/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.phpunit.ui.options;

import java.awt.EventQueue;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import org.netbeans.modules.php.api.validation.ValidationResult;
import org.netbeans.modules.php.phpunit.commands.SkeletonGenerator;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptions;
import org.netbeans.modules.php.phpunit.options.PhpUnitOptionsValidator;
import org.netbeans.modules.php.phpunit.ui.options.PhpUnitOptionsPanel;
import org.netbeans.spi.options.OptionsPanelController;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class PhpUnitOptionsPanelController
extends OptionsPanelController
implements ChangeListener {
    static final String ID = "PhpUnit";
    public static final String OPTIONS_SUB_PATH = "FrameworksAndTools/PhpUnit";
    public static final String OPTIONS_PATH = "org-netbeans-modules-php-project-ui-options-PHPOptionsCategory/FrameworksAndTools/PhpUnit";
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private PhpUnitOptionsPanel phpUnitOptionsPanel = null;
    private volatile boolean changed = false;
    private boolean firstOpening = true;

    public void update() {
        assert (EventQueue.isDispatchThread());
        if (this.firstOpening || !this.isChanged()) {
            this.firstOpening = false;
            this.getPhpUnitOptionsPanel().setPhpUnit(this.getPhpUnitOptions().getPhpUnitPath());
            this.getPhpUnitOptionsPanel().setPhpUnitSkelGen(this.getPhpUnitOptions().getSkeletonGeneratorPath());
        }
        this.changed = false;
    }

    public void applyChanges() {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SkeletonGenerator.resetVersion();
                PhpUnitOptionsPanelController.this.getPhpUnitOptions().setPhpUnitPath(PhpUnitOptionsPanelController.this.getPhpUnitOptionsPanel().getPhpUnit());
                PhpUnitOptionsPanelController.this.getPhpUnitOptions().setSkeletonGeneratorPath(PhpUnitOptionsPanelController.this.getPhpUnitOptionsPanel().getPhpUnitSkelGen());
                PhpUnitOptionsPanelController.this.changed = false;
            }
        });
    }

    public void cancel() {
        if (this.isChanged()) {
            this.getPhpUnitOptionsPanel().setPhpUnit(this.getPhpUnitOptions().getPhpUnitPath());
            this.getPhpUnitOptionsPanel().setPhpUnitSkelGen(this.getPhpUnitOptions().getSkeletonGeneratorPath());
        }
    }

    public boolean isValid() {
        assert (EventQueue.isDispatchThread());
        PhpUnitOptionsPanel panel = this.getPhpUnitOptionsPanel();
        ValidationResult result = new PhpUnitOptionsValidator().validate(panel.getPhpUnit(), panel.getPhpUnitSkelGen()).getResult();
        if (result.hasErrors()) {
            panel.setError(((ValidationResult.Message)result.getErrors().get(0)).getMessage());
            return false;
        }
        if (result.hasWarnings()) {
            panel.setWarning(((ValidationResult.Message)result.getWarnings().get(0)).getMessage());
            return true;
        }
        panel.setError(" ");
        return true;
    }

    public boolean isChanged() {
        String saved = this.getPhpUnitOptions().getPhpUnitPath();
        String current = this.getPhpUnitOptionsPanel().getPhpUnit().trim();
        if (saved == null ? !current.isEmpty() : !saved.equals(current)) {
            return true;
        }
        saved = this.getPhpUnitOptions().getSkeletonGeneratorPath();
        current = this.getPhpUnitOptionsPanel().getPhpUnitSkelGen().trim();
        return saved == null ? !current.isEmpty() : !saved.equals(current);
    }

    public JComponent getComponent(Lookup masterLookup) {
        assert (EventQueue.isDispatchThread());
        return this.getPhpUnitOptionsPanel();
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx("org.netbeans.modules.php.project.phpunit.PhpUnit");
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.propertyChangeSupport.removePropertyChangeListener(l);
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (!this.changed) {
            this.changed = true;
            this.propertyChangeSupport.firePropertyChange("changed", false, true);
        }
        this.propertyChangeSupport.firePropertyChange("valid", null, null);
    }

    private PhpUnitOptionsPanel getPhpUnitOptionsPanel() {
        assert (EventQueue.isDispatchThread());
        if (this.phpUnitOptionsPanel == null) {
            this.phpUnitOptionsPanel = new PhpUnitOptionsPanel();
            this.phpUnitOptionsPanel.addChangeListener(this);
        }
        return this.phpUnitOptionsPanel;
    }

    private PhpUnitOptions getPhpUnitOptions() {
        return PhpUnitOptions.getInstance();
    }
}

