/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.qnavigator.navigator;

import javax.swing.JComponent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorContent;
import org.netbeans.modules.cnd.qnavigator.navigator.NavigatorPanelUI;
import org.netbeans.modules.cnd.utils.MIMENames;
import org.netbeans.spi.navigator.NavigatorPanel;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.NbBundle;

public final class NavigatorComponent
implements NavigatorPanel,
LookupListener {
    private Lookup.Result<DataObject> doContext;
    private NavigatorPanelUI panelUI;
    private boolean activated = false;
    private static NavigatorComponent INSTANCE = new NavigatorComponent();
    private DataObject curData;
    private final Lock lock = new Lock();
    private final Lock uiLock = new Lock();
    private static final NavigatorContent content = new NavigatorContent();

    private NavigatorComponent() {
    }

    public String getDisplayName() {
        return NbBundle.getMessage(NavigatorComponent.class, (String)"LBL_members");
    }

    public String getDisplayHint() {
        return NbBundle.getMessage(NavigatorComponent.class, (String)"HINT_NavigatorTopComponen");
    }

    public JComponent getComponent() {
        return this.getPanelUI();
    }

    private String getMime(DataObject dobj) {
        FileObject fo = dobj == null ? null : dobj.getPrimaryFile();
        String mime = fo == null ? "" : fo.getMIMEType();
        return mime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelActivated(Lookup context) {
        Lock lock = this.lock;
        synchronized (lock) {
            this.activated = true;
            this.doContext = context.lookupResult(DataObject.class);
            this.doContext.addLookupListener((LookupListener)this);
            this.resultChanged(null);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void panelDeactivated() {
        Lock lock = this.lock;
        synchronized (lock) {
            this.activated = false;
            this.doContext.removeLookupListener((LookupListener)this);
            this.doContext = null;
            this.curData = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resultChanged(LookupEvent ev) {
        Lock lock = this.lock;
        synchronized (lock) {
            for (DataObject dob : this.doContext.allInstances()) {
                if (!MIMENames.isFortranOrHeaderOrCppOrC((String)this.getMime(dob))) continue;
                if (dob.equals(this.curData)) break;
                this.curData = dob;
                this.setNewContent(dob);
                break;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean isNavigatorEnabled() {
        Lock lock = this.uiLock;
        synchronized (lock) {
            return this.activated && this.panelUI != null;
        }
    }

    public static NavigatorComponent getInstance() {
        return INSTANCE;
    }

    public Lookup getLookup() {
        return this.getPanelUI().getLookup();
    }

    private void setNewContent(DataObject cdo) {
        NavigatorPanelUI ui = this.getPanelUI();
        DataObject old = ui.getDataObject();
        if (old == null || !old.equals(cdo)) {
            ui.showWaitNode();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    NavigatorPanelUI getPanelUI() {
        Lock lock = this.uiLock;
        synchronized (lock) {
            if (this.panelUI == null) {
                this.panelUI = new NavigatorPanelUI(NavigatorComponent.getContent());
            }
            return this.panelUI;
        }
    }

    static NavigatorContent getContent() {
        return content;
    }

    private static final class Lock {
        private Lock() {
        }
    }
}

