/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.remote;

import java.beans.PropertyChangeListener;
import java.io.File;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.netbeans.api.project.Project;
import org.netbeans.modules.cnd.api.remote.ServerRecord;
import org.netbeans.modules.cnd.spi.remote.RemoteSyncFactory;
import org.netbeans.modules.cnd.spi.remote.ServerListImplementation;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironmentFactory;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;

public class ServerList {
    public static final String PROP_DEFAULT_RECORD = "DEFAULT_RECORD";
    public static final String PROP_RECORD_LIST = "RECORD_LIST";
    private static ServerListImplementation DEFAULT;

    private ServerList() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static ServerListImplementation getDefault() {
        Class<ServerList> clazz = ServerList.class;
        synchronized (ServerList.class) {
            ServerListImplementation result = DEFAULT;
            if (result == null) {
                result = (ServerListImplementation)Lookup.getDefault().lookup(ServerListImplementation.class);
                if (result == null) {
                    result = new DummyServerListImplementation();
                } else {
                    DEFAULT = result;
                }
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return result;
        }
    }

    public static Collection<? extends ServerRecord> getRecords() {
        return ServerList.getDefault().getRecords();
    }

    public static void setDefaultRecord(ServerRecord defaultRecord) {
        ServerList.getDefault().setDefaultRecord(defaultRecord);
    }

    public static List<ExecutionEnvironment> getEnvironments() {
        return ServerList.getDefault().getEnvironments();
    }

    public static ServerRecord get(ExecutionEnvironment env) {
        return ServerList.getDefault().get(env);
    }

    static ServerRecord get(Project project) {
        return ServerList.getDefault().get(project);
    }

    public static ServerRecord getDefaultRecord() {
        return ServerList.getDefault().getDefaultRecord();
    }

    public static void set(List<ServerRecord> records, ServerRecord defaultRecord) {
        ServerList.getDefault().set(records, defaultRecord);
    }

    public static void save() {
        ServerList.getDefault().save();
    }

    public static ServerRecord addServer(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect) {
        return ServerList.getDefault().addServer(env, displayName, syncFactory, asDefault, connect);
    }

    public static ServerRecord createServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory) {
        return ServerList.getDefault().createServerRecord(env, displayName, syncFactory);
    }

    public static boolean isValidExecutable(ExecutionEnvironment env, String path) {
        return ServerList.getDefault().isValidExecutable(env, path);
    }

    public static void addPropertyChangeListener(PropertyChangeListener listener) {
        ServerList.getDefault().addPropertyChangeListener(listener);
    }

    public static void removePropertyChangeListener(PropertyChangeListener listener) {
        ServerList.getDefault().removePropertyChangeListener(listener);
    }

    private static class DummyServerListImplementation
    implements ServerListImplementation {
        private ServerRecord record = new DummyServerRecord();

        private DummyServerListImplementation() {
        }

        @Override
        public ServerRecord addServer(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory, boolean asDefault, boolean connect) {
            return this.record;
        }

        @Override
        public ServerRecord get(ExecutionEnvironment env) {
            return this.record;
        }

        @Override
        public ServerRecord get(Project project) {
            return this.record;
        }

        @Override
        public ServerRecord getDefaultRecord() {
            return this.record;
        }

        @Override
        public List<ExecutionEnvironment> getEnvironments() {
            return Arrays.asList(this.record.getExecutionEnvironment());
        }

        @Override
        public Collection<? extends ServerRecord> getRecords() {
            return Arrays.asList(this.record);
        }

        @Override
        public boolean isValidExecutable(ExecutionEnvironment env, String path) {
            return new File(path).exists();
        }

        @Override
        public void set(List<ServerRecord> records, ServerRecord defaultRecord) {
        }

        @Override
        public void setDefaultRecord(ServerRecord record) {
        }

        @Override
        public ServerRecord createServerRecord(ExecutionEnvironment env, String displayName, RemoteSyncFactory syncFactory) {
            return new DummyServerRecord();
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void save() {
        }
    }

    private static class DummyServerRecord
    implements ServerRecord {
        private DummyServerRecord() {
        }

        @Override
        public String getDisplayName() {
            return NbBundle.getMessage(ServerList.class, (String)"DUMMY_HOST_NAME");
        }

        @Override
        public ExecutionEnvironment getExecutionEnvironment() {
            return ExecutionEnvironmentFactory.getLocal();
        }

        @Override
        public String getServerDisplayName() {
            return this.getDisplayName();
        }

        @Override
        public String getServerName() {
            return this.getDisplayName();
        }

        @Override
        public RemoteSyncFactory getSyncFactory() {
            return RemoteSyncFactory.getDefault();
        }

        @Override
        public String getUserName() {
            return "";
        }

        @Override
        public boolean isDeleted() {
            return true;
        }

        @Override
        public boolean isOffline() {
            return false;
        }

        @Override
        public boolean isOnline() {
            return true;
        }

        @Override
        public boolean isRemote() {
            return false;
        }

        @Override
        public boolean isSetUp() {
            return true;
        }

        @Override
        public boolean setUp() {
            return true;
        }

        @Override
        public void validate(boolean force) {
        }

        @Override
        public void checkSetupAfterConnection(Runnable task) {
        }

        @Override
        public boolean getX11Forwarding() {
            return false;
        }

        @Override
        public boolean isRememberPassword() {
            return false;
        }

        @Override
        public void addPropertyChangeListener(PropertyChangeListener listener) {
        }

        @Override
        public void removePropertyChangeListener(PropertyChangeListener listener) {
        }
    }
}

