/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import javax.swing.JLabel;
import javax.swing.JTextField;
import org.netbeans.modules.cnd.debugger.common2.debugger.EditorBridge;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.BreakpointPanel;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.NativeBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.Catalog;
import org.netbeans.modules.cnd.debugger.common2.debugger.breakpoints.types.VariableBreakpoint;
import org.netbeans.modules.cnd.debugger.common2.utils.IpeUtils;

class VariableBreakpointPanel
extends BreakpointPanel {
    private VariableBreakpoint fb;
    private JLabel variableLabel;
    private JTextField variableText;

    @Override
    protected final void seed(NativeBreakpoint breakpoint) {
        this.seedCommonComponents(breakpoint);
        this.fb = (VariableBreakpoint)breakpoint;
        this.variableText.setText(this.fb.getVariable());
    }

    public VariableBreakpointPanel() {
        this(new VariableBreakpoint(2), false);
    }

    public VariableBreakpointPanel(NativeBreakpoint b) {
        this((VariableBreakpoint)b, true);
    }

    public VariableBreakpointPanel(VariableBreakpoint breakpoint, boolean customizing) {
        super(breakpoint, customizing);
        String selection;
        this.fb = breakpoint;
        this.initComponents();
        this.addCommonComponents(1);
        if (!customizing && (selection = EditorBridge.getCurrentSelection()) != null) {
            breakpoint.setVariable(selection);
        }
        this.seed(breakpoint);
        this.variableText.getDocument().addDocumentListener(this);
    }

    @Override
    public void setDescriptionEnabled(boolean enabled) {
        this.variableText.setEnabled(false);
    }

    private void initComponents() {
        this.variableLabel = new JLabel();
        this.variableText = new JTextField();
        this.panel_settings.setLayout(new GridBagLayout());
        this.variableLabel.setText(Catalog.get("Variable"));
        this.variableLabel.setDisplayedMnemonic(Catalog.getMnemonic("MNEM_Variable"));
        this.variableLabel.setLabelFor(this.variableText);
        GridBagConstraints gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.ipadx = 5;
        gridBagConstraints1.anchor = 17;
        this.panel_settings.add((Component)this.variableLabel, gridBagConstraints1);
        gridBagConstraints1 = new GridBagConstraints();
        gridBagConstraints1.gridwidth = 3;
        gridBagConstraints1.fill = 2;
        gridBagConstraints1.weightx = 1.0;
        this.panel_settings.add((Component)this.variableText, gridBagConstraints1);
        this.variableText.getAccessibleContext().setAccessibleDescription(Catalog.get("ACSD_Variable"));
    }

    @Override
    protected void assignProperties() {
        this.fb.setVariable(this.variableText.getText());
    }

    @Override
    protected boolean propertiesAreValid() {
        return !IpeUtils.isEmpty(this.variableText.getText());
    }
}

