/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli;

import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitBranch;
import org.netbeans.modules.git.remote.cli.GitRefUpdateResult;

public final class GitTransportUpdate {
    private final String localName;
    private final String remoteName;
    private final String oldObjectId;
    private final String newObjectId;
    private final String operation;
    private final GitRefUpdateResult result;
    private final String uri;
    private final Type type;

    GitTransportUpdate(Map<String, GitBranch> remoteBranches) {
        this.localName = null;
        this.remoteName = null;
        this.oldObjectId = this.getOldRevisionId(remoteBranches.get(this.remoteName));
        this.newObjectId = null;
        this.result = null;
        this.uri = null;
        this.type = null;
        this.operation = null;
    }

    GitTransportUpdate(GitTransportUpdateContainer container) {
        this.localName = container.localBranch;
        this.remoteName = container.remoteBranch;
        this.oldObjectId = container.oldID;
        this.newObjectId = container.newID;
        this.result = container.status;
        this.uri = container.url;
        this.type = container.type;
        this.operation = container.operation;
    }

    public String getRemoteUri() {
        return this.uri;
    }

    public String getLocalName() {
        return this.localName;
    }

    public String getRemoteName() {
        return this.remoteName;
    }

    public String getOldObjectId() {
        return this.oldObjectId;
    }

    public String getNewObjectId() {
        return this.newObjectId;
    }

    public String getOperation() {
        return this.operation;
    }

    public GitRefUpdateResult getResult() {
        return this.result;
    }

    public Type getType() {
        return this.type;
    }

    public static Type getType(String refName) {
        Type retval;
        if (refName.startsWith("refs/tags/")) {
            retval = Type.TAG;
        } else if (refName.startsWith("refs/remotes/")) {
            retval = Type.BRANCH;
        } else if (refName.startsWith("refs/heads/")) {
            retval = Type.BRANCH;
        } else if (refName.startsWith("refs/")) {
            retval = Type.REFERENCE;
        } else {
            throw new IllegalArgumentException("Unknown type for: " + refName);
        }
        return retval;
    }

    private String getOldRevisionId(GitBranch branch) {
        return branch == null ? null : branch.getId();
    }

    public static class GitTransportUpdateContainer {
        public boolean def;
        public String newBranch;
        public String localBranch;
        public String remoteBranch;
        public String url;
        public Type type;
        public GitRefUpdateResult status;
        public String oldID;
        public String newID;
        public String operation;
    }

    public static enum Type {
        BRANCH,
        TAG,
        REFERENCE;

    }
}

