/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import org.netbeans.modules.git.remote.cli.GitClient;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.progress.FileListener;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class ResetCommand
extends GitCommand {
    private final VCSFileProxy[] roots;
    private final FileListener listener;
    private final ProgressMonitor monitor;
    private final String revisionStr;
    private final GitClient.ResetType resetType;
    private final boolean moveHead;
    private final boolean recursively;

    public ResetCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, VCSFileProxy[] roots, boolean recursively, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = roots;
        this.listener = listener;
        this.monitor = monitor;
        this.revisionStr = revision;
        this.resetType = GitClient.ResetType.MIXED;
        this.recursively = recursively;
        this.moveHead = false;
    }

    public ResetCommand(JGitRepository repository, GitClassFactory gitFactory, String revision, GitClient.ResetType resetType, ProgressMonitor monitor, FileListener listener) {
        super(repository, gitFactory, monitor);
        this.roots = new VCSFileProxy[0];
        this.listener = listener;
        this.monitor = monitor;
        this.revisionStr = revision;
        this.resetType = resetType;
        this.recursively = true;
        this.moveHead = true;
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "reset");
        if (this.moveHead) {
            this.addArgument(0, this.resetType.toString());
            this.addArgument(0, this.revisionStr);
        } else {
            this.addArgument(0, this.revisionStr);
            this.addArgument(0, "--");
            this.addFiles(0, this.roots);
        }
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }

                    @Override
                    protected void outputErrorParser(String output, String error, int exitCode) throws GitException {
                    }

                    @Override
                    protected void errorParser(String error) throws GitException {
                        if (error.isEmpty()) {
                            return;
                        }
                        super.errorParser(error);
                    }
                }.runCLI();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

