/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.git.remote.cli.jgit.commands;

import java.util.Map;
import org.netbeans.modules.git.remote.cli.GitException;
import org.netbeans.modules.git.remote.cli.GitSubmoduleStatus;
import org.netbeans.modules.git.remote.cli.jgit.DelegatingGitProgressMonitor;
import org.netbeans.modules.git.remote.cli.jgit.GitClassFactory;
import org.netbeans.modules.git.remote.cli.jgit.JGitRepository;
import org.netbeans.modules.git.remote.cli.jgit.commands.GitCommand;
import org.netbeans.modules.git.remote.cli.jgit.commands.SubmoduleStatusCommand;
import org.netbeans.modules.git.remote.cli.progress.ProgressMonitor;
import org.netbeans.modules.remotefs.versioning.api.ProcessUtils;
import org.netbeans.modules.versioning.core.api.VCSFileProxy;
import org.openide.util.Cancellable;

public class SubmoduleInitializeCommand
extends GitCommand {
    private final VCSFileProxy[] roots;
    private final SubmoduleStatusCommand statusCmd;
    private final ProgressMonitor monitor;

    public SubmoduleInitializeCommand(JGitRepository repository, GitClassFactory classFactory, VCSFileProxy[] roots, ProgressMonitor monitor) {
        super(repository, classFactory, monitor);
        this.roots = roots;
        this.monitor = monitor;
        this.statusCmd = new SubmoduleStatusCommand(repository, this.getClassFactory(), roots, new DelegatingGitProgressMonitor(monitor));
    }

    public Map<VCSFileProxy, GitSubmoduleStatus> getStatuses() {
        return this.statusCmd.getStatuses();
    }

    @Override
    protected void prepare() throws GitException {
        super.prepare();
        this.addArgument(0, "submodule");
        this.addArgument(0, "initialize");
        this.addFiles(0, this.roots);
    }

    @Override
    protected void run() throws GitException {
        block4: {
            ProcessUtils.Canceler canceled = new ProcessUtils.Canceler();
            if (this.monitor != null) {
                this.monitor.setCancelDelegate((Cancellable)canceled);
            }
            try {
                new GitCommand.Runner(canceled, 0){

                    @Override
                    public void outputParser(String output) throws GitException {
                    }
                }.runCLI();
                this.statusCmd.execute();
            }
            catch (GitException t) {
                throw t;
            }
            catch (Throwable t) {
                if (canceled.canceled()) break block4;
                throw new GitException(t);
            }
        }
    }
}

