/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.messaging.saaj.client.p2p;

import com.sun.xml.messaging.saaj.SOAPExceptionImpl;
import com.sun.xml.messaging.saaj.util.Base64;
import com.sun.xml.messaging.saaj.util.ByteInputStream;
import com.sun.xml.messaging.saaj.util.JaxmURI;
import com.sun.xml.messaging.saaj.util.ParseUtil;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.security.AccessController;
import java.security.PrivilegedExceptionAction;
import java.security.Provider;
import java.security.Security;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.MimeHeader;
import javax.xml.soap.MimeHeaders;
import javax.xml.soap.SOAPConnection;
import javax.xml.soap.SOAPException;
import javax.xml.soap.SOAPMessage;

public class HttpSOAPConnection
extends SOAPConnection {
    public static final String vmVendor = System.getProperty("java.vendor.url");
    private static final String sunVmVendor = "http://java.sun.com/";
    private static final String ibmVmVendor = "http://www.ibm.com/";
    private static final boolean isSunVM = "http://java.sun.com/".equals(vmVendor);
    private static final boolean isIBMVM = "http://www.ibm.com/".equals(vmVendor);
    private static final String JAXM_URLENDPOINT = "javax.xml.messaging.URLEndpoint";
    protected static final Logger log = Logger.getLogger("javax.xml.messaging.saaj.client.p2p", "com.sun.xml.messaging.saaj.client.p2p.LocalStrings");
    private static final String defaultProxyHost = null;
    private static final int defaultProxyPort = -1;
    MessageFactory messageFactory = null;
    boolean closed = false;
    private String proxyHost = defaultProxyHost;
    private int proxyPort = -1;
    private static final String SSL_PKG;
    private static final String SSL_PROVIDER;
    private static final int dL = 0;

    public HttpSOAPConnection() throws SOAPException {
        try {
            this.messageFactory = MessageFactory.newInstance((String)"Dynamic Protocol");
        }
        catch (NoSuchMethodError ex) {
            this.messageFactory = MessageFactory.newInstance();
        }
        catch (Exception ex) {
            log.log(Level.SEVERE, "SAAJ0001.p2p.cannot.create.msg.factory", ex);
            throw new SOAPExceptionImpl("Unable to create message factory", ex);
        }
    }

    public void close() throws SOAPException {
        if (this.closed) {
            log.severe("SAAJ0002.p2p.close.already.closed.conn");
            throw new SOAPExceptionImpl("Connection already closed");
        }
        this.messageFactory = null;
        this.closed = true;
    }

    public SOAPMessage call(SOAPMessage message, Object endPoint) throws SOAPException {
        if (this.closed) {
            log.severe("SAAJ0003.p2p.call.already.closed.conn");
            throw new SOAPExceptionImpl("Connection is closed");
        }
        Class<?> urlEndpointClass = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        try {
            urlEndpointClass = loader != null ? loader.loadClass(JAXM_URLENDPOINT) : Class.forName(JAXM_URLENDPOINT);
        }
        catch (ClassNotFoundException ex) {
            log.finest("SAAJ0090.p2p.endpoint.available.only.for.JAXM");
        }
        if (urlEndpointClass != null && urlEndpointClass.isInstance(endPoint)) {
            String url = null;
            try {
                Method m = urlEndpointClass.getMethod("getURL", null);
                url = (String)m.invoke(endPoint, (Object[])null);
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "SAAJ0004.p2p.internal.err", ex);
                throw new SOAPExceptionImpl("Internal error: " + ex.getMessage());
            }
            try {
                endPoint = new URL(url);
            }
            catch (MalformedURLException mex) {
                log.log(Level.SEVERE, "SAAJ0005.p2p.", mex);
                throw new SOAPExceptionImpl("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof String) {
            try {
                endPoint = new URL((String)endPoint);
            }
            catch (MalformedURLException mex) {
                log.log(Level.SEVERE, "SAAJ0006.p2p.bad.URL", mex);
                throw new SOAPExceptionImpl("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof URL) {
            try {
                PriviledgedPost pp = new PriviledgedPost(this, message, (URL)endPoint);
                SOAPMessage response = (SOAPMessage)AccessController.doPrivileged(pp);
                return response;
            }
            catch (Exception ex) {
                throw new SOAPExceptionImpl(ex);
            }
        }
        log.severe("SAAJ0007.p2p.bad.endPoint.type");
        throw new SOAPExceptionImpl("Bad endPoint type " + endPoint);
    }

    public void setProxy(String host, int port) {
        try {
            this.proxyPort = port;
            PriviledgedSetProxyAction ps = new PriviledgedSetProxyAction(host, port);
            this.proxyHost = (String)AccessController.doPrivileged(ps);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public String getProxyHost() {
        return this.proxyHost;
    }

    public int getProxyPort() {
        return this.proxyPort;
    }

    SOAPMessage post(SOAPMessage message, URL endPoint) throws SOAPException {
        int responseCode;
        HttpURLConnection httpConnection;
        boolean isFailure;
        block27: {
            isFailure = false;
            URL url = null;
            httpConnection = null;
            responseCode = 0;
            try {
                if (endPoint.getProtocol().equals("https")) {
                    this.initHttps();
                }
                JaxmURI uri = new JaxmURI(endPoint.toString());
                String userInfo = uri.getUserinfo();
                url = endPoint;
                if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
                }
                httpConnection = this.createConnection(url);
                httpConnection.setRequestMethod("POST");
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                httpConnection.setUseCaches(false);
                HttpURLConnection.setFollowRedirects(true);
                if (message.saveRequired()) {
                    message.saveChanges();
                }
                MimeHeaders headers = message.getMimeHeaders();
                Iterator it = headers.getAllHeaders();
                boolean hasAuth = false;
                while (it.hasNext()) {
                    MimeHeader header = (MimeHeader)it.next();
                    String[] values = headers.getHeader(header.getName());
                    if (values.length == 1) {
                        httpConnection.setRequestProperty(header.getName(), header.getValue());
                    } else {
                        StringBuffer concat = new StringBuffer();
                        for (int i = 0; i < values.length; ++i) {
                            if (i != 0) {
                                concat.append(',');
                            }
                            concat.append(values[i]);
                        }
                        httpConnection.setRequestProperty(header.getName(), concat.toString());
                    }
                    if (!"Authorization".equals(header.getName())) continue;
                    hasAuth = true;
                    log.fine("SAAJ0091.p2p.https.auth.in.POST.true");
                }
                if (!hasAuth && userInfo != null) {
                    this.initAuthUserInfo(httpConnection, userInfo);
                }
                OutputStream out = httpConnection.getOutputStream();
                message.writeTo(out);
                out.flush();
                out.close();
                httpConnection.connect();
                try {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                    } else if (responseCode / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + responseCode + httpConnection.getResponseMessage());
                    }
                }
                catch (IOException e) {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                        break block27;
                    }
                    throw e;
                }
            }
            catch (SOAPException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.severe("SAAJ0009.p2p.msg.send.failed");
                throw new SOAPExceptionImpl("Message send failed", ex);
            }
        }
        SOAPMessage response = null;
        if (responseCode == 200 || isFailure) {
            try {
                int length;
                MimeHeaders headers = new MimeHeaders();
                int i = 1;
                while (true) {
                    String key = httpConnection.getHeaderFieldKey(i);
                    String value = httpConnection.getHeaderField(i);
                    if (key == null && value == null) break;
                    if (key != null) {
                        StringTokenizer values = new StringTokenizer(value, ",");
                        while (values.hasMoreTokens()) {
                            headers.addHeader(key, values.nextToken().trim());
                        }
                    }
                    ++i;
                }
                InputStream httpIn = isFailure ? httpConnection.getErrorStream() : httpConnection.getInputStream();
                byte[] bytes = this.readFully(httpIn);
                int n = length = httpConnection.getContentLength() == -1 ? bytes.length : httpConnection.getContentLength();
                if (length == 0) {
                    response = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    ByteInputStream in = new ByteInputStream(bytes, length);
                    response = this.messageFactory.createMessage(headers, (InputStream)in);
                }
                httpIn.close();
                httpConnection.disconnect();
            }
            catch (SOAPException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", ex);
                throw new SOAPExceptionImpl("Unable to read response: " + ex.getMessage());
            }
        }
        return response;
    }

    public SOAPMessage get(Object endPoint) throws SOAPException {
        if (this.closed) {
            log.severe("SAAJ0011.p2p.get.already.closed.conn");
            throw new SOAPExceptionImpl("Connection is closed");
        }
        Class<?> urlEndpointClass = null;
        try {
            urlEndpointClass = Class.forName(JAXM_URLENDPOINT);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (urlEndpointClass != null && urlEndpointClass.isInstance(endPoint)) {
            String url = null;
            try {
                Method m = urlEndpointClass.getMethod("getURL", null);
                url = (String)m.invoke(endPoint, (Object[])null);
            }
            catch (Exception ex) {
                log.severe("SAAJ0004.p2p.internal.err");
                throw new SOAPExceptionImpl("Internal error: " + ex.getMessage());
            }
            try {
                endPoint = new URL(url);
            }
            catch (MalformedURLException mex) {
                log.severe("SAAJ0005.p2p.");
                throw new SOAPExceptionImpl("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof String) {
            try {
                endPoint = new URL((String)endPoint);
            }
            catch (MalformedURLException mex) {
                log.severe("SAAJ0006.p2p.bad.URL");
                throw new SOAPExceptionImpl("Bad URL: " + mex.getMessage());
            }
        }
        if (endPoint instanceof URL) {
            try {
                PriviledgedGet pg = new PriviledgedGet(this, (URL)endPoint);
                SOAPMessage response = (SOAPMessage)AccessController.doPrivileged(pg);
                return response;
            }
            catch (Exception ex) {
                throw new SOAPExceptionImpl(ex);
            }
        }
        throw new SOAPExceptionImpl("Bad endPoint type " + endPoint);
    }

    SOAPMessage get(URL endPoint) throws SOAPException {
        int responseCode;
        HttpURLConnection httpConnection;
        boolean isFailure;
        block20: {
            isFailure = false;
            URL url = null;
            httpConnection = null;
            responseCode = 0;
            try {
                if (endPoint.getProtocol().equals("https")) {
                    this.initHttps();
                }
                JaxmURI uri = new JaxmURI(endPoint.toString());
                String userInfo = uri.getUserinfo();
                url = endPoint;
                if (!url.getProtocol().equalsIgnoreCase("http") && !url.getProtocol().equalsIgnoreCase("https")) {
                    log.severe("SAAJ0052.p2p.protocol.mustbe.http.or.https");
                    throw new IllegalArgumentException("Protocol " + url.getProtocol() + " not supported in URL " + url);
                }
                httpConnection = this.createConnection(url);
                httpConnection.setRequestMethod("GET");
                httpConnection.setDoOutput(true);
                httpConnection.setDoInput(true);
                httpConnection.setUseCaches(false);
                HttpURLConnection.setFollowRedirects(true);
                httpConnection.connect();
                try {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                    } else if (responseCode / 100 != 2) {
                        log.log(Level.SEVERE, "SAAJ0008.p2p.bad.response", new String[]{httpConnection.getResponseMessage()});
                        throw new SOAPExceptionImpl("Bad response: (" + responseCode + httpConnection.getResponseMessage());
                    }
                }
                catch (IOException e) {
                    responseCode = httpConnection.getResponseCode();
                    if (responseCode == 500) {
                        isFailure = true;
                        break block20;
                    }
                    throw e;
                }
            }
            catch (SOAPException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.severe("SAAJ0012.p2p.get.failed");
                throw new SOAPExceptionImpl("Get failed", ex);
            }
        }
        SOAPMessage response = null;
        if (responseCode == 200 || isFailure) {
            try {
                InputStream httpIn;
                MimeHeaders headers = new MimeHeaders();
                int i = 1;
                while (true) {
                    String key = httpConnection.getHeaderFieldKey(i);
                    String value = httpConnection.getHeaderField(i);
                    if (key == null && value == null) break;
                    if (key != null) {
                        StringTokenizer values = new StringTokenizer(value, ",");
                        while (values.hasMoreTokens()) {
                            headers.addHeader(key, values.nextToken().trim());
                        }
                    }
                    ++i;
                }
                InputStream inputStream = httpIn = isFailure ? httpConnection.getErrorStream() : httpConnection.getInputStream();
                if (httpIn == null || httpConnection.getContentLength() == 0 || httpIn.available() == 0) {
                    response = null;
                    log.warning("SAAJ0014.p2p.content.zero");
                } else {
                    response = this.messageFactory.createMessage(headers, httpIn);
                }
                httpIn.close();
                httpConnection.disconnect();
            }
            catch (SOAPException ex) {
                throw ex;
            }
            catch (Exception ex) {
                log.log(Level.SEVERE, "SAAJ0010.p2p.cannot.read.resp", ex);
                throw new SOAPExceptionImpl("Unable to read response: " + ex.getMessage());
            }
        }
        return response;
    }

    private byte[] readFully(InputStream istream) throws IOException {
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int num = 0;
        while ((num = istream.read(buf)) != -1) {
            bout.write(buf, 0, num);
        }
        byte[] ret = bout.toByteArray();
        return ret;
    }

    private void initHttps() {
        String pkgs = System.getProperty("java.protocol.handler.pkgs");
        log.log(Level.FINE, "SAAJ0053.p2p.providers", new String[]{pkgs});
        if (pkgs == null || pkgs.indexOf(SSL_PKG) < 0) {
            pkgs = pkgs == null ? SSL_PKG : pkgs + "|" + SSL_PKG;
            System.setProperty("java.protocol.handler.pkgs", pkgs);
            log.log(Level.FINE, "SAAJ0054.p2p.set.providers", new String[]{pkgs});
            try {
                Class<?> c = Class.forName(SSL_PROVIDER);
                Provider p = (Provider)c.newInstance();
                Security.addProvider(p);
                log.log(Level.FINE, "SAAJ0055.p2p.added.ssl.provider", new String[]{SSL_PROVIDER});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void initAuthUserInfo(HttpURLConnection conn, String userInfo) {
        if (userInfo != null) {
            String password;
            String user;
            int delimiter = userInfo.indexOf(58);
            if (delimiter == -1) {
                user = ParseUtil.decode(userInfo);
                password = null;
            } else {
                user = ParseUtil.decode(userInfo.substring(0, delimiter++));
                password = ParseUtil.decode(userInfo.substring(delimiter));
            }
            String plain = user + ":";
            byte[] nameBytes = plain.getBytes();
            byte[] passwdBytes = password.getBytes();
            byte[] concat = new byte[nameBytes.length + passwdBytes.length];
            System.arraycopy(nameBytes, 0, concat, 0, nameBytes.length);
            System.arraycopy(passwdBytes, 0, concat, nameBytes.length, passwdBytes.length);
            String auth = "Basic " + new String(Base64.encode(concat));
            conn.setRequestProperty("Authorization", auth);
        }
    }

    private void d(String s) {
        log.log(Level.SEVERE, "SAAJ0013.p2p.HttpSOAPConnection", new String[]{s});
        System.err.println("HttpSOAPConnection: " + s);
    }

    private HttpURLConnection createConnection(URL endpoint) throws IOException {
        return (HttpURLConnection)endpoint.openConnection();
    }

    static {
        if (isIBMVM) {
            SSL_PKG = "com.ibm.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.ibm.net.ssl.internal.ssl.Provider";
        } else {
            SSL_PKG = "com.sun.net.ssl.internal.www.protocol";
            SSL_PROVIDER = "com.sun.net.ssl.internal.ssl.Provider";
        }
    }

    static class PriviledgedGet
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        URL endPoint;

        PriviledgedGet(HttpSOAPConnection c, URL endPoint) {
            this.c = c;
            this.endPoint = endPoint;
        }

        public Object run() throws Exception {
            return this.c.get(this.endPoint);
        }
    }

    static class PriviledgedSetProxyAction
    implements PrivilegedExceptionAction {
        String proxyHost = null;
        int proxyPort = 0;

        PriviledgedSetProxyAction(String host, int port) {
            this.proxyHost = host;
            this.proxyPort = port;
        }

        public Object run() throws Exception {
            System.setProperty("http.proxyHost", this.proxyHost);
            System.setProperty("http.proxyPort", new Integer(this.proxyPort).toString());
            log.log(Level.FINE, "SAAJ0050.p2p.proxy.host", new String[]{this.proxyHost});
            log.log(Level.FINE, "SAAJ0051.p2p.proxy.port", new String[]{new Integer(this.proxyPort).toString()});
            return this.proxyHost;
        }
    }

    static class PriviledgedPost
    implements PrivilegedExceptionAction {
        HttpSOAPConnection c;
        SOAPMessage message;
        URL endPoint;

        PriviledgedPost(HttpSOAPConnection c, SOAPMessage message, URL endPoint) {
            this.c = c;
            this.message = message;
            this.endPoint = endPoint;
        }

        public Object run() throws Exception {
            return this.c.post(this.message, this.endPoint);
        }
    }
}

