/*
 * Decompiled with CFR 0.152.
 */
package com.sun.xml.rpc.processor.generator;

import com.sun.xml.rpc.processor.generator.GeneratorConstants;
import com.sun.xml.rpc.processor.generator.GeneratorException;
import com.sun.xml.rpc.processor.model.AbstractType;
import com.sun.xml.rpc.processor.model.Block;
import com.sun.xml.rpc.processor.model.Fault;
import com.sun.xml.rpc.processor.model.Operation;
import com.sun.xml.rpc.processor.model.Service;
import com.sun.xml.rpc.processor.model.java.JavaArrayType;
import com.sun.xml.rpc.processor.model.java.JavaInterface;
import com.sun.xml.rpc.processor.model.java.JavaStructureMember;
import com.sun.xml.rpc.processor.model.java.JavaType;
import com.sun.xml.rpc.processor.model.literal.LiteralFragmentType;
import com.sun.xml.rpc.processor.model.literal.LiteralType;
import com.sun.xml.rpc.processor.model.soap.SOAPCustomType;
import com.sun.xml.rpc.processor.model.soap.SOAPType;
import com.sun.xml.rpc.processor.util.DirectoryUtil;
import com.sun.xml.rpc.processor.util.ProcessorEnvironment;
import com.sun.xml.rpc.processor.util.StringUtils;
import com.sun.xml.rpc.spi.model.Port;
import com.sun.xml.rpc.streaming.PrefixFactory;
import com.sun.xml.rpc.streaming.PrefixFactoryImpl;
import com.sun.xml.rpc.util.ClassNameInfo;
import java.io.File;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;

public class Names
implements com.sun.xml.rpc.spi.tools.Names,
GeneratorConstants {
    protected String serializerNameInfix = null;
    protected PrefixFactory prefixFactory = new PrefixFactoryImpl("ns");
    protected static Map reservedWords = new HashMap();
    protected static Map holderClassNames;

    public String stubFor(Port port) {
        return this.stubFor((com.sun.xml.rpc.processor.model.Port)port, null);
    }

    public String stubFor(com.sun.xml.rpc.processor.model.Port port, String infix) {
        String result = (String)port.getProperty("com.sun.xml.rpc.processor.model.StubClassName");
        if (result == null) {
            result = this.makeDerivedClassName(port.getJavaInterface(), "_Stub", infix);
        }
        return result;
    }

    public String skeletonFor(JavaInterface javaInterface) {
        String name = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return name + "_Skeleton";
    }

    public String tieFor(com.sun.xml.rpc.processor.model.Port port) {
        return this.tieFor(port, this.serializerNameInfix);
    }

    public String tieFor(com.sun.xml.rpc.processor.model.Port port, String infix) {
        String result = (String)port.getProperty("com.sun.xml.rpc.processor.model.TieClassName");
        if (result == null) {
            result = this.makeDerivedClassName(port.getJavaInterface(), "_Tie", infix);
        }
        return result;
    }

    public String makeDerivedClassName(JavaInterface javaInterface, String suffix, String infix) {
        String name = ClassNameInfo.replaceInnerClassSym(javaInterface.getRealName());
        return name + (infix == null ? "" : "_" + infix) + suffix;
    }

    public static String getPortName(com.sun.xml.rpc.processor.model.Port port) {
        String javaPortName = (String)port.getProperty("com.sun.xml.rpc.processor.model.JavaPortName");
        if (javaPortName != null) {
            return javaPortName;
        }
        QName portName = (QName)port.getProperty("com.sun.xml.rpc.processor.model.WSDLPortName");
        if (portName != null) {
            return portName.getLocalPart();
        }
        String name = Names.stripQualifier(port.getJavaInterface().getName());
        return ClassNameInfo.replaceInnerClassSym(name);
    }

    public static String stripQualifier(Class classObj) {
        String name = classObj.getName();
        return Names.stripQualifier(name);
    }

    public static String stripQualifier(String name) {
        return ClassNameInfo.getName(name);
    }

    public static String getPackageName(String className) {
        String packageName = ClassNameInfo.getQualifier(className);
        return packageName != null ? packageName : "";
    }

    public static String getUnqualifiedClassName(String className) {
        return ClassNameInfo.getName(className).replace('$', '.');
    }

    public File sourceFileForClass(String className, String outputClassName, File destDir, ProcessorEnvironment env) throws GeneratorException {
        File packageDir = DirectoryUtil.getOutputDirectoryFor(className, destDir, env);
        String outputName = Names.stripQualifier(outputClassName);
        String outputFileName = outputName + ".java";
        return new File(packageDir, outputFileName);
    }

    public String typeClassName(SOAPType type) {
        return this.typeClassName(type.getJavaType());
    }

    public String typeClassName(JavaType type) {
        String typeName = type.getName();
        return typeName;
    }

    public String typeObjectSerializerClassName(String basePackage, SOAPType type) {
        return this.typeObjectSerializerClassName(basePackage, type.getJavaType(), "_SOAPSerializer");
    }

    public String typeObjectArraySerializerClassName(String basePackage, SOAPType type) {
        return this.typeObjectArraySerializerClassName(basePackage, type.getJavaType(), "Array_SOAPSerializer");
    }

    public String typeObjectSerializerClassName(String basePackage, LiteralType type) {
        return this.typeObjectSerializerClassName(basePackage, type.getJavaType(), "_LiteralSerializer");
    }

    public String typeObjectArraySerializerClassName(String basePackage, LiteralType type) {
        return this.typeObjectArraySerializerClassName(basePackage, type.getJavaType(), "Array_LiteralSerializer");
    }

    public String typeObjectSerializerClassName(String basePackage, JavaType type, String suffix) {
        String typeName = type.getRealName();
        return this.serializerClassName(basePackage, typeName, suffix);
    }

    public String typeInterfaceSerializerClassName(String basePackage, AbstractType type) {
        return this.typeInterfaceSerializerClassName(basePackage, type.getJavaType(), "_InterfaceSOAPSerializer");
    }

    public String typeInterfaceSerializerClassName(String basePackage, JavaType type, String suffix) {
        String typeName = type.getRealName();
        return this.serializerClassName(basePackage, typeName, suffix);
    }

    protected String serializerClassName(String basePackage, String className, String suffix) {
        if (this.serializerNameInfix != null) {
            className = className + this.serializerNameInfix;
        }
        return (className + suffix).replace('$', '_');
    }

    public String typeObjectArraySerializerClassName(String basePackage, JavaType type, String suffix) {
        String typeName = type.getRealName();
        int idx = typeName.indexOf("[]");
        if (idx > 0) {
            typeName = typeName.substring(0, idx);
        }
        return this.serializerClassName(basePackage, typeName, suffix);
    }

    public String typeObjectBuilderClassName(String basePackage, SOAPType type) {
        return this.typeObjectBuilderClassName(basePackage, type.getJavaType());
    }

    public String typeObjectBuilderClassName(String basePackage, JavaType type) {
        return this.builderClassName(basePackage, type.getRealName(), "_SOAPBuilder");
    }

    protected String builderClassName(String basePackage, String className, String suffix) {
        if (this.serializerNameInfix != null) {
            className = className + this.serializerNameInfix;
        }
        return (className + suffix).replace('$', '_');
    }

    public String faultBuilderClassName(String basePackage, com.sun.xml.rpc.processor.model.Port port, Operation operation) {
        String typeName = port.getJavaInterface().getName() + "_" + this.validExternalJavaIdentifier(operation.getUniqueName());
        return this.builderClassName(basePackage, typeName, "_Fault_SOAPBuilder");
    }

    public String faultSerializerClassName(String basePackage, com.sun.xml.rpc.processor.model.Port port, Operation operation) {
        String name = port.getJavaInterface().getName() + "_" + this.validExternalJavaIdentifier(operation.getUniqueName());
        return this.serializerClassName(basePackage, name, "_Fault_SOAPSerializer");
    }

    public static String getPackageName(Service service) {
        String portPackage = Names.getPackageName(service.getJavaInterface().getName());
        return portPackage;
    }

    public String customJavaTypeClassName(JavaInterface intf) {
        String intName = intf.getName();
        return intName;
    }

    public String customJavaTypeClassName(AbstractType type) {
        String typeName = type.getJavaType().getName();
        return typeName;
    }

    private String customJavaTypeClassName(String typeName) {
        return typeName;
    }

    public String customExceptionClassName(Fault fault) {
        String typeName = fault.getJavaException().getName();
        return typeName;
    }

    public String interfaceImplClassName(com.sun.xml.rpc.spi.model.JavaInterface intf) {
        String intName = intf.getName() + "_Impl";
        return intName;
    }

    public String serializerRegistryClassName(JavaInterface intf) {
        String intName = intf.getName() + "_SerializerRegistry";
        return intName;
    }

    public String holderClassName(com.sun.xml.rpc.processor.model.Port port, AbstractType type) {
        return this.holderClassName(port, type.getJavaType());
    }

    public String holderClassName(com.sun.xml.rpc.processor.model.Port port, JavaType type) {
        if (type.getHolderName() != null) {
            return type.getHolderName();
        }
        String typeName = type.getName();
        if (type instanceof JavaArrayType && ((JavaArrayType)type).getSOAPArrayHolderName() != null) {
            typeName = ((JavaArrayType)type).getSOAPArrayHolderName();
        }
        return this.holderClassName(port, typeName);
    }

    protected String holderClassName(com.sun.xml.rpc.processor.model.Port port, String typeName) {
        String holderTypeName = (String)holderClassNames.get(typeName);
        if (holderTypeName == null) {
            String className = port.getJavaInterface().getName();
            String packageName = Names.getPackageName(className);
            packageName = packageName.length() > 0 ? packageName + ".holders." : "holders.";
            typeName = Names.stripQualifier(typeName);
            int idx = typeName.indexOf("[]");
            while (idx > 0) {
                typeName = typeName.substring(0, idx) + "Array" + typeName.substring(idx + 2);
                idx = typeName.indexOf("[]");
            }
            holderTypeName = packageName + this.validJavaClassName(typeName) + "Holder";
        }
        return holderTypeName;
    }

    public static boolean isInJavaOrJavaxPackage(String typeName) {
        return typeName.startsWith("java.") || typeName.startsWith("javax.");
    }

    public String memberName(String name) {
        return ("my" + name).replace('.', '$');
    }

    public String getClassMemberName(String className) {
        className = Names.getUnqualifiedClassName(className);
        return this.memberName(className);
    }

    public String getClassMemberName(String className, AbstractType type, String suffix) {
        className = Names.getUnqualifiedClassName(className);
        String additionalClassName = type.getJavaType().getName().replace('.', '_');
        int idx = additionalClassName.indexOf(91);
        if (idx > 0) {
            additionalClassName = additionalClassName.substring(0, idx);
        }
        return this.memberName(this.getPrefix(type.getName()) + "_" + this.validJavaName(type.getName().getLocalPart()) + "__" + additionalClassName + "_" + className + suffix);
    }

    public String getClassMemberName(String className, AbstractType type) {
        className = Names.getUnqualifiedClassName(className);
        return this.getClassMemberName(this.getPrefix(type.getName()) + "_" + this.validJavaName(type.getName().getLocalPart()) + "__" + className);
    }

    public String getTypeMemberName(AbstractType type) {
        return this.getTypeMemberName(type.getJavaType());
    }

    public String getTypeMemberName(JavaType javaType) {
        String typeName = javaType.getRealName();
        return this.getTypeMemberName(typeName);
    }

    public String getTypeMemberName(String typeName) {
        typeName = Names.getUnqualifiedClassName(typeName);
        int i = 0;
        while (typeName.endsWith("[]")) {
            typeName = typeName.substring(0, typeName.length() - 2);
            ++i;
        }
        while (i < 0) {
            typeName = typeName + "Array";
            --i;
        }
        return this.memberName(typeName);
    }

    public String getCustomTypeSerializerMemberName(SOAPCustomType type) {
        return this.getTypeQName(type.getName()) + "_Serializer";
    }

    public String getCustomTypeDeserializerMemberName(SOAPCustomType type) {
        return this.getTypeQName(type.getName()) + "_Deserializer";
    }

    public String getLiteralFragmentTypeSerializerMemberName(LiteralFragmentType type) {
        return this.getTypeQName(type.getName()) + "_Serializer";
    }

    public String getOPCodeName(String name) {
        String qname = name + "_OPCODE";
        return this.validInternalJavaIdentifier(qname);
    }

    public String getQNameName(QName name) {
        String qname = this.getPrefix(name) + "_" + name.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public String getBlockQNameName(Operation operation, Block block) {
        QName blockName = block.getName();
        String qname = this.getPrefix(blockName);
        if (operation != null) {
            qname = qname + "_" + operation.getUniqueName();
        }
        qname = qname + "_" + blockName.getLocalPart() + "_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public void setJavaStructureMemberMethodNames(JavaStructureMember javaMember) {
        javaMember.setReadMethod(this.getJavaMemberReadMethod(javaMember));
        javaMember.setWriteMethod(this.getJavaMemberWriteMethod(javaMember));
    }

    public String getBlockUniqueName(Operation operation, Block block) {
        QName blockName = block.getName();
        String qname = this.getPrefix(blockName);
        if (operation != null) {
            qname = qname + "_" + operation.getUniqueName();
        }
        qname = qname + "_" + blockName.getLocalPart();
        return this.validInternalJavaIdentifier(qname);
    }

    public String getTypeQName(QName name) {
        String qname = this.getPrefix(name) + "_" + name.getLocalPart() + "_TYPE_QNAME";
        return this.validInternalJavaIdentifier(qname);
    }

    public String validJavaClassName(String name) {
        return this.validJavaName(StringUtils.capitalize(name));
    }

    public String validJavaMemberName(String name) {
        return this.validJavaName(StringUtils.decapitalize(name));
    }

    public String validJavaPackageName(String name) {
        return this.validJavaName(StringUtils.decapitalize(name));
    }

    public String getIDObjectResolverName(String name) {
        return this.validJavaClassName(name) + "IDObjectResolver";
    }

    public String validInternalJavaIdentifier(String name) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < name.length(); ++i) {
            char ch = name.charAt(i);
            if (i == 0) {
                if (Character.isJavaIdentifierStart(ch)) {
                    sb.append(ch);
                    continue;
                }
                sb.append("_$");
                sb.append(Integer.toHexString(ch));
                sb.append("$");
                continue;
            }
            if (Character.isJavaIdentifierPart(ch)) {
                sb.append(ch);
                continue;
            }
            sb.append("$");
            sb.append(Integer.toHexString(ch));
            sb.append("$");
        }
        String id = sb.toString();
        String tmp = (String)reservedWords.get(id);
        if (tmp != null) {
            id = tmp;
        }
        return id;
    }

    public String validExternalJavaIdentifier(String name) {
        return this.validInternalJavaIdentifier(name).replace('$', '_');
    }

    public String validJavaName(String name) {
        name = this.wordBreakString(name);
        String tmp = (String)reservedWords.get(name = this.removeWhiteSpace(name));
        if (tmp != null) {
            name = tmp;
        }
        return name;
    }

    public boolean isJavaReservedWord(String name) {
        return reservedWords.get(name) != null;
    }

    public String getJavaMemberReadMethod(JavaStructureMember member) {
        String return_value = null;
        return_value = member.getType().getRealName() == "boolean" ? "is" + StringUtils.capitalize(member.getName()) : "get" + StringUtils.capitalize(member.getName());
        return return_value;
    }

    public String getJavaMemberWriteMethod(JavaStructureMember member) {
        return "set" + StringUtils.capitalize(member.getName());
    }

    public String getResponseName(String messageName) {
        return messageName + "Response";
    }

    public String removeWhiteSpace(String str) {
        String tmp = this.removeCharacter(32, str);
        return tmp;
    }

    public String wordBreakString(String str) {
        StringBuffer buf = new StringBuffer(str);
        for (int i = 0; i < buf.length(); ++i) {
            char ch = buf.charAt(i);
            if (Character.isDigit(ch)) {
                if (i + 1 >= buf.length() || Character.isDigit(buf.charAt(i + 1))) continue;
                buf.insert(1 + i++, ' ');
                continue;
            }
            if (Character.isSpaceChar(ch) || ch == '_') continue;
            if (!Character.isJavaIdentifierPart(ch)) {
                buf.setCharAt(i, ' ');
                continue;
            }
            if (Character.isLetter(ch)) continue;
            buf.setCharAt(i, ' ');
        }
        return buf.toString();
    }

    public String removeCharacter(int ch, String str) {
        int idx = str.indexOf(ch);
        while (idx >= 0) {
            str = str.substring(0, idx) + StringUtils.capitalize(str.substring(idx + 1).trim());
            idx = str.indexOf(32);
        }
        return str;
    }

    public String getPrefix(QName name) {
        return this.getPrefix(name.getNamespaceURI());
    }

    public String getPrefix(String uri) {
        return this.prefixFactory.getPrefix(uri);
    }

    public void resetPrefixFactory() {
        this.prefixFactory = new PrefixFactoryImpl("ns");
    }

    public void setSerializerNameInfix(String serNameInfix) {
        if (serNameInfix != null && serNameInfix.length() > 0) {
            this.serializerNameInfix = "_" + serNameInfix;
        }
    }

    public String getSerializerNameInfix() {
        String str = this.serializerNameInfix;
        if (this.serializerNameInfix != null && this.serializerNameInfix.charAt(0) == '_') {
            str = this.serializerNameInfix.substring(1);
        }
        return str;
    }

    public static String getAdjustedURI(String namespaceURI, String pkgName) {
        if (pkgName == null) {
            return namespaceURI;
        }
        if (namespaceURI == null) {
            return pkgName;
        }
        int length = namespaceURI.length();
        int i = namespaceURI.lastIndexOf(47);
        if (i == -1 && (i = namespaceURI.lastIndexOf(58)) == -1) {
            return pkgName;
        }
        if (i != -1 && i + 1 == length) {
            return namespaceURI + pkgName;
        }
        int j = namespaceURI.indexOf(46, i);
        if (j != -1) {
            return namespaceURI.substring(0, i + 1) + pkgName;
        }
        return namespaceURI + "/" + pkgName;
    }

    static {
        reservedWords.put("abstract", "_abstract");
        reservedWords.put("assert", "_assert");
        reservedWords.put("boolean", "_boolean");
        reservedWords.put("break", "_break");
        reservedWords.put("byte", "_byte");
        reservedWords.put("case", "_case");
        reservedWords.put("catch", "_catch");
        reservedWords.put("char", "_char");
        reservedWords.put("class", "_class");
        reservedWords.put("const", "_const");
        reservedWords.put("continue", "_continue");
        reservedWords.put("default", "_default");
        reservedWords.put("do", "_do");
        reservedWords.put("double", "_double");
        reservedWords.put("else", "_else");
        reservedWords.put("extends", "_extends");
        reservedWords.put("false", "_false");
        reservedWords.put("final", "_final");
        reservedWords.put("finally", "_finally");
        reservedWords.put("float", "_float");
        reservedWords.put("for", "_for");
        reservedWords.put("goto", "_goto");
        reservedWords.put("if", "_if");
        reservedWords.put("implements", "_implements");
        reservedWords.put("import", "_import");
        reservedWords.put("instanceof", "_instanceof");
        reservedWords.put("int", "_int");
        reservedWords.put("interface", "_interface");
        reservedWords.put("long", "_long");
        reservedWords.put("native", "_native");
        reservedWords.put("new", "_new");
        reservedWords.put("null", "_null");
        reservedWords.put("package", "_package");
        reservedWords.put("private", "_private");
        reservedWords.put("protected", "_protected");
        reservedWords.put("public", "_public");
        reservedWords.put("return", "_return");
        reservedWords.put("short", "_short");
        reservedWords.put("static", "_static");
        reservedWords.put("strictfp", "_strictfp");
        reservedWords.put("super", "_super");
        reservedWords.put("switch", "_switch");
        reservedWords.put("synchronized", "_synchronized");
        reservedWords.put("this", "_this");
        reservedWords.put("throw", "_throw");
        reservedWords.put("throws", "_throws");
        reservedWords.put("transient", "_transient");
        reservedWords.put("true", "_true");
        reservedWords.put("try", "_try");
        reservedWords.put("void", "_void");
        reservedWords.put("volatile", "_volatile");
        reservedWords.put("while", "_while");
        reservedWords.put("Exception", "_Exception");
        holderClassNames = new HashMap();
        holderClassNames.put("int", "javax.xml.rpc.holders.IntHolder");
        holderClassNames.put("long", "javax.xml.rpc.holders.LongHolder");
        holderClassNames.put("short", "javax.xml.rpc.holders.ShortHolder");
        holderClassNames.put("float", "javax.xml.rpc.holders.FloatHolder");
        holderClassNames.put("double", "javax.xml.rpc.holders.DoubleHolder");
        holderClassNames.put("boolean", "javax.xml.rpc.holders.BooleanHolder");
        holderClassNames.put("byte", "javax.xml.rpc.holders.ByteHolder");
        holderClassNames.put("java.lang.Integer", "javax.xml.rpc.holders.IntegerWrapperHolder");
        holderClassNames.put("java.lang.Long", "javax.xml.rpc.holders.LongWrapperHolder");
        holderClassNames.put("java.lang.Short", "javax.xml.rpc.holders.ShortWrapperHolder");
        holderClassNames.put("java.lang.Float", "javax.xml.rpc.holders.FloatWrapperHolder");
        holderClassNames.put("java.lang.Double", "javax.xml.rpc.holders.DoubleWrapperHolder");
        holderClassNames.put("java.lang.Boolean", "javax.xml.rpc.holders.BooleanWrapperHolder");
        holderClassNames.put("java.lang.Byte", "javax.xml.rpc.holders.ByteWrapperHolder");
        holderClassNames.put("java.lang.String", "javax.xml.rpc.holders.StringHolder");
        holderClassNames.put("java.math.BigDecimal", "javax.xml.rpc.holders.BigDecimalHolder");
        holderClassNames.put("java.math.BigInteger", "javax.xml.rpc.holders.BigIntegerHolder");
        holderClassNames.put("java.util.Calendar", "javax.xml.rpc.holders.CalendarHolder");
        holderClassNames.put("javax.xml.namespace.QName", "javax.xml.rpc.holders.QNameHolder");
        holderClassNames.put("java.lang.Object", "javax.xml.rpc.holders.ObjectHolder");
        holderClassNames.put("byte[]", "javax.xml.rpc.holders.ByteArrayHolder");
    }
}

