/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.util.LinkedList;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.source.ClasspathInfo;
import org.netbeans.api.java.source.CompilationController;
import org.netbeans.modules.java.source.parsing.ClasspathInfoTask;
import org.netbeans.modules.parsing.api.Embedding;
import org.netbeans.modules.parsing.api.ResultIterator;
import org.netbeans.modules.parsing.api.Snapshot;
import org.netbeans.modules.parsing.spi.ParseException;

public final class NewComilerTask
extends ClasspathInfoTask {
    private CompilationController result;
    private long timestamp;

    public NewComilerTask(ClasspathInfo cpInfo, CompilationController last, long timestamp) {
        super(cpInfo);
        this.result = last;
        this.timestamp = timestamp;
    }

    public void run(@NonNull ResultIterator resultIterator) throws Exception {
        Snapshot snapshot = resultIterator.getSnapshot();
        if (!"text/x-java".equals(snapshot.getMimeType())) {
            resultIterator = this.findEmbeddedJava(resultIterator);
        }
        if (resultIterator != null) {
            resultIterator.getParserResult();
        }
    }

    @CheckForNull
    private ResultIterator findEmbeddedJava(@NonNull ResultIterator theMess) throws ParseException {
        LinkedList<Embedding> todo = new LinkedList<Embedding>();
        for (Embedding embedding : theMess.getEmbeddings()) {
            if ("text/x-java".equals(embedding.getMimeType())) {
                return theMess.getResultIterator(embedding);
            }
            todo.add(embedding);
        }
        for (Embedding embedding : todo) {
            ResultIterator res = this.findEmbeddedJava(theMess.getResultIterator(embedding));
            if (res == null) continue;
            return res;
        }
        return null;
    }

    public void setCompilationController(@NonNull CompilationController result, long timestamp) {
        assert (result != null);
        this.result = result;
        this.timestamp = timestamp;
    }

    public CompilationController getCompilationController() {
        return this.result;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

