/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.parsing;

import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.tools.FileObject;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.parsing.Archive;
import org.netbeans.modules.java.source.parsing.CachingArchiveProvider;
import org.netbeans.modules.java.source.parsing.FileManagerTransaction;
import org.netbeans.modules.java.source.parsing.FileObjects;
import org.netbeans.modules.java.source.parsing.InferableJavaFileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.BaseUtilities;
import org.openide.util.Exceptions;

public final class TreeLoaderOutputFileManager
implements JavaFileManager {
    private static final Logger LOG = Logger.getLogger(TreeLoaderOutputFileManager.class.getName());
    private static final String OUTPUT_ROOT = "output-root";
    private String outputRoot;
    private final CachingArchiveProvider provider;
    private final FileManagerTransaction tx;

    public TreeLoaderOutputFileManager(@NonNull CachingArchiveProvider provider, @NonNull FileManagerTransaction tx) {
        assert (provider != null);
        assert (tx != null);
        this.provider = provider;
        this.tx = tx;
    }

    @Override
    public Iterable<JavaFileObject> list(JavaFileManager.Location location, String packageName, Set<JavaFileObject.Kind> kinds, boolean recurse) throws IOException {
        return Collections.emptyList();
    }

    @Override
    public JavaFileObject getJavaFileForOutput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind, FileObject sibling) throws IOException {
        if (!this.hasLocation(location)) {
            throw new IllegalArgumentException(String.valueOf(location));
        }
        File root = new File(this.outputRoot);
        String nameStr = FileObjects.convertPackage2Folder(className, File.separatorChar) + '.' + "sig";
        File file = new File(root, nameStr);
        if (FileObjects.isValidFileName(className)) {
            return this.tx.createFileObject(location, file, root, null, null);
        }
        LOG.log(Level.WARNING, "Invalid class name: {0} sibling: {1}", new Object[]{className, sibling});
        return FileObjects.nullWriteFileObject(FileObjects.fileFileObject(file, root, null, null));
    }

    @Override
    public JavaFileObject getJavaFileForInput(JavaFileManager.Location location, String className, JavaFileObject.Kind kind) throws IOException {
        JavaFileObject fo;
        if (!this.hasLocation(location)) {
            throw new IllegalArgumentException(String.valueOf(location));
        }
        String[] names = FileObjects.getParentRelativePathAndName(className);
        if (kind == JavaFileObject.Kind.CLASS && (fo = this.tx.readFileObject(location, names[0], names[1])) != null) {
            return fo;
        }
        names[1] = names[1] + kind.extension;
        try {
            File root = new File(this.outputRoot);
            Archive archive = this.provider.getArchive(BaseUtilities.toURI((File)root).toURL(), false);
            if (archive != null) {
                Iterable<JavaFileObject> files = archive.getFiles(names[0], null, null, null);
                for (JavaFileObject e : files) {
                    if (!names[1].equals(e.getName())) continue;
                    return e;
                }
            }
        }
        catch (IOException e) {
            Exceptions.printStackTrace((Throwable)e);
        }
        return null;
    }

    @Override
    public FileObject getFileForOutput(JavaFileManager.Location location, String packageName, String relativeName, FileObject sibling) throws IOException {
        if (!this.hasLocation(location)) {
            throw new IllegalArgumentException(String.valueOf(location));
        }
        File root = new File(this.outputRoot);
        File file = FileUtil.normalizeFile((File)new File(root, FileObjects.resolveRelativePath(packageName, relativeName).replace('/', File.separatorChar)));
        return this.tx.createFileObject(location, file, root, null, null);
    }

    @Override
    public FileObject getFileForInput(JavaFileManager.Location location, String packageName, String relativeName) throws IOException {
        if (!this.hasLocation(location)) {
            throw new IllegalArgumentException(String.valueOf(location));
        }
        File root = new File(this.outputRoot);
        String path = FileObjects.resolveRelativePath(packageName, relativeName);
        String[] names = FileObjects.getFolderAndBaseName(path, '/');
        JavaFileObject jfo = this.tx.readFileObject(location, names[0], names[1]);
        if (jfo != null) {
            return jfo;
        }
        Archive archive = this.provider.getArchive(BaseUtilities.toURI((File)root).toURL(), false);
        return archive != null ? archive.getFile(path) : null;
    }

    @Override
    public String inferBinaryName(JavaFileManager.Location location, JavaFileObject file) {
        if (file instanceof InferableJavaFileObject) {
            return ((InferableJavaFileObject)file).inferBinaryName();
        }
        return null;
    }

    @Override
    public boolean isSameFile(FileObject a, FileObject b) {
        return false;
    }

    @Override
    public int isSupportedOption(String option) {
        return OUTPUT_ROOT.equals(option) ? 1 : -1;
    }

    @Override
    public boolean handleOption(String current, Iterator<String> remaining) {
        if (OUTPUT_ROOT.equals(current)) {
            if (remaining.hasNext()) {
                this.outputRoot = remaining.next();
                if (this.outputRoot.isEmpty()) {
                    this.outputRoot = null;
                }
            } else {
                throw new IllegalStateException("No OUTPUT_ROOT value.");
            }
        }
        return false;
    }

    @Override
    public boolean hasLocation(JavaFileManager.Location location) {
        return location == StandardLocation.CLASS_OUTPUT && this.outputRoot != null;
    }

    @Override
    public ClassLoader getClassLoader(JavaFileManager.Location location) {
        return null;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
    }
}

