/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.navigation.hierarchy;

import java.awt.BorderLayout;
import java.io.Serializable;
import java.util.logging.Logger;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import org.netbeans.modules.cnd.api.model.CsmChangeEvent;
import org.netbeans.modules.cnd.api.model.CsmClass;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmListeners;
import org.netbeans.modules.cnd.api.model.CsmModelAccessor;
import org.netbeans.modules.cnd.api.model.CsmModelListener;
import org.netbeans.modules.cnd.api.model.CsmProject;
import org.netbeans.modules.cnd.navigation.classhierarchy.ClassHierarchyPanel;
import org.netbeans.modules.cnd.navigation.hierarchy.ContextUtils;
import org.netbeans.modules.cnd.navigation.includeview.IncludeHierarchyPanel;
import org.netbeans.modules.cnd.navigation.includeview.IncludeNode;
import org.openide.awt.Mnemonics;
import org.openide.awt.StatusDisplayer;
import org.openide.explorer.ExplorerManager;
import org.openide.nodes.Node;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;
import org.openide.windows.TopComponent;
import org.openide.windows.WindowManager;

final class HierarchyTopComponent
extends TopComponent
implements CsmModelListener {
    private static HierarchyTopComponent instance;
    static final String ICON_PATH = "org/netbeans/modules/cnd/navigation/classhierarchy/resources/subtypehierarchy.gif";
    private static final String PREFERRED_ID = "HierarchyTopComponent";
    private JComponent last = null;
    private static final RequestProcessor RP;
    private JButton jButton1;

    private HierarchyTopComponent() {
        this.initComponents();
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_HierarchyTopComponent"));
        this.setIcon(ImageUtilities.loadImage((String)ICON_PATH, (boolean)true));
        this.putClientProperty("KeepNonPersistentTCInModelWhenClosed", Boolean.TRUE);
    }

    void setClass(final TypeContextFinder context, final boolean setClose) {
        ClassHierarchyPanel panel;
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_TypeHierarchyTopComponent"));
        if (this.last instanceof ClassHierarchyPanel) {
            panel = (ClassHierarchyPanel)this.last;
        } else {
            this.removeAll();
            panel = new ClassHierarchyPanel(true);
            this.add(panel, "Center");
            this.validate();
            this.last = panel;
        }
        panel.setWaiting();
        Runnable worker = new Runnable(){
            private CsmClass cls;

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    if (this.cls == null) {
                        String msg = NbBundle.getMessage(this.getClass(), (String)"MESSAGE_NoContextClass");
                        StatusDisplayer.getDefault().setStatusText(msg);
                    }
                    HierarchyTopComponent.this.setClass(this.cls, setClose);
                } else {
                    this.cls = context.getCsmClass();
                    SwingUtilities.invokeLater(this);
                }
            }
        };
        RP.post(worker);
    }

    void setClass(CsmClass decl, boolean setClose) {
        ClassHierarchyPanel panel;
        if (decl == null) {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        } else {
            this.setName(decl.getName() + " - " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        }
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_TypeHierarchyTopComponent"));
        if (this.last instanceof ClassHierarchyPanel) {
            panel = (ClassHierarchyPanel)this.last;
        } else {
            this.removeAll();
            panel = new ClassHierarchyPanel(true);
            this.add(panel, "Center");
            this.validate();
            this.last = panel;
        }
        if (setClose) {
            panel.setClose();
        } else {
            panel.clearClose();
        }
        panel.setClass(decl);
        this.last.requestFocusInWindow();
    }

    void setFile(final InclideContextFinder context, final boolean setClose) {
        IncludeHierarchyPanel panel;
        this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_IncludeHierarchyTopComponent"));
        if (this.last instanceof IncludeHierarchyPanel) {
            panel = (IncludeHierarchyPanel)this.last;
        } else {
            this.removeAll();
            panel = new IncludeHierarchyPanel(true);
            this.add(panel, "Center");
            this.validate();
            this.last = panel;
        }
        panel.setWaiting();
        Runnable worker = new Runnable(){
            private CsmFile file;

            @Override
            public void run() {
                if (SwingUtilities.isEventDispatchThread()) {
                    HierarchyTopComponent.this.setFile(this.file, setClose);
                } else {
                    this.file = context.getFile();
                    SwingUtilities.invokeLater(this);
                }
            }
        };
        RP.post(worker);
    }

    public Lookup getLookup() {
        IncludeHierarchyPanel p;
        ExplorerManager explorerManager;
        Node[] selectedNodes;
        if (this.last instanceof IncludeHierarchyPanel && (selectedNodes = (explorerManager = (p = (IncludeHierarchyPanel)this.last).getExplorerManager()).getSelectedNodes()).length == 1 && selectedNodes[0] instanceof IncludeNode) {
            IncludeNode node = (IncludeNode)selectedNodes[0];
            return node.getNodeLookup();
        }
        return super.getLookup();
    }

    void setFile(CsmFile file, boolean setClose) {
        if (file != null) {
            this.setName(file.getName() + " - " + NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        } else {
            this.setName(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"CTL_HierarchyTopComponent"));
        }
        this.setToolTipText(NbBundle.getMessage(((Object)((Object)this)).getClass(), (String)"HINT_IncludeHierarchyTopComponent"));
        if (!(this.last instanceof IncludeHierarchyPanel)) {
            this.removeAll();
            IncludeHierarchyPanel panel = new IncludeHierarchyPanel(true);
            this.add(panel, "Center");
            this.validate();
            this.last = panel;
        }
        if (setClose) {
            ((IncludeHierarchyPanel)this.last).setClose();
        } else {
            ((IncludeHierarchyPanel)this.last).clearClose();
        }
        ((IncludeHierarchyPanel)this.last).setFile(file);
        this.last.requestFocusInWindow();
    }

    public void requestActive() {
        super.requestActive();
        if (this.last != null) {
            this.last.requestFocusInWindow();
        }
    }

    private void initComponents() {
        this.jButton1 = new JButton();
        this.setLayout(new BorderLayout());
        this.jButton1.setBackground(new JTextArea().getBackground());
        Mnemonics.setLocalizedText((AbstractButton)this.jButton1, (String)NbBundle.getMessage(HierarchyTopComponent.class, (String)"NoViewAvailable"));
        this.jButton1.setBorderPainted(false);
        this.jButton1.setEnabled(false);
        this.add(this.jButton1, "Center");
    }

    public static synchronized HierarchyTopComponent getDefault() {
        if (instance == null) {
            instance = new HierarchyTopComponent();
        }
        return instance;
    }

    public static synchronized HierarchyTopComponent findInstance() {
        TopComponent win = WindowManager.getDefault().findTopComponent(PREFERRED_ID);
        if (win == null) {
            Logger.getLogger(HierarchyTopComponent.class.getName()).warning("Cannot find HierarchyTopComponent component. It will not be located properly in the window system.");
            return HierarchyTopComponent.getDefault();
        }
        if (win instanceof HierarchyTopComponent) {
            return (HierarchyTopComponent)win;
        }
        Logger.getLogger(HierarchyTopComponent.class.getName()).warning("There seem to be multiple components with the 'HierarchyTopComponent' ID. That is a potential source of errors and unexpected behavior.");
        return HierarchyTopComponent.getDefault();
    }

    public int getPersistenceType() {
        return 1;
    }

    public void componentOpened() {
        CsmListeners.getDefault().addModelListener((CsmModelListener)this);
    }

    public void componentClosed() {
        this.removeAll();
        this.initComponents();
        this.last = null;
        CsmListeners.getDefault().removeModelListener((CsmModelListener)this);
    }

    public Object writeReplace() {
        return new ResolvableHelper();
    }

    protected String preferredID() {
        return PREFERRED_ID;
    }

    public void projectOpened(CsmProject project) {
    }

    public void projectClosed(CsmProject project) {
        if (CsmModelAccessor.getModel().projects().isEmpty()) {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    HierarchyTopComponent tc = HierarchyTopComponent.findInstance();
                    if (tc.isOpened()) {
                        tc.close();
                    }
                }
            });
        }
    }

    public void modelChanged(CsmChangeEvent e) {
    }

    static {
        RP = new RequestProcessor("HierarchyWorker", 1);
    }

    static final class TypeContextFinder {
        private final Node[] activatedNodes;

        TypeContextFinder(Node[] activatedNodes) {
            this.activatedNodes = activatedNodes;
        }

        private CsmClass getCsmClass() {
            return ContextUtils.getContextClass(this.activatedNodes);
        }
    }

    static final class InclideContextFinder {
        private final Node[] activatedNodes;

        InclideContextFinder(Node[] activatedNodes) {
            this.activatedNodes = activatedNodes;
        }

        private CsmFile getFile() {
            return ContextUtils.findFile(this.activatedNodes);
        }
    }

    static final class ResolvableHelper
    implements Serializable {
        private static final long serialVersionUID = 1L;

        ResolvableHelper() {
        }

        public Object readResolve() {
            return HierarchyTopComponent.getDefault();
        }
    }
}

