/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2me.project.ui.customizer;

import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.JFrame;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2me.project.J2MEProject;
import org.netbeans.modules.j2me.project.ui.customizer.J2MEProjectProperties;
import org.netbeans.modules.java.api.common.project.ui.customizer.CustomizerProvider3;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.util.Lookup;
import org.openide.util.Mutex;
import org.openide.util.NbBundle;
import org.openide.util.Parameters;
import org.openide.util.lookup.Lookups;
import org.openide.windows.WindowManager;

public final class CustomizerProviderImpl
implements CustomizerProvider3 {
    private static final String CUSTOMIZER_FOLDER_PATH = "Projects/org-netbeans-modules-j2me-project/Customizer";
    private final J2MEProject project;
    private Dialog currentDialog;

    public CustomizerProviderImpl(@NonNull J2MEProject project) {
        Parameters.notNull((CharSequence)"project", (Object)project);
        this.project = project;
    }

    public void showCustomizer() {
        this.showCustomizer(null, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void showCustomizer(String preselectedCategory, String preselectedSubCategory) {
        if (this.currentDialog != null) {
            this.currentDialog.setVisible(true);
            return;
        }
        try {
            WaitCursor.show();
            J2MEProjectProperties uiProperties = this.createProperties();
            Lookup context = Lookups.fixed((Object[])new Object[]{this.project, uiProperties, new SubCategoryProvider(preselectedCategory, preselectedSubCategory)});
            OptionListener listener = new OptionListener(context);
            StoreListener storeListener = new StoreListener(context);
            this.currentDialog = ProjectCustomizer.createCustomizerDialog((String)CUSTOMIZER_FOLDER_PATH, (Lookup)context, (String)preselectedCategory, (ActionListener)listener, (ActionListener)storeListener, null);
            this.currentDialog.addWindowListener(listener);
            this.currentDialog.setTitle(NbBundle.getMessage(CustomizerProviderImpl.class, (String)"LBL_Customizer_Title", (Object)ProjectUtils.getInformation((Project)this.project).getDisplayName()));
        }
        finally {
            WaitCursor.hide();
        }
        this.currentDialog.setVisible(true);
    }

    public void cancelCustomizer() {
        this.hide();
        this.clear();
    }

    private void hide() {
        if (this.currentDialog != null) {
            this.currentDialog.setVisible(false);
            this.currentDialog.dispose();
        }
    }

    private void clear() {
        if (this.currentDialog != null) {
            this.currentDialog = null;
        }
    }

    private J2MEProjectProperties createProperties() {
        return new J2MEProjectProperties(this.project);
    }

    static final class SubCategoryProvider {
        private String subcategory;
        private String category;

        SubCategoryProvider(String category, String subcategory) {
            this.category = category;
            this.subcategory = subcategory;
        }

        public String getCategory() {
            return this.category;
        }

        public String getSubcategory() {
            return this.subcategory;
        }
    }

    private static final class StoreListener
    implements ActionListener {
        private final Lookup ctx;

        StoreListener(@NonNull Lookup context) {
            this.ctx = context;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            J2MEProjectProperties props = (J2MEProjectProperties)this.ctx.lookup(J2MEProjectProperties.class);
            props.storeData();
        }
    }

    private final class OptionListener
    extends WindowAdapter
    implements ActionListener {
        private final Lookup ctx;

        OptionListener(Lookup context) {
            this.ctx = context;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            J2MEProjectProperties props = (J2MEProjectProperties)this.ctx.lookup(J2MEProjectProperties.class);
            props.collectData();
        }

        @Override
        public void windowClosing(WindowEvent e) {
            CustomizerProviderImpl.this.hide();
        }

        @Override
        public void windowClosed(WindowEvent e) {
            CustomizerProviderImpl.this.clear();
        }
    }

    private static class WaitCursor
    implements Runnable {
        private final boolean show;

        private WaitCursor(boolean show) {
            this.show = show;
        }

        static void show() {
            Mutex.EVENT.readAccess((Runnable)new WaitCursor(true));
        }

        static void hide() {
            Mutex.EVENT.readAccess((Runnable)new WaitCursor(false));
        }

        @Override
        public void run() {
            JFrame f = (JFrame)WindowManager.getDefault().getMainWindow();
            Component c = f.getGlassPane();
            c.setVisible(this.show);
            c.setCursor(this.show ? Cursor.getPredefinedCursor(3) : null);
        }
    }
}

