/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.source.queries.spi;

import java.net.URL;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.modules.java.source.queries.APIAccessor;
import org.netbeans.modules.java.source.queries.SPIAccessor;
import org.netbeans.modules.java.source.queries.api.Function;
import org.netbeans.modules.java.source.queries.api.Queries;
import org.netbeans.modules.java.source.queries.api.QueryException;
import org.netbeans.modules.java.source.queries.spi.ModelOperations;

public interface QueriesController {
    public <R> R runQuery(@NonNull Context<R> var1) throws QueryException;

    public boolean runUpdate(@NonNull Context<Boolean> var1) throws QueryException;

    public static final class Context<R> {
        private final SPIFnc<?, R> toRun;
        private final URL forURL;

        private Context(@NonNull URL forURL, @NonNull SPIFnc<?, R> toRun) {
            assert (forURL != null);
            assert (toRun != null);
            this.toRun = toRun;
            this.forURL = forURL;
        }

        public URL getURL() {
            return this.forURL;
        }

        public R execute(ModelOperations op) throws QueryException {
            return this.toRun.apply(op);
        }

        static {
            SPIAccessor.setInstance(new Accessor());
        }

        private static class SPIFnc<P extends Queries, R>
        implements Function<ModelOperations, R> {
            private final Function<P, R> fnc;
            private final P param;

            private SPIFnc(@NonNull Function<P, R> fnc, @NonNull P param) {
                assert (fnc != null);
                assert (param != null);
                this.fnc = fnc;
                this.param = param;
            }

            @Override
            public R apply(@NonNull ModelOperations spi) throws QueryException {
                APIAccessor.getInstance().attach((Queries)this.param, spi);
                try {
                    R r = this.fnc.apply(this.param);
                    return r;
                }
                finally {
                    APIAccessor.getInstance().detach((Queries)this.param);
                }
            }

            /* synthetic */ SPIFnc(Function x0, Queries x1, 1 x2) {
                this(x0, x1);
            }
        }

        private static class Accessor
        extends SPIAccessor {
            private Accessor() {
            }

            @Override
            public <P extends Queries, R> Context<R> createContext(Function<P, R> fnc, P param) {
                return new Context(param.getURL(), new SPIFnc(fnc, param, null));
            }
        }
    }
}

