/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.nashorn.execution.options;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.jdesktop.beansbinding.AutoBinding;
import org.jdesktop.beansbinding.BeanProperty;
import org.jdesktop.beansbinding.Binding;
import org.jdesktop.beansbinding.BindingGroup;
import org.jdesktop.beansbinding.Bindings;
import org.jdesktop.beansbinding.ObjectProperty;
import org.jdesktop.beansbinding.Property;
import org.netbeans.api.java.platform.JavaPlatform;
import org.netbeans.api.java.platform.PlatformsCustomizer;
import org.netbeans.modules.java.api.common.ui.PlatformUiSupport;
import org.netbeans.modules.nashorn.execution.NashornPlatform;
import org.netbeans.modules.nashorn.execution.options.JavaScriptNashornOptionsPanelController;
import org.netbeans.modules.nashorn.execution.options.NashornPlatformComboBoxModel;
import org.netbeans.modules.nashorn.execution.options.Settings;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public class JavaScriptNashornPanel
extends JPanel {
    private final JavaScriptNashornOptionsPanelController optionsController;
    private JLabel argumentsLabel;
    private JTextField argumentsTextField;
    private JLabel engineOptionsLabel;
    private JTextField engineOptionsTextField;
    private JPanel fillPanel;
    private JLabel infoLabel;
    private JLabel platformHintLabel;
    private JButton platformManageButton;
    private JComboBox platformsComboBox;
    private JLabel platformsLabel;
    private BindingGroup bindingGroup;

    public JavaScriptNashornPanel(JavaScriptNashornOptionsPanelController optionsController) {
        this.optionsController = optionsController;
        this.initComponents();
        this.platformsComboBox.setModel(new NashornPlatformComboBoxModel());
        this.platformsComboBox.addActionListener(new PlatformChangeListener());
        this.setFieldsEnabled();
    }

    private void initComponents() {
        this.bindingGroup = new BindingGroup();
        this.infoLabel = new JLabel();
        this.platformsLabel = new JLabel();
        this.platformsComboBox = new JComboBox();
        this.engineOptionsLabel = new JLabel();
        this.engineOptionsTextField = new JTextField();
        this.platformHintLabel = new JLabel();
        this.argumentsLabel = new JLabel();
        this.argumentsTextField = new JTextField();
        this.platformManageButton = new JButton();
        this.fillPanel = new JPanel();
        this.setLayout(new GridBagLayout());
        Mnemonics.setLocalizedText((JLabel)this.infoLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.infoLabel.text"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        this.add((Component)this.infoLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.platformsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformsLabel.text"));
        AutoBinding binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.platformsComboBox, (Property)ObjectProperty.create(), (Object)this.platformsLabel, (Property)BeanProperty.create((String)"labelFor"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(17, 0, 0, 0);
        this.add((Component)this.platformsLabel, gridBagConstraints);
        this.platformsComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptNashornPanel.this.platformsComboBoxActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 284;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 24, 0, 0);
        this.add((Component)this.platformsComboBox, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.engineOptionsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.engineOptionsLabel.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.engineOptionsTextField, (Property)ObjectProperty.create(), (Object)this.engineOptionsLabel, (Property)BeanProperty.create((String)"labelFor"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(14, 0, 0, 0);
        this.add((Component)this.engineOptionsLabel, gridBagConstraints);
        this.engineOptionsTextField.setText(NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.engineOptionsTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 312;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(12, 24, 0, 0);
        this.add((Component)this.engineOptionsTextField, gridBagConstraints);
        this.platformHintLabel.setFont(this.platformHintLabel.getFont().deriveFont((float)this.platformHintLabel.getFont().getSize() - 1.0f));
        Mnemonics.setLocalizedText((JLabel)this.platformHintLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformHintLabel.text"));
        this.platformHintLabel.setEnabled(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 6;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 329;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 24, 0, 0);
        this.add((Component)this.platformHintLabel, gridBagConstraints);
        Mnemonics.setLocalizedText((JLabel)this.argumentsLabel, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.argumentsLabel.text"));
        binding = Bindings.createAutoBinding((AutoBinding.UpdateStrategy)AutoBinding.UpdateStrategy.READ_WRITE, (Object)this.argumentsTextField, (Property)ObjectProperty.create(), (Object)this.argumentsLabel, (Property)BeanProperty.create((String)"labelFor"));
        this.bindingGroup.addBinding((Binding)binding);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(8, 0, 0, 0);
        this.add((Component)this.argumentsLabel, gridBagConstraints);
        this.argumentsTextField.setText(NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.argumentsTextField.text"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 3;
        gridBagConstraints.gridy = 7;
        gridBagConstraints.gridwidth = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.ipadx = 312;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.insets = new Insets(6, 24, 172, 0);
        this.add((Component)this.argumentsTextField, gridBagConstraints);
        Mnemonics.setLocalizedText((AbstractButton)this.platformManageButton, (String)NbBundle.getMessage(JavaScriptNashornPanel.class, (String)"JavaScriptNashornPanel.platformManageButton.text"));
        this.platformManageButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                JavaScriptNashornPanel.this.platformManageButtonActionPerformed(evt);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 8;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.insets = new Insets(12, 12, 0, 0);
        this.add((Component)this.platformManageButton, gridBagConstraints);
        this.fillPanel.setMinimumSize(new Dimension(0, 0));
        this.fillPanel.setLayout(null);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 8;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 15;
        gridBagConstraints.weightx = 0.1;
        gridBagConstraints.weighty = 0.1;
        this.add((Component)this.fillPanel, gridBagConstraints);
        this.bindingGroup.bind();
    }

    private void platformManageButtonActionPerformed(ActionEvent evt) {
        PlatformsCustomizer.showCustomizer(null);
    }

    private void platformsComboBoxActionPerformed(ActionEvent evt) {
        this.setFieldsEnabled();
    }

    private JavaPlatform getSelectedPlatform() {
        Object selObj = this.platformsComboBox.getSelectedItem();
        if (selObj == null) {
            return null;
        }
        return PlatformUiSupport.getPlatform((Object)selObj);
    }

    private void selectPlatform(JavaPlatform platform) {
        int n = this.platformsComboBox.getItemCount();
        for (int i = 0; i < n; ++i) {
            Object obj = this.platformsComboBox.getItemAt(i);
            JavaPlatform p = PlatformUiSupport.getPlatform(obj);
            if (!platform.equals(p)) continue;
            this.platformsComboBox.setSelectedIndex(i);
            return;
        }
    }

    void load() {
        JavaPlatform njp = NashornPlatform.getDefault().getPlatform();
        if (njp != null) {
            this.selectPlatform(njp);
        }
        String options = Settings.getPreferences().get("nashornEngineOptions", null);
        String arguments = Settings.getPreferences().get("nashornScriptArguments", null);
        this.engineOptionsTextField.setText(options != null ? options : "");
        this.argumentsTextField.setText(arguments != null ? arguments : "");
    }

    void store() {
        NashornPlatform.getDefault().setPlatform(this.getSelectedPlatform());
        String options = this.engineOptionsTextField.getText().trim();
        if (options.isEmpty()) {
            Settings.getPreferences().remove("nashornEngineOptions");
        } else {
            Settings.getPreferences().put("nashornEngineOptions", options);
        }
        String arguments = this.argumentsTextField.getText().trim();
        if (arguments.isEmpty()) {
            Settings.getPreferences().remove("nashornScriptArguments");
        } else {
            Settings.getPreferences().put("nashornScriptArguments", arguments);
        }
    }

    boolean valid() {
        return true;
    }

    boolean isChanged() {
        if (NashornPlatform.getDefault().getPlatform() != this.getSelectedPlatform()) {
            return true;
        }
        if (!this.engineOptionsTextField.getText().trim().equals(Settings.getPreferences().get("nashornEngineOptions", ""))) {
            return true;
        }
        return !this.argumentsTextField.getText().trim().equals(Settings.getPreferences().get("nashornScriptArguments", ""));
    }

    private void setFieldsEnabled() {
        boolean enabled = this.getSelectedPlatform() != null;
        this.engineOptionsTextField.setEnabled(enabled);
        this.argumentsTextField.setEnabled(enabled);
    }

    private class PlatformChangeListener
    implements ActionListener {
        private PlatformChangeListener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JavaScriptNashornPanel.this.optionsController.changed();
        }
    }
}

