/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.profiler;

import java.awt.BorderLayout;
import java.awt.Component;
import java.lang.management.LockInfo;
import java.lang.management.MonitorInfo;
import java.lang.management.ThreadInfo;
import java.net.URL;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JScrollPane;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.EditorKit;
import javax.swing.text.Segment;
import javax.swing.text.html.HTMLDocument;
import javax.swing.text.html.HTMLEditorKit;
import javax.swing.text.html.StyleSheet;
import org.netbeans.lib.profiler.results.threads.ThreadDump;
import org.netbeans.lib.profiler.ui.components.HTMLTextArea;
import org.netbeans.lib.profiler.utils.StringUtils;
import org.netbeans.modules.profiler.Bundle;
import org.netbeans.modules.profiler.ProfilerTopComponent;
import org.netbeans.modules.profiler.api.GoToSource;
import org.netbeans.modules.profiler.api.icons.Icons;
import org.openide.util.HelpCtx;

public class ThreadDumpWindow
extends ProfilerTopComponent {
    private static final String HELP_CTX_KEY = "ThreadDumpWindow.HelpCtx";
    private static final HelpCtx HELP_CTX = new HelpCtx("ThreadDumpWindow.HelpCtx");

    public ThreadDumpWindow() {
        throw new InternalError("This constructor should never be called");
    }

    public ThreadDumpWindow(ThreadDump td) {
        this.setLayout(new BorderLayout());
        this.setFocusable(true);
        this.setRequestFocusEnabled(true);
        this.setName(Bundle.ThreadDumpWindow_Caption(StringUtils.formatUserDate((Date)td.getTime())));
        this.setIcon(Icons.getImage((String)"ProfilerIcons.Thread"));
        StringBuilder text = new StringBuilder();
        this.printThreads(text, td);
        HTMLTextArea a = new HTMLTextArea(){

            protected void showURL(URL url) {
                if (url == null) {
                    return;
                }
                String urls = url.toString();
                ThreadDumpWindow.this.showURL(urls);
            }
        };
        a.setEditorKit((EditorKit)new CustomHtmlEditorKit());
        a.setText(text.toString());
        a.setCaretPosition(0);
        JScrollPane sp = new JScrollPane((Component)a);
        sp.setBorder(BorderFactory.createEmptyBorder());
        sp.setViewportBorder(BorderFactory.createEmptyBorder());
        this.add(sp, "Center");
    }

    public int getPersistenceType() {
        return 2;
    }

    public HelpCtx getHelpCtx() {
        return HELP_CTX;
    }

    protected String preferredID() {
        return ((Object)((Object)this)).getClass().getName();
    }

    private void printThreads(StringBuilder sb, ThreadDump td) {
        ThreadInfo[] threads = td.getThreads();
        boolean goToSourceAvailable = GoToSource.isAvailable();
        boolean jdk15 = td.isJDK15();
        sb.append("<pre>");
        sb.append(" <b>Full thread dump: ");
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        sb.append(df.format(td.getTime()) + "</b><br><br>");
        for (ThreadInfo thread : threads) {
            if (thread == null) continue;
            if (jdk15) {
                this.print15Thread(sb, thread, goToSourceAvailable);
                continue;
            }
            this.print16Thread(sb, thread, goToSourceAvailable);
        }
        sb.append("</pre>");
    }

    private void print15Thread(StringBuilder sb, ThreadInfo thread, boolean goToSourceAvailable) {
        sb.append("<br>\"" + thread.getThreadName() + "\" - Thread t@" + thread.getThreadId() + "<br>");
        sb.append("   java.lang.Thread.State: " + (Object)((Object)thread.getThreadState()));
        if (thread.getLockName() != null) {
            sb.append(" on " + thread.getLockName());
            if (thread.getLockOwnerName() != null) {
                sb.append(" owned by: " + thread.getLockOwnerName());
            }
        }
        sb.append("<br>");
        for (StackTraceElement st : thread.getStackTrace()) {
            String stackElementText;
            String stackEl = stackElementText = ThreadDumpWindow.htmlize(st.toString());
            if (goToSourceAvailable) {
                String className = st.getClassName();
                String method = st.getMethodName();
                int lineNo = st.getLineNumber();
                String stackUrl = "file:/stackframe/" + className + "|" + method + "|" + lineNo;
                stackEl = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
            }
            sb.append("        at ").append(stackEl).append("<br>");
        }
    }

    private void print16Thread(StringBuilder sb, ThreadInfo thread, boolean goToSourceAvailable) {
        LockInfo[] synchronizers;
        MonitorInfo[] monitors = thread.getLockedMonitors();
        sb.append("&nbsp;<b>");
        sb.append("\"").append(thread.getThreadName()).append("\" - Thread t@").append(thread.getThreadId()).append("<br>");
        sb.append("    java.lang.Thread.State: ").append((Object)thread.getThreadState());
        sb.append("</b><br>");
        int index = 0;
        for (StackTraceElement st : thread.getStackTrace()) {
            LockInfo lock = thread.getLockInfo();
            String stackElementText = ThreadDumpWindow.htmlize(st.toString());
            String lockOwner = thread.getLockOwnerName();
            String stackEl = stackElementText;
            if (goToSourceAvailable) {
                String className = st.getClassName();
                String method = st.getMethodName();
                int lineNo = st.getLineNumber();
                String stackUrl = "file:/stackframe/" + className + "|" + method + "|" + lineNo;
                stackEl = "<a href=\"" + stackUrl + "\">" + stackElementText + "</a>";
            }
            sb.append("    at ").append(stackEl).append("<br>");
            if (index == 0) {
                if ("java.lang.Object".equals(st.getClassName()) && "wait".equals(st.getMethodName())) {
                    if (lock != null) {
                        sb.append("    - waiting on ");
                        this.printLock(sb, lock);
                        sb.append("<br>");
                    }
                } else if (lock != null) {
                    if (lockOwner == null) {
                        sb.append("    - parking to wait for ");
                        this.printLock(sb, lock);
                        sb.append("<br>");
                    } else {
                        sb.append("    - waiting to lock ");
                        this.printLock(sb, lock);
                        sb.append(" owned by \"").append(lockOwner).append("\" t@").append(thread.getLockOwnerId()).append("<br>");
                    }
                }
            }
            this.printMonitors(sb, monitors, index);
            ++index;
        }
        StringBuilder jnisb = new StringBuilder();
        this.printMonitors(jnisb, monitors, -1);
        if (jnisb.length() > 0) {
            sb.append("   JNI locked monitors:<br>");
            sb.append((CharSequence)jnisb);
        }
        if ((synchronizers = thread.getLockedSynchronizers()) != null) {
            sb.append("<br>   Locked ownable synchronizers:");
            if (synchronizers.length == 0) {
                sb.append("<br>    - None\n");
            } else {
                for (LockInfo li : synchronizers) {
                    sb.append("<br>    - locked ");
                    this.printLock(sb, li);
                    sb.append("<br>");
                }
            }
        }
        sb.append("<br>");
    }

    private void printMonitors(StringBuilder sb, MonitorInfo[] monitors, int index) {
        if (monitors != null) {
            for (MonitorInfo mi : monitors) {
                if (mi.getLockedStackDepth() != index) continue;
                sb.append("    - locked ");
                this.printLock(sb, mi);
                sb.append("<br>");
            }
        }
    }

    private void printLock(StringBuilder sb, LockInfo lock) {
        String id = Integer.toHexString(lock.getIdentityHashCode());
        String className = lock.getClassName();
        sb.append("&lt;").append(id).append("&gt; (a ").append(className).append(")");
    }

    private static String htmlize(String value) {
        return value.replace(">", "&gt;").replace("<", "&lt;");
    }

    private void showURL(String urls) {
        if (urls.startsWith("file:/stackframe/")) {
            urls = urls.substring("file:/stackframe/".length());
            String[] parts = urls.split("\\|");
            String className = parts[0];
            String method = parts[1];
            int linenumber = Integer.parseInt(parts[2]);
            GoToSource.openSource(null, (String)className, (String)method, (int)linenumber);
        }
    }

    private class CustomHTMLDocument
    extends HTMLDocument {
        private static final int CACHE_BOUNDARY = 1000;
        private char[] segArray;
        private int segOffset;
        private int segCount;
        private boolean segPartialReturn;
        private int lastOffset;
        private int lastLength;

        private CustomHTMLDocument(StyleSheet ss) {
            super(ss);
            this.lastOffset = -1;
            this.lastLength = -1;
            this.putProperty("multiByte", Boolean.TRUE);
        }

        @Override
        public void getText(int offset, int length, Segment txt) throws BadLocationException {
            if (this.lastOffset == offset && this.lastLength == length) {
                txt.array = this.segArray;
                txt.offset = this.segOffset;
                txt.count = this.segCount;
                txt.setPartialReturn(this.segPartialReturn);
                return;
            }
            super.getText(offset, length, txt);
            if (length > 1000 || this.lastLength <= 1000) {
                this.segArray = txt.array;
                this.segOffset = txt.offset;
                this.segCount = txt.count;
                this.segPartialReturn = txt.isPartialReturn();
                this.lastOffset = offset;
                this.lastLength = length;
            }
        }
    }

    private class CustomHtmlEditorKit
    extends HTMLEditorKit {
        private CustomHtmlEditorKit() {
        }

        @Override
        public Document createDefaultDocument() {
            StyleSheet styles = this.getStyleSheet();
            StyleSheet ss = new StyleSheet();
            ss.addStyleSheet(styles);
            CustomHTMLDocument doc = new CustomHTMLDocument(ss);
            doc.setParser(this.getParser());
            doc.setAsynchronousLoadPriority(4);
            doc.setTokenThreshold(100);
            return doc;
        }
    }
}

