/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.java.j2seproject;

import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.event.ChangeListener;
import org.apache.tools.ant.module.api.support.ActionUtils;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.java.source.BuildArtifactMapper;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.java.api.common.SourceRoots;
import org.netbeans.modules.java.api.common.ant.UpdateHelper;
import org.netbeans.modules.java.api.common.project.BaseActionProvider;
import org.netbeans.modules.java.api.common.project.ProjectConfigurations;
import org.netbeans.modules.java.j2seproject.J2SEProject;
import org.netbeans.modules.java.j2seproject.J2SEProjectUtil;
import org.netbeans.modules.java.j2seproject.api.J2SEBuildPropertiesProvider;
import org.netbeans.modules.java.preprocessorbridge.spi.CompileOnSaveAction;
import org.netbeans.spi.project.ActionProvider;
import org.netbeans.spi.project.support.ant.PropertyEvaluator;
import org.openide.execution.ExecutorTask;
import org.openide.filesystems.FileLock;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.modules.Places;
import org.openide.util.BaseUtilities;
import org.openide.util.ChangeSupport;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;
import org.openide.util.RequestProcessor;
import org.openide.util.WeakListeners;

public class J2SEActionProvider
extends BaseActionProvider {
    private static final Logger LOG = Logger.getLogger(J2SEActionProvider.class.getName());
    private static final String[] supportedActions = new String[]{"build", "clean", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto", "delete", "copy", "move", "rename"};
    private static final String[] platformSensitiveActions = new String[]{"build", "rebuild", "compile.single", "run", "run.single", "debug", "debug.single", "profile", "profile.single", "javadoc", "test", "test.single", "debug.test.single", "profile.test.single", "run.single.method", "debug.single.method", "debug.fix", "debug.stepinto"};
    private static final String[] actionsDisabledForQuickRun = new String[]{"compile.single", "debug.fix"};
    private final CosAction cosAction;
    private Map<String, String[]> commands = new HashMap<String, String[]>();
    private Set<String> bkgScanSensitiveActions;
    private Set<String> needJavaModelActions;

    public J2SEActionProvider(J2SEProject project, UpdateHelper updateHelper) {
        super((Project)project, updateHelper, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots(), project.getAntProjectHelper(), (BaseActionProvider.Callback)new CallbackImpl(project));
        this.commands.put("clean", new String[]{"clean"});
        this.commands.put("compile.single", new String[]{"compile-single"});
        this.commands.put("run", new String[]{"run"});
        this.commands.put("run.single", new String[]{"run-single"});
        this.commands.put("debug", new String[]{"debug"});
        this.commands.put("debug.single", new String[]{"debug-single"});
        this.commands.put("profile", new String[]{"profile"});
        this.commands.put("profile.single", new String[]{"profile-single"});
        this.commands.put("javadoc", new String[]{"javadoc"});
        this.commands.put("test", new String[]{"test"});
        this.commands.put("test.single", new String[]{"test-single"});
        this.commands.put("debug.test.single", new String[]{"debug-test"});
        this.commands.put("profile.test.single", new String[]{"profile-test"});
        this.commands.put("debug.fix", new String[]{"debug-fix"});
        this.commands.put("debug.stepinto", new String[]{"debug-stepinto"});
        this.bkgScanSensitiveActions = new HashSet<String>(Arrays.asList("run", "run.single", "debug", "debug.single", "debug.stepinto"));
        this.needJavaModelActions = new HashSet<String>(Arrays.asList("debug.fix"));
        this.cosAction = new CosAction(this, project.evaluator(), project.getSourceRoots(), project.getTestSourceRoots());
    }

    protected String[] getPlatformSensitiveActions() {
        return platformSensitiveActions;
    }

    protected String[] getActionsDisabledForQuickRun() {
        return actionsDisabledForQuickRun;
    }

    public Map<String, String[]> getCommands() {
        return this.commands;
    }

    protected Set<String> getScanSensitiveActions() {
        return this.bkgScanSensitiveActions;
    }

    protected Set<String> getJavaModelActions() {
        return this.needJavaModelActions;
    }

    protected boolean isCompileOnSaveEnabled() {
        return this.isCompileOnSaveUpdate() && this.cosAction.getTarget() == null;
    }

    protected boolean isCompileOnSaveUpdate() {
        return J2SEProjectUtil.isCompileOnSaveEnabled((J2SEProject)this.getProject());
    }

    public String[] getSupportedActions() {
        return supportedActions;
    }

    public String[] getTargetNames(String command, Lookup context, Properties p, boolean doJavaChecks) throws IllegalArgumentException {
        String[] names = super.getTargetNames(command, context, p, doJavaChecks);
        ProjectConfigurations.Configuration c = (ProjectConfigurations.Configuration)context.lookup(ProjectConfigurations.Configuration.class);
        if (c != null) {
            String config = !c.isDefault() ? c.getName() : "";
            p.setProperty("config", config);
        }
        return names;
    }

    public static J2SEActionProvider create(@NonNull Lookup lkp) {
        Parameters.notNull((CharSequence)"lkp", (Object)lkp);
        J2SEProject project = (J2SEProject)lkp.lookup(J2SEProject.class);
        J2SEActionProvider j2seActionProvider = new J2SEActionProvider(project, project.getUpdateHelper());
        j2seActionProvider.startFSListener();
        return j2seActionProvider;
    }

    public static final class Provider
    implements CompileOnSaveAction.Provider {
        public CompileOnSaveAction forRoot(URL root) {
            try {
                Project p = FileOwnerQuery.getOwner((URI)root.toURI());
                if (p != null) {
                    ActionProvider prov = (ActionProvider)p.getLookup().lookup(ActionProvider.class);
                    if (prov != null) {
                        prov.getSupportedActions();
                    }
                    CosAction action = CosAction.getInstance(p);
                    return action;
                }
            }
            catch (URISyntaxException e) {
                Exceptions.printStackTrace((Throwable)e);
            }
            return null;
        }
    }

    private static final class CosAction
    implements BuildArtifactMapper.ArtifactsUpdated,
    CompileOnSaveAction,
    PropertyChangeListener {
        private static Map<Project, Reference<CosAction>> instances = new WeakHashMap<Project, Reference<CosAction>>();
        private static final String COS_UPDATED = "$cos.update";
        private static final String COS_CUSTOM = "$cos.update.resources";
        private static final String PROP_TARGET = "cos.update.target.internal";
        private static final String PROP_SCRIPT = "cos.update.script.internal";
        private static final String PROP_SRCDIR = "cos.src.dir.internal";
        private static final String PROP_INCLUDES = "cos.includes.internal";
        private static final String SNIPPETS = "executor-snippets";
        private static final String SCRIPT = "cos-update.xml";
        private static final String TARGET = "cos-update-internal";
        private static final String SCRIPT_TEMPLATE = "/org/netbeans/modules/java/j2seproject/resources/cos-update-snippet.xml";
        private static final Object NONE = new Object();
        private static final RequestProcessor RUNNER = new RequestProcessor(CosAction.class);
        private final J2SEActionProvider owner;
        private final PropertyEvaluator eval;
        private final SourceRoots src;
        private final SourceRoots tests;
        private final BuildArtifactMapper mapper;
        private final Map<URL, BuildArtifactMapper.ArtifactsUpdated> currentListeners;
        private final ChangeSupport cs;
        private volatile Object targetCache;
        private volatile Object updatedFSProp;

        private CosAction(@NonNull J2SEActionProvider owner, @NonNull PropertyEvaluator eval, @NonNull SourceRoots src, @NonNull SourceRoots tests) {
            this.owner = owner;
            this.eval = eval;
            this.src = src;
            this.tests = tests;
            this.mapper = new BuildArtifactMapper();
            this.currentListeners = new HashMap<URL, BuildArtifactMapper.ArtifactsUpdated>();
            this.cs = new ChangeSupport((Object)this);
            this.eval.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.eval));
            this.src.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.src));
            this.tests.addPropertyChangeListener(WeakListeners.propertyChange((PropertyChangeListener)this, (Object)this.tests));
            this.updateRootsListeners();
            instances.put(owner.getProject(), new WeakReference<CosAction>(this));
        }

        public boolean isEnabled() {
            return this.getTarget() != null && this.isCustomUpdate();
        }

        public boolean isUpdateClasses() {
            return this.isEnabled();
        }

        public boolean isUpdateResources() {
            return this.isEnabled();
        }

        public Boolean performAction(CompileOnSaveAction.Context ctx) throws IOException {
            switch (ctx.getOperation()) {
                case UPDATE: {
                    return this.performUpdate(ctx);
                }
                case CLEAN: {
                    return this.performClean(ctx);
                }
                case SYNC: {
                    return this.performSync(ctx);
                }
            }
            throw new IllegalArgumentException(String.valueOf(ctx.getOperation()));
        }

        public void artifactsUpdated(@NonNull Iterable<File> artifacts) {
            FileObject buildXml;
            String target;
            if (!this.isCustomUpdate() && (target = this.getTarget()) != null && (buildXml = this.owner.findBuildXml()) != null) {
                try {
                    ActionUtils.runTarget((FileObject)buildXml, (String[])new String[]{target}, null, null);
                }
                catch (IOException ioe) {
                    LOG.log(Level.WARNING, "Cannot execute pos compile on save target: {0} in: {1}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml)});
                }
            }
        }

        @Override
        public void propertyChange(@NonNull PropertyChangeEvent evt) {
            String name = evt.getPropertyName();
            if (name == null) {
                this.targetCache = null;
                this.updatedFSProp = null;
                this.cs.fireChange();
            } else if (COS_UPDATED.equals(name)) {
                this.targetCache = null;
                this.cs.fireChange();
            } else if (COS_CUSTOM.equals(name)) {
                this.updatedFSProp = null;
                this.cs.fireChange();
            } else if (SourceRoots.PROP_ROOTS.equals(name)) {
                this.updateRootsListeners();
            }
        }

        public void addChangeListener(@NonNull ChangeListener listener) {
            this.cs.addChangeListener(listener);
        }

        public void removeChangeListner(@NonNull ChangeListener listener) {
            this.cs.removeChangeListener(listener);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateRootsListeners() {
            HashSet newRoots = new HashSet();
            Collections.addAll(newRoots, this.src.getRootURLs());
            Collections.addAll(newRoots, this.tests.getRootURLs());
            CosAction cosAction = this;
            synchronized (cosAction) {
                BuildArtifactMapper.ArtifactsUpdated l;
                HashSet<URL> toRemove = new HashSet<URL>(this.currentListeners.keySet());
                toRemove.removeAll(newRoots);
                newRoots.removeAll(this.currentListeners.keySet());
                for (URL u : toRemove) {
                    l = this.currentListeners.remove(u);
                    BuildArtifactMapper.removeArtifactsUpdatedListener((URL)u, (BuildArtifactMapper.ArtifactsUpdated)l);
                }
                for (URL u : newRoots) {
                    l = new WeakArtifactUpdated(this, this.mapper, u);
                    this.currentListeners.put(u, l);
                    BuildArtifactMapper.addArtifactsUpdatedListener((URL)u, (BuildArtifactMapper.ArtifactsUpdated)l);
                }
            }
        }

        @CheckForNull
        private String getTarget() {
            Object target = this.targetCache;
            if (target == null) {
                String val = this.eval.getProperty(COS_UPDATED);
                this.targetCache = val != null && !val.isEmpty() ? val : NONE;
                target = this.targetCache;
            }
            if (target == NONE) {
                return null;
            }
            return this.owner.isCompileOnSaveUpdate() ? (String)target : null;
        }

        @CheckForNull
        private String getUpdatedFileSetProperty() {
            Object res = this.updatedFSProp;
            if (res == null) {
                String val = this.eval.getProperty(COS_CUSTOM);
                this.updatedFSProp = val != null && !val.isEmpty() ? val : NONE;
                res = this.updatedFSProp;
            }
            if (res == NONE) {
                res = null;
            }
            return (String)res;
        }

        private boolean isCustomUpdate() {
            return this.getUpdatedFileSetProperty() != null;
        }

        @CheckForNull
        private Boolean performUpdate(@NonNull CompileOnSaveAction.Context ctx) {
            FileObject buildXml;
            String target = this.getTarget();
            if (target != null && (buildXml = this.owner.findBuildXml()) != null) {
                try {
                    FileObject cosScript = this.getCosScript();
                    Iterable updated = ctx.getUpdated();
                    Iterable deleted = ctx.getDeleted();
                    File root = ctx.isCopyResources() ? BaseUtilities.toFile((URI)ctx.getSourceRoot().toURI()) : ctx.getCacheRoot();
                    String includes = CosAction.createIncludes(root, updated);
                    if (includes != null) {
                        Properties props = new Properties();
                        props.setProperty(PROP_TARGET, target);
                        props.setProperty(PROP_SCRIPT, FileUtil.toFile((FileObject)buildXml).getAbsolutePath());
                        props.setProperty(PROP_SRCDIR, root.getAbsolutePath());
                        props.setProperty(PROP_INCLUDES, includes);
                        props.setProperty(COS_CUSTOM, this.getUpdatedFileSetProperty());
                        RUNNER.execute(() -> {
                            try {
                                ExecutorTask task = ActionUtils.runTarget((FileObject)cosScript, (String[])new String[]{TARGET}, (Properties)props, null);
                                task.result();
                            }
                            catch (IOException | IllegalArgumentException ex) {
                                LOG.log(Level.WARNING, "Cannot execute update targer: {0} in: {1} due to: {2}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml), ex.getMessage()});
                            }
                        });
                    } else {
                        LOG.warning("BuildArtifactMapper artifacts do not provide attributes.");
                    }
                }
                catch (IOException | URISyntaxException e) {
                    LOG.log(Level.WARNING, "Cannot execute update targer: {0} in: {1} due to: {2}", new Object[]{target, FileUtil.getFileDisplayName((FileObject)buildXml), e.getMessage()});
                }
            }
            return true;
        }

        @CheckForNull
        private Boolean performClean(@NonNull CompileOnSaveAction.Context ctx) {
            return null;
        }

        @CheckForNull
        private Boolean performSync(@NonNull CompileOnSaveAction.Context ctx) {
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @NonNull
        private FileObject getCosScript() throws IOException {
            FileObject snippets = FileUtil.createFolder((File)Places.getCacheSubdirectory((String)SNIPPETS));
            FileObject cosScript = snippets.getFileObject(SCRIPT);
            if (cosScript == null) {
                cosScript = FileUtil.createData((FileObject)snippets, (String)SCRIPT);
                FileLock lock = cosScript.lock();
                try (InputStream in = this.getClass().getResourceAsStream(SCRIPT_TEMPLATE);
                     OutputStream out = cosScript.getOutputStream(lock);){
                    FileUtil.copy((InputStream)in, (OutputStream)out);
                }
                finally {
                    lock.releaseLock();
                }
            }
            return cosScript;
        }

        @CheckForNull
        private static String createIncludes(@NonNull File root, @NonNull Iterable<? extends File> artifacts) {
            StringBuilder include = new StringBuilder();
            for (File file : artifacts) {
                if (include.length() > 0) {
                    include.append(',');
                }
                include.append(CosAction.relativize(file, root));
            }
            return include.length() == 0 ? null : include.toString();
        }

        private static String relativize(@NonNull File file, @NonNull File folder) {
            String folderPath = folder.getAbsolutePath();
            int start = folderPath.length();
            if (!folderPath.endsWith(File.separator)) {
                ++start;
            }
            return file.getAbsolutePath().substring(start);
        }

        @CheckForNull
        static CosAction getInstance(@NonNull Project p) {
            Reference<CosAction> r = instances.get(p);
            return r != null ? r.get() : null;
        }

        private static final class WeakArtifactUpdated
        extends WeakReference<BuildArtifactMapper.ArtifactsUpdated>
        implements BuildArtifactMapper.ArtifactsUpdated,
        Runnable {
            private final BuildArtifactMapper source;
            private final URL url;

            WeakArtifactUpdated(@NonNull BuildArtifactMapper.ArtifactsUpdated delegate, @NonNull BuildArtifactMapper source, @NonNull URL url) {
                super(delegate);
                Parameters.notNull((CharSequence)"source", (Object)source);
                Parameters.notNull((CharSequence)"url", (Object)url);
                this.source = source;
                this.url = url;
            }

            public void artifactsUpdated(@NonNull Iterable<File> artifacts) {
                BuildArtifactMapper.ArtifactsUpdated delegate = (BuildArtifactMapper.ArtifactsUpdated)this.get();
                if (delegate != null) {
                    delegate.artifactsUpdated(artifacts);
                }
            }

            @Override
            public void run() {
                BuildArtifactMapper.removeArtifactsUpdatedListener((URL)this.url, (BuildArtifactMapper.ArtifactsUpdated)this);
            }
        }
    }

    private static final class CallbackImpl
    implements BaseActionProvider.Callback3 {
        private final J2SEProject prj;

        CallbackImpl(@NonNull J2SEProject project) {
            Parameters.notNull((CharSequence)"project", (Object)project);
            this.prj = project;
        }

        @NonNull
        public Map<String, String> createAdditionalProperties(@NonNull String command, @NonNull Lookup context) {
            HashMap<String, String> result = new HashMap<String, String>();
            for (J2SEBuildPropertiesProvider bpp : this.prj.getLookup().lookupAll(J2SEBuildPropertiesProvider.class)) {
                Map<String, String> contrib = bpp.createAdditionalProperties(command, context);
                assert (contrib != null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following build properties: {1}", new Object[]{bpp.getClass(), contrib});
                }
                result.putAll(contrib);
            }
            return Collections.unmodifiableMap(result);
        }

        public Set<String> createConcealedProperties(String command, Lookup context) {
            HashSet<String> result = new HashSet<String>();
            for (J2SEBuildPropertiesProvider bpp : this.prj.getLookup().lookupAll(J2SEBuildPropertiesProvider.class)) {
                Set<String> contrib = bpp.createConcealedProperties(command, context);
                assert (contrib != null);
                if (LOG.isLoggable(Level.FINE)) {
                    LOG.log(Level.FINE, "J2SEBuildPropertiesProvider: {0} added following concealed properties: {1}", new Object[]{bpp.getClass(), contrib});
                }
                result.addAll(contrib);
            }
            return Collections.unmodifiableSet(result);
        }

        public void antTargetInvocationStarted(@NonNull String command, @NonNull Lookup context) {
        }

        public void antTargetInvocationFinished(@NonNull String command, @NonNull Lookup context, int result) {
        }

        public void antTargetInvocationFailed(@NonNull String command, @NonNull Lookup context) {
        }

        @CheckForNull
        public ClassPath getProjectSourcesClassPath(@NonNull String type) {
            return this.prj.getClassPathProvider().getProjectSourcesClassPath(type);
        }

        @CheckForNull
        public ClassPath findClassPath(@NonNull FileObject file, @NonNull String type) {
            return this.prj.getClassPathProvider().findClassPath(file, type);
        }
    }
}

