/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.maven.problems;

import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.WeakHashMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectManager;
import org.netbeans.modules.maven.NbMavenProjectImpl;
import org.netbeans.modules.maven.api.FileUtilities;
import org.netbeans.modules.maven.api.NbMavenProject;
import org.netbeans.modules.maven.api.execute.RunUtils;
import org.netbeans.modules.maven.configurations.M2ConfigProvider;
import org.netbeans.modules.maven.configurations.M2Configuration;
import org.netbeans.modules.maven.execute.BeanRunConfig;
import org.netbeans.modules.maven.execute.ReactorChecker;
import org.netbeans.modules.maven.problems.Bundle;
import org.netbeans.modules.maven.problems.ProblemReporterImpl;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;

public class BatchProblemNotifier {
    private static final Logger LOG = Logger.getLogger(BatchProblemNotifier.class.getName());
    private static final Map<File, Reactor> reactors = new HashMap<File, Reactor>();
    private static final Map<NbMavenProjectImpl, File> roots = new WeakHashMap<NbMavenProjectImpl, File>();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void opened(NbMavenProjectImpl p) {
        ProblemReporterImpl pr = p.getProblemReporter();
        Set<File> missingArtifacts = pr.getMissingArtifactFiles();
        if (!missingArtifacts.isEmpty()) {
            HashSet<File> files = new HashSet<File>();
            for (File file : missingArtifacts) {
                if (file == null) continue;
                files.add(file);
            }
            File root = ReactorChecker.findReactor(p.getProjectWatcher()).getMavenProject().getBasedir();
            Map<NbMavenProjectImpl, File> map = roots;
            synchronized (map) {
                roots.put(p, root);
            }
            File file = p.getPOMFile().getParentFile();
            String path = FileUtilities.relativizeFile(root, file);
            if (path == null) {
                path = file.getAbsolutePath();
            }
            Map<File, Reactor> map2 = reactors;
            synchronized (map2) {
                Reactor reactor = reactors.get(root);
                if (reactor == null) {
                    reactor = new Reactor(root);
                    reactors.put(root, reactor);
                }
                reactor.register(path, files);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void closed(NbMavenProjectImpl p) {
        File root;
        Map<NbMavenProjectImpl, File> map = roots;
        synchronized (map) {
            root = roots.remove(p);
        }
        if (root == null) {
            return;
        }
        File basedir = p.getPOMFile().getParentFile();
        String path = FileUtilities.relativizeFile(root, basedir);
        if (path == null) {
            path = basedir.getAbsolutePath();
        }
        Map<File, Reactor> map2 = reactors;
        synchronized (map2) {
            Reactor reactor = reactors.get(root);
            if (reactor != null) {
                reactor.unregister(path);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void resolved(File f) {
        Map<File, Reactor> map = reactors;
        synchronized (map) {
            for (Reactor reactor : new ArrayList<Reactor>(reactors.values())) {
                reactor.resolved(f);
            }
        }
    }

    private static void showUI(File reactor, Set<String> projects) {
        BeanRunConfig cfg = new BeanRunConfig();
        String label = Bundle.build_label(reactor.getName());
        cfg.setExecutionName(label);
        cfg.setTaskDisplayName(label);
        cfg.setExecutionDirectory(reactor);
        NbMavenProject mavenPrj = null;
        try {
            Project reactorP;
            FileObject reactorFO = FileUtil.toFileObject((File)reactor);
            if (reactorFO != null && reactorFO.isFolder() && (reactorP = ProjectManager.getDefault().findProject(reactorFO)) != null) {
                mavenPrj = (NbMavenProject)reactorP.getLookup().lookup(NbMavenProject.class);
                cfg.setProject(reactorP);
                M2Configuration m2c = ((M2ConfigProvider)reactorP.getLookup().lookup(M2ConfigProvider.class)).getActiveConfiguration();
                if (m2c != null) {
                    cfg.setActivatedProfiles(m2c.getActivatedProfiles());
                }
            }
        }
        catch (IOException x) {
            LOG.log(Level.FINE, null, x);
        }
        StringBuilder pl = new StringBuilder();
        for (String project : projects) {
            if (pl.length() > 0) {
                pl.append(',');
            }
            pl.append(project);
        }
        if (mavenPrj != null && mavenPrj.getMavenProject().getVersion() != null && mavenPrj.getMavenProject().getVersion().endsWith("SNAPSHOT")) {
            cfg.setGoals(Arrays.asList("--fail-at-end", "--also-make", "--projects", pl.toString(), "install"));
        } else {
            cfg.setGoals(Arrays.asList("--fail-at-end", "--also-make", "--projects", pl.toString(), "package"));
        }
        cfg.setUpdateSnapshots(true);
        cfg.setProperty("skipTests", "true");
        RunUtils.run(cfg);
    }

    private BatchProblemNotifier() {
    }

    private static class Reactor
    implements ActionListener {
        final File root;
        final Map<String, Set<File>> projects = new TreeMap<String, Set<File>>();
        final Notification n;

        Reactor(File root) {
            assert (Thread.holdsLock(reactors));
            this.root = root;
            this.n = NotificationDisplayer.getDefault().notify(Bundle.build_title(root.getName()), ImageUtilities.image2Icon((Image)ImageUtilities.mergeImages((Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/resources/Maven2Icon.gif", (boolean)true), (Image)ImageUtilities.loadImage((String)"org/netbeans/modules/maven/brokenProjectBadge.png", (boolean)true), (int)8, (int)0)), Bundle.build_details(root), (ActionListener)this);
            LOG.log(Level.FINE, "created for {0}", root);
        }

        void register(String path, Set<File> files) {
            assert (Thread.holdsLock(reactors));
            this.projects.put(path, files);
            LOG.log(Level.FINE, "registered {0} for {1} in {2}", new Object[]{files, path, this.root});
        }

        void unregister(String path) {
            assert (Thread.holdsLock(reactors));
            this.projects.remove(path);
            LOG.log(Level.FINE, "unregistered {0} in {1}", new Object[]{path, this.root});
            this.checkComplete();
        }

        void resolved(File f) {
            assert (Thread.holdsLock(reactors));
            Iterator<Map.Entry<String, Set<File>>> it = this.projects.entrySet().iterator();
            while (it.hasNext()) {
                Map.Entry<String, Set<File>> entry = it.next();
                String path = entry.getKey();
                Set<File> files = entry.getValue();
                if (files.remove(f)) {
                    LOG.log(Level.FINE, "resolved {0} for {1} in {2}", new Object[]{f, path, this.root});
                }
                if (!files.isEmpty()) continue;
                it.remove();
                LOG.log(Level.FINE, "completed {0} in {1}", new Object[]{path, this.root});
            }
            this.checkComplete();
        }

        private void checkComplete() {
            if (this.projects.isEmpty()) {
                this.n.clear();
                reactors.remove(this.root);
                LOG.log(Level.FINE, "completed {0}", this.root);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void actionPerformed(ActionEvent e) {
            LOG.log(Level.FINE, "showing UI for {0} with {1}", new Object[]{this.root, this.projects.keySet()});
            Map map = reactors;
            synchronized (map) {
                reactors.remove(this.root);
            }
            BatchProblemNotifier.showUI(this.root, this.projects.keySet());
        }
    }
}

