/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.refactoring.php.ui.tree;

import javax.swing.Icon;
import javax.swing.ImageIcon;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.modules.refactoring.spi.ui.TreeElement;
import org.netbeans.modules.refactoring.spi.ui.TreeElementFactory;
import org.openide.filesystems.FileObject;
import org.openide.loaders.DataObject;
import org.openide.loaders.DataObjectNotFoundException;

public class FileTreeElement
implements TreeElement {
    private final FileObject fileObject;

    FileTreeElement(FileObject fileObject) {
        this.fileObject = fileObject;
    }

    public TreeElement getParent(boolean isLogical) {
        if (isLogical) {
            return TreeElementFactory.getTreeElement((Object)this.fileObject.getParent());
        }
        Project project = FileOwnerQuery.getOwner((FileObject)this.fileObject);
        return TreeElementFactory.getTreeElement((Object)(project != null ? project : this.fileObject.getParent()));
    }

    public Icon getIcon() {
        ImageIcon result = null;
        try {
            result = new ImageIcon(DataObject.find((FileObject)this.fileObject).getNodeDelegate().getIcon(1));
        }
        catch (DataObjectNotFoundException dataObjectNotFoundException) {
            // empty catch block
        }
        return result;
    }

    public String getText(boolean isLogical) {
        return this.fileObject.getNameExt();
    }

    public Object getUserObject() {
        return this.fileObject;
    }
}

