/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.web.jsfapi.api;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.api.annotations.common.CheckForNull;
import org.netbeans.modules.web.jsfapi.api.DefaultLibraryInfo;
import org.netbeans.modules.web.jsfapi.api.Library;

public final class NamespaceUtils {
    public static final String JCP_ORG_LOCATION = "http://xmlns.jcp.org";
    public static final String SUN_COM_LOCATION = "http://java.sun.com";
    public static final Map<String, String> NS_MAPPING = new HashMap<String, String>(8);

    @CheckForNull
    public static <T> T getForNs(Map<String, T> map, String ns) {
        T result = NamespaceUtils.checkMapForNs(map, ns);
        if (result == null && ns.endsWith("/")) {
            ns = ns.substring(0, ns.length() - 1);
            return NamespaceUtils.checkMapForNs(map, ns);
        }
        return result;
    }

    private static <T> T checkMapForNs(Map<String, T> map, String ns) {
        T result = map.get(ns);
        if (result == null) {
            if (NS_MAPPING.containsKey(ns)) {
                result = map.get(NS_MAPPING.get(ns));
            } else if (ns.startsWith(DefaultLibraryInfo.COMPOSITE.getLegacyNamespace())) {
                result = map.get(ns.replace(DefaultLibraryInfo.COMPOSITE.getLegacyNamespace(), DefaultLibraryInfo.COMPOSITE.getNamespace()));
            }
        }
        return result;
    }

    public static boolean containsNsOf(Collection<String> collection, DefaultLibraryInfo library) {
        if (collection.contains(library.getNamespace())) {
            return true;
        }
        if (library.getLegacyNamespace() != null) {
            return collection.contains(library.getLegacyNamespace());
        }
        return false;
    }

    public static Set<String> getAvailableNss(Map<String, ? extends Library> libraries, boolean jsf22plus) {
        HashSet<String> nss = new HashSet<String>();
        for (Map.Entry<String, ? extends Library> entry : libraries.entrySet()) {
            nss.add(entry.getKey());
            if (!jsf22plus) continue;
            Library library = entry.getValue();
            nss.add(library.getNamespace());
            if (!NS_MAPPING.containsKey(library.getNamespace())) continue;
            nss.add(NS_MAPPING.get(library.getNamespace()));
        }
        return nss;
    }

    static {
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/html", "http://java.sun.com/jsf/html");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/core", "http://java.sun.com/jsf/core");
        NS_MAPPING.put("http://xmlns.jcp.org/jsp/jstl/core", "http://java.sun.com/jsp/jstl/core");
        NS_MAPPING.put("http://xmlns.jcp.org/jsp/jstl/functions", "http://java.sun.com/jsp/jstl/functions");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/facelets", "http://java.sun.com/jsf/facelets");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/composite", "http://java.sun.com/jsf/composite");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf", "http://java.sun.com/jsf");
        NS_MAPPING.put("http://xmlns.jcp.org/jsf/passthrough", "http://java.sun.com/jsf/passthrough");
    }
}

