/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.websvc.wsitconf.refactoring;

import java.io.IOException;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.fileinfo.NonRecursiveFolder;
import org.netbeans.api.java.classpath.ClassPath;
import org.netbeans.api.project.FileOwnerQuery;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.api.project.SourceGroup;
import org.netbeans.modules.j2ee.core.api.support.java.JavaIdentifiers;
import org.netbeans.modules.refactoring.api.AbstractRefactoring;
import org.netbeans.modules.refactoring.api.Problem;
import org.netbeans.modules.refactoring.api.RenameRefactoring;
import org.netbeans.modules.refactoring.spi.RefactoringElementImplementation;
import org.netbeans.modules.refactoring.spi.RefactoringElementsBag;
import org.netbeans.modules.refactoring.spi.RefactoringPlugin;
import org.netbeans.modules.websvc.api.jaxws.project.config.Service;
import org.netbeans.modules.websvc.jaxws.api.JAXWSSupport;
import org.netbeans.modules.websvc.wsitconf.refactoring.WSITRefactoringPlugin;
import org.netbeans.modules.websvc.wsitconf.wsdlmodelext.WSITModelSupport;
import org.netbeans.modules.xml.wsdl.model.WSDLModel;
import org.openide.filesystems.FileObject;

class WSITRenamePackagePlugin
implements RefactoringPlugin {
    private static final Logger LOG = Logger.getLogger(WSITRenamePackagePlugin.class.getName());
    private RenameRefactoring refactoring;

    WSITRenamePackagePlugin(RenameRefactoring refactoring) {
        this.refactoring = refactoring;
    }

    public void cancelRequest() {
    }

    public Problem checkParameters() {
        return null;
    }

    public Problem fastCheckParameters() {
        return null;
    }

    public Problem preCheck() {
        return null;
    }

    public Problem prepare(RefactoringElementsBag refactoringElements) {
        FileObject pkg = ((NonRecursiveFolder)this.refactoring.getRefactoringSource().lookup(NonRecursiveFolder.class)).getFolder();
        String oldPackageName = JavaIdentifiers.getQualifiedName((FileObject)pkg);
        JAXWSSupport support = JAXWSSupport.getJAXWSSupport((FileObject)pkg);
        if (support == null) {
            LOG.log(Level.FINE, "No JAX-WS support for project found");
            return null;
        }
        List services = support.getServices();
        for (Object object : services) {
            Service service = (Service)object;
            String implementationClass = service.getImplementationClass();
            if (implementationClass == null || !implementationClass.startsWith(oldPackageName)) continue;
            this.doPrepare(pkg, implementationClass, refactoringElements);
        }
        return null;
    }

    private void doPrepare(FileObject pkg, String classFqn, RefactoringElementsBag refactoringElements) {
        Project project = FileOwnerQuery.getOwner((FileObject)pkg);
        WSDLModel model = null;
        if (project == null) {
            return;
        }
        FileObject file = this.getJavaFile(classFqn, project);
        if (file == null) {
            return;
        }
        try {
            model = WSITModelSupport.getModelForServiceFromJava(file, project, false, null);
        }
        catch (IOException ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        catch (Exception ex) {
            LOG.log(Level.SEVERE, null, ex);
        }
        if (model == null) {
            return;
        }
        refactoringElements.addFileChange((AbstractRefactoring)this.refactoring, (RefactoringElementImplementation)new PackageRenameElement(JavaIdentifiers.getQualifiedName((FileObject)pkg), this.refactoring.getNewName(), model));
    }

    private FileObject getJavaFile(String fqn, Project project) {
        SourceGroup[] sourceGroups = ProjectUtils.getSources((Project)project).getSourceGroups("java");
        if (sourceGroups.length > 0) {
            ClassPath classPath = null;
            for (int i = 0; i < sourceGroups.length; ++i) {
                FileObject javaClass;
                classPath = ClassPath.getClassPath((FileObject)sourceGroups[i].getRootFolder(), (String)"classpath/source");
                if (classPath == null || (javaClass = classPath.findResource(fqn.replace('.', '/') + ".java")) == null) continue;
                return javaClass;
            }
        }
        return null;
    }

    private static class PackageRenameElement
    extends WSITRefactoringPlugin.AbstractRenameConfigElement {
        PackageRenameElement(String oldPackageName, String newPackageName, WSDLModel model) {
            super(model);
            String oldConfName = this.getParentFile().getName();
            this.setOldConfigName(oldConfName);
            this.setNewConfigName(oldConfName.replace(oldPackageName, newPackageName));
        }
    }
}

