/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.configurations;

import org.netbeans.modules.cnd.api.toolchain.AbstractCompiler;
import org.netbeans.modules.cnd.api.toolchain.Tool;
import org.netbeans.modules.cnd.makeproject.api.configurations.BasicCompilerConfiguration;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfiguration;
import org.netbeans.modules.cnd.makeproject.api.support.MakeProjectOptionsFormat;

public class AssemblerConfiguration
extends BasicCompilerConfiguration
implements Cloneable {
    public AssemblerConfiguration(String baseDir, AssemblerConfiguration master, MakeConfiguration owner) {
        super(baseDir, master, owner);
    }

    public void assign(AssemblerConfiguration conf) {
        super.assign(conf);
    }

    public AssemblerConfiguration clone() {
        AssemblerConfiguration clone = new AssemblerConfiguration(this.getBaseDir(), (AssemblerConfiguration)this.getMaster(), this.getOwner());
        clone.setDevelopmentMode(this.getDevelopmentMode().clone());
        clone.setWarningLevel(this.getWarningLevel().clone());
        clone.setSixtyfourBits(this.getSixtyfourBits().clone());
        clone.setStrip(this.getStrip().clone());
        clone.setAdditionalDependencies(this.getAdditionalDependencies().clone());
        clone.setTool(this.getTool().clone());
        clone.setCommandLineConfiguration(this.getCommandLineConfiguration().clone());
        return clone;
    }

    @Override
    public String getOptions(AbstractCompiler compiler) {
        StringBuilder options = new StringBuilder("$(AS) $(ASFLAGS) ");
        options.append(this.getAllOptions2(compiler)).append(' ');
        options.append(this.getCommandLineOptions(true));
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getAsFlagsBasic(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getStripOption(this.getStrip().getValue()) + " ";
        options = options + compiler.getSixtyfourBitsOption(this.getSixtyfourBits().getValue()) + " ";
        if (this.getDevelopmentMode().getValue() == 3) {
            options = options + compiler.getDevelopmentModeOptions(3);
        }
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    public String getAsFlags(AbstractCompiler compiler) {
        String options = this.getAsFlagsBasic(compiler) + " ";
        options = options + this.getCommandLineConfiguration().getValue() + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }

    @Override
    public String getAllOptions(Tool tool) {
        if (!(tool instanceof AbstractCompiler)) {
            return "";
        }
        AbstractCompiler compiler = (AbstractCompiler)tool;
        StringBuilder options = new StringBuilder();
        options.append(this.getAsFlagsBasic(compiler)).append(' ');
        this.getMasters(true).forEach(master -> options.append(master.getCommandLineConfiguration().getValue()).append(' '));
        options.append(this.getAllOptions2(compiler)).append(' ');
        return MakeProjectOptionsFormat.reformatWhitespaces(options.toString());
    }

    public String getAllOptions2(AbstractCompiler compiler) {
        String options = "";
        options = options + compiler.getDevelopmentModeOptions(this.getDevelopmentMode().getValue()) + " ";
        options = options + compiler.getWarningLevelOptions(this.getWarningLevel().getValue()) + " ";
        return MakeProjectOptionsFormat.reformatWhitespaces(options);
    }
}

