/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.api.launchers;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;

public final class Launcher {
    private final int index;
    private String name;
    private final String command;
    private String buildCommand;
    private String runDir;
    private final Map<String, String> env = new HashMap<String, String>();
    private String symbolFiles;
    private boolean hide = false;
    private boolean runInOwnTab = true;
    private final Launcher common;

    public Launcher(String command, Launcher common) {
        this(-1, command, common);
    }

    public Launcher(int index, String command, Launcher common) {
        this.index = index;
        this.command = command;
        this.common = common;
    }

    int getIndex() {
        return this.index;
    }

    public String getName() {
        return this.name;
    }

    void setName(String name) {
        this.name = name;
    }

    public String getCommand() {
        return this.command;
    }

    public String getBuildCommand() {
        return this.buildCommand;
    }

    public void setBuildCommand(String buildCommand) {
        this.buildCommand = buildCommand;
    }

    public String getRunDir() {
        if (this.runDir != null) {
            return this.runDir;
        }
        if (this.common != null) {
            return this.common.getRunDir();
        }
        return null;
    }

    void setRunDir(String runDir) {
        this.runDir = runDir;
    }

    public Map<String, String> getEnv() {
        Map<String, String> ret = this.common != null ? this.common.getEnv() : new HashMap<String, String>();
        ret.putAll(this.env);
        return ret;
    }

    void putEnv(String key, String value) {
        this.env.put(key, value);
    }

    public String getSymbolFiles() {
        if (this.symbolFiles != null) {
            return this.symbolFiles;
        }
        if (this.common != null) {
            return this.common.getSymbolFiles();
        }
        return null;
    }

    void setSymbolFiles(String symbolFiles) {
        this.symbolFiles = symbolFiles;
    }

    public boolean isHide() {
        return this.hide;
    }

    void setHide(boolean isHide) {
        this.hide = isHide;
    }

    public boolean runInOwnTab() {
        return this.runInOwnTab;
    }

    void setRunInOwnTab(boolean runInOwnTab) {
        this.runInOwnTab = runInOwnTab;
    }

    public String getDisplayedName() {
        return this.name == null ? this.command : this.name;
    }

    public boolean equals(Object obj) {
        if (obj instanceof Launcher) {
            return ((Launcher)obj).getDisplayedName().equals(this.getDisplayedName());
        }
        return false;
    }

    public int hashCode() {
        assert (false) : "hashCode is not designed";
        return 17;
    }

    boolean isLauncherEquals(Launcher other) {
        if (other == null) {
            return false;
        }
        if (!Objects.equals(this.name, other.name)) {
            return false;
        }
        if (!Objects.equals(this.command, other.command)) {
            return false;
        }
        if (!Objects.equals(this.buildCommand, other.buildCommand)) {
            return false;
        }
        if (!Objects.equals(this.runDir, other.runDir)) {
            return false;
        }
        if (!Objects.equals(this.hide, other.hide)) {
            return false;
        }
        if (!Objects.equals(this.runInOwnTab, other.runInOwnTab)) {
            return false;
        }
        if (!Objects.equals(this.env, other.env)) {
            return false;
        }
        if (!Objects.equals(this.symbolFiles, other.symbolFiles)) {
            return false;
        }
        return this.common == null && other.common == null || this.common != null && other.common != null && this.common.isLauncherEquals(other.common);
    }
}

