/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.callgraph.support;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import org.netbeans.api.visual.graph.GraphScene;
import org.netbeans.api.visual.graph.layout.GraphLayout;
import org.netbeans.api.visual.graph.layout.UniversalGraph;
import org.netbeans.api.visual.widget.ConnectionWidget;
import org.netbeans.api.visual.widget.Widget;

public class HorizontalHierarchicalLayout<N, E>
extends GraphLayout<N, E> {
    public static final boolean TRACE = false;
    public static final boolean CHECK = false;
    public static final int SWEEP_ITERATIONS = 3;
    public static final int CROSSING_ITERATIONS = 3;
    public static final int DUMMY_WIDTH = 1;
    public static final int X_OFFSET = 20;
    public static final int LAYER_OFFSET = 30;
    private int dummyWidth = 1;
    private int xOffset;
    private int layerOffset;
    private int layerCount;
    private UniversalGraph<N, E> graph;
    private List<LayoutNode> nodes;
    private Collection<N> nodesSubset = null;
    private HashMap<N, LayoutNode> vertexToLayoutNode;
    private Set<E> reversedLinks;
    private List<LayoutNode>[] layers;
    private boolean animate = false;
    private boolean invert = true;
    private Comparator<LayoutNode> crossingNodeComparator = new Comparator<LayoutNode>(){

        @Override
        public int compare(LayoutNode n1, LayoutNode n2) {
            float f = n1.crossingNumber - n2.crossingNumber;
            if (f < 0.0f) {
                return -1;
            }
            if (f > 0.0f) {
                return 1;
            }
            return 0;
        }
    };

    public HorizontalHierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted, int xOffset, int layerOffset) {
        this.animate = animate;
        this.xOffset = xOffset > 0 ? xOffset : 20;
        this.layerOffset = layerOffset > 0 ? layerOffset : 30;
        this.invert = inverted;
    }

    public HorizontalHierarchicalLayout(GraphScene<N, E> scene, boolean animate, boolean inverted) {
        this(scene, animate, inverted, 20, 30);
    }

    public HorizontalHierarchicalLayout(GraphScene<N, E> scene, boolean animate) {
        this(scene, animate, false);
    }

    public HorizontalHierarchicalLayout() {
        this(null, false);
    }

    protected void performGraphLayout(UniversalGraph<N, E> graph) {
        this.graph = graph;
        this.vertexToLayoutNode = new HashMap();
        this.reversedLinks = new HashSet();
        this.nodes = new ArrayList<LayoutNode>();
        new BuildDatastructure().start();
        new ReverseEdges().start();
        new AssignLayers().start();
        new CreateDummyNodes().start();
        new CrossingReduction().start();
        new AssignXCoordinates().start();
        new AssignYCoordinates().start();
        new WriteResult().start();
    }

    protected void performNodesLayout(UniversalGraph<N, E> arg0, Collection<N> arg1) {
        this.nodesSubset = arg1;
        this.performGraphLayout(arg0);
    }

    static /* synthetic */ List[] access$1902(HorizontalHierarchicalLayout x0, List[] x1) {
        x0.layers = x1;
        return x1;
    }

    private class WriteResult
    extends AlgorithmPart {
        private int pointCount;

        private WriteResult() {
        }

        @Override
        protected void run() {
            Widget w;
            ArrayList points;
            Point p;
            Point p2;
            HashMap vertexPositions = new HashMap();
            HashMap linkPositions = new HashMap();
            for (Object v : HorizontalHierarchicalLayout.this.graph.getNodes()) {
                LayoutNode n = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(v);
                assert (!vertexPositions.containsKey(v));
                vertexPositions.put(v, new Point(n.x + n.xOffset, n.y + n.yOffset));
            }
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                for (LayoutEdge layoutEdge : n.succs) {
                    if (layoutEdge.link == null) continue;
                    Object link = layoutEdge.link;
                    ArrayList points2 = new ArrayList();
                    p2 = new Point(layoutEdge.from.x + layoutEdge.relativeFrom, layoutEdge.from.y + layoutEdge.from.height - layoutEdge.from.bottomYOffset);
                    points2.add(p2);
                    LayoutNode cur = layoutEdge.to;
                    LayoutNode other = layoutEdge.from;
                    LayoutEdge curEdge = layoutEdge;
                    while (cur.vertex == null && !cur.succs.isEmpty()) {
                        points2.add(new Point(cur.x + cur.width / 2, cur.y));
                        points2.add(new Point(cur.x + cur.width / 2, cur.y + cur.height));
                        if (cur.succs.isEmpty()) break;
                        assert (cur.succs.size() == 1);
                        curEdge = cur.succs.get(0);
                        cur = curEdge.to;
                    }
                    p2 = new Point(cur.x + curEdge.relativeTo, cur.y + cur.yOffset);
                    points2.add(p2);
                    if (HorizontalHierarchicalLayout.this.reversedLinks.contains(link)) {
                        Collections.reverse(points2);
                    }
                    linkPositions.put(layoutEdge.link, points2);
                    layoutEdge.link = null;
                }
            }
            int minX = Integer.MAX_VALUE;
            int minY = Integer.MAX_VALUE;
            for (Map.Entry entry : vertexPositions.entrySet()) {
                p = (Point)entry.getValue();
                minX = Math.min(minX, p.x);
                minY = Math.min(minY, p.y);
            }
            for (Map.Entry entry : linkPositions.entrySet()) {
                points = (ArrayList)entry.getValue();
                for (Point p22 : points) {
                    if (p22 == null) continue;
                    minX = Math.min(minX, p22.x);
                    minY = Math.min(minY, p22.y);
                }
            }
            for (Map.Entry entry : vertexPositions.entrySet()) {
                p = (Point)entry.getValue();
                p.x -= minX;
                p.y -= minY;
                w = HorizontalHierarchicalLayout.this.graph.getScene().findWidget(entry.getKey());
                if (HorizontalHierarchicalLayout.this.animate) {
                    HorizontalHierarchicalLayout.this.graph.getScene().getSceneAnimator().animatePreferredLocation(w, p);
                    continue;
                }
                w.setPreferredLocation(p);
            }
            for (Map.Entry entry : linkPositions.entrySet()) {
                points = (List)entry.getValue();
                w = points.iterator();
                while (w.hasNext()) {
                    p2 = (Point)w.next();
                    if (p2 == null) continue;
                    p2.x -= minX;
                    p2.y -= minY;
                }
                if (HorizontalHierarchicalLayout.this.invert && points.size() > 3) {
                    int numPoints = points.size();
                    ArrayList invertedPoints = new ArrayList(numPoints);
                    invertedPoints.add(points.get(0));
                    for (int i = numPoints - 2; i > 0; --i) {
                        invertedPoints.add(points.get(i));
                    }
                    invertedPoints.add(points.get(numPoints - 1));
                    points = invertedPoints;
                }
                if (!((w = HorizontalHierarchicalLayout.this.graph.getScene().findWidget(entry.getKey())) instanceof ConnectionWidget)) continue;
                ConnectionWidget cw = (ConnectionWidget)w;
                cw.setControlPoints((Collection)points, true);
            }
            HorizontalHierarchicalLayout.this.graph.getScene().validate();
            HorizontalHierarchicalLayout.this.graph.getScene().repaint();
            HorizontalHierarchicalLayout.this.graph.getScene().revalidate();
        }

        @Override
        protected void printStatistics() {
            System.out.println("Number of nodes: " + HorizontalHierarchicalLayout.this.nodes.size());
            int edgeCount = 0;
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                edgeCount += n.succs.size();
            }
            System.out.println("Number of edges: " + edgeCount);
            System.out.println("Number of points: " + this.pointCount);
        }
    }

    private class AssignYCoordinates
    extends AlgorithmPart {
        private AssignYCoordinates() {
        }

        @Override
        protected void run() {
            for (int i = 0; i < HorizontalHierarchicalLayout.this.layers.length; ++i) {
                int maxHeight = 0;
                int baseLine = 0;
                int bottomBaseLine = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    maxHeight = Math.max(maxHeight, n.height - n.yOffset - n.bottomYOffset);
                    baseLine = Math.max(baseLine, n.yOffset);
                    bottomBaseLine = Math.max(bottomBaseLine, n.bottomYOffset);
                }
                int curY = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    if (n.vertex == null) {
                        n.y = curY;
                        n.height = maxHeight + baseLine + bottomBaseLine;
                    } else {
                        n.y = curY + baseLine + (maxHeight - (n.height - n.yOffset - n.bottomYOffset)) / 2 - n.yOffset;
                    }
                    curY += maxHeight + baseLine + bottomBaseLine;
                    curY += HorizontalHierarchicalLayout.this.layerOffset;
                }
            }
        }
    }

    private class AssignXCoordinates
    extends AlgorithmPart {
        private AssignXCoordinates() {
        }

        @Override
        protected void run() {
            int curX = 0;
            for (int i = 0; i < HorizontalHierarchicalLayout.this.layers.length; ++i) {
                int maxWidth = 0;
                int baseLine = 0;
                int rightBaseLine = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    maxWidth = Math.max(maxWidth, n.width - n.xOffset - n.rightXOffset);
                    baseLine = Math.max(baseLine, n.yOffset);
                    rightBaseLine = Math.max(rightBaseLine, n.rightXOffset);
                }
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    if (n.vertex == null) {
                        n.x = curX;
                        n.width = maxWidth + baseLine + rightBaseLine;
                        continue;
                    }
                    n.x = curX + baseLine + (maxWidth - (n.width - n.xOffset - n.rightXOffset)) / 2 - n.xOffset;
                }
                curX += maxWidth + baseLine + rightBaseLine;
                curX += HorizontalHierarchicalLayout.this.layerOffset;
            }
        }
    }

    private class CrossingReduction
    extends AlgorithmPart {
        private CrossingReduction() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                assert (n.layer < HorizontalHierarchicalLayout.this.layerCount);
            }
        }

        @Override
        protected void run() {
            int i;
            HorizontalHierarchicalLayout.access$1902(HorizontalHierarchicalLayout.this, new List[HorizontalHierarchicalLayout.this.layerCount]);
            for (int i2 = 0; i2 < HorizontalHierarchicalLayout.this.layerCount; ++i2) {
                ((HorizontalHierarchicalLayout)HorizontalHierarchicalLayout.this).layers[i2] = new ArrayList();
            }
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                if (n.layer == 0) {
                    HorizontalHierarchicalLayout.this.layers[0].add(n);
                    visited.add(n);
                    continue;
                }
                if (!n.preds.isEmpty()) continue;
                HorizontalHierarchicalLayout.this.layers[n.layer].add(n);
                visited.add(n);
            }
            for (i = 0; i < HorizontalHierarchicalLayout.this.layers.length - 1; ++i) {
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    for (LayoutEdge e : n.succs) {
                        if (visited.contains(e.to)) continue;
                        visited.add(e.to);
                        HorizontalHierarchicalLayout.this.layers[i + 1].add(e.to);
                    }
                }
            }
            this.updatePositions();
            for (i = 0; i < 3; ++i) {
                this.downSweep();
                this.upSweep();
            }
        }

        private void updatePositions() {
            for (int i = 0; i < HorizontalHierarchicalLayout.this.layers.length; ++i) {
                int z = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void downSweep() {
            for (int i = 1; i < HorizontalHierarchicalLayout.this.layerCount; ++i) {
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.preds) {
                        float cur = e.from.pos;
                        if (e.from.width != 0 && e.relativeFrom != 0) {
                            cur += (float)e.relativeFrom / (float)e.from.width;
                        }
                        sum += cur;
                    }
                    if (n.preds.size() <= 0) continue;
                    n.crossingNumber = sum /= (float)n.preds.size();
                }
                Collections.sort(HorizontalHierarchicalLayout.this.layers[i], HorizontalHierarchicalLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        private void upSweep() {
            for (int i = HorizontalHierarchicalLayout.this.layerCount - 1; i >= 0; --i) {
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    float sum = 0.0f;
                    for (LayoutEdge e : n.succs) {
                        float cur = e.to.pos;
                        if (e.to.width != 0 && e.relativeTo != 0) {
                            cur += (float)e.relativeTo / (float)e.to.width;
                        }
                        sum += cur;
                    }
                    if (n.succs.size() <= 0) continue;
                    n.crossingNumber = sum /= (float)n.succs.size();
                }
                Collections.sort(HorizontalHierarchicalLayout.this.layers[i], HorizontalHierarchicalLayout.this.crossingNodeComparator);
                int z = 0;
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    n.pos = z++;
                }
            }
        }

        @Override
        public void postCheck() {
            HashSet<LayoutNode> visited = new HashSet<LayoutNode>();
            for (int i = 0; i < HorizontalHierarchicalLayout.this.layers.length; ++i) {
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    assert (!visited.contains(n));
                    assert (n.layer == i);
                    visited.add(n);
                }
            }
        }
    }

    private class CreateDummyNodes
    extends AlgorithmPart {
        private int oldNodeCount;

        private CreateDummyNodes() {
        }

        @Override
        protected void preCheck() {
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from != null);
                    assert (e.from == n);
                    assert (e.from.layer < e.to.layer);
                }
                for (LayoutEdge e : n.preds) {
                    assert (e.to != null);
                    assert (e.to == n);
                }
            }
        }

        @Override
        protected void run() {
            this.oldNodeCount = HorizontalHierarchicalLayout.this.nodes.size();
            ArrayList currentNodes = new ArrayList(HorizontalHierarchicalLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    this.processSingleEdge(e);
                }
            }
        }

        private void processSingleEdge(LayoutEdge e) {
            LayoutNode n = e.from;
            if (e.to.layer > n.layer + 1) {
                LayoutEdge last = e;
                for (int i = n.layer + 1; i < last.to.layer; ++i) {
                    last = this.addBetween(last, i);
                }
            }
        }

        private LayoutEdge addBetween(LayoutEdge e, int layer) {
            LayoutNode n = new LayoutNode();
            n.width = HorizontalHierarchicalLayout.this.dummyWidth;
            n.height = 0;
            n.layer = layer;
            n.preds.add(e);
            HorizontalHierarchicalLayout.this.nodes.add(n);
            LayoutEdge result = new LayoutEdge();
            n.succs.add(result);
            result.from = n;
            result.relativeFrom = n.width / 2;
            result.to = e.to;
            result.relativeTo = e.relativeTo;
            e.relativeTo = n.width / 2;
            e.to.preds.remove(e);
            e.to.preds.add(result);
            e.to = n;
            return result;
        }

        @Override
        public void printStatistics() {
            System.out.println("Dummy nodes created: " + (HorizontalHierarchicalLayout.this.nodes.size() - this.oldNodeCount));
        }

        @Override
        public void postCheck() {
            ArrayList currentNodes = new ArrayList(HorizontalHierarchicalLayout.this.nodes);
            for (LayoutNode n : currentNodes) {
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer == e.to.layer - 1);
                }
            }
            for (int i = 0; i < HorizontalHierarchicalLayout.this.layers.length; ++i) {
                assert (HorizontalHierarchicalLayout.this.layers[i].size() > 0);
                for (LayoutNode n : HorizontalHierarchicalLayout.this.layers[i]) {
                    assert (n.layer == i);
                }
            }
        }
    }

    private class AssignLayers
    extends AlgorithmPart {
        private AssignLayers() {
        }

        @Override
        public void preCheck() {
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                assert (n.layer == -1);
            }
        }

        @Override
        protected void run() {
            HashSet<LayoutNode> set = new HashSet<LayoutNode>();
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                if (!n.preds.isEmpty()) continue;
                set.add(n);
                n.layer = 0;
            }
            int z = 1;
            HashSet<Object> newSet = new HashSet();
            HashSet<LayoutNode> failed = new HashSet<LayoutNode>();
            while (!set.isEmpty()) {
                newSet.clear();
                failed.clear();
                for (LayoutNode layoutNode : set) {
                    for (LayoutEdge se : layoutNode.succs) {
                        LayoutNode s = se.to;
                        if (newSet.contains(s) || failed.contains(s)) continue;
                        boolean ok = true;
                        for (LayoutEdge pe : s.preds) {
                            LayoutNode p = pe.from;
                            if (p.layer != -1) continue;
                            ok = false;
                            break;
                        }
                        if (ok) {
                            newSet.add(s);
                            continue;
                        }
                        failed.add(s);
                    }
                }
                for (LayoutNode layoutNode : newSet) {
                    layoutNode.layer = z;
                }
                HashSet<LayoutNode> tmp = set;
                set = newSet;
                newSet = tmp;
                ++z;
            }
            this.optimize(set);
            HorizontalHierarchicalLayout.this.layerCount = z - 1;
        }

        public void optimize(HashSet<LayoutNode> set) {
            for (LayoutNode n : set) {
                if (!n.preds.isEmpty() || n.succs.size() <= 0) continue;
                int minLayer = n.succs.get((int)0).to.layer;
                for (LayoutEdge e : n.succs) {
                    minLayer = Math.min(minLayer, e.to.layer);
                }
                n.layer = minLayer - 1;
            }
        }

        @Override
        public void printStatistics() {
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                assert (n.layer >= 0);
                assert (n.layer < HorizontalHierarchicalLayout.this.layerCount);
                for (LayoutEdge e : n.succs) {
                    assert (e.from.layer < e.to.layer);
                }
            }
        }
    }

    private class ReverseEdges
    extends AlgorithmPart {
        private HashSet<LayoutNode> visited;
        private HashSet<LayoutNode> active;

        private ReverseEdges() {
        }

        @Override
        protected void run() {
            for (LayoutNode node : HorizontalHierarchicalLayout.this.nodes) {
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    assert (e.from == node);
                    if (e.to != node) continue;
                    node.succs.remove(e);
                    node.preds.remove(e);
                }
            }
            this.visited = new HashSet();
            this.active = new HashSet();
            for (LayoutNode node : HorizontalHierarchicalLayout.this.nodes) {
                this.DFS(node);
            }
        }

        private void DFS(LayoutNode startNode) {
            if (this.visited.contains(startNode)) {
                return;
            }
            Stack<LayoutNode> stack = new Stack<LayoutNode>();
            stack.push(startNode);
            while (!stack.empty()) {
                LayoutNode node = (LayoutNode)stack.pop();
                if (this.visited.contains(node)) {
                    this.active.remove(node);
                    continue;
                }
                stack.push(node);
                this.visited.add(node);
                this.active.add(node);
                ArrayList<LayoutEdge> succs = new ArrayList<LayoutEdge>(node.succs);
                for (LayoutEdge e : succs) {
                    if (this.active.contains(e.to)) {
                        assert (this.visited.contains(e.to));
                        this.reverseEdge(e);
                        continue;
                    }
                    if (this.visited.contains(e.to)) continue;
                    stack.push(e.to);
                }
            }
        }

        private void reverseEdge(LayoutEdge e) {
            assert (!HorizontalHierarchicalLayout.this.reversedLinks.contains(e.link));
            HorizontalHierarchicalLayout.this.reversedLinks.add(e.link);
            LayoutNode oldFrom = e.from;
            LayoutNode oldTo = e.to;
            int oldRelativeFrom = e.relativeFrom;
            int oldRelativeTo = e.relativeTo;
            e.from = oldTo;
            e.to = oldFrom;
            e.relativeFrom = oldRelativeTo;
            e.relativeTo = oldRelativeFrom;
            oldFrom.succs.remove(e);
            oldFrom.preds.add(e);
            oldTo.preds.remove(e);
            oldTo.succs.add(e);
        }

        @Override
        public void postCheck() {
            for (LayoutNode n : HorizontalHierarchicalLayout.this.nodes) {
                LinkedList<LayoutNode> queue = new LinkedList<LayoutNode>();
                for (LayoutEdge e : n.succs) {
                    LayoutNode s = e.to;
                    queue.add(s);
                    this.visited.add(s);
                }
                HashSet<LayoutNode> aVisited = new HashSet<LayoutNode>();
                while (!queue.isEmpty()) {
                    LayoutNode curNode = (LayoutNode)queue.remove();
                    for (LayoutEdge e : curNode.succs) {
                        assert (e.to != n);
                        if (aVisited.contains(e.to)) continue;
                        queue.add(e.to);
                        aVisited.add(e.to);
                    }
                }
            }
        }
    }

    private class BuildDatastructure
    extends AlgorithmPart {
        private BuildDatastructure() {
        }

        @Override
        protected void run() {
            Collection vertices = HorizontalHierarchicalLayout.this.nodesSubset == null ? HorizontalHierarchicalLayout.this.graph.getNodes() : HorizontalHierarchicalLayout.this.nodesSubset;
            for (Object v : vertices) {
                LayoutNode node = new LayoutNode();
                Widget w = HorizontalHierarchicalLayout.this.graph.getScene().findWidget(v);
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                node.width = (int)size.getWidth();
                node.height = (int)size.getHeight();
                node.vertex = v;
                HorizontalHierarchicalLayout.this.nodes.add(node);
                HorizontalHierarchicalLayout.this.vertexToLayoutNode.put(v, node);
            }
            Collection links = HorizontalHierarchicalLayout.this.graph.getEdges();
            for (Object l : links) {
                LayoutEdge edge = new LayoutEdge();
                assert (HorizontalHierarchicalLayout.this.vertexToLayoutNode.containsKey(HorizontalHierarchicalLayout.this.graph.getEdgeSource(l)));
                assert (HorizontalHierarchicalLayout.this.vertexToLayoutNode.containsKey(HorizontalHierarchicalLayout.this.graph.getEdgeTarget(l)));
                if (HorizontalHierarchicalLayout.this.invert) {
                    edge.to = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(HorizontalHierarchicalLayout.this.graph.getEdgeSource(l));
                    edge.from = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(HorizontalHierarchicalLayout.this.graph.getEdgeTarget(l));
                } else {
                    edge.from = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(HorizontalHierarchicalLayout.this.graph.getEdgeSource(l));
                    edge.to = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(HorizontalHierarchicalLayout.this.graph.getEdgeTarget(l));
                }
                Widget w = HorizontalHierarchicalLayout.this.graph.getScene().findWidget(HorizontalHierarchicalLayout.this.graph.getEdgeSource(l));
                assert (w != null);
                Rectangle r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                Dimension size = r.getSize();
                edge.relativeFrom = size.width / 2;
                w = HorizontalHierarchicalLayout.this.graph.getScene().findWidget(HorizontalHierarchicalLayout.this.graph.getEdgeTarget(l));
                assert (w != null);
                r = w.getBounds();
                if (r == null) {
                    r = w.getPreferredBounds();
                }
                size = r.getSize();
                edge.relativeTo = size.width / 2;
                edge.link = l;
                edge.from.succs.add(edge);
                edge.to.preds.add(edge);
            }
        }

        @Override
        public void postCheck() {
            assert (HorizontalHierarchicalLayout.this.vertexToLayoutNode.keySet().size() == HorizontalHierarchicalLayout.this.nodes.size());
            assert (HorizontalHierarchicalLayout.this.nodes.size() == HorizontalHierarchicalLayout.this.graph.getNodes().size());
            for (Object v : HorizontalHierarchicalLayout.this.graph.getNodes()) {
                LayoutNode node = (LayoutNode)HorizontalHierarchicalLayout.this.vertexToLayoutNode.get(v);
                assert (node != null);
                for (LayoutEdge e : node.succs) {
                    assert (e.from == node);
                }
                for (LayoutEdge e : node.preds) {
                    assert (e.to == node);
                }
            }
        }
    }

    private abstract class AlgorithmPart {
        private AlgorithmPart() {
        }

        public void start() {
            long start = 0L;
            this.run();
        }

        protected abstract void run();

        protected void printStatistics() {
        }

        protected void postCheck() {
        }

        protected void preCheck() {
        }
    }

    private class LayoutEdge {
        public LayoutNode from;
        public LayoutNode to;
        public int relativeFrom;
        public int relativeTo;
        public E link;

        private LayoutEdge() {
        }
    }

    private class LayoutNode {
        public int x;
        public int y;
        public int width;
        public int height;
        public int layer = -1;
        public int xOffset;
        public int yOffset;
        public int bottomYOffset;
        public int rightXOffset;
        public N vertex;
        public List<LayoutEdge> preds = new ArrayList<LayoutEdge>();
        public List<LayoutEdge> succs = new ArrayList<LayoutEdge>();
        public int pos = -1;
        public float crossingNumber;

        private LayoutNode() {
        }

        public String toString() {
            return "Node " + this.vertex;
        }
    }
}

