/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.api.model.services;

import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.swing.text.Document;
import org.netbeans.modules.cnd.api.model.CsmErrorDirective;
import org.netbeans.modules.cnd.api.model.CsmFile;
import org.netbeans.modules.cnd.api.model.CsmInclude;
import org.netbeans.modules.cnd.api.model.CsmOffsetable;
import org.netbeans.modules.cnd.api.model.CsmUID;
import org.netbeans.modules.cnd.api.model.services.CsmCompilationUnit;
import org.netbeans.modules.cnd.api.model.xref.CsmReference;
import org.netbeans.modules.cnd.api.project.IncludePath;
import org.netbeans.modules.cnd.api.project.NativeFileItem;
import org.netbeans.modules.cnd.support.Interrupter;
import org.netbeans.modules.parsing.spi.Parser;
import org.openide.util.CharSequences;
import org.openide.util.Lookup;
import org.openide.util.Pair;

public abstract class CsmFileInfoQuery {
    private static final CsmFileInfoQuery EMPTY = new Empty();
    private static CsmFileInfoQuery defaultResolver;

    protected CsmFileInfoQuery() {
    }

    public static CsmFileInfoQuery getDefault() {
        if (defaultResolver != null) {
            return defaultResolver;
        }
        defaultResolver = (CsmFileInfoQuery)Lookup.getDefault().lookup(CsmFileInfoQuery.class);
        return defaultResolver == null ? EMPTY : defaultResolver;
    }

    public abstract boolean isCpp98OrLater(CsmFile var1);

    public abstract boolean isCpp11OrLater(CsmFile var1);

    public abstract boolean isCpp14OrLater(CsmFile var1);

    public abstract List<IncludePath> getSystemIncludePaths(CsmFile var1);

    public abstract List<IncludePath> getUserIncludePaths(CsmFile var1);

    public abstract List<CsmOffsetable> getUnusedCodeBlocks(CsmFile var1, Interrupter var2);

    public abstract List<CsmReference> getMacroUsages(CsmFile var1, Document var2, Interrupter var3);

    public abstract CsmOffsetable getGuardOffset(CsmFile var1);

    public abstract boolean hasGuardBlock(CsmFile var1);

    public abstract NativeFileItem getNativeFileItem(CsmFile var1);

    public abstract List<CsmInclude> getIncludeStack(CsmFile var1);

    public abstract List<CsmInclude> getIncludeStack(CsmInclude var1);

    public abstract List<CsmInclude> getIncludeStack(CsmErrorDirective var1);

    public abstract Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> getFileLanguageFlavor(CsmFile var1);

    public abstract Pair<String, String> getAPTLanguageFlavor(Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> var1);

    public abstract Collection<CsmCompilationUnit> getCompilationUnits(CsmFile var1, int var2);

    public abstract Collection<CsmInclude> getBrokenIncludes(CsmFile var1);

    public abstract boolean hasBrokenIncludes(CsmFile var1);

    public abstract long getFileVersion(CsmFile var1);

    public abstract boolean isDocumentBasedFile(CsmFile var1);

    public abstract boolean isStandardHeadersIndexer(CsmFile var1);

    public abstract long getOffset(CsmFile var1, int var2, int var3);

    public abstract int[] getLineColumnByOffset(CsmFile var1, int var2);

    public abstract int getLineCount(CsmFile var1);

    public abstract CharSequence getName(CsmUID<CsmFile> var1);

    public abstract CharSequence getAbsolutePath(CsmUID<CsmFile> var1);

    public abstract CsmFile getCsmFile(Parser.Result var1);

    private static final class Empty
    extends CsmFileInfoQuery {
        Empty() {
        }

        @Override
        public boolean isCpp98OrLater(CsmFile csmFile) {
            return false;
        }

        @Override
        public boolean isCpp11OrLater(CsmFile csmFile) {
            return false;
        }

        @Override
        public boolean isCpp14OrLater(CsmFile csmFile) {
            return false;
        }

        @Override
        public List<IncludePath> getSystemIncludePaths(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<IncludePath> getUserIncludePaths(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmOffsetable> getUnusedCodeBlocks(CsmFile file, Interrupter interrupter) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmReference> getMacroUsages(CsmFile file, Document doc, Interrupter interrupter) {
            return Collections.emptyList();
        }

        @Override
        public CsmOffsetable getGuardOffset(CsmFile file) {
            return null;
        }

        @Override
        public boolean hasGuardBlock(CsmFile file) {
            return false;
        }

        @Override
        public NativeFileItem getNativeFileItem(CsmFile file) {
            return null;
        }

        @Override
        public List<CsmInclude> getIncludeStack(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmInclude> getIncludeStack(CsmErrorDirective err) {
            return Collections.emptyList();
        }

        @Override
        public List<CsmInclude> getIncludeStack(CsmInclude incl) {
            return Collections.emptyList();
        }

        @Override
        public Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> getFileLanguageFlavor(CsmFile file) {
            return Pair.of((Object)NativeFileItem.Language.OTHER, (Object)NativeFileItem.LanguageFlavor.UNKNOWN);
        }

        @Override
        public Pair<String, String> getAPTLanguageFlavor(Pair<NativeFileItem.Language, NativeFileItem.LanguageFlavor> langFlavor) {
            return null;
        }

        @Override
        public long getFileVersion(CsmFile file) {
            return 0L;
        }

        @Override
        public long getOffset(CsmFile file, int line, int column) {
            return 0L;
        }

        @Override
        public int getLineCount(CsmFile file) {
            return 0;
        }

        @Override
        public int[] getLineColumnByOffset(CsmFile file, int offset) {
            return new int[]{0, 0};
        }

        @Override
        public Collection<CsmInclude> getBrokenIncludes(CsmFile file) {
            return Collections.emptyList();
        }

        @Override
        public boolean hasBrokenIncludes(CsmFile file) {
            return false;
        }

        @Override
        public Collection<CsmCompilationUnit> getCompilationUnits(CsmFile file, int offset) {
            return Collections.singleton(CsmCompilationUnit.createCompilationUnit(file));
        }

        @Override
        public CharSequence getName(CsmUID<CsmFile> fileUID) {
            CsmFile file = (CsmFile)fileUID.getObject();
            if (file != null) {
                return file.getName();
            }
            return CharSequences.empty();
        }

        @Override
        public CharSequence getAbsolutePath(CsmUID<CsmFile> fileUID) {
            CsmFile file = (CsmFile)fileUID.getObject();
            if (file != null) {
                return file.getAbsolutePath();
            }
            return CharSequences.empty();
        }

        @Override
        public boolean isDocumentBasedFile(CsmFile file) {
            return false;
        }

        @Override
        public boolean isStandardHeadersIndexer(CsmFile file) {
            return false;
        }

        @Override
        public CsmFile getCsmFile(Parser.Result parseResult) {
            return null;
        }
    }
}

