/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.mobility.e2e.mapping;

import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.mobility.e2e.classdata.ClassData;
import org.netbeans.modules.mobility.e2e.classdata.ClassDataRegistry;
import org.netbeans.modules.mobility.e2e.classdata.MethodData;
import org.netbeans.modules.mobility.e2e.classdata.MethodParameter;
import org.netbeans.modules.mobility.javon.JavonMapping;

public class JavonMappingImpl
implements JavonMapping {
    private Client clientMapping;
    private Server serverMapping;
    private Service serviceMapping;
    private Map<String, Service> serviceMappings;
    private ClassDataRegistry registry;
    private Map<String, Object> properties;
    private String servletURL;

    public JavonMappingImpl(ClassDataRegistry registry) {
        this.registry = registry;
        this.serviceMappings = new HashMap<String, Service>();
        this.properties = new HashMap<String, Object>();
    }

    private JavonMappingImpl() {
    }

    @Override
    public ClassDataRegistry getRegistry() {
        return this.registry;
    }

    public void setClientMapping(Client clientMapping) {
        this.clientMapping = clientMapping;
    }

    @Override
    public Client getClientMapping() {
        return this.clientMapping;
    }

    public void setServerMapping(Server serverMapping) {
        this.serverMapping = serverMapping;
    }

    @Override
    public JavonMapping.Server getServerMapping() {
        return this.serverMapping;
    }

    public void addServiceMaping(Service serviceMapping) {
        this.serviceMappings.put(serviceMapping.getType(), serviceMapping);
    }

    @Override
    public JavonMapping.Service getServiceMapping(String serviceType) {
        return this.serviceMappings.get(serviceType);
    }

    @Override
    public Set<JavonMapping.Service> getServiceMappings() {
        return new HashSet<JavonMapping.Service>(this.serviceMappings.values());
    }

    public void setServletURL(String servletURL) {
        this.servletURL = servletURL;
    }

    @Override
    public String getServletURL() {
        return this.servletURL;
    }

    @Override
    public void setProperty(String key, Object value) {
        this.properties.put(key, value);
    }

    @Override
    public Object getProperty(String key) {
        return this.properties.get(key);
    }

    public static class Service
    implements JavonMapping.Service {
        public static final String STUB = "stub";
        public static final String SYNCHRONOUS = "synchronous";
        public static final String GROUPING = "grouping";
        private String packageName;
        private String className;
        private Set<MethodData> methods = new HashSet<MethodData>();

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        @Override
        public String getType() {
            if (this.packageName.length() > 0) {
                return this.packageName + "." + this.className;
            }
            return this.className;
        }

        @Override
        public Set<MethodData> getMethods() {
            return Collections.unmodifiableSet(this.methods);
        }

        public void addMethod(MethodData methodData) {
            this.methods.add(methodData);
        }

        @Override
        public Set<ClassData> getParameterTypes() {
            HashSet<ClassData> paramTypes = new HashSet<ClassData>();
            for (MethodData method : this.methods) {
                for (MethodParameter param : method.getParameters()) {
                    ClassData cd = param.getType();
                    paramTypes.addAll(cd.getSerializer().getReferencedTypes(cd, paramTypes));
                }
            }
            return Collections.unmodifiableSet(paramTypes);
        }

        @Override
        public Set<ClassData> getReturnTypes() {
            HashSet<ClassData> returnTypes = new HashSet<ClassData>();
            for (MethodData method : this.methods) {
                ClassData cd = method.getReturnType();
                returnTypes.addAll(cd.getSerializer().getReferencedTypes(cd, returnTypes));
            }
            return Collections.unmodifiableSet(returnTypes);
        }

        @Override
        public Set<ClassData> getSupportedTypes() {
            HashSet<ClassData> result = new HashSet<ClassData>();
            result.addAll(this.getParameterTypes());
            result.addAll(this.getReturnTypes());
            return result;
        }
    }

    public static class Server
    implements JavonMapping.Server {
        private String location;
        private String port;
        private String servletLocation;
        private String projectName;
        private String packageName;
        private String className;
        private String outputDirectory;

        public void setLocation(String location) {
            this.location = location;
        }

        @Override
        public String getLocation() {
            return this.location;
        }

        public void setPort(String port) {
            this.port = port;
        }

        @Override
        public String getPort() {
            return this.port;
        }

        public void setServletLocation(String location) {
            this.servletLocation = location;
        }

        @Override
        public String getServletLocation() {
            return this.servletLocation;
        }

        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Override
        public String getProjectName() {
            return this.projectName;
        }

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getClassName() {
            return this.className;
        }

        public void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getOutputDirectory() {
            return this.outputDirectory;
        }
    }

    public static class Client
    implements JavonMapping.Client {
        private String packageName;
        private String outputDirectory;
        private String className;

        public void setPackageName(String packageName) {
            this.packageName = packageName;
        }

        @Override
        public String getPackageName() {
            return this.packageName;
        }

        public void setOutputDirectory(String outputDirectory) {
            this.outputDirectory = outputDirectory;
        }

        @Override
        public String getOutputDirectory() {
            return this.outputDirectory;
        }

        public void setClassName(String className) {
            this.className = className;
        }

        @Override
        public String getClassName() {
            return this.className;
        }
    }
}

