/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.lib.terminalemulator.TermStream;
import org.netbeans.modules.cnd.debugger.gdb2.Gdb;

final class KeyProcessing {
    static TermStream createStream() {
        return new KeyProcessingStream();
    }

    private KeyProcessing() {
    }

    private static class KeyProcessingStream
    extends TermStream {
        private static final Logger STREAM_LOG = Logger.getLogger(Gdb.class.getName());
        private static final char FIRST_PRINTABLE = ' ';
        private final History history = new History();
        private boolean resendingLastCommand = false;
        private final StringBuilder line = new StringBuilder();
        private int charIdxInLine;
        private int send_buf_sz = 2;
        private char[] send_buf = new char[this.send_buf_sz];

        private KeyProcessingStream() {
        }

        private char[] send_buf(int n) {
            if (n >= this.send_buf_sz) {
                this.send_buf_sz = n + 1;
                this.send_buf = new char[this.send_buf_sz];
            }
            return this.send_buf;
        }

        public void sendChars(char[] c, int offset, int count) {
            STREAM_LOG.log(Level.FINE, "sendChars from term: \"{0}\"", Arrays.toString(c));
            boolean consumed = this.processCharSequences(c, offset, count);
            if (consumed) {
                this.toDTE.flush();
                STREAM_LOG.log(Level.FINE, "processCharSequences: line in term: \"{0}\"", this.line);
                return;
            }
            for (int cx = 0; cx < count; ++cx) {
                this.sendCharImpl(c[offset + cx]);
            }
            this.toDTE.flush();
            STREAM_LOG.log(Level.FINE, "sendChars: line in term: \"{0}\"", this.line);
        }

        public void sendChar(char c) {
            STREAM_LOG.log(Level.FINE, "sendChar from term: \"{0}:{1}\"", new Object[]{Character.valueOf(c), (int)c});
            this.sendCharImpl(c);
            this.toDTE.flush();
            STREAM_LOG.log(Level.FINE, "sendChar: line in term: \"{0}\"", this.line);
        }

        public void putChar(char c) {
            this.toDTE.putChar(c);
        }

        public void flush() {
            this.toDTE.flush();
        }

        public void putChars(char[] buf, int offset, int count) {
            this.toDTE.putChars(buf, offset, count);
        }

        private boolean processCharSequences(char[] chars, int offset, int count) {
            String seq = String.valueOf(chars, offset, count);
            if ("\u001b[A".equals(seq)) {
                this.historyUp();
            } else if ("\u001b[B".equals(seq)) {
                this.historyDown();
            } else if ("\u001b[D".equals(seq)) {
                this.moveCaretLeft(this.charIdxInLine - 1);
            } else if ("\u001b[C".equals(seq)) {
                this.moveCaretRight(this.charIdxInLine + 1);
            } else if ("\u001b[H".equals(seq)) {
                this.moveCaretLeft(0);
            } else if ("\u001b[F".equals(seq)) {
                this.moveCaretRight(this.line.length());
            } else if ("\u001b[3~".equals(seq)) {
                this.removeRight(1);
            } else {
                return false;
            }
            return true;
        }

        private void sendCharImpl(char c) {
            if (c == '\r' || c == '\n') {
                if (!this.resendingLastCommand && this.line.toString().trim().length() == 0) {
                    String last = this.history.getLast();
                    int nchars = last.length() + 1;
                    char[] tmp = this.send_buf(nchars);
                    last.getChars(0, nchars - 1, tmp, 0);
                    tmp[nchars - 1] = c;
                    this.cleanLine();
                    this.resendingLastCommand = true;
                    this.sendChars(tmp, 0, nchars);
                    this.resendingLastCommand = false;
                } else {
                    this.toDTE.putChar('\r');
                    this.toDTE.putChar('\n');
                    this.toDTE.flush();
                    if (!this.resendingLastCommand) {
                        this.history.add(this.line.toString());
                    }
                    this.line.append('\n');
                    int nchars = this.line.length();
                    char[] tmp = this.send_buf(nchars);
                    this.line.getChars(0, nchars, tmp, 0);
                    this.line.delete(0, nchars);
                    this.charIdxInLine = 0;
                    this.toDCE.sendChars(tmp, 0, nchars);
                    this.toDCE.flush();
                }
            } else if (c == '\u0001') {
                this.moveCaretLeft(0);
            } else if (c == '\u0005') {
                this.moveCaretRight(this.line.length());
            } else if (c == '\b') {
                if (this.charIdxInLine == 0) {
                    return;
                }
                this.removeLeft(1);
                this.printPostfixKeepCaret();
            } else if (c == '\u000b') {
                this.removeRight(this.line.length() - this.charIdxInLine);
            } else if (c == '\u0015') {
                if (this.charIdxInLine == 0) {
                    return;
                }
                this.removeLeft(this.charIdxInLine);
                assert (this.charIdxInLine == 0) : "" + this.charIdxInLine;
                this.printPostfixKeepCaret();
            } else if (c >= ' ') {
                if (this.charIdxInLine == this.line.length()) {
                    this.line.append(c);
                } else {
                    assert (this.charIdxInLine < this.line.length()) : this.charIdxInLine + "vs. " + this.line.length();
                    this.line.insert(this.charIdxInLine, c);
                }
                this.toDTE.putChar(c);
                ++this.charIdxInLine;
                this.printPostfixKeepCaret();
            }
        }

        private void removeRight(int count) {
            if (this.charIdxInLine == this.line.length()) {
                return;
            }
            assert (count > 0);
            if (this.charIdxInLine + count == this.line.length()) {
                this.toDTE.putChars(ESCAPES.BS_EOL_SEQUENCE, 0, ESCAPES.BS_EOL_SEQUENCE.length);
                this.line.delete(this.charIdxInLine, this.line.length());
                return;
            }
            int nrTermPositions = 0;
            while (count-- > 0) {
                assert (this.charIdxInLine > 0) : "unexpected " + this.charIdxInLine;
                char erased_char = this.line.charAt(this.charIdxInLine);
                this.line.deleteCharAt(this.charIdxInLine);
                nrTermPositions += this.getTerm().charWidth(erased_char);
            }
            this.deleteRightImpl(nrTermPositions);
        }

        private void removeLeft(int count) {
            int nrTermPositions = 0;
            while (count-- > 0) {
                assert (this.charIdxInLine > 0) : "unexpected " + this.charIdxInLine;
                --this.charIdxInLine;
                char erased_char = this.line.charAt(this.charIdxInLine);
                this.line.deleteCharAt(this.charIdxInLine);
                nrTermPositions += this.getTerm().charWidth(erased_char);
            }
            if (nrTermPositions == 1 && this.charIdxInLine == this.line.length()) {
                this.toDTE.putChars(ESCAPES.BS_SEQUENCE, 0, ESCAPES.BS_SEQUENCE.length);
            } else if (nrTermPositions > 0) {
                int move = nrTermPositions;
                while (move-- > 0) {
                    this.toDTE.putChar('\b');
                }
                this.deleteRightImpl(nrTermPositions);
            }
        }

        private void cleanLine() {
            this.line.delete(0, this.line.length());
            this.charIdxInLine = 0;
            this.toDTE.putChars(ESCAPES.BS_EL_SEQUENCE, 0, ESCAPES.BS_EL_SEQUENCE.length);
            this.toDTE.putChar('\r');
        }

        private void deleteRightImpl(int nrTermPositions) {
            assert (nrTermPositions > 0);
            String delSeq = String.format("\u001b[%dP", nrTermPositions);
            int nchars = delSeq.length();
            char[] tmp = this.send_buf(nchars);
            delSeq.getChars(0, nchars, tmp, 0);
            this.toDTE.putChars(tmp, 0, nchars);
        }

        private void printPostfixKeepCaret() {
            if (this.charIdxInLine < this.line.length()) {
                int oldCaretIdx = this.charIdxInLine;
                while (this.charIdxInLine < this.line.length()) {
                    this.toDTE.putChar(this.line.charAt(this.charIdxInLine++));
                }
                this.moveCaretLeft(oldCaretIdx);
            }
        }

        private void moveCaretRight(int requestedIdx) {
            if (requestedIdx <= this.line.length()) {
                while (this.charIdxInLine < requestedIdx) {
                    int cwidth = this.getTerm().charWidth(this.line.charAt(this.charIdxInLine));
                    ++this.charIdxInLine;
                    while (cwidth-- > 0) {
                        this.toDTE.putChars(ESCAPES.RIGHT_SEQUENCE_CHARS, 0, ESCAPES.RIGHT_SEQUENCE_CHARS.length);
                    }
                }
                assert (requestedIdx == this.charIdxInLine) : this.charIdxInLine + " different from " + requestedIdx;
            }
        }

        private void moveCaretLeft(int requestedIdx) {
            if (requestedIdx == 0) {
                this.toDTE.putChar('\r');
                this.charIdxInLine = 0;
            } else if (requestedIdx >= 0) {
                while (requestedIdx < this.charIdxInLine) {
                    --this.charIdxInLine;
                    int cwidth = this.getTerm().charWidth(this.line.charAt(this.charIdxInLine));
                    while (cwidth-- > 0) {
                        this.toDTE.putChar('\b');
                    }
                }
                assert (requestedIdx == this.charIdxInLine) : this.charIdxInLine + " different from " + requestedIdx;
            }
        }

        private void historyUp() {
            String str = this.line.toString();
            this.cleanLine();
            String prev = this.history.previous(str);
            this.line.append(prev);
            this.toDTE.putChars(prev.toCharArray(), 0, prev.length());
            this.charIdxInLine = prev.length();
        }

        private void historyDown() {
            this.cleanLine();
            String next = this.history.next();
            this.line.append(next);
            this.toDTE.putChars(next.toCharArray(), 0, next.length());
            this.charIdxInLine = next.length();
        }

        private static class History {
            private static final int MAX_SIZE = 100;
            private final LinkedList<String> list = new LinkedList();
            private ListIterator<String> iter = this.list.listIterator();
            private boolean forward = false;
            private boolean lastIsTmp = false;

            public void add(String string) {
                if (this.lastIsTmp) {
                    this.list.removeLast();
                    this.lastIsTmp = false;
                } else if (this.list.size() > 100) {
                    this.list.removeFirst();
                }
                this.list.addLast(string);
                this.iter = this.list.listIterator(this.list.size());
                this.forward = false;
            }

            public String previous() {
                if (this.forward && this.iter.hasPrevious()) {
                    this.iter.previous();
                }
                this.forward = false;
                if (this.iter.hasPrevious()) {
                    return this.iter.previous();
                }
                return !this.list.isEmpty() ? this.list.getFirst() : "";
            }

            String previous(String current) {
                if (this.isLast()) {
                    this.add(current);
                    this.lastIsTmp = true;
                    this.previous();
                }
                return this.previous();
            }

            public String next() {
                if (!this.forward && this.iter.hasNext()) {
                    this.iter.next();
                }
                this.forward = true;
                String val = "";
                if (this.iter.hasNext()) {
                    val = this.iter.next();
                }
                if (this.isLast() && this.lastIsTmp) {
                    this.removeLast();
                    this.lastIsTmp = false;
                }
                return val;
            }

            public boolean isLast() {
                return !this.iter.hasNext();
            }

            public String getLast() {
                return !this.list.isEmpty() ? this.list.getLast() : "";
            }

            private void removeLast() {
                assert (!this.iter.hasNext()) : "The iterator must be on the last index";
                this.list.removeLast();
                this.iter = this.list.listIterator(this.list.size());
            }
        }
    }

    static final class ESCAPES {
        private static final char CHAR_SOH = '\u0001';
        private static final char CHAR_ENQ = '\u0005';
        private static final char CHAR_BS = '\b';
        static final char CHAR_LF = '\n';
        static final char CHAR_CR = '\r';
        static final char CHAR_ESC = '\u001b';
        private static final char CHAR_SP = ' ';
        private static final char CHAR_VT = '\u000b';
        private static final char CHAR_NAK = '\u0015';
        private static final char[] BS_SEQUENCE = new char[]{'\b', ' ', '\b'};
        private static final char[] BS_SOL_SEQUENCE = new char[]{'\u001b', '[', '1', 'K'};
        private static final char[] BS_EL_SEQUENCE = new char[]{'\u001b', '[', '2', 'K'};
        private static final char[] BS_EOL_SEQUENCE = new char[]{'\u001b', '[', 'K'};
        private static final String DEL_SEQUENCE_FMT = "\u001b[%dP";
        static final char[] BOLD_SEQUENCE = new char[]{'\u001b', '[', '1', 'm'};
        static final char[] BLUEBOLD_SEQUENCE = new char[]{'\u001b', '[', '1', ';', '3', '4', 'm'};
        static final char[] RED_SEQUENCE = new char[]{'\u001b', '[', '3', '1', 'm'};
        static final char[] BROWN_SEQUENCE = new char[]{'\u001b', '[', '5', '0', 'm'};
        static final char[] GREEN_SEQUENCE = new char[]{'\u001b', '[', '5', '1', 'm'};
        static final char[] LOG_SEQUENCE = new char[]{'\u001b', '[', '5', '2', 'm'};
        static final char[] RESET_SEQUENCE = new char[]{'\u001b', '[', '0', 'm'};
        private static final String DEL_SEQUENCE = "\u001b[3~";
        private static final String UP_SEQUENCE = "\u001b[A";
        private static final String DOWN_SEQUENCE = "\u001b[B";
        private static final String RIGHT_SEQUENCE = "\u001b[C";
        private static final String LEFT_SEQUENCE = "\u001b[D";
        private static final String HOME_SEQUENCE = "\u001b[H";
        private static final String END_SEQUENCE = "\u001b[F";
        private static final char[] RIGHT_SEQUENCE_CHARS = "\u001b[C".toCharArray();

        ESCAPES() {
        }
    }
}

