/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.debugger.gdb2.mi;

import org.netbeans.modules.cnd.debugger.common2.utils.StopWatch;
import org.netbeans.modules.cnd.debugger.gdb2.GdbUtils;
import org.netbeans.modules.cnd.debugger.gdb2.mi.Log;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIConst;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIRecord;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIResult;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MITList;
import org.netbeans.modules.cnd.debugger.gdb2.mi.MIValue;

public class MIParser {
    private char[] str;
    private int x;
    private int bx;
    private final String encoding;
    private static final int CHAR_DIGIT = 1;
    private static final int CHAR_TERM = 2;
    private static final int[] charMap = MIParser.makeCharMap();
    private Token ungotToken = null;

    private static void error(String parsing, String expected, Token got) throws MIParserException {
        String msg = "MI parse error while parsing '" + parsing + "': " + "Expected " + expected + " but got " + got.toString();
        throw new MIParserException(msg);
    }

    public MIParser(String encoding) {
        this.encoding = encoding;
    }

    public void setup(String data) {
        int len = data.length();
        this.str = new char[len + 1];
        data.getChars(0, len, this.str, 0);
        this.str[len] = '\u0000';
        this.x = 0;
    }

    public MIRecord parse() {
        StopWatch sw = new StopWatch("MIrecord.parse()");
        sw.start();
        MIRecord record = new MIRecord();
        try {
            this.parseWork(record);
        }
        catch (MIParserException e) {
            record.isError = true;
            record.error = e.getMessage();
        }
        sw.stop();
        if (Log.MI.time) {
            int threshold = 5;
            sw.dump(5);
        }
        return record;
    }

    private static int[] makeCharMap() {
        int[] cmap = new int[256];
        cmap[48] = cmap[48] | 1;
        cmap[49] = cmap[49] | 1;
        cmap[50] = cmap[50] | 1;
        cmap[51] = cmap[51] | 1;
        cmap[52] = cmap[52] | 1;
        cmap[53] = cmap[53] | 1;
        cmap[54] = cmap[54] | 1;
        cmap[55] = cmap[55] | 1;
        cmap[56] = cmap[56] | 1;
        cmap[57] = cmap[57] | 1;
        cmap[0] = cmap[0] | 2;
        cmap[32] = cmap[32] | 2;
        cmap[10] = cmap[10] | 2;
        cmap[13] = cmap[13] | 2;
        cmap[9] = cmap[9] | 2;
        cmap[44] = cmap[44] | 2;
        cmap[61] = cmap[61] | 2;
        cmap[91] = cmap[91] | 2;
        cmap[93] = cmap[93] | 2;
        cmap[123] = cmap[123] | 2;
        cmap[125] = cmap[125] | 2;
        return cmap;
    }

    private boolean charIs(char c, int what) {
        if (c >= '\u0100') {
            return false;
        }
        return (charMap[c] & what) == what;
    }

    private void ungetToken(Token t) {
        assert (this.ungotToken == null);
        this.ungotToken = t;
    }

    /*
     * Unable to fully structure code
     */
    private Token getToken() {
        if (this.ungotToken != null) {
            t = this.ungotToken;
            this.ungotToken = null;
            return t;
        }
        block18: while (true) {
            c = this.str[this.x++];
            switch (c) {
                case '\u0000': {
                    return new Token(TokenType.EOL);
                }
                case '\t': 
                case '\n': 
                case '\r': 
                case ' ': {
                    continue block18;
                }
                case '{': {
                    return new Token(TokenType.LC);
                }
                case '}': {
                    return new Token(TokenType.RC);
                }
                case '[': {
                    return new Token(TokenType.LB);
                }
                case ']': {
                    return new Token(TokenType.RB);
                }
                case ',': {
                    return new Token(TokenType.COMMA);
                }
                case '=': {
                    return new Token(TokenType.EQ);
                }
                case '^': {
                    return new Token(TokenType.CARET);
                }
                case '+': {
                    return new Token(TokenType.PLUS);
                }
                case '*': {
                    return new Token(TokenType.STAR);
                }
                case '~': {
                    return new Token(TokenType.TILDE);
                }
                case '@': {
                    return new Token(TokenType.AT);
                }
                case '&': {
                    return new Token(TokenType.AMP);
                }
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': {
                    --this.x;
                    this.bx = this.x;
                    while (this.charIs(this.str[this.x], 1)) {
                        ++this.x;
                    }
                    return new Token(TokenType.NUM, new String(this.str, this.bx, this.x - this.bx));
                }
                case '\"': {
                    string = new StringBuilder();
                    escape = false;
                    while (true) {
                        if (this.str[this.x] != '\u0000') ** break;
                        continue block18;
                        if (this.str[this.x] == '\\') {
                            escape = escape == false;
                        } else {
                            if (this.str[this.x] == '\"' && !escape) {
                                ++this.x;
                                return new Token(TokenType.STR, string.toString());
                            }
                            escape = false;
                        }
                        string.append(this.str[this.x++]);
                    }
                }
                default: {
                    --this.x;
                    this.bx = this.x;
                    while (!this.charIs(this.str[this.x], 2)) {
                        ++this.x;
                    }
                    return new Token(TokenType.SYM, new String(this.str, this.bx, this.x - this.bx));
                }
            }
            break;
        }
    }

    private MITList parseValueList(TokenType endToken, boolean topLevel) throws MIParserException {
        MITList list = new MITList(endToken == TokenType.RB, topLevel);
        while (true) {
            MIValue value = this.parseValue(false);
            list.add(value);
            Token t = this.getToken();
            if (t.type == endToken) break;
            if (t.type == TokenType.COMMA) continue;
            MIParser.error("value list", ", or ]|}", t);
        }
        return list;
    }

    private MITList parseResultList(TokenType endToken, boolean topLevel) throws MIParserException {
        MITList list = new MITList(endToken == TokenType.RB, topLevel);
        String name = null;
        while (true) {
            Token t;
            if ((t = this.getToken()).type == TokenType.SYM) {
                name = t.value;
                t = this.getToken();
                if (t.type != TokenType.EQ) {
                    MIParser.error("result", "=", t);
                }
            } else if (t.type == TokenType.LC) {
                this.ungetToken(t);
            } else {
                MIParser.error("result list", "variable or {", t);
            }
            if (name == null) {
                MIParser.error("result list", "variable", t);
            }
            MIValue value = this.parseValue("file".equals(name) || "fullname".equals(name));
            MIResult result = new MIResult(name, value);
            list.add(result);
            t = this.getToken();
            if (t.type == endToken) break;
            if (t.type == TokenType.COMMA) continue;
            MIParser.error("result list", ", or ]", t);
        }
        return list;
    }

    private MIValue parseValue(boolean decode) throws MIParserException {
        Token t = this.getToken();
        if (t.type == TokenType.STR) {
            String value = t.value;
            if (decode) {
                value = GdbUtils.gdbToUserEncoding(value, this.encoding);
            }
            return new MIConst(value);
        }
        if (t.type == TokenType.LC) {
            return this.parseTList(TokenType.RC);
        }
        if (t.type == TokenType.LB) {
            return this.parseTList(TokenType.RB);
        }
        MIParser.error("value", "c-string or { or [", t);
        return null;
    }

    private MITList parseTList(TokenType endToken) throws MIParserException {
        boolean topLevel = endToken == TokenType.EOL;
        Token t = this.getToken();
        if (t.type == endToken) {
            return new MITList(endToken == TokenType.RB, topLevel);
        }
        switch (t.type) {
            case SYM: {
                this.ungetToken(t);
                return this.parseResultList(endToken, topLevel);
            }
            case STR: 
            case LC: 
            case LB: {
                this.ungetToken(t);
                return this.parseValueList(endToken, topLevel);
            }
        }
        MIParser.error("tlist", "]|} or variable or c-string or [ or {", t);
        return null;
    }

    private MIRecord parseWork(MIRecord record) throws MIParserException {
        Token t = this.getToken();
        if (t.type == TokenType.NUM) {
            try {
                record.token = Integer.parseInt(t.value);
            }
            catch (NumberFormatException nfe) {
                throw new MIParserException("Unable to parse token: " + t.value);
            }
            t = this.getToken();
        }
        switch (t.type) {
            case EOL: {
                record.results = new MITList(false, true);
                return record;
            }
            case CARET: {
                record.type = (char)94;
                record.isStream = false;
                break;
            }
            case PLUS: {
                record.type = (char)43;
                record.isStream = false;
                break;
            }
            case STAR: {
                record.type = (char)42;
                record.isStream = false;
                break;
            }
            case EQ: {
                record.type = (char)61;
                record.isStream = false;
                break;
            }
            case TILDE: {
                record.type = (char)126;
                record.isStream = true;
                break;
            }
            case AT: {
                record.type = (char)64;
                record.isStream = true;
                break;
            }
            case AMP: {
                record.type = (char)38;
                record.isStream = true;
            }
        }
        if (record.isStream) {
            t = this.getToken();
            if (t.type != TokenType.STR) {
                MIParser.error("stream-record", "c-string", t);
            }
            record.stream = t.value;
        } else {
            t = this.getToken();
            if (t.type != TokenType.SYM) {
                MIParser.error("non-stream-record", "SYM", t);
            }
            record.cls = t.value;
            t = this.getToken();
            if (t.type == TokenType.EOL) {
                record.results = new MITList(false, true);
            } else if (t.type == TokenType.COMMA) {
                record.results = this.parseTList(TokenType.EOL);
            } else {
                record.results = new MITList(false, true);
                MIParser.error("results", ", or EOL", t);
            }
        }
        return record;
    }

    private static class Token {
        private final TokenType type;
        private final String value;

        public Token(TokenType type) {
            this.type = type;
            this.value = null;
            if (Log.MI.ttrace) {
                System.out.println("\t" + this.toString());
            }
        }

        public Token(TokenType type, String value) {
            this.type = type;
            this.value = value;
            if (Log.MI.ttrace) {
                System.out.println("\t" + this.toString() + ": " + value);
            }
        }

        public String toString() {
            return this.type.toString() + " (" + this.value + ')';
        }
    }

    private static enum TokenType {
        EOL,
        LC,
        RC,
        LB,
        RB,
        COMMA,
        EQ,
        STR,
        SYM,
        NUM,
        CARET,
        PLUS,
        STAR,
        TILDE,
        AT,
        AMP;

    }

    private static class MIParserException
    extends Exception {
        public MIParserException(String msg) {
            super(msg);
        }
    }
}

