/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.java.queries;

import java.io.IOException;
import java.net.URL;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.spi.java.queries.SourceJavadocAttacherImplementation;
import org.openide.util.Exceptions;
import org.openide.util.Lookup;
import org.openide.util.Parameters;

public final class SourceJavadocAttacher {
    private static final Logger LOG = Logger.getLogger(SourceJavadocAttacher.class.getName());

    private SourceJavadocAttacher() {
    }

    public static void attachSources(@NonNull URL root, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 0);
    }

    public static void attachJavadoc(@NonNull URL root, @NullAllowed AttachmentListener listener) {
        SourceJavadocAttacher.attach(root, listener, 1);
    }

    private static void attach(URL root, @NullAllowed AttachmentListener listener, int mode) {
        Parameters.notNull((CharSequence)"root", (Object)root);
        if (listener == null) {
            listener = new AttachmentListener(){

                @Override
                public void attachmentSucceeded() {
                }

                @Override
                public void attachmentFailed() {
                }
            };
        }
        try {
            for (SourceJavadocAttacherImplementation attacher : Lookup.getDefault().lookupAll(SourceJavadocAttacherImplementation.class)) {
                boolean handles = mode == 0 ? attacher.attachSources(root, listener) : attacher.attachJavadoc(root, listener);
                if (!handles) continue;
                LOG.log(Level.FINE, "Attaching of {0} to root: {1} handled by: {2}", new Object[]{mode == 0 ? "sources" : "javadoc", root, attacher.getClass().getName()});
                return;
            }
        }
        catch (IOException ioe) {
            Exceptions.printStackTrace((Throwable)ioe);
        }
        if (listener != null) {
            listener.attachmentFailed();
        }
        LOG.log(Level.FINE, "No provider handled attaching of {0} to root: {1}", new Object[]{mode == 0 ? "sources" : "javadoc", root});
    }

    public static interface AttachmentListener {
        public void attachmentSucceeded();

        public void attachmentFailed();
    }
}

