/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.remote.sync.download;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.swing.Icon;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.modules.cnd.remote.mapper.RemotePathMap;
import org.netbeans.modules.cnd.remote.sync.download.FileDownloadInfo;
import org.netbeans.modules.cnd.remote.sync.download.HostUpdatesPersistence;
import org.netbeans.modules.cnd.remote.sync.download.HostUpdatesRequestPanel;
import org.netbeans.modules.cnd.remote.utils.RemoteUtil;
import org.netbeans.modules.cnd.utils.CndUtils;
import org.netbeans.modules.cnd.utils.NamedRunnable;
import org.netbeans.modules.cnd.utils.cache.CndFileUtils;
import org.netbeans.modules.nativeexecution.api.ExecutionEnvironment;
import org.openide.awt.Notification;
import org.openide.awt.NotificationDisplayer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.ImageUtilities;
import org.openide.util.NbBundle;
import org.openide.util.RequestProcessor;

public class HostUpdates {
    private static final Map<ExecutionEnvironment, HostUpdates> map = new HashMap<ExecutionEnvironment, HostUpdates>();
    private static final RequestProcessor RP = new RequestProcessor("HostUpdates", 1);
    private final ExecutionEnvironment env;
    private final RemotePathMap mapper;
    private Notification notification;
    private final HostUpdatesPersistence persistence;
    private final List<FileDownloadInfo> infos = new ArrayList<FileDownloadInfo>();

    public static void register(Collection<File> localFiles, ExecutionEnvironment env, FileObject privStorageDir) throws IOException {
        HostUpdates.get(env, true, privStorageDir).register(localFiles);
    }

    static List<FileDownloadInfo> testGetUpdates(ExecutionEnvironment env, FileObject privProjectStorageDir) throws IOException {
        HostUpdates hu = HostUpdates.get(env, false, privProjectStorageDir);
        if (hu != null) {
            return new ArrayList<FileDownloadInfo>(hu.infos);
        }
        return Collections.emptyList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostUpdates get(ExecutionEnvironment env, boolean create, FileObject privStorageDir) throws IOException {
        Map<ExecutionEnvironment, HostUpdates> map = HostUpdates.map;
        synchronized (map) {
            HostUpdates updates = HostUpdates.map.get(env);
            if (updates == null) {
                updates = new HostUpdates(env, privStorageDir);
                HostUpdates.map.put(env, updates);
            }
            return updates;
        }
    }

    private HostUpdates(ExecutionEnvironment env, FileObject privStorageDir) throws IOException {
        this.env = env;
        this.mapper = RemotePathMap.getPathMap((ExecutionEnvironment)env);
        this.persistence = new HostUpdatesPersistence(privStorageDir, env);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private FileDownloadInfo getFileInfo(File file) {
        Object object = FileDownloadInfo.LOCK;
        synchronized (object) {
            for (FileDownloadInfo info : this.infos) {
                if (!file.equals(info.getLocalFile())) continue;
                return info;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void register(Collection<File> localFiles) {
        Object object = FileDownloadInfo.LOCK;
        synchronized (object) {
            for (File file : localFiles) {
                FileDownloadInfo info = this.getFileInfo(file);
                if (info == null) {
                    this.infos.add(new FileDownloadInfo(file, this.mapper.getRemotePath(file.getAbsolutePath(), false), this.env));
                    continue;
                }
                info.reset();
            }
        }
        this.showNotification();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showNotification() {
        if (this.persistence.getRememberChoice()) {
            this.download();
            return;
        }
        ActionListener onClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CndUtils.assertUiThread();
                HostUpdates.this.showConfirmDialog();
            }
        };
        String envString = RemoteUtil.getDisplayName((ExecutionEnvironment)this.env);
        try {
            Object object = FileDownloadInfo.LOCK;
            synchronized (object) {
                if (this.notification != null) {
                    this.notification.clear();
                }
                this.notification = NotificationDisplayer.getDefault().notify(NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesNotifier.TITLE", (Object)envString), (Icon)ImageUtilities.loadImageIcon((String)"org/netbeans/modules/cnd/remote/sync/download/remote-updates.png", (boolean)false), NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesNotifier.DETAILS", (Object)envString), onClickAction, NotificationDisplayer.Priority.NORMAL, NotificationDisplayer.Category.INFO);
            }
        }
        catch (RuntimeException e) {
            e.printStackTrace();
            throw e;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Collection<FileDownloadInfo> getByState(FileDownloadInfo.State state) {
        ArrayList<FileDownloadInfo> result = new ArrayList<FileDownloadInfo>();
        Object object = FileDownloadInfo.LOCK;
        synchronized (object) {
            for (FileDownloadInfo info : this.infos) {
                if (info.getState() != state) continue;
                result.add(info);
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showConfirmDialog() {
        Collection<FileDownloadInfo> unconfirmed;
        Object object = FileDownloadInfo.LOCK;
        synchronized (object) {
            unconfirmed = this.getByState(FileDownloadInfo.State.UNCONFIRMED);
            if (unconfirmed.isEmpty()) {
                return;
            }
            if (this.notification != null) {
                this.notification.clear();
                this.notification = null;
            }
        }
        final Set<FileDownloadInfo> confirmed = HostUpdatesRequestPanel.request(unconfirmed, this.env, this.persistence);
        if (confirmed == null) {
            Object object2 = FileDownloadInfo.LOCK;
            synchronized (object2) {
                if (this.notification == null) {
                    this.showNotification();
                }
            }
        }
        Object object3 = FileDownloadInfo.LOCK;
        synchronized (object3) {
            for (FileDownloadInfo info : unconfirmed) {
                if (confirmed.contains(info)) {
                    info.confirm();
                    continue;
                }
                info.reject();
            }
            unconfirmed.removeAll(confirmed);
            this.infos.removeAll(unconfirmed);
        }
        if (!confirmed.isEmpty()) {
            NamedRunnable r = new NamedRunnable("Remote updates synchronizer for " + this.env.getDisplayName()){

                protected void runImpl() {
                    HostUpdates.this.download(confirmed);
                }
            };
            RP.post((Runnable)r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void download() {
        final ArrayList<FileDownloadInfo> confirmed = new ArrayList<FileDownloadInfo>();
        Object object = FileDownloadInfo.LOCK;
        synchronized (object) {
            Collection<FileDownloadInfo> unconfirmed = this.getByState(FileDownloadInfo.State.UNCONFIRMED);
            for (FileDownloadInfo info : unconfirmed) {
                if (this.persistence.getFileSelected(info.getLocalFile(), true)) {
                    info.confirm();
                    confirmed.add(info);
                    continue;
                }
                info.reject();
            }
            unconfirmed.removeAll(confirmed);
            this.infos.removeAll(unconfirmed);
        }
        if (!confirmed.isEmpty()) {
            RP.post((Runnable)new NamedRunnable(""){

                protected void runImpl() {
                    HostUpdates.this.download(confirmed);
                }
            });
        }
    }

    private void download(Collection<FileDownloadInfo> infos) {
        ProgressHandle handle = ProgressHandle.createHandle((String)NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesProgress_Title", (Object)RemoteUtil.getDisplayName((ExecutionEnvironment)this.env)));
        handle.start();
        handle.switchToDeterminate(infos.size());
        int cnt = 0;
        HashSet<File> refreshDirs = new HashSet<File>();
        for (FileDownloadInfo info : infos) {
            File dirToRefresh;
            handle.progress(NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesProgress_Message", (Object)info.getLocalFile().getName()), cnt++);
            for (dirToRefresh = info.getLocalFile().getParentFile(); dirToRefresh != null && !dirToRefresh.exists(); dirToRefresh = dirToRefresh.getParentFile()) {
            }
            info.download();
            if (info.getState() != FileDownloadInfo.State.DONE || dirToRefresh == null) continue;
            refreshDirs.add(dirToRefresh);
        }
        FileUtil.refreshFor((File[])refreshDirs.toArray(new File[refreshDirs.size()]));
        CndFileUtils.clearFileExistenceCache();
        handle.finish();
        final AtomicReference<Notification> notRef = new AtomicReference<Notification>();
        ActionListener onClickAction = new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                Notification n = (Notification)notRef.get();
                if (n != null) {
                    n.clear();
                }
            }
        };
        String envString = RemoteUtil.getDisplayName((ExecutionEnvironment)this.env);
        String iconString = "org/netbeans/modules/cnd/remote/sync/download/check.png";
        String title = NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesOK.TITLE", (Object)envString, (Object)infos.size());
        String detailsText = NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesOK.DETAILS", (Object)envString, (Object)infos.size());
        NotificationDisplayer.Category category = NotificationDisplayer.Category.INFO;
        for (FileDownloadInfo info : infos) {
            if (info.getState() == FileDownloadInfo.State.DONE) continue;
            iconString = "org/netbeans/modules/cnd/remote/sync/download/error.png";
            title = NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesERR.TITLE", (Object)envString, (Object)infos.size());
            detailsText = NbBundle.getMessage(this.getClass(), (String)"RemoteUpdatesERR.DETAILS", (Object)envString, (Object)infos.size());
            category = NotificationDisplayer.Category.ERROR;
            break;
        }
        notRef.set(NotificationDisplayer.getDefault().notify(title, (Icon)ImageUtilities.loadImageIcon((String)iconString, (boolean)false), detailsText, onClickAction, NotificationDisplayer.Priority.LOW, category));
        RP.post(new Runnable(){

            @Override
            public void run() {
                Notification n = (Notification)notRef.get();
                if (n != null) {
                    n.clear();
                }
            }
        }, 15000);
    }
}

