/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.j2ee.ejbcore.ejb.wizard.dd;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.DefaultListCellRenderer;
import javax.swing.GroupLayout;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import org.netbeans.api.project.Project;
import org.netbeans.api.project.ProjectUtils;
import org.netbeans.modules.j2ee.api.ejbjar.EjbJar;
import org.openide.awt.Mnemonics;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.NbBundle;

public final class EjbJarXmlVisualPanel1
extends JPanel {
    private Project project;
    private JTextField createdFileText;
    private JTextField fileNameText;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JComboBox locationCombo;
    private JTextField projectText;

    public EjbJarXmlVisualPanel1() {
        this.initComponents();
        this.locationCombo.setRenderer(new FileObjectListCellRenderer());
    }

    void setProject(Project project) {
        this.project = project;
        this.fileNameText.setText("ejb-jar.xml");
        this.projectText.setText(ProjectUtils.getInformation((Project)project).getDisplayName());
        for (EjbJar ejbJar : EjbJar.getEjbJars((Project)project)) {
            if (ejbJar.getDeploymentDescriptor() != null) {
                this.locationCombo.addItem(ejbJar.getDeploymentDescriptor());
                continue;
            }
            if (ejbJar.getMetaInf() == null) continue;
            this.locationCombo.addItem(ejbJar.getMetaInf());
        }
        this.refreshLocation();
        this.locationCombo.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                EjbJarXmlVisualPanel1.this.refreshLocation();
            }
        });
    }

    FileObject getSelectedLocation() {
        return (FileObject)this.locationCombo.getSelectedItem();
    }

    @Override
    public String getName() {
        return NbBundle.getMessage(EjbJarXmlVisualPanel1.class, (String)"LBL_SelectLocation");
    }

    private void refreshLocation() {
        FileObject fileObject = (FileObject)this.locationCombo.getSelectedItem();
        if (fileObject != null) {
            this.createdFileText.setText(FileUtil.getFileDisplayName((FileObject)fileObject) + File.separator + "ejb-jar.xml");
        }
        this.firePropertyChange("", null, null);
    }

    private void initComponents() {
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.createdFileText = new JTextField();
        this.projectText = new JTextField();
        this.fileNameText = new JTextField();
        this.locationCombo = new JComboBox();
        Mnemonics.setLocalizedText((JLabel)this.jLabel1, (String)NbBundle.getMessage(EjbJarXmlVisualPanel1.class, (String)"LBL_Name"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel2, (String)NbBundle.getMessage(EjbJarXmlVisualPanel1.class, (String)"LBL_Project"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel3, (String)NbBundle.getMessage(EjbJarXmlVisualPanel1.class, (String)"LBL_Location"));
        Mnemonics.setLocalizedText((JLabel)this.jLabel4, (String)NbBundle.getMessage(EjbJarXmlVisualPanel1.class, (String)"LBL_CreatedFile"));
        this.createdFileText.setEditable(false);
        this.projectText.setEditable(false);
        this.fileNameText.setEditable(false);
        GroupLayout layout = new GroupLayout(this);
        this.setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel4).addComponent(this.jLabel2).addComponent(this.jLabel1).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.projectText, -1, 287, Short.MAX_VALUE).addComponent(this.createdFileText, -1, 287, Short.MAX_VALUE).addComponent(this.fileNameText, -1, 287, Short.MAX_VALUE).addComponent(this.locationCombo, 0, 287, Short.MAX_VALUE)).addContainerGap()));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.fileNameText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.projectText, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel3).addComponent(this.locationCombo, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel4).addComponent(this.createdFileText, -2, -1, -2)).addContainerGap(189, Short.MAX_VALUE)));
    }

    private class FileObjectListCellRenderer
    extends DefaultListCellRenderer {
        private FileObjectListCellRenderer() {
        }

        @Override
        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
            if (value instanceof FileObject) {
                FileObject fileObject = (FileObject)value;
                this.setText(FileUtil.getFileDisplayName((FileObject)fileObject));
            }
            return this;
        }
    }
}

