/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import org.netbeans.api.search.SearchRoot;
import org.netbeans.api.search.SearchScopeOptions;
import org.netbeans.api.search.provider.SearchListener;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.MakeProjectLookupProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.ConfigurationDescriptorProvider;
import org.netbeans.modules.cnd.makeproject.api.configurations.Folder;
import org.netbeans.modules.cnd.makeproject.api.configurations.Item;
import org.netbeans.modules.cnd.makeproject.api.configurations.MakeConfigurationDescriptor;
import org.netbeans.modules.cnd.makeproject.ui.FolderSearchInfo;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.spi.search.SearchInfoDefinition;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileStateInvalidException;

final class MakeProjectSearchInfo
extends SearchInfoDefinition {
    private final ConfigurationDescriptorProvider projectDescriptorProvider;

    private MakeProjectSearchInfo(ConfigurationDescriptorProvider projectDescriptorProvider) {
        this.projectDescriptorProvider = projectDescriptorProvider;
    }

    public boolean canSearch() {
        return true;
    }

    public List<SearchRoot> getSearchRoots() {
        MakeConfigurationDescriptor configurationDescriptor;
        ArrayList<SearchRoot> roots = new ArrayList<SearchRoot>();
        if (this.projectDescriptorProvider.gotDescriptor() && (configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            FileObject baseDirFileObject = configurationDescriptor.getBaseDirFileObject();
            roots.add(new SearchRoot(baseDirFileObject, null));
            configurationDescriptor.getAbsoluteSourceRoots().forEach(root -> {
                try {
                    FileObject fo = new FSPath(baseDirFileObject.getFileSystem(), root).getFileObject();
                    if (fo != null && !baseDirFileObject.equals(fo)) {
                        roots.add(new SearchRoot(fo, null));
                    }
                }
                catch (FileStateInvalidException fileStateInvalidException) {
                    // empty catch block
                }
            });
        }
        return roots;
    }

    public Iterator<FileObject> filesToSearch(SearchScopeOptions options, SearchListener listener, AtomicBoolean terminated) {
        MakeConfigurationDescriptor configurationDescriptor;
        FolderSearchInfo.FileObjectNameMatcherImpl matcher = new FolderSearchInfo.FileObjectNameMatcherImpl(options, terminated);
        if (this.projectDescriptorProvider.gotDescriptor() && (configurationDescriptor = this.projectDescriptorProvider.getConfigurationDescriptor()) != null) {
            Item[] projectItems;
            Folder rootFolder = configurationDescriptor.getLogicalFolders();
            Set res = rootFolder.getAllItemsAsFileObjectSet(false, (Folder.FileObjectNameMatcher)matcher);
            FileObject baseDirFileObject = this.projectDescriptorProvider.getConfigurationDescriptor().getBaseDirFileObject();
            for (Item item : projectItems = this.projectDescriptorProvider.getConfigurationDescriptor().getProjectItems()) {
                FileObject fo = item.getFileObject();
                if (fo == null || matcher != null && !matcher.pathMatches(fo)) continue;
                res.add(fo);
            }
            this.addFolder(res, baseDirFileObject.getFileObject("nbproject"), matcher);
            return res.iterator();
        }
        return new ArrayList().iterator();
    }

    private void addFolder(Set<FileObject> res, FileObject fo, Folder.FileObjectNameMatcher matcher) {
        if (fo != null && fo.isFolder() && fo.isValid()) {
            if (matcher.isTerminated()) {
                return;
            }
            for (FileObject f : fo.getChildren()) {
                if (matcher.isTerminated()) {
                    return;
                }
                if (f.isData() && matcher.pathMatches(f)) {
                    res.add(f);
                    continue;
                }
                if (!f.isFolder()) continue;
                this.addFolder(res, f, matcher);
            }
        }
    }

    public static class MakeProjectSearchInfoFactory
    implements MakeProjectLookupProvider {
        public void addLookup(MakeProject owner, ArrayList<Object> ic) {
            ic.add((Object)new MakeProjectSearchInfo(owner.getConfigurationDescriptorProvider()));
        }
    }
}

