/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.makeproject.ui.customizer;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.swing.JComponent;
import org.netbeans.api.annotations.common.NonNull;
import org.netbeans.api.annotations.common.NullAllowed;
import org.netbeans.modules.cnd.makeproject.api.MakeProject;
import org.netbeans.modules.cnd.makeproject.api.configurations.Configuration;
import org.netbeans.modules.cnd.makeproject.api.ui.configurations.CustomizerNode;
import org.netbeans.modules.cnd.makeproject.ui.configurations.LicenseHeadersPanel;
import org.netbeans.modules.cnd.makeproject.ui.configurations.LicensePanelContentHandler;
import org.netbeans.modules.cnd.makeproject.ui.customizer.MakeContext;
import org.netbeans.modules.cnd.utils.FSPath;
import org.netbeans.spi.project.ui.support.ProjectCustomizer;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.FileUtil;
import org.openide.util.Exceptions;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;

public class LicenseCustomizerNode
extends CustomizerNode
implements MakeContext.Savable {
    private JComponent licencePropPanel;
    private LicensePanelContentHandlerImpl handler;

    public LicenseCustomizerNode(String name, String displayName, CustomizerNode[] children, Lookup lookup) {
        super(name, displayName, children, lookup);
    }

    @Override
    public JComponent getPanel(Configuration configuration) {
        if (this.licencePropPanel == null) {
            MakeContext context = (MakeContext)this.lookup.lookup(MakeContext.class);
            MakeProject project = (MakeProject)context.getProject();
            Properties projectProperties = project.getProjectProperties(true);
            String licenseName = projectProperties.getProperty("project.license");
            String licensePath = projectProperties.getProperty("project.licensePath");
            this.handler = new LicensePanelContentHandlerImpl(this.lookup, licensePath, licenseName);
            ProjectCustomizer.Category category = ProjectCustomizer.Category.create((String)this.getName(), (String)this.getDisplayName(), null, (ProjectCustomizer.Category[])new ProjectCustomizer.Category[0]);
            this.licencePropPanel = new LicenseHeadersPanel(category, this.handler);
            this.getContext().registerSavable(this);
        }
        return this.licencePropPanel;
    }

    @Override
    public CustomizerNode.CustomizerStyle customizerStyle() {
        return CustomizerNode.CustomizerStyle.PANEL;
    }

    @Override
    public HelpCtx getHelpCtx() {
        return new HelpCtx("ProjectProperties");
    }

    @Override
    public void save() {
        MakeContext context = (MakeContext)this.lookup.lookup(MakeContext.class);
        MakeProject project = (MakeProject)context.getProject();
        Properties projectProperties = project.getProjectProperties(true);
        String globalLicenseName = this.handler.getGlobalLicenseName();
        if (globalLicenseName == null || globalLicenseName.isEmpty()) {
            projectProperties.remove("project.license");
        } else {
            projectProperties.put("project.license", globalLicenseName);
        }
        String projectLicenseLocation = this.handler.getProjectLicenseLocation();
        if (projectLicenseLocation == null || projectLicenseLocation.isEmpty()) {
            projectProperties.remove("project.licensePath");
        } else {
            projectProperties.put("project.licensePath", projectLicenseLocation);
        }
        String projectLicenseContent = this.handler.getProjectLicenseContent();
        if (projectLicenseContent != null) {
            String path = projectLicenseLocation;
            assert (path != null);
            FSPath file = project.getHelper().resolveFSPath(path);
            FileObject fo = file.getFileObject();
            if (fo == null) {
                try {
                    fo = FileUtil.createData((FileObject)file.getFileSystem().getRoot(), (String)file.getPath());
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
            if (fo != null) {
                try (OutputStream out = fo.getOutputStream();){
                    FileUtil.copy((InputStream)new ByteArrayInputStream(projectLicenseContent.getBytes()), (OutputStream)out);
                }
                catch (IOException ex) {
                    Exceptions.printStackTrace((Throwable)ex);
                }
            }
        }
        project.saveProjectProperties(projectProperties, true);
    }

    private static class LicensePanelContentHandlerImpl
    implements LicensePanelContentHandler {
        private String licensePath;
        private String licenseName;
        private String licenseText;
        private final MakeContext context;

        public LicensePanelContentHandlerImpl(Lookup lookup, String licensePath, String licenseName) {
            this.context = (MakeContext)lookup.lookup(MakeContext.class);
            this.licensePath = licensePath;
            this.licenseName = licenseName;
        }

        @Override
        public String getProjectLicenseLocation() {
            return this.licensePath;
        }

        @Override
        public String getGlobalLicenseName() {
            return this.licenseName;
        }

        @Override
        public FileObject resolveProjectLocation(@NonNull String path) {
            MakeProject project = (MakeProject)this.context.getProject();
            return project.getHelper().resolveFileObject(path);
        }

        @Override
        public void setProjectLicenseLocation(@NullAllowed String newLocation) {
            this.licensePath = newLocation;
        }

        @Override
        public void setGlobalLicenseName(@NullAllowed String newName) {
            this.licenseName = newName;
        }

        @Override
        public String getDefaultProjectLicenseLocation() {
            return "./nbproject/licenseheader.txt";
        }

        @Override
        public void setProjectLicenseContent(@NullAllowed String text) {
            this.licenseText = text;
        }

        public String getProjectLicenseContent() {
            return this.licenseText;
        }
    }
}

