/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.javadoc.search;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import org.netbeans.modules.javadoc.search.IndexSearchThread;
import org.netbeans.modules.javadoc.search.Jdk12SearchType;
import org.netbeans.modules.javadoc.search.SearchThreadJdk12_japan;
import org.netbeans.modules.javadoc.search.URLUtils;
import org.openide.util.Exceptions;

public final class Jdk12SearchType_japan
extends Jdk12SearchType {
    private String japanEncoding;
    private static final long serialVersionUID = -2453877778724454324L;
    private static final String JDK12_ALLCLASSES_JA = "\u3059\u3079\u3066\u306e\u30af\u30e9\u30b9";

    public String getJapanEncoding() {
        return this.japanEncoding != null ? this.japanEncoding : "JISAutoDetect";
    }

    public void setJapanEncoding(String japanEncoding) {
        String old = this.japanEncoding;
        this.japanEncoding = japanEncoding;
    }

    @Override
    public IndexSearchThread getSearchThread(String toFind, URL fo, IndexSearchThread.DocIndexItemConsumer diiConsumer) {
        return new SearchThreadJdk12_japan(toFind, fo, diiConsumer, this.isCaseSensitive(), this.getJapanEncoding());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean accepts(URL root, String encoding) {
        if (encoding == null) {
            return false;
        }
        if ("iso-2022-jp".equals(encoding = encoding.toLowerCase()) || "sjis".equals(encoding) || "euc-jp".equals(encoding)) {
            this.setJapanEncoding(encoding);
            return true;
        }
        if ("utf-8".equals(encoding)) {
            try {
                InputStream is = URLUtils.open(root, "allclasses-frame.html");
                if (is == null) {
                    return false;
                }
                boolean jazip = false;
                try {
                    String line;
                    BufferedReader r = new BufferedReader(new InputStreamReader(is, encoding));
                    while ((line = r.readLine()) != null) {
                        if (line.contains(JDK12_ALLCLASSES_JA)) {
                            jazip = true;
                        }
                        if (!line.toLowerCase().contains("</title>")) continue;
                        break;
                    }
                }
                finally {
                    is.close();
                }
                if (jazip) {
                    this.setJapanEncoding(encoding);
                }
                return jazip;
            }
            catch (IOException ioe) {
                Exceptions.printStackTrace((Throwable)ioe);
            }
        }
        return false;
    }
}

