/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.cnd.testrunner.spi;

import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.netbeans.modules.gsf.testrunner.api.TestSession;
import org.netbeans.modules.gsf.testrunner.ui.api.Manager;

public abstract class TestRecognizerHandler {
    private static final Logger LOGGER = Logger.getLogger(TestRecognizerHandler.class.getName());
    protected final Pattern pattern;
    private Matcher matcher;
    protected String line;
    private final boolean performOutput;

    public TestRecognizerHandler(String regex) {
        this(regex, true, false);
    }

    public TestRecognizerHandler(String regex, boolean wrapRegex, boolean performOutput) {
        if (wrapRegex) {
            regex = TestRecognizerHandler.wrap(regex);
        }
        this.pattern = Pattern.compile(regex, 32);
        this.performOutput = performOutput;
    }

    public boolean isPerformOutput() {
        return this.performOutput;
    }

    public final boolean matches(String line) {
        this.match(line);
        return this.matchesImpl(line);
    }

    public Matcher getMatcher() {
        return this.matcher;
    }

    public boolean matchesImpl(String line) {
        return this.matcher.matches();
    }

    public final Matcher match(String line) {
        this.line = line;
        this.matcher = this.pattern.matcher(line);
        return this.matcher;
    }

    public abstract void updateUI(Manager var1, TestSession var2);

    public List<String> getRecognizedOutput() {
        return Collections.singletonList(this.line);
    }

    protected static int toMillis(String timeInSeconds) {
        try {
            Double elapsedTimeMillis = Double.parseDouble(timeInSeconds) * 1000.0;
            return elapsedTimeMillis.intValue();
        }
        catch (NumberFormatException nfe) {
            LOGGER.log(Level.WARNING, "Could not parse time, returning 0", nfe);
            return 0;
        }
    }

    protected static String wrap(String string) {
        String regex = string;
        if (!regex.endsWith(".*")) {
            regex = regex + ".*";
        }
        if (!regex.startsWith(".*") && !regex.startsWith("(.*)")) {
            regex = ".*" + regex;
        }
        return regex;
    }
}

