/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.api;

import java.net.URL;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.netbeans.modules.php.editor.api.AbstractElementQuery;
import org.netbeans.modules.php.editor.api.ElementQuery;
import org.netbeans.modules.php.editor.api.NameKind;
import org.netbeans.modules.php.editor.api.QualifiedName;
import org.netbeans.modules.php.editor.api.elements.ClassElement;
import org.netbeans.modules.php.editor.api.elements.ConstantElement;
import org.netbeans.modules.php.editor.api.elements.FieldElement;
import org.netbeans.modules.php.editor.api.elements.FunctionElement;
import org.netbeans.modules.php.editor.api.elements.InterfaceElement;
import org.netbeans.modules.php.editor.api.elements.MethodElement;
import org.netbeans.modules.php.editor.api.elements.NamespaceElement;
import org.netbeans.modules.php.editor.api.elements.PhpElement;
import org.netbeans.modules.php.editor.api.elements.TraitElement;
import org.netbeans.modules.php.editor.api.elements.TypeConstantElement;
import org.netbeans.modules.php.editor.api.elements.TypeElement;
import org.netbeans.modules.php.editor.api.elements.TypeResolver;
import org.netbeans.modules.php.editor.api.elements.VariableElement;
import org.netbeans.modules.php.editor.elements.ClassElementImpl;
import org.netbeans.modules.php.editor.elements.ConstantElementImpl;
import org.netbeans.modules.php.editor.elements.FieldElementImpl;
import org.netbeans.modules.php.editor.elements.FunctionElementImpl;
import org.netbeans.modules.php.editor.elements.InterfaceElementImpl;
import org.netbeans.modules.php.editor.elements.MethodElementImpl;
import org.netbeans.modules.php.editor.elements.NamespaceElementImpl;
import org.netbeans.modules.php.editor.elements.TraitElementImpl;
import org.netbeans.modules.php.editor.elements.TypeConstantElementImpl;
import org.netbeans.modules.php.editor.elements.VariableElementImpl;
import org.netbeans.modules.php.editor.model.Model;
import org.netbeans.modules.php.editor.model.TypeScope;
import org.netbeans.modules.php.editor.model.VariableScope;
import org.netbeans.modules.php.editor.model.impl.VariousUtils;
import org.netbeans.modules.php.editor.model.nodes.ASTNodeInfo;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ClassDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.ConstantDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FieldsDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.InterfaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TraitDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.TypeDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.VariableBase;
import org.openide.filesystems.FileObject;
import org.openide.filesystems.URLMapper;
import org.openide.util.Parameters;

public final class FileElementQuery
extends AbstractElementQuery
implements ElementQuery.File {
    private final FileObject fileObject;
    private final PHPParseResult result;
    private final URL url;
    private final Map<PhpElement, Map<String, VariableElement>> varMap = new HashMap<PhpElement, Map<String, VariableElement>>();
    private final Set<FieldElement> fields = new HashSet<FieldElement>();

    private FileElementQuery(PHPParseResult result) {
        super(ElementQuery.QueryScope.FILE_SCOPE);
        this.result = result;
        this.fileObject = result.getSnapshot().getSource().getFileObject();
        this.url = this.fileObject != null ? URLMapper.findURL((FileObject)this.fileObject, (int)0) : null;
    }

    public static FileElementQuery getInstance(PHPParseResult result) {
        return new FileElementQuery(result);
    }

    public NamespaceElement create(NamespaceDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        NamespaceElement retval = NamespaceElementImpl.fromNode(node, this);
        this.addElement(retval);
        return retval;
    }

    public TypeElement create(NamespaceElement namespace, TypeDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        TypeElement retval = null;
        if (node instanceof ClassDeclaration) {
            retval = this.create(namespace, (ClassDeclaration)node);
        } else if (node instanceof InterfaceDeclaration) {
            retval = this.create(namespace, (InterfaceDeclaration)node);
        } else if (node instanceof TraitDeclaration) {
            retval = this.create(namespace, (TraitDeclaration)node);
        }
        this.addElement(retval);
        return retval;
    }

    public ClassElement create(NamespaceElement namespace, ClassDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        ClassElement retval = ClassElementImpl.fromNode(namespace, node, this);
        this.addElement(retval);
        return retval;
    }

    public InterfaceElement create(NamespaceElement namespace, InterfaceDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        InterfaceElement retval = InterfaceElementImpl.fromNode(namespace, node, this);
        this.addElement(retval);
        return retval;
    }

    public TraitElement create(NamespaceElement namespace, TraitDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        TraitElement retval = TraitElementImpl.fromNode(namespace, node, this);
        this.addElement(retval);
        return retval;
    }

    public FunctionElement create(NamespaceElement namespace, FunctionDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        FunctionElement retval = FunctionElementImpl.fromNode(namespace, node, this);
        this.addElement(retval);
        return retval;
    }

    public MethodElement create(TypeElement type, MethodDeclaration node) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        MethodElement retval = MethodElementImpl.fromNode(type, node, this);
        this.addElement(retval);
        return retval;
    }

    public Set<FieldElement> create(TypeElement type, FieldsDeclaration node) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Set<FieldElement> retval = FieldElementImpl.fromNode(type, node, this);
        for (FieldElement fieldElement : retval) {
            if (this.fields.contains(fieldElement)) continue;
            this.fields.add(fieldElement);
            this.addElement(fieldElement);
        }
        return retval;
    }

    public FieldElement create(TypeElement type, FieldAccess node) {
        VariableElement varDispatcher;
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        HashSet<TypeResolver> resolvers = new HashSet<TypeResolver>();
        resolvers.add(new VariableTypeResolver(node));
        VariableBase dispatcher = node.getDispatcher();
        MethodElement method = this.getLast(MethodElement.class);
        if (method != null && dispatcher instanceof Variable && (varDispatcher = this.createMethodVariable(method, (Variable)dispatcher)).getName(false).equalsIgnoreCase("this")) {
            FieldElement retval = FieldElementImpl.fromNode(type, node, resolvers, this);
            if (!this.fields.contains(retval)) {
                this.fields.add(retval);
                this.addElement(retval);
            }
            return retval;
        }
        return null;
    }

    public VariableElement createTopLevelVariable(Variable node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        HashSet<TypeResolver> resolvers = new HashSet<TypeResolver>();
        resolvers.add(new VariableTypeResolver(node));
        return this.addTopLevelVariable(VariableElementImpl.fromNode(node, resolvers, this));
    }

    public VariableElement createMethodVariable(MethodElement method, Variable node) {
        Parameters.notNull((CharSequence)"method", (Object)method);
        Parameters.notNull((CharSequence)"node", (Object)node);
        HashSet<TypeResolver> resolvers = new HashSet<TypeResolver>();
        resolvers.add(new VariableTypeResolver(node));
        return this.addMethodVariable(method, VariableElementImpl.fromNode(node, resolvers, this));
    }

    public VariableElement createFunctionVariable(FunctionElement function, Variable node) {
        Parameters.notNull((CharSequence)"method", (Object)function);
        Parameters.notNull((CharSequence)"node", (Object)node);
        HashSet<TypeResolver> resolvers = new HashSet<TypeResolver>();
        resolvers.add(new VariableTypeResolver(node));
        return this.addFunctionVariable(function, VariableElementImpl.fromNode(node, resolvers, this));
    }

    public Set<ConstantElement> createConstant(NamespaceElement namespace, ConstantDeclaration node) {
        Parameters.notNull((CharSequence)"node", (Object)node);
        Set<ConstantElement> retval = ConstantElementImpl.fromNode(namespace, node, this);
        this.addElements(retval);
        return retval;
    }

    public Set<TypeConstantElement> createTypeConstant(TypeElement type, ConstantDeclaration node) {
        Parameters.notNull((CharSequence)"type", (Object)type);
        Parameters.notNull((CharSequence)"node", (Object)node);
        Set<TypeConstantElement> retval = TypeConstantElementImpl.fromNode(type, node, this);
        this.addElements(retval);
        return retval;
    }

    @Override
    public FileObject getFileObject() {
        return this.fileObject;
    }

    @Override
    public URL getURL() {
        return this.url;
    }

    @Override
    public PHPParseResult getResult() {
        return this.result;
    }

    @Override
    public Set<MethodElement> getDeclaredMethods(TypeElement typeElement) {
        return this.getMethods(NameKind.exact(typeElement.getFullyQualifiedName()), NameKind.empty());
    }

    @Override
    public Set<FieldElement> getDeclaredFields(TypeElement typeElement) {
        return this.getFields(NameKind.exact(typeElement.getFullyQualifiedName()), NameKind.empty());
    }

    @Override
    public Set<TypeConstantElement> getDeclaredTypeConstants(TypeElement typeElement) {
        return this.getTypeConstants(NameKind.exact(typeElement.getFullyQualifiedName()), NameKind.empty());
    }

    private synchronized VariableElement addVariable(PhpElement scope, VariableElement variable) {
        VariableElement old;
        Map<String, VariableElement> map = this.varMap.get(scope);
        if (map == null) {
            map = new HashMap<String, VariableElement>();
        }
        if ((old = map.put(variable.getName(), variable)) != null) {
            map.put(old.getName(), old);
        }
        this.varMap.put(scope, map);
        return old != null ? old : variable;
    }

    private synchronized VariableElement addFunctionVariable(FunctionElement scope, VariableElement variable) {
        return this.addVariable(scope, variable);
    }

    private synchronized VariableElement addMethodVariable(MethodElement scope, VariableElement variable) {
        return this.addVariable(scope, variable);
    }

    private synchronized VariableElement addTopLevelVariable(VariableElement variable) {
        VariableElement retval = this.addVariable(null, variable);
        if (retval == variable) {
            super.addElement(variable);
        }
        return retval;
    }

    @Override
    public Set<VariableElement> getTopLevelVariables() {
        Map<String, VariableElement> map = this.varMap.get(null);
        return map != null ? new HashSet<VariableElement>(map.values()) : Collections.emptySet();
    }

    @Override
    public Set<VariableElement> getMethodVariables(MethodElement method) {
        Map<String, VariableElement> map = this.varMap.get(method);
        return map != null ? new HashSet<VariableElement>(map.values()) : Collections.emptySet();
    }

    @Override
    public Set<VariableElement> getFunctionVariables(FunctionElement function) {
        Map<String, VariableElement> map = this.varMap.get(function);
        return map != null ? new HashSet<VariableElement>(map.values()) : Collections.emptySet();
    }

    private final class VariableTypeResolver
    implements TypeResolver {
        private final String rawName;
        private QualifiedName name;
        private boolean resolved;
        private final int offset;

        private VariableTypeResolver(Variable var) {
            ASTNodeInfo<Variable> info = ASTNodeInfo.create(var);
            this.rawName = VariousUtils.extractTypeFroVariableBase(info.getOriginalNode());
            this.offset = info.getRange().getStart();
        }

        private VariableTypeResolver(FieldAccess field) {
            ASTNodeInfo<FieldAccess> info = ASTNodeInfo.create(field);
            this.rawName = VariousUtils.extractTypeFroVariableBase(info.getOriginalNode());
            this.offset = info.getRange().getStart();
        }

        @Override
        public synchronized boolean isResolved() {
            return this.resolved;
        }

        @Override
        public boolean canBeResolved() {
            return true;
        }

        @Override
        public String getRawTypeName() {
            return this.rawName;
        }

        @Override
        public synchronized QualifiedName getTypeName(boolean resolve) {
            if (!this.isResolved() && resolve) {
                this.resolved = true;
                Model model = FileElementQuery.this.getResult().getModel();
                VariableScope scope = model.getVariableScope(this.offset);
                if (scope != null) {
                    Collection<? extends TypeScope> types = VariousUtils.getType(scope, this.rawName, this.offset, false);
                    for (TypeScope typeScope : types) {
                        this.name = typeScope.getFullyQualifiedName();
                        if (this.name == null) continue;
                        break;
                    }
                }
            }
            return this.name;
        }
    }
}

