/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.php.editor.verification;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.modules.csl.api.Error;
import org.netbeans.modules.csl.spi.support.CancelSupport;
import org.netbeans.modules.php.api.PhpVersion;
import org.netbeans.modules.php.editor.CodeUtils;
import org.netbeans.modules.php.editor.model.impl.Type;
import org.netbeans.modules.php.editor.parser.PHPParseResult;
import org.netbeans.modules.php.editor.parser.astnodes.ASTNode;
import org.netbeans.modules.php.editor.parser.astnodes.ClassInstanceCreation;
import org.netbeans.modules.php.editor.parser.astnodes.ConditionalExpression;
import org.netbeans.modules.php.editor.parser.astnodes.Expression;
import org.netbeans.modules.php.editor.parser.astnodes.ExpressionArrayAccess;
import org.netbeans.modules.php.editor.parser.astnodes.FormalParameter;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.FunctionInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.GroupUseStatementPart;
import org.netbeans.modules.php.editor.parser.astnodes.Identifier;
import org.netbeans.modules.php.editor.parser.astnodes.InfixExpression;
import org.netbeans.modules.php.editor.parser.astnodes.LambdaFunctionDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.MethodDeclaration;
import org.netbeans.modules.php.editor.parser.astnodes.NamespaceName;
import org.netbeans.modules.php.editor.parser.astnodes.StaticConstantAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticDispatch;
import org.netbeans.modules.php.editor.parser.astnodes.StaticFieldAccess;
import org.netbeans.modules.php.editor.parser.astnodes.StaticMethodInvocation;
import org.netbeans.modules.php.editor.parser.astnodes.Variable;
import org.netbeans.modules.php.editor.parser.astnodes.YieldFromExpression;
import org.netbeans.modules.php.editor.parser.astnodes.visitors.DefaultVisitor;
import org.netbeans.modules.php.editor.verification.Bundle;
import org.netbeans.modules.php.editor.verification.PHPRuleContext;
import org.netbeans.modules.php.editor.verification.UnhandledErrorRule;
import org.netbeans.modules.php.editor.verification.VerificationError;
import org.openide.filesystems.FileObject;

public class PHP70UnhandledError
extends UnhandledErrorRule {
    public String getDisplayName() {
        return Bundle.PHP70UnhandledError_displayName();
    }

    @Override
    public void invoke(PHPRuleContext context, List<Error> errors) {
        PHPParseResult phpParseResult = (PHPParseResult)context.parserResult;
        if (phpParseResult.getProgram() == null) {
            return;
        }
        FileObject fileObject = phpParseResult.getSnapshot().getSource().getFileObject();
        if (fileObject != null && PHP70UnhandledError.appliesTo(fileObject)) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            CheckVisitor checkVisitor = new CheckVisitor(fileObject);
            phpParseResult.getProgram().accept(checkVisitor);
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            errors.addAll(checkVisitor.getErrors());
        }
    }

    private static boolean appliesTo(FileObject fileObject) {
        return CodeUtils.isPhpVersionLessThan(fileObject, PhpVersion.PHP_70);
    }

    private static final class PHP70VersionError
    extends VerificationError {
        private static final String KEY = "Php.Version.70";

        private PHP70VersionError(FileObject fileObject, int startOffset, int endOffset) {
            super(fileObject, startOffset, endOffset);
        }

        public String getDisplayName() {
            return Bundle.PHP70VersionError_displayName();
        }

        public String getDescription() {
            return Bundle.PHP70VersionError_description();
        }

        public String getKey() {
            return KEY;
        }
    }

    private static final class CheckVisitor
    extends DefaultVisitor {
        private static final Set<String> TYPES_FOR_SOURCES = new HashSet<String>(Type.getTypesForEditor());
        private final List<VerificationError> errors = new ArrayList<VerificationError>();
        private final FileObject fileObject;

        public CheckVisitor(FileObject fileObject) {
            this.fileObject = fileObject;
        }

        public Collection<VerificationError> getErrors() {
            return Collections.unmodifiableCollection(this.errors);
        }

        @Override
        public void visit(InfixExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (InfixExpression.OperatorType.SPACESHIP.equals((Object)node.getOperator())) {
                this.createError(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(ConditionalExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (ConditionalExpression.OperatorType.COALESCE.equals((Object)node.getOperator())) {
                this.createError(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(FunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkScalarTypes(node.getFormalParameters());
            this.checkReturnType(node.getReturnType());
            super.visit(node);
        }

        @Override
        public void visit(MethodDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkScalarTypes(node.getFunction().getFormalParameters());
            this.checkReturnType(node.getFunction().getReturnType());
            super.visit(node);
        }

        @Override
        public void visit(LambdaFunctionDeclaration node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkScalarTypes(node.getFormalParameters());
            this.checkReturnType(node.getReturnType());
            super.visit(node);
        }

        @Override
        public void visit(GroupUseStatementPart node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(YieldFromExpression node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.createError(node);
            super.visit(node);
        }

        @Override
        public void visit(ClassInstanceCreation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            if (node.isAnonymous()) {
                this.createError(node);
            }
            super.visit(node);
        }

        @Override
        public void visit(StaticConstantAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDispatcher(node);
            super.visit(node);
        }

        @Override
        public void visit(StaticFieldAccess node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDispatcher(node);
            super.visit(node);
        }

        @Override
        public void visit(StaticMethodInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkDispatcher(node);
            super.visit(node);
        }

        @Override
        public void visit(FunctionInvocation node) {
            if (CancelSupport.getDefault().isCancelled()) {
                return;
            }
            this.checkIssetFunction(node);
            super.visit(node);
        }

        private void checkScalarTypes(List<FormalParameter> formalParameters) {
            for (FormalParameter formalParameter : formalParameters) {
                String typeName = CodeUtils.extractUnqualifiedTypeName(formalParameter);
                if (typeName == null || !TYPES_FOR_SOURCES.contains(typeName)) continue;
                this.createError(formalParameter);
            }
        }

        private void checkReturnType(Expression returnType) {
            if (returnType != null) {
                this.createError(returnType);
            }
        }

        private void checkDispatcher(StaticDispatch node) {
            Expression dispatcher = node.getDispatcher();
            if (dispatcher instanceof NamespaceName || dispatcher instanceof Identifier || dispatcher instanceof Variable) {
                return;
            }
            this.createError(dispatcher);
        }

        private void checkIssetFunction(FunctionInvocation node) {
            String functionName = CodeUtils.extractFunctionName(node);
            if ("isset".equals(functionName)) {
                List<Expression> parameters = node.getParameters();
                for (Expression parameter : parameters) {
                    Expression expression = parameter;
                    if (expression instanceof StaticConstantAccess) {
                        StaticConstantAccess sca = (StaticConstantAccess)expression;
                        expression = sca.getConstant();
                    }
                    if (!(expression instanceof ExpressionArrayAccess)) continue;
                    this.createError(parameter);
                }
            }
        }

        private void createError(int startOffset, int endOffset) {
            this.errors.add(new PHP70VersionError(this.fileObject, startOffset, endOffset));
        }

        private void createError(ASTNode node) {
            this.createError(node.getStartOffset(), node.getEndOffset());
        }

        static {
            TYPES_FOR_SOURCES.remove("array");
            TYPES_FOR_SOURCES.remove("callable");
        }
    }
}

