/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.messaging.handler.annotation.support;

import org.springframework.core.MethodParameter;
import org.springframework.messaging.Message;
import org.springframework.messaging.MessagingException;
import org.springframework.validation.BindingResult;
import org.springframework.validation.ObjectError;

public class MethodArgumentNotValidException
extends MessagingException {
    private final MethodParameter parameter;
    private final BindingResult bindingResult;

    public MethodArgumentNotValidException(Message<?> message, MethodParameter parameter, BindingResult bindingResult) {
        super(message);
        this.parameter = parameter;
        this.bindingResult = bindingResult;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder("Validation failed for parameter at index ").append(this.parameter.getParameterIndex()).append(" in method: ").append(this.parameter.getMethod().toGenericString()).append(", with ").append(this.bindingResult.getErrorCount()).append(" error(s): ");
        for (ObjectError error : this.bindingResult.getAllErrors()) {
            sb.append("[").append(error).append("] ");
        }
        return sb.toString();
    }
}

