/*
 * Decompiled with CFR 0.152.
 */
package org.clang.basic.target.impl;

import org.clang.basic.CallingConv;
import org.clang.basic.LangOptions;
import org.clang.basic.MacroBuilder;
import org.clang.basic.target.TargetInfo;
import org.clang.basic.target.TargetOptions;
import org.clang.basic.target.impl.ARMleTargetInfo;
import org.clang.basic.target.impl.WindowsTargetInfo;
import org.clank.support.Destructors;
import org.clank.support.NativePointer;
import org.llvm.adt.Triple;
import org.llvm.adt.Twine;

public class WindowsARMTargetInfo
extends WindowsTargetInfo<ARMleTargetInfo>
implements Destructors.ClassWithDestructor {
    private Triple _Triple;

    public WindowsARMTargetInfo(Triple Triple2, TargetOptions Opts) {
        super(new ARMleTargetInfo(Triple2, Opts), Triple2, Opts);
        this._Triple = new Triple(Triple2);
        ((ARMleTargetInfo)this.tgt).WCharType = TargetInfo.IntType.UnsignedShort;
        ((ARMleTargetInfo)this.tgt).SizeType = TargetInfo.IntType.UnsignedInt;
    }

    @Override
    public void getVisualStudioDefines(LangOptions Opts, MacroBuilder Builder2) {
        super.getVisualStudioDefines(Opts, Builder2);
        Builder2.defineMacro(new Twine("_M_ARM_NT"), new Twine(NativePointer.$1));
        Builder2.defineMacro(new Twine("_M_ARMT"), new Twine("_M_ARM"));
        Builder2.defineMacro(new Twine("_M_THUMB"), new Twine("_M_ARM"));
        assert (this._Triple.getArch() == Triple.ArchType.arm || this._Triple.getArch() == Triple.ArchType.thumb) : "invalid architecture for Windows ARM target info";
        int Offset = this._Triple.getArch() == Triple.ArchType.arm ? 4 : 6;
        Builder2.defineMacro(new Twine("_M_ARM"), new Twine(this._Triple.getArchName().substr(Offset)));
        Builder2.defineMacro(new Twine("_M_ARM_FP"), new Twine("31"));
    }

    @Override
    public TargetInfo.BuiltinVaListKind getBuiltinVaListKind() {
        return TargetInfo.BuiltinVaListKind.CharPtrBuiltinVaList;
    }

    @Override
    public TargetInfo.CallingConvCheckResult checkCallingConvention(CallingConv CC) {
        switch (CC) {
            case CC_X86StdCall: 
            case CC_X86ThisCall: 
            case CC_X86FastCall: 
            case CC_X86VectorCall: {
                return TargetInfo.CallingConvCheckResult.CCCR_Ignore;
            }
            case CC_C: {
                return TargetInfo.CallingConvCheckResult.CCCR_OK;
            }
        }
        return TargetInfo.CallingConvCheckResult.CCCR_Warning;
    }

    @Override
    public void $destroy() {
        this._Triple.$destroy();
        super.$destroy();
    }

    @Override
    public String toString() {
        return "Triple=" + this._Triple + super.toString();
    }
}

