/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.hudson.php.options;

import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import java.util.prefs.Preferences;
import javax.swing.event.ChangeListener;
import org.netbeans.api.annotations.common.CheckForNull;
import org.openide.util.ChangeSupport;
import org.openide.util.NbPreferences;

public final class HudsonOptions {
    private static final Logger LOGGER = Logger.getLogger(HudsonOptions.class.getName());
    private static final String PREFERENCES_PATH = "hudson";
    private static final HudsonOptions INSTANCE = new HudsonOptions();
    private static final String BUILD_XML = "build.xml.path";
    private static final String JOB_CONFIG = "job.config.path";
    private static final String PHP_UNIT_CONFIG = "phpunit.config.path";
    final ChangeSupport changeSupport = new ChangeSupport((Object)this);

    private HudsonOptions() {
        this.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(PreferenceChangeEvent evt) {
                HudsonOptions.this.changeSupport.fireChange();
            }
        });
    }

    public static HudsonOptions getInstance() {
        return INSTANCE;
    }

    public void addChangeListener(ChangeListener listener) {
        this.changeSupport.addChangeListener(listener);
    }

    public void removeChangeListener(ChangeListener listener) {
        this.changeSupport.removeChangeListener(listener);
    }

    @CheckForNull
    public String getBuildXml() {
        return this.getPreferences().get(BUILD_XML, null);
    }

    public void setBuildXml(String buildXml) {
        this.getPreferences().put(BUILD_XML, buildXml);
    }

    @CheckForNull
    public String getJobConfig() {
        return this.getPreferences().get(JOB_CONFIG, null);
    }

    public void setJobConfig(String jobConfig) {
        this.getPreferences().put(JOB_CONFIG, jobConfig);
    }

    @CheckForNull
    public String getPhpUnitConfig() {
        return this.getPreferences().get(PHP_UNIT_CONFIG, null);
    }

    public void setPhpUnitConfig(String phpUnitConfig) {
        this.getPreferences().put(PHP_UNIT_CONFIG, phpUnitConfig);
    }

    private Preferences getPreferences() {
        return NbPreferences.forModule(HudsonOptions.class).node(PREFERENCES_PATH);
    }
}

