#------------------------------------------------------------------------------
# File:         TagLookup.pm
#
# Description:  Fast lookup for ExifTool tags
#
# Notes:        This lookup is used to look up tag names for writing
#
# Revisions:    2004-12-31 - P. Harvey Created
#               2013-01-06 - PH Allow wildcards in FindTagInfo()
#------------------------------------------------------------------------------

package Image::ExifTool::TagLookup;

use strict;
require Exporter;

use vars qw($VERSION @ISA @EXPORT_OK);
use Image::ExifTool qw(:Utils);

$VERSION = '1.12';
@ISA = qw(Exporter);
@EXPORT_OK = qw(FindTagInfo TagExists);

sub AddTags($$);
sub AddFields($$$$$$;$$);

#
# Note: the lists below were generated by Image::ExifTool::BuildTagLookup
#

#++++ Begin automatically generated code ++++

# list of tables containing writable tags
my @tableList = (
	'Image::ExifTool::APP12::Ducky',
	'Image::ExifTool::Apple::Main',
	'Image::ExifTool::Canon::AFConfig',
	'Image::ExifTool::Canon::AFMicroAdj',
	'Image::ExifTool::Canon::Ambience',
	'Image::ExifTool::Canon::AspectInfo',
	'Image::ExifTool::Canon::CameraInfo1000D',
	'Image::ExifTool::Canon::CameraInfo1D',
	'Image::ExifTool::Canon::CameraInfo1DX',
	'Image::ExifTool::Canon::CameraInfo1DmkII',
	'Image::ExifTool::Canon::CameraInfo1DmkIII',
	'Image::ExifTool::Canon::CameraInfo1DmkIIN',
	'Image::ExifTool::Canon::CameraInfo1DmkIV',
	'Image::ExifTool::Canon::CameraInfo40D',
	'Image::ExifTool::Canon::CameraInfo450D',
	'Image::ExifTool::Canon::CameraInfo500D',
	'Image::ExifTool::Canon::CameraInfo50D',
	'Image::ExifTool::Canon::CameraInfo550D',
	'Image::ExifTool::Canon::CameraInfo5D',
	'Image::ExifTool::Canon::CameraInfo5DmkII',
	'Image::ExifTool::Canon::CameraInfo5DmkIII',
	'Image::ExifTool::Canon::CameraInfo600D',
	'Image::ExifTool::Canon::CameraInfo60D',
	'Image::ExifTool::Canon::CameraInfo650D',
	'Image::ExifTool::Canon::CameraInfo6D',
	'Image::ExifTool::Canon::CameraInfo70D',
	'Image::ExifTool::Canon::CameraInfo7D',
	'Image::ExifTool::Canon::CameraInfoPowerShot',
	'Image::ExifTool::Canon::CameraInfoPowerShot2',
	'Image::ExifTool::Canon::CameraInfoUnknown32',
	'Image::ExifTool::Canon::CameraSettings',
	'Image::ExifTool::Canon::ColorBalance',
	'Image::ExifTool::Canon::ColorCalib',
	'Image::ExifTool::Canon::ColorCoefs',
	'Image::ExifTool::Canon::ColorData1',
	'Image::ExifTool::Canon::ColorData2',
	'Image::ExifTool::Canon::ColorData3',
	'Image::ExifTool::Canon::ColorData4',
	'Image::ExifTool::Canon::ColorData5',
	'Image::ExifTool::Canon::ColorData6',
	'Image::ExifTool::Canon::ColorData7',
	'Image::ExifTool::Canon::ColorData8',
	'Image::ExifTool::Canon::ColorInfo',
	'Image::ExifTool::Canon::ContrastInfo',
	'Image::ExifTool::Canon::CropInfo',
	'Image::ExifTool::Canon::FaceDetect1',
	'Image::ExifTool::Canon::FaceDetect2',
	'Image::ExifTool::Canon::FaceDetect3',
	'Image::ExifTool::Canon::FileInfo',
	'Image::ExifTool::Canon::Flags',
	'Image::ExifTool::Canon::FocalLength',
	'Image::ExifTool::Canon::HDRInfo',
	'Image::ExifTool::Canon::LensInfo',
	'Image::ExifTool::Canon::LightingOpt',
	'Image::ExifTool::Canon::Main',
	'Image::ExifTool::Canon::MeasuredColor',
	'Image::ExifTool::Canon::ModifiedInfo',
	'Image::ExifTool::Canon::MovieInfo',
	'Image::ExifTool::Canon::MultiExp',
	'Image::ExifTool::Canon::MyColors',
	'Image::ExifTool::Canon::PSInfo',
	'Image::ExifTool::Canon::PSInfo2',
	'Image::ExifTool::Canon::Panorama',
	'Image::ExifTool::Canon::PreviewImageInfo',
	'Image::ExifTool::Canon::Processing',
	'Image::ExifTool::Canon::SerialInfo',
	'Image::ExifTool::Canon::ShotInfo',
	'Image::ExifTool::Canon::TimeInfo',
	'Image::ExifTool::Canon::VignettingCorr',
	'Image::ExifTool::Canon::VignettingCorr2',
	'Image::ExifTool::CanonCustom::Functions10D',
	'Image::ExifTool::CanonCustom::Functions1D',
	'Image::ExifTool::CanonCustom::Functions2',
	'Image::ExifTool::CanonCustom::Functions20D',
	'Image::ExifTool::CanonCustom::Functions30D',
	'Image::ExifTool::CanonCustom::Functions350D',
	'Image::ExifTool::CanonCustom::Functions400D',
	'Image::ExifTool::CanonCustom::Functions5D',
	'Image::ExifTool::CanonCustom::FunctionsD30',
	'Image::ExifTool::CanonCustom::PersonalFuncValues',
	'Image::ExifTool::CanonCustom::PersonalFuncs',
	'Image::ExifTool::CanonRaw::ExposureInfo',
	'Image::ExifTool::CanonRaw::FlashInfo',
	'Image::ExifTool::CanonRaw::ImageFormat',
	'Image::ExifTool::CanonRaw::ImageInfo',
	'Image::ExifTool::CanonRaw::Main',
	'Image::ExifTool::CanonRaw::MakeModel',
	'Image::ExifTool::CanonRaw::RawJpgInfo',
	'Image::ExifTool::CanonRaw::TimeStamp',
	'Image::ExifTool::CanonVRD::CropInfo',
	'Image::ExifTool::CanonVRD::DR4',
	'Image::ExifTool::CanonVRD::DR4Header',
	'Image::ExifTool::CanonVRD::GammaInfo',
	'Image::ExifTool::CanonVRD::Main',
	'Image::ExifTool::CanonVRD::ToneCurve',
	'Image::ExifTool::CanonVRD::Ver1',
	'Image::ExifTool::CanonVRD::Ver2',
	'Image::ExifTool::Casio::FaceInfo1',
	'Image::ExifTool::Casio::FaceInfo2',
	'Image::ExifTool::Casio::Main',
	'Image::ExifTool::Casio::Type2',
	'Image::ExifTool::Composite',
	'Image::ExifTool::DNG::AdobeData',
	'Image::ExifTool::DarwinCore::Main',
	'Image::ExifTool::Exif::Main',
	'Image::ExifTool::Extra',
	'Image::ExifTool::FLIR::Main',
	'Image::ExifTool::FotoStation::Main',
	'Image::ExifTool::FotoStation::SoftEdit',
	'Image::ExifTool::FujiFilm::Main',
	'Image::ExifTool::GE::Main',
	'Image::ExifTool::GPS::Main',
	'Image::ExifTool::IPTC::ApplicationRecord',
	'Image::ExifTool::IPTC::EnvelopeRecord',
	'Image::ExifTool::IPTC::NewsPhoto',
	'Image::ExifTool::JFIF::Main',
	'Image::ExifTool::Jpeg2000::Main',
	'Image::ExifTool::Kodak::CameraInfo',
	'Image::ExifTool::Kodak::IFD',
	'Image::ExifTool::Kodak::KDC_IFD',
	'Image::ExifTool::Kodak::Main',
	'Image::ExifTool::Kodak::Meta',
	'Image::ExifTool::Kodak::SubIFD0',
	'Image::ExifTool::Kodak::SubIFD1',
	'Image::ExifTool::Kodak::SubIFD2',
	'Image::ExifTool::Kodak::SubIFD3',
	'Image::ExifTool::Kodak::SubIFD5',
	'Image::ExifTool::Kodak::Type10',
	'Image::ExifTool::Kodak::Type2',
	'Image::ExifTool::Kodak::Type3',
	'Image::ExifTool::Kodak::Type4',
	'Image::ExifTool::Kodak::Type7',
	'Image::ExifTool::Kodak::Type9',
	'Image::ExifTool::MIE::Audio',
	'Image::ExifTool::MIE::Camera',
	'Image::ExifTool::MIE::Doc',
	'Image::ExifTool::MIE::Extender',
	'Image::ExifTool::MIE::Flash',
	'Image::ExifTool::MIE::GPS',
	'Image::ExifTool::MIE::Geo',
	'Image::ExifTool::MIE::Image',
	'Image::ExifTool::MIE::Lens',
	'Image::ExifTool::MIE::Main',
	'Image::ExifTool::MIE::Orient',
	'Image::ExifTool::MIE::Preview',
	'Image::ExifTool::MIE::Thumbnail',
	'Image::ExifTool::MIE::UTM',
	'Image::ExifTool::MIE::Video',
	'Image::ExifTool::MWG::Collections',
	'Image::ExifTool::MWG::Keywords',
	'Image::ExifTool::MWG::Regions',
	'Image::ExifTool::Microsoft::MP',
	'Image::ExifTool::Microsoft::MP1',
	'Image::ExifTool::Microsoft::Stitch',
	'Image::ExifTool::Microsoft::XMP',
	'Image::ExifTool::Minolta::CameraInfoA100',
	'Image::ExifTool::Minolta::CameraSettings',
	'Image::ExifTool::Minolta::CameraSettings5D',
	'Image::ExifTool::Minolta::CameraSettings7D',
	'Image::ExifTool::Minolta::CameraSettingsA100',
	'Image::ExifTool::Minolta::ISInfoA100',
	'Image::ExifTool::Minolta::Main',
	'Image::ExifTool::Minolta::WBInfoA100',
	'Image::ExifTool::MinoltaRaw::PRD',
	'Image::ExifTool::MinoltaRaw::RIF',
	'Image::ExifTool::MinoltaRaw::WBG',
	'Image::ExifTool::Nikon::AFInfo',
	'Image::ExifTool::Nikon::AFInfo2',
	'Image::ExifTool::Nikon::AFTune',
	'Image::ExifTool::Nikon::BarometerInfo',
	'Image::ExifTool::Nikon::CaptureOutput',
	'Image::ExifTool::Nikon::ColorBalance1',
	'Image::ExifTool::Nikon::ColorBalance2',
	'Image::ExifTool::Nikon::ColorBalance3',
	'Image::ExifTool::Nikon::ColorBalance4',
	'Image::ExifTool::Nikon::ColorBalanceA',
	'Image::ExifTool::Nikon::ColorBalanceUnknown',
	'Image::ExifTool::Nikon::DistortInfo',
	'Image::ExifTool::Nikon::FaceDetect',
	'Image::ExifTool::Nikon::FileInfo',
	'Image::ExifTool::Nikon::FlashInfo0100',
	'Image::ExifTool::Nikon::FlashInfo0102',
	'Image::ExifTool::Nikon::FlashInfo0103',
	'Image::ExifTool::Nikon::GEM',
	'Image::ExifTool::Nikon::HDRInfo',
	'Image::ExifTool::Nikon::ISOInfo',
	'Image::ExifTool::Nikon::LensData00',
	'Image::ExifTool::Nikon::LensData01',
	'Image::ExifTool::Nikon::LensData0204',
	'Image::ExifTool::Nikon::LensData0400',
	'Image::ExifTool::Nikon::LocationInfo',
	'Image::ExifTool::Nikon::Main',
	'Image::ExifTool::Nikon::MultiExposure',
	'Image::ExifTool::Nikon::PictureControl',
	'Image::ExifTool::Nikon::PreviewIFD',
	'Image::ExifTool::Nikon::ROC',
	'Image::ExifTool::Nikon::RetouchInfo',
	'Image::ExifTool::Nikon::Scan',
	'Image::ExifTool::Nikon::ShotInfo',
	'Image::ExifTool::Nikon::ShotInfoD300S',
	'Image::ExifTool::Nikon::ShotInfoD300a',
	'Image::ExifTool::Nikon::ShotInfoD300b',
	'Image::ExifTool::Nikon::ShotInfoD3S',
	'Image::ExifTool::Nikon::ShotInfoD3X',
	'Image::ExifTool::Nikon::ShotInfoD3a',
	'Image::ExifTool::Nikon::ShotInfoD3b',
	'Image::ExifTool::Nikon::ShotInfoD40',
	'Image::ExifTool::Nikon::ShotInfoD4S',
	'Image::ExifTool::Nikon::ShotInfoD5000',
	'Image::ExifTool::Nikon::ShotInfoD5100',
	'Image::ExifTool::Nikon::ShotInfoD5200',
	'Image::ExifTool::Nikon::ShotInfoD700',
	'Image::ExifTool::Nikon::ShotInfoD7000',
	'Image::ExifTool::Nikon::ShotInfoD80',
	'Image::ExifTool::Nikon::ShotInfoD800',
	'Image::ExifTool::Nikon::ShotInfoD810',
	'Image::ExifTool::Nikon::ShotInfoD90',
	'Image::ExifTool::Nikon::Type2',
	'Image::ExifTool::Nikon::VRInfo',
	'Image::ExifTool::Nikon::WorldTime',
	'Image::ExifTool::NikonCapture::Brightness',
	'Image::ExifTool::NikonCapture::ColorBoost',
	'Image::ExifTool::NikonCapture::CropData',
	'Image::ExifTool::NikonCapture::DLightingHQ',
	'Image::ExifTool::NikonCapture::DLightingHS',
	'Image::ExifTool::NikonCapture::Exposure',
	'Image::ExifTool::NikonCapture::HighlightData',
	'Image::ExifTool::NikonCapture::Main',
	'Image::ExifTool::NikonCapture::NoiseReduction',
	'Image::ExifTool::NikonCapture::PhotoEffects',
	'Image::ExifTool::NikonCapture::PictureCtrl',
	'Image::ExifTool::NikonCapture::RedEyeData',
	'Image::ExifTool::NikonCapture::UnsharpData',
	'Image::ExifTool::NikonCapture::WBAdjData',
	'Image::ExifTool::NikonCustom::SettingsD3',
	'Image::ExifTool::NikonCustom::SettingsD4',
	'Image::ExifTool::NikonCustom::SettingsD40',
	'Image::ExifTool::NikonCustom::SettingsD5000',
	'Image::ExifTool::NikonCustom::SettingsD5100',
	'Image::ExifTool::NikonCustom::SettingsD5200',
	'Image::ExifTool::NikonCustom::SettingsD700',
	'Image::ExifTool::NikonCustom::SettingsD7000',
	'Image::ExifTool::NikonCustom::SettingsD80',
	'Image::ExifTool::NikonCustom::SettingsD800',
	'Image::ExifTool::NikonCustom::SettingsD810',
	'Image::ExifTool::NikonCustom::SettingsD90',
	'Image::ExifTool::Nintendo::CameraInfo',
	'Image::ExifTool::Olympus::CameraSettings',
	'Image::ExifTool::Olympus::Equipment',
	'Image::ExifTool::Olympus::FETags',
	'Image::ExifTool::Olympus::FocusInfo',
	'Image::ExifTool::Olympus::ImageProcessing',
	'Image::ExifTool::Olympus::Main',
	'Image::ExifTool::Olympus::RawDevelopment',
	'Image::ExifTool::Olympus::RawDevelopment2',
	'Image::ExifTool::Olympus::RawInfo',
	'Image::ExifTool::PDF::Info',
	'Image::ExifTool::PNG::Main',
	'Image::ExifTool::PNG::PhysicalPixel',
	'Image::ExifTool::PNG::TextualData',
	'Image::ExifTool::Panasonic::Data1',
	'Image::ExifTool::Panasonic::FaceDetInfo',
	'Image::ExifTool::Panasonic::FaceRecInfo',
	'Image::ExifTool::Panasonic::Leica2',
	'Image::ExifTool::Panasonic::Leica3',
	'Image::ExifTool::Panasonic::Leica5',
	'Image::ExifTool::Panasonic::Leica6',
	'Image::ExifTool::Panasonic::Main',
	'Image::ExifTool::Panasonic::ShotInfo',
	'Image::ExifTool::Panasonic::Subdir',
	'Image::ExifTool::PanasonicRaw::DistortionInfo',
	'Image::ExifTool::PanasonicRaw::Main',
	'Image::ExifTool::PanasonicRaw::WBInfo',
	'Image::ExifTool::PanasonicRaw::WBInfo2',
	'Image::ExifTool::Pentax::AEInfo',
	'Image::ExifTool::Pentax::AEInfo2',
	'Image::ExifTool::Pentax::AEInfo3',
	'Image::ExifTool::Pentax::AFInfo',
	'Image::ExifTool::Pentax::AWBInfo',
	'Image::ExifTool::Pentax::BatteryInfo',
	'Image::ExifTool::Pentax::CameraInfo',
	'Image::ExifTool::Pentax::CameraSettings',
	'Image::ExifTool::Pentax::ColorInfo',
	'Image::ExifTool::Pentax::EVStepInfo',
	'Image::ExifTool::Pentax::FaceInfo',
	'Image::ExifTool::Pentax::FacePos',
	'Image::ExifTool::Pentax::FaceSize',
	'Image::ExifTool::Pentax::FilterInfo',
	'Image::ExifTool::Pentax::FlashInfo',
	'Image::ExifTool::Pentax::KelvinWB',
	'Image::ExifTool::Pentax::LensCorr',
	'Image::ExifTool::Pentax::LensData',
	'Image::ExifTool::Pentax::LensInfo',
	'Image::ExifTool::Pentax::LensInfo2',
	'Image::ExifTool::Pentax::LensInfo3',
	'Image::ExifTool::Pentax::LensInfo4',
	'Image::ExifTool::Pentax::LensInfo5',
	'Image::ExifTool::Pentax::LensInfoQ',
	'Image::ExifTool::Pentax::LensRec',
	'Image::ExifTool::Pentax::LevelInfo',
	'Image::ExifTool::Pentax::Main',
	'Image::ExifTool::Pentax::SRInfo',
	'Image::ExifTool::Pentax::SRInfo2',
	'Image::ExifTool::Pentax::ShotInfo',
	'Image::ExifTool::Pentax::TempInfo',
	'Image::ExifTool::Pentax::TimeInfo',
	'Image::ExifTool::Pentax::Type2',
	'Image::ExifTool::Pentax::WBLevels',
	'Image::ExifTool::PhotoMechanic::SoftEdit',
	'Image::ExifTool::PhotoMechanic::XMP',
	'Image::ExifTool::Photoshop::JPEG_Quality',
	'Image::ExifTool::Photoshop::Main',
	'Image::ExifTool::Photoshop::Resolution',
	'Image::ExifTool::PostScript::Main',
	'Image::ExifTool::QuickTime::MediaHeader',
	'Image::ExifTool::QuickTime::MovieHeader',
	'Image::ExifTool::QuickTime::Preview',
	'Image::ExifTool::QuickTime::TrackHeader',
	'Image::ExifTool::Reconyx::Main',
	'Image::ExifTool::Ricoh::FaceInfo',
	'Image::ExifTool::Ricoh::FirmwareInfo',
	'Image::ExifTool::Ricoh::ImageInfo',
	'Image::ExifTool::Ricoh::Main',
	'Image::ExifTool::Ricoh::SerialInfo',
	'Image::ExifTool::Ricoh::Subdir',
	'Image::ExifTool::Ricoh::ThetaSubdir',
	'Image::ExifTool::Samsung::Main',
	'Image::ExifTool::Samsung::PictureWizard',
	'Image::ExifTool::Samsung::Type2',
	'Image::ExifTool::Sanyo::FaceInfo',
	'Image::ExifTool::Sanyo::Main',
	'Image::ExifTool::Sigma::Main',
	'Image::ExifTool::Sony::AFInfo',
	'Image::ExifTool::Sony::AFStatus15',
	'Image::ExifTool::Sony::AFStatus19',
	'Image::ExifTool::Sony::CameraInfo',
	'Image::ExifTool::Sony::CameraInfo2',
	'Image::ExifTool::Sony::CameraInfo3',
	'Image::ExifTool::Sony::CameraSettings',
	'Image::ExifTool::Sony::CameraSettings2',
	'Image::ExifTool::Sony::CameraSettings3',
	'Image::ExifTool::Sony::Ericsson',
	'Image::ExifTool::Sony::ExtraInfo',
	'Image::ExifTool::Sony::ExtraInfo2',
	'Image::ExifTool::Sony::ExtraInfo3',
	'Image::ExifTool::Sony::FaceInfo',
	'Image::ExifTool::Sony::FaceInfo1',
	'Image::ExifTool::Sony::FaceInfo2',
	'Image::ExifTool::Sony::FaceInfoA',
	'Image::ExifTool::Sony::FocusInfo',
	'Image::ExifTool::Sony::Main',
	'Image::ExifTool::Sony::MeterInfo',
	'Image::ExifTool::Sony::MoreInfo0201',
	'Image::ExifTool::Sony::MoreInfo0401',
	'Image::ExifTool::Sony::MoreSettings',
	'Image::ExifTool::Sony::Panorama',
	'Image::ExifTool::Sony::ShotInfo',
	'Image::ExifTool::Sony::Tag2010a',
	'Image::ExifTool::Sony::Tag2010b',
	'Image::ExifTool::Sony::Tag2010c',
	'Image::ExifTool::Sony::Tag2010d',
	'Image::ExifTool::Sony::Tag2010e',
	'Image::ExifTool::Sony::Tag2010f',
	'Image::ExifTool::Sony::Tag2010g',
	'Image::ExifTool::Sony::Tag2010h',
	'Image::ExifTool::Sony::Tag9050',
	'Image::ExifTool::Sony::Tag9400a',
	'Image::ExifTool::Sony::Tag9400b',
	'Image::ExifTool::Sony::Tag9400c',
	'Image::ExifTool::Sony::Tag9402',
	'Image::ExifTool::Sony::Tag9403',
	'Image::ExifTool::Sony::Tag9404a',
	'Image::ExifTool::Sony::Tag9404b',
	'Image::ExifTool::Sony::Tag9405a',
	'Image::ExifTool::Sony::Tag9405b',
	'Image::ExifTool::Sony::Tag9406',
	'Image::ExifTool::Sony::Tag940a',
	'Image::ExifTool::Sony::Tag940c',
	'Image::ExifTool::SonyIDC::Main',
	'Image::ExifTool::XMP::Album',
	'Image::ExifTool::XMP::DICOM',
	'Image::ExifTool::XMP::ExpressionMedia',
	'Image::ExifTool::XMP::GPano',
	'Image::ExifTool::XMP::GettyImages',
	'Image::ExifTool::XMP::Lightroom',
	'Image::ExifTool::XMP::MediaPro',
	'Image::ExifTool::XMP::aas',
	'Image::ExifTool::XMP::acdsee',
	'Image::ExifTool::XMP::apple_fi',
	'Image::ExifTool::XMP::aux',
	'Image::ExifTool::XMP::cc',
	'Image::ExifTool::XMP::cell',
	'Image::ExifTool::XMP::creatorAtom',
	'Image::ExifTool::XMP::crs',
	'Image::ExifTool::XMP::dc',
	'Image::ExifTool::XMP::dex',
	'Image::ExifTool::XMP::digiKam',
	'Image::ExifTool::XMP::exif',
	'Image::ExifTool::XMP::exifEX',
	'Image::ExifTool::XMP::extensis',
	'Image::ExifTool::XMP::fpv',
	'Image::ExifTool::XMP::ics',
	'Image::ExifTool::XMP::iptcCore',
	'Image::ExifTool::XMP::iptcExt',
	'Image::ExifTool::XMP::pdf',
	'Image::ExifTool::XMP::photoshop',
	'Image::ExifTool::XMP::plus',
	'Image::ExifTool::XMP::pmi',
	'Image::ExifTool::XMP::prism',
	'Image::ExifTool::XMP::prl',
	'Image::ExifTool::XMP::prm',
	'Image::ExifTool::XMP::pur',
	'Image::ExifTool::XMP::rdf',
	'Image::ExifTool::XMP::swf',
	'Image::ExifTool::XMP::tiff',
	'Image::ExifTool::XMP::x',
	'Image::ExifTool::XMP::xmp',
	'Image::ExifTool::XMP::xmpBJ',
	'Image::ExifTool::XMP::xmpDM',
	'Image::ExifTool::XMP::xmpMM',
	'Image::ExifTool::XMP::xmpNote',
	'Image::ExifTool::XMP::xmpPLUS',
	'Image::ExifTool::XMP::xmpRights',
	'Image::ExifTool::XMP::xmpTPg',
);

# lookup for all writable tags
my %tagLookup = (
	'aberrationcorrectiondistance' => { 96 => 0x69 },
	'about' => { 412 => 'about' },
	'aboutcvterm' => { 403 => 'AboutCvTerm' },
	'aboutcvtermcvid' => { 403 => [\'AboutCvTerm','AboutCvTermCvId'] },
	'aboutcvtermid' => { 403 => [\'AboutCvTerm','AboutCvTermCvTermId'] },
	'aboutcvtermname' => { 403 => [\'AboutCvTerm','AboutCvTermCvTermName'] },
	'aboutcvtermrefinedabout' => { 403 => [\'AboutCvTerm','AboutCvTermCvTermRefinedAbout'] },
	'abspeakaudiofilepath' => { 418 => 'absPeakAudioFilePath' },
	'accelerationtracking' => { 72 => 0x518 },
	'accelerometer' => { 325 => 0x3 },
	'accelerometerx' => { 267 => 0x8d },
	'accelerometery' => { 267 => 0x8e },
	'accelerometerz' => { 267 => 0x8c },
	'accessoryserialnumber' => { 267 => 0x54 },
	'accessorytype' => { 267 => 0x53 },
	'acedemicfield' => { 408 => 'acedemicField' },
	'actionadvised' => { 112 => 0x2a },
	'activearea' => { 104 => 0xc68d },
	'actived-lighting' => { 191 => 0x22, 225 => 0x24 },
	'actived-lightingmode' => { 225 => 0x25 },
	'adaptervoltage' => { 118 => 0x407 },
	'addaspectratioinfo' => { 72 => 0x80e },
	'additionalmodelinformation' => { 403 => 'AddlModelInfo' },
	'addoriginaldecisiondata' => { 72 => 0x80f, 73 => 0x11, 74 => 0x13, 77 => 0x14 },
	'address' => { 139 => 'Address' },
	'adjustmentmode' => { 331 => 0x15 },
	'adobe' => { 105 => 'Adobe' },
	'adultcontentwarning' => { 406 => 'AdultContentWarning', 411 => 'adultContentWarning' },
	'advancedfilter' => { 109 => 0x1201 },
	'advancedraw' => { 227 => 0x76a43203 },
	'advancedscenetype' => { 267 => 0x3d },
	'advisory' => { 416 => 'Advisory' },
	'ae_iso' => { 274 => 0x2, 275 => 0x4, 276 => 0x12 },
	'aeaperture' => { 274 => 0x1, 275 => 0x3, 276 => 0x11 },
	'aeaperturesteps' => { 274 => 0x8, 275 => 0xb },
	'aebautocancel' => { 72 => 0x104 },
	'aebbracketvalue' => { 66 => 0x11 },
	'aebsequence' => { 72 => 0x105 },
	'aebsequenceautocancel' => { 70 => 0x9, 71 => 0x9, 73 => 0x8, 74 => 0x9, 77 => 0x9, 78 => 0x7 },
	'aebshotcount' => { 72 => 0x106 },
	'aebxv' => { 274 => 0x4, 275 => 0x6 },
	'aeerror' => { 275 => 0x8 },
	'aeexposuretime' => { 274 => 0x0, 275 => 0x2, 276 => 0x10 },
	'aelbutton' => { 159 => 0x45 },
	'aelexposureindicator' => { 159 => 0x51 },
	'aelock' => { 159 => 0x5b, 236 => '4.2', 242 => '4.2', 247 => 0x201, 300 => 0x48, 338 => 0x40, 339 => 0x40, 340 => [0x86,0x286] },
	'aelockbutton' => { 234 => '16.1', 236 => '4.1', 237 => '15.1', 238 => '16.1', 239 => '16.1', 240 => '30.1', 241 => '16.1', 242 => '4.1', 244 => '17.1', 245 => '17.1' },
	'aelockbuttonplusdials' => { 234 => '16.2', 240 => '32.1', 244 => '44.1' },
	'aelockformb-d80' => { 245 => '3.1' },
	'aemaxaperture' => { 274 => 0x9, 275 => 0x10, 276 => 0x1c },
	'aemaxaperture2' => { 274 => 0xa, 275 => 0x11, 276 => 0x1d },
	'aemeteringmode' => { 274 => 0xc },
	'aemeteringmode2' => { 274 => '13.1' },
	'aemeteringsegments' => { 162 => 0x628, 300 => 0x209 },
	'aemicroadjustment' => { 72 => 0x110 },
	'aeminaperture' => { 274 => 0xb, 275 => 0x12, 276 => 0x1e },
	'aeminexposuretime' => { 274 => 0x5, 275 => 0x13, 276 => 0x1f },
	'aeprogrammode' => { 274 => 0x6 },
	'aeprojectlink' => { 392 => 'aeProjectLink' },
	'aeprojectlinkcompositionid' => { 392 => [\'aeProjectLink','aeProjectLinkCompositionID'] },
	'aeprojectlinkfullpath' => { 392 => [\'aeProjectLink','aeProjectLinkFullPath'] },
	'aeprojectlinkrenderoutputmoduleindex' => { 392 => [\'aeProjectLink','aeProjectLinkRenderOutputModuleIndex'] },
	'aeprojectlinkrenderqueueitemid' => { 392 => [\'aeProjectLink','aeProjectLinkRenderQueueItemID'] },
	'aeprojectlinkrendertimestamp' => { 392 => [\'aeProjectLink','aeProjectLinkRenderTimeStamp'] },
	'aesetting' => { 30 => 0x21 },
	'aewhitebalance' => { 274 => 0xd },
	'aexv' => { 274 => 0x3, 275 => 0x5 },
	'af-cpriorityselection' => { 234 => '1.1', 235 => '1.1', 238 => '0.1', 239 => '0.1', 240 => '1.1', 241 => '0.1', 244 => '1.1' },
	'af-onformb-d10' => { 234 => '3.3', 240 => '3.2' },
	'af-onformb-d11' => { 241 => '2.2' },
	'af-onformb-d12' => { 244 => '50.1' },
	'af-spriorityselection' => { 234 => '1.2', 235 => '1.2', 240 => '1.2', 241 => '0.2', 244 => '1.2' },
	'afacceldeceltracking' => { 2 => 0x3 },
	'afactivation' => { 234 => '2.1', 235 => '2.1', 240 => '2.1', 244 => '2.1' },
	'afadjustment' => { 300 => 0x72 },
	'afandmeteringbuttons' => { 72 => 0x701 },
	'afaperture' => { 187 => 0x5, 188 => 0x5 },
	'afareaheight' => { 167 => 0x1a },
	'afareaillumination' => { 159 => 0x4b, 242 => '15.3' },
	'afareamode' => { 155 => 0x33, 159 => 0xe, 166 => 0x0, 167 => 0x5, 267 => 0xf, 322 => 0x1205, 332 => [0xa,0x3a], 338 => 0x11, 339 => 0x10, 340 => 0x24, 350 => 0xb043, 369 => 0x17 },
	'afareamodesetting' => { 236 => '11.1', 237 => '0.1', 242 => '16.1', 245 => '2.1', 350 => 0x201c },
	'afareas' => { 247 => 0x304 },
	'afareaselectmethod' => { 72 => 0x51b },
	'afareawidth' => { 167 => 0x18 },
	'afareaxposition' => { 167 => 0x14, 322 => 0x1203 },
	'afareaxposition1' => { 322 => 0x1201 },
	'afareayposition' => { 167 => 0x16, 322 => 0x1204 },
	'afareayposition1' => { 322 => 0x1202 },
	'afassist' => { 70 => 0x5, 78 => 0x5, 159 => 0x48, 234 => '2.5', 236 => '0.2', 237 => '0.2', 238 => '1.1', 239 => '1.1', 240 => '2.4', 241 => '1.4', 242 => '0.2', 244 => '2.4', 245 => '2.3' },
	'afassistbeam' => { 72 => 0x50e, 73 => 0x4, 74 => 0x5, 75 => 0x4, 76 => 0x4, 77 => 0x5 },
	'afassistlamp' => { 267 => 0x31 },
	'afbuttonpressed' => { 340 => [0x83,0x283] },
	'afconfigtool' => { 2 => 0x1 },
	'afdefocus' => { 277 => 0x6 },
	'afduringliveview' => { 72 => 0x511 },
	'affinea' => { 386 => 'AffineA' },
	'affineb' => { 386 => 'AffineB' },
	'affinec' => { 386 => 'AffineC' },
	'affined' => { 386 => 'AffineD' },
	'affinetune' => { 168 => 0x0, 247 => 0x306 },
	'affinetuneadj' => { 168 => 0x2, 200 => 0x2d1, 201 => 0x2dc, 247 => 0x307 },
	'affinetuneindex' => { 168 => 0x1 },
	'affinex' => { 386 => 'AffineX' },
	'affiney' => { 386 => 'AffineY' },
	'afilluminator' => { 338 => 0x29, 350 => 0xb044 },
	'afimageheight' => { 167 => 0x12 },
	'afimagewidth' => { 167 => 0x10 },
	'afintegrationtime' => { 277 => 0x7 },
	'afmicroadj' => { 332 => [0x17d,0x50] },
	'afmicroadjmode' => { 3 => 0x1, 335 => 0x131 },
	'afmicroadjregisteredlenses' => { 335 => '305.1' },
	'afmicroadjustment' => { 72 => 0x507 },
	'afmicroadjvalue' => { 3 => 0x2, 335 => 0x130 },
	'afmode' => { 100 => 0x3009, 109 => 0x1022, 155 => 0x16, 331 => 0x5 },
	'afmoderestrictions' => { 235 => '50.3', 244 => '48.3' },
	'afonaelockbuttonswitch' => { 72 => 0x702 },
	'afonbutton' => { 234 => '3.1', 235 => '47.1' },
	'afpoint' => { 30 => 0x13, 99 => 0x18, 155 => 0x15, 166 => 0x1, 250 => 0x308, 331 => 0x1f, 332 => 0x7, 335 => 0x19, 336 => 0x18, 337 => [0x18,0x20] },
	'afpointactivationarea' => { 71 => 0x11, 77 => 0x11 },
	'afpointareaexpansion' => { 72 => 0x508 },
	'afpointatshutterrelease' => { 332 => 0x9 },
	'afpointautoselection' => { 72 => 0x50b },
	'afpointbrightness' => { 72 => 0x50d, 234 => '2.4', 235 => '46.5', 244 => '2.3' },
	'afpointdisplayduringfocus' => { 72 => 0x50c },
	'afpointillumination' => { 71 => 0xa, 234 => '2.3', 235 => '46.2', 240 => '2.3', 241 => '1.3', 244 => '47.2', 245 => '2.4' },
	'afpointinfocus' => { 332 => 0x8 },
	'afpointmode' => { 281 => 0x3 },
	'afpointposition' => { 100 => 0x2021, 267 => 0x4d },
	'afpointregistration' => { 70 => 0x7 },
	'afpoints' => { 158 => 0x10 },
	'afpointselected' => { 159 => 0xd, 247 => 0x305, 300 => 0xe, 335 => 0x15, 336 => 0x14, 337 => [0x14,0x1c], 350 => 0x201e },
	'afpointselected2' => { 281 => 0x4 },
	'afpointselection' => { 71 => 0xb, 234 => '1.3', 235 => '1.3', 240 => '1.3', 244 => '1.3' },
	'afpointselectionmethod' => { 72 => 0x50f, 73 => 0xc, 74 => 0xd, 77 => 0xd },
	'afpointsetting' => { 338 => 0x12, 339 => 0x11 },
	'afpointsinfocus' => { 66 => 0xe, 166 => 0x2, 277 => 0xb, 300 => [0xf,0x3c] },
	'afpointsinfocus5d' => { 18 => 0x38 },
	'afpointspotmetering' => { 71 => 0xd },
	'afpointsselected' => { 376 => 0x4 },
	'afpointsunknown1' => { 277 => 0x0 },
	'afpointsunknown2' => { 277 => 0x2 },
	'afpointsused' => { 167 => 0x8 },
	'afpointswitching' => { 2 => 0x4 },
	'afpredictor' => { 277 => 0x4 },
	'afresponse' => { 191 => 0xad },
	'afresult' => { 252 => 0x1038 },
	'afsearch' => { 247 => 0x303 },
	'afsensoractive' => { 155 => 0x1 },
	'afstatus' => { 322 => 0x1200 },
	'afstatusactivesensor' => { 155 => 0x2, 332 => 0x4, 335 => 0x1e, 336 => 0x1b, 337 => [0x1b,0x21] },
	'afstatusbottom' => { 155 => 0x8, 335 => 0x2a, 336 => 0x21, 337 => 0x21 },
	'afstatusbottom-left' => { 155 => 0x12, 336 => 0x2b, 337 => 0x2b },
	'afstatusbottom-right' => { 155 => 0x6, 336 => 0x1f, 337 => 0x1f },
	'afstatusbottomassist-left' => { 335 => 0x28 },
	'afstatusbottomassist-right' => { 335 => 0x2c },
	'afstatusbottomhorizontal' => { 333 => 0x10, 334 => 0x1c },
	'afstatusbottomvertical' => { 333 => 0x16, 334 => 0x26 },
	'afstatuscenter-10' => { 335 => 0x34 },
	'afstatuscenter-11' => { 335 => 0x36 },
	'afstatuscenter-12' => { 335 => 0x38 },
	'afstatuscenter-14' => { 335 => 0x3c },
	'afstatuscenter-7' => { 335 => 0x2e },
	'afstatuscenter-9' => { 335 => 0x32 },
	'afstatuscenter-horizontal' => { 335 => 0x30 },
	'afstatuscenter-vertical' => { 335 => 0x3a },
	'afstatuscenterf2-8' => { 335 => 0x4c },
	'afstatuscenterhorizontal' => { 155 => 0x2f, 333 => 0xc, 334 => 0x18, 336 => 0x2f, 337 => 0x2f },
	'afstatuscentervertical' => { 155 => 0xc, 333 => 0x14, 334 => 0x22, 336 => 0x25, 337 => 0x25 },
	'afstatusfarleft' => { 333 => 0x6, 335 => 0x26 },
	'afstatusfarlefthorizontal' => { 334 => 0x4 },
	'afstatusfarleftvertical' => { 334 => 0x12 },
	'afstatusfarright' => { 333 => 0x18, 335 => 0x44 },
	'afstatusfarrighthorizontal' => { 334 => 0x2c },
	'afstatusfarrightvertical' => { 334 => 0x34 },
	'afstatusleft' => { 155 => 0x2d, 333 => 0x2, 335 => 0x22, 336 => 0x2d, 337 => 0x2d },
	'afstatuslefthorizontal' => { 334 => 0x6 },
	'afstatusleftvertical' => { 334 => 0xe },
	'afstatuslower-left' => { 333 => 0x4, 335 => 0x24 },
	'afstatuslower-lefthorizontal' => { 334 => 0xa },
	'afstatuslower-leftvertical' => { 334 => 0x10 },
	'afstatuslower-middle' => { 333 => 0x22, 334 => 0x24 },
	'afstatuslower-right' => { 333 => 0x1e, 335 => 0x4a },
	'afstatuslower-righthorizontal' => { 334 => 0x32 },
	'afstatuslower-rightvertical' => { 334 => 0x3a },
	'afstatuslowerfarleft' => { 334 => 0x8 },
	'afstatuslowerfarright' => { 334 => 0x30 },
	'afstatusmiddlehorizontal' => { 155 => 0xa, 336 => 0x23, 337 => 0x23 },
	'afstatusnearleft' => { 333 => 0xe, 334 => 0x1a },
	'afstatusnearright' => { 333 => 0xa, 334 => 0x16 },
	'afstatusright' => { 155 => 0x31, 333 => 0x1c, 335 => 0x48, 336 => 0x31, 337 => 0x31 },
	'afstatusrighthorizontal' => { 334 => 0x2e },
	'afstatusrightvertical' => { 334 => 0x38 },
	'afstatustop' => { 155 => 0xe, 335 => 0x40, 336 => 0x27, 337 => 0x27 },
	'afstatustop-left' => { 155 => 0x10, 336 => 0x29, 337 => 0x29 },
	'afstatustop-right' => { 155 => 0x4, 336 => 0x1d, 337 => 0x1d },
	'afstatustopassist-left' => { 335 => 0x3e },
	'afstatustopassist-right' => { 335 => 0x42 },
	'afstatustophorizontal' => { 333 => 0x8, 334 => 0x14 },
	'afstatustopvertical' => { 333 => 0x12, 334 => 0x1e },
	'afstatusupper-left' => { 333 => 0x0, 335 => 0x20 },
	'afstatusupper-lefthorizontal' => { 334 => 0x2 },
	'afstatusupper-leftvertical' => { 334 => 0xc },
	'afstatusupper-middle' => { 333 => 0x20, 334 => 0x20 },
	'afstatusupper-right' => { 333 => 0x1a, 335 => 0x46 },
	'afstatusupper-righthorizontal' => { 334 => 0x2a },
	'afstatusupper-rightvertical' => { 334 => 0x36 },
	'afstatusupperfarleft' => { 334 => 0x0 },
	'afstatusupperfarright' => { 334 => 0x28 },
	'aftrackingsensitivity' => { 2 => 0x2 },
	'aftype' => { 332 => 0x2 },
	'afwithshutter' => { 338 => 0x2a },
	'afzoneselected' => { 350 => 0x201e },
	'aggregateissuenumber' => { 408 => 'aggregateIssueNumber' },
	'aggregationtype' => { 408 => 'aggregationType' },
	'agreement' => { 411 => 'agreement' },
	'aiservocontinuousshooting' => { 71 => 0x15 },
	'aiservofirstimagepriority' => { 72 => 0x519 },
	'aiservoimagepriority' => { 72 => 0x503 },
	'aiservosecondimagepriority' => { 72 => 0x51a },
	'aiservotrackingmethod' => { 72 => 0x504 },
	'aiservotrackingsensitivity' => { 71 => 0x14, 72 => 0x502 },
	'album' => { 418 => 'album' },
	'alreadyapplied' => { 393 => 'AlreadyApplied' },
	'alternatetitle' => { 408 => 'alternateTitle' },
	'alternatetitlea-lang' => { 408 => [\'alternateTitle','alternateTitleA-lang'] },
	'alternatetitlea-platform' => { 408 => [\'alternateTitle','alternateTitleA-platform'] },
	'alternatetitletext' => { 408 => [\'alternateTitle','alternateTitleText'] },
	'altitude' => { 169 => 0x6 },
	'alttapename' => { 418 => 'altTapeName' },
	'alttimecode' => { 418 => 'altTimecode' },
	'alttimecodetimeformat' => { 418 => [\'altTimecode','altTimecodeTimeFormat'] },
	'alttimecodetimevalue' => { 418 => [\'altTimecode','altTimecodeTimeValue'] },
	'alttimecodevalue' => { 418 => [\'altTimecode','altTimecodeValue'] },
	'ambienceselection' => { 4 => 0x1 },
	'ambienttemperature' => { 318 => 0x14, 369 => 0x4 },
	'ambienttemperaturefahrenheit' => { 318 => 0x13 },
	'analogbalance' => { 104 => 0xc627 },
	'angleadj' => { 90 => 0x10003, 96 => 0x8b },
	'angleinforoll' => { 388 => 'AngleInfoRoll' },
	'angleinfoyaw' => { 388 => 'AngleInfoYaw' },
	'anti-blur' => { 350 => 0xb04b },
	'antialiasstrength' => { 104 => 0xc632 },
	'aperturelock' => { 235 => '38.2', 244 => '38.2' },
	'aperturerange' => { 72 => 0x10d },
	'apertureringuse' => { 281 => '1.4' },
	'aperturesetting' => { 159 => 0x7, 338 => 0x30, 339 => 0x29, 340 => 0x1 },
	'aperturevalue' => { 81 => 0x2, 104 => 0x9202, 252 => 0x1002, 397 => 'ApertureValue' },
	'applekeywords' => { 256 => 'AAPL:Keywords' },
	'applicationnotes' => { 104 => 0x2bc, 271 => 0x2bc },
	'applicationrecordversion' => { 112 => 0x0 },
	'applyshootingmeteringmode' => { 72 => 0x10e },
	'approved' => { 399 => 'Approved' },
	'approvedby' => { 399 => 'ApprovedBy' },
	'approximatefnumber' => { 263 => 0x313, 269 => 0x3406 },
	'approximatefocusdistance' => { 389 => 'ApproximateFocusDistance' },
	'aquahsl' => { 90 => 0x20913 },
	'armidentifier' => { 113 => 0x78 },
	'armversion' => { 113 => 0x7a },
	'artfilter' => { 247 => 0x529 },
	'artfiltereffect' => { 247 => 0x52f },
	'artist' => { 104 => 0x13b, 259 => 'Artist', 300 => 0x22e, 414 => 'Artist', 418 => 'artist' },
	'artmode' => { 100 => 0x301b },
	'artmodeparameters' => { 100 => 0x310b },
	'artworkcircadatecreated' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCircaDateCreated'] },
	'artworkcontributiondescription' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOContributionDescription'] },
	'artworkcopyrightnotice' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCopyrightNotice'] },
	'artworkcopyrightownerid' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerId'] },
	'artworkcopyrightownername' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentCopyrightOwnerName'] },
	'artworkcreator' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCreator'] },
	'artworkcreatorid' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCreatorId'] },
	'artworkdatecreated' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAODateCreated'] },
	'artworklicensorid' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorId'] },
	'artworklicensorname' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOCurrentLicensorName'] },
	'artworkorobject' => { 403 => 'ArtworkOrObject' },
	'artworkphysicaldescription' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOPhysicalDescription'] },
	'artworkscontentdescription' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOContentDescription'] },
	'artworksource' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOSource'] },
	'artworksourceinventoryno' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvNo'] },
	'artworksourceinvurl' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOSourceInvURL'] },
	'artworkstyleperiod' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOStylePeriod'] },
	'artworktitle' => { 403 => [\'ArtworkOrObject','ArtworkOrObjectAOTitle'] },
	'aspectframe' => { 251 => 0x1113 },
	'aspectratio' => { 5 => 0x0, 251 => 0x1112, 300 => 0x80, 338 => 0x55, 339 => 0x55, 340 => 0xa },
	'asshoticcprofile' => { 104 => 0xc68f },
	'asshotneutral' => { 104 => 0xc628 },
	'asshotpreprofilematrix' => { 104 => 0xc690 },
	'asshotprofilename' => { 104 => 0xc6f6 },
	'asshotwhitexy' => { 104 => 0xc629 },
	'assignbktbutton' => { 234 => '4.2', 235 => '16.1', 244 => '16.1' },
	'assignfuncbutton' => { 72 => 0x70b },
	'assignmovierecordbutton' => { 235 => '43.2', 244 => '45.1' },
	'assignremotefnbutton' => { 235 => '54.1', 244 => '51.1' },
	'assistbuttonfunction' => { 70 => 0xd },
	'attributionname' => { 390 => 'attributionName' },
	'attributionurl' => { 390 => 'attributionURL' },
	'audio' => { 267 => 0x20 },
	'audiobitrate' => { 57 => 0x6c },
	'audiochannels' => { 57 => 0x70 },
	'audiochanneltype' => { 418 => 'audioChannelType' },
	'audiocompression' => { 133 => 'Compression' },
	'audiocompressor' => { 418 => 'audioCompressor' },
	'audioduration' => { 112 => 0x99 },
	'audiomoddate' => { 418 => 'audioModDate' },
	'audiooutcue' => { 112 => 0x9a },
	'audiosamplerate' => { 57 => 0x6e, 418 => 'audioSampleRate' },
	'audiosampletype' => { 418 => 'audioSampleType' },
	'audiosamplingrate' => { 112 => 0x97 },
	'audiosamplingresolution' => { 112 => 0x98 },
	'audiotype' => { 112 => 0x96 },
	'author' => { 135 => 'Author', 256 => 'Author', 259 => 'Author', 313 => 'Author', 387 => 'author', 404 => 'Author', 416 => 'Author' },
	'authorsposition' => { 405 => 'AuthorsPosition' },
	'autoaperture' => { 291 => '0.1' },
	'autobracket' => { 331 => 0x19 },
	'autobracketing' => { 109 => 0x1100, 300 => 0x18, 322 => 0x1007 },
	'autobracketingmode' => { 243 => '12.3' },
	'autobracketingset' => { 243 => '12.1' },
	'autobracketmodem' => { 234 => '21.2', 235 => '13.3', 240 => '26.2', 244 => '13.3' },
	'autobracketorder' => { 159 => 0x43, 234 => '21.3', 235 => '13.2', 240 => '26.3', 241 => '12.2', 242 => '2.2', 243 => '12.2', 244 => '13.2', 245 => '13.2' },
	'autobracketset' => { 234 => '21.1', 235 => '13.1', 237 => '11.1', 238 => '12.1', 239 => '12.1', 240 => '26.1', 241 => '12.1', 242 => '2.1', 244 => '13.1', 245 => '13.1' },
	'autobrightness' => { 393 => 'AutoBrightness' },
	'autocontrast' => { 393 => 'AutoContrast' },
	'autodistortioncontrol' => { 177 => 0x4 },
	'autodynamicrange' => { 109 => 0x140b },
	'autoexposure' => { 393 => 'AutoExposure' },
	'autoexposurebracketing' => { 66 => 0x10 },
	'autofocus' => { 250 => 0x209 },
	'autofp' => { 242 => '7.3', 245 => '31.4' },
	'autoiso' => { 66 => 0x1, 100 => 0x3008, 236 => '1.1', 242 => '1.1' },
	'autoisomax' => { 236 => '1.2', 242 => '1.2' },
	'autoisominshutterspeed' => { 236 => '1.3', 242 => '1.3' },
	'autolateralca' => { 393 => 'AutoLateralCA' },
	'autolightingoptimizer' => { 15 => 0xbe, 16 => 0xbf, 19 => 0xbf, 53 => 0x2, 72 => 0x204, 90 => 0x20500, 96 => 0x6f },
	'autolightingoptimizeron' => { 90 => '0x20500.0', 96 => 0x6e },
	'autoportraitframed' => { 350 => 0x2016 },
	'autoredeye' => { 227 => 0xfe28a44f },
	'autorotate' => { 66 => 0x1b },
	'autoshadows' => { 393 => 'AutoShadows' },
	'autowhiteversion' => { 393 => 'AutoWhiteVersion' },
	'auxiliarylens' => { 191 => 0x82 },
	'avaperturesetting' => { 281 => 0x13 },
	'averageblacklevel' => { 37 => 0xe7, 39 => 0xfb, 40 => 0x114, 41 => 0x146 },
	'averagelv' => { 162 => 0x38 },
	'avsettingwithoutlens' => { 72 => 0x707 },
	'azimuth' => { 143 => 'Azimuth' },
	'babyage' => { 267 => [0x8010,0x33] },
	'babyname' => { 267 => 0x66 },
	'backgroundalpha' => { 413 => 'bgalpha' },
	'baseexposurecompensation' => { 281 => 0x15 },
	'baseiso' => { 66 => 0x2, 85 => 0x101c, 118 => 0x903, 269 => 0x312a, 374 => 0x6 },
	'baselineexposure' => { 104 => 0xc62a },
	'baselineexposureoffset' => { 104 => 0xc7a5 },
	'baselinenoise' => { 104 => 0xc62b },
	'baselinesharpness' => { 104 => 0xc62c },
	'baseurl' => { 416 => 'BaseURL' },
	'batterylevel' => { 338 => 0x51, 342 => 0xc, 343 => 0x4, 344 => 0x4, 375 => 0x7 },
	'batterylevelgrip1' => { 375 => 0x6 },
	'batterylevelgrip2' => { 375 => 0x8 },
	'batteryorder' => { 234 => '12.5', 240 => '13.2', 241 => '2.1', 244 => '3.1' },
	'batterystate' => { 159 => 0x60, 338 => 0x50, 344 => 0x14 },
	'batterytemperature' => { 342 => 0x1, 344 => 0x2, 375 => 0x5 },
	'batteryunknown' => { 342 => 0x2, 344 => 0x0 },
	'batteryvoltage' => { 118 => 0x408, 318 => 0x2a, 342 => 0x8 },
	'batteryvoltage1' => { 344 => 0x6 },
	'batteryvoltage2' => { 344 => 0x8 },
	'bayergreensplit' => { 104 => 0xc62d },
	'bayerpattern' => { 117 => 0xf902, 163 => 0x17 },
	'beatspliceparams' => { 418 => 'beatSpliceParams' },
	'beatspliceparamsriseindecibel' => { 418 => [\'beatSpliceParams','beatSpliceParamsRiseInDecibel'] },
	'beatspliceparamsriseintimeduration' => { 418 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDuration'] },
	'beatspliceparamsriseintimedurationscale' => { 418 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationScale'] },
	'beatspliceparamsriseintimedurationvalue' => { 418 => [\'beatSpliceParams','beatSpliceParamsRiseInTimeDurationValue'] },
	'beatspliceparamsusefilebeatsmarker' => { 418 => [\'beatSpliceParams','beatSpliceParamsUseFileBeatsMarker'] },
	'beep' => { 234 => '13.1', 235 => '5.4', 236 => '0.1', 237 => '2.1', 238 => '3.1', 239 => '3.1', 240 => '10.1', 242 => '0.1', 244 => '5.5', 245 => '4.1' },
	'beeppitch' => { 241 => '3.1' },
	'beepvolume' => { 241 => '4.5' },
	'bestqualityscale' => { 104 => 0xc65c },
	'bestshotmode' => { 100 => 0x3007 },
	'bitdepth' => { 140 => 'BitDepth', 163 => 0x11, 197 => 0x41 },
	'bitspercomponent' => { 114 => 0x87 },
	'bitspersample' => { 104 => 0x102, 414 => 'BitsPerSample' },
	'blacklevel' => { 104 => 0xc61a, 191 => 0x3d, 252 => [0x401,0x1012] },
	'blacklevel1' => { 271 => 0x8 },
	'blacklevel2' => { 251 => 0x600, 255 => 0x600, 271 => 0x9 },
	'blacklevel3' => { 271 => 0xa },
	'blacklevelblue' => { 271 => 0x1e },
	'blackleveldeltah' => { 104 => 0xc61b },
	'blackleveldeltav' => { 104 => 0xc61c },
	'blacklevelgreen' => { 271 => 0x1d },
	'blacklevelred' => { 271 => 0x1c },
	'blacklevelrepeatdim' => { 104 => 0xc619 },
	'blackpoint' => { 300 => 0x200 },
	'blacks2012' => { 393 => 'Blacks2012' },
	'bleachbypasstoning' => { 300 => 0x7f },
	'blogtitle' => { 408 => 'blogTitle' },
	'blogurl' => { 408 => 'blogURL' },
	'bluebalance' => { 175 => 0x271, 252 => 0x1018, 271 => 0x12, 300 => 0x1b },
	'bluecurvelimits' => { 95 => 0x1fe },
	'bluecurvepoints' => { 94 => 0x79, 95 => 0x1d4 },
	'bluehsl' => { 90 => [0x20914,0x20915] },
	'bluehue' => { 393 => 'BlueHue' },
	'bluesaturation' => { 393 => 'BlueSaturation' },
	'blurcontrol' => { 300 => 0x82 },
	'blurwarning' => { 109 => 0x1300 },
	'bodybatteryadload' => { 279 => 0x3 },
	'bodybatteryadnoload' => { 279 => 0x2 },
	'bodybatterystate' => { 279 => '1.1' },
	'bodybatteryvoltage1' => { 279 => 0x2 },
	'bodybatteryvoltage2' => { 279 => 0x4 },
	'bodybatteryvoltage3' => { 279 => 0x6 },
	'bodybatteryvoltage4' => { 279 => 0x8 },
	'bodyfirmware' => { 323 => 0x0 },
	'bodyfirmwareversion' => { 248 => 0x104, 249 => 0x100, 252 => 0x104 },
	'bodyserialnumber' => { 323 => 0x10 },
	'bookedition' => { 408 => 'bookEdition' },
	'bracketmode' => { 48 => 0x3 },
	'bracketsequence' => { 100 => 0x301d },
	'bracketsettings' => { 267 => 0x45 },
	'bracketshotnumber' => { 48 => 0x5, 281 => 0x9, 349 => 0x2b },
	'bracketshotnumber2' => { 349 => 0x2d },
	'bracketstep' => { 156 => 0xe },
	'bracketvalue' => { 48 => 0x4 },
	'brightness' => { 104 => 0xfe53, 134 => 'Brightness', 156 => 0x2c, 193 => 0x34, 318 => 0x25, 338 => 0x22, 350 => 0x2007, 393 => 'Brightness' },
	'brightnessadj' => { 95 => 0x114, 220 => 0x0, 230 => 0x2d, 378 => 0x8018 },
	'brightnessvalue' => { 104 => 0x9203, 162 => [0x691,0x49c3], 252 => 0x1003, 354 => 0x1e, 357 => 0x1140, 358 => 0x1140, 359 => 0x111c, 360 => 0x1198, 361 => 0x1174, 362 => 0x102c, 363 => 0x224, 364 => 0x224, 397 => 'BrightnessValue' },
	'bulbduration' => { 66 => 0x18 },
	'burstmode' => { 120 => 0xa, 267 => 0x2a },
	'burstmode2' => { 120 => 0x18 },
	'burstshot' => { 331 => 0x34 },
	'burstspeed' => { 267 => 0x77 },
	'burstuuid' => { 1 => 0xb },
	'buttonfunctioncontroloff' => { 72 => 0x70a },
	'bwfilter' => { 156 => 0x2a, 164 => 0x39 },
	'bwmode' => { 252 => 0x203 },
	'by-line' => { 112 => 0x50 },
	'by-linetitle' => { 112 => 0x55 },
	'bytecount' => { 408 => 'byteCount' },
	'calibration' => { 331 => [0x24,0x30] },
	'calibrationilluminant1' => { 104 => 0xc65a },
	'calibrationilluminant2' => { 104 => 0xc65b },
	'cameraangle' => { 418 => 'cameraAngle' },
	'cameracalibration1' => { 104 => 0xc623 },
	'cameracalibration2' => { 104 => 0xc624 },
	'cameracalibrationsig' => { 104 => 0xc6f3 },
	'cameracolorcalibration01' => { 32 => 0x0, 38 => 0xba },
	'cameracolorcalibration02' => { 32 => 0x4, 38 => 0xbf },
	'cameracolorcalibration03' => { 32 => 0x8, 38 => 0xc4 },
	'cameracolorcalibration04' => { 32 => 0xc, 38 => 0xc9 },
	'cameracolorcalibration05' => { 32 => 0x10, 38 => 0xce },
	'cameracolorcalibration06' => { 32 => 0x14, 38 => 0xd3 },
	'cameracolorcalibration07' => { 32 => 0x18, 38 => 0xd8 },
	'cameracolorcalibration08' => { 32 => 0x1c, 38 => 0xdd },
	'cameracolorcalibration09' => { 32 => 0x20, 38 => 0xe2 },
	'cameracolorcalibration10' => { 32 => 0x24, 38 => 0xe7 },
	'cameracolorcalibration11' => { 32 => 0x28, 38 => 0xec },
	'cameracolorcalibration12' => { 32 => 0x2c, 38 => 0xf1 },
	'cameracolorcalibration13' => { 32 => 0x30, 38 => 0xf6 },
	'cameracolorcalibration14' => { 32 => 0x34, 38 => 0xfb },
	'cameracolorcalibration15' => { 32 => 0x38, 38 => 0x100 },
	'cameraid' => { 252 => 0x209, 330 => 0x209 },
	'cameraiso' => { 30 => 0x10 },
	'cameralabel' => { 104 => 0xc7a1, 418 => 'cameraLabel' },
	'cameramodel' => { 418 => 'cameraModel' },
	'cameramove' => { 418 => 'cameraMove' },
	'cameraorientation' => { 6 => 0x30, 8 => 0x7d, 10 => 0x30, 12 => 0x35, 13 => 0x30, 14 => 0x30, 15 => 0x31, 16 => 0x31, 17 => 0x35, 18 => 0x27, 19 => 0x31, 20 => 0x7d, 21 => 0x38, 22 => 0x36, 23 => 0x7d, 24 => 0x83, 25 => 0x84, 26 => 0x35, 267 => 0x8f, 303 => 0x1, 344 => [0x16,0x18], 366 => 0x28, 367 => 0x24, 368 => 0x29 },
	'cameraowner' => { 121 => 0xc353 },
	'cameraparameters' => { 252 => 0x2050 },
	'cameraprofile' => { 393 => 'CameraProfile' },
	'cameraprofiledigest' => { 393 => 'CameraProfileDigest' },
	'cameraserialnumber' => { 104 => 0xc62f, 154 => 'CameraSerialNumber' },
	'camerasettingsversion' => { 247 => 0x0 },
	'cameratemperature' => { 6 => 0x18, 8 => 0x1b, 10 => 0x18, 12 => 0x19, 13 => 0x18, 14 => 0x18, 15 => 0x19, 16 => 0x19, 17 => 0x19, 18 => 0x17, 19 => 0x19, 20 => 0x1b, 21 => 0x19, 22 => 0x19, 23 => 0x1b, 24 => 0x1b, 25 => 0x1b, 26 => 0x19, 27 => [0x87,0x91], 28 => [0x99,0x9f,0xa4,0xa8,0x105], 29 => ['-3',0x64,0x47,0x53,0x5b,0x5c], 66 => 0xc, 118 => 0x406, 251 => 0x1306, 263 => 0x320, 269 => 0x3402, 300 => 0x47, 328 => 0x43, 370 => 0x5 },
	'cameratemperature2' => { 304 => 0xc },
	'cameratemperature3' => { 304 => 0xe },
	'cameratemperature4' => { 304 => 0x14 },
	'cameratemperature5' => { 304 => 0x16 },
	'cameratemperaturerangemax' => { 106 => 0x5 },
	'cameratemperaturerangemin' => { 106 => 0x6 },
	'cameratype' => { 66 => 0x1a, 252 => 0x207 },
	'cameratype2' => { 248 => 0x100 },
	'canondr4' => { 105 => 'CanonDR4' },
	'canonexposuremode' => { 30 => 0x14 },
	'canonfiledescription' => { 85 => 0x805 },
	'canonfilelength' => { 54 => 0xe },
	'canonfirmwareversion' => { 54 => 0x7, 85 => 0x80b },
	'canonflashinfo' => { 85 => 0x1028 },
	'canonflashmode' => { 30 => 0x4 },
	'canonimagesize' => { 9 => 0x39, 30 => 0xa },
	'canonimagetype' => { 54 => 0x6, 85 => 0x815 },
	'canonmodelid' => { 54 => 0x10, 85 => 0x1834 },
	'canonvrd' => { 105 => 'CanonVRD' },
	'caption' => { 387 => 'caption' },
	'caption-abstract' => { 112 => 0x78 },
	'captionsauthornames' => { 396 => 'CaptionsAuthorNames' },
	'captionsdatetimestamps' => { 396 => 'CaptionsDateTimeStamps' },
	'captionwriter' => { 405 => 'CaptionWriter' },
	'captureframerate' => { 100 => 0x4001 },
	'capturesoftware' => { 382 => 'CaptureSoftware' },
	'cardshutterlock' => { 159 => 0x49 },
	'casioimagesize' => { 100 => 0x9 },
	'catalogsets' => { 112 => 0xff, 381 => 'CatalogSets', 385 => 'CatalogSets' },
	'categories' => { 54 => 0x23, 387 => 'categories' },
	'category' => { 112 => 0xf, 246 => 0x30, 405 => 'Category' },
	'cbcrgain' => { 328 => 0xa036 },
	'cbcrgaindefault' => { 328 => 0xa035 },
	'cbcrmatrix' => { 328 => 0xa034 },
	'cbcrmatrixdefault' => { 328 => 0xa033 },
	'ccdboardversion' => { 263 => 0x331 },
	'ccdscanmode' => { 252 => 0x1039 },
	'ccdsensitivity' => { 217 => 0x6 },
	'ccdversion' => { 263 => 0x330 },
	'cellglobalid' => { 391 => 'cgi' },
	'celllength' => { 104 => 0x109 },
	'cellr' => { 391 => 'r' },
	'celltowerid' => { 391 => 'cellid' },
	'cellwidth' => { 104 => 0x108 },
	'centerafarea' => { 242 => '15.1' },
	'centerfocuspoint' => { 245 => '2.2' },
	'centerweightedareasize' => { 234 => '7.1', 235 => '8.1', 240 => '5.1', 241 => '7.1', 242 => '6.3', 244 => '8.1', 245 => '8.1' },
	'certificate' => { 422 => 'Certificate' },
	'cfapattern' => { 104 => 0xa302, 397 => 'CFAPattern' },
	'cfapattern2' => { 104 => 0x828e },
	'cfapatterncolumns' => { 397 => [\'CFAPattern','CFAPatternColumns'] },
	'cfapatternrows' => { 397 => [\'CFAPattern','CFAPatternRows'] },
	'cfapatternvalues' => { 397 => [\'CFAPattern','CFAPatternValues'] },
	'cfarepeatpatterndim' => { 104 => 0x828d },
	'channel' => { 408 => 'channel' },
	'channela-lang' => { 408 => [\'channel','channelA-lang'] },
	'channelchannel' => { 408 => [\'channel','channelChannel'] },
	'channels' => { 133 => 'Channels' },
	'channelsubchannel1' => { 408 => [\'channel','channelSubchannel1'] },
	'channelsubchannel2' => { 408 => [\'channel','channelSubchannel2'] },
	'channelsubchannel3' => { 408 => [\'channel','channelSubchannel3'] },
	'channelsubchannel4' => { 408 => [\'channel','channelSubchannel4'] },
	'checkmark' => { 90 => 0x10101, 95 => 0x26a },
	'checkmark2' => { 96 => 0x8e },
	'childfontfiles' => { 423 => [\'Fonts','FontsChildFontFiles'] },
	'chmodeshootingspeed' => { 234 => '10.3', 235 => '11.2' },
	'chromablurradius' => { 104 => 0xc631 },
	'chromaticaberration' => { 90 => 0x20703, 96 => 0x66, 328 => 0xa051 },
	'chromaticaberrationb' => { 393 => 'ChromaticAberrationB' },
	'chromaticaberrationblue' => { 90 => 0x20708, 96 => 0x6b },
	'chromaticaberrationcorr' => { 68 => [0x4,0x5] },
	'chromaticaberrationcorrection' => { 290 => 0x1 },
	'chromaticaberrationon' => { 90 => '0x20703.0', 96 => 0x62 },
	'chromaticaberrationr' => { 393 => 'ChromaticAberrationR' },
	'chromaticaberrationred' => { 90 => 0x20707, 96 => 0x6a },
	'chromaticaberrationsetting' => { 69 => 0x6 },
	'chrominancenoisereduction' => { 90 => 0x20601, 96 => 0x5e, 331 => 0x1a },
	'chrominancenr_tiff_jpeg' => { 96 => 0x60 },
	'circgradbasedcorractive' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionActive'] },
	'circgradbasedcorramount' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionAmount'] },
	'circgradbasedcorrbrightness' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalBrightness'] },
	'circgradbasedcorrclarity' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity'] },
	'circgradbasedcorrclarity2012' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalClarity2012'] },
	'circgradbasedcorrcontrast' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast'] },
	'circgradbasedcorrcontrast2012' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalContrast2012'] },
	'circgradbasedcorrdefringe' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalDefringe'] },
	'circgradbasedcorrexposure' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure'] },
	'circgradbasedcorrexposure2012' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalExposure2012'] },
	'circgradbasedcorrhighlights2012' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalHighlights2012'] },
	'circgradbasedcorrhue' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalToningHue'] },
	'circgradbasedcorrluminancenoise' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalLuminanceNoise'] },
	'circgradbasedcorrmaskalpha' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAlpha'] },
	'circgradbasedcorrmaskangle' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksAngle'] },
	'circgradbasedcorrmaskbottom' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksBottom'] },
	'circgradbasedcorrmaskcentervalue' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'circgradbasedcorrmaskcenterweight' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'circgradbasedcorrmaskdabs' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksDabs'] },
	'circgradbasedcorrmaskfeather' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFeather'] },
	'circgradbasedcorrmaskflipped' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlipped'] },
	'circgradbasedcorrmaskflow' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFlow'] },
	'circgradbasedcorrmaskfullx' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullX'] },
	'circgradbasedcorrmaskfully' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksFullY'] },
	'circgradbasedcorrmaskleft' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksLeft'] },
	'circgradbasedcorrmaskmidpoint' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'circgradbasedcorrmaskperimetervalue' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'circgradbasedcorrmaskradius' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRadius'] },
	'circgradbasedcorrmaskright' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRight'] },
	'circgradbasedcorrmaskroundness' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksRoundness'] },
	'circgradbasedcorrmasks' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasks'] },
	'circgradbasedcorrmasksizex' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeX'] },
	'circgradbasedcorrmasksizey' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksSizeY'] },
	'circgradbasedcorrmasktop' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksTop'] },
	'circgradbasedcorrmaskvalue' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'circgradbasedcorrmaskversion' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksVersion'] },
	'circgradbasedcorrmaskwhat' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksWhat'] },
	'circgradbasedcorrmaskx' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksX'] },
	'circgradbasedcorrmasky' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksY'] },
	'circgradbasedcorrmaskzerox' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroX'] },
	'circgradbasedcorrmaskzeroy' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsCorrectionMasksZeroY'] },
	'circgradbasedcorrmoire' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalMoire'] },
	'circgradbasedcorrsaturation' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSaturation','CircularGradientBasedCorrectionsLocalToningSaturation'] },
	'circgradbasedcorrshadows2012' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalShadows2012'] },
	'circgradbasedcorrsharpness' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalSharpness'] },
	'circgradbasedcorrtemperature' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTemperature'] },
	'circgradbasedcorrtint' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsLocalTint'] },
	'circgradbasedcorrwhat' => { 393 => [\'CircularGradientBasedCorrections','CircularGradientBasedCorrectionsWhat'] },
	'circulargradientbasedcorrections' => { 393 => 'CircularGradientBasedCorrections' },
	'city' => { 112 => 0x5a, 139 => 'City', 267 => 0x6d, 405 => 'City' },
	'city2' => { 267 => 0x80 },
	'clarity' => { 393 => 'Clarity' },
	'clarity2012' => { 393 => 'Clarity2012' },
	'classifystate' => { 112 => 0xe1 },
	'clearretouch' => { 267 => 0x7c },
	'clearretouchvalue' => { 267 => 0xa3 },
	'client' => { 418 => 'client' },
	'clientname' => { 399 => 'ClientName' },
	'clmodeshootingspeed' => { 234 => '10.2', 235 => '11.3', 240 => '11.2', 241 => '10.2', 244 => '11.2', 245 => '11.1' },
	'cmcontrast' => { 255 => 0x2022 },
	'cmexposurecompensation' => { 255 => 0x2000 },
	'cmhue' => { 255 => 0x2021 },
	'cmsaturation' => { 255 => 0x2020 },
	'cmsharpness' => { 255 => 0x2023 },
	'cmwhitebalance' => { 255 => 0x2001 },
	'cmwhitebalancecomp' => { 255 => 0x2002 },
	'cmwhitebalancegraypoint' => { 255 => 0x2010 },
	'codec' => { 147 => 'Codec' },
	'codedcharacterset' => { 113 => 0x5a },
	'collectionname' => { 148 => [\'Collections','CollectionsCollectionName'] },
	'collections' => { 148 => 'Collections' },
	'collectionuri' => { 148 => [\'Collections','CollectionsCollectionURI'] },
	'color' => { 407 => 'color' },
	'coloraberrationcontrol' => { 227 => 0xc89224b },
	'coloradjustment' => { 331 => 0x14 },
	'coloradjustmentmode' => { 330 => 0x210 },
	'coloranta' => { 423 => [\'Colorants','ColorantsA'] },
	'colorantb' => { 423 => [\'Colorants','ColorantsB'] },
	'colorantblack' => { 423 => [\'Colorants','ColorantsBlack'] },
	'colorantblue' => { 423 => [\'Colorants','ColorantsBlue'] },
	'colorantcyan' => { 423 => [\'Colorants','ColorantsCyan'] },
	'colorantgreen' => { 423 => [\'Colorants','ColorantsGreen'] },
	'colorantl' => { 423 => [\'Colorants','ColorantsL'] },
	'colorantmagenta' => { 423 => [\'Colorants','ColorantsMagenta'] },
	'colorantmode' => { 423 => [\'Colorants','ColorantsMode'] },
	'colorantred' => { 423 => [\'Colorants','ColorantsRed'] },
	'colorants' => { 423 => 'Colorants' },
	'colorantswatchname' => { 423 => [\'Colorants','ColorantsSwatchName'] },
	'coloranttint' => { 423 => [\'Colorants','ColorantsTint'] },
	'coloranttype' => { 423 => [\'Colorants','ColorantsType'] },
	'colorantyellow' => { 423 => [\'Colorants','ColorantsYellow'] },
	'colorbalance' => { 134 => 'ColorBalance' },
	'colorbalanceadj' => { 227 => 0x76a43202 },
	'colorbalanceblue' => { 156 => 0x1e },
	'colorbalancegreen' => { 156 => 0x1d },
	'colorbalancered' => { 156 => 0x1c },
	'colorbalanceversion' => { 176 => 0x0 },
	'colorblur' => { 96 => 0x65 },
	'colorbluron' => { 90 => 0x20704 },
	'colorbooster' => { 227 => 0x5f0e7d23 },
	'colorboostlevel' => { 221 => 0x1 },
	'colorboosttype' => { 221 => 0x0 },
	'colorclass' => { 308 => 0xde, 309 => 'ColorClass' },
	'colorcompensationfilter' => { 159 => [0x3a,0x5f], 161 => 0x111, 350 => 0xb022 },
	'colorcompensationfiltercustom' => { 338 => 0xd, 339 => 0xc },
	'colorcompensationfilterset' => { 338 => 0x8, 339 => 0x7, 340 => 0x18, 354 => 0xf },
	'colorcontrol' => { 252 => 0x102b },
	'colorcorrection' => { 378 => 0x8015 },
	'colordataversion' => { 36 => 0x0, 37 => 0x0, 39 => 0x0, 40 => 0x0, 41 => 0x0 },
	'coloreffect' => { 267 => 0x28 },
	'colorfilter' => { 99 => 0x17, 100 => 0x3017, 156 => 0x29, 164 => [0x38,0x4d,0x4f], 306 => 0x17 },
	'colorgain' => { 197 => 0x51 },
	'colorhue' => { 90 => 0x20900, 191 => 0x8d },
	'colorimetricreference' => { 104 => 0xc6bf },
	'colorlabel' => { 396 => 'ColorLabel' },
	'colormatrix' => { 251 => 0x200, 252 => 0x1011, 328 => 0xa030 },
	'colormatrix1' => { 104 => 0xc621 },
	'colormatrix2' => { 104 => 0xc622, 255 => 0x200 },
	'colormatrixa' => { 300 => 0x203 },
	'colormatrixadobergb' => { 328 => 0xa032 },
	'colormatrixb' => { 300 => 0x204 },
	'colormatrixnumber' => { 252 => 0x1019 },
	'colormatrixsrgb' => { 328 => 0xa031 },
	'colormode' => { 100 => 0x3015, 109 => 0x1210, 120 => 0x66, 156 => 0x28, 159 => 0x16, 161 => 0x101, 162 => 0x36, 164 => 0x7, 191 => 0x3, 217 => 0x4, 267 => 0x32, 331 => 0x2c, 350 => 0xb029, 405 => 'ColorMode' },
	'colormoirereduction' => { 228 => 0x15 },
	'colormoirereductionmode' => { 228 => 0x5 },
	'colornoisereduction' => { 378 => 0x8029, 393 => 'ColorNoiseReduction' },
	'colornoisereductiondetail' => { 393 => 'ColorNoiseReductionDetail' },
	'colornoisereductionintensity' => { 228 => 0x18 },
	'colornoisereductionsharpness' => { 228 => 0x1c },
	'colornoisereductionsmoothness' => { 393 => 'ColorNoiseReductionSmoothness' },
	'colorplanes' => { 108 => 0x2 },
	'colorprofile' => { 156 => 0x33 },
	'colorrepresentation' => { 114 => 0x3c },
	'colorsaturationadj' => { 90 => 0x20305 },
	'colorsequence' => { 114 => 0x41 },
	'colorspace' => { 42 => 0x3, 54 => 0xb4, 85 => 0x10b4, 104 => 0xa001, 140 => 'ColorSpace', 157 => 0x2f, 158 => 0x25, 159 => 0x17, 191 => 0x1e, 247 => 0x507, 300 => 0x37, 328 => 0xa011, 331 => 0xb, 338 => 0x1b, 339 => 0x83, 340 => 0xe, 354 => 0x6, 397 => 'ColorSpace' },
	'colortempasshot' => { 33 => 0x4, 34 => 0x1d, 35 => 0x26, 36 => 0x43, 39 => 0x43, 40 => 0x43, 41 => 0x43 },
	'colortempauto' => { 33 => 0x9, 34 => 0x22, 35 => 0x1c, 36 => 0x48, 39 => 0x48, 40 => 0x48, 41 => 0x48 },
	'colortempcloudy' => { 33 => 0x22, 34 => 0x31, 35 => 0x35, 36 => 0x5c, 39 => 0x75, 40 => 0x8e, 41 => 0x93, 300 => 0x55 },
	'colortempcustom' => { 36 => 0x84 },
	'colortempcustom1' => { 34 => 0x45 },
	'colortempcustom2' => { 34 => 0x4a },
	'colortempdaylight' => { 33 => 0x18, 34 => 0x27, 35 => 0x2b, 36 => 0x52, 39 => 0x6b, 40 => 0x84, 41 => 0x89, 300 => 0x53 },
	'colortemperature' => { 6 => 0x73, 7 => [0x48,0x4e], 8 => 0xc0, 9 => 0x37, 10 => 0x62, 11 => 0x37, 12 => 0x7c, 13 => 0x73, 14 => 0x73, 15 => 0x77, 16 => 0x73, 17 => 0x7c, 18 => 0x58, 19 => 0x73, 20 => 0xc0, 21 => 0x7f, 22 => 0x7d, 23 => 0xc0, 24 => 0xc6, 25 => 0xc7, 26 => 0x7b, 54 => 0xae, 64 => 0x9, 85 => 0x10ae, 109 => 0x1005, 118 => 0x846, 134 => 'ColorTemperature', 157 => [0x6e,0x49], 158 => 0x3f, 159 => [0x39,0x5e], 161 => 0x10b, 164 => [0x3c,0x4c,0x4e], 263 => 0x321, 300 => 0x50, 322 => 0x1308, 350 => 0xb021, 393 => 'Temperature' },
	'colortemperatureadj' => { 378 => 0x8013 },
	'colortemperaturebg' => { 252 => 0x1013 },
	'colortemperaturecustom' => { 338 => 0xc, 339 => 0xb },
	'colortemperaturerg' => { 252 => 0x1014 },
	'colortemperatureset' => { 338 => 0x7, 339 => 0x6 },
	'colortemperaturesetting' => { 159 => 0x25, 340 => 0x17, 354 => 0xe },
	'colortempflash' => { 33 => 0x36, 34 => 0x40, 35 => 0x49, 36 => 0x70, 39 => 0x89, 40 => 0xa2, 41 => 0xa7, 300 => 0x5a },
	'colortempflashdata' => { 36 => 0x24a },
	'colortempfluorescent' => { 33 => 0x2c, 34 => 0x3b, 35 => 0x3f, 36 => 0x66, 39 => 0x7f, 40 => 0x98, 41 => 0x9d },
	'colortempfluorescentd' => { 300 => 0x57 },
	'colortempfluorescentn' => { 300 => 0x58 },
	'colortempfluorescentw' => { 300 => 0x59 },
	'colortempkelvin' => { 33 => 0x31, 35 => 0x44, 36 => 0x6b, 39 => 0x84, 40 => 0x9d, 41 => 0xa2, 267 => 0x44, 322 => 0x1307 },
	'colortempmeasured' => { 33 => 0xe, 36 => 0x4d, 39 => 0x4d, 40 => 0x4d, 41 => 0x4d },
	'colortemppc1' => { 35 => 0x94, 36 => 0x75 },
	'colortemppc2' => { 35 => 0x99, 36 => 0x7a },
	'colortemppc3' => { 35 => 0x9e, 36 => 0x7f },
	'colortempshade' => { 33 => 0x1d, 34 => 0x2c, 35 => 0x30, 36 => 0x57, 39 => 0x70, 40 => 0x89, 41 => 0x8e, 300 => 0x54 },
	'colortemptungsten' => { 33 => 0x27, 34 => 0x36, 35 => 0x3a, 36 => 0x61, 39 => 0x7a, 40 => 0x93, 41 => 0x98, 300 => 0x56 },
	'colortempunknown' => { 33 => 0x13, 35 => 0x21, 39 => 0x52, 40 => 0x52, 41 => 0x52 },
	'colortempunknown10' => { 33 => 0x63, 35 => 0x76, 39 => 0xa2, 40 => 0x7f, 41 => 0x7f },
	'colortempunknown11' => { 33 => 0x68, 35 => 0x7b, 39 => 0xa7, 40 => 0xa7, 41 => 0x84 },
	'colortempunknown12' => { 33 => 0x6d, 35 => 0x80, 39 => 0xac, 40 => 0xac, 41 => 0xac },
	'colortempunknown13' => { 33 => 0x72, 35 => 0x85, 39 => 0xb1, 40 => 0xb1, 41 => 0xb1 },
	'colortempunknown14' => { 35 => 0x8a, 39 => 0xb6, 40 => 0xb6, 41 => 0xb6 },
	'colortempunknown15' => { 35 => 0x8f, 39 => 0xbb, 40 => 0xbb, 41 => 0xbb },
	'colortempunknown16' => { 35 => 0xa3, 40 => 0xc0, 41 => 0xc0 },
	'colortempunknown17' => { 40 => 0xc5, 41 => 0xc5 },
	'colortempunknown18' => { 40 => 0xca, 41 => 0xca },
	'colortempunknown19' => { 40 => 0xcf, 41 => 0xcf },
	'colortempunknown2' => { 33 => 0x3b, 35 => 0x4e, 39 => 0x57, 40 => 0x57, 41 => 0x57 },
	'colortempunknown20' => { 40 => 0xd4, 41 => 0xd4 },
	'colortempunknown21' => { 41 => 0xd9 },
	'colortempunknown22' => { 41 => 0xde },
	'colortempunknown23' => { 41 => 0xe3 },
	'colortempunknown24' => { 41 => 0xe8 },
	'colortempunknown25' => { 41 => 0xed },
	'colortempunknown26' => { 41 => 0xf2 },
	'colortempunknown27' => { 41 => 0xf7 },
	'colortempunknown28' => { 41 => 0xfc },
	'colortempunknown29' => { 41 => 0x101 },
	'colortempunknown3' => { 33 => 0x40, 35 => 0x53, 39 => 0x5c, 40 => 0x5c, 41 => 0x5c },
	'colortempunknown30' => { 41 => 0x106 },
	'colortempunknown4' => { 33 => 0x45, 35 => 0x58, 39 => 0x61, 40 => 0x61, 41 => 0x61 },
	'colortempunknown5' => { 33 => 0x4a, 35 => 0x5d, 39 => 0x66, 40 => 0x66, 41 => 0x66 },
	'colortempunknown6' => { 33 => 0x4f, 35 => 0x62, 39 => 0x8e, 40 => 0x6b, 41 => 0x6b },
	'colortempunknown7' => { 33 => 0x54, 35 => 0x67, 39 => 0x93, 40 => 0x70, 41 => 0x70 },
	'colortempunknown8' => { 33 => 0x59, 35 => 0x6c, 39 => 0x98, 40 => 0x75, 41 => 0x75 },
	'colortempunknown9' => { 33 => 0x5e, 35 => 0x71, 39 => 0x9d, 40 => 0x7a, 41 => 0x7a },
	'colortone' => { 9 => 0x6f, 11 => 0x77, 30 => 0x2a, 42 => 0x2 },
	'colortoneadj' => { 90 => 0x20304, 95 => 0x11e },
	'colortoneauto' => { 61 => 0x9c },
	'colortonefaithful' => { 18 => 0x107, 60 => 0x6c, 61 => 0x6c },
	'colortonelandscape' => { 18 => 0x105, 60 => 0x3c, 61 => 0x3c },
	'colortonemonochrome' => { 60 => 0x84, 61 => 0x84 },
	'colortoneneutral' => { 18 => 0x106, 60 => 0x54, 61 => 0x54 },
	'colortoneportrait' => { 18 => 0x104, 60 => 0x24, 61 => 0x24 },
	'colortonestandard' => { 18 => 0x103, 60 => 0xc, 61 => 0xc },
	'colortoneuserdef1' => { 18 => 0x109, 60 => 0x9c, 61 => 0xb4 },
	'colortoneuserdef2' => { 18 => 0x10a, 60 => 0xb4, 61 => 0xcc },
	'colortoneuserdef3' => { 18 => 0x10b, 60 => 0xcc, 61 => 0xe4 },
	'commanddials' => { 242 => '5.1' },
	'commanddialsaperturesetting' => { 234 => '17.3', 235 => '18.3', 240 => '33.3', 241 => '17.3', 244 => '18.3' },
	'commanddialschangemainsub' => { 234 => '17.2', 235 => '18.1', 240 => '33.2', 241 => '17.2', 244 => '18.1' },
	'commanddialsmenuandplayback' => { 234 => '17.4', 235 => '18.2', 240 => '33.4', 241 => '17.4', 244 => '18.2' },
	'commanddialsreverserotation' => { 234 => '17.1', 235 => '6.4', 237 => '16.2', 238 => '17.2', 240 => '33.1', 241 => '17.1', 244 => '6.2', 245 => '18.1' },
	'commanderchannel' => { 242 => '10.2', 243 => '25.2' },
	'commandergroupa_ttl-aacomp' => { 242 => '13.1', 243 => '31.1' },
	'commandergroupa_ttlcomp' => { 245 => '32.1' },
	'commandergroupamanualoutput' => { 242 => '13.2', 243 => '28.2' },
	'commandergroupamode' => { 242 => '11.2', 243 => '28.1' },
	'commandergroupb_ttl-aacomp' => { 242 => '14.1', 243 => '32.1' },
	'commandergroupb_ttlcomp' => { 245 => '33.1' },
	'commandergroupbmanualoutput' => { 242 => '14.2', 243 => '29.2' },
	'commandergroupbmode' => { 242 => '11.3', 243 => '29.1' },
	'commanderinternalflash' => { 242 => '11.1', 243 => '27.1' },
	'commanderinternalmanualoutput' => { 242 => '12.2', 243 => '27.2' },
	'commanderinternalttlchannel' => { 240 => '18.2' },
	'commanderinternalttlcomp' => { 242 => '12.1', 243 => '30.2', 245 => '31.2' },
	'commanderinternalttlcompbuiltin' => { 240 => '20.1', 241 => '26.1' },
	'commanderinternalttlcompgroupa' => { 240 => '21.1', 241 => '27.1' },
	'commanderinternalttlcompgroupb' => { 240 => '22.1', 241 => '28.1' },
	'comment' => { 0 => 0x2, 105 => 'Comment', 135 => 'Comment', 259 => 'Comment' },
	'compass' => { 325 => 0x4 },
	'complianceprofile' => { 408 => 'complianceProfile' },
	'componentsconfiguration' => { 104 => 0x9101, 140 => 'Components', 397 => 'ComponentsConfiguration' },
	'componentversion' => { 85 => 0x80c },
	'composer' => { 418 => 'composer' },
	'compositionadjust' => { 299 => '0.1' },
	'compositionadjustrotation' => { 299 => 0x7 },
	'compositionadjustx' => { 299 => 0x5 },
	'compositionadjusty' => { 299 => 0x6 },
	'compressedbitsperpixel' => { 104 => 0x9102, 397 => 'CompressedBitsPerPixel' },
	'compressedimagesize' => { 161 => 0x40, 252 => 0x40 },
	'compression' => { 104 => 0x103, 414 => 'Compression' },
	'compressionfactor' => { 247 => 0x50d },
	'compressionratio' => { 140 => 'Compression', 252 => 0x1034 },
	'confidencelevel' => { 388 => 'ConfidenceLevel' },
	'constrainedcropheight' => { 95 => 0x266, 308 => 0xd6 },
	'constrainedcropwidth' => { 95 => 0x262, 308 => 0xd5 },
	'contact' => { 112 => 0x76 },
	'contactinfo' => { 407 => 'contactInfo' },
	'contentlocationcode' => { 112 => 0x1a },
	'contentlocationname' => { 112 => 0x1b },
	'contenttype' => { 408 => 'contentType' },
	'continuousbracketing' => { 159 => 0x20 },
	'continuousdrive' => { 30 => 0x5 },
	'continuousshootingspeed' => { 72 => 0x610 },
	'continuousshotlimit' => { 72 => 0x611 },
	'contrast' => { 9 => 0x73, 11 => 0x75, 30 => 0xd, 99 => 0xc, 100 => [0x3012,0x20], 104 => [0xa408,0xfe54], 109 => [0x1004,0x1006], 134 => 'Contrast', 156 => 0x20, 157 => 0x31, 158 => 0x27, 159 => 0x19, 164 => 0x2, 193 => 0x33, 252 => 0x1029, 267 => 0x39, 269 => 0x300a, 300 => 0x20, 306 => 0xc, 318 => 0x24, 322 => 0x1012, 331 => 0xd, 338 => 0x1d, 339 => 0x1a, 350 => 0x2004, 393 => 'Contrast', 397 => 'Contrast' },
	'contrast2012' => { 393 => 'Contrast2012' },
	'contrastadj' => { 90 => 0x20303, 95 => 0x115, 230 => 0x2c, 378 => 0x8017 },
	'contrastauto' => { 61 => 0x90 },
	'contrastcurve' => { 191 => 0x8c },
	'contrastdetectaf' => { 167 => 0x4 },
	'contrastdetectafarea' => { 300 => 0x231 },
	'contrastdetectafinfocus' => { 167 => 0x1c },
	'contrastfaithful' => { 18 => 0xec, 60 => 0x60, 61 => 0x60 },
	'contrasthighlight' => { 300 => 0x6d },
	'contrasthighlightshadowadj' => { 300 => 0x6f },
	'contrastlandscape' => { 18 => 0xea, 60 => 0x30, 61 => 0x30 },
	'contrastmode' => { 267 => 0x2c },
	'contrastmonochrome' => { 18 => 0xed, 60 => 0x78, 61 => 0x78 },
	'contrastneutral' => { 18 => 0xeb, 60 => 0x48, 61 => 0x48 },
	'contrastportrait' => { 18 => 0xe9, 60 => 0x18, 61 => 0x18 },
	'contrastsetting' => { 247 => 0x505, 255 => 0x1012, 340 => 0x10, 354 => 0x8 },
	'contrastshadow' => { 300 => 0x6e },
	'contraststandard' => { 18 => 0xe8, 60 => 0x0, 61 => 0x0 },
	'contrastuserdef1' => { 18 => 0xee, 60 => 0x90, 61 => 0xa8 },
	'contrastuserdef2' => { 18 => 0xef, 60 => 0xa8, 61 => 0xc0 },
	'contrastuserdef3' => { 18 => 0xf0, 60 => 0xc0, 61 => 0xd8 },
	'contributedmedia' => { 418 => 'contributedMedia' },
	'contributedmediaduration' => { 418 => [\'contributedMedia','contributedMediaDuration'] },
	'contributedmediadurationscale' => { 418 => [\'contributedMedia','contributedMediaDurationScale'] },
	'contributedmediadurationvalue' => { 418 => [\'contributedMedia','contributedMediaDurationValue'] },
	'contributedmediamanaged' => { 418 => [\'contributedMedia','contributedMediaManaged'] },
	'contributedmediapath' => { 418 => [\'contributedMedia','contributedMediaPath'] },
	'contributedmediastarttime' => { 418 => [\'contributedMedia','contributedMediaStartTime'] },
	'contributedmediastarttimescale' => { 418 => [\'contributedMedia','contributedMediaStartTimeScale'] },
	'contributedmediastarttimevalue' => { 418 => [\'contributedMedia','contributedMediaStartTimeValue'] },
	'contributedmediatrack' => { 418 => [\'contributedMedia','contributedMediaTrack'] },
	'contributedmediawebstatement' => { 418 => [\'contributedMedia','contributedMediaWebStatement'] },
	'contributor' => { 394 => 'contributor' },
	'contributors' => { 135 => 'Contributors' },
	'controldialset' => { 159 => 0x46 },
	'controlledvocabularyterm' => { 403 => 'CVterm' },
	'controllerboardversion' => { 263 => 0x332 },
	'controlmode' => { 66 => 0x12 },
	'conversionlens' => { 248 => 0x403, 267 => 0x35 },
	'converter' => { 104 => 0xfe4d, 217 => 0xb, 393 => 'Converter' },
	'converttograyscale' => { 393 => 'ConvertToGrayscale' },
	'cookingequipment' => { 410 => 'cookingEquipment' },
	'cookingmethod' => { 410 => 'cookingMethod' },
	'copyright' => { 0 => 0x3, 104 => 0x8298, 135 => 'Copyright', 259 => 'Copyright', 300 => 0x22f, 313 => 'Copyright', 404 => 'Copyright', 411 => 'copyright', 414 => 'Copyright', 418 => 'copyright' },
	'copyrightflag' => { 311 => 0x40a },
	'copyrightnotice' => { 112 => 0x74 },
	'copyrightowner' => { 406 => 'CopyrightOwner' },
	'copyrightownerid' => { 406 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerID'] },
	'copyrightownerimageid' => { 406 => 'CopyrightOwnerImageID' },
	'copyrightownername' => { 406 => [\'CopyrightOwner','CopyrightOwnerCopyrightOwnerName'] },
	'copyrightregistrationnumber' => { 406 => 'CopyrightRegistrationNumber' },
	'copyrightstatus' => { 406 => 'CopyrightStatus' },
	'copyrightyear' => { 408 => 'copyrightYear' },
	'coringfilter' => { 251 => 0x310, 252 => 0x102d, 255 => 0x310 },
	'coringvalues' => { 251 => 0x311, 255 => 0x311 },
	'corporateentity' => { 408 => 'corporateEntity' },
	'country' => { 139 => 'Country', 267 => 0x69, 405 => 'Country' },
	'country-primarylocationcode' => { 112 => 0x64 },
	'country-primarylocationname' => { 112 => 0x65 },
	'countrycode' => { 190 => 0x5, 309 => 'CountryCode', 402 => 'CountryCode' },
	'course' => { 410 => 'course' },
	'coverage' => { 394 => 'coverage' },
	'coverdate' => { 408 => 'coverDate' },
	'coverdisplaydate' => { 408 => 'coverDisplayDate' },
	'cpufirmwareversion' => { 300 => 0x28 },
	'crc32' => { 395 => 'crc32' },
	'createdate' => { 104 => 0x9004, 135 => 'CreateDate', 256 => 'CreationDate', 259 => 'create-date', 313 => 'CreationDate', 315 => 0x1, 416 => 'CreateDate' },
	'creationdate' => { 404 => 'CreationDate', 408 => 'creationDate' },
	'creationtime' => { 259 => 'Creation Time' },
	'creativestyle' => { 338 => 0x1a, 339 => 0x18, 349 => 0x41, 350 => 0xb020, 374 => 0x4a },
	'creativestylesetting' => { 340 => 0xf, 354 => 0x7 },
	'creativestylewaschanged' => { 378 => 0x8001 },
	'creator' => { 256 => 'Creator', 313 => 'Creator', 394 => 'creator', 404 => 'Creator' },
	'creatoraddress' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiAdrExtadr'] },
	'creatorcity' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCity'] },
	'creatorcontactinfo' => { 402 => 'CreatorContactInfo' },
	'creatorcountry' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiAdrCtry'] },
	'creatorpostalcode' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiAdrPcode'] },
	'creatorregion' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiAdrRegion'] },
	'creatortool' => { 416 => 'CreatorTool' },
	'creatorworkemail' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiEmailWork'] },
	'creatorworktelephone' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiTelWork'] },
	'creatorworkurl' => { 402 => [\'CreatorContactInfo','CreatorContactInfoCiUrlWork'] },
	'credit' => { 112 => 0x6e, 405 => 'Credit' },
	'creditline' => { 411 => 'creditLine' },
	'creditlinereq' => { 421 => 'CreditLineReq' },
	'creditlinerequired' => { 406 => 'CreditLineRequired' },
	'cropactive' => { 89 => 0x0, 95 => 0x244 },
	'cropangle' => { 393 => 'CropAngle' },
	'cropaspectratio' => { 90 => 0x30101, 95 => 0x260 },
	'cropaspectratiocustom' => { 90 => 0x30102 },
	'cropbottom' => { 108 => 0x9, 222 => 0x36, 308 => 0xdc, 393 => 'CropBottom' },
	'cropbottommargin' => { 44 => 0x3 },
	'cropcircleactive' => { 96 => 0xd6 },
	'cropcircleradius' => { 96 => 0xd9 },
	'cropcirclex' => { 96 => 0xd7 },
	'cropcircley' => { 96 => 0xd8 },
	'cropconstraintowarp' => { 393 => 'CropConstrainToWarp' },
	'croph' => { 386 => 'CropH' },
	'cropheight' => { 89 => 0x6, 95 => 0x24c, 251 => 0x615, 255 => 0x615, 393 => 'CropHeight' },
	'crophispeed' => { 191 => 0x1b },
	'cropleft' => { 95 => 0x246, 108 => 0x6, 222 => 0x1e, 251 => 0x612, 255 => 0x612, 308 => 0xd9, 393 => 'CropLeft' },
	'cropleftmargin' => { 44 => 0x0 },
	'cropmode35mm' => { 322 => 0x1018 },
	'croporiginalheight' => { 89 => 0xb },
	'croporiginalwidth' => { 89 => 0xa },
	'cropoutputheight' => { 222 => 0xce },
	'cropoutputheightinches' => { 222 => 0x96 },
	'cropoutputpixels' => { 222 => 0xd6 },
	'cropoutputresolution' => { 222 => 0xb6 },
	'cropoutputscale' => { 222 => 0xbe },
	'cropoutputwidth' => { 222 => 0xc6 },
	'cropoutputwidthinches' => { 222 => 0x8e },
	'croppedareaimageheightpixels' => { 382 => 'CroppedAreaImageHeightPixels' },
	'croppedareaimagewidthpixels' => { 382 => 'CroppedAreaImageWidthPixels' },
	'croppedarealeftpixels' => { 382 => 'CroppedAreaLeftPixels' },
	'croppedareatoppixels' => { 382 => 'CroppedAreaTopPixels' },
	'croppedimageheight' => { 5 => 0x2, 322 => 0x1604 },
	'croppedimageleft' => { 5 => 0x3 },
	'croppedimagetop' => { 5 => 0x4 },
	'croppedimagewidth' => { 5 => 0x1, 322 => 0x1603 },
	'cropright' => { 108 => 0x8, 222 => 0x2e, 308 => 0xdb, 393 => 'CropRight' },
	'croprightmargin' => { 44 => 0x1 },
	'croprotatedoriginalheight' => { 89 => 0x2 },
	'croprotatedoriginalwidth' => { 89 => 0x1 },
	'croprotation' => { 89 => 0x8, 108 => 0xb },
	'cropscaledresolution' => { 222 => 0x9e },
	'cropsourceresolution' => { 222 => 0xae },
	'croptop' => { 95 => 0x248, 108 => 0x7, 222 => 0x26, 251 => 0x613, 255 => 0x613, 308 => 0xda, 393 => 'CropTop' },
	'croptopmargin' => { 44 => 0x2 },
	'cropunit' => { 393 => 'CropUnit' },
	'cropunits' => { 393 => 'CropUnits' },
	'cropw' => { 386 => 'CropW' },
	'cropwidth' => { 89 => 0x5, 95 => 0x24a, 251 => 0x614, 255 => 0x614, 393 => 'CropWidth' },
	'cropx' => { 89 => 0x3, 386 => 'CropX' },
	'cropy' => { 89 => 0x4, 386 => 'CropY' },
	'crossprocess' => { 300 => 0x7b },
	'crossprocessparams' => { 300 => 0x235 },
	'cuisine' => { 410 => 'cuisine' },
	'currenticcprofile' => { 104 => 0xc691 },
	'currentpreprofilematrix' => { 104 => 0xc692 },
	'currentversion' => { 378 => 0xd000 },
	'curve0x' => { 386 => 'Curve0x' },
	'curve0y' => { 386 => 'Curve0y' },
	'curve1x' => { 386 => 'Curve1x' },
	'curve1y' => { 386 => 'Curve1y' },
	'curve2x' => { 386 => 'Curve2x' },
	'curve2y' => { 386 => 'Curve2y' },
	'curve3x' => { 386 => 'Curve3x' },
	'curve3y' => { 386 => 'Curve3y' },
	'curve4x' => { 386 => 'Curve4x' },
	'curve4y' => { 386 => 'Curve4y' },
	'curves' => { 227 => 0x76a43201 },
	'custom1' => { 406 => 'Custom1' },
	'custom10' => { 406 => 'Custom10' },
	'custom2' => { 406 => 'Custom2' },
	'custom3' => { 406 => 'Custom3' },
	'custom4' => { 406 => 'Custom4' },
	'custom5' => { 406 => 'Custom5' },
	'custom6' => { 406 => 'Custom6' },
	'custom7' => { 406 => 'Custom7' },
	'custom8' => { 406 => 'Custom8' },
	'custom9' => { 406 => 'Custom9' },
	'customcolortone' => { 96 => 0x4c },
	'customcontrast' => { 96 => 0x4e },
	'customcontrols' => { 72 => 0x70c },
	'customdefaultunsharpfineness' => { 96 => 0xbe },
	'customdefaultunsharpstrength' => { 96 => 0xbc },
	'customdefaultunsharpthreshold' => { 96 => 0xc0 },
	'customlinear' => { 96 => 0x4f },
	'customoutputhighlightpoint' => { 96 => 0x53 },
	'customoutputshadowpoint' => { 96 => 0x54 },
	'custompicturestyle' => { 90 => 0x10021 },
	'custompicturestyledata' => { 90 => 0xf0500 },
	'custompicturestylefilename' => { 54 => 0x4010 },
	'customrawhighlight' => { 96 => 0x7c },
	'customrawhighlightpoint' => { 96 => 0x51 },
	'customrawshadow' => { 96 => 0x85 },
	'customrawshadowpoint' => { 96 => 0x52 },
	'customrendered' => { 104 => 0xa401, 397 => 'CustomRendered' },
	'customsaturation' => { 96 => 0x4d, 247 => 0x503 },
	'customsettingsalldefault' => { 234 => '0.2', 240 => '0.2' },
	'customsettingsbank' => { 234 => '0.1', 235 => '0.1', 240 => '0.1', 244 => '0.2' },
	'customsharpness' => { 96 => 0x50 },
	'customunsharpmaskfineness' => { 96 => 0xb8 },
	'customunsharpmaskstrength' => { 96 => 0xb6 },
	'customunsharpmaskthreshold' => { 96 => 0xba },
	'customwb_rblevels' => { 354 => 0x1a },
	'customwb_rgblevels' => { 339 => 0x8, 340 => 0x19 },
	'customwbbluelevel' => { 159 => 0x36 },
	'customwberror' => { 159 => 0x37 },
	'customwbgreenlevel' => { 159 => 0x35 },
	'customwbredlevel' => { 159 => 0x34 },
	'customwbsetting' => { 159 => 0x26 },
	'd-lightinghq' => { 227 => 0x2175eb78 },
	'd-lightinghqcolorboost' => { 223 => 0x2 },
	'd-lightinghqhighlight' => { 223 => 0x1 },
	'd-lightinghqselected' => { 227 => 0x6a6e36b6 },
	'd-lightinghqshadow' => { 223 => 0x0 },
	'd-lightinghs' => { 227 => 0xce5554aa },
	'd-lightinghsadjustment' => { 224 => 0x0 },
	'd-lightinghscolorboost' => { 224 => 0x1 },
	'd-rangeoptimizerhighlight' => { 378 => 0x8024 },
	'd-rangeoptimizermode' => { 378 => 0x8022 },
	'd-rangeoptimizershadow' => { 378 => 0x802d },
	'd-rangeoptimizervalue' => { 378 => 0x8023 },
	'd810meteringmode' => { 215 => 0x175e },
	'datacompressionmethod' => { 114 => 0x6e },
	'dataimprint' => { 156 => 0x34 },
	'datascaling' => { 300 => 0x3d },
	'date' => { 300 => 0x6, 394 => 'date' },
	'dateacquired' => { 154 => 'DateAcquired' },
	'datecreated' => { 112 => 0x37, 405 => 'DateCreated' },
	'datedisplayformat' => { 219 => 0x3 },
	'dateidentified' => { 103 => [\'Identification','IdentificationDateIdentified'] },
	'dateimprint' => { 237 => '4.2' },
	'daterecieved' => { 408 => 'dateRecieved' },
	'datesent' => { 113 => 0x46 },
	'datestampmode' => { 54 => 0x1c },
	'datetime' => { 387 => 'datetime', 414 => 'DateTime' },
	'datetimedigitized' => { 397 => 'DateTimeDigitized' },
	'datetimeoriginal' => { 88 => 0x0, 104 => 0x9003, 132 => 0x14, 135 => 'OriginalDate', 318 => 0xb, 397 => 'DateTimeOriginal' },
	'datetimestamp' => { 120 => 0x64 },
	'datetimeutc' => { 247 => 0x908 },
	'daylightsavings' => { 67 => 0x3, 219 => 0x2 },
	'dccontinent' => { 103 => [\'dctermsLocation','dctermsLocationContinent'] },
	'dccoordinateprecision' => { 103 => [\'dctermsLocation','dctermsLocationCoordinatePrecision'] },
	'dccoordinateuncertaintyinmeters' => { 103 => [\'dctermsLocation','dctermsLocationCoordinateUncertaintyInMeters'] },
	'dccountry' => { 103 => [\'dctermsLocation','dctermsLocationCountry'] },
	'dccountrycode' => { 103 => [\'dctermsLocation','dctermsLocationCountryCode'] },
	'dccounty' => { 103 => [\'dctermsLocation','dctermsLocationCounty'] },
	'dcdecimallatitude' => { 103 => [\'dctermsLocation','dctermsLocationDecimalLatitude'] },
	'dcdecimallongitude' => { 103 => [\'dctermsLocation','dctermsLocationDecimalLongitude'] },
	'dcevent' => { 103 => 'Event' },
	'dcfootprintspatialfit' => { 103 => [\'dctermsLocation','dctermsLocationFootprintSpatialFit'] },
	'dcfootprintsrs' => { 103 => [\'dctermsLocation','dctermsLocationFootprintSRS'] },
	'dcfootprintwkt' => { 103 => [\'dctermsLocation','dctermsLocationFootprintWKT'] },
	'dcgeodeticdatum' => { 103 => [\'dctermsLocation','dctermsLocationGeodeticDatum'] },
	'dcgeoreferencedby' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferencedBy'] },
	'dcgeoreferenceddate' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferencedDate'] },
	'dcgeoreferenceprotocol' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceProtocol'] },
	'dcgeoreferenceremarks' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceRemarks'] },
	'dcgeoreferencesources' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceSources'] },
	'dcgeoreferenceverificationstatus' => { 103 => [\'dctermsLocation','dctermsLocationGeoreferenceVerificationStatus'] },
	'dchighergeography' => { 103 => [\'dctermsLocation','dctermsLocationHigherGeography'] },
	'dchighergeographyid' => { 103 => [\'dctermsLocation','dctermsLocationHigherGeographyID'] },
	'dcisland' => { 103 => [\'dctermsLocation','dctermsLocationIsland'] },
	'dcislandgroup' => { 103 => [\'dctermsLocation','dctermsLocationIslandGroup'] },
	'dclocality' => { 103 => [\'dctermsLocation','dctermsLocationLocality'] },
	'dclocationaccordingto' => { 103 => [\'dctermsLocation','dctermsLocationLocationAccordingTo'] },
	'dclocationid' => { 103 => [\'dctermsLocation','dctermsLocationLocationID'] },
	'dclocationremarks' => { 103 => [\'dctermsLocation','dctermsLocationLocationRemarks'] },
	'dcmaximumdepthinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumDepthInMeters'] },
	'dcmaximumdistanceabovesurfaceinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumDistanceAboveSurfaceInMeters'] },
	'dcmaximumelevationinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMaximumElevationInMeters'] },
	'dcminimumdepthinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumDepthInMeters'] },
	'dcminimumdistanceabovesurfaceinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumDistanceAboveSurfaceInMeters'] },
	'dcminimumelevationinmeters' => { 103 => [\'dctermsLocation','dctermsLocationMinimumElevationInMeters'] },
	'dcmunicipality' => { 103 => [\'dctermsLocation','dctermsLocationMunicipality'] },
	'dcpointradiusspatialfit' => { 103 => [\'dctermsLocation','dctermsLocationPointRadiusSpatialFit'] },
	'dcstateprovince' => { 103 => [\'dctermsLocation','dctermsLocationStateProvince'] },
	'dctermslocation' => { 103 => 'dctermsLocation' },
	'dcverbatimcoordinates' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimCoordinates'] },
	'dcverbatimcoordinatesystem' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimCoordinateSystem'] },
	'dcverbatimdepth' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimDepth'] },
	'dcverbatimelevation' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimElevation'] },
	'dcverbatimlatitude' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLatitude'] },
	'dcverbatimlocality' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLocality'] },
	'dcverbatimlongitude' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimLongitude'] },
	'dcverbatimsrs' => { 103 => [\'dctermsLocation','dctermsLocationVerbatimSRS'] },
	'dcwaterbody' => { 103 => [\'dctermsLocation','dctermsLocationWaterBody'] },
	'declination' => { 143 => 'Declination' },
	'decposition' => { 156 => 0x32 },
	'defaultblackrender' => { 104 => 0xc7a6 },
	'defaultcroporigin' => { 104 => 0xc61f },
	'defaultcropsize' => { 104 => 0xc620 },
	'defaulteraseoption' => { 72 => 0x813 },
	'defaultscale' => { 104 => 0xc61e },
	'defaultusercrop' => { 104 => 0xc7b5 },
	'defringe' => { 393 => 'Defringe' },
	'defringegreenamount' => { 393 => 'DefringeGreenAmount' },
	'defringegreenhuehi' => { 393 => 'DefringeGreenHueHi' },
	'defringegreenhuelo' => { 393 => 'DefringeGreenHueLo' },
	'defringepurpleamount' => { 393 => 'DefringePurpleAmount' },
	'defringepurplehuehi' => { 393 => 'DefringePurpleHueHi' },
	'defringepurplehuelo' => { 393 => 'DefringePurpleHueLo' },
	'deletedimagecount' => { 191 => 0xa6, 198 => 0x6e },
	'deprecatedon' => { 390 => 'deprecatedOn' },
	'derivedfrom' => { 419 => 'DerivedFrom' },
	'derivedfromalternatepaths' => { 419 => [\'DerivedFrom','DerivedFromAlternatePaths'] },
	'derivedfromdocumentid' => { 419 => [\'DerivedFrom','DerivedFromDocumentID'] },
	'derivedfromfilepath' => { 419 => [\'DerivedFrom','DerivedFromFilePath'] },
	'derivedfromfrompart' => { 419 => [\'DerivedFrom','DerivedFromFromPart'] },
	'derivedfrominstanceid' => { 419 => [\'DerivedFrom','DerivedFromInstanceID'] },
	'derivedfromlastmodifydate' => { 419 => [\'DerivedFrom','DerivedFromLastModifyDate'] },
	'derivedfrommanager' => { 419 => [\'DerivedFrom','DerivedFromManager'] },
	'derivedfrommanagervariant' => { 419 => [\'DerivedFrom','DerivedFromManagerVariant'] },
	'derivedfrommanageto' => { 419 => [\'DerivedFrom','DerivedFromManageTo'] },
	'derivedfrommanageui' => { 419 => [\'DerivedFrom','DerivedFromManageUI'] },
	'derivedfrommaskmarkers' => { 419 => [\'DerivedFrom','DerivedFromMaskMarkers'] },
	'derivedfromoriginaldocumentid' => { 419 => [\'DerivedFrom','DerivedFromOriginalDocumentID'] },
	'derivedfrompartmapping' => { 419 => [\'DerivedFrom','DerivedFromPartMapping'] },
	'derivedfromrenditionclass' => { 419 => [\'DerivedFrom','DerivedFromRenditionClass'] },
	'derivedfromrenditionparams' => { 419 => [\'DerivedFrom','DerivedFromRenditionParams'] },
	'derivedfromtopart' => { 419 => [\'DerivedFrom','DerivedFromToPart'] },
	'derivedfromversionid' => { 419 => [\'DerivedFrom','DerivedFromVersionID'] },
	'description' => { 259 => 'Description', 394 => 'description', 416 => 'Description' },
	'destination' => { 113 => 0x5 },
	'destinationcity' => { 300 => 0x24, 305 => 0x3 },
	'destinationcitycode' => { 306 => 0x1001 },
	'destinationdst' => { 300 => 0x26, 305 => '0.3' },
	'developmentdynamicrange' => { 109 => 0x1403 },
	'device' => { 408 => 'device' },
	'devicesettingdescription' => { 397 => 'DeviceSettingDescription' },
	'devicesettingdescriptioncolumns' => { 397 => [\'DeviceSettingDescription','DeviceSettingDescriptionColumns'] },
	'devicesettingdescriptionrows' => { 397 => [\'DeviceSettingDescription','DeviceSettingDescriptionRows'] },
	'devicesettingdescriptionsettings' => { 397 => [\'DeviceSettingDescription','DeviceSettingDescriptionSettings'] },
	'devicetype' => { 328 => 0x2 },
	'dialdirectiontvav' => { 72 => 0x706 },
	'dietaryneeds' => { 410 => 'dietaryNeeds' },
	'diffractioncorrection' => { 290 => 0x3 },
	'digitalcreationdate' => { 112 => 0x3e },
	'digitalcreationtime' => { 112 => 0x3f },
	'digitaldeehighlightadj' => { 197 => 0x202 },
	'digitaldeeshadowadj' => { 197 => 0x200 },
	'digitaldeethreshold' => { 197 => 0x201 },
	'digitalfilter' => { 331 => 0x59 },
	'digitalfilter01' => { 287 => 0x5 },
	'digitalfilter02' => { 287 => 0x16 },
	'digitalfilter03' => { 287 => 0x27 },
	'digitalfilter04' => { 287 => 0x38 },
	'digitalfilter05' => { 287 => 0x49 },
	'digitalfilter06' => { 287 => 0x5a },
	'digitalfilter07' => { 287 => 0x6b },
	'digitalfilter08' => { 287 => 0x7c },
	'digitalfilter09' => { 287 => 0x8d },
	'digitalfilter10' => { 287 => 0x9e },
	'digitalfilter11' => { 287 => 0xaf },
	'digitalfilter12' => { 287 => 0xc0 },
	'digitalfilter13' => { 287 => 0xd1 },
	'digitalfilter14' => { 287 => 0xe2 },
	'digitalfilter15' => { 287 => 0xf3 },
	'digitalfilter16' => { 287 => 0x104 },
	'digitalfilter17' => { 287 => 0x115 },
	'digitalfilter18' => { 287 => 0x126 },
	'digitalfilter19' => { 287 => 0x137 },
	'digitalfilter20' => { 287 => 0x148 },
	'digitalgain' => { 64 => 0xb },
	'digitalgem' => { 183 => 0x0 },
	'digitalice' => { 197 => 0x100 },
	'digitalimageguid' => { 403 => 'DigImageGUID' },
	'digitalroc' => { 195 => 0x0 },
	'digitalsourcefiletype' => { 403 => 'DigitalSourcefileType' },
	'digitalsourcetype' => { 403 => 'DigitalSourceType' },
	'digitalzoom' => { 30 => 0xc, 99 => 0xa, 120 => 0x68, 134 => 'DigitalZoom', 156 => 0xc, 191 => 0x86, 217 => 0xa, 252 => 0x204, 300 => 0x1e, 306 => 0xa, 330 => 0x204, 366 => 0x12, 367 => 0x12 },
	'digitalzoomon' => { 330 => 0x21b },
	'digitalzoomratio' => { 104 => 0xa404, 359 => 0x200, 361 => 0x21c, 397 => 'DigitalZoomRatio' },
	'director' => { 418 => 'director' },
	'directorphotography' => { 418 => 'directorPhotography' },
	'directory' => { 105 => 'Directory' },
	'directoryindex' => { 6 => 0x137, 8 => 0x2dc, 10 => 0x17e, 12 => 0x238, 13 => 0x13f, 14 => 0x133, 15 => 0x1df, 16 => 0x1a7, 17 => 0x1f0, 18 => 0xcc, 19 => 0x1c7, 20 => 0x298, 21 => 0x1e7, 22 => 0x1e5, 23 => [0x27c,0x280], 24 => 0x2b6, 25 => 0x2bf, 26 => 0x1f7 },
	'directoryindex2' => { 20 => 0x29c },
	'directorynumber' => { 179 => 0x3 },
	'disclaimer' => { 259 => 'Disclaimer' },
	'discnumber' => { 418 => 'discNumber' },
	'dishtype' => { 410 => 'dishType' },
	'displayallafpoints' => { 72 => 0x514 },
	'displayaperture' => { 30 => 0x23 },
	'displayedunitsx' => { 312 => 0x2 },
	'displayedunitsy' => { 312 => 0x6 },
	'displayname' => { 407 => 'displayName' },
	'distance1' => { 120 => 0x28 },
	'distance2' => { 120 => 0x2c },
	'distance3' => { 120 => 0x30 },
	'distance4' => { 120 => 0x34 },
	'distortion' => { 328 => 0xa050 },
	'distortioncontrol' => { 198 => 0x10 },
	'distortioncorrection' => { 90 => 0x20705, 96 => 0x67, 247 => 0x50b, 270 => '7.1', 290 => 0x0, 373 => 0x601, 374 => 0x5b },
	'distortioncorrection2' => { 251 => 0x1011 },
	'distortioncorrectionalreadyapplied' => { 389 => 'DistortionCorrectionAlreadyApplied' },
	'distortioncorrectionon' => { 90 => '0x20705.0', 96 => 0x63 },
	'distortioncorrectionsetting' => { 350 => 0x2013 },
	'distortioneffect' => { 90 => 0x20709 },
	'distortionn' => { 270 => 0xc },
	'distortionparam02' => { 270 => 0x2 },
	'distortionparam04' => { 270 => 0x4 },
	'distortionparam08' => { 270 => 0x8 },
	'distortionparam09' => { 270 => 0x9 },
	'distortionparam11' => { 270 => 0xb },
	'distortionscale' => { 270 => 0x5 },
	'distributor' => { 408 => 'distributor' },
	'distributorproductid' => { 407 => 'distributorProductID' },
	'dloon' => { 90 => '0x20706.0', 96 => 0xdc },
	'dlosetting' => { 90 => 0x20706, 96 => 0xdd },
	'dlosettingapplied' => { 96 => 0xe4 },
	'dloshootingdistance' => { 96 => 0xde },
	'dloversion' => { 96 => 0xe5 },
	'dmcomment' => { 418 => 'comment' },
	'dngadobedata' => { 104 => 0xc634 },
	'dngbackwardversion' => { 104 => 0xc613 },
	'dnglensinfo' => { 104 => 0xc630 },
	'dngprivatedata' => { 104 => 0xc634 },
	'dngversion' => { 104 => 0xc612 },
	'document' => { 259 => 'Document' },
	'documentancestorid' => { 405 => [\'DocumentAncestors','DocumentAncestorsAncestorID'] },
	'documentancestors' => { 405 => 'DocumentAncestors' },
	'documenthistory' => { 112 => 0xe7 },
	'documentid' => { 419 => 'DocumentID' },
	'documentname' => { 104 => 0x10d },
	'documentnotes' => { 112 => 0xe6 },
	'doi' => { 408 => 'doi' },
	'dotrange' => { 104 => 0x150 },
	'dpp' => { 387 => 'dpp' },
	'dr4cameramodel' => { 91 => 0x3 },
	'drivemode' => { 100 => 0x3103, 156 => 0x6, 159 => 0x1e, 162 => 0xe, 247 => 0x600, 300 => 0x34, 322 => 0x1002, 331 => 0x3, 338 => 0x4, 339 => 0x7e, 340 => 0x34 },
	'drivemode2' => { 159 => 0xa, 281 => 0x7, 349 => 0xe, 354 => 0x1 },
	'drivemodesetting' => { 340 => 0x4 },
	'dspfirmwareversion' => { 300 => 0x27 },
	'duration' => { 57 => 0x6a, 133 => 'Duration', 147 => 'Duration', 410 => 'duration', 418 => 'duration' },
	'durationscale' => { 418 => [\'duration','durationScale'] },
	'durationvalue' => { 418 => [\'duration','durationValue'] },
	'dustremovaldata' => { 54 => 0x97 },
	'dynamicafarea' => { 234 => '1.4', 240 => '1.4' },
	'dynamicareaafdisplay' => { 235 => '46.1', 244 => '47.1' },
	'dynamicrange' => { 109 => 0x1400 },
	'dynamicrangeexpansion' => { 300 => 0x69, 322 => 0x100e },
	'dynamicrangemax' => { 95 => 0x7c },
	'dynamicrangemin' => { 95 => 0x7a },
	'dynamicrangeoptimizer' => { 159 => 0x15, 350 => [0xb025,0xb04f], 357 => 0x1144, 358 => [0x1144,0x324], 359 => [0x1120,0x300], 360 => [0x119c,0x37c], 361 => [0x1178,0x328], 362 => [0x1030,0x50], 363 => [0x228,0x50], 364 => [0x228,0x50] },
	'dynamicrangeoptimizerbracket' => { 349 => 0x2e },
	'dynamicrangeoptimizerlevel' => { 338 => 0x19, 339 => 0x17, 340 => 0xd, 349 => 0x79, 354 => 0x5 },
	'dynamicrangeoptimizermode' => { 162 => 0x15, 338 => 0x18, 339 => 0x16, 349 => [0x77,0x15] },
	'dynamicrangeoptimizersetting' => { 159 => 0x27, 340 => 0xc, 354 => 0x4 },
	'dynamicrangesetting' => { 109 => 0x1402 },
	'e-dialinprogram' => { 281 => '1.3' },
	'e-mountversioncamera' => { 340 => 0x3f3, 377 => 0xb },
	'e-mountversionlens' => { 340 => 0x3f0, 377 => 0xd },
	'earliestageorloweststage' => { 103 => [\'GeologicalContext','GeologicalContextEarliestAgeOrLowestStage'] },
	'earliesteonorlowesteonothem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEonOrLowestEonothem'] },
	'earliestepochorlowestseries' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEpochOrLowestSeries'] },
	'earliesteraorlowesterathem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestEraOrLowestErathem'] },
	'earliestperiodorlowestsystem' => { 103 => [\'GeologicalContext','GeologicalContextEarliestPeriodOrLowestSystem'] },
	'easyexposurecomp' => { 245 => '6.1' },
	'easyexposurecompensation' => { 234 => '6.4', 235 => '6.5', 240 => '4.4', 241 => '5.2', 244 => '6.3' },
	'easymode' => { 30 => 0xb },
	'edgenoisereduction' => { 228 => 0x4, 378 => 0x8028 },
	'edition' => { 408 => 'edition' },
	'editorialupdate' => { 112 => 0x8 },
	'editstatus' => { 112 => 0x7, 309 => 'EditStatus' },
	'editversionname' => { 227 => 0x3d136244 },
	'effectivelv' => { 300 => 0x2d },
	'effectivemaxaperture' => { 187 => 0x12, 188 => 0x13 },
	'eissn' => { 408 => 'eIssn' },
	'electronicfront-curtainshutter' => { 244 => '5.3' },
	'elevation' => { 143 => 'Elevation' },
	'email' => { 135 => 'EMail' },
	'embargodate' => { 411 => 'embargoDate' },
	'embdencrightsexpr' => { 403 => 'EmbdEncRightsExpr' },
	'embeddedencodedrightsexpr' => { 403 => [\'EmbdEncRightsExpr','EmbdEncRightsExprEncRightsExpr'] },
	'embeddedencodedrightsexprlangid' => { 403 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprLangId'] },
	'embeddedencodedrightsexprtype' => { 403 => [\'EmbdEncRightsExpr','EmbdEncRightsExprRightsExprEncType'] },
	'embeddedxmpdigest' => { 405 => 'EmbeddedXMPDigest' },
	'emissivity' => { 106 => 0x3 },
	'encryptionkey' => { 328 => 0xa020 },
	'endingpage' => { 408 => 'endingPage' },
	'enduser' => { 406 => 'EndUser' },
	'enduserid' => { 406 => [\'EndUser','EndUserEndUserID'] },
	'endusername' => { 406 => [\'EndUser','EndUserEndUserName'] },
	'engineer' => { 418 => 'engineer' },
	'enhancedarktones' => { 220 => 0x8 },
	'enhancement' => { 99 => 0x16, 100 => 0x3016 },
	'enhancer' => { 251 => 0x300 },
	'enhancervalues' => { 251 => 0x301 },
	'envelopenumber' => { 113 => 0x28 },
	'envelopepriority' => { 113 => 0x3c },
	'enveloperecordversion' => { 113 => 0x0 },
	'epsonimageheight' => { 252 => 0x20c },
	'epsonimagewidth' => { 252 => 0x20b },
	'epsonsoftware' => { 252 => 0x20d },
	'equipmentinstitution' => { 380 => 'EquipmentInstitution' },
	'equipmentmanufacturer' => { 380 => 'EquipmentManufacturer' },
	'equipmentversion' => { 248 => 0x0 },
	'ettlii' => { 72 => 0x304, 73 => 0xd, 74 => 0xe, 75 => 0x7, 76 => 0x7, 77 => 0xe },
	'event' => { 381 => 'Event', 385 => 'Event', 403 => 'Event', 408 => 'event' },
	'eventalias' => { 407 => 'eventAlias' },
	'eventday' => { 103 => [\'Event','EventDay'] },
	'eventearliestdate' => { 103 => [\'Event','EventEarliestDate'] },
	'eventend' => { 407 => 'eventEnd' },
	'eventenddayofyear' => { 103 => [\'Event','EventEndDayOfYear'] },
	'eventfieldnotes' => { 103 => [\'Event','EventFieldNotes'] },
	'eventfieldnumber' => { 103 => [\'Event','EventFieldNumber'] },
	'eventhabitat' => { 103 => [\'Event','EventHabitat'] },
	'eventid' => { 103 => [\'Event','EventEventID'] },
	'eventlatestdate' => { 103 => [\'Event','EventLatestDate'] },
	'eventmonth' => { 103 => [\'Event','EventMonth'] },
	'eventnumber' => { 318 => 0x9 },
	'eventremarks' => { 103 => [\'Event','EventEventRemarks'] },
	'eventsamplingeffort' => { 103 => [\'Event','EventSamplingEffort'] },
	'eventsamplingprotocol' => { 103 => [\'Event','EventSamplingProtocol'] },
	'eventstart' => { 407 => 'eventStart' },
	'eventstartdayofyear' => { 103 => [\'Event','EventStartDayOfYear'] },
	'eventsubtype' => { 407 => 'eventSubtype' },
	'eventtime' => { 103 => [\'Event','EventEventTime'] },
	'eventtype' => { 407 => 'eventType' },
	'eventverbatimeventdate' => { 103 => [\'Event','EventVerbatimEventDate'] },
	'eventyear' => { 103 => [\'Event','EventYear'] },
	'evsteps' => { 281 => '1.2', 283 => 0x0 },
	'evstepsize' => { 237 => '5.1', 238 => '6.1', 239 => '6.1', 242 => '0.7' },
	'exclusivityenddate' => { 411 => 'exclusivityEndDate' },
	'excursiontolerance' => { 114 => 0x82 },
	'exif' => { 105 => 'EXIF' },
	'exifbyteorder' => { 105 => 'ExifByteOrder' },
	'exifcamerainfo' => { 112 => 0xe8 },
	'exifimageheight' => { 104 => 0xa003, 397 => 'PixelYDimension' },
	'exifimagewidth' => { 104 => 0xa002, 397 => 'PixelXDimension' },
	'exifunicodebyteorder' => { 105 => 'ExifUnicodeByteOrder' },
	'exifversion' => { 104 => 0x9000, 397 => 'ExifVersion' },
	'exitpupilposition' => { 187 => 0x4, 188 => 0x4 },
	'expirationdate' => { 112 => 0x25, 411 => 'expirationDate' },
	'expirationtime' => { 112 => 0x26 },
	'exposure' => { 104 => 0xfe51, 393 => 'Exposure' },
	'exposure2012' => { 393 => 'Exposure2012' },
	'exposureadj' => { 225 => 0x0 },
	'exposureadj2' => { 225 => 0x12 },
	'exposureadjust' => { 331 => 0xc },
	'exposurebracketingindicatorlast' => { 159 => 0x52 },
	'exposurebracketshotnumber' => { 162 => 0x2d, 349 => 0x2f },
	'exposurebracketstepsize' => { 281 => 0x8 },
	'exposurebracketvalue' => { 191 => 0x19 },
	'exposurecompensation' => { 66 => 0x6, 81 => 0x0, 104 => 0x9204, 120 => 0x24, 134 => 'ExposureComp', 156 => 0xd, 157 => 0x53, 158 => 0x1e, 162 => 0x49c0, 252 => 0x1006, 300 => 0x16, 328 => 0xa013, 331 => [0xc,0x35,0x4d], 357 => 0x114c, 358 => 0x114c, 359 => 0x1128, 361 => 0x1180, 362 => 0x1038, 363 => 0x230, 364 => 0x230, 397 => 'ExposureBiasValue' },
	'exposurecompensation2' => { 354 => [0x24,0x26,0x2a] },
	'exposurecompensationmode' => { 159 => 0x47, 162 => 0x2a },
	'exposurecompensationset' => { 338 => 0x3, 339 => 0x3, 340 => 0x3, 354 => 0x1e },
	'exposurecompensationsetting' => { 159 => 0x1 },
	'exposurecompstepsize' => { 234 => '6.3', 235 => '7.3', 240 => '4.3', 244 => '7.3' },
	'exposurecontrolstep' => { 241 => '6.1' },
	'exposurecontrolstepsize' => { 234 => '6.2', 235 => '7.1', 240 => '4.2', 244 => '7.1', 245 => '7.1' },
	'exposurecount' => { 109 => 0x1032 },
	'exposuredelaymode' => { 234 => '10.1', 235 => '11.1', 237 => '9.1', 238 => '10.1', 239 => '10.1', 240 => '10.4', 241 => '10.1', 242 => '6.4', 244 => '11.1', 245 => '11.2' },
	'exposuredifference' => { 191 => 0xe },
	'exposureindex' => { 104 => 0xa215, 397 => 'ExposureIndex' },
	'exposureindicator' => { 159 => 0x50 },
	'exposurelevelincrements' => { 70 => 0x6, 71 => 0x6, 72 => 0x101, 73 => 0x5, 74 => 0x6, 75 => 0x5, 76 => 0x5, 77 => 0x6, 78 => 0x4, 338 => 0x58, 339 => 0x58 },
	'exposurelockused' => { 382 => 'ExposureLockUsed' },
	'exposuremode' => { 104 => 0xa402, 134 => 'ExposureMode', 156 => 0x1, 157 => 0xa, 158 => 0x0, 159 => 0x0, 162 => 0x34, 247 => 0x200, 265 => 0x40d, 331 => 0x8, 350 => 0xb041, 397 => 'ExposureMode' },
	'exposuremodeinmanual' => { 72 => 0x10b },
	'exposureprogram' => { 104 => 0x8822, 322 => 0x1001, 332 => 0x17e, 338 => 0x3c, 339 => 0x3c, 340 => 0x5, 344 => 0x14, 349 => 0x3f, 354 => 0x2, 357 => 0x1175, 358 => 0x1179, 359 => 0x1155, 360 => 0x11d1, 361 => 0x11ad, 362 => 0x1065, 363 => 0x25d, 364 => 0x25d, 374 => 0x48, 397 => 'ExposureProgram' },
	'exposureshift' => { 247 => 0x203 },
	'exposuretime' => { 6 => 0x4, 7 => 0x4, 8 => 0x4, 9 => 0x4, 10 => 0x4, 11 => 0x4, 12 => 0x4, 13 => 0x4, 14 => 0x4, 15 => 0x4, 16 => 0x4, 17 => 0x4, 18 => 0x4, 19 => 0x4, 20 => 0x4, 21 => 0x4, 22 => 0x4, 23 => 0x4, 24 => 0x4, 25 => 0x4, 26 => 0x4, 27 => 0x6, 28 => 0x7, 66 => 0x16, 104 => 0x829a, 117 => 0xfd05, 120 => 0x20, 122 => 0xfa24, 124 => 0xf104, 127 => 0x12, 129 => 0x38, 132 => 0x10, 134 => 'ExposureTime', 156 => 0x9, 157 => 0x35, 158 => 0x48, 159 => 0x8, 162 => 0x49b8, 300 => 0x12, 328 => 0xa018, 331 => [0x32,0x4a], 338 => 0x0, 339 => 0x0, 354 => [0x21,0x23,0x27], 374 => 0x10, 397 => 'ExposureTime' },
	'exposuretime2' => { 331 => [0x33,0x4b] },
	'exposuretuning' => { 191 => 0x1c },
	'exposurevalue' => { 118 => 0x3 },
	'exposurewarning' => { 109 => 0x1302 },
	'exrauto' => { 109 => 0x1033 },
	'exrmode' => { 109 => 0x1034 },
	'extendedwbdetect' => { 247 => 0x902 },
	'extender' => { 248 => 0x301 },
	'extenderfirmwareversion' => { 248 => 0x304 },
	'extendermagnification' => { 136 => 'Magnification' },
	'extendermake' => { 136 => 'Make' },
	'extendermodel' => { 136 => 'Model', 248 => 0x303 },
	'extenderserialnumber' => { 136 => 'SerialNumber', 248 => 0x302 },
	'externalflash' => { 250 => 0x1201 },
	'externalflashae1' => { 252 => 0x101f },
	'externalflashae1_0' => { 252 => 0x101b },
	'externalflashae2' => { 252 => 0x1020 },
	'externalflashae2_0' => { 252 => 0x101c },
	'externalflashbounce' => { 250 => 0x1204, 252 => 0x1026, 288 => 0x1a },
	'externalflashcompensation' => { 182 => 0x1b },
	'externalflashexposurecomp' => { 191 => 0x17, 288 => 0x19 },
	'externalflashfirmware' => { 180 => 0x6, 181 => 0x6, 182 => 0x6 },
	'externalflashflags' => { 180 => 0x8, 181 => 0x8, 182 => 0x8 },
	'externalflashguidenumber' => { 250 => 0x1203, 288 => '24.1' },
	'externalflashgvalue' => { 252 => 0x1025 },
	'externalflashmode' => { 252 => 0x1028, 288 => 0x2 },
	'externalflashzoom' => { 250 => 0x1205, 252 => 0x1027 },
	'externalsensorbrightnessvalue' => { 263 => 0x311, 269 => 0x3408 },
	'extrainfoversion' => { 342 => 0x1a },
	'eyestartaf' => { 159 => 0x40 },
	'face10position' => { 97 => 0x3f4, 98 => 0x1ec, 178 => 0x28, 285 => 0x12 },
	'face10size' => { 286 => 0x12 },
	'face11position' => { 178 => 0x2c, 285 => 0x14 },
	'face11size' => { 286 => 0x14 },
	'face12position' => { 178 => 0x30, 285 => 0x16 },
	'face12size' => { 286 => 0x16 },
	'face13position' => { 285 => 0x18 },
	'face13size' => { 286 => 0x18 },
	'face14position' => { 285 => 0x1a },
	'face14size' => { 286 => 0x1a },
	'face15position' => { 285 => 0x1c },
	'face15size' => { 286 => 0x1c },
	'face16position' => { 285 => 0x1e },
	'face16size' => { 286 => 0x1e },
	'face17position' => { 285 => 0x20 },
	'face17size' => { 286 => 0x20 },
	'face18position' => { 285 => 0x22 },
	'face18size' => { 286 => 0x22 },
	'face19position' => { 285 => 0x24 },
	'face19size' => { 286 => 0x24 },
	'face1position' => { 45 => 0x8, 97 => 0xd, 98 => 0x18, 178 => 0x4, 261 => 0x1, 285 => 0x0, 319 => 0xbc, 345 => 0x1, 346 => 0x0, 347 => 0x0, 348 => 0x5b },
	'face1size' => { 286 => 0x0 },
	'face20position' => { 285 => 0x26 },
	'face20size' => { 286 => 0x26 },
	'face21position' => { 285 => 0x28 },
	'face21size' => { 286 => 0x28 },
	'face22position' => { 285 => 0x2a },
	'face22size' => { 286 => 0x2a },
	'face23position' => { 285 => 0x2c },
	'face23size' => { 286 => 0x2c },
	'face24position' => { 285 => 0x2e },
	'face24size' => { 286 => 0x2e },
	'face25position' => { 285 => 0x30 },
	'face25size' => { 286 => 0x30 },
	'face26position' => { 285 => 0x32 },
	'face26size' => { 286 => 0x32 },
	'face27position' => { 285 => 0x34 },
	'face27size' => { 286 => 0x34 },
	'face28position' => { 285 => 0x36 },
	'face28size' => { 286 => 0x36 },
	'face29position' => { 285 => 0x38 },
	'face29size' => { 286 => 0x38 },
	'face2position' => { 45 => 0xa, 97 => 0x7c, 98 => 0x4c, 178 => 0x8, 261 => 0x5, 285 => 0x2, 319 => 0xc8, 345 => 0x6, 346 => 0x20, 347 => 0x25, 348 => 0x65 },
	'face2size' => { 286 => 0x2 },
	'face30position' => { 285 => 0x3a },
	'face30size' => { 286 => 0x3a },
	'face31position' => { 285 => 0x3c },
	'face31size' => { 286 => 0x3c },
	'face32position' => { 285 => 0x3e },
	'face32size' => { 286 => 0x3e },
	'face3position' => { 45 => 0xc, 97 => 0xeb, 98 => 0x80, 178 => 0xc, 261 => 0x9, 285 => 0x4, 319 => 0xd4, 345 => 0xb, 346 => 0x40, 347 => 0x4a, 348 => 0x6f },
	'face3size' => { 286 => 0x4 },
	'face4position' => { 45 => 0xe, 97 => 0x15a, 98 => 0xb4, 178 => 0x10, 261 => 0xd, 285 => 0x6, 319 => 0xe0, 345 => 0x10, 346 => 0x60, 347 => 0x6f, 348 => 0x79 },
	'face4size' => { 286 => 0x6 },
	'face5position' => { 45 => 0x10, 97 => 0x1c9, 98 => 0xe8, 178 => 0x14, 261 => 0x11, 285 => 0x8, 319 => 0xec, 345 => 0x15, 346 => 0x80, 347 => 0x94 },
	'face5size' => { 286 => 0x8 },
	'face6position' => { 45 => 0x12, 97 => 0x238, 98 => 0x11c, 178 => 0x18, 285 => 0xa, 319 => 0xf8, 345 => 0x1a, 346 => 0xa0, 347 => 0xb9 },
	'face6size' => { 286 => 0xa },
	'face7position' => { 45 => 0x14, 97 => 0x2a7, 98 => 0x150, 178 => 0x1c, 285 => 0xc, 319 => 0x104, 345 => 0x1f, 346 => 0xc0, 347 => 0xde },
	'face7size' => { 286 => 0xc },
	'face8position' => { 45 => 0x16, 97 => 0x316, 98 => 0x184, 178 => 0x20, 285 => 0xe, 319 => 0x110, 345 => 0x24, 346 => 0xe0, 347 => 0x103 },
	'face8size' => { 286 => 0xe },
	'face9position' => { 45 => 0x18, 97 => 0x385, 98 => 0x1b8, 178 => 0x24, 285 => 0x10 },
	'face9size' => { 286 => 0x10 },
	'facedetect' => { 300 => 0x76, 328 => 0x100 },
	'facedetectarea' => { 251 => 0x1201 },
	'facedetectframecrop' => { 251 => 0x1207 },
	'facedetectframesize' => { 45 => 0x3, 97 => 0x1, 98 => 0x4, 178 => 0x1, 251 => 0x1203, 300 => 0x77, 319 => 0xb6 },
	'facedetection' => { 340 => 0x30, 354 => 0x19 },
	'faceid' => { 388 => 'FaceID' },
	'faceinfounknown' => { 100 => 0x2089 },
	'facename' => { 328 => 0x123 },
	'faceorientation' => { 98 => 0x8 },
	'faceposition' => { 284 => 0x2, 329 => 0x4 },
	'facepositions' => { 109 => 0x4103 },
	'facerecognition' => { 328 => 0x120 },
	'facesdetected' => { 45 => 0x2, 46 => 0x2, 47 => 0x3, 97 => 0x0, 98 => 0x2, 100 => 0x211c, 109 => 0x4100, 178 => 0x3, 251 => 0x1200, 267 => 0x3f, 284 => 0x0, 319 => 0xb5, 329 => 0x0, 345 => 0x0, 348 => 0x3, 356 => 0x30 },
	'facesrecognized' => { 262 => 0x0 },
	'facewidth' => { 46 => 0x1 },
	'faithfuloutputhighlightpoint' => { 96 => 0x38 },
	'faithfuloutputshadowpoint' => { 96 => 0x39 },
	'faithfulrawcolortone' => { 96 => 0x31 },
	'faithfulrawcontrast' => { 96 => 0x33 },
	'faithfulrawhighlight' => { 96 => 0x79 },
	'faithfulrawhighlightpoint' => { 96 => 0x36 },
	'faithfulrawlinear' => { 96 => 0x34 },
	'faithfulrawsaturation' => { 96 => 0x32 },
	'faithfulrawshadow' => { 96 => 0x82 },
	'faithfulrawshadowpoint' => { 96 => 0x37 },
	'faithfulrawsharpness' => { 96 => 0x35 },
	'faithfulunsharpmaskfineness' => { 96 => 0xac },
	'faithfulunsharpmaskstrength' => { 96 => 0xaa },
	'faithfulunsharpmaskthreshold' => { 96 => 0xae },
	'femicroadjustment' => { 72 => 0x111 },
	'ffid' => { 395 => 'ffid' },
	'field' => { 407 => 'field' },
	'fieldcount' => { 252 => 0x103f },
	'filecreatedate' => { 105 => 'FileCreateDate' },
	'filedatarate' => { 418 => 'fileDataRate' },
	'fileformat' => { 83 => 0x0, 113 => 0x14, 331 => [0x22,0x26], 350 => 0xb000 },
	'fileindex' => { 6 => 0x143, 8 => 0x2d0, 10 => 0x172, 12 => 0x22c, 13 => 0x133, 14 => 0x13f, 15 => 0x1d3, 16 => 0x19b, 17 => 0x1e4, 18 => 0xd0, 19 => 0x1bb, 20 => 0x28c, 21 => 0x1db, 22 => 0x1d9, 23 => [0x270,0x274], 24 => 0x2aa, 25 => 0x2b3, 26 => 0x1eb, 268 => 0x0 },
	'fileindex2' => { 20 => 0x290 },
	'filemodifydate' => { 105 => 'FileModifyDate' },
	'filename' => { 105 => 'FileName' },
	'filenameasdelivered' => { 406 => 'FileNameAsDelivered' },
	'filenumber' => { 48 => 0x1, 54 => 0x8, 85 => 0x1817, 101 => 'FileNumber', 179 => 0x4 },
	'filenumbermemory' => { 156 => 0x1a },
	'filenumbersequence' => { 234 => '12.2', 237 => '3.1', 238 => '4.1', 239 => '4.1', 240 => '11.1', 241 => '4.3', 245 => '5.2' },
	'filesource' => { 104 => 0xa300, 109 => 0x8000, 397 => 'FileSource' },
	'fileversion' => { 113 => 0x16 },
	'fillflashautoreduction' => { 70 => 0xe, 71 => 0xe, 78 => 0xa },
	'filllight' => { 393 => 'FillLight' },
	'fillorder' => { 104 => 0x10a },
	'filmmode' => { 109 => 0x1401, 265 => 0x412, 267 => 0x42 },
	'filmtype' => { 197 => 0x2 },
	'filtereffect' => { 48 => 0xe, 193 => 0x37 },
	'filtereffectauto' => { 61 => 0xa0 },
	'filtereffectfaithful' => { 60 => 0x70, 61 => 0x70 },
	'filtereffectlandscape' => { 60 => 0x40, 61 => 0x40 },
	'filtereffectmonochrome' => { 18 => 0xff, 60 => 0x88, 61 => 0x88 },
	'filtereffectneutral' => { 60 => 0x58, 61 => 0x58 },
	'filtereffectportrait' => { 60 => 0x28, 61 => 0x28 },
	'filtereffectstandard' => { 60 => 0x10, 61 => 0x10 },
	'filtereffectuserdef1' => { 60 => 0xa0, 61 => 0xb8 },
	'filtereffectuserdef2' => { 60 => 0xb8, 61 => 0xd0 },
	'filtereffectuserdef3' => { 60 => 0xd0, 61 => 0xe8 },
	'finderdisplayduringexposure' => { 71 => 0x1 },
	'finesharpness' => { 300 => 0x70 },
	'finetuneoptcenterweighted' => { 234 => '7.2', 235 => '9.1', 244 => '9.1', 245 => '9.1' },
	'finetuneopthighlightweighted' => { 244 => '46.1' },
	'finetuneoptmatrixmetering' => { 234 => '8.1', 235 => '8.2', 240 => '6.1', 244 => '8.2', 245 => '8.2' },
	'finetuneoptspotmetering' => { 234 => '8.2', 235 => '9.2', 240 => '6.2', 244 => '9.2', 245 => '9.2' },
	'firmware' => { 252 => 0x405, 331 => [0x17,0x3b,0x57], 389 => 'Firmware' },
	'firmwaredate' => { 99 => 0x15, 100 => 0x2001, 318 => 0x4 },
	'firmwareid' => { 163 => 0x0 },
	'firmwarename' => { 328 => 0xa001 },
	'firmwarerevision' => { 18 => 0xa4, 54 => 0x1e, 320 => 0x0 },
	'firmwarerevision2' => { 320 => 0xc },
	'firmwareversion' => { 6 => 0x10b, 10 => 0x136, 13 => 0xff, 14 => 0x107, 118 => 0xce5, 132 => 0x57, 134 => 'FirmwareVersion', 267 => 0x2, 269 => 0x3109, 300 => 0x230, 322 => 0x2 },
	'firstphotodate' => { 382 => 'FirstPhotoDate' },
	'firstpublicationdate' => { 406 => 'FirstPublicationDate' },
	'fixtureidentifier' => { 112 => 0x16 },
	'flash' => { 101 => 'Flash', 104 => 0x9209, 157 => 0x1f, 158 => 0x15, 397 => 'Flash' },
	'flashaction' => { 338 => 0x3e, 339 => 0x3e, 350 => 0x2017, 354 => [0x2a,0x2c,0x30] },
	'flashaction2' => { 338 => 0x4c, 339 => 0x4c, 354 => 0x77 },
	'flashactionexternal' => { 354 => [0x78,0x7c] },
	'flashactivity' => { 30 => 0x1c },
	'flashbatterylevel' => { 36 => 0x249 },
	'flashbias' => { 267 => 0x24 },
	'flashbits' => { 30 => 0x1d },
	'flashbuttonfunction' => { 72 => 0x70e },
	'flashchargelevel' => { 252 => 0x1010 },
	'flashcolorfilter' => { 182 => 0x10 },
	'flashcommandermode' => { 180 => '9.1', 181 => '9.1', 182 => '9.1' },
	'flashcompensation' => { 180 => 0xa, 181 => 0xa, 182 => 0xa, 389 => 'FlashCompensation' },
	'flashcontrol' => { 338 => 0x23, 339 => 0x1f, 340 => 0x21 },
	'flashcontrolbuilt-in' => { 240 => '16.1', 241 => '23.1', 243 => '23.1', 244 => '24.1' },
	'flashcontrolmode' => { 180 => '9.2', 181 => '9.2', 182 => '9.2', 247 => 0x404 },
	'flashcurtain' => { 267 => 0x48 },
	'flashdefault' => { 159 => 0x42 },
	'flashdevice' => { 252 => 0x1005 },
	'flashdistance' => { 100 => 0x2034 },
	'flashenergy' => { 104 => 0xa20b, 397 => 'FlashEnergy' },
	'flashexposurebracketvalue' => { 191 => 0x18 },
	'flashexposurecomp' => { 66 => 0xf, 109 => 0x1011, 137 => 'ExposureComp', 156 => 0x23, 161 => 0x104, 162 => 0x49c1, 191 => 0x12, 247 => 0x401, 252 => 0x1023, 300 => 0x4d, 322 => 0x100b, 331 => [0x3a,0x56], 350 => 0x104 },
	'flashexposurecomp2' => { 214 => 0x4d2 },
	'flashexposurecomp3' => { 182 => 0x1d },
	'flashexposurecomp4' => { 182 => 0x27 },
	'flashexposurecomparea' => { 235 => '38.4', 244 => '38.4' },
	'flashexposurecompset' => { 159 => 0x10, 274 => 0xe, 338 => 0x14, 339 => 0x12, 340 => 0x23, 354 => 0x1f },
	'flashexposurecompset2' => { 354 => [0x26,0x2c] },
	'flashexposureindicator' => { 159 => 0x54 },
	'flashexposureindicatorlast' => { 159 => 0x56 },
	'flashexposureindicatornext' => { 159 => 0x55 },
	'flashexposurelock' => { 48 => 0x19 },
	'flashfired' => { 120 => 0x5d, 137 => 'Fired', 156 => 0x14, 213 => '590.3', 267 => 0x8007, 397 => [\'Flash','FlashFired'] },
	'flashfiring' => { 72 => 0x306, 73 => 0x6, 74 => 0x7, 77 => 0x7 },
	'flashfirmwareversion' => { 248 => 0x1002 },
	'flashfocallength' => { 180 => 0xb, 181 => 0xc, 182 => 0xc },
	'flashfunction' => { 162 => 0x31, 397 => [\'Flash','FlashFunction'] },
	'flashgndistance' => { 180 => 0xe, 181 => 0xf, 182 => 0xf },
	'flashgroupacompensation' => { 180 => 0x11, 181 => 0x12, 182 => 0x13 },
	'flashgroupacontrolmode' => { 180 => 0xf, 181 => '16.1', 182 => '17.1' },
	'flashgroupaoutput' => { 180 => 0x11, 181 => 0x12, 182 => 0x13 },
	'flashgroupbcompensation' => { 180 => 0x12, 181 => 0x13, 182 => 0x14 },
	'flashgroupbcontrolmode' => { 180 => 0x10, 181 => '17.1', 182 => '18.1' },
	'flashgroupboutput' => { 180 => 0x12, 181 => 0x13, 182 => 0x14 },
	'flashgroupccompensation' => { 181 => 0x14, 182 => 0x15 },
	'flashgroupccontrolmode' => { 181 => '17.2', 182 => '18.2' },
	'flashgroupcoutput' => { 181 => 0x14, 182 => 0x15 },
	'flashguidenumber' => { 66 => 0xd, 82 => 0x0, 137 => 'GuideNumber' },
	'flashintensity' => { 99 => [0x19,0x5], 247 => 0x405 },
	'flashlevel' => { 236 => 0x9, 350 => 0xb048 },
	'flashmake' => { 137 => 'Make' },
	'flashmanufacturer' => { 154 => 'FlashManufacturer' },
	'flashmetering' => { 156 => 0x3f, 159 => 0x1c },
	'flashmeteringmode' => { 6 => 0x15, 12 => 0x15, 13 => 0x15, 14 => 0x15, 15 => 0x15, 16 => 0x15, 17 => 0x15, 19 => 0x15, 21 => 0x15, 26 => 0x15 },
	'flashmeteringsegments' => { 300 => 0x20a },
	'flashmode' => { 99 => 0x4, 120 => 0x5c, 137 => 'Mode', 156 => 0x2, 157 => 0x20, 158 => 0x16, 159 => 0xf, 191 => 0x87, 247 => 0x400, 252 => 0x1004, 300 => 0xc, 306 => 0x4, 321 => 0x20, 322 => 0x100a, 330 => 0x225, 338 => 0x13, 339 => 0x7f, 340 => 0x20, 354 => 0x10, 357 => 0x1138, 358 => 0x1138, 359 => 0x1114, 360 => 0x1190, 361 => 0x116c, 362 => 0x1024, 363 => 0x21c, 364 => 0x21c, 397 => [\'Flash','FlashMode'] },
	'flashmodel' => { 137 => 'Model', 154 => 'FlashModel', 248 => 0x1001 },
	'flashoptions' => { 281 => 0x2 },
	'flashoptions2' => { 281 => 0x10 },
	'flashoutput' => { 36 => 0x248, 66 => 0x21, 180 => 0xa, 181 => 0xa, 182 => 0xa },
	'flashpixversion' => { 104 => 0xa000, 397 => 'FlashpixVersion' },
	'flashredeyemode' => { 397 => [\'Flash','FlashRedEyeMode'] },
	'flashremotecontrol' => { 247 => 0x403 },
	'flashreturn' => { 397 => [\'Flash','FlashReturn'] },
	'flashserialnumber' => { 137 => 'SerialNumber', 248 => 0x1003 },
	'flashsetting' => { 191 => 0x8 },
	'flashshutterspeed' => { 234 => '20.2', 235 => '23.2', 240 => '15.2', 241 => '22.2', 242 => '7.2', 243 => '22.2', 244 => '23.2', 245 => '23.1' },
	'flashsource' => { 180 => 0x4, 181 => 0x4, 182 => 0x4 },
	'flashstatus' => { 288 => 0x0, 354 => [0x82,0x86], 365 => [0x31,0x39] },
	'flashstatusbuilt-in' => { 340 => [0x87,0x287] },
	'flashstatusexternal' => { 340 => [0x88,0x288] },
	'flashsyncspeed' => { 234 => '20.1', 235 => '23.1', 240 => '15.1', 241 => '22.1', 243 => '22.1', 244 => '23.1' },
	'flashsyncspeedav' => { 70 => 0x3, 72 => 0x10f, 73 => 0x2, 74 => 0x3, 75 => 0x2, 76 => 0x2, 77 => 0x3, 78 => 0x6 },
	'flashthreshold' => { 82 => 0x1 },
	'flashtype' => { 137 => 'Type', 159 => 0x59, 191 => 0x9, 248 => 0x1000 },
	'flashwarning' => { 241 => '30.1', 242 => '7.1', 245 => '31.1', 267 => 0x62 },
	'flexiblespotposition' => { 350 => 0x201d },
	'flickerreduce' => { 330 => 0x218 },
	'fliphorizontal' => { 227 => 0x76a43206 },
	'fnumber' => { 6 => 0x3, 8 => 0x3, 10 => 0x3, 12 => 0x3, 13 => 0x3, 14 => 0x3, 15 => 0x3, 16 => 0x3, 17 => 0x3, 18 => 0x3, 19 => 0x3, 20 => 0x3, 21 => 0x3, 22 => 0x3, 23 => 0x3, 24 => 0x3, 25 => 0x3, 26 => 0x3, 27 => 0x5, 28 => 0x6, 66 => 0x15, 104 => 0x829d, 117 => 0xfd04, 120 => 0x1e, 122 => 0xfa23, 124 => 0xf103, 127 => 0x13, 129 => 0x3c, 132 => 0xc, 141 => 'FNumber', 156 => 0xa, 157 => 0x36, 158 => 0x47, 159 => 0x9, 162 => 0x49c7, 300 => 0x13, 328 => 0xa019, 331 => [0x31,0x49], 338 => 0x1, 339 => 0x1, 354 => [0x20,0x22,0x26], 397 => 'FNumber' },
	'focallength' => { 6 => 0x1d, 7 => 0xa, 8 => 0x23, 9 => 0x9, 10 => 0x1d, 11 => 0x9, 12 => 0x1e, 13 => 0x1d, 14 => 0x1d, 15 => 0x1e, 16 => 0x1e, 17 => 0x1e, 18 => 0x28, 19 => 0x1e, 20 => 0x23, 21 => 0x1e, 22 => 0x1e, 23 => 0x23, 24 => 0x23, 25 => 0x23, 26 => 0x1e, 50 => 0x1, 100 => 0x1d, 104 => 0x920a, 127 => 0x1d, 141 => 'FocalLength', 156 => 0x12, 187 => 0xa, 188 => 0xb, 291 => 0x9, 300 => 0x1d, 322 => 0x1500, 337 => 0xe, 361 => 0x1278, 362 => 0x1134, 363 => 0x32c, 364 => 0x32c, 397 => 'FocalLength' },
	'focallength2' => { 354 => [0x23,0x25,0x29] },
	'focallengthin35mmformat' => { 104 => 0xa405, 328 => 0xa01a, 397 => 'FocalLengthIn35mmFilm' },
	'focallengthtelezoom' => { 337 => 0x10 },
	'focalplanediagonal' => { 248 => 0x103, 252 => 0x205 },
	'focalplaneresolutionunit' => { 104 => 0xa210, 397 => 'FocalPlaneResolutionUnit' },
	'focalplanexresolution' => { 104 => 0xa20e, 397 => 'FocalPlaneXResolution' },
	'focalplanexsize' => { 50 => 0x2 },
	'focalplanexunknown' => { 50 => 0x2 },
	'focalplaneyresolution' => { 104 => 0xa20f, 397 => 'FocalPlaneYResolution' },
	'focalplaneysize' => { 50 => 0x3 },
	'focalplaneyunknown' => { 50 => 0x3 },
	'focaltype' => { 9 => 0x2d, 50 => 0x0 },
	'focalunits' => { 30 => 0x19 },
	'focus' => { 217 => 0x8 },
	'focusarea' => { 156 => 0x31 },
	'focusareaselection' => { 242 => '15.2' },
	'focuscontinuous' => { 30 => 0x20 },
	'focusdisplayaiservoandmf' => { 72 => 0x515 },
	'focusdistance' => { 141 => 'FocusDistance', 156 => 0x13, 162 => 0x49bb, 187 => 0x9, 188 => 0xa, 250 => 0x305 },
	'focusdistancelower' => { 6 => 0x45, 8 => 0x8e, 10 => 0x45, 12 => 0x56, 13 => 0x45, 14 => 0x45, 15 => 0x52, 16 => 0x52, 17 => 0x56, 19 => 0x52, 20 => 0x8e, 21 => 0x59, 22 => 0x57, 23 => 0x8e, 24 => 0x94, 25 => 0x95, 26 => 0x56, 48 => 0x15, 66 => 0x14 },
	'focusdistanceupper' => { 6 => 0x43, 8 => 0x8c, 10 => 0x43, 12 => 0x54, 13 => 0x43, 14 => 0x43, 15 => 0x50, 16 => 0x50, 17 => 0x54, 19 => 0x50, 20 => 0x8c, 21 => 0x57, 22 => 0x55, 23 => 0x8c, 24 => 0x92, 25 => 0x93, 26 => 0x54, 48 => 0x14, 66 => 0x13 },
	'focusholdbutton' => { 159 => 0x44 },
	'focusinfoversion' => { 250 => 0x0 },
	'focusingscreen' => { 71 => 0x0, 72 => 0x80b, 77 => 0x0 },
	'focuslocked' => { 155 => 0x14 },
	'focusmode' => { 30 => 0x7, 99 => 0x3, 100 => [0x3003,0xd], 109 => 0x1021, 120 => 0x38, 134 => 'FocusMode', 156 => 0x30, 158 => 0xe, 159 => 0xc, 191 => 0x7, 247 => 0x301, 252 => 0x100b, 267 => 0x7, 300 => 0xd, 306 => 0x3, 322 => 0x1006, 332 => [0xb,0x5], 337 => [0x15,0x1d], 338 => 0x4d, 339 => 0x4d, 350 => [0xb042,0xb04e,0x201b], 354 => 0x13, 369 => 0x16 },
	'focusmode2' => { 281 => '3.1', 354 => [0x2c,0x2e,0x32] },
	'focusmodesetting' => { 236 => '10.1', 335 => 0x14, 336 => 0x15, 338 => 0x10, 339 => 0xf, 340 => 0x6 },
	'focusmodeswitch' => { 159 => 0x58, 338 => 0x2e },
	'focuspixel' => { 109 => 0x1023 },
	'focuspointwrap' => { 234 => '2.2', 235 => '2.2', 240 => '2.2', 241 => '1.2', 244 => '2.2', 245 => '2.5' },
	'focusposition' => { 187 => 0x8, 188 => 0x8, 300 => 0x10, 349 => 0x9bb },
	'focusposition2' => { 354 => [0x29,0x2b,0x2f], 369 => 0x2d, 372 => 0x20 },
	'focusprocess' => { 247 => 0x302 },
	'focusrange' => { 30 => 0x12, 252 => 0x100a },
	'focusrangeindex' => { 291 => '3.1' },
	'focussetting' => { 331 => 0x6 },
	'focusstatus' => { 337 => 0x19, 338 => 0x53, 339 => 0x53 },
	'focusstepcount' => { 250 => 0x301, 252 => 0x100e },
	'focusstepinfinity' => { 250 => 0x303, 252 => 0x103b },
	'focusstepnear' => { 250 => 0x304, 252 => 0x103c },
	'focustrackinglockon' => { 234 => ['1.5','4.1'], 235 => '1.4', 240 => '3.1', 241 => '0.4', 244 => '1.4' },
	'focuswarning' => { 109 => 0x1301 },
	'foldername' => { 156 => 0x27 },
	'foldernumber' => { 338 => 0x9a, 340 => [0x402,0x114,0x316] },
	'fontcomposite' => { 423 => [\'Fonts','FontsComposite'] },
	'fontface' => { 423 => [\'Fonts','FontsFontFace'] },
	'fontfamily' => { 423 => [\'Fonts','FontsFontFamily'] },
	'fontfilename' => { 423 => [\'Fonts','FontsFontFileName'] },
	'fontname' => { 423 => [\'Fonts','FontsFontName'] },
	'fonts' => { 423 => 'Fonts' },
	'fonttype' => { 423 => [\'Fonts','FontsFontType'] },
	'fontversion' => { 423 => [\'Fonts','FontsVersionString'] },
	'for' => { 313 => 'For' },
	'format' => { 394 => 'format', 416 => 'Format' },
	'forwardlock' => { 413 => 'forwardlock' },
	'forwardmatrix1' => { 104 => 0xc714 },
	'forwardmatrix2' => { 104 => 0xc715 },
	'framecount' => { 57 => [0x2,0x4] },
	'frameheight' => { 109 => 0x3822 },
	'framenum' => { 308 => 0xd7 },
	'framenumber' => { 109 => 0x8003, 162 => 0x3c, 300 => 0x29 },
	'framerate' => { 57 => [0x1,0x6], 104 => 0xc764, 109 => 0x3820 },
	'framewidth' => { 109 => 0x3821 },
	'framing' => { 407 => 'framing' },
	'freebytes' => { 85 => 0x1 },
	'freememorycardimages' => { 157 => [0x37,0x54], 158 => [0x2d,0x4a], 159 => 0x32 },
	'fujiflashmode' => { 109 => 0x1010 },
	'fullimagesize' => { 350 => 0xb02b },
	'fullpanoheightpixels' => { 382 => 'FullPanoHeightPixels' },
	'fullpanowidthpixels' => { 382 => 'FullPanoWidthPixels' },
	'fullpresssnap' => { 322 => 0x100d },
	'fullsizeimage' => { 140 => 'data' },
	'fullsizeimagename' => { 140 => '1Name' },
	'fullsizeimagetype' => { 140 => '0Type' },
	'funcbutton' => { 234 => ['14.1','15.1'], 235 => '14.1', 240 => '28.1', 241 => '13.1', 244 => '14.1', 245 => '14.1' },
	'funcbuttonplusdials' => { 234 => ['14.2','15.2'], 235 => '14.2', 240 => '31.1', 244 => '42.1' },
	'functionbutton' => { 239 => '13.1', 242 => '5.2' },
	'gainbase' => { 251 => 0x610 },
	'gaincontrol' => { 104 => 0xa407, 397 => 'GainControl' },
	'gamma' => { 104 => 0xa500, 398 => 'Gamma' },
	'gammablackpoint' => { 92 => 0xc },
	'gammacolortone' => { 92 => 0x3 },
	'gammacompensatedvalue' => { 114 => 0x91 },
	'gammacontrast' => { 92 => 0x2 },
	'gammacurveoutputrange' => { 92 => 0xf },
	'gammahighlight' => { 92 => 0xa },
	'gammalinear' => { 90 => 0x20200 },
	'gammamidpoint' => { 92 => 0xe },
	'gammasaturation' => { 92 => 0x4 },
	'gammashadow' => { 92 => 0x9 },
	'gammasharpnessstrength' => { 92 => 0x8 },
	'gammaunsharpmaskfineness' => { 92 => 0x6 },
	'gammaunsharpmaskstrength' => { 92 => 0x5 },
	'gammaunsharpmaskthreshold' => { 92 => 0x7 },
	'gammewhitepoint' => { 92 => 0xd },
	'geimagesize' => { 109 => 0x1304 },
	'gemake' => { 110 => 0x300 },
	'gemodel' => { 110 => 0x207 },
	'genre' => { 408 => 'genre', 418 => 'genre' },
	'geography' => { 409 => 'geography' },
	'geologicalcontext' => { 103 => 'GeologicalContext' },
	'geologicalcontextbed' => { 103 => [\'GeologicalContext','GeologicalContextBed'] },
	'geologicalcontextformation' => { 103 => [\'GeologicalContext','GeologicalContextFormation'] },
	'geologicalcontextgroup' => { 103 => [\'GeologicalContext','GeologicalContextGroup'] },
	'geologicalcontextid' => { 103 => [\'GeologicalContext','GeologicalContextGeologicalContextID'] },
	'geologicalcontextmember' => { 103 => [\'GeologicalContext','GeologicalContextMember'] },
	'geosync' => { 105 => 'Geosync' },
	'geotag' => { 105 => 'Geotag' },
	'geotiffasciiparams' => { 104 => 0x87b1 },
	'geotiffdirectory' => { 104 => 0x87af },
	'geotiffdoubleparams' => { 104 => 0x87b0 },
	'geotime' => { 105 => 'Geotime' },
	'globalaltitude' => { 311 => 0x419 },
	'globalangle' => { 311 => 0x40d },
	'good' => { 418 => 'good' },
	'googleplusuploadcode' => { 104 => 0x9009 },
	'gpsaltitude' => { 111 => 0x6, 138 => 'Altitude', 397 => 'GPSAltitude' },
	'gpsaltituderef' => { 111 => 0x5, 397 => 'GPSAltitudeRef' },
	'gpsareainformation' => { 111 => 0x1c, 397 => 'GPSAreaInformation' },
	'gpsdatestamp' => { 111 => 0x1d },
	'gpsdatetime' => { 138 => 'DateTime', 397 => 'GPSTimeStamp' },
	'gpsdestbearing' => { 111 => 0x18, 138 => 'Bearing', 397 => 'GPSDestBearing' },
	'gpsdestbearingref' => { 111 => 0x17, 397 => 'GPSDestBearingRef' },
	'gpsdestdistance' => { 111 => 0x1a, 138 => 'Distance', 397 => 'GPSDestDistance' },
	'gpsdestdistanceref' => { 111 => 0x19, 397 => 'GPSDestDistanceRef' },
	'gpsdestlatitude' => { 111 => 0x14, 397 => 'GPSDestLatitude' },
	'gpsdestlatituderef' => { 111 => 0x13 },
	'gpsdestlongitude' => { 111 => 0x16, 397 => 'GPSDestLongitude' },
	'gpsdestlongituderef' => { 111 => 0x15 },
	'gpsdifferential' => { 111 => 0x1e, 138 => 'Differential', 397 => 'GPSDifferential' },
	'gpsdop' => { 111 => 0xb, 397 => 'GPSDOP' },
	'gpshpositioningerror' => { 111 => 0x1f, 397 => 'GPSHPositioningError' },
	'gpsimgdirection' => { 111 => 0x11, 397 => 'GPSImgDirection' },
	'gpsimgdirectionref' => { 111 => 0x10, 397 => 'GPSImgDirectionRef' },
	'gpslatitude' => { 111 => 0x2, 138 => 'Latitude', 397 => 'GPSLatitude' },
	'gpslatituderef' => { 111 => 0x1 },
	'gpslongitude' => { 111 => 0x4, 138 => 'Longitude', 397 => 'GPSLongitude' },
	'gpslongituderef' => { 111 => 0x3 },
	'gpsmapdatum' => { 111 => 0x12, 138 => 'Datum', 397 => 'GPSMapDatum' },
	'gpsmeasuremode' => { 111 => 0xa, 138 => 'MeasureMode', 397 => 'GPSMeasureMode' },
	'gpsprocessingmethod' => { 111 => 0x1b, 397 => 'GPSProcessingMethod' },
	'gpssatellites' => { 111 => 0x8, 138 => 'Satellites', 397 => 'GPSSatellites' },
	'gpsspeed' => { 111 => 0xd, 138 => 'Speed', 397 => 'GPSSpeed' },
	'gpsspeedref' => { 111 => 0xc, 397 => 'GPSSpeedRef' },
	'gpsstatus' => { 111 => 0x9, 397 => 'GPSStatus' },
	'gpstimestamp' => { 111 => 0x7 },
	'gpstrack' => { 111 => 0xf, 138 => 'Heading', 397 => 'GPSTrack' },
	'gpstrackref' => { 111 => 0xe, 397 => 'GPSTrackRef' },
	'gpsversionid' => { 111 => 0x0, 397 => 'GPSVersionID' },
	'gradation' => { 247 => 0x50f },
	'gradientbasedcorractive' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionActive'] },
	'gradientbasedcorramount' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionAmount'] },
	'gradientbasedcorrbrightness' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalBrightness'] },
	'gradientbasedcorrclarity' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity'] },
	'gradientbasedcorrclarity2012' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalClarity2012'] },
	'gradientbasedcorrcontrast' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast'] },
	'gradientbasedcorrcontrast2012' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalContrast2012'] },
	'gradientbasedcorrdefringe' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalDefringe'] },
	'gradientbasedcorrections' => { 393 => 'GradientBasedCorrections' },
	'gradientbasedcorrexposure' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure'] },
	'gradientbasedcorrexposure2012' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalExposure2012'] },
	'gradientbasedcorrhighlights2012' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalHighlights2012'] },
	'gradientbasedcorrhue' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalToningHue'] },
	'gradientbasedcorrluminancenoise' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalLuminanceNoise'] },
	'gradientbasedcorrmaskalpha' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAlpha'] },
	'gradientbasedcorrmaskangle' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksAngle'] },
	'gradientbasedcorrmaskbottom' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksBottom'] },
	'gradientbasedcorrmaskcentervalue' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterValue'] },
	'gradientbasedcorrmaskcenterweight' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksCenterWeight'] },
	'gradientbasedcorrmaskdabs' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksDabs'] },
	'gradientbasedcorrmaskfeather' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFeather'] },
	'gradientbasedcorrmaskflipped' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlipped'] },
	'gradientbasedcorrmaskflow' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFlow'] },
	'gradientbasedcorrmaskfullx' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullX'] },
	'gradientbasedcorrmaskfully' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksFullY'] },
	'gradientbasedcorrmaskleft' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksLeft'] },
	'gradientbasedcorrmaskmidpoint' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMidpoint'] },
	'gradientbasedcorrmaskperimetervalue' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'gradientbasedcorrmaskradius' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRadius'] },
	'gradientbasedcorrmaskright' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRight'] },
	'gradientbasedcorrmaskroundness' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksRoundness'] },
	'gradientbasedcorrmasks' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasks'] },
	'gradientbasedcorrmasksizex' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeX'] },
	'gradientbasedcorrmasksizey' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksSizeY'] },
	'gradientbasedcorrmasktop' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksTop'] },
	'gradientbasedcorrmaskvalue' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksMaskValue'] },
	'gradientbasedcorrmaskversion' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksVersion'] },
	'gradientbasedcorrmaskwhat' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksWhat'] },
	'gradientbasedcorrmaskx' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksX'] },
	'gradientbasedcorrmasky' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksY'] },
	'gradientbasedcorrmaskzerox' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroX'] },
	'gradientbasedcorrmaskzeroy' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsCorrectionMasksZeroY'] },
	'gradientbasedcorrmoire' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalMoire'] },
	'gradientbasedcorrsaturation' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSaturation','GradientBasedCorrectionsLocalToningSaturation'] },
	'gradientbasedcorrshadows2012' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalShadows2012'] },
	'gradientbasedcorrsharpness' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalSharpness'] },
	'gradientbasedcorrtemperature' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTemperature'] },
	'gradientbasedcorrtint' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsLocalTint'] },
	'gradientbasedcorrwhat' => { 393 => [\'GradientBasedCorrections','GradientBasedCorrectionsWhat'] },
	'grainamount' => { 393 => 'GrainAmount' },
	'grainfrequency' => { 393 => 'GrainFrequency' },
	'grainsize' => { 393 => 'GrainSize' },
	'graymixeraqua' => { 393 => 'GrayMixerAqua' },
	'graymixerblue' => { 393 => 'GrayMixerBlue' },
	'graymixergreen' => { 393 => 'GrayMixerGreen' },
	'graymixermagenta' => { 393 => 'GrayMixerMagenta' },
	'graymixerorange' => { 393 => 'GrayMixerOrange' },
	'graymixerpurple' => { 393 => 'GrayMixerPurple' },
	'graymixerred' => { 393 => 'GrayMixerRed' },
	'graymixeryellow' => { 393 => 'GrayMixerYellow' },
	'graypoint' => { 378 => 0x8021 },
	'grayresponseunit' => { 104 => 0x122 },
	'greencurvelimits' => { 95 => 0x1c4 },
	'greencurvepoints' => { 94 => 0x53, 95 => 0x19a },
	'greenhsl' => { 90 => 0x20912 },
	'greenhue' => { 393 => 'GreenHue' },
	'greensaturation' => { 393 => 'GreenSaturation' },
	'griddisplay' => { 234 => '13.3', 235 => '4.3', 237 => '2.2', 240 => '10.5', 241 => '3.4', 242 => '6.1', 244 => '4.4', 245 => '4.2' },
	'gripbatteryadload' => { 279 => 0x5 },
	'gripbatteryadnoload' => { 279 => 0x4 },
	'gripbatterystate' => { 279 => '1.2' },
	'groupareaafillumination' => { 235 => '46.4', 244 => '47.4' },
	'halftonehints' => { 104 => 0x141 },
	'hardlink' => { 105 => 'HardLink' },
	'hasalternative' => { 408 => 'hasAlternative' },
	'hascorrection' => { 408 => 'hasCorrection' },
	'hascorrectiona-lang' => { 408 => [\'hasCorrection','hasCorrectionA-lang'] },
	'hascorrectiona-platform' => { 408 => [\'hasCorrection','hasCorrectionA-platform'] },
	'hascorrectiontext' => { 408 => [\'hasCorrection','hasCorrectionText'] },
	'hascrop' => { 393 => 'HasCrop' },
	'hasextendedxmp' => { 420 => 'HasExtendedXMP' },
	'hassettings' => { 393 => 'HasSettings' },
	'hastranslation' => { 408 => 'hasTranslation' },
	'hdr' => { 51 => 0x1, 184 => 0x4, 267 => 0x9e, 300 => 0x85, 350 => 0x200a },
	'hdreffect' => { 51 => 0x2 },
	'hdrimagetype' => { 1 => 0xa },
	'hdrinfoversion' => { 184 => 0x0 },
	'hdrlevel' => { 184 => 0x5, 340 => 0x2e, 354 => 0x17 },
	'hdrlevel2' => { 184 => 0x7 },
	'hdrsetting' => { 340 => 0x2d, 354 => 0x16, 357 => 0x1148, 358 => 0x1148, 359 => 0x1124, 360 => 0x11a0, 361 => 0x117c, 362 => 0x1034, 363 => 0x22c, 364 => 0x22c },
	'hdrsmoothing' => { 184 => 0x6 },
	'headline' => { 112 => 0x69, 405 => 'Headline' },
	'hierarchicalkeywords' => { 149 => [\'Keywords','KeywordsHierarchy'] },
	'hierarchicalkeywords1' => { 149 => [\'Keywords','KeywordsHierarchyKeyword'] },
	'hierarchicalkeywords1applied' => { 149 => [\'Keywords','KeywordsHierarchyApplied'] },
	'hierarchicalkeywords1children' => { 149 => [\'Keywords','KeywordsHierarchyChildren'] },
	'hierarchicalkeywords2' => { 149 => [\'Keywords','KeywordsHierarchyChildrenKeyword'] },
	'hierarchicalkeywords2applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenApplied'] },
	'hierarchicalkeywords2children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildren'] },
	'hierarchicalkeywords3' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenKeyword'] },
	'hierarchicalkeywords3applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenApplied'] },
	'hierarchicalkeywords3children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildren'] },
	'hierarchicalkeywords4' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords4applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords4children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords5' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords5applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalkeywords5children' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildren'] },
	'hierarchicalkeywords6' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenKeyword'] },
	'hierarchicalkeywords6applied' => { 149 => [\'Keywords','KeywordsHierarchyChildrenChildrenChildrenChildrenChildrenApplied'] },
	'hierarchicalsubject' => { 384 => 'hierarchicalSubject' },
	'highestbiostratigraphiczone' => { 103 => [\'GeologicalContext','GeologicalContextHighestBiostratigraphicZone'] },
	'highisomultiplierblue' => { 271 => 0x1a },
	'highisomultipliergreen' => { 271 => 0x19 },
	'highisomultiplierred' => { 271 => 0x18 },
	'highisonoisereduction' => { 15 => 0xbc, 16 => 0xbd, 19 => 0xbd, 26 => 0xc9, 53 => 0x5, 72 => 0x202, 109 => 0x100e, 191 => 0xb1, 300 => 0x71, 338 => 0x2c, 339 => 0x26, 340 => 0x26, 350 => 0x2009, 354 => 0x12, 374 => 0x42 },
	'highisonoisereduction2' => { 350 => 0xb050 },
	'highlight' => { 331 => 0xf },
	'highlightadj' => { 90 => 0x2030c },
	'highlightcolordistortreduct' => { 378 => 0x8026 },
	'highlightprotection' => { 226 => 0x6 },
	'highlightrecovery' => { 393 => 'HighlightRecovery' },
	'highlights' => { 386 => 'Highlights' },
	'highlights2012' => { 393 => 'Highlights2012' },
	'highlighttone' => { 109 => 0x1041 },
	'highlighttonepriority' => { 12 => 0x7, 15 => 0x7, 16 => 0x7, 17 => 0x7, 19 => 0x7, 21 => 0x7, 26 => 0x7, 53 => 0x3, 72 => 0x203 },
	'highlowkeyadj' => { 300 => 0x6c },
	'highspeedsync' => { 159 => 0x5, 338 => 0x2, 339 => 0x2 },
	'histogramxml' => { 227 => 0x83a1a25 },
	'history' => { 405 => 'History', 419 => 'History' },
	'historyaction' => { 419 => [\'History','HistoryAction'] },
	'historychanged' => { 419 => [\'History','HistoryChanged'] },
	'historyinstanceid' => { 419 => [\'History','HistoryInstanceID'] },
	'historyparameters' => { 419 => [\'History','HistoryParameters'] },
	'historysoftwareagent' => { 419 => [\'History','HistorySoftwareAgent'] },
	'historywhen' => { 419 => [\'History','HistoryWhen'] },
	'hometowncity' => { 100 => 0x3006, 300 => 0x23, 305 => 0x2 },
	'hometowncitycode' => { 306 => 0x1000 },
	'hometowndst' => { 300 => 0x25, 305 => '0.2' },
	'hostcomputer' => { 104 => 0x13c },
	'hue' => { 164 => 0x3b, 300 => 0x67 },
	'hueadj' => { 230 => 0x2f, 378 => 0x8019 },
	'hueadjust' => { 322 => 0x1016 },
	'hueadjustment' => { 157 => 0x4a, 158 => 0x40, 191 => 0x92, 193 => 0x36 },
	'hueadjustmentaqua' => { 393 => 'HueAdjustmentAqua' },
	'hueadjustmentblue' => { 393 => 'HueAdjustmentBlue' },
	'hueadjustmentgreen' => { 393 => 'HueAdjustmentGreen' },
	'hueadjustmentmagenta' => { 393 => 'HueAdjustmentMagenta' },
	'hueadjustmentorange' => { 393 => 'HueAdjustmentOrange' },
	'hueadjustmentpurple' => { 393 => 'HueAdjustmentPurple' },
	'hueadjustmentred' => { 393 => 'HueAdjustmentRed' },
	'hueadjustmentyellow' => { 393 => 'HueAdjustmentYellow' },
	'huesetting' => { 255 => 0x1011 },
	'icc_profile' => { 105 => 'ICC_Profile' },
	'iccprofilename' => { 405 => 'ICCProfile' },
	'idccreativestyle' => { 378 => 0x8000 },
	'idcpreviewlength' => { 378 => 0x202 },
	'idcpreviewstart' => { 378 => 0x201 },
	'identification' => { 103 => 'Identification' },
	'identificationid' => { 103 => [\'Identification','IdentificationIdentificationID'] },
	'identificationqualifier' => { 103 => [\'Identification','IdentificationIdentificationQualifier'] },
	'identificationreferences' => { 103 => [\'Identification','IdentificationIdentificationReferences'] },
	'identificationremarks' => { 103 => [\'Identification','IdentificationIdentificationRemarks'] },
	'identificationverificationstatus' => { 103 => [\'Identification','IdentificationIdentificationVerificationStatus'] },
	'identifiedby' => { 103 => [\'Identification','IdentificationIdentifiedBy'] },
	'identifier' => { 394 => 'identifier', 416 => 'Identifier' },
	'illumination' => { 242 => '0.5' },
	'imageadjustment' => { 191 => 0x80, 217 => 0x5 },
	'imagealterationconstraints' => { 406 => 'ImageAlterationConstraints' },
	'imagearea' => { 202 => 0x10, 205 => 0x10 },
	'imageareaoffset' => { 300 => 0x38 },
	'imageauthentication' => { 191 => 0x20 },
	'imageboundary' => { 191 => 0x16 },
	'imagecount' => { 109 => 0x1438, 191 => 0xa5, 352 => 0x11b, 365 => [0x32,0x3a] },
	'imagecount2' => { 365 => [0x4c,0x58] },
	'imagecount3' => { 365 => [0x1a0,0x1aa,0x1bd,0x1cb] },
	'imagecreator' => { 406 => 'ImageCreator' },
	'imagecreatorid' => { 406 => [\'ImageCreator','ImageCreatorImageCreatorID'] },
	'imagecreatorimageid' => { 406 => 'ImageCreatorImageID' },
	'imagecreatorname' => { 406 => [\'ImageCreator','ImageCreatorImageCreatorName'] },
	'imagedatasize' => { 191 => 0xa2 },
	'imagedescription' => { 104 => 0x10e, 414 => 'ImageDescription' },
	'imageduplicationconstraints' => { 406 => 'ImageDuplicationConstraints' },
	'imagedustoff' => { 227 => 0xfe443a45 },
	'imageeditcount' => { 300 => 0x41 },
	'imageediting' => { 300 => 0x32 },
	'imageeffects' => { 322 => 0x1010 },
	'imagefileconstraints' => { 406 => 'ImageFileConstraints' },
	'imagefileformatasdelivered' => { 406 => 'ImageFileFormatAsDelivered' },
	'imagefilesizeasdelivered' => { 406 => 'ImageFileSizeAsDelivered' },
	'imagegeneration' => { 109 => 0x1436 },
	'imageheight' => { 104 => 0x101, 163 => 0xc, 414 => 'ImageLength' },
	'imagehistory' => { 104 => 0x9213 },
	'imageidnumber' => { 263 => 0x340 },
	'imagenumber' => { 104 => 0x9211, 134 => 'ImageNumber', 157 => 0xae, 158 => 0x5e, 338 => 0x9b, 340 => [0x400,'276.1',0x314], 389 => 'ImageNumber' },
	'imagenumber2' => { 158 => 0x62 },
	'imageoptimization' => { 191 => 0xa9 },
	'imageorientation' => { 112 => 0x83 },
	'imageprocessing' => { 191 => 0x1a },
	'imageprocessingversion' => { 251 => 0x0 },
	'imagequality' => { 134 => 'ImageQuality', 204 => '723.2', 205 => '732.2', 213 => '708.1', 267 => 0x1 },
	'imagequality2' => { 247 => 0x603 },
	'imageref' => { 401 => 'ImageRef' },
	'imagereview' => { 236 => '0.4', 242 => '0.4' },
	'imagereviewmonitorofftime' => { 235 => '21.1', 244 => '21.1' },
	'imagereviewtime' => { 234 => '25.1', 236 => '2.1', 237 => '19.1', 238 => '20.1', 239 => '20.1', 240 => '9.2', 241 => '20.1', 245 => '21.2' },
	'imagesize' => { 140 => 'ImageSize' },
	'imagesizerestriction' => { 411 => 'imageSizeRestriction' },
	'imagesourcedata' => { 104 => 0x935c },
	'imagestabilization' => { 30 => 0x22, 100 => 0x3020, 109 => 0x1422, 134 => 'ImageStabilization', 157 => 0xbd, 158 => 0x71, 159 => 0x57, 160 => 0x0, 161 => [0x18,0x107,0x113], 162 => 0x49c2, 191 => 0xac, 247 => 0x604, 250 => 0x1600, 267 => 0x1a, 343 => 0x12, 344 => 0x11, 350 => 0xb026 },
	'imagestabilization2' => { 342 => 0xa },
	'imagestabilizationsetting' => { 162 => 0x14, 338 => 0x3d, 339 => 0x3d, 349 => 0x14 },
	'imagestyle' => { 338 => 0x2d, 339 => 0x27 },
	'imagesupplier' => { 406 => 'ImageSupplier' },
	'imagesupplierid' => { 406 => [\'ImageSupplier','ImageSupplierImageSupplierID'] },
	'imagesupplierimageid' => { 406 => 'ImageSupplierImageID' },
	'imagesuppliername' => { 406 => [\'ImageSupplier','ImageSupplierImageSupplierName'] },
	'imagetemperaturemax' => { 106 => 0x1 },
	'imagetemperaturemin' => { 106 => 0x2 },
	'imagetone' => { 300 => 0x4f },
	'imagetype' => { 112 => 0x82, 406 => 'ImageType' },
	'imageuniqueid' => { 54 => 0x28, 104 => 0xa420, 397 => 'ImageUniqueID' },
	'imagewidth' => { 104 => 0x100, 163 => 0xe, 414 => 'ImageWidth' },
	'incrementaltemperature' => { 393 => 'IncrementalTemperature' },
	'incrementaltint' => { 393 => 'IncrementalTint' },
	'industry' => { 408 => 'industry', 409 => 'industry' },
	'infobuttonwhenshooting' => { 72 => 0x409 },
	'infraredilluminator' => { 318 => 0x28 },
	'ingredientexclusion' => { 410 => 'ingredientExclusion' },
	'ingredients' => { 419 => 'Ingredients' },
	'ingredientsalternatepaths' => { 419 => [\'Ingredients','IngredientsAlternatePaths'] },
	'ingredientsdocumentid' => { 419 => [\'Ingredients','IngredientsDocumentID'] },
	'ingredientsfilepath' => { 419 => [\'Ingredients','IngredientsFilePath'] },
	'ingredientsfrompart' => { 419 => [\'Ingredients','IngredientsFromPart'] },
	'ingredientsinstanceid' => { 419 => [\'Ingredients','IngredientsInstanceID'] },
	'ingredientslastmodifydate' => { 419 => [\'Ingredients','IngredientsLastModifyDate'] },
	'ingredientsmanager' => { 419 => [\'Ingredients','IngredientsManager'] },
	'ingredientsmanagervariant' => { 419 => [\'Ingredients','IngredientsManagerVariant'] },
	'ingredientsmanageto' => { 419 => [\'Ingredients','IngredientsManageTo'] },
	'ingredientsmanageui' => { 419 => [\'Ingredients','IngredientsManageUI'] },
	'ingredientsmaskmarkers' => { 419 => [\'Ingredients','IngredientsMaskMarkers'] },
	'ingredientsoriginaldocumentid' => { 419 => [\'Ingredients','IngredientsOriginalDocumentID'] },
	'ingredientspartmapping' => { 419 => [\'Ingredients','IngredientsPartMapping'] },
	'ingredientsrenditionclass' => { 419 => [\'Ingredients','IngredientsRenditionClass'] },
	'ingredientsrenditionparams' => { 419 => [\'Ingredients','IngredientsRenditionParams'] },
	'ingredientstopart' => { 419 => [\'Ingredients','IngredientsToPart'] },
	'ingredientsversionid' => { 419 => [\'Ingredients','IngredientsVersionID'] },
	'initialhorizontalfovdegrees' => { 382 => 'InitialHorizontalFOVDegrees' },
	'initialviewheadingdegrees' => { 382 => 'InitialViewHeadingDegrees' },
	'initialviewpitchdegrees' => { 382 => 'InitialViewPitchDegrees' },
	'initialviewrolldegrees' => { 382 => 'InitialViewRollDegrees' },
	'initialzoomliveview' => { 234 => '4.4' },
	'initialzoomsetting' => { 234 => '9.3', 240 => '27.3' },
	'inkset' => { 104 => 0x14c },
	'inputprofile' => { 118 => 0x1389 },
	'instanceid' => { 419 => 'InstanceID' },
	'instantplaybacksetup' => { 159 => 0x3e },
	'instantplaybacktime' => { 159 => 0x3d },
	'instructions' => { 405 => 'Instructions' },
	'instrument' => { 418 => 'instrument' },
	'intellectualgenre' => { 402 => 'IntellectualGenre' },
	'intelligentauto' => { 350 => 0xb052 },
	'intelligentcontrast' => { 43 => 0x4 },
	'intelligentd-range' => { 267 => 0x79 },
	'intelligentexposure' => { 267 => 0x5d },
	'intelligentresolution' => { 267 => 0x70 },
	'interchangecolorspace' => { 114 => 0x40 },
	'internalflash' => { 156 => 0x2b, 234 => '23.1', 236 => '8.1', 237 => '22.1', 239 => '23.1', 242 => '8.1', 245 => '24.1', 250 => 0x1208 },
	'internalflashae1' => { 252 => 0x1021 },
	'internalflashae1_0' => { 252 => 0x101d },
	'internalflashae2' => { 252 => 0x1022 },
	'internalflashae2_0' => { 252 => 0x101e },
	'internalflashmode' => { 288 => 0x1 },
	'internalflashstrength' => { 288 => 0x3 },
	'internalflashtable' => { 252 => 0x1024 },
	'internallensserialnumber' => { 328 => 0xa005 },
	'internalndfilter' => { 267 => 0x9d },
	'internalserialnumber' => { 54 => 0x96, 65 => 0x9, 109 => 0x10, 162 => 0x49dc, 246 => 0x18, 248 => 0x102, 267 => 0x25, 280 => 0x4, 322 => 0x5, 365 => [0x7c,0xf0] },
	'interopindex' => { 104 => 0x1, 398 => 'InteroperabilityIndex' },
	'interopversion' => { 104 => 0x2 },
	'intervallength' => { 156 => 0x10 },
	'intervalmode' => { 156 => 0x26 },
	'intervalnumber' => { 156 => 0x11 },
	'introtime' => { 418 => 'introTime' },
	'introtimescale' => { 418 => [\'introTime','introTimeScale'] },
	'introtimevalue' => { 418 => [\'introTime','introTimeValue'] },
	'iptc' => { 105 => 'IPTC' },
	'iptc-naa' => { 104 => 0x83bb, 271 => 0x83bb },
	'iptcbitspersample' => { 114 => 0x56 },
	'iptcdigest' => { 311 => 0x425 },
	'iptcimageheight' => { 114 => 0x1e },
	'iptcimagerotation' => { 114 => 0x66 },
	'iptcimagewidth' => { 114 => 0x14 },
	'iptclastedited' => { 403 => 'IptcLastEdited' },
	'iptcpicturenumber' => { 114 => 0xa },
	'iptcpixelheight' => { 114 => 0x32 },
	'iptcpixelwidth' => { 114 => 0x28 },
	'isalternativeof' => { 408 => 'isAlternativeOf' },
	'isbn' => { 408 => 'isbn' },
	'iscorrectionof' => { 408 => 'isCorrectionOf' },
	'iscustompicturestyle' => { 96 => 0x3 },
	'ismergedhdr' => { 389 => 'IsMergedHDR' },
	'ismergedpanorama' => { 389 => 'IsMergedPanorama' },
	'iso' => { 6 => 0x6, 8 => 0x6, 9 => 0x75, 10 => 0x6, 11 => 0x79, 12 => 0x6, 13 => 0x6, 14 => 0x6, 15 => 0x6, 16 => 0x6, 17 => 0x6, 18 => 0x6, 19 => 0x6, 20 => 0x6, 21 => 0x6, 22 => 0x6, 23 => 0x6, 24 => 0x6, 25 => 0x6, 26 => 0x6, 27 => 0x0, 28 => 0x1, 99 => 0x14, 100 => [0x3014,0x14], 104 => 0x8827, 117 => 0xfd06, 118 => 0x1784, 120 => 0x60, 122 => [0xfa2e,0xfa46], 123 => [0x27,0x28], 124 => 0xf105, 127 => 0x14, 129 => 0x4e, 132 => 0x34, 134 => 'ISO', 156 => 0x8, 162 => 0x49ba, 185 => 0x0, 191 => 0x2, 271 => 0x17, 300 => [0x8b,0x14], 306 => 0x14, 328 => 0xa014, 349 => 0x6f, 354 => [0x1f,0x21,0x25], 397 => 'ISOSpeedRatings' },
	'iso2' => { 185 => 0x6, 199 => 0x265, 200 => 0x25c, 201 => 0x265, 202 => 0x221, 203 => 0x25d, 204 => 0x256, 205 => 0x25d, 208 => 0x2b5, 211 => 0x265, 216 => 0x2b5 },
	'isoauto' => { 281 => '14.4' },
	'isoautoparameters' => { 300 => 0x7a },
	'isodisplay' => { 237 => '2.3', 238 => '3.3', 239 => '3.3', 241 => '3.3', 244 => '4.3', 245 => '4.3' },
	'isoexpansion' => { 72 => 0x103, 73 => 0x7, 74 => 0x8, 77 => 0x8, 185 => 0x4 },
	'isoexpansion2' => { 185 => 0xa },
	'isofloor' => { 281 => 0x6 },
	'isoselection' => { 191 => 0xf },
	'isosensitivitystep' => { 241 => '6.2' },
	'isosetting' => { 120 => 0x5e, 134 => 'ISOSetting', 156 => 0x24, 157 => 0x26, 158 => 0x1c, 159 => 0x13, 164 => 0x6, 191 => 0x13, 281 => '17.3', 321 => 0x27, 338 => 0x16, 339 => 0x14, 340 => 0x2, 349 => 0x6d },
	'isospeed' => { 104 => 0x8833, 398 => 'ISOSpeed' },
	'isospeedexpansion' => { 71 => 0x3 },
	'isospeedincrements' => { 72 => 0x102 },
	'isospeedlatitudeyyy' => { 104 => 0x8834, 398 => 'ISOSpeedLatitudeyyy' },
	'isospeedlatitudezzz' => { 104 => 0x8835, 398 => 'ISOSpeedLatitudezzz' },
	'isospeedrange' => { 72 => 0x103 },
	'isostepsize' => { 234 => '6.1', 235 => '7.2', 240 => '4.1', 244 => '7.2' },
	'isovalue' => { 252 => 0x1001 },
	'issn' => { 408 => 'issn' },
	'issueidentifier' => { 408 => 'issueIdentifier' },
	'issuename' => { 408 => 'issueName' },
	'issueteaser' => { 408 => 'issueTeaser' },
	'issuetype' => { 408 => 'issueType' },
	'istranslationof' => { 408 => 'isTranslationOf' },
	'jobid' => { 112 => 0xb8 },
	'jobname' => { 399 => 'JobName' },
	'jobref' => { 417 => 'JobRef' },
	'jobrefid' => { 417 => [\'JobRef','JobRefId'] },
	'jobrefname' => { 417 => [\'JobRef','JobRefName'] },
	'jobrefurl' => { 417 => [\'JobRef','JobRefUrl'] },
	'jobstatus' => { 399 => 'JobStatus' },
	'jpegquality' => { 9 => 0x66, 269 => 0x3034, 350 => 0xb047 },
	'jpegsize' => { 269 => 0x303a },
	'jpgfromraw' => { 85 => 0x2007, 101 => 'JpgFromRaw', 271 => 0x2e },
	'jpgfromrawlength' => { 104 => [0x117,0x202] },
	'jpgfromrawstart' => { 104 => [0x111,0x201] },
	'jpgrecordedpixels' => { 281 => '14.1' },
	'jurisdiction' => { 390 => 'jurisdiction' },
	'kelvinwb_01' => { 289 => 0x5 },
	'kelvinwb_02' => { 289 => 0x9 },
	'kelvinwb_03' => { 289 => 0xd },
	'kelvinwb_04' => { 289 => 0x11 },
	'kelvinwb_05' => { 289 => 0x15 },
	'kelvinwb_06' => { 289 => 0x19 },
	'kelvinwb_07' => { 289 => 0x1d },
	'kelvinwb_08' => { 289 => 0x21 },
	'kelvinwb_09' => { 289 => 0x25 },
	'kelvinwb_10' => { 289 => 0x29 },
	'kelvinwb_11' => { 289 => 0x2d },
	'kelvinwb_12' => { 289 => 0x31 },
	'kelvinwb_13' => { 289 => 0x35 },
	'kelvinwb_14' => { 289 => 0x39 },
	'kelvinwb_15' => { 289 => 0x3d },
	'kelvinwb_16' => { 289 => 0x41 },
	'kelvinwb_daylight' => { 289 => 0x1 },
	'key' => { 418 => 'key' },
	'keyword' => { 408 => 'keyword' },
	'keywordinfo' => { 149 => 'Keywords' },
	'keywords' => { 112 => 0x19, 135 => 'Keywords', 256 => 'Keywords', 313 => 'Keywords', 387 => 'keywords', 404 => 'Keywords', 416 => 'Keywords' },
	'killdate' => { 408 => 'killDate' },
	'killdatea-platform' => { 408 => [\'killDate','killDateA-platform'] },
	'killdatedate' => { 408 => [\'killDate','killDateDate'] },
	'kodakimageheight' => { 117 => 0xf908, 120 => 0xe, 122 => [0xfa1e,0xfa52], 128 => 0x70 },
	'kodakimagewidth' => { 117 => 0xf907, 120 => 0xc, 122 => [0xfa1d,0xfa51], 128 => 0x6c },
	'kodakinfotype' => { 117 => 0xfa00 },
	'kodaklook' => { 118 => 0xe4c },
	'kodaklookprofile' => { 118 => 0x138a },
	'kodakmaker' => { 128 => 0x8 },
	'kodakmodel' => { 120 => 0x0, 128 => 0x28 },
	'label' => { 259 => 'Label', 416 => 'Label' },
	'labelname1' => { 401 => [\'TagStructure','TagStructureLabelName'] },
	'labelname2' => { 401 => [\'TagStructure','TagStructureSubLabelsLabelName'] },
	'labelname3' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsLabelName'] },
	'labelname4' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname5' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'labelname6' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsLabelName'] },
	'landmark' => { 267 => 0x6f },
	'landscapeoutputhighlightpoint' => { 96 => 0x26 },
	'landscapeoutputshadowpoint' => { 96 => 0x27 },
	'landscaperawcolortone' => { 96 => 0x1f },
	'landscaperawcontrast' => { 96 => 0x21 },
	'landscaperawhighlight' => { 96 => 0x77 },
	'landscaperawhighlightpoint' => { 96 => 0x24 },
	'landscaperawlinear' => { 96 => 0x22 },
	'landscaperawsaturation' => { 96 => 0x20 },
	'landscaperawshadow' => { 96 => 0x80 },
	'landscaperawshadowpoint' => { 96 => 0x25 },
	'landscaperawsharpness' => { 96 => 0x23 },
	'landscapeunsharpmaskfineness' => { 96 => 0xa0 },
	'landscapeunsharpmaskstrength' => { 96 => 0x9e },
	'landscapeunsharpmaskthreshold' => { 96 => 0xa2 },
	'language' => { 394 => 'language' },
	'languageidentifier' => { 112 => 0x87 },
	'largestvalidinteriorrectheight' => { 382 => 'LargestValidInteriorRectHeight' },
	'largestvalidinteriorrectleft' => { 382 => 'LargestValidInteriorRectLeft' },
	'largestvalidinteriorrecttop' => { 382 => 'LargestValidInteriorRectTop' },
	'largestvalidinteriorrectwidth' => { 382 => 'LargestValidInteriorRectWidth' },
	'lastfilenumber' => { 156 => 0x1b },
	'lastkeywordiptc' => { 154 => 'LastKeywordIPTC' },
	'lastkeywordxmp' => { 154 => 'LastKeywordXMP' },
	'lastphotodate' => { 382 => 'LastPhotoDate' },
	'lasturl' => { 419 => 'LastURL' },
	'lateralchromaticaberration' => { 350 => 0x2012 },
	'lateralchromaticaberrationcorrectionalreadyapplied' => { 389 => 'LateralChromaticAberrationCorrectionAlreadyApplied' },
	'latestageorhigheststage' => { 103 => [\'GeologicalContext','GeologicalContextLatestAgeOrHighestStage'] },
	'latesteonorhighesteonothem' => { 103 => [\'GeologicalContext','GeologicalContextLatestEonOrHighestEonothem'] },
	'latestepochorhighestseries' => { 103 => [\'GeologicalContext','GeologicalContextLatestEpochOrHighestSeries'] },
	'latesteraorhighesterathem' => { 103 => [\'GeologicalContext','GeologicalContextLatestEraOrHighestErathem'] },
	'latestperiodorhighestsystem' => { 103 => [\'GeologicalContext','GeologicalContextLatestPeriodOrHighestSystem'] },
	'lc1' => { 291 => 0x2 },
	'lc10' => { 291 => 0xb },
	'lc11' => { 291 => 0xc },
	'lc12' => { 291 => 0xd },
	'lc14' => { 291 => 0xf },
	'lc15' => { 291 => 0x10 },
	'lc3' => { 291 => 0x4 },
	'lc4' => { 291 => 0x5 },
	'lc5' => { 291 => 0x6 },
	'lc6' => { 291 => 0x7 },
	'lc7' => { 291 => 0x8 },
	'lcddisplayatpoweron' => { 72 => 0x811, 76 => 0xa },
	'lcddisplayreturntoshoot' => { 77 => 0x12 },
	'lcdillumination' => { 234 => '17.5', 235 => '5.2', 240 => '10.3', 241 => '4.2', 244 => '5.2', 245 => '5.4' },
	'lcdilluminationduringbulb' => { 72 => 0x408 },
	'lcdpanels' => { 71 => 0x8 },
	'lcheditor' => { 227 => 0x8ae85e },
	'legacyiptcdigest' => { 405 => 'LegacyIPTCDigest' },
	'legalcode' => { 390 => 'legalcode' },
	'lens' => { 104 => 0xfdea, 191 => 0x84, 389 => 'Lens' },
	'lensafstopbutton' => { 70 => 0x11, 71 => 0x13, 72 => 0x506, 73 => 0x10, 74 => 0x12, 77 => 0x13, 78 => 0x9 },
	'lensaperturerange' => { 331 => [0x30,0x48] },
	'lensdistortionparams' => { 252 => 0x206 },
	'lensdrivenoaf' => { 72 => 0x505 },
	'lensfirmware' => { 323 => 0x20, 328 => 0xa004 },
	'lensfirmwareversion' => { 248 => 0x204, 267 => 0x60 },
	'lensfocallength' => { 90 => 0xf0512 },
	'lensfocalrange' => { 331 => [0xa,0x2a] },
	'lensfocusfunctionbuttons' => { 235 => '55.1', 244 => '52.1' },
	'lensformat' => { 361 => 0x1891, 363 => 0x18bd, 364 => 0x18ed, 365 => 0x106, 373 => 0x603, 374 => 0x5d },
	'lensfstops' => { 186 => 0x7, 187 => 0xc, 188 => 0xd, 191 => 0x8b, 291 => '0.3' },
	'lensid' => { 389 => 'LensID' },
	'lensidnumber' => { 186 => 0x6, 187 => 0xb, 188 => 0xc },
	'lensinfo' => { 104 => 0xa432, 297 => 0x2a, 389 => 'LensInfo', 398 => 'LensSpecification' },
	'lenskind' => { 291 => 0x1 },
	'lensmake' => { 104 => 0xa433, 141 => 'Make', 398 => 'LensMake' },
	'lensmanualdistortionamount' => { 393 => 'LensManualDistortionAmount' },
	'lensmanufacturer' => { 154 => 'LensManufacturer' },
	'lensmaxaperturerange' => { 331 => 0x2b },
	'lensmodel' => { 6 => 0x937, 13 => 0x92b, 14 => 0x933, 54 => 0x95, 104 => 0xa434, 141 => 'Model', 154 => 'LensModel', 189 => 0x18a, 248 => 0x203, 265 => 0x303, 297 => 0xc, 398 => 'LensModel' },
	'lensmount' => { 340 => 0x99, 361 => 0x1892, 363 => 0x18be, 364 => 0x18ee, 365 => 0x105, 373 => 0x604, 374 => 0x5e, 377 => 0x8 },
	'lensparameters' => { 358 => 0x1a23, 361 => 0x1870, 363 => 0x189c, 364 => 0x18cc, 373 => 0x6ca, 374 => 0x64 },
	'lensprofilechromaticaberrationscale' => { 393 => 'LensProfileChromaticAberrationScale' },
	'lensprofiledigest' => { 393 => 'LensProfileDigest' },
	'lensprofiledistortionscale' => { 393 => 'LensProfileDistortionScale' },
	'lensprofileenable' => { 393 => 'LensProfileEnable' },
	'lensprofilefilename' => { 393 => 'LensProfileFilename' },
	'lensprofilematchkeycameramodelname' => { 393 => 'LensProfileMatchKeyCameraModelName' },
	'lensprofilematchkeyexifmake' => { 393 => 'LensProfileMatchKeyExifMake' },
	'lensprofilematchkeyexifmodel' => { 393 => 'LensProfileMatchKeyExifModel' },
	'lensprofilematchkeyisraw' => { 393 => 'LensProfileMatchKeyIsRaw' },
	'lensprofilematchkeylensid' => { 393 => 'LensProfileMatchKeyLensID' },
	'lensprofilematchkeylensinfo' => { 393 => 'LensProfileMatchKeyLensInfo' },
	'lensprofilematchkeylensname' => { 393 => 'LensProfileMatchKeyLensName' },
	'lensprofilematchkeysensorformatfactor' => { 393 => 'LensProfileMatchKeySensorFormatFactor' },
	'lensprofilename' => { 393 => 'LensProfileName' },
	'lensprofilesetup' => { 393 => 'LensProfileSetup' },
	'lensprofilevignettingscale' => { 393 => 'LensProfileVignettingScale' },
	'lensproperties' => { 248 => 0x20b },
	'lensserialnumber' => { 52 => 0x0, 104 => 0xa435, 141 => 'SerialNumber', 248 => 0x202, 267 => 0x52, 323 => 0x30, 389 => 'LensSerialNumber', 398 => 'LensSerialNumber' },
	'lensshutterlock' => { 159 => 0x4a },
	'lensspec' => { 335 => 0x0, 336 => 0x0, 337 => 0x0, 350 => 0xb02a },
	'lensspecfeatures' => { 365 => [0x115,0x116] },
	'lenstemperature' => { 252 => 0x1008 },
	'lenstype' => { 6 => 0xe2, 7 => 0xd, 8 => 0x1a7, 9 => 0xc, 10 => 0x111, 11 => 0xc, 12 => 0x14f, 13 => 0xd6, 14 => 0xde, 15 => 0xf6, 16 => 0xea, 17 => 0xff, 18 => [0xc,0x97], 19 => 0xe6, 20 => 0x153, 21 => 0xea, 22 => 0xe8, 23 => 0x127, 24 => 0x161, 25 => 0x166, 26 => 0x112, 30 => 0x16, 161 => 0x10c, 162 => 0x49bd, 191 => 0x83, 248 => 0x201, 260 => 0x16, 263 => 0x310, 266 => 0x303, 267 => 0x51, 269 => 0x3405, 292 => 0x0, 293 => 0x0, 294 => 0x1, 295 => 0x1, 296 => 0x1, 298 => 0x0, 328 => 0xa003, 331 => 0x27, 350 => 0xb027, 361 => 0x1896, 363 => 0x18c2, 364 => 0x18f2, 365 => 0x109, 373 => 0x608, 374 => 0x62 },
	'lenstype2' => { 340 => 0x3f7, 361 => 0x1893, 363 => 0x18bf, 364 => 0x18ef, 365 => 0x107, 373 => 0x605, 374 => 0x60, 377 => 0x9 },
	'lenszoomposition' => { 371 => 0x19, 372 => 0x1e, 374 => 0x342 },
	'levelindicator' => { 274 => 0x15 },
	'levelorientation' => { 299 => 0x0 },
	'license' => { 390 => 'license' },
	'licensee' => { 406 => 'Licensee' },
	'licenseeid' => { 406 => [\'Licensee','LicenseeLicenseeID'] },
	'licenseeimageid' => { 406 => 'LicenseeImageID' },
	'licenseeimagenotes' => { 406 => 'LicenseeImageNotes' },
	'licenseename' => { 406 => [\'Licensee','LicenseeLicenseeName'] },
	'licenseenddate' => { 406 => 'LicenseEndDate' },
	'licenseeprojectreference' => { 406 => 'LicenseeProjectReference' },
	'licenseetransactionid' => { 406 => 'LicenseeTransactionID' },
	'licenseid' => { 406 => 'LicenseID' },
	'licensestartdate' => { 406 => 'LicenseStartDate' },
	'licensetransactiondate' => { 406 => 'LicenseTransactionDate' },
	'licensetype' => { 395 => 'licensetype' },
	'licensor' => { 406 => 'Licensor' },
	'licensorcity' => { 406 => [\'Licensor','LicensorLicensorCity'] },
	'licensorcountry' => { 406 => [\'Licensor','LicensorLicensorCountry'] },
	'licensoremail' => { 406 => [\'Licensor','LicensorLicensorEmail'] },
	'licensorextendedaddress' => { 406 => [\'Licensor','LicensorLicensorExtendedAddress'] },
	'licensorid' => { 406 => [\'Licensor','LicensorLicensorID'] },
	'licensorimageid' => { 406 => 'LicensorImageID' },
	'licensorname' => { 406 => [\'Licensor','LicensorLicensorName'] },
	'licensornotes' => { 406 => 'LicensorNotes' },
	'licensorpostalcode' => { 406 => [\'Licensor','LicensorLicensorPostalCode'] },
	'licensorregion' => { 406 => [\'Licensor','LicensorLicensorRegion'] },
	'licensorstreetaddress' => { 406 => [\'Licensor','LicensorLicensorStreetAddress'] },
	'licensortelephone1' => { 406 => [\'Licensor','LicensorLicensorTelephone1'] },
	'licensortelephone2' => { 406 => [\'Licensor','LicensorLicensorTelephone2'] },
	'licensortelephonetype1' => { 406 => [\'Licensor','LicensorLicensorTelephoneType1'] },
	'licensortelephonetype2' => { 406 => [\'Licensor','LicensorLicensorTelephoneType2'] },
	'licensortransactionid' => { 406 => 'LicensorTransactionID' },
	'licensorurl' => { 406 => [\'Licensor','LicensorLicensorURL'] },
	'lightcondition' => { 252 => 0x1009 },
	'lightingmode' => { 100 => 0x302a },
	'lightreading' => { 300 => 0x15 },
	'lightsource' => { 104 => 0x9208, 191 => 0x90, 255 => 0x1000, 397 => 'LightSource' },
	'lightsourcespecial' => { 330 => 0x21d },
	'lightswitch' => { 244 => '0.1', 245 => '0.1' },
	'lightvaluecenter' => { 252 => 0x103d },
	'lightvalueperiphery' => { 252 => 0x103e },
	'limitafareamodeselection' => { 235 => '51.1', 244 => '49.1' },
	'linearitylimitblue' => { 271 => 0x10 },
	'linearitylimitgreen' => { 271 => 0xf },
	'linearitylimitred' => { 271 => 0xe },
	'linearityuppermargin' => { 37 => [0x2ba,0x2d1,0x2d5], 39 => 0x1e5, 40 => [0x1fe,0x2de], 41 => 0x310 },
	'linearizationtable' => { 104 => 0xc618 },
	'linearresponselimit' => { 104 => 0xc62e },
	'link' => { 408 => 'link' },
	'linkaetoafpoint' => { 281 => '14.2' },
	'linkedencodedrightsexpr' => { 403 => [\'LinkedEncRightsExpr','LinkedEncRightsExprLinkedRightsExpr'] },
	'linkedencodedrightsexprlangid' => { 403 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprLangId'] },
	'linkedencodedrightsexprtype' => { 403 => [\'LinkedEncRightsExpr','LinkedEncRightsExprRightsExprEncType'] },
	'linkedencrightsexpr' => { 403 => 'LinkedEncRightsExpr' },
	'lithostratigraphicterms' => { 103 => [\'GeologicalContext','GeologicalContextLithostratigraphicTerms'] },
	'liveviewaf' => { 237 => '32.1', 245 => '34.1' },
	'liveviewafareamode' => { 241 => '34.1' },
	'liveviewafmethod' => { 354 => 0x20 },
	'liveviewafmode' => { 241 => '34.2' },
	'liveviewafsetting' => { 340 => 0x36 },
	'liveviewbuttonoptions' => { 235 => '50.2', 244 => '48.2' },
	'liveviewexposuresimulation' => { 72 => 0x810 },
	'liveviewfocusmode' => { 340 => [0x8b,0x28b] },
	'liveviewmetering' => { 340 => [0x84,0x284] },
	'liveviewmonitorofftime' => { 235 => '21.2', 238 => '20.2', 239 => '20.2', 241 => '20.2', 244 => '21.2' },
	'liveviewshooting' => { 48 => 0x13 },
	'localcaption' => { 112 => 0x79 },
	'localizedcameramodel' => { 104 => 0xc615 },
	'locallocationname' => { 328 => 0x30 },
	'location' => { 190 => 0x9, 267 => 0x67, 385 => 'Location', 402 => 'Location', 407 => 'location', 408 => 'location' },
	'locationareacode' => { 391 => 'lac' },
	'locationcreated' => { 403 => 'LocationCreated' },
	'locationcreatedcity' => { 403 => [\'LocationCreated','LocationCreatedCity'] },
	'locationcreatedcountrycode' => { 403 => [\'LocationCreated','LocationCreatedCountryCode'] },
	'locationcreatedcountryname' => { 403 => [\'LocationCreated','LocationCreatedCountryName'] },
	'locationcreatedlocationid' => { 403 => [\'LocationCreated','LocationCreatedLocationId'] },
	'locationcreatedprovincestate' => { 403 => [\'LocationCreated','LocationCreatedProvinceState'] },
	'locationcreatedsublocation' => { 403 => [\'LocationCreated','LocationCreatedSublocation'] },
	'locationcreatedworldregion' => { 403 => [\'LocationCreated','LocationCreatedWorldRegion'] },
	'locationinfoversion' => { 190 => 0x0 },
	'locationname' => { 328 => 0x31 },
	'locationshown' => { 403 => 'LocationShown' },
	'locationshowncity' => { 403 => [\'LocationShown','LocationShownCity'] },
	'locationshowncountrycode' => { 403 => [\'LocationShown','LocationShownCountryCode'] },
	'locationshowncountryname' => { 403 => [\'LocationShown','LocationShownCountryName'] },
	'locationshownlocationid' => { 403 => [\'LocationShown','LocationShownLocationId'] },
	'locationshownprovincestate' => { 403 => [\'LocationShown','LocationShownProvinceState'] },
	'locationshownsublocation' => { 403 => [\'LocationShown','LocationShownSublocation'] },
	'locationshownworldregion' => { 403 => [\'LocationShown','LocationShownWorldRegion'] },
	'lockmicrophonebutton' => { 72 => 0x709 },
	'logcomment' => { 418 => 'logComment' },
	'longexposurenoisereduction' => { 53 => 0x4, 72 => 0x201, 73 => 0x1, 74 => 0x2, 75 => 0x1, 76 => 0x1, 77 => 0x2, 78 => 0x1, 267 => 0x49, 338 => 0x2b, 339 => 0x25, 340 => 0x25, 350 => 0x2008, 354 => 0x11, 374 => 0x44 },
	'longexposurenoisereduction2' => { 48 => 0x8 },
	'loop' => { 418 => 'loop' },
	'lowestbiostratigraphiczone' => { 103 => [\'GeologicalContext','GeologicalContextLowestBiostratigraphicZone'] },
	'luminanceadjustmentaqua' => { 393 => 'LuminanceAdjustmentAqua' },
	'luminanceadjustmentblue' => { 393 => 'LuminanceAdjustmentBlue' },
	'luminanceadjustmentgreen' => { 393 => 'LuminanceAdjustmentGreen' },
	'luminanceadjustmentmagenta' => { 393 => 'LuminanceAdjustmentMagenta' },
	'luminanceadjustmentorange' => { 393 => 'LuminanceAdjustmentOrange' },
	'luminanceadjustmentpurple' => { 393 => 'LuminanceAdjustmentPurple' },
	'luminanceadjustmentred' => { 393 => 'LuminanceAdjustmentRed' },
	'luminanceadjustmentyellow' => { 393 => 'LuminanceAdjustmentYellow' },
	'luminancecurvelimits' => { 95 => 0x150 },
	'luminancecurvepoints' => { 95 => 0x126 },
	'luminancenoisereduction' => { 90 => 0x20600, 96 => 0x5f, 331 => 0x1b },
	'luminancenoisereductioncontrast' => { 393 => 'LuminanceNoiseReductionContrast' },
	'luminancenoisereductiondetail' => { 393 => 'LuminanceNoiseReductionDetail' },
	'luminancenr_tiff_jpeg' => { 96 => 0x6d },
	'luminancesmoothing' => { 393 => 'LuminanceSmoothing' },
	'lvshootingareadisplay' => { 72 => 0x40b },
	'lyrics' => { 418 => 'lyrics' },
	'm16cversion' => { 263 => 0x333 },
	'macatom' => { 392 => 'macAtom' },
	'macatomapplicationcode' => { 392 => [\'macAtom','macAtomApplicationCode'] },
	'macatominvocationappleevent' => { 392 => [\'macAtom','macAtomInvocationAppleEvent'] },
	'macatomposixprojectpath' => { 392 => [\'macAtom','macAtomPosixProjectPath'] },
	'macro' => { 109 => 0x1020, 110 => 0x202, 252 => 0x202, 321 => 0x21, 330 => 0x202, 350 => 0xb040 },
	'macroled' => { 250 => 0x120a },
	'macromagnification' => { 6 => 0x1b, 10 => 0x1b, 13 => 0x1b, 14 => 0x1b, 18 => 0x1b, 19 => 0x1b, 48 => 0x10 },
	'macromode' => { 30 => 0x1, 156 => 0xb, 247 => 0x300, 267 => 0x1c, 322 => 0x1009 },
	'magentahsl' => { 90 => 0x20917 },
	'magicfilter' => { 247 => 0x52c },
	'magnifiedview' => { 74 => 0x11, 76 => 0x9 },
	'maindialexposurecomp' => { 242 => '0.6' },
	'mainingredient' => { 410 => 'mainIngredient' },
	'make' => { 86 => 0x0, 104 => 0x10f, 134 => 'Make', 259 => 'Make', 271 => 0x10f, 407 => 'make', 414 => 'Make' },
	'makernote' => { 397 => 'MakerNote' },
	'makernoteapple' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecanon' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecasio' => { 102 => 'MakN', 104 => 0x927c },
	'makernotecasio2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteflir' => { 102 => 'MakN', 104 => 0x927c },
	'makernotefujifilm' => { 102 => 'MakN', 104 => 0x927c },
	'makernotege' => { 102 => 'MakN', 104 => 0x927c },
	'makernotege2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehasselblad' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotehp6' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteisl' => { 102 => 'MakN', 104 => 0x927c },
	'makernotejvc' => { 102 => 'MakN', 104 => 0x927c },
	'makernotejvctext' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak10' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak11' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak1a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak1b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak6a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak6b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak7' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak8c' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodak9' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekodakunknown' => { 102 => 'MakN', 104 => 0x927c },
	'makernotekyocera' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica3' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica4' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica5' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica6' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica7' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteleica8' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta2' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteminolta3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenikon3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotenintendo' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteoffset' => { 330 => 0xff },
	'makernoteolympus' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteolympus2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepanasonic' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepanasonic2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotepentax6' => { 102 => 'MakN', 104 => 0x927c },
	'makernotephaseone' => { 102 => 'MakN', 104 => 0x927c },
	'makernotereconyx' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericoh' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericoh2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotericohtext' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesafety' => { 104 => 0xc635 },
	'makernotesamsung1a' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesamsung1b' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesamsung2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyo' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyoc4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesanyopatch' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesigma' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony2' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony3' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony4' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesony5' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesonyericsson' => { 102 => 'MakN', 104 => 0x927c },
	'makernotesonysrf' => { 102 => 'MakN', 104 => 0x927c },
	'makernotetype' => { 322 => 0x1 },
	'makernoteunknown' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteunknownbinary' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteunknowntext' => { 102 => 'MakN', 104 => 0x927c },
	'makernoteversion' => { 161 => 0x0, 191 => 0x1, 252 => 0x0, 267 => 0x8000, 326 => 0x0, 328 => 0x1, 331 => [0x1d,0x1f], 341 => 0x2000 },
	'managedfrom' => { 419 => 'ManagedFrom' },
	'managedfromalternatepaths' => { 419 => [\'ManagedFrom','ManagedFromAlternatePaths'] },
	'managedfromdocumentid' => { 419 => [\'ManagedFrom','ManagedFromDocumentID'] },
	'managedfromfilepath' => { 419 => [\'ManagedFrom','ManagedFromFilePath'] },
	'managedfromfrompart' => { 419 => [\'ManagedFrom','ManagedFromFromPart'] },
	'managedfrominstanceid' => { 419 => [\'ManagedFrom','ManagedFromInstanceID'] },
	'managedfromlastmodifydate' => { 419 => [\'ManagedFrom','ManagedFromLastModifyDate'] },
	'managedfrommanager' => { 419 => [\'ManagedFrom','ManagedFromManager'] },
	'managedfrommanagervariant' => { 419 => [\'ManagedFrom','ManagedFromManagerVariant'] },
	'managedfrommanageto' => { 419 => [\'ManagedFrom','ManagedFromManageTo'] },
	'managedfrommanageui' => { 419 => [\'ManagedFrom','ManagedFromManageUI'] },
	'managedfrommaskmarkers' => { 419 => [\'ManagedFrom','ManagedFromMaskMarkers'] },
	'managedfromoriginaldocumentid' => { 419 => [\'ManagedFrom','ManagedFromOriginalDocumentID'] },
	'managedfrompartmapping' => { 419 => [\'ManagedFrom','ManagedFromPartMapping'] },
	'managedfromrenditionclass' => { 419 => [\'ManagedFrom','ManagedFromRenditionClass'] },
	'managedfromrenditionparams' => { 419 => [\'ManagedFrom','ManagedFromRenditionParams'] },
	'managedfromtopart' => { 419 => [\'ManagedFrom','ManagedFromToPart'] },
	'managedfromversionid' => { 419 => [\'ManagedFrom','ManagedFromVersionID'] },
	'manager' => { 419 => 'Manager' },
	'managervariant' => { 419 => 'ManagerVariant' },
	'manageto' => { 419 => 'ManageTo' },
	'manageui' => { 419 => 'ManageUI' },
	'manifest' => { 419 => 'Manifest' },
	'manifestlinkform' => { 419 => [\'Manifest','ManifestLinkForm'] },
	'manifestplacedresolutionunit' => { 419 => [\'Manifest','ManifestPlacedResolutionUnit'] },
	'manifestplacedxresolution' => { 419 => [\'Manifest','ManifestPlacedXResolution'] },
	'manifestplacedyresolution' => { 419 => [\'Manifest','ManifestPlacedYResolution'] },
	'manifestreference' => { 419 => [\'Manifest','ManifestReference'] },
	'manifestreferencealternatepaths' => { 419 => [\'Manifest','ManifestReferenceAlternatePaths'] },
	'manifestreferencedocumentid' => { 419 => [\'Manifest','ManifestReferenceDocumentID'] },
	'manifestreferencefilepath' => { 419 => [\'Manifest','ManifestReferenceFilePath'] },
	'manifestreferencefrompart' => { 419 => [\'Manifest','ManifestReferenceFromPart'] },
	'manifestreferenceinstanceid' => { 419 => [\'Manifest','ManifestReferenceInstanceID'] },
	'manifestreferencelastmodifydate' => { 419 => [\'Manifest','ManifestReferenceLastModifyDate'] },
	'manifestreferencemanager' => { 419 => [\'Manifest','ManifestReferenceManager'] },
	'manifestreferencemanagervariant' => { 419 => [\'Manifest','ManifestReferenceManagerVariant'] },
	'manifestreferencemanageto' => { 419 => [\'Manifest','ManifestReferenceManageTo'] },
	'manifestreferencemanageui' => { 419 => [\'Manifest','ManifestReferenceManageUI'] },
	'manifestreferencemaskmarkers' => { 419 => [\'Manifest','ManifestReferenceMaskMarkers'] },
	'manifestreferenceoriginaldocumentid' => { 419 => [\'Manifest','ManifestReferenceOriginalDocumentID'] },
	'manifestreferencepartmapping' => { 419 => [\'Manifest','ManifestReferencePartMapping'] },
	'manifestreferencerenditionclass' => { 419 => [\'Manifest','ManifestReferenceRenditionClass'] },
	'manifestreferencerenditionparams' => { 419 => [\'Manifest','ManifestReferenceRenditionParams'] },
	'manifestreferencetopart' => { 419 => [\'Manifest','ManifestReferenceToPart'] },
	'manifestreferenceversionid' => { 419 => [\'Manifest','ManifestReferenceVersionID'] },
	'manometerpressure' => { 247 => 0x900, 267 => 0x86 },
	'manometerreading' => { 247 => 0x901 },
	'manualafpointselectpattern' => { 72 => 0x513 },
	'manualflash' => { 250 => 0x1209 },
	'manualflashoutput' => { 30 => 0x29, 236 => '8.2', 237 => '22.2', 238 => '23.1', 239 => '23.2', 240 => '16.2', 241 => '23.2', 242 => '8.2', 243 => '23.2', 245 => '24.2', 322 => 0x100c },
	'manualflashstrength' => { 247 => 0x406 },
	'manualfocusdistance' => { 191 => 0x85, 252 => 0x100c, 330 => 0x223 },
	'manualtv' => { 71 => 0x5, 72 => 0x705 },
	'manufacturedate' => { 280 => 0x1 },
	'manufacturedate1' => { 324 => 0x4 },
	'manufacturedate2' => { 324 => 0x5 },
	'manufacturer' => { 407 => 'manufacturer' },
	'marked' => { 404 => 'Marked', 422 => 'Marked' },
	'markers' => { 418 => 'markers' },
	'markerscomment' => { 418 => [\'markers','markersComment'] },
	'markerscuepointparams' => { 418 => [\'markers','markersCuePointParams'] },
	'markerscuepointparamskey' => { 418 => [\'markers','markersCuePointParamsKey'] },
	'markerscuepointparamsvalue' => { 418 => [\'markers','markersCuePointParamsValue'] },
	'markerscuepointtype' => { 418 => [\'markers','markersCuePointType'] },
	'markersduration' => { 418 => [\'markers','markersDuration'] },
	'markerslocation' => { 418 => [\'markers','markersLocation'] },
	'markersname' => { 418 => [\'markers','markersName'] },
	'markersprobability' => { 418 => [\'markers','markersProbability'] },
	'markersspeaker' => { 418 => [\'markers','markersSpeaker'] },
	'markersstarttime' => { 418 => [\'markers','markersStartTime'] },
	'markerstarget' => { 418 => [\'markers','markersTarget'] },
	'markerstype' => { 418 => [\'markers','markersType'] },
	'maskedareas' => { 104 => 0xc68e },
	'masterdocumentid' => { 112 => 0xb9 },
	'mastergain' => { 197 => 0x50 },
	'matrixmetering' => { 235 => '50.1', 244 => '48.1' },
	'maxaperture' => { 30 => 0x1a, 124 => 0x6103, 141 => 'MaxAperture', 156 => 0x17, 162 => 0x49c5, 248 => 0x20a, 291 => '14.1', 365 => 0x0 },
	'maxapertureatmaxfocal' => { 109 => 0x1407, 141 => 'MaxApertureAtMaxFocal', 186 => 0xb, 187 => 0x10, 188 => 0x11, 248 => 0x206 },
	'maxapertureatminfocal' => { 109 => 0x1406, 186 => 0xa, 187 => 0xf, 188 => 0x10, 248 => 0x205 },
	'maxaperturevalue' => { 104 => 0x9205, 397 => 'MaxApertureValue' },
	'maxavailheight' => { 403 => 'MaxAvailHeight' },
	'maxavailwidth' => { 403 => 'MaxAvailWidth' },
	'maxcontinuousrelease' => { 234 => 0xb, 235 => 0xc, 240 => 0xc, 241 => 0xb, 244 => '12.1' },
	'maxfaces' => { 251 => 0x1202 },
	'maxfocallength' => { 6 => 0xe6, 7 => 0x10, 8 => 0x1ab, 9 => 0x13, 10 => 0x115, 11 => 0x13, 12 => 0x153, 13 => 0xda, 15 => 0xfa, 16 => 0xee, 17 => 0x103, 18 => 0x95, 19 => 0xea, 20 => 0x157, 21 => 0xee, 22 => 0xec, 23 => 0x12b, 24 => 0x165, 25 => 0x16a, 26 => 0x116, 30 => 0x17, 109 => 0x1405, 141 => 'MaxFocalLength', 186 => 0x9, 187 => 0xe, 188 => 0xf, 248 => 0x208, 361 => 0x127c, 362 => 0x1138, 363 => 0x330, 364 => 0x330 },
	'maximumdensityrange' => { 114 => 0x8c },
	'maxpagesize' => { 423 => 'MaxPageSize' },
	'maxpagesizeh' => { 423 => [\'MaxPageSize','MaxPageSizeH'] },
	'maxpagesizeunit' => { 423 => [\'MaxPageSize','MaxPageSizeUnit'] },
	'maxpagesizew' => { 423 => [\'MaxPageSize','MaxPageSizeW'] },
	'maxsamplevalue' => { 104 => 0x119 },
	'maxstorage' => { 413 => 'maxstorage' },
	'mb-d10batteries' => { 234 => '12.6' },
	'mb-d10batterytype' => { 240 => '13.3' },
	'mb-d11batterytype' => { 241 => '2.3' },
	'mb-d12batterytype' => { 244 => '3.2' },
	'mb-d80batteries' => { 242 => '6.5' },
	'mb-d80batterytype' => { 245 => '3.2' },
	'mcuversion' => { 186 => 0xc, 187 => 0x11, 188 => 0x12 },
	'md5digest' => { 142 => 'zmd5' },
	'meal' => { 410 => 'meal' },
	'measuredev' => { 26 => 0x9, 66 => 0x3, 85 => 0x1814, 134 => 'MeasuredEV' },
	'measuredev2' => { 12 => 0x8, 26 => 0x8, 66 => 0x17 },
	'measuredev3' => { 12 => 0x9 },
	'measuredlv' => { 162 => 0x690, 263 => 0x312, 269 => 0x3407 },
	'measuredrggb' => { 55 => 0x1 },
	'measuredrggbdata' => { 36 => 0x287 },
	'measurementaccuracy' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementAccuracy'] },
	'measurementdeterminedby' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedBy'] },
	'measurementdetermineddate' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementDeterminedDate'] },
	'measurementid' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementID'] },
	'measurementmethod' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementMethod'] },
	'measurementorfact' => { 103 => 'MeasurementOrFact' },
	'measurementremarks' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementRemarks'] },
	'measurementtype' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementType'] },
	'measurementunit' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementUnit'] },
	'measurementvalue' => { 103 => [\'MeasurementOrFact','MeasurementOrFactMeasurementValue'] },
	'mediaconstraints' => { 406 => 'MediaConstraints' },
	'mediacreatedate' => { 314 => 0x1 },
	'mediamodifydate' => { 314 => 0x2 },
	'mediasummarycode' => { 406 => 'MediaSummaryCode' },
	'memoaudioquality' => { 72 => 0x812 },
	'memorycardconfiguration' => { 344 => 0x16 },
	'menubuttondisplayposition' => { 70 => 0xb, 73 => 0xa, 74 => 0xb, 77 => 0xb },
	'menubuttonreturn' => { 78 => 0xb },
	'menumonitorofftime' => { 234 => '26.1', 235 => '22.1', 240 => '8.2', 241 => '21.1', 244 => '22.1', 245 => '22.1' },
	'metadatadate' => { 416 => 'MetadataDate' },
	'metadatamoddate' => { 418 => 'metadataModDate' },
	'metaversion' => { 356 => 0x34 },
	'meterinfo1row1' => { 351 => 0x0 },
	'meterinfo1row2' => { 351 => 0x6c },
	'meterinfo1row3' => { 351 => 0xd8 },
	'meterinfo1row4' => { 351 => 0x144 },
	'meterinfo1row5' => { 351 => 0x1b0 },
	'meterinfo1row6' => { 351 => 0x21c },
	'meterinfo1row7' => { 351 => 0x288 },
	'meterinfo2row1' => { 351 => 0x2f4 },
	'meterinfo2row2' => { 351 => 0x378 },
	'meterinfo2row3' => { 351 => 0x3fc },
	'meterinfo2row4' => { 351 => 0x480 },
	'meterinfo2row5' => { 351 => 0x504 },
	'meterinfo2row6' => { 351 => 0x588 },
	'meterinfo2row7' => { 351 => 0x60c },
	'meterinfo2row8' => { 351 => 0x690 },
	'meterinfo2row9' => { 351 => 0x714 },
	'metering' => { 236 => '6.1' },
	'meteringmode' => { 30 => 0x11, 104 => 0x9207, 120 => 0x1c, 156 => 0x7, 157 => 0x25, 159 => 0x12, 247 => 0x202, 300 => 0x17, 331 => 0x9, 338 => 0x15, 339 => 0x13, 340 => 0x7, 354 => 0x3, 357 => 0x1174, 358 => 0x1178, 359 => 0x1154, 360 => 0x11d0, 361 => 0x11ac, 362 => 0x1064, 363 => 0x25c, 364 => 0x25c, 397 => 'MeteringMode' },
	'meteringmode2' => { 281 => '2.1' },
	'meteringmode3' => { 281 => '16.1' },
	'meteringoffscaleindicator' => { 159 => 0x53 },
	'meteringtime' => { 234 => '22.2', 236 => '3.2', 237 => '17.1', 238 => '18.1', 240 => '7.3', 241 => '18.1', 242 => '3.2', 245 => '19.1' },
	'mieversion' => { 142 => '0Vers' },
	'minaperture' => { 30 => 0x1b, 141 => 'MinAperture', 291 => '0.2', 365 => 0x1 },
	'minfocallength' => { 6 => 0xe4, 7 => 0xe, 8 => 0x1a9, 9 => 0x11, 10 => 0x113, 11 => 0x11, 12 => 0x151, 13 => 0xd8, 15 => 0xf8, 16 => 0xec, 17 => 0x101, 18 => 0x93, 19 => 0xe8, 20 => 0x155, 21 => 0xec, 22 => 0xea, 23 => 0x129, 24 => 0x163, 25 => 0x168, 26 => 0x114, 30 => 0x18, 109 => 0x1404, 141 => 'MinFocalLength', 186 => 0x8, 187 => 0xd, 188 => 0xe, 248 => 0x207, 361 => 0x127a, 362 => 0x1136, 363 => 0x32e, 364 => 0x32e },
	'minfocusdistance' => { 291 => 0x3 },
	'minoltadate' => { 156 => 0x15 },
	'minoltaimagesize' => { 156 => 0x4, 157 => 0xc, 158 => 0x2, 161 => 0x103 },
	'minoltamodelid' => { 156 => 0x25 },
	'minoltaquality' => { 156 => 0x5, 157 => 0xd, 158 => 0x3, 161 => [0x102,0x103] },
	'minoltatime' => { 156 => 0x16 },
	'minormodelagedisclosure' => { 406 => 'MinorModelAgeDisclosure' },
	'minsamplevalue' => { 104 => 0x118 },
	'mirrorlockup' => { 70 => 0xc, 71 => 0xc, 72 => 0x60f, 73 => 0xb, 74 => 0xc, 75 => 0x6, 76 => 0x6, 77 => 0xc, 78 => 0x3 },
	'mobilecountrycode' => { 391 => 'mcc' },
	'mobilenetworkcode' => { 391 => 'mnc' },
	'moddate' => { 259 => 'modify-date', 404 => 'ModDate' },
	'modedialposition' => { 344 => 0x14 },
	'model' => { 86 => 0x6, 104 => 0x110, 134 => 'Model', 259 => 'Model', 271 => 0x110, 407 => 'model', 414 => 'Model' },
	'modelage' => { 403 => 'ModelAge' },
	'modelid' => { 246 => 0x0 },
	'modelingflash' => { 234 => '21.4', 235 => '31.1', 240 => '26.4', 241 => '30.2', 242 => '7.4', 243 => '30.1', 244 => '31.1', 245 => '31.3' },
	'modelreleaseid' => { 406 => 'ModelReleaseID' },
	'modelreleasestatus' => { 406 => 'ModelReleaseStatus' },
	'modelreleaseyear' => { 366 => 0x52, 367 => 0x46 },
	'modelyear' => { 407 => 'modelYear' },
	'modificationdate' => { 408 => 'modificationDate' },
	'modifiedcolortemp' => { 56 => 0x9 },
	'modifieddigitalgain' => { 56 => 0xb },
	'modifiedparamflag' => { 49 => 0x1 },
	'modifiedpicturestyle' => { 56 => 0xa },
	'modifiedsaturation' => { 247 => 0x504 },
	'modifiedsensorbluelevel' => { 56 => 0x5 },
	'modifiedsensorredlevel' => { 56 => 0x4 },
	'modifiedsharpness' => { 56 => 0x2 },
	'modifiedsharpnessfreq' => { 56 => 0x3 },
	'modifiedtonecurve' => { 56 => 0x1 },
	'modifiedwhitebalance' => { 56 => 0x8 },
	'modifiedwhitebalanceblue' => { 56 => 0x7 },
	'modifiedwhitebalancered' => { 56 => 0x6 },
	'modifydate' => { 104 => 0x132, 135 => 'ModifyDate', 256 => 'ModDate', 257 => 'tIME', 313 => 'ModDate', 315 => 0x2, 416 => 'ModifyDate' },
	'moirefilter' => { 104 => 0xfe58, 393 => 'MoireFilter' },
	'monitordisplayoff' => { 159 => 0x4c },
	'monitorofftime' => { 234 => '18.2', 236 => '3.1', 242 => '3.1' },
	'monochromecontrast' => { 96 => 0x3c },
	'monochromefiltereffect' => { 90 => 0x20307, 96 => 0x3a, 300 => 0x73 },
	'monochromelinear' => { 96 => 0x3d },
	'monochromeoutputhighlightpoint' => { 96 => 0x41 },
	'monochromeoutputshadowpoint' => { 96 => 0x42 },
	'monochromerawhighlight' => { 96 => 0x7a },
	'monochromerawhighlightpoint' => { 96 => 0x3f },
	'monochromerawshadow' => { 96 => 0x83 },
	'monochromerawshadowpoint' => { 96 => 0x40 },
	'monochromesharpness' => { 96 => 0x3e },
	'monochrometoning' => { 300 => 0x74 },
	'monochrometoningeffect' => { 90 => 0x20306, 96 => 0x3b },
	'monochromeunsharpmaskfineness' => { 96 => 0xb2 },
	'monochromeunsharpmaskstrength' => { 96 => 0xb0 },
	'monochromeunsharpmaskthreshold' => { 96 => 0xb4 },
	'monthdaycreated' => { 120 => 0x12, 129 => 0xe },
	'moonphase' => { 318 => 0x12 },
	'morepermissions' => { 390 => 'morePermissions' },
	'motionsensitivity' => { 318 => 0x29 },
	'movieaelockbuttonassignment' => { 244 => '40.1' },
	'moviefunctionbutton' => { 235 => '41.1', 244 => '41.1' },
	'moviefunctionbuttonplusdials' => { 235 => '52.1' },
	'moviepreviewbutton' => { 235 => '41.2', 244 => '41.2' },
	'moviepreviewbuttonplusdials' => { 235 => '52.2' },
	'movieshutterbutton' => { 235 => '38.3', 244 => '38.3' },
	'moviesubselectorassignment' => { 235 => '48.2' },
	'moviesubselectorassignmentplusdials' => { 235 => '53.1' },
	'multiburstimageheight' => { 350 => 0x1002 },
	'multiburstimagewidth' => { 350 => 0x1001 },
	'multiburstmode' => { 350 => 0x1000 },
	'multicontrollerwhilemetering' => { 72 => 0x517 },
	'multiexposure' => { 58 => 0x1 },
	'multiexposureautogain' => { 192 => 0x3 },
	'multiexposurecontrol' => { 58 => 0x2 },
	'multiexposuremode' => { 192 => 0x1 },
	'multiexposureshots' => { 58 => 0x3, 192 => 0x2 },
	'multiframenoisereduction' => { 340 => 0x35, 350 => 0x200b, 354 => 0x15 },
	'multifunctionlock' => { 72 => 0x70f },
	'multipleexposuremode' => { 251 => 0x101c },
	'multipleexposureset' => { 281 => '10.1' },
	'multisample' => { 197 => 0x40 },
	'multiselector' => { 234 => '9.4', 235 => '10.3', 240 => '27.4', 244 => '10.3' },
	'multiselectorliveview' => { 234 => '4.3', 244 => '37.1' },
	'multiselectorliveviewmode' => { 207 => 0x18c2 },
	'multiselectorplaybackmode' => { 234 => ['13.5','9.2'], 235 => '10.2', 240 => '27.2', 244 => '10.2' },
	'multiselectorshootmode' => { 234 => '9.1', 235 => '10.1', 240 => '27.1', 244 => '10.1' },
	'mycolormode' => { 59 => 0x2 },
	'nationalcatalognumber' => { 408 => 'nationalCatalogNumber' },
	'nativedigest' => { 397 => 'NativeDigest', 414 => 'NativeDigest' },
	'ncdfileinfo' => { 118 => 0x414 },
	'ndfilter' => { 66 => 0x1c, 247 => 0x204, 322 => 0x1019 },
	'nefbitdepth' => { 191 => 0xe22 },
	'nefcompression' => { 191 => 0x93 },
	'neflinearizationtable' => { 191 => 0x96 },
	'neutraldensityfilter' => { 300 => 0x88 },
	'neutraloutputhighlightpoint' => { 96 => 0x2f },
	'neutraloutputshadowpoint' => { 96 => 0x30 },
	'neutralrawcolortone' => { 96 => 0x28 },
	'neutralrawcontrast' => { 96 => 0x2a },
	'neutralrawhighlight' => { 96 => 0x78 },
	'neutralrawhighlightpoint' => { 96 => 0x2d },
	'neutralrawlinear' => { 96 => 0x2b },
	'neutralrawsaturation' => { 96 => 0x29 },
	'neutralrawshadow' => { 96 => 0x81 },
	'neutralrawshadowpoint' => { 96 => 0x2e },
	'neutralrawsharpness' => { 96 => 0x2c },
	'neutralunsharpmaskfineness' => { 96 => 0xa6 },
	'neutralunsharpmaskthreshold' => { 96 => 0xa8 },
	'neutraunsharpmaskstrength' => { 96 => 0xa4 },
	'newrawimagedigest' => { 104 => 0xc7a7 },
	'newsphotoversion' => { 114 => 0x0 },
	'nickname' => { 416 => 'Nickname' },
	'nikoncapturedata' => { 191 => 0xe01 },
	'nikoncaptureeditversions' => { 191 => 0xe13 },
	'nikoncaptureoutput' => { 191 => 0xe1e },
	'nikoncaptureversion' => { 191 => 0xe09 },
	'nikoniccprofile' => { 191 => 0xe1d },
	'nikonimagesize' => { 204 => '723.1', 205 => '732.1', 213 => 0x2c4 },
	'noisefilter' => { 247 => 0x527 },
	'noiseprofile' => { 104 => 0xc761 },
	'noisereduction' => { 109 => 0x100b, 157 => 0xb0, 158 => 0x60, 159 => 0x3f, 191 => 0x95, 227 => 0x753dcbc0, 228 => 0x17, 247 => 0x50a, 252 => 0x103a, 267 => 0x2d, 300 => 0x49, 322 => 0x100f, 324 => 0x2a },
	'noisereduction2' => { 251 => 0x1010 },
	'noisereductionapplied' => { 104 => 0xc6f7 },
	'noisereductionintensity' => { 228 => 0x9 },
	'noisereductionmethod' => { 228 => 0x11 },
	'noisereductionmode' => { 378 => 0x801e },
	'noisereductionsharpness' => { 228 => 0xd },
	'noisereductionvalue' => { 378 => 0x8027 },
	'nomemorycard' => { 234 => '22.1', 235 => '4.2', 236 => '0.3', 237 => '2.4', 238 => '3.2', 239 => '3.2', 240 => '33.7', 241 => '3.2', 242 => '0.3', 244 => '4.2', 245 => '4.5' },
	'nominalmaxaperture' => { 291 => 0xa },
	'nominalminaperture' => { 291 => '10.1' },
	'normalwhitelevel' => { 37 => [0x2b8,0x2cf,0x2d3], 39 => 0x1e3, 40 => [0x1fc,0x2dc], 41 => 0x30e },
	'notes' => { 379 => 'Notes', 387 => 'notes' },
	'npages' => { 423 => 'NPages' },
	'nrwdata' => { 191 => 0x14 },
	'nullrecord' => { 85 => 0x0 },
	'number' => { 408 => 'number' },
	'numberofbeats' => { 418 => 'numberOfBeats' },
	'numberoffocuspoints' => { 239 => '0.2', 241 => '0.3' },
	'numfacepositions' => { 261 => 0x0 },
	'numindexentries' => { 114 => 0x54 },
	'numwbentries' => { 272 => 0x0, 273 => 0x0 },
	'object' => { 408 => 'object' },
	'objectattributereference' => { 112 => 0x4 },
	'objectcycle' => { 112 => 0x4b },
	'objectdescription' => { 407 => 'objectDescription' },
	'objectdistance' => { 99 => 0x6, 100 => 0x2022 },
	'objectname' => { 112 => 0x5 },
	'objectpreviewdata' => { 112 => 0xca },
	'objectpreviewfileformat' => { 112 => 0xc8 },
	'objectpreviewfileversion' => { 112 => 0xc9 },
	'objectsubtype' => { 407 => 'objectSubtype' },
	'objecttype' => { 407 => 'objectType' },
	'objecttypereference' => { 112 => 0x3 },
	'occurrence' => { 103 => 'Occurrence' },
	'occurrenceassociatedmedia' => { 103 => [\'Occurrence','OccurrenceAssociatedMedia'] },
	'occurrenceassociatedoccurrences' => { 103 => [\'Occurrence','OccurrenceAssociatedOccurrences'] },
	'occurrenceassociatedreferences' => { 103 => [\'Occurrence','OccurrenceAssociatedReferences'] },
	'occurrenceassociatedsequences' => { 103 => [\'Occurrence','OccurrenceAssociatedSequences'] },
	'occurrenceassociatedtaxa' => { 103 => [\'Occurrence','OccurrenceAssociatedTaxa'] },
	'occurrencebehavior' => { 103 => [\'Occurrence','OccurrenceBehavior'] },
	'occurrencecatalognumber' => { 103 => [\'Occurrence','OccurrenceCatalogNumber'] },
	'occurrencedetails' => { 103 => [\'Occurrence','OccurrenceOccurrenceDetails'] },
	'occurrencedisposition' => { 103 => [\'Occurrence','OccurrenceDisposition'] },
	'occurrenceestablishmentmeans' => { 103 => [\'Occurrence','OccurrenceEstablishmentMeans'] },
	'occurrenceid' => { 103 => [\'Occurrence','OccurrenceOccurrenceID'] },
	'occurrenceindividualcount' => { 103 => [\'Occurrence','OccurrenceIndividualCount'] },
	'occurrenceindividualid' => { 103 => [\'Occurrence','OccurrenceIndividualID'] },
	'occurrencelifestage' => { 103 => [\'Occurrence','OccurrenceLifeStage'] },
	'occurrenceothercatalognumbers' => { 103 => [\'Occurrence','OccurrenceOtherCatalogNumbers'] },
	'occurrencepreparations' => { 103 => [\'Occurrence','OccurrencePreparations'] },
	'occurrencepreviousidentifications' => { 103 => [\'Occurrence','OccurrencePreviousIdentifications'] },
	'occurrencerecordedby' => { 103 => [\'Occurrence','OccurrenceRecordedBy'] },
	'occurrencerecordnumber' => { 103 => [\'Occurrence','OccurrenceRecordNumber'] },
	'occurrenceremarks' => { 103 => [\'Occurrence','OccurrenceOccurrenceRemarks'] },
	'occurrencereproductivecondition' => { 103 => [\'Occurrence','OccurrenceReproductiveCondition'] },
	'occurrencesex' => { 103 => [\'Occurrence','OccurrenceSex'] },
	'occurrencestatus' => { 103 => [\'Occurrence','OccurrenceOccurrenceStatus'] },
	'oecfcolumns' => { 397 => [\'OECF','OECFColumns'] },
	'oecfnames' => { 397 => [\'OECF','OECFNames'] },
	'oecfrows' => { 397 => [\'OECF','OECFRows'] },
	'oecfvalues' => { 397 => [\'OECF','OECFValues'] },
	'offsaledate' => { 408 => 'offSaleDate' },
	'offsaledatea-platform' => { 408 => [\'offSaleDate','offSaleDateA-platform'] },
	'offsaledatedate' => { 408 => [\'offSaleDate','offSaleDateDate'] },
	'offsetschema' => { 104 => 0xea1d },
	'okbutton' => { 241 => '15.1', 245 => '16.1' },
	'oldsubfiletype' => { 104 => 0xff },
	'olympusimageheight' => { 252 => 0x102f },
	'olympusimagewidth' => { 252 => 0x102e },
	'onetouchwb' => { 252 => 0x302 },
	'onsaledate' => { 408 => 'onSaleDate' },
	'onsaledatea-platform' => { 408 => [\'onSaleDate','onSaleDateA-platform'] },
	'onsaledatedate' => { 408 => [\'onSaleDate','onSaleDateDate'] },
	'onsaleday' => { 408 => 'onSaleDay' },
	'onsaledaya-platform' => { 408 => [\'onSaleDay','onSaleDayA-platform'] },
	'onsaledayday' => { 408 => [\'onSaleDay','onSaleDayDay'] },
	'opticalzoom' => { 122 => 0xfa3d, 124 => [0x6006,0xf006], 125 => 0x1000, 126 => 0xf, 129 => 0x1e, 141 => 'OpticalZoom' },
	'opticalzoomcode' => { 66 => 0xa },
	'opticalzoommode' => { 267 => 0x34 },
	'opticalzoomon' => { 330 => 0x219 },
	'optionenddate' => { 411 => 'optionEndDate' },
	'opto-electricconvfactor' => { 397 => 'OECF' },
	'orangehsl' => { 90 => 0x20911 },
	'ordernumber' => { 109 => 0x8002 },
	'organisationinimagecode' => { 403 => 'OrganisationInImageCode' },
	'organisationinimagename' => { 403 => 'OrganisationInImageName' },
	'organization' => { 408 => 'organization' },
	'orientation' => { 104 => 0x112, 271 => 0x112, 407 => 'orientation', 414 => 'Orientation' },
	'orientation2' => { 354 => [0x28,0x2e] },
	'orientationlinkedafpoint' => { 72 => 0x516 },
	'originalbestqualitysize' => { 104 => 0xc792 },
	'originaldecisiondata' => { 101 => 'OriginalDecisionData' },
	'originaldecisiondataoffset' => { 54 => 0x83 },
	'originaldefaultcropsize' => { 104 => 0xc793 },
	'originaldefaultfinalsize' => { 104 => 0xc791 },
	'originaldirectory' => { 265 => 0x408 },
	'originaldocumentid' => { 419 => 'OriginalDocumentID' },
	'originalfilename' => { 85 => 0x816, 118 => 0x3e9, 130 => 0x20, 265 => 0x407, 383 => 'OriginalFilename' },
	'originalimageheight' => { 68 => 0xc, 108 => 0x1 },
	'originalimagewidth' => { 68 => 0xb, 108 => 0x0 },
	'originalrawfiledata' => { 104 => 0xc68c },
	'originalrawfiledigest' => { 104 => 0xc71d },
	'originalrawfilename' => { 104 => 0xc68b },
	'originaltransmissionreference' => { 112 => 0x67 },
	'originatingprogram' => { 112 => 0x41 },
	'originplatform' => { 408 => 'originPlatform' },
	'os' => { 395 => 'os' },
	'otherconditions' => { 406 => 'OtherConditions' },
	'otherconstraints' => { 406 => 'OtherConstraints' },
	'otherimage' => { 101 => 'OtherImage' },
	'otherimageinfo' => { 406 => 'OtherImageInfo' },
	'otherimagelength' => { 104 => 0x202 },
	'otherimagestart' => { 104 => 0x201 },
	'otherlicensedocuments' => { 406 => 'OtherLicenseDocuments' },
	'otherlicenseinfo' => { 406 => 'OtherLicenseInfo' },
	'otherlicenserequirements' => { 406 => 'OtherLicenseRequirements' },
	'outcue' => { 418 => 'outCue' },
	'outcuescale' => { 418 => [\'outCue','outCueScale'] },
	'outcuevalue' => { 418 => [\'outCue','outCueValue'] },
	'outputimageheight' => { 170 => 0x3 },
	'outputimagewidth' => { 170 => 0x2 },
	'outputprofile' => { 118 => 0x138b },
	'outputresolution' => { 170 => 0x4 },
	'owner' => { 422 => 'Owner' },
	'ownerid' => { 112 => 0xbc },
	'ownername' => { 14 => 0x10f, 54 => 0x9, 85 => 0x810, 104 => [0xa430,0xfde8], 134 => 'OwnerName', 389 => 'OwnerName', 398 => 'CameraOwnerName' },
	'padding' => { 104 => 0xea1c },
	'pagecount' => { 408 => 'pageCount' },
	'pageimage' => { 416 => [\'PageInfo','PageInfoImage'] },
	'pageimageformat' => { 416 => [\'PageInfo','PageInfoFormat'] },
	'pageimageheight' => { 416 => [\'PageInfo','PageInfoHeight'] },
	'pageimagepagenumber' => { 416 => [\'PageInfo','PageInfoPageNumber'] },
	'pageimagewidth' => { 416 => [\'PageInfo','PageInfoWidth'] },
	'pageinfo' => { 416 => 'PageInfo' },
	'pagename' => { 104 => 0x11d },
	'pagenumber' => { 104 => 0x129 },
	'pageprogressiondirection' => { 408 => 'pageProgressionDirection' },
	'pagerange' => { 408 => 'pageRange' },
	'paintbasedcorrectionmasks' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasks'] },
	'paintbasedcorrections' => { 393 => 'PaintBasedCorrections' },
	'paintcorrectionactive' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionActive'] },
	'paintcorrectionamount' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionAmount'] },
	'paintcorrectionbrightness' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalBrightness'] },
	'paintcorrectionclarity' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity'] },
	'paintcorrectionclarity2012' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalClarity2012'] },
	'paintcorrectioncontrast' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast'] },
	'paintcorrectioncontrast2012' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalContrast2012'] },
	'paintcorrectiondefringe' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalDefringe'] },
	'paintcorrectionexposure' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure'] },
	'paintcorrectionexposure2012' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalExposure2012'] },
	'paintcorrectionhighlights2012' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalHighlights2012'] },
	'paintcorrectionhue' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalToningHue'] },
	'paintcorrectionluminancenoise' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalLuminanceNoise'] },
	'paintcorrectionmaskalpha' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAlpha'] },
	'paintcorrectionmaskangle' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksAngle'] },
	'paintcorrectionmaskbottom' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksBottom'] },
	'paintcorrectionmaskcentervalue' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterValue'] },
	'paintcorrectionmaskcenterweight' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksCenterWeight'] },
	'paintcorrectionmaskdabs' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksDabs'] },
	'paintcorrectionmaskfeather' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFeather'] },
	'paintcorrectionmaskflipped' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlipped'] },
	'paintcorrectionmaskflow' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFlow'] },
	'paintcorrectionmaskfullx' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullX'] },
	'paintcorrectionmaskfully' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksFullY'] },
	'paintcorrectionmaskleft' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksLeft'] },
	'paintcorrectionmaskmidpoint' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMidpoint'] },
	'paintcorrectionmaskperimetervalue' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksPerimeterValue'] },
	'paintcorrectionmaskradius' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRadius'] },
	'paintcorrectionmaskright' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRight'] },
	'paintcorrectionmaskroundness' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksRoundness'] },
	'paintcorrectionmasksizex' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeX'] },
	'paintcorrectionmasksizey' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksSizeY'] },
	'paintcorrectionmasktop' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksTop'] },
	'paintcorrectionmaskvalue' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksMaskValue'] },
	'paintcorrectionmaskversion' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksVersion'] },
	'paintcorrectionmaskwhat' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksWhat'] },
	'paintcorrectionmaskx' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksX'] },
	'paintcorrectionmasky' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksY'] },
	'paintcorrectionmaskzerox' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroX'] },
	'paintcorrectionmaskzeroy' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsCorrectionMasksZeroY'] },
	'paintcorrectionmoire' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalMoire'] },
	'paintcorrectionsaturation' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSaturation','PaintBasedCorrectionsLocalToningSaturation'] },
	'paintcorrectionshadows2012' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalShadows2012'] },
	'paintcorrectionsharpness' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalSharpness'] },
	'paintcorrectiontemperature' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTemperature'] },
	'paintcorrectiontint' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsLocalTint'] },
	'paintcorrectionwhat' => { 393 => [\'PaintBasedCorrections','PaintBasedCorrectionsWhat'] },
	'panasonicexifversion' => { 267 => 0x26 },
	'panasonicimageheight' => { 267 => 0x4c },
	'panasonicimagewidth' => { 267 => 0x4b },
	'panasonicrawversion' => { 271 => 0x1 },
	'panasonictitle' => { 104 => 0xc6d2 },
	'panasonictitle2' => { 104 => 0xc6d3 },
	'panoramacropbottom' => { 355 => 0x7 },
	'panoramacropleft' => { 355 => 0x4 },
	'panoramacropright' => { 355 => 0x6 },
	'panoramacroptop' => { 355 => 0x5 },
	'panoramadirection' => { 62 => 0x5, 355 => 0x3 },
	'panoramaframeheight' => { 355 => 0x9 },
	'panoramaframenumber' => { 62 => 0x2 },
	'panoramaframewidth' => { 355 => 0x8 },
	'panoramafullheight' => { 355 => 0x2 },
	'panoramafullwidth' => { 355 => 0x1 },
	'panoramamode' => { 120 => 0x3c, 247 => 0x601 },
	'panoramasize3d' => { 340 => 0x38 },
	'panoramasourceheight' => { 355 => 0xb },
	'panoramasourcewidth' => { 355 => 0xa },
	'panoramicstitchcameramotion' => { 152 => 'PanoramicStitchCameraMotion', 153 => 0x1 },
	'panoramicstitchmaptype' => { 152 => 'PanoramicStitchMapType', 153 => 0x2 },
	'panoramicstitchphi0' => { 152 => 'PanoramicStitchPhi0', 153 => 0x5 },
	'panoramicstitchphi1' => { 152 => 'PanoramicStitchPhi1', 153 => 0x6 },
	'panoramicstitchtheta0' => { 152 => 'PanoramicStitchTheta0', 153 => 0x3 },
	'panoramicstitchtheta1' => { 152 => 'PanoramicStitchTheta1', 153 => 0x4 },
	'panoramicstitchversion' => { 153 => 0x0 },
	'pantry' => { 419 => 'Pantry' },
	'parallax' => { 109 => 0xb211, 246 => 0x28 },
	'parametricdarks' => { 393 => 'ParametricDarks' },
	'parametrichighlights' => { 393 => 'ParametricHighlights' },
	'parametrichighlightsplit' => { 393 => 'ParametricHighlightSplit' },
	'parametriclights' => { 393 => 'ParametricLights' },
	'parametricmidtonesplit' => { 393 => 'ParametricMidtoneSplit' },
	'parametricshadows' => { 393 => 'ParametricShadows' },
	'parametricshadowsplit' => { 393 => 'ParametricShadowSplit' },
	'parentmeid' => { 383 => 'ParentMEID' },
	'parentreference1' => { 401 => [\'TagStructure','TagStructureParentReference'] },
	'parentreference2' => { 401 => [\'TagStructure','TagStructureSubLabelsParentReference'] },
	'parentreference3' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsParentReference'] },
	'parentreference4' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference5' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'parentreference6' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsParentReference'] },
	'partofcompilation' => { 418 => 'partOfCompilation' },
	'patientbirthdate' => { 380 => 'PatientDOB' },
	'patientid' => { 380 => 'PatientID' },
	'patientname' => { 380 => 'PatientName' },
	'patientsex' => { 380 => 'PatientSex' },
	'pdfversion' => { 404 => 'PDFVersion' },
	'pentaximagesize' => { 300 => 0x9 },
	'pentaxmodelid' => { 280 => 0x0, 300 => 0x5 },
	'pentaxmodeltype' => { 300 => 0x1 },
	'pentaxversion' => { 300 => 0x0 },
	'people' => { 381 => 'People', 385 => 'People' },
	'perchannelblacklevel' => { 36 => 0xc4, 37 => [0x2b4,0x2cb,0x2cf], 38 => 0x108, 39 => 0x1df, 40 => [0x1f8,0x2d8], 41 => 0x30a },
	'peripheralillumcentralradius' => { 378 => 0x8030 },
	'peripheralillumcentralvalue' => { 378 => 0x8031 },
	'peripheralillumination' => { 90 => 0x20702, 96 => 0x68 },
	'peripheralilluminationcorr' => { 53 => 0x1, 290 => 0x2 },
	'peripheralilluminationon' => { 90 => '0x20702.0', 96 => 0x64 },
	'peripheralillumperiphvalue' => { 378 => 0x8032 },
	'peripherallighting' => { 68 => 0x2 },
	'peripherallightingsetting' => { 69 => 0x5 },
	'peripherallightingvalue' => { 68 => 0x6 },
	'permissions' => { 411 => 'permissions' },
	'permits' => { 390 => 'permits' },
	'person' => { 408 => 'person' },
	'personality' => { 383 => 'Personality' },
	'personinimage' => { 403 => 'PersonInImage' },
	'personinimagecharacteristic' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristic'] },
	'personinimagecvtermcvid' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvId'] },
	'personinimagecvtermid' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermId'] },
	'personinimagecvtermname' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermName'] },
	'personinimagecvtermrefinedabout' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonCharacteristicCvTermRefinedAbout'] },
	'personinimagedescription' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonDescription'] },
	'personinimageid' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonId'] },
	'personinimagename' => { 403 => [\'PersonInImageWDetails','PersonInImageWDetailsPersonName'] },
	'personinimagewdetails' => { 403 => 'PersonInImageWDetails' },
	'perspectiveaspect' => { 393 => 'PerspectiveAspect' },
	'perspectivehorizontal' => { 393 => 'PerspectiveHorizontal' },
	'perspectiverotate' => { 393 => 'PerspectiveRotate' },
	'perspectivescale' => { 393 => 'PerspectiveScale' },
	'perspectiveupright' => { 393 => 'PerspectiveUpright' },
	'perspectivevertical' => { 393 => 'PerspectiveVertical' },
	'pf0customfuncregistration' => { 80 => 0x1 },
	'pf10retainprogramshift' => { 80 => 0xb },
	'pf13drivepriority' => { 80 => 0xe },
	'pf14disablefocussearch' => { 80 => 0xf },
	'pf15disableafassistbeam' => { 80 => 0x10 },
	'pf16autofocuspointshoot' => { 80 => 0x11 },
	'pf17disableafpointsel' => { 80 => 0x12 },
	'pf18enableautoafpointsel' => { 80 => 0x13 },
	'pf19continuousshootspeed' => { 80 => 0x14 },
	'pf19shootingspeedhigh' => { 79 => 0xa },
	'pf19shootingspeedlow' => { 79 => 0x9 },
	'pf1disableshootingmodes' => { 80 => 0x2 },
	'pf1value' => { 79 => 0x1 },
	'pf20limitcontinousshots' => { 80 => 0x15 },
	'pf20maxcontinousshots' => { 79 => 0xb },
	'pf21enablequietoperation' => { 80 => 0x16 },
	'pf23felocktime' => { 79 => 0xd },
	'pf23postreleasetime' => { 79 => 0xe },
	'pf23settimerlengths' => { 80 => 0x18 },
	'pf23shutterbuttontime' => { 79 => 0xc },
	'pf24lightlcdduringbulb' => { 80 => 0x19 },
	'pf25aemode' => { 79 => 0xf },
	'pf25afmode' => { 79 => 0x12 },
	'pf25afpointsel' => { 79 => 0x13 },
	'pf25colormatrix' => { 79 => 0x17 },
	'pf25defaultclearsettings' => { 80 => 0x1a },
	'pf25drivemode' => { 79 => 0x11 },
	'pf25imagesize' => { 79 => 0x14 },
	'pf25meteringmode' => { 79 => 0x10 },
	'pf25parameters' => { 79 => 0x16 },
	'pf25wbmode' => { 79 => 0x15 },
	'pf26shortenreleaselag' => { 80 => 0x1b },
	'pf27reversedialrotation' => { 80 => 0x1c },
	'pf27value' => { 79 => 0x18 },
	'pf28noquickdialexpcomp' => { 80 => 0x1d },
	'pf29quickdialswitchoff' => { 80 => 0x1e },
	'pf2disablemeteringmodes' => { 80 => 0x3 },
	'pf2value' => { 79 => 0x2 },
	'pf30enlargementmode' => { 80 => 0x1f },
	'pf31originaldecisiondata' => { 80 => 0x20 },
	'pf3manualexposuremetering' => { 80 => 0x4 },
	'pf3value' => { 79 => 0x3 },
	'pf4exposuretimelimits' => { 80 => 0x5 },
	'pf4exposuretimemax' => { 79 => 0x5 },
	'pf4exposuretimemin' => { 79 => 0x4 },
	'pf5aperturelimits' => { 80 => 0x6 },
	'pf5aperturemax' => { 79 => 0x7 },
	'pf5aperturemin' => { 79 => 0x6 },
	'pf6presetshootingmodes' => { 80 => 0x7 },
	'pf7bracketcontinuousshoot' => { 80 => 0x8 },
	'pf8bracketshots' => { 79 => 0x8 },
	'pf8setbracketshots' => { 80 => 0x9 },
	'pf9changebracketsequence' => { 80 => 0xa },
	'phasedetectaf' => { 167 => 0x6 },
	'phonenumber' => { 135 => 'Phone' },
	'photoeffect' => { 30 => 0x28 },
	'photoeffecthistoryxml' => { 227 => 0xe9651831 },
	'photoeffects' => { 227 => 0xab5eca5e },
	'photoeffectsblue' => { 229 => 0x8 },
	'photoeffectsgreen' => { 229 => 0x6 },
	'photoeffectsred' => { 229 => 0x4 },
	'photoeffectstype' => { 229 => 0x0 },
	'photographicsensitivity' => { 398 => 'PhotographicSensitivity' },
	'photoinfoplayback' => { 234 => '17.6', 240 => '33.6' },
	'photometricinterpretation' => { 104 => 0x106, 414 => 'PhotometricInterpretation' },
	'photoshopbgrthumbnail' => { 311 => 0x409 },
	'photoshopquality' => { 310 => 0x0 },
	'photoshopthumbnail' => { 311 => 0x40c },
	'photostyle' => { 267 => 0x89 },
	'picklabel' => { 396 => 'PickLabel' },
	'pictinfo' => { 330 => 0x208 },
	'picturecontrol' => { 227 => 0xe2173c47 },
	'picturecontrolactive' => { 230 => 0x0 },
	'picturecontroladjust' => { 193 => 0x30 },
	'picturecontrolbase' => { 193 => 0x18 },
	'picturecontroldata' => { 191 => [0xbd,0x23] },
	'picturecontrolmode' => { 230 => 0x13 },
	'picturecontrolname' => { 193 => 0x4 },
	'picturecontrolquickadjust' => { 193 => 0x31 },
	'pictureeffect' => { 350 => 0x200e },
	'pictureeffect2' => { 357 => 0x1163, 358 => 0x1167, 359 => 0x1143, 360 => 0x11bf, 361 => 0x119b, 362 => 0x1053, 363 => 0x24b, 364 => 0x24b, 374 => 0x46 },
	'picturefinish' => { 157 => 0x71 },
	'picturemode' => { 109 => 0x1031, 247 => 0x520, 300 => [0xb,0x33], 331 => 0x3d },
	'picturemode2' => { 281 => 0x0 },
	'picturemodebwfilter' => { 247 => 0x525 },
	'picturemodecontrast' => { 247 => 0x523 },
	'picturemodeeffect' => { 247 => 0x52d },
	'picturemodehue' => { 247 => 0x522 },
	'picturemodesaturation' => { 247 => 0x521 },
	'picturemodesharpness' => { 247 => 0x524 },
	'picturemodetone' => { 247 => 0x526 },
	'pictureprofile' => { 357 => [0x115e,0x115f], 358 => [0x1162,0x1163], 359 => [0x113e,0x113f], 360 => [0x11ba,0x11bb], 361 => [0x1196,0x1197], 362 => [0x104e,0x104f], 363 => [0x246,0x247], 364 => [0x246,0x247] },
	'picturestyle' => { 7 => [0x4b,0x51], 8 => 0xf4, 9 => 0x6c, 10 => 0x86, 11 => 0x73, 15 => 0xab, 16 => 0xa7, 17 => 0xb0, 18 => 0x6c, 19 => 0xa7, 20 => 0xf4, 21 => 0xb3, 23 => 0xf4, 24 => 0xfa, 64 => 0xa, 90 => 0x20301, 96 => 0x2 },
	'picturewizard' => { 328 => 0x21 },
	'picturewizardcolor' => { 327 => 0x1 },
	'picturewizardcontrast' => { 327 => 0x4 },
	'picturewizardmode' => { 327 => 0x0 },
	'picturewizardsaturation' => { 327 => 0x2 },
	'picturewizardsharpness' => { 327 => 0x3 },
	'pitch' => { 235 => '4.1', 244 => '4.1' },
	'pitchangle' => { 207 => 0x350f, 247 => 0x904, 267 => 0x91, 299 => 0x2 },
	'pixelsperunitx' => { 258 => 0x0 },
	'pixelsperunity' => { 258 => 0x4 },
	'pixelunits' => { 258 => 0x8 },
	'planarconfiguration' => { 104 => 0x11c, 414 => 'PlanarConfiguration' },
	'platenames' => { 423 => 'PlateNames' },
	'platform' => { 408 => 'platform' },
	'playbackmenustime' => { 237 => '20.1', 238 => '21.1', 239 => '21.1' },
	'playbackmonitorofftime' => { 234 => '25.2', 235 => '36.1', 240 => '8.1', 241 => '35.1', 244 => '36.1', 245 => '21.1' },
	'playbackzoom' => { 235 => '37.1' },
	'playdisplay' => { 159 => 0x4e },
	'plusversion' => { 406 => 'Version' },
	'pmversion' => { 309 => 'PMVersion' },
	'pngwarning' => { 259 => 'Warning' },
	'poilevel' => { 190 => 0x8 },
	'portraitoutputhighlightpoint' => { 96 => 0x1d },
	'portraitoutputshadowpoint' => { 96 => 0x1e },
	'portraitrawcolortone' => { 96 => 0x16 },
	'portraitrawcontrast' => { 96 => 0x18 },
	'portraitrawhighlight' => { 96 => 0x76 },
	'portraitrawhighlightpoint' => { 96 => 0x1b },
	'portraitrawlinear' => { 96 => 0x19 },
	'portraitrawsaturation' => { 96 => 0x17 },
	'portraitrawshadow' => { 96 => 0x7f },
	'portraitrawshadowpoint' => { 96 => 0x1c },
	'portraitrawsharpness' => { 96 => 0x1a },
	'portraitrefiner' => { 100 => 0x302b },
	'portraitunsharpmaskfineness' => { 96 => 0x9a },
	'portraitunsharpmaskstrength' => { 96 => 0x98 },
	'portraitunsharpmaskthreshold' => { 96 => 0x9c },
	'poseheadingdegrees' => { 382 => 'PoseHeadingDegrees' },
	'posepitchdegrees' => { 382 => 'PosePitchDegrees' },
	'poserolldegrees' => { 382 => 'PoseRollDegrees' },
	'positiondescriptor' => { 407 => 'positionDescriptor' },
	'postalcode' => { 139 => 'PostalCode' },
	'postcropvignetteamount' => { 393 => 'PostCropVignetteAmount' },
	'postcropvignettefeather' => { 393 => 'PostCropVignetteFeather' },
	'postcropvignettehighlightcontrast' => { 393 => 'PostCropVignetteHighlightContrast' },
	'postcropvignettemidpoint' => { 393 => 'PostCropVignetteMidpoint' },
	'postcropvignetteroundness' => { 393 => 'PostCropVignetteRoundness' },
	'postcropvignettestyle' => { 393 => 'PostCropVignetteStyle' },
	'potentialface1position' => { 348 => 0xb },
	'potentialface2position' => { 348 => 0x15 },
	'potentialface3position' => { 348 => 0x1f },
	'potentialface4position' => { 348 => 0x29 },
	'potentialface5position' => { 348 => 0x33 },
	'potentialface6position' => { 348 => 0x3d },
	'potentialface7position' => { 348 => 0x47 },
	'potentialface8position' => { 348 => 0x51 },
	'powersource' => { 279 => '0.1' },
	'poweruptime' => { 191 => 0xb6 },
	'precaptureframes' => { 252 => 0x300 },
	'predictor' => { 104 => 0x13d },
	'preflashreturnstrength' => { 205 => 0x28a },
	'prefs' => { 112 => 0xdd, 309 => 'Prefs' },
	'preservedfilename' => { 419 => 'PreservedFileName' },
	'presetwhitebalance' => { 159 => 0x24, 378 => 0x8002 },
	'presetwhitebalanceadj' => { 378 => 0x8014 },
	'previewapplicationname' => { 104 => 0xc716 },
	'previewapplicationversion' => { 104 => 0xc717 },
	'previewbutton' => { 234 => ['14.1','15.1'], 235 => '15.1', 240 => '29.1', 241 => '14.1', 244 => '15.1' },
	'previewbuttonplusdials' => { 234 => ['14.2','15.2'], 235 => '15.2', 240 => '31.2', 244 => '43.1' },
	'previewcolorspace' => { 104 => 0xc71a },
	'previewcropbottom' => { 308 => 0xef },
	'previewcropleft' => { 308 => 0xec },
	'previewcropright' => { 308 => 0xee },
	'previewcroptop' => { 308 => 0xed },
	'previewdate' => { 316 => 0x0 },
	'previewdatetime' => { 104 => 0xc71b },
	'previewimage' => { 100 => 0x2000, 101 => 'PreviewImage', 105 => 'PreviewImage', 107 => 0x4, 144 => 'data', 161 => 0x81, 252 => 0x280, 266 => 0x300, 350 => 0x2001 },
	'previewimageborders' => { 300 => 0x3e },
	'previewimageheight' => { 63 => 0x4, 122 => 0xfa58 },
	'previewimagelength' => { 63 => 0x2, 100 => 0x3, 104 => [0x117,0x202], 161 => 0x89, 194 => 0x202, 247 => 0x102, 252 => 0x1037, 300 => 0x3, 321 => 0x1e, 326 => 0x3, 331 => [0x1b,0x1d], 341 => 0x202 },
	'previewimagename' => { 144 => '1Name' },
	'previewimagesize' => { 100 => 0x2, 127 => 0x2, 144 => 'ImageSize', 300 => 0x2, 331 => [0x1c,0x1e], 350 => 0xb02c },
	'previewimagestart' => { 63 => 0x5, 100 => 0x4, 104 => [0x111,0x201], 161 => 0x88, 194 => 0x201, 247 => 0x101, 252 => 0x1036, 300 => 0x4, 321 => 0x1c, 326 => 0x2, 331 => [0x1a,0x1c], 341 => 0x201 },
	'previewimagetype' => { 144 => '0Type' },
	'previewimagevalid' => { 247 => 0x100, 252 => 0x1035 },
	'previewimagewidth' => { 63 => 0x3, 122 => 0xfa57 },
	'previewquality' => { 63 => 0x1 },
	'previewsettingsdigest' => { 104 => 0xc719 },
	'previewsettingsname' => { 104 => 0xc718 },
	'primaryafpoint' => { 167 => 0x7 },
	'primarychromaticities' => { 104 => 0x13f, 414 => 'PrimaryChromaticities' },
	'printim' => { 104 => 0xc4a5 },
	'prioritysetupshutterrelease' => { 159 => 0x1d, 338 => 0x28 },
	'privatertkinfo' => { 384 => 'privateRTKInfo' },
	'processingsoftware' => { 104 => 0xb },
	'processversion' => { 393 => 'ProcessVersion' },
	'producer' => { 256 => 'Producer', 404 => 'Producer' },
	'productcode' => { 408 => 'productCode' },
	'productid' => { 113 => 0x32, 407 => 'productID' },
	'productidtype' => { 407 => 'productIDType' },
	'productinimage' => { 403 => 'ProductInImage' },
	'productinimagedescription' => { 403 => [\'ProductInImage','ProductInImageProductDescription'] },
	'productinimagegtin' => { 403 => [\'ProductInImage','ProductInImageProductGTIN'] },
	'productinimagename' => { 403 => [\'ProductInImage','ProductInImageProductName'] },
	'productioncode' => { 280 => 0x2 },
	'productorserviceconstraints' => { 406 => 'ProductOrServiceConstraints' },
	'profession' => { 408 => 'profession' },
	'profilecalibrationsig' => { 104 => 0xc6f4 },
	'profilecopyright' => { 104 => 0xc6fe },
	'profileembedpolicy' => { 104 => 0xc6fd },
	'profilehuesatmapdata1' => { 104 => 0xc6fa },
	'profilehuesatmapdata2' => { 104 => 0xc6fb },
	'profilehuesatmapdims' => { 104 => 0xc6f9 },
	'profilehuesatmapencoding' => { 104 => 0xc7a3 },
	'profilelooktabledata' => { 104 => 0xc726 },
	'profilelooktabledims' => { 104 => 0xc725 },
	'profilelooktableencoding' => { 104 => 0xc7a4 },
	'profilename' => { 104 => 0xc6f8 },
	'profiletonecurve' => { 104 => 0xc6fc },
	'programiso' => { 267 => 0x3c },
	'programline' => { 281 => '1.1' },
	'programmode' => { 164 => 0x5 },
	'programshift' => { 191 => 0xd },
	'programversion' => { 112 => 0x46 },
	'prohibits' => { 390 => 'prohibits' },
	'projectiontype' => { 382 => 'ProjectionType' },
	'projectname' => { 418 => 'projectName' },
	'projectref' => { 418 => 'projectRef' },
	'projectrefpath' => { 418 => [\'projectRef','projectRefPath'] },
	'projectreftype' => { 418 => [\'projectRef','projectRefType'] },
	'propertyreleaseid' => { 406 => 'PropertyReleaseID' },
	'propertyreleasestatus' => { 406 => 'PropertyReleaseStatus' },
	'province-state' => { 112 => 0x5f },
	'publicationdate' => { 408 => 'publicationDate' },
	'publicationdatea-platform' => { 408 => [\'publicationDate','publicationDateA-platform'] },
	'publicationdatedate' => { 408 => [\'publicationDate','publicationDateDate'] },
	'publicationdisplaydate' => { 408 => 'publicationDisplayDate' },
	'publicationdisplaydatea-platform' => { 408 => [\'publicationDisplayDate','publicationDisplayDateA-platform'] },
	'publicationdisplaydatedate' => { 408 => [\'publicationDisplayDate','publicationDisplayDateDate'] },
	'publicationname' => { 408 => 'publicationName' },
	'publisher' => { 394 => 'publisher' },
	'publishingfrequency' => { 408 => 'publishingFrequency' },
	'pulldown' => { 418 => 'pullDown' },
	'purplehsl' => { 90 => 0x20916 },
	'quality' => { 0 => 0x1, 30 => 0x3, 99 => 0x2, 100 => 0x3002, 109 => 0x1000, 120 => 0x9, 191 => 0x4, 217 => 0x3, 252 => 0x201, 263 => 0x300, 300 => 0x8, 306 => 0x2, 331 => 0x16, 338 => 0x56, 339 => 0x56, 340 => 0xb, 350 => 0x102 },
	'quality2' => { 357 => 0x1170, 358 => 0x1174, 359 => 0x1150, 361 => 0x11a8, 362 => 0x1060, 363 => 0x258, 364 => 0x258, 366 => 0x29, 367 => 0x25, 368 => 0x2a },
	'qualitymode' => { 100 => 0x8 },
	'quantizationmethod' => { 114 => 0x78 },
	'quickadjust' => { 230 => 0x2a },
	'quickcontroldialinmeter' => { 72 => 0x703 },
	'quickfix' => { 227 => 0x416391c6 },
	'quickshot' => { 330 => 0x213 },
	'rangefinder' => { 237 => '4.1', 238 => '5.1', 239 => '5.1' },
	'rasterizedcaption' => { 112 => 0x7d },
	'rating' => { 104 => 0x4746, 109 => 0x1431, 308 => 0xdf, 350 => 0x2002, 387 => 'rating', 395 => 'rating', 408 => 'rating', 416 => 'Rating' },
	'ratingpercent' => { 104 => 0x4749, 154 => 'Rating' },
	'rawandjpgrecording' => { 70 => 0x8, 161 => 0x109, 281 => 0xd },
	'rawbrightnessadj' => { 90 => 0x20001, 95 => 0x38 },
	'rawcoloradj' => { 95 => 0x2e },
	'rawcompressionmode' => { 328 => 0x45 },
	'rawcropbottom' => { 308 => 0xd4 },
	'rawcropleft' => { 308 => 0xd1 },
	'rawcropright' => { 308 => 0xd3 },
	'rawcroptop' => { 308 => 0xd2 },
	'rawcustomsaturation' => { 95 => 0x30 },
	'rawcustomtone' => { 95 => 0x34 },
	'rawdata' => { 328 => 0xa048 },
	'rawdatauniqueid' => { 104 => 0xc65d },
	'rawdepth' => { 163 => 0x10 },
	'rawdevartfilter' => { 254 => 0x121 },
	'rawdevautogradation' => { 254 => 0x119 },
	'rawdevcolorspace' => { 253 => 0x108, 254 => 0x109 },
	'rawdevcontrastvalue' => { 253 => 0x106, 254 => 0x105 },
	'rawdeveditstatus' => { 253 => 0x10b },
	'rawdevelopmentprocess' => { 300 => 0x62 },
	'rawdevengine' => { 253 => 0x109, 254 => 0x10b },
	'rawdevexposurebiasvalue' => { 253 => 0x100, 254 => 0x100 },
	'rawdevgradation' => { 254 => 0x112 },
	'rawdevgraypoint' => { 253 => 0x103, 254 => 0x104 },
	'rawdevmemorycoloremphasis' => { 253 => 0x105, 254 => 0x108 },
	'rawdevnoisereduction' => { 253 => 0x10a, 254 => 0x10a },
	'rawdevpicturemode' => { 254 => 0x10c },
	'rawdevpm_bwfilter' => { 254 => 0x110 },
	'rawdevpmcontrast' => { 254 => 0x10e },
	'rawdevpmnoisefilter' => { 254 => 0x120 },
	'rawdevpmpicturetone' => { 254 => 0x111 },
	'rawdevpmsaturation' => { 254 => 0x10d },
	'rawdevpmsharpness' => { 254 => 0x10f },
	'rawdevsaturation3' => { 254 => 0x113 },
	'rawdevsaturationemphasis' => { 253 => 0x104, 254 => 0x107 },
	'rawdevsettings' => { 253 => 0x10c },
	'rawdevsharpnessvalue' => { 253 => 0x107, 254 => 0x106 },
	'rawdevversion' => { 253 => 0x0, 254 => 0x0 },
	'rawdevwbfineadjustment' => { 253 => 0x102, 254 => 0x103 },
	'rawdevwhitebalance' => { 254 => 0x101 },
	'rawdevwhitebalancevalue' => { 253 => 0x101, 254 => 0x102 },
	'rawfile' => { 104 => 0xfe4c },
	'rawfilename' => { 393 => 'RawFileName' },
	'rawimagecenter' => { 191 => 0x99 },
	'rawimagedigest' => { 104 => 0xc71c },
	'rawimagesize' => { 300 => 0x39 },
	'rawinfoversion' => { 255 => 0x0 },
	'rawjpgheight' => { 87 => 0x4 },
	'rawjpgquality' => { 48 => 0x6, 87 => 0x1 },
	'rawjpgsize' => { 48 => 0x7, 87 => 0x2 },
	'rawjpgwidth' => { 87 => 0x3 },
	'rawmeasuredrggb' => { 35 => 0x26a, 37 => 0x280, 39 => 0x194, 40 => [0x1ad,0x26b] },
	'rawrppused' => { 387 => 'rawrppused' },
	'rawtopreviewgain' => { 104 => 0xc7a8 },
	'reardisplay' => { 234 => '12.3', 235 => '6.2' },
	'recipeendingpage' => { 410 => 'recipeEndingPage' },
	'recipepagerange' => { 410 => 'recipePageRange' },
	'recipesource' => { 410 => 'recipeSource' },
	'recipestartingpage' => { 410 => 'recipeStartingPage' },
	'recipetitle' => { 410 => 'recipeTitle' },
	'recognizedface1age' => { 262 => 0x20 },
	'recognizedface1name' => { 262 => 0x4 },
	'recognizedface1position' => { 262 => 0x18 },
	'recognizedface2age' => { 262 => 0x50 },
	'recognizedface2name' => { 262 => 0x34 },
	'recognizedface2position' => { 262 => 0x48 },
	'recognizedface3age' => { 262 => 0x80 },
	'recognizedface3name' => { 262 => 0x64 },
	'recognizedface3position' => { 262 => 0x78 },
	'recognizedfaceflags' => { 267 => 0x63 },
	'recommendedexposureindex' => { 104 => 0x8832, 398 => 'RecommendedExposureIndex' },
	'record' => { 103 => 'Record' },
	'recordbasisofrecord' => { 103 => [\'Record','RecordBasisOfRecord'] },
	'recordcollectioncode' => { 103 => [\'Record','RecordCollectionCode'] },
	'recordcollectionid' => { 103 => [\'Record','RecordCollectionID'] },
	'recorddatageneralizations' => { 103 => [\'Record','RecordDataGeneralizations'] },
	'recorddatasetid' => { 103 => [\'Record','RecordDatasetID'] },
	'recorddatasetname' => { 103 => [\'Record','RecordDatasetName'] },
	'recorddisplay' => { 159 => 0x4d },
	'recorddynamicproperties' => { 103 => [\'Record','RecordDynamicProperties'] },
	'recordid' => { 85 => 0x1804 },
	'recordinformationwithheld' => { 103 => [\'Record','RecordInformationWithheld'] },
	'recordingformat' => { 322 => 0x1000 },
	'recordingmode' => { 99 => 0x1, 306 => 0x1 },
	'recordinstitutioncode' => { 103 => [\'Record','RecordInstitutionCode'] },
	'recordinstitutionid' => { 103 => [\'Record','RecordInstitutionID'] },
	'recordmode' => { 30 => 0x9, 100 => 0x3000 },
	'recordownerinstitutioncode' => { 103 => [\'Record','RecordOwnerInstitutionCode'] },
	'recordshutterrelease' => { 330 => 0x217 },
	'redbalance' => { 175 => 0x270, 252 => 0x1017, 271 => 0x11, 300 => 0x1c },
	'redcurvelimits' => { 95 => 0x18a },
	'redcurvepoints' => { 94 => 0x2d, 95 => 0x160 },
	'redeyecorrection' => { 231 => 0x0 },
	'redeyeinfo' => { 393 => 'RedEyeInfo' },
	'redeyereduction' => { 159 => 0x41, 338 => 0x6a, 340 => 0x28 },
	'redhsl' => { 90 => 0x20910 },
	'redhue' => { 393 => 'RedHue' },
	'redsaturation' => { 393 => 'RedSaturation' },
	'reductionmatrix1' => { 104 => 0xc625 },
	'reductionmatrix2' => { 104 => 0xc626 },
	'reelname' => { 104 => 0xc789 },
	'reference1' => { 401 => [\'TagStructure','TagStructureReference'] },
	'reference2' => { 401 => [\'TagStructure','TagStructureSubLabelsReference'] },
	'reference3' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsReference'] },
	'reference4' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsReference'] },
	'reference5' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'reference6' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabelsReference'] },
	'referenceblackwhite' => { 104 => 0x214, 414 => 'ReferenceBlackWhite' },
	'referencedate' => { 112 => 0x2f },
	'referencenumber' => { 112 => 0x32 },
	'references' => { 135 => 'References' },
	'referenceservice' => { 112 => 0x2d },
	'regionappliedtodimensions' => { 150 => [\'Regions','RegionsAppliedToDimensions'] },
	'regionappliedtodimensionsh' => { 150 => [\'Regions','RegionsAppliedToDimensionsH'] },
	'regionappliedtodimensionsunit' => { 150 => [\'Regions','RegionsAppliedToDimensionsUnit'] },
	'regionappliedtodimensionsw' => { 150 => [\'Regions','RegionsAppliedToDimensionsW'] },
	'regionarea' => { 150 => [\'Regions','RegionsRegionListArea'] },
	'regionaread' => { 150 => [\'Regions','RegionsRegionListAreaD'] },
	'regionareah' => { 150 => [\'Regions','RegionsRegionListAreaH'] },
	'regionareaunit' => { 150 => [\'Regions','RegionsRegionListAreaUnit'] },
	'regionareaw' => { 150 => [\'Regions','RegionsRegionListAreaW'] },
	'regionareax' => { 150 => [\'Regions','RegionsRegionListAreaX'] },
	'regionareay' => { 150 => [\'Regions','RegionsRegionListAreaY'] },
	'regionbarcodevalue' => { 150 => [\'Regions','RegionsRegionListBarCodeValue'] },
	'regionconstraints' => { 406 => 'RegionConstraints' },
	'regiondescription' => { 150 => [\'Regions','RegionsRegionListDescription'] },
	'regionextensions' => { 150 => [\'Regions','RegionsRegionListExtensions'] },
	'regionfocususage' => { 150 => [\'Regions','RegionsRegionListFocusUsage'] },
	'regioninfo' => { 150 => 'Regions' },
	'regioninfodateregionsvalid' => { 151 => [\'RegionInfo','RegionInfoDateRegionsValid'] },
	'regioninfomp' => { 151 => 'RegionInfo' },
	'regioninforegions' => { 151 => [\'RegionInfo','RegionInfoRegions'] },
	'regionlist' => { 150 => [\'Regions','RegionsRegionList'] },
	'regionname' => { 150 => [\'Regions','RegionsRegionListName'] },
	'regionpersondisplayname' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonDisplayName'] },
	'regionpersonemaildigest' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonEmailDigest'] },
	'regionpersonliveidcid' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonLiveIdCID'] },
	'regionpersonsourceid' => { 151 => [\'RegionInfo','RegionInfoRegionsPersonSourceID'] },
	'regionrectangle' => { 151 => [\'RegionInfo','RegionInfoRegionsRectangle'] },
	'regionrotation' => { 150 => [\'Regions','RegionsRegionListRotation'] },
	'regionseealso' => { 150 => [\'Regions','RegionsRegionListSeeAlso'] },
	'regiontype' => { 150 => [\'Regions','RegionsRegionListType'] },
	'registryid' => { 403 => 'RegistryId' },
	'registryitemid' => { 403 => [\'RegistryId','RegistryIdRegItemId'] },
	'registryorganisationid' => { 403 => [\'RegistryId','RegistryIdRegOrgId'] },
	'relatedaudiofile' => { 133 => 'data' },
	'relatedaudiofilename' => { 133 => '1Name' },
	'relatedaudiofiletype' => { 133 => '0Type' },
	'relatedimagefileformat' => { 104 => 0x1000 },
	'relatedimageheight' => { 104 => 0x1002 },
	'relatedimagewidth' => { 104 => 0x1001 },
	'relatedresourceid' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelatedResourceID'] },
	'relatedsoundfile' => { 104 => 0xa004, 397 => 'RelatedSoundFile' },
	'relatedvideofile' => { 147 => 'data' },
	'relatedvideofilename' => { 147 => '1Name' },
	'relatedvideofiletype' => { 147 => '0Type' },
	'relation' => { 394 => 'relation' },
	'relationshipaccordingto' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipAccordingTo'] },
	'relationshipestablisheddate' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipEstablishedDate'] },
	'relationshipofresource' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipOfResource'] },
	'relationshipremarks' => { 103 => [\'ResourceRelationship','ResourceRelationshipRelationshipRemarks'] },
	'relativepeakaudiofilepath' => { 418 => 'relativePeakAudioFilePath' },
	'relativetimestamp' => { 418 => 'relativeTimestamp' },
	'relativetimestampscale' => { 418 => [\'relativeTimestamp','relativeTimestampScale'] },
	'relativetimestampvalue' => { 418 => [\'relativeTimestamp','relativeTimestampValue'] },
	'releasebuttontousedial' => { 234 => '17.8', 235 => '18.5', 240 => '33.8', 241 => '17.6', 244 => '18.5' },
	'releasedate' => { 112 => 0x1e, 418 => 'releaseDate' },
	'releasemode' => { 100 => 0x3001, 350 => 0xb049 },
	'releasemode2' => { 357 => 0x112c, 358 => [0x112c,0x8], 359 => [0x1108,0x8], 360 => [0x1184,0x8], 361 => [0x1160,0x8], 362 => [0x4,0x1018], 363 => [0x4,0x210], 364 => [0x4,0x210], 365 => [0x3f,0x4b], 366 => 0x10, 367 => 0x10, 368 => 0x9, 374 => 0x34 },
	'releasemode3' => { 357 => 0x1128, 358 => 0x1128, 359 => 0x1104, 360 => 0x1180, 361 => 0x115c, 362 => 0x1014, 363 => 0x20c, 364 => 0x20c },
	'releasesetting' => { 85 => 0x1016 },
	'releasetime' => { 112 => 0x23 },
	'remoteonduration' => { 236 => '3.4', 237 => '17.2', 238 => '18.2', 239 => '18.2', 241 => '18.2', 242 => '4.3', 245 => '19.2' },
	'renditionclass' => { 419 => 'RenditionClass' },
	'renditionof' => { 419 => 'RenditionOf' },
	'renditionofalternatepaths' => { 419 => [\'RenditionOf','RenditionOfAlternatePaths'] },
	'renditionofdocumentid' => { 419 => [\'RenditionOf','RenditionOfDocumentID'] },
	'renditionoffilepath' => { 419 => [\'RenditionOf','RenditionOfFilePath'] },
	'renditionoffrompart' => { 419 => [\'RenditionOf','RenditionOfFromPart'] },
	'renditionofinstanceid' => { 419 => [\'RenditionOf','RenditionOfInstanceID'] },
	'renditionoflastmodifydate' => { 419 => [\'RenditionOf','RenditionOfLastModifyDate'] },
	'renditionofmanager' => { 419 => [\'RenditionOf','RenditionOfManager'] },
	'renditionofmanagervariant' => { 419 => [\'RenditionOf','RenditionOfManagerVariant'] },
	'renditionofmanageto' => { 419 => [\'RenditionOf','RenditionOfManageTo'] },
	'renditionofmanageui' => { 419 => [\'RenditionOf','RenditionOfManageUI'] },
	'renditionofmaskmarkers' => { 419 => [\'RenditionOf','RenditionOfMaskMarkers'] },
	'renditionoforiginaldocumentid' => { 419 => [\'RenditionOf','RenditionOfOriginalDocumentID'] },
	'renditionofpartmapping' => { 419 => [\'RenditionOf','RenditionOfPartMapping'] },
	'renditionofrenditionclass' => { 419 => [\'RenditionOf','RenditionOfRenditionClass'] },
	'renditionofrenditionparams' => { 419 => [\'RenditionOf','RenditionOfRenditionParams'] },
	'renditionoftopart' => { 419 => [\'RenditionOf','RenditionOfToPart'] },
	'renditionofversionid' => { 419 => [\'RenditionOf','RenditionOfVersionID'] },
	'renditionparams' => { 419 => 'RenditionParams' },
	'repeatingflashcount' => { 180 => 0xd, 181 => 0xe, 182 => 0xe, 240 => '17.2', 241 => '24.2', 242 => '9.2', 243 => '24.2', 245 => '25.2' },
	'repeatingflashcountbuilt-in' => { 214 => 0x4db },
	'repeatingflashcountexternal' => { 214 => 0x4c3 },
	'repeatingflashoutput' => { 240 => '17.1', 241 => '24.1', 242 => '9.1', 243 => '24.1', 245 => '25.1' },
	'repeatingflashoutputexternal' => { 214 => 0x4c0 },
	'repeatingflashrate' => { 180 => 0xc, 181 => 0xd, 182 => 0xd, 240 => '18.1', 241 => '25.1', 242 => '10.1', 243 => '25.1', 245 => '26.1' },
	'repeatingflashratebuilt-in' => { 214 => 0x4da },
	'repeatingflashrateexternal' => { 214 => 0x4c2 },
	'requires' => { 390 => 'requires' },
	'resampleparams' => { 418 => 'resampleParams' },
	'resampleparamsquality' => { 418 => [\'resampleParams','resampleParamsQuality'] },
	'resaved' => { 330 => 0x21e },
	'resolution' => { 140 => 'Resolution' },
	'resolutionmode' => { 331 => 0x4 },
	'resolutionunit' => { 104 => 0x128, 115 => 0x2, 414 => 'ResolutionUnit' },
	'resourceid' => { 103 => [\'ResourceRelationship','ResourceRelationshipResourceID'] },
	'resourcerelationship' => { 103 => 'ResourceRelationship' },
	'resourcerelationshipid' => { 103 => [\'ResourceRelationship','ResourceRelationshipResourceRelationshipID'] },
	'restrictdrivemodes' => { 72 => 0x612 },
	'restrictions' => { 411 => 'restrictions' },
	'retouchareafeather' => { 393 => [\'RetouchAreas','RetouchAreasFeather'] },
	'retouchareamaskalpha' => { 393 => [\'RetouchAreas','RetouchAreasMasksAlpha'] },
	'retouchareamaskangle' => { 393 => [\'RetouchAreas','RetouchAreasMasksAngle'] },
	'retouchareamaskbottom' => { 393 => [\'RetouchAreas','RetouchAreasMasksBottom'] },
	'retouchareamaskcentervalue' => { 393 => [\'RetouchAreas','RetouchAreasMasksCenterValue'] },
	'retouchareamaskcenterweight' => { 393 => [\'RetouchAreas','RetouchAreasMasksCenterWeight'] },
	'retouchareamaskdabs' => { 393 => [\'RetouchAreas','RetouchAreasMasksDabs'] },
	'retouchareamaskfeather' => { 393 => [\'RetouchAreas','RetouchAreasMasksFeather'] },
	'retouchareamaskflipped' => { 393 => [\'RetouchAreas','RetouchAreasMasksFlipped'] },
	'retouchareamaskflow' => { 393 => [\'RetouchAreas','RetouchAreasMasksFlow'] },
	'retouchareamaskfullx' => { 393 => [\'RetouchAreas','RetouchAreasMasksFullX'] },
	'retouchareamaskfully' => { 393 => [\'RetouchAreas','RetouchAreasMasksFullY'] },
	'retouchareamaskleft' => { 393 => [\'RetouchAreas','RetouchAreasMasksLeft'] },
	'retouchareamaskmidpoint' => { 393 => [\'RetouchAreas','RetouchAreasMasksMidpoint'] },
	'retouchareamaskperimetervalue' => { 393 => [\'RetouchAreas','RetouchAreasMasksPerimeterValue'] },
	'retouchareamaskradius' => { 393 => [\'RetouchAreas','RetouchAreasMasksRadius'] },
	'retouchareamaskright' => { 393 => [\'RetouchAreas','RetouchAreasMasksRight'] },
	'retouchareamaskroundness' => { 393 => [\'RetouchAreas','RetouchAreasMasksRoundness'] },
	'retouchareamasks' => { 393 => [\'RetouchAreas','RetouchAreasMasks'] },
	'retouchareamasksizex' => { 393 => [\'RetouchAreas','RetouchAreasMasksSizeX'] },
	'retouchareamasksizey' => { 393 => [\'RetouchAreas','RetouchAreasMasksSizeY'] },
	'retouchareamasktop' => { 393 => [\'RetouchAreas','RetouchAreasMasksTop'] },
	'retouchareamaskvalue' => { 393 => [\'RetouchAreas','RetouchAreasMasksMaskValue'] },
	'retouchareamaskversion' => { 393 => [\'RetouchAreas','RetouchAreasMasksVersion'] },
	'retouchareamaskwhat' => { 393 => [\'RetouchAreas','RetouchAreasMasksWhat'] },
	'retouchareamaskx' => { 393 => [\'RetouchAreas','RetouchAreasMasksX'] },
	'retouchareamasky' => { 393 => [\'RetouchAreas','RetouchAreasMasksY'] },
	'retouchareamaskzerox' => { 393 => [\'RetouchAreas','RetouchAreasMasksZeroX'] },
	'retouchareamaskzeroy' => { 393 => [\'RetouchAreas','RetouchAreasMasksZeroY'] },
	'retouchareamethod' => { 393 => [\'RetouchAreas','RetouchAreasMethod'] },
	'retouchareaoffsety' => { 393 => [\'RetouchAreas','RetouchAreasOffsetY'] },
	'retouchareaopacity' => { 393 => [\'RetouchAreas','RetouchAreasOpacity'] },
	'retouchareas' => { 393 => 'RetouchAreas' },
	'retouchareaseed' => { 393 => [\'RetouchAreas','RetouchAreasSeed'] },
	'retouchareasourcestate' => { 393 => [\'RetouchAreas','RetouchAreasSourceState'] },
	'retouchareasourcex' => { 393 => [\'RetouchAreas','RetouchAreasSourceX'] },
	'retouchareaspottype' => { 393 => [\'RetouchAreas','RetouchAreasSpotType'] },
	'retouchhistory' => { 191 => 0x9e },
	'retouchinfo' => { 393 => 'RetouchInfo' },
	'retouchnefprocessing' => { 196 => 0x5 },
	'reuse' => { 406 => 'Reuse' },
	'reuseallowed' => { 421 => 'ReuseAllowed' },
	'reuseprohibited' => { 411 => 'reuseProhibited' },
	'reverseexposurecompdial' => { 239 => '5.2' },
	'reverseindicators' => { 234 => '12.1', 235 => '6.1', 237 => '4.3', 238 => '5.2', 239 => '5.4', 240 => '33.5', 241 => '5.1', 244 => '6.1', 245 => '6.2' },
	'reverseshutterspeedaperture' => { 239 => '5.3' },
	'revision' => { 395 => 'revision' },
	'rgbcurvelimits' => { 95 => 0x238 },
	'rgbcurvepoints' => { 94 => 0x7, 95 => 0x20e },
	'richtextcomment' => { 400 => 'RichTextComment' },
	'ricohdate' => { 321 => 0x6 },
	'ricohimageheight' => { 321 => 0x2 },
	'ricohimagewidth' => { 321 => 0x0 },
	'rightascension' => { 143 => 'RightAscension' },
	'rights' => { 394 => 'rights' },
	'rightsagent' => { 411 => 'rightsAgent' },
	'rightsowner' => { 411 => 'rightsOwner' },
	'rollangle' => { 207 => 0x350b, 247 => 0x903, 267 => 0x90, 299 => 0x1 },
	'romoperationmode' => { 85 => 0x80d },
	'rotation' => { 27 => 0x17, 28 => 0x18, 84 => 0x3, 90 => 0x10002, 95 => 0x26e, 108 => 0x4, 143 => 'Rotation', 157 => [0x65,0x50], 158 => 0x46, 159 => 0x5a, 162 => 0x10, 213 => '590.1', 227 => 0x76a43207, 267 => 0x30, 281 => '17.2', 308 => 0xd8, 338 => 0x3f, 339 => 0x3f, 349 => 0x10 },
	'routedto' => { 399 => 'RoutedTo' },
	'routing' => { 313 => 'Routing' },
	'routingnotes' => { 399 => 'RoutingNotes' },
	'rowsperstrip' => { 104 => 0x116 },
	'rpp' => { 387 => 'rpp' },
	'safetyshift' => { 72 => 0x108 },
	'safetyshiftinavortv' => { 70 => 0x10, 71 => 0x10, 73 => 0xf, 74 => 0x10, 77 => 0x10 },
	'samplebits' => { 133 => 'SampleBits' },
	'samplepagerange' => { 408 => 'samplePageRange' },
	'samplerate' => { 133 => 'SampleRate' },
	'samplesperpixel' => { 104 => 0x115, 414 => 'SamplesPerPixel' },
	'samplestructure' => { 114 => 0x5a },
	'samsungmodelid' => { 328 => 0x3 },
	'sanyoquality' => { 330 => 0x201 },
	'sanyothumbnail' => { 330 => 0x100 },
	'saturation' => { 9 => 0x6e, 11 => 0x76, 30 => 0xe, 42 => 0x1, 99 => 0xd, 100 => [0x3013,0x1f], 104 => [0xa409,0xfe55], 109 => 0x1003, 134 => 'Saturation', 156 => 0x1f, 157 => 0x32, 158 => 0x28, 159 => 0x1a, 164 => 0x1, 191 => [0x94,0xaa], 193 => 0x35, 267 => 0x40, 269 => 0x300d, 300 => 0x1f, 306 => 0xd, 318 => 0x27, 321 => 0x28, 322 => 0x1013, 331 => 0x10, 338 => 0x1e, 339 => 0x1b, 350 => 0x2005, 393 => 'Saturation', 397 => 'Saturation' },
	'saturationadj' => { 90 => 0x20901, 95 => 0x116, 226 => 0x1, 230 => 0x2e, 378 => 0x8016 },
	'saturationadjustmentaqua' => { 393 => 'SaturationAdjustmentAqua' },
	'saturationadjustmentblue' => { 393 => 'SaturationAdjustmentBlue' },
	'saturationadjustmentgreen' => { 393 => 'SaturationAdjustmentGreen' },
	'saturationadjustmentmagenta' => { 393 => 'SaturationAdjustmentMagenta' },
	'saturationadjustmentorange' => { 393 => 'SaturationAdjustmentOrange' },
	'saturationadjustmentpurple' => { 393 => 'SaturationAdjustmentPurple' },
	'saturationadjustmentred' => { 393 => 'SaturationAdjustmentRed' },
	'saturationadjustmentyellow' => { 393 => 'SaturationAdjustmentYellow' },
	'saturationauto' => { 61 => 0x98 },
	'saturationfaithful' => { 18 => 0xfe, 60 => 0x68, 61 => 0x68 },
	'saturationlandscape' => { 18 => 0xfc, 60 => 0x38, 61 => 0x38 },
	'saturationmonochrome' => { 60 => 0x80, 61 => 0x80 },
	'saturationneutral' => { 18 => 0xfd, 60 => 0x50, 61 => 0x50 },
	'saturationportrait' => { 18 => 0xfb, 60 => 0x20, 61 => 0x20 },
	'saturationsetting' => { 255 => 0x1010, 340 => 0x11, 354 => 0x9 },
	'saturationstandard' => { 18 => 0xfa, 60 => 0x8, 61 => 0x8 },
	'saturationuserdef1' => { 18 => 0x100, 60 => 0x98, 61 => 0xb0 },
	'saturationuserdef2' => { 18 => 0x101, 60 => 0xb0, 61 => 0xc8 },
	'saturationuserdef3' => { 18 => 0x102, 60 => 0xc8, 61 => 0xe0 },
	'saveid' => { 419 => 'SaveID' },
	'scaletype' => { 418 => 'scaleType' },
	'scanimageenhancer' => { 197 => 0x60 },
	'scanningdirection' => { 114 => 0x64 },
	'scene' => { 402 => 'Scene', 418 => 'scene' },
	'scenearea' => { 250 => 0x211, 252 => 0x1031 },
	'sceneassist' => { 191 => 0x9c },
	'scenecapturetype' => { 104 => 0xa406, 397 => 'SceneCaptureType' },
	'scenedetect' => { 250 => 0x210, 252 => 0x1030 },
	'scenedetectdata' => { 250 => 0x212, 252 => 0x1033 },
	'scenemode' => { 122 => 0xfa02, 161 => 0x100, 191 => 0x8f, 247 => 0x509, 252 => 0x403, 267 => 0x8001, 275 => 0xf, 350 => 0xb023 },
	'scenemodeused' => { 124 => [0x6002,0xf002] },
	'sceneselect' => { 330 => 0x21f },
	'scenetype' => { 104 => 0xa301, 397 => 'SceneType' },
	'screentips' => { 234 => '12.7', 235 => '5.3', 240 => '13.1', 241 => '4.4', 244 => '5.4', 245 => '5.1' },
	'season' => { 407 => 'season' },
	'section' => { 408 => 'section' },
	'securityclassification' => { 104 => 0x9212 },
	'selectableafpoint' => { 72 => 0x509 },
	'selectafareaselectmode' => { 72 => 0x512 },
	'selftimer' => { 30 => 0x2, 267 => 0x2e, 330 => 0x214 },
	'selftimer2' => { 66 => 0x1d },
	'selftimerinterval' => { 241 => '19.2' },
	'selftimermode' => { 104 => 0x882b },
	'selftimershotcount' => { 235 => '20.2', 237 => '18.2', 238 => '19.2', 239 => '19.2', 241 => '19.3', 244 => '20.3', 245 => '20.2' },
	'selftimershotinterval' => { 235 => '20.3', 244 => '20.2' },
	'selftimertime' => { 85 => 0x1806, 159 => 0x1f, 234 => '18.1', 235 => '20.1', 236 => '3.3', 237 => '18.1', 238 => '19.1', 239 => '19.1', 240 => '7.2', 241 => '19.1', 242 => '3.3', 244 => '20.1', 245 => '20.1' },
	'sellingagency' => { 408 => 'sellingAgency' },
	'seminfo' => { 104 => 0x8546 },
	'sensingmethod' => { 104 => 0xa217, 397 => 'SensingMethod' },
	'sensitivityadjust' => { 300 => 0x40 },
	'sensitivitysteps' => { 281 => ['14.3','17.4'], 283 => 0x1 },
	'sensitivitytype' => { 104 => 0x8830, 398 => 'SensitivityType' },
	'sensorareas' => { 328 => 0xa010 },
	'sensorbitdepth' => { 269 => 0x312d },
	'sensorbluelevel' => { 64 => 0x5 },
	'sensorcalibration' => { 251 => 0x805 },
	'sensorcleaning' => { 78 => 0xd },
	'sensorfullheight' => { 117 => 0xf904 },
	'sensorfullwidth' => { 117 => 0xf903 },
	'sensorheight' => { 117 => 0xf901, 122 => 0xfa21, 163 => 0x8, 269 => 0x312c, 322 => 0x1602 },
	'sensorpixelsize' => { 191 => 0x9a },
	'sensorredlevel' => { 64 => 0x4 },
	'sensorserialnumber' => { 118 => 0x9ce },
	'sensorsize' => { 134 => 'SensorSize', 300 => 0x35 },
	'sensortemperature' => { 250 => 0x1500, 252 => 0x1007, 331 => [0x39,0x55] },
	'sensorwidth' => { 117 => 0xf900, 122 => 0xfa20, 163 => 0xa, 269 => 0x312b, 322 => 0x1601 },
	'sequence' => { 318 => 0x7 },
	'sequencefilenumber' => { 358 => 0x4, 359 => 0x4, 360 => 0x4, 361 => 0x4, 366 => 0xc, 367 => 0xc, 368 => 0x1a },
	'sequenceimagenumber' => { 358 => 0x0, 359 => 0x0, 360 => 0x0, 361 => 0x0, 366 => 0x8, 367 => 0x8, 368 => 0x12, 374 => 0x24 },
	'sequencelength' => { 366 => 0x22, 367 => 0x1e, 368 => [0x16,0x1e] },
	'sequencename' => { 407 => 'sequenceName' },
	'sequencenumber' => { 66 => 0x9, 100 => 0x301c, 109 => 0x1101, 120 => 0x1d, 214 => 0x51c, 267 => 0x2b, 340 => [0x10c,0x30c], 350 => 0xb04a, 407 => 'sequenceNumber' },
	'sequenceshotinterval' => { 330 => 0x224 },
	'sequencetotalnumber' => { 407 => 'sequenceTotalNumber' },
	'sequentialshot' => { 330 => 0x20e },
	'serialnumber' => { 54 => 0xc, 85 => 0x180b, 104 => [0xa431,0xfde9], 117 => 0xfa04, 119 => 0xfa00, 121 => 0xc354, 122 => 0xfa19, 131 => 0x0, 134 => 'SerialNumber', 191 => [0xa0,0x1d], 248 => 0x101, 252 => [0x404,0x101a], 263 => 0x303, 269 => 0x3103, 300 => 0x229, 318 => 0x15, 322 => 0x5, 331 => 0x2, 389 => 'SerialNumber', 398 => 'BodySerialNumber' },
	'serialnumberformat' => { 54 => 0x15, 85 => 0x183b },
	'seriesdatetime' => { 380 => 'SeriesDateTime' },
	'seriesdescription' => { 380 => 'SeriesDescription' },
	'seriesmodality' => { 380 => 'SeriesModality' },
	'seriesnumber' => { 380 => 'SeriesNumber', 408 => 'seriesNumber' },
	'seriestitle' => { 408 => 'seriesTitle' },
	'serviceidentifier' => { 113 => 0x1e },
	'servingsize' => { 410 => 'servingSize' },
	'setbuttoncrosskeysfunc' => { 75 => 0x0, 76 => 0x0 },
	'setbuttonwhenshooting' => { 70 => 0x1, 72 => 0x704, 78 => 0xc },
	'setfunctionwhenshooting' => { 73 => 0x0, 74 => 0x1, 77 => 0x1 },
	'setting' => { 407 => 'setting' },
	'shadingcompensation' => { 247 => 0x50c, 267 => 0x8a },
	'shadingcompensation2' => { 251 => 0x1012 },
	'shadow' => { 331 => 0xe },
	'shadowadj' => { 90 => 0x2030b },
	'shadowcorrection' => { 300 => 0x79 },
	'shadowprotection' => { 226 => 0x0 },
	'shadows' => { 104 => 0xfe52, 386 => 'Shadows', 393 => 'Shadows' },
	'shadows2012' => { 393 => 'Shadows2012' },
	'shadowscale' => { 104 => 0xc633 },
	'shadowtint' => { 393 => 'ShadowTint' },
	'shadowtone' => { 109 => 0x1040 },
	'shakereduction' => { 301 => 0x1, 302 => 0x1 },
	'sharpendetail' => { 393 => 'SharpenDetail' },
	'sharpenedgemasking' => { 393 => 'SharpenEdgeMasking' },
	'sharpening' => { 269 => 0x300b },
	'sharpeningadj' => { 230 => 0x2b },
	'sharpenradius' => { 393 => 'SharpenRadius' },
	'sharpness' => { 7 => [0x42,0x48], 9 => 0x72, 11 => 0x74, 30 => 0xf, 64 => 0x2, 99 => 0xb, 100 => [0x3011,0x21], 104 => [0xa40a,0xfe56], 109 => 0x1001, 120 => 0x6b, 129 => 0x37, 134 => 'Sharpness', 156 => 0x21, 157 => 0x30, 158 => 0x26, 159 => 0x18, 164 => 0x3, 191 => 0x6, 193 => 0x32, 252 => 0x100f, 267 => 0x41, 300 => 0x21, 306 => 0xb, 318 => 0x26, 321 => 0x22, 322 => [0x1003,0x1014], 331 => 0x11, 338 => 0x1c, 339 => 0x19, 350 => 0x2006, 374 => 0x52, 393 => 'Sharpness', 397 => 'Sharpness' },
	'sharpnessadj' => { 90 => 0x20310, 95 => 0x25a, 378 => 0x801a },
	'sharpnessadjon' => { 90 => '0x20310.0' },
	'sharpnessauto' => { 61 => 0x94 },
	'sharpnessfactor' => { 252 => 0x102a },
	'sharpnessfaithful' => { 18 => 0xf5, 60 => 0x64, 61 => 0x64 },
	'sharpnessfrequency' => { 7 => [0x41,0x47], 64 => 0x3 },
	'sharpnesslandscape' => { 18 => 0xf3, 60 => 0x34, 61 => 0x34 },
	'sharpnessmonochrome' => { 18 => 0xf6, 60 => 0x7c, 61 => 0x7c },
	'sharpnessneutral' => { 18 => 0xf4, 60 => 0x4c, 61 => 0x4c },
	'sharpnessovershoot' => { 378 => 0x801b },
	'sharpnessportrait' => { 18 => 0xf2, 60 => 0x1c, 61 => 0x1c },
	'sharpnesssetting' => { 247 => 0x506, 255 => 0x1013, 340 => 0x12, 354 => 0xa },
	'sharpnessstandard' => { 18 => 0xf1, 60 => 0x4, 61 => 0x4 },
	'sharpnessstrength' => { 90 => 0x20311 },
	'sharpnessthreshold' => { 378 => 0x801d },
	'sharpnessundershoot' => { 378 => 0x801c },
	'sharpnessuserdef1' => { 18 => 0xf7, 60 => 0x94, 61 => 0xac },
	'sharpnessuserdef2' => { 18 => 0xf8, 60 => 0xac, 61 => 0xc4 },
	'sharpnessuserdef3' => { 18 => 0xf9, 60 => 0xc4, 61 => 0xdc },
	'shootid' => { 407 => 'shootID' },
	'shootingdistance' => { 90 => 0x20701 },
	'shootinginfodisplay' => { 234 => '13.2', 235 => '5.1', 240 => '10.2', 241 => '4.1', 244 => '5.1', 245 => '5.3' },
	'shootinginfomonitorofftime' => { 234 => '26.2', 235 => '22.2', 240 => '9.1', 241 => '21.2', 244 => '22.2', 245 => '22.2' },
	'shootingmode' => { 134 => 'ShootingMode', 191 => 0x89, 267 => 0x1f },
	'shootingmodesetting' => { 236 => '5.1' },
	'shortdescription' => { 395 => 'shortdescription' },
	'shortdocumentid' => { 112 => 0xba },
	'shortownername' => { 18 => 0xac },
	'shortreleasetimelag' => { 72 => 0x80d },
	'shotdate' => { 418 => 'shotDate' },
	'shotday' => { 418 => 'shotDay' },
	'shotlocation' => { 418 => 'shotLocation' },
	'shotname' => { 418 => 'shotName' },
	'shotnumber' => { 418 => 'shotNumber' },
	'shotnumbersincepowerup' => { 353 => 0x44e, 366 => 0x1a, 367 => 0x16, 368 => 0xa },
	'shotnumbersincepowerup2' => { 340 => 0x200 },
	'shotsize' => { 418 => 'shotSize' },
	'shutter-aelock' => { 70 => 0x4, 72 => 0x701, 73 => 0x3, 74 => 0x4, 75 => 0x3, 76 => 0x3, 77 => 0x4, 78 => 0x2 },
	'shutteraelbutton' => { 71 => 0x4 },
	'shutterbuttonafonbutton' => { 72 => 0x701 },
	'shuttercount' => { 10 => 0x176, 48 => 0x1, 191 => 0xa7, 198 => [0x6a,0x157,0x24d], 199 => 0x286, 200 => 0x279, 201 => 0x284, 202 => 0x242, 203 => 0x280, 204 => 0x276, 205 => [0x27d,0x27f], 206 => 0x246, 208 => 0x2d6, 209 => 0x321, 210 => 0xbd8, 211 => 0x287, 212 => 0x320, 213 => 0x24a, 214 => 0x5fb, 216 => 0x2d5, 300 => 0x5d, 349 => 0x846, 352 => [0x125,0x14a] },
	'shuttercurtainsync' => { 70 => 0xf, 71 => 0xf, 72 => 0x305, 73 => 0xe, 74 => 0xf, 75 => 0x8, 76 => 0x8, 77 => 0xf, 78 => 0x8 },
	'shuttermode' => { 120 => 0x1b },
	'shutterreleasebuttonae-l' => { 234 => '17.7', 235 => '18.4', 237 => '16.1', 238 => '17.1', 239 => '17.1', 240 => '7.1', 241 => '17.5', 244 => '18.4', 245 => '18.2' },
	'shutterreleasemethod' => { 85 => 0x1010 },
	'shutterreleasenocfcard' => { 70 => 0x2, 71 => 0x2, 78 => 0xf },
	'shutterreleasetiming' => { 85 => 0x1011 },
	'shutterreleasewithoutlens' => { 72 => 0x711 },
	'shutterspeedlock' => { 235 => '38.1', 244 => '38.1' },
	'shutterspeedrange' => { 72 => 0x10c },
	'shutterspeedsetting' => { 159 => 0x6, 338 => 0x2f, 339 => 0x28, 340 => 0x0 },
	'shutterspeedvalue' => { 81 => 0x1, 104 => 0x9201, 252 => 0x1000, 397 => 'ShutterSpeedValue' },
	'shuttertype' => { 109 => 0x1050, 267 => 0x9f },
	'sidecarforextension' => { 405 => 'SidecarForExtension' },
	'similarityindex' => { 112 => 0xe4 },
	'singleframebracketing' => { 159 => 0x21 },
	'skilllevel' => { 410 => 'skillLevel' },
	'slaveflashmeteringsegments' => { 300 => 0x20b },
	'slideshowname' => { 407 => 'slideshowName' },
	'slideshownumber' => { 407 => 'slideshowNumber' },
	'slideshowtotalnumber' => { 407 => 'slideshowTotalNumber' },
	'slowshutter' => { 66 => 0x8 },
	'slowsync' => { 109 => 0x1030 },
	'smartrange' => { 328 => 0xa012 },
	'smileshutter' => { 340 => 0x31 },
	'smileshuttermode' => { 340 => 0x27 },
	'smoothness' => { 104 => 0xfe57, 393 => 'Smoothness' },
	'softskineffect' => { 350 => 0x200f },
	'software' => { 104 => 0x131, 135 => 'Software', 259 => 'Software', 331 => 0x18, 414 => 'Software' },
	'softwareversion' => { 330 => 0x207 },
	'sonydatetime' => { 356 => 0x6, 358 => 0x1b6, 359 => 0x210, 360 => 0x1fe, 361 => 0x22c },
	'sonydatetime2' => { 365 => [0x51,0x5d] },
	'sonyexposuretime' => { 365 => 0x46 },
	'sonyexposuretime2' => { 374 => 0xe },
	'sonyfnumber' => { 365 => [0x3c,0x48], 374 => 0x14 },
	'sonyimageheight' => { 356 => 0x1a, 366 => 0x44, 367 => 0x3f, 368 => 0x47 },
	'sonyimagesize' => { 159 => 0x3b, 338 => 0x54, 339 => 0x54, 340 => 0x9 },
	'sonyimagewidth' => { 356 => 0x1c },
	'sonyiso' => { 358 => 0x1218, 359 => 0x11f4, 360 => 0x1270, 361 => [0x1254,0x1258,0x1280], 362 => 0x113c, 363 => 0x344, 364 => 0x346, 374 => 0x4 },
	'sonymaxaperturevalue' => { 374 => 0x16 },
	'sonymodelid' => { 350 => 0xb001 },
	'sonyquality' => { 159 => 0x3c },
	'source' => { 112 => 0x73, 259 => 'Source', 394 => 'source', 395 => 'source', 405 => 'Source' },
	'sourcedirectoryindex' => { 287 => 0x0 },
	'sourcefileindex' => { 287 => 0x2 },
	'sourcephotoscount' => { 382 => 'SourcePhotosCount' },
	'spatialfrequencyresponse' => { 397 => 'SpatialFrequencyResponse' },
	'spatialfrequencyresponsecolumns' => { 397 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseColumns'] },
	'spatialfrequencyresponsenames' => { 397 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseNames'] },
	'spatialfrequencyresponserows' => { 397 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseRows'] },
	'spatialfrequencyresponsevalues' => { 397 => [\'SpatialFrequencyResponse','SpatialFrequencyResponseValues'] },
	'speakerplacement' => { 418 => 'speakerPlacement' },
	'specialeffectlevel' => { 100 => 0x3030 },
	'specialeffectmode' => { 100 => 0x2076 },
	'specialeffectsetting' => { 100 => 0x3031 },
	'specialinstructions' => { 112 => 0x28 },
	'specialmode' => { 252 => 0x200, 330 => 0x200 },
	'specialoccasion' => { 410 => 'specialOccasion' },
	'spectralsensitivity' => { 104 => 0x8824, 397 => 'SpectralSensitivity' },
	'specularwhitelevel' => { 37 => [0x2b9,0x2d0,0x2d4], 39 => 0x1e4, 40 => [0x1fd,0x2dd], 41 => 0x30f },
	'splittoningbalance' => { 393 => 'SplitToningBalance' },
	'splittoninghighlighthue' => { 393 => 'SplitToningHighlightHue' },
	'splittoninghighlightsaturation' => { 393 => 'SplitToningHighlightSaturation' },
	'splittoningshadowhue' => { 393 => 'SplitToningShadowHue' },
	'splittoningshadowsaturation' => { 393 => 'SplitToningShadowSaturation' },
	'sport' => { 408 => 'sport' },
	'spotfocuspointx' => { 156 => 0x2d },
	'spotfocuspointy' => { 156 => 0x2e },
	'spotmeteringmode' => { 30 => 0x27 },
	'spotmeterlinktoafpoint' => { 72 => 0x107 },
	'sractive' => { 281 => '17.1' },
	'srawquality' => { 30 => 0x2e },
	'srfocallength' => { 301 => 0x3 },
	'srhalfpresstime' => { 301 => 0x2 },
	'srresult' => { 301 => 0x0, 302 => 0x0 },
	'standardoutputhighlightpoint' => { 96 => 0x14 },
	'standardoutputsensitivity' => { 104 => 0x8831, 398 => 'StandardOutputSensitivity' },
	'standardoutputshadowpoint' => { 96 => 0x15 },
	'standardrawcolortone' => { 96 => 0xd },
	'standardrawcontrast' => { 96 => 0xf },
	'standardrawhighlight' => { 96 => 0x75 },
	'standardrawhighlightpoint' => { 96 => 0x12 },
	'standardrawlinear' => { 96 => 0x10 },
	'standardrawsaturation' => { 96 => 0xe },
	'standardrawshadow' => { 96 => 0x7e },
	'standardrawshadowpoint' => { 96 => 0x13 },
	'standardrawsharpness' => { 96 => 0x11 },
	'standardunsharpmaskfineness' => { 96 => 0x94 },
	'standardunsharpmaskstrength' => { 96 => 0x92 },
	'standardunsharpmaskthreshold' => { 96 => 0x96 },
	'standbytimer' => { 235 => '19.1', 239 => '18.1', 244 => '19.1' },
	'startingpage' => { 408 => 'startingPage' },
	'startmovieshooting' => { 72 => 0x70d },
	'starttimecode' => { 418 => 'startTimecode' },
	'starttimecodetimeformat' => { 418 => [\'startTimecode','startTimecodeTimeFormat'] },
	'starttimecodetimevalue' => { 418 => [\'startTimecode','startTimecodeTimeValue'] },
	'starttimecodevalue' => { 418 => [\'startTimecode','startTimecodeValue'] },
	'starttimesamplesize' => { 418 => 'startTimeSampleSize' },
	'starttimescale' => { 418 => 'startTimeScale' },
	'state' => { 139 => 'State', 267 => 0x6b, 405 => 'State' },
	'status' => { 381 => 'Status', 385 => 'Status' },
	'stitchingsoftware' => { 382 => 'StitchingSoftware' },
	'stopsabovebaseiso' => { 357 => 0x113e, 358 => 0x113e, 359 => 0x111a, 360 => 0x1196, 361 => 0x1172, 362 => 0x102a, 363 => 0x222, 364 => 0x222, 374 => 0xa },
	'storagemethod' => { 163 => 0x12 },
	'storebyorientation' => { 235 => '46.3', 244 => '47.3' },
	'straightenangle' => { 227 => 0x2fc08431 },
	'stretchmode' => { 418 => 'stretchMode' },
	'studydatetime' => { 380 => 'StudyDateTime' },
	'studydescription' => { 380 => 'StudyDescription' },
	'studyid' => { 380 => 'StudyID' },
	'studyphysician' => { 380 => 'StudyPhysician' },
	'sub-location' => { 112 => 0x5c },
	'subfiledata' => { 142 => 'data' },
	'subfiledirectory' => { 142 => '1Directory' },
	'subfilemimetype' => { 142 => '2MIME' },
	'subfilename' => { 142 => '1Name' },
	'subfileresource' => { 142 => 'rsrc' },
	'subfiletype' => { 104 => 0xfe, 142 => '0Type' },
	'subject' => { 256 => 'Subject', 313 => 'Subject', 394 => 'subject', 404 => 'Subject', 419 => 'subject' },
	'subjectarea' => { 104 => 0x9214, 397 => 'SubjectArea' },
	'subjectcode' => { 402 => 'SubjectCode' },
	'subjectdistance' => { 104 => 0x9206, 120 => 0x3e, 397 => 'SubjectDistance' },
	'subjectdistancerange' => { 104 => 0xa40c, 397 => 'SubjectDistanceRange' },
	'subjectlocation' => { 104 => 0xa214, 397 => 'SubjectLocation' },
	'subjectprogram' => { 156 => 0x22 },
	'subjectreference' => { 112 => 0xc },
	'sublabels4' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublabels5' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabelsSubLabelsSubLabels'] },
	'sublables1' => { 401 => [\'TagStructure','TagStructureSubLabels'] },
	'sublables2' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabels'] },
	'sublables3' => { 401 => [\'TagStructure','TagStructureSubLabelsSubLabelsSubLabels'] },
	'subsectime' => { 104 => 0x9290 },
	'subsectimedigitized' => { 104 => 0x9292 },
	'subsectimeoriginal' => { 104 => 0x9291 },
	'subsection1' => { 408 => 'subsection1' },
	'subsection2' => { 408 => 'subsection2' },
	'subsection3' => { 408 => 'subsection3' },
	'subsection4' => { 408 => 'subsection4' },
	'subselector' => { 235 => '49.1' },
	'subselectorassignment' => { 235 => '48.1' },
	'subselectorplusdials' => { 235 => '49.2' },
	'subtitle' => { 408 => 'subtitle' },
	'subversionfilename' => { 401 => [\'SubVersions','SubVersionsFileName'] },
	'subversionreference' => { 401 => [\'SubVersions','SubVersionsVersRef'] },
	'subversions' => { 401 => 'SubVersions' },
	'superimposeddisplay' => { 70 => 0xa, 72 => 0x510, 73 => 0x9, 74 => 0xa, 77 => 0xa, 78 => 0xe },
	'supermacro' => { 54 => 0x1a },
	'supplementalcategories' => { 112 => 0x14, 405 => 'SupplementalCategories' },
	'supplementaltype' => { 114 => 0x37 },
	'supplementdisplayid' => { 408 => 'supplementDisplayID' },
	'supplementstartingpage' => { 408 => 'supplementStartingPage' },
	'supplementtitle' => { 408 => 'supplementTitle' },
	'svisosetting' => { 281 => 0x14 },
	'sweeppanoramadirection' => { 267 => 0x93, 340 => 0x33 },
	'sweeppanoramafieldofview' => { 267 => 0x94 },
	'sweeppanoramasize' => { 340 => 0x32 },
	'switchtoregisteredafpoint' => { 71 => 0x12, 72 => 0x50a },
	'tagged' => { 308 => 0xdd, 309 => 'Tagged', 387 => 'tagged' },
	'tagslist' => { 396 => 'TagsList' },
	'tagstructure' => { 401 => 'TagStructure' },
	'takenumber' => { 418 => 'takeNumber' },
	'tapename' => { 418 => 'tapeName' },
	'targetaperture' => { 66 => 0x4 },
	'targetcompressionratio' => { 83 => 0x1 },
	'targetdistancesetting' => { 85 => 0x1807 },
	'targetexposuretime' => { 66 => 0x5 },
	'targetimagetype' => { 85 => 0x100a },
	'taxon' => { 103 => 'Taxon' },
	'taxonacceptednameusage' => { 103 => [\'Taxon','TaxonAcceptedNameUsage'] },
	'taxonacceptednameusageid' => { 103 => [\'Taxon','TaxonAcceptedNameUsageID'] },
	'taxonclass' => { 103 => [\'Taxon','TaxonClass'] },
	'taxonconceptid' => { 103 => [\'Taxon','TaxonTaxonConceptID'] },
	'taxonfamily' => { 103 => [\'Taxon','TaxonFamily'] },
	'taxongenus' => { 103 => [\'Taxon','TaxonGenus'] },
	'taxonhigherclassification' => { 103 => [\'Taxon','TaxonHigherClassification'] },
	'taxonid' => { 103 => [\'Taxon','TaxonTaxonID'] },
	'taxoninfraspecificepithet' => { 103 => [\'Taxon','TaxonInfraspecificEpithet'] },
	'taxonkingdom' => { 103 => [\'Taxon','TaxonKingdom'] },
	'taxonnameaccordingto' => { 103 => [\'Taxon','TaxonNameAccordingTo'] },
	'taxonnameaccordingtoid' => { 103 => [\'Taxon','TaxonNameAccordingToID'] },
	'taxonnamepublishedin' => { 103 => [\'Taxon','TaxonNamePublishedIn'] },
	'taxonnamepublishedinid' => { 103 => [\'Taxon','TaxonNamePublishedInID'] },
	'taxonnamepublishedinyear' => { 103 => [\'Taxon','TaxonNamePublishedInYear'] },
	'taxonnomenclaturalcode' => { 103 => [\'Taxon','TaxonNomenclaturalCode'] },
	'taxonnomenclaturalstatus' => { 103 => [\'Taxon','TaxonNomenclaturalStatus'] },
	'taxonorder' => { 103 => [\'Taxon','TaxonOrder'] },
	'taxonoriginalnameusage' => { 103 => [\'Taxon','TaxonOriginalNameUsage'] },
	'taxonoriginalnameusageid' => { 103 => [\'Taxon','TaxonOriginalNameUsageID'] },
	'taxonparentnameusage' => { 103 => [\'Taxon','TaxonParentNameUsage'] },
	'taxonparentnameusageid' => { 103 => [\'Taxon','TaxonParentNameUsageID'] },
	'taxonphylum' => { 103 => [\'Taxon','TaxonPhylum'] },
	'taxonrank' => { 103 => [\'Taxon','TaxonTaxonRank'] },
	'taxonremarks' => { 103 => [\'Taxon','TaxonTaxonRemarks'] },
	'taxonscientificname' => { 103 => [\'Taxon','TaxonScientificName'] },
	'taxonscientificnameauthorship' => { 103 => [\'Taxon','TaxonScientificNameAuthorship'] },
	'taxonscientificnameid' => { 103 => [\'Taxon','TaxonScientificNameID'] },
	'taxonspecificepithet' => { 103 => [\'Taxon','TaxonSpecificEpithet'] },
	'taxonsubgenus' => { 103 => [\'Taxon','TaxonSubgenus'] },
	'taxontaxonomicstatus' => { 103 => [\'Taxon','TaxonTaxonomicStatus'] },
	'taxonverbatimtaxonrank' => { 103 => [\'Taxon','TaxonVerbatimTaxonRank'] },
	'taxonvernacularname' => { 103 => [\'Taxon','TaxonVernacularName'] },
	'teaser' => { 408 => 'teaser' },
	'teleconverter' => { 161 => 0x105, 350 => 0x105 },
	'tempo' => { 418 => 'tempo' },
	'termsandconditionstext' => { 406 => 'TermsAndConditionsText' },
	'termsandconditionsurl' => { 406 => 'TermsAndConditionsURL' },
	'testname' => { 105 => 'TestName' },
	'textencoding' => { 190 => 0x4 },
	'textlayername' => { 405 => [\'TextLayers','TextLayersLayerName'] },
	'textlayers' => { 405 => 'TextLayers' },
	'textlayertext' => { 405 => [\'TextLayers','TextLayersLayerText'] },
	'textstamp' => { 267 => [0x8008,0x8009,0x3b,0x3e] },
	'thresholding' => { 104 => 0x107 },
	'thumbnailfilename' => { 85 => 0x817 },
	'thumbnailformat' => { 416 => [\'Thumbnails','ThumbnailsFormat'] },
	'thumbnailheight' => { 122 => 0xfa55, 416 => [\'Thumbnails','ThumbnailsHeight'] },
	'thumbnailimage' => { 85 => 0x2008, 101 => 'ThumbnailImage', 107 => 0x3, 145 => 'data', 252 => 0x100, 416 => [\'Thumbnails','ThumbnailsImage'] },
	'thumbnailimagename' => { 145 => '1Name' },
	'thumbnailimagesize' => { 145 => 'ImageSize' },
	'thumbnailimagetype' => { 145 => '0Type' },
	'thumbnailimagevalidarea' => { 54 => 0x13 },
	'thumbnaillength' => { 104 => 0x202 },
	'thumbnailoffset' => { 104 => 0x201 },
	'thumbnails' => { 416 => 'Thumbnails' },
	'thumbnailwidth' => { 122 => 0xfa54, 416 => [\'Thumbnails','ThumbnailsWidth'] },
	'ticker' => { 408 => 'ticker' },
	'tiffmeteringimage' => { 162 => 0x104c, 349 => 0x1110 },
	'tilelength' => { 104 => 0x143 },
	'tilewidth' => { 104 => 0x142 },
	'time' => { 118 => 0x401, 300 => 0x7 },
	'timecodes' => { 104 => 0xc763 },
	'timecreated' => { 112 => 0x3c, 120 => 0x14, 129 => 0x10, 309 => 'TimeCreated' },
	'timeperiod' => { 408 => 'timePeriod' },
	'timerfunctionbutton' => { 236 => '5.2', 237 => '12.1', 238 => '13.1' },
	'timerlength' => { 72 => 0x80c },
	'timerrecording' => { 267 => 0x96 },
	'timescaleparams' => { 418 => 'timeScaleParams' },
	'timescaleparamsframeoverlappingpercentage' => { 418 => [\'timeScaleParams','timeScaleParamsFrameOverlappingPercentage'] },
	'timescaleparamsframesize' => { 418 => [\'timeScaleParams','timeScaleParamsFrameSize'] },
	'timescaleparamsquality' => { 418 => [\'timeScaleParams','timeScaleParamsQuality'] },
	'timesent' => { 113 => 0x50 },
	'timesignature' => { 418 => 'timeSignature' },
	'timesincepoweron' => { 267 => 0x29 },
	'timestamp' => { 10 => 0x45e, 18 => 0x11c, 246 => 0x8, 259 => 'TimeStamp', 388 => 'Timestamp' },
	'timestamp1' => { 10 => 0x45a },
	'timezone' => { 67 => 0x1, 219 => 0x0 },
	'timezonecity' => { 67 => 0x2 },
	'timezonecode' => { 88 => 0x1 },
	'timezoneinfo' => { 88 => 0x2 },
	'timezoneoffset' => { 104 => 0x882a },
	'tint' => { 393 => 'Tint' },
	'title' => { 135 => 'Title', 256 => 'Title', 259 => 'Title', 267 => 0x65, 313 => 'Title', 394 => 'title', 404 => 'Title', 416 => 'Title' },
	'tonecomp' => { 191 => 0x81 },
	'tonecurve' => { 64 => 0x1, 300 => 0x402, 393 => 'ToneCurve' },
	'tonecurveactive' => { 95 => 0x110 },
	'tonecurveadobergb' => { 328 => 0xa043 },
	'tonecurveadobergbdefault' => { 328 => 0xa041 },
	'tonecurveblue' => { 393 => 'ToneCurveBlue' },
	'tonecurvebluex' => { 378 => 0x9003 },
	'tonecurvebluey' => { 378 => 0x9007 },
	'tonecurvebrightness' => { 90 => 0x20410 },
	'tonecurvebrightnessx' => { 378 => 0x9000 },
	'tonecurvebrightnessy' => { 378 => 0x9004 },
	'tonecurvecolorspace' => { 94 => 0x0 },
	'tonecurvecontrast' => { 90 => 0x20411 },
	'tonecurvefilename' => { 118 => 0x1391 },
	'tonecurvegreen' => { 393 => 'ToneCurveGreen' },
	'tonecurvegreenx' => { 378 => 0x9002 },
	'tonecurvegreeny' => { 378 => 0x9006 },
	'tonecurveinputrange' => { 94 => 0x3 },
	'tonecurveinterpolation' => { 95 => 0x159 },
	'tonecurvemode' => { 95 => 0x113 },
	'tonecurvename' => { 393 => 'ToneCurveName' },
	'tonecurvename2012' => { 393 => 'ToneCurveName2012' },
	'tonecurveoriginal' => { 90 => '0x20400.1' },
	'tonecurveoutputrange' => { 94 => 0x5 },
	'tonecurveproperty' => { 95 => 0x3c },
	'tonecurvepv2012' => { 393 => 'ToneCurvePV2012' },
	'tonecurvepv2012blue' => { 393 => 'ToneCurvePV2012Blue' },
	'tonecurvepv2012green' => { 393 => 'ToneCurvePV2012Green' },
	'tonecurvepv2012red' => { 393 => 'ToneCurvePV2012Red' },
	'tonecurvered' => { 393 => 'ToneCurveRed' },
	'tonecurveredx' => { 378 => 0x9001 },
	'tonecurveredy' => { 378 => 0x9005 },
	'tonecurves' => { 300 => 0x403 },
	'tonecurveshape' => { 94 => 0x1 },
	'tonecurvesrgb' => { 328 => 0xa042 },
	'tonecurvesrgbdefault' => { 328 => 0xa040 },
	'tonecurvex' => { 94 => 0xa },
	'tonecurvey' => { 94 => 0xb },
	'tonelevel' => { 247 => 0x52e },
	'toningeffect' => { 48 => 0xf, 191 => 0xb3, 193 => 0x38, 322 => 0x1015 },
	'toningeffectauto' => { 61 => 0xa4 },
	'toningeffectfaithful' => { 60 => 0x74, 61 => 0x74 },
	'toningeffectlandscape' => { 60 => 0x44, 61 => 0x44 },
	'toningeffectmonochrome' => { 18 => 0x108, 60 => 0x8c, 61 => 0x8c },
	'toningeffectneutral' => { 60 => 0x5c, 61 => 0x5c },
	'toningeffectportrait' => { 60 => 0x2c, 61 => 0x2c },
	'toningeffectstandard' => { 60 => 0x14, 61 => 0x14 },
	'toningeffectuserdef1' => { 60 => 0xa4, 61 => 0xbc },
	'toningeffectuserdef2' => { 60 => 0xbc, 61 => 0xd4 },
	'toningeffectuserdef3' => { 60 => 0xd4, 61 => 0xec },
	'toningsaturation' => { 193 => 0x39 },
	'totalzoom' => { 120 => 0x62 },
	'touchae' => { 267 => 0xab },
	'trackcreatedate' => { 317 => 0x1 },
	'trackmodifydate' => { 317 => 0x2 },
	'tracknumber' => { 418 => 'trackNumber' },
	'tracks' => { 418 => 'Tracks' },
	'tracksframerate' => { 418 => [\'Tracks','TracksFrameRate'] },
	'tracksmarkers' => { 418 => [\'Tracks','TracksMarkers'] },
	'tracksmarkerscomment' => { 418 => [\'Tracks','TracksMarkersComment'] },
	'tracksmarkerscuepointparams' => { 418 => [\'Tracks','TracksMarkersCuePointParams'] },
	'tracksmarkerscuepointparamskey' => { 418 => [\'Tracks','TracksMarkersCuePointParamsKey'] },
	'tracksmarkerscuepointparamsvalue' => { 418 => [\'Tracks','TracksMarkersCuePointParamsValue'] },
	'tracksmarkerscuepointtype' => { 418 => [\'Tracks','TracksMarkersCuePointType'] },
	'tracksmarkersduration' => { 418 => [\'Tracks','TracksMarkersDuration'] },
	'tracksmarkerslocation' => { 418 => [\'Tracks','TracksMarkersLocation'] },
	'tracksmarkersname' => { 418 => [\'Tracks','TracksMarkersName'] },
	'tracksmarkersprobability' => { 418 => [\'Tracks','TracksMarkersProbability'] },
	'tracksmarkersspeaker' => { 418 => [\'Tracks','TracksMarkersSpeaker'] },
	'tracksmarkersstarttime' => { 418 => [\'Tracks','TracksMarkersStartTime'] },
	'tracksmarkerstarget' => { 418 => [\'Tracks','TracksMarkersTarget'] },
	'tracksmarkerstype' => { 418 => [\'Tracks','TracksMarkersType'] },
	'trackstrackname' => { 418 => [\'Tracks','TracksTrackName'] },
	'trackstracktype' => { 418 => [\'Tracks','TracksTrackType'] },
	'trailersignature' => { 142 => 'zmie' },
	'transferfunction' => { 104 => 0x12d, 414 => 'TransferFunction' },
	'transform' => { 267 => [0x8012,0x59] },
	'transmissionreference' => { 405 => 'TransmissionReference' },
	'trapped' => { 256 => 'Trapped', 404 => 'Trapped' },
	'trashbuttonfunction' => { 72 => 0x710 },
	'travelday' => { 267 => 0x36 },
	'triggermode' => { 318 => 0x6 },
	'tstop' => { 104 => 0xc772 },
	'ttl_da_adown' => { 288 => 0x5 },
	'ttl_da_aup' => { 288 => 0x4 },
	'ttl_da_bdown' => { 288 => 0x7 },
	'ttl_da_bup' => { 288 => 0x6 },
	'tungstenawb' => { 278 => 0x1 },
	'tvexposuretimesetting' => { 281 => 0x12 },
	'type' => { 394 => 'type', 413 => 'type' },
	'typestatus' => { 103 => [\'Identification','IdentificationTypeStatus'] },
	'uniquecameramodel' => { 104 => 0xc614 },
	'uniquedocumentid' => { 112 => 0xbb },
	'uniqueobjectname' => { 113 => 0x64 },
	'unknownblock' => { 300 => 0x405 },
	'unknownblock1' => { 251 => 0x635 },
	'unknownblock2' => { 251 => 0x636 },
	'unknownblock3' => { 251 => 0x1103 },
	'unknownblock4' => { 251 => 0x1104 },
	'unknowncontrast' => { 96 => 0x45 },
	'unknownev' => { 118 => 0x1 },
	'unknownlinear' => { 96 => 0x46 },
	'unknownnumber' => { 85 => 0x180b },
	'unknownoutputhighlightpoint' => { 96 => 0x4a },
	'unknownoutputshadowpoint' => { 96 => 0x4b },
	'unknownrawhighlight' => { 96 => 0x7b },
	'unknownrawhighlightpoint' => { 96 => 0x48 },
	'unknownrawshadow' => { 96 => 0x84 },
	'unknownrawshadowpoint' => { 96 => 0x49 },
	'unknownsharpness' => { 96 => 0x47 },
	'unknowntemperature' => { 106 => 0x4 },
	'unsharp1color' => { 232 => 0x13 },
	'unsharp1halowidth' => { 232 => 0x19 },
	'unsharp1intensity' => { 232 => 0x17 },
	'unsharp1threshold' => { 232 => 0x1b },
	'unsharp2color' => { 232 => 0x2e },
	'unsharp2halowidth' => { 232 => 0x34 },
	'unsharp2intensity' => { 232 => 0x32 },
	'unsharp2threshold' => { 232 => 0x36 },
	'unsharp3color' => { 232 => 0x49 },
	'unsharp3halowidth' => { 232 => 0x4f },
	'unsharp3intensity' => { 232 => 0x4d },
	'unsharp3threshold' => { 232 => 0x51 },
	'unsharp4color' => { 232 => 0x64 },
	'unsharp4halowidth' => { 232 => 0x6a },
	'unsharp4intensity' => { 232 => 0x68 },
	'unsharp4threshold' => { 232 => 0x6c },
	'unsharpcount' => { 232 => 0x0 },
	'unsharpmask' => { 96 => 0x90, 227 => 0x76a43200 },
	'unsharpmaskfineness' => { 90 => 0x20309 },
	'unsharpmaskstrength' => { 90 => 0x20308 },
	'unsharpmaskthreshold' => { 90 => 0x2030a },
	'uprightcentermode' => { 393 => 'UprightCenterMode' },
	'uprightcenternormx' => { 393 => 'UprightCenterNormX' },
	'uprightcenternormy' => { 393 => 'UprightCenterNormY' },
	'uprightdependentdigest' => { 393 => 'UprightDependentDigest' },
	'uprightfocallength35mm' => { 393 => 'UprightFocalLength35mm' },
	'uprightfocalmode' => { 393 => 'UprightFocalMode' },
	'uprightpreview' => { 393 => 'UprightPreview' },
	'uprighttransform_0' => { 393 => 'UprightTransform_0' },
	'uprighttransform_1' => { 393 => 'UprightTransform_1' },
	'uprighttransform_2' => { 393 => 'UprightTransform_2' },
	'uprighttransform_3' => { 393 => 'UprightTransform_3' },
	'uprighttransform_4' => { 393 => 'UprightTransform_4' },
	'uprighttransformcount' => { 393 => 'UprightTransformCount' },
	'uprightversion' => { 393 => 'UprightVersion' },
	'urgency' => { 112 => 0xa, 405 => 'Urgency' },
	'url' => { 135 => 'URL', 259 => 'URL', 311 => 0x40b, 408 => 'url' },
	'urla-platform' => { 408 => [\'url','urlA-platform'] },
	'urlurl' => { 408 => [\'url','urlUrl'] },
	'usablemeteringmodes' => { 72 => 0x10a },
	'usableshootingmodes' => { 72 => 0x109 },
	'usage' => { 409 => 'usage' },
	'usageterms' => { 422 => 'UsageTerms' },
	'useguidelines' => { 390 => 'useGuidelines' },
	'usepanoramaviewer' => { 382 => 'UsePanoramaViewer' },
	'usercomment' => { 85 => 0x805, 104 => 0x9286, 397 => 'UserComment' },
	'userdef1picturestyle' => { 18 => 0x10c, 60 => 0xd8, 61 => 0xf0 },
	'userdef2picturestyle' => { 18 => 0x10e, 60 => 0xda, 61 => 0xf2 },
	'userdef3picturestyle' => { 18 => 0x110, 60 => 0xdc, 61 => 0xf4 },
	'userfields' => { 385 => 'UserFields' },
	'userlabel' => { 318 => 0x2b },
	'userprofile' => { 263 => 0x302, 269 => 0x3038 },
	'usmlenselectronicmf' => { 71 => 0x7, 72 => 0x501 },
	'uspsnumber' => { 408 => 'uspsNumber' },
	'utmeasting' => { 146 => 'Easting' },
	'utmmapdatum' => { 146 => 'Datum' },
	'utmnorthing' => { 146 => 'Northing' },
	'utmzone' => { 146 => 'Zone' },
	'uv-irfiltercorrection' => { 263 => 0x325 },
	'validbits' => { 251 => 0x611, 252 => 0x102c },
	'validpixeldepth' => { 255 => 0x611 },
	'variousmodes' => { 120 => 0x26 },
	'variousmodes2' => { 120 => 0x3a },
	'variprogram' => { 191 => 0xab },
	'version' => { 109 => 0x0, 313 => 'Version', 393 => 'Version' },
	'versioncreatedate' => { 378 => 0xd100 },
	'versionid' => { 419 => 'VersionID' },
	'versionidentifier' => { 408 => 'versionIdentifier' },
	'versionmodifydate' => { 378 => 0xd101 },
	'versions' => { 419 => 'Versions' },
	'versionscomments' => { 419 => [\'Versions','VersionsComments'] },
	'versionsevent' => { 419 => [\'Versions','VersionsEvent'] },
	'versionseventaction' => { 419 => [\'Versions','VersionsEventAction'] },
	'versionseventchanged' => { 419 => [\'Versions','VersionsEventChanged'] },
	'versionseventinstanceid' => { 419 => [\'Versions','VersionsEventInstanceID'] },
	'versionseventparameters' => { 419 => [\'Versions','VersionsEventParameters'] },
	'versionseventsoftwareagent' => { 419 => [\'Versions','VersionsEventSoftwareAgent'] },
	'versionseventwhen' => { 419 => [\'Versions','VersionsEventWhen'] },
	'versionsmodifier' => { 419 => [\'Versions','VersionsModifier'] },
	'versionsmodifydate' => { 419 => [\'Versions','VersionsModifyDate'] },
	'versionsversion' => { 419 => [\'Versions','VersionsVersion'] },
	'verticalafonbutton' => { 234 => '3.2', 235 => '47.2' },
	'verticalfuncbutton' => { 235 => '42.2' },
	'verticalfuncbuttonplusdials' => { 235 => '43.1' },
	'verticalmultiselector' => { 235 => '42.1' },
	'vfdisplayillumination' => { 72 => 0x510 },
	'vibrance' => { 386 => 'Vibrance', 393 => 'Vibrance' },
	'vibrationreduction' => { 198 => [0x75,0x82,0x1ae], 206 => '586.1', 213 => '590.2', 218 => 0x4 },
	'videoalphamode' => { 418 => 'videoAlphaMode' },
	'videoalphapremultiplecolor' => { 418 => 'videoAlphaPremultipleColor' },
	'videoalphapremultiplecolora' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorA'] },
	'videoalphapremultiplecolorb' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorB'] },
	'videoalphapremultiplecolorblack' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlack'] },
	'videoalphapremultiplecolorblue' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorBlue'] },
	'videoalphapremultiplecolorcyan' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorCyan'] },
	'videoalphapremultiplecolorgreen' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorGreen'] },
	'videoalphapremultiplecolorl' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorL'] },
	'videoalphapremultiplecolormagenta' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMagenta'] },
	'videoalphapremultiplecolormode' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorMode'] },
	'videoalphapremultiplecolorred' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorRed'] },
	'videoalphapremultiplecolorswatchname' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorSwatchName'] },
	'videoalphapremultiplecolortint' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorTint'] },
	'videoalphapremultiplecolortype' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorType'] },
	'videoalphapremultiplecoloryellow' => { 418 => [\'videoAlphaPremultipleColor','videoAlphaPremultipleColorYellow'] },
	'videoalphaunityistransparent' => { 418 => 'videoAlphaUnityIsTransparent' },
	'videocodec' => { 57 => 0x74 },
	'videocolorspace' => { 418 => 'videoColorSpace' },
	'videocompressor' => { 418 => 'videoCompressor' },
	'videofieldorder' => { 418 => 'videoFieldOrder' },
	'videoframerate' => { 418 => 'videoFrameRate' },
	'videoframesize' => { 418 => 'videoFrameSize' },
	'videoframesizeh' => { 418 => [\'videoFrameSize','videoFrameSizeH'] },
	'videoframesizeunit' => { 418 => [\'videoFrameSize','videoFrameSizeUnit'] },
	'videoframesizew' => { 418 => [\'videoFrameSize','videoFrameSizeW'] },
	'videomoddate' => { 418 => 'videoModDate' },
	'videopixelaspectratio' => { 418 => 'videoPixelAspectRatio' },
	'videopixeldepth' => { 418 => 'videoPixelDepth' },
	'videoquality' => { 100 => 0x4003 },
	'viewfinderdisplay' => { 234 => '12.4', 235 => '6.3' },
	'viewfinderwarning' => { 234 => '13.4', 241 => '3.5', 242 => '6.2', 245 => '4.4' },
	'viewfinderwarnings' => { 72 => 0x40a },
	'viewinfoduringexposure' => { 72 => 0x407 },
	'viewingmode' => { 340 => 0x2f, 354 => 0x18 },
	'viewingmode2' => { 340 => [0x85,0x285] },
	'viewpoint' => { 407 => 'viewpoint' },
	'vignetteamount' => { 393 => 'VignetteAmount' },
	'vignettecontrol' => { 191 => 0x2a, 227 => 0x76a43205 },
	'vignettecontrolintensity' => { 227 => 0xac6bd5c0 },
	'vignettecorrectionalreadyapplied' => { 389 => 'VignetteCorrectionAlreadyApplied' },
	'vignettemidpoint' => { 393 => 'VignetteMidpoint' },
	'vignetting' => { 322 => 0x1011, 328 => 0xa052 },
	'vignettingcorrection' => { 328 => 0xa053, 350 => 0x2011 },
	'vignettingsetting' => { 328 => 0xa054 },
	'visualtechnique' => { 407 => 'visualTechnique' },
	'voicememo' => { 330 => 0x216 },
	'volume' => { 408 => 'volume' },
	'vr_0x66' => { 198 => 0x66 },
	'vrdoffset' => { 54 => 0xd0 },
	'vrmode' => { 218 => 0x6 },
	'wb_bluelevel3500k' => { 162 => 0x19a },
	'wb_bluelevel6500k' => { 162 => 0x18a },
	'wb_bluelevelcustom' => { 162 => 0x18e },
	'wb_bluelevelscloudy' => { 162 => 0x106 },
	'wb_bluelevelsdaylight' => { 162 => 0xea },
	'wb_bluelevelsflash' => { 162 => 0x122 },
	'wb_bluelevelsfluorescent' => { 162 => [0x40a,0x15a] },
	'wb_bluelevelskelvin' => { 162 => 0x254 },
	'wb_bluelevelsshade' => { 162 => 0x176 },
	'wb_bluelevelstungsten' => { 162 => 0xce },
	'wb_gbrglevels' => { 162 => 0xae, 165 => 0x4 },
	'wb_glevel' => { 251 => 0x11f },
	'wb_glevel3000k' => { 251 => 0x113 },
	'wb_glevel3300k' => { 251 => 0x114 },
	'wb_glevel3600k' => { 251 => 0x115 },
	'wb_glevel3900k' => { 251 => 0x116 },
	'wb_glevel4000k' => { 251 => 0x117 },
	'wb_glevel4300k' => { 251 => 0x118 },
	'wb_glevel4500k' => { 251 => 0x119 },
	'wb_glevel4800k' => { 251 => 0x11a },
	'wb_glevel5300k' => { 251 => 0x11b },
	'wb_glevel6000k' => { 251 => 0x11c },
	'wb_glevel6600k' => { 251 => 0x11d },
	'wb_glevel7500k' => { 251 => 0x11e },
	'wb_grbglevels' => { 174 => 0x0 },
	'wb_rbgglevels' => { 171 => 0x0 },
	'wb_rblevels' => { 191 => 0xc, 251 => 0x100 },
	'wb_rblevels1' => { 272 => 0x2 },
	'wb_rblevels2' => { 272 => 0x5 },
	'wb_rblevels3' => { 272 => 0x8 },
	'wb_rblevels3000k' => { 251 => 0x102 },
	'wb_rblevels3300k' => { 251 => 0x103 },
	'wb_rblevels3500k' => { 162 => 0x430 },
	'wb_rblevels3600k' => { 251 => 0x104 },
	'wb_rblevels3900k' => { 251 => 0x105 },
	'wb_rblevels4' => { 272 => 0xb },
	'wb_rblevels4000k' => { 251 => 0x106 },
	'wb_rblevels4300k' => { 251 => 0x107 },
	'wb_rblevels4500k' => { 251 => 0x108 },
	'wb_rblevels4800k' => { 251 => 0x109 },
	'wb_rblevels5' => { 272 => 0xe },
	'wb_rblevels5300k' => { 251 => 0x10a },
	'wb_rblevels6' => { 272 => 0x11 },
	'wb_rblevels6000k' => { 251 => 0x10b },
	'wb_rblevels6500k' => { 162 => 0x420 },
	'wb_rblevels6600k' => { 251 => 0x10c },
	'wb_rblevels7' => { 272 => 0x14 },
	'wb_rblevels7500k' => { 251 => 0x10d },
	'wb_rblevelsauto' => { 255 => 0x110 },
	'wb_rblevelscloudy' => { 162 => 0x3f0, 164 => 0x10, 255 => 0x121 },
	'wb_rblevelscoolwhitef' => { 162 => 0x308, 164 => 0x14 },
	'wb_rblevelscoolwhitefluor' => { 255 => 0x132 },
	'wb_rblevelscustom' => { 162 => 0x424 },
	'wb_rblevelscwb1' => { 251 => 0x10e },
	'wb_rblevelscwb2' => { 251 => 0x10f },
	'wb_rblevelscwb3' => { 251 => 0x110 },
	'wb_rblevelscwb4' => { 251 => 0x111 },
	'wb_rblevelsdaylight' => { 162 => [0x3ec,0x528], 164 => 0xc },
	'wb_rblevelsdaylightf' => { 164 => 0x24 },
	'wb_rblevelsdaylightfluor' => { 255 => 0x130 },
	'wb_rblevelsdaywhitef' => { 164 => 0x28 },
	'wb_rblevelsdaywhitefluor' => { 255 => 0x131 },
	'wb_rblevelseveningsunlight' => { 255 => 0x124 },
	'wb_rblevelsfineweather' => { 255 => 0x122 },
	'wb_rblevelsflash' => { 162 => [0x3f4,0x304], 164 => 0x18 },
	'wb_rblevelsshade' => { 162 => 0x418, 164 => 0x20, 255 => 0x120 },
	'wb_rblevelstungsten' => { 162 => 0x3e8, 164 => 0x8, 255 => 0x123 },
	'wb_rblevelsunknown' => { 164 => 0x1c },
	'wb_rblevelsused' => { 255 => 0x100 },
	'wb_rblevelswhitef' => { 164 => 0x2c },
	'wb_rblevelswhitefluorescent' => { 255 => 0x133 },
	'wb_redlevel3500k' => { 162 => 0x198 },
	'wb_redlevel6500k' => { 162 => 0x188 },
	'wb_redlevelcustom' => { 162 => 0x18c },
	'wb_redlevelscloudy' => { 162 => 0xf8 },
	'wb_redlevelsdaylight' => { 162 => 0xdc },
	'wb_redlevelsflash' => { 162 => 0x114 },
	'wb_redlevelsfluorescent' => { 162 => [0x3fc,0x14c] },
	'wb_redlevelskelvin' => { 162 => 0x1be },
	'wb_redlevelsshade' => { 162 => 0x168 },
	'wb_redlevelstungsten' => { 162 => 0xc0 },
	'wb_rgbglevels' => { 173 => 0x0 },
	'wb_rgblevels' => { 162 => [0x546,0x96], 264 => 0xd, 265 => 0x413, 269 => 0x3036, 357 => 0x117c, 358 => 0x1180, 359 => 0x115c, 360 => 0x11d8, 361 => 0x11b4, 362 => 0x106c, 363 => 0x264, 364 => 0x264 },
	'wb_rgblevels1' => { 273 => 0x2 },
	'wb_rgblevels2' => { 273 => 0x6 },
	'wb_rgblevels3' => { 273 => 0xa },
	'wb_rgblevels4' => { 273 => 0xe },
	'wb_rgblevels5' => { 273 => 0x12 },
	'wb_rgblevels6' => { 273 => 0x16 },
	'wb_rgblevels7' => { 273 => 0x1a },
	'wb_rggbblacklevels' => { 31 => 0x25 },
	'wb_rggblevels' => { 165 => 0x4, 172 => 0x0 },
	'wb_rggblevelsasshot' => { 33 => 0x0, 34 => 0x19, 35 => 0x22, 36 => 0x3f, 39 => 0x3f, 40 => 0x3f, 41 => 0x3f },
	'wb_rggblevelsauto' => { 31 => 0x1, 33 => 0x5, 34 => 0x1e, 35 => 0x18, 36 => 0x44, 39 => 0x44, 40 => 0x44, 41 => 0x44, 328 => 0xa022 },
	'wb_rggblevelsblack' => { 328 => 0xa028 },
	'wb_rggblevelscloudy' => { 31 => 0xd, 33 => 0x1e, 34 => 0x2d, 35 => 0x31, 36 => 0x58, 39 => 0x71, 40 => 0x8a, 41 => 0x8f, 300 => 0x20f, 307 => 0x14 },
	'wb_rggblevelscustom' => { 31 => 0x1d, 36 => 0x80 },
	'wb_rggblevelscustom1' => { 34 => 0x41 },
	'wb_rggblevelscustom2' => { 34 => 0x46 },
	'wb_rggblevelsdaylight' => { 31 => 0x5, 33 => 0x14, 34 => 0x23, 35 => 0x27, 36 => 0x4e, 39 => 0x67, 40 => 0x80, 41 => 0x85, 300 => 0x20d, 307 => 0x2 },
	'wb_rggblevelsflash' => { 31 => 0x19, 33 => 0x32, 34 => 0x3c, 35 => 0x45, 36 => 0x6c, 39 => 0x85, 40 => 0x9e, 41 => 0xa3, 300 => 0x214, 307 => 0x41 },
	'wb_rggblevelsfluorescent' => { 31 => 0x15, 33 => 0x28, 34 => 0x37, 35 => 0x3b, 36 => 0x62, 39 => 0x7b, 40 => 0x94, 41 => 0x99 },
	'wb_rggblevelsfluorescentd' => { 300 => 0x211, 307 => 0x26 },
	'wb_rggblevelsfluorescentl' => { 307 => 0x4a },
	'wb_rggblevelsfluorescentn' => { 300 => 0x212, 307 => 0x2f },
	'wb_rggblevelsfluorescentw' => { 300 => 0x213, 307 => 0x38 },
	'wb_rggblevelsilluminator1' => { 328 => 0xa023 },
	'wb_rggblevelsilluminator2' => { 328 => 0xa024 },
	'wb_rggblevelskelvin' => { 31 => 0x21, 33 => 0x2d, 35 => 0x40, 36 => 0x67, 39 => 0x80, 40 => 0x99, 41 => 0x9e },
	'wb_rggblevelsmeasured' => { 33 => 0xa, 36 => 0x49, 39 => 0x49, 40 => 0x49, 41 => 0x49 },
	'wb_rggblevelspc1' => { 35 => 0x90, 36 => 0x71 },
	'wb_rggblevelspc2' => { 35 => 0x95, 36 => 0x76 },
	'wb_rggblevelspc3' => { 35 => 0x9a, 36 => 0x7b },
	'wb_rggblevelsshade' => { 31 => 0x9, 33 => 0x19, 34 => 0x28, 35 => 0x2c, 36 => 0x53, 39 => 0x6c, 40 => 0x85, 41 => 0x8a, 300 => 0x20e, 307 => 0xb },
	'wb_rggblevelstungsten' => { 31 => 0x11, 33 => 0x23, 34 => 0x32, 35 => 0x36, 36 => 0x5d, 39 => 0x76, 40 => 0x8f, 41 => 0x94, 300 => 0x210, 307 => 0x1d },
	'wb_rggblevelsuncorrected' => { 328 => 0xa021 },
	'wb_rggblevelsunknown' => { 33 => 0xf, 35 => 0x1d, 39 => 0x4e, 40 => 0x4e, 41 => 0x4e, 307 => 0x53 },
	'wb_rggblevelsunknown10' => { 33 => 0x5f, 35 => 0x72, 39 => 0x9e, 40 => 0x7b, 41 => 0x7b },
	'wb_rggblevelsunknown11' => { 33 => 0x64, 35 => 0x77, 39 => 0xa3, 40 => 0xa3, 41 => 0x80 },
	'wb_rggblevelsunknown12' => { 33 => 0x69, 35 => 0x7c, 39 => 0xa8, 40 => 0xa8, 41 => 0xa8 },
	'wb_rggblevelsunknown13' => { 33 => 0x6e, 35 => 0x81, 39 => 0xad, 40 => 0xad, 41 => 0xad },
	'wb_rggblevelsunknown14' => { 35 => 0x86, 39 => 0xb2, 40 => 0xb2, 41 => 0xb2 },
	'wb_rggblevelsunknown15' => { 35 => 0x8b, 39 => 0xb7, 40 => 0xb7, 41 => 0xb7 },
	'wb_rggblevelsunknown16' => { 35 => 0x9f, 40 => 0xbc, 41 => 0xbc },
	'wb_rggblevelsunknown17' => { 40 => 0xc1, 41 => 0xc1 },
	'wb_rggblevelsunknown18' => { 40 => 0xc6, 41 => 0xc6 },
	'wb_rggblevelsunknown19' => { 40 => 0xcb, 41 => 0xcb },
	'wb_rggblevelsunknown2' => { 33 => 0x37, 35 => 0x4a, 39 => 0x53, 40 => 0x53, 41 => 0x53 },
	'wb_rggblevelsunknown20' => { 40 => 0xd0, 41 => 0xd0 },
	'wb_rggblevelsunknown21' => { 41 => 0xd5 },
	'wb_rggblevelsunknown22' => { 41 => 0xda },
	'wb_rggblevelsunknown23' => { 41 => 0xdf },
	'wb_rggblevelsunknown24' => { 41 => 0xe4 },
	'wb_rggblevelsunknown25' => { 41 => 0xe9 },
	'wb_rggblevelsunknown26' => { 41 => 0xee },
	'wb_rggblevelsunknown27' => { 41 => 0xf3 },
	'wb_rggblevelsunknown28' => { 41 => 0xf8 },
	'wb_rggblevelsunknown29' => { 41 => 0xfd },
	'wb_rggblevelsunknown3' => { 33 => 0x3c, 35 => 0x4f, 39 => 0x58, 40 => 0x58, 41 => 0x58 },
	'wb_rggblevelsunknown30' => { 41 => 0x102 },
	'wb_rggblevelsunknown4' => { 33 => 0x41, 35 => 0x54, 39 => 0x5d, 40 => 0x5d, 41 => 0x5d },
	'wb_rggblevelsunknown5' => { 33 => 0x46, 35 => 0x59, 39 => 0x62, 40 => 0x62, 41 => 0x62 },
	'wb_rggblevelsunknown6' => { 33 => 0x4b, 35 => 0x5e, 39 => 0x8a, 40 => 0x67, 41 => 0x67 },
	'wb_rggblevelsunknown7' => { 33 => 0x50, 35 => 0x63, 39 => 0x8f, 40 => 0x6c, 41 => 0x6c },
	'wb_rggblevelsunknown8' => { 33 => 0x55, 35 => 0x68, 39 => 0x94, 40 => 0x71, 41 => 0x71 },
	'wb_rggblevelsunknown9' => { 33 => 0x5a, 35 => 0x6d, 39 => 0x99, 40 => 0x76, 41 => 0x76 },
	'wb_rggblevelsuserselected' => { 307 => 0x5c },
	'wbadjblueamber' => { 90 => 0x20106 },
	'wbadjbluebalance' => { 233 => 0x8 },
	'wbadjcolortemp' => { 90 => 0x20102, 95 => 0x1a },
	'wbadjlighting' => { 233 => 0x14 },
	'wbadjmagentagreen' => { 90 => 0x20105 },
	'wbadjmode' => { 233 => 0x10 },
	'wbadjredbalance' => { 233 => 0x0 },
	'wbadjrggblevels' => { 90 => 0x20125, 95 => 0x6 },
	'wbadjtemperature' => { 233 => 0x18 },
	'wbadjtint' => { 233 => 0x25 },
	'wbbluelevel' => { 263 => 0x324, 267 => 0x8006, 271 => 0x26 },
	'wbbracketmode' => { 48 => 0x9 },
	'wbbracketshotnumber' => { 162 => 0x2b, 322 => 0x101a },
	'wbbracketvalueab' => { 48 => 0xc },
	'wbbracketvaluegm' => { 48 => 0xd },
	'wbfinetuneactive' => { 95 => 0x24 },
	'wbfinetunesaturation' => { 95 => 0x28 },
	'wbfinetunetone' => { 95 => 0x2c },
	'wbgreenlevel' => { 263 => 0x323, 267 => 0x8005, 271 => 0x25 },
	'wbmediaimagesizesetting' => { 72 => 0x708 },
	'wbmode' => { 164 => 0x4, 252 => 0x1015 },
	'wbredlevel' => { 263 => 0x322, 267 => 0x8004, 271 => 0x24 },
	'wbscale' => { 165 => 0x0 },
	'wbshiftab' => { 64 => 0xc, 267 => 0x46, 282 => 0x10 },
	'wbshiftab_gm' => { 350 => 0x2014 },
	'wbshiftgm' => { 64 => 0xd, 267 => 0x47, 282 => 0x11 },
	'wbtype1' => { 272 => 0x1, 273 => 0x1 },
	'wbtype2' => { 272 => 0x4, 273 => 0x5 },
	'wbtype3' => { 272 => 0x7, 273 => 0x9 },
	'wbtype4' => { 272 => 0xa, 273 => 0xd },
	'wbtype5' => { 272 => 0xd, 273 => 0x11 },
	'wbtype6' => { 272 => 0x10, 273 => 0x15 },
	'wbtype7' => { 272 => 0x13, 273 => 0x19 },
	'webstatement' => { 422 => 'WebStatement' },
	'what' => { 393 => 'What' },
	'whitebalance' => { 6 => 0x6f, 7 => [0x44,0x4a], 8 => 0xbc, 9 => 0x36, 10 => 0x5e, 11 => 0x36, 12 => 0x78, 13 => 0x6f, 14 => 0x6f, 15 => 0x73, 16 => 0x6f, 17 => 0x78, 18 => 0x54, 19 => 0x6f, 20 => 0xbc, 21 => 0x7b, 23 => 0xbc, 24 => 0xc2, 26 => 0x77, 64 => 0x8, 66 => 0x7, 99 => 0x7, 100 => [0x19,0x2012], 104 => [0xa403,0xfe4e], 109 => 0x1002, 118 => 0x3fc, 119 => 0xfa0d, 120 => 0x40, 156 => 0x3, 157 => 0xe, 158 => 0x4, 159 => 0xb, 161 => 0x115, 191 => 0x5, 217 => 0x7, 263 => 0x304, 267 => 0x3, 269 => 0x3033, 300 => 0x19, 306 => 0x7, 321 => 0x26, 322 => 0x1003, 331 => [0x3c,0x7,0x58], 338 => 0xf, 339 => 0xe, 350 => [0x115,0xb054], 393 => 'WhiteBalance', 397 => 'WhiteBalance' },
	'whitebalance2' => { 247 => 0x500 },
	'whitebalanceadj' => { 90 => 0x20101, 95 => 0x18, 227 => 0x76a43204 },
	'whitebalanceautoadjustment' => { 278 => 0x0 },
	'whitebalancebias' => { 100 => 0x2011, 252 => 0x304, 267 => 0x23 },
	'whitebalanceblue' => { 64 => 0x7 },
	'whitebalancebracket' => { 247 => 0x502, 252 => 0x303 },
	'whitebalancebracketing' => { 159 => 0x22, 162 => 0x2c, 349 => 0x2c },
	'whitebalancecomp' => { 255 => 0x1001 },
	'whitebalancefinetune' => { 109 => 0x100a, 159 => 0x38, 161 => 0x112, 191 => 0xb, 322 => 0x1004, 338 => 0x6, 339 => 0x5, 350 => 0x112 },
	'whitebalancemode' => { 300 => 0x1a },
	'whitebalancered' => { 64 => 0x6 },
	'whitebalanceset' => { 281 => 0xa },
	'whitebalancesetting' => { 159 => 0x23, 338 => 0x5, 339 => 0x4, 340 => 0x16, 354 => 0xd },
	'whitebalancetemperature' => { 247 => 0x501 },
	'whiteboard' => { 252 => 0x301 },
	'whitelevel' => { 104 => 0xc61d, 300 => 0x7e },
	'whitepoint' => { 104 => 0x13e, 300 => 0x201, 414 => 'WhitePoint' },
	'whites2012' => { 393 => 'Whites2012' },
	'wideadapter' => { 322 => 0x1017 },
	'widefocuszone' => { 156 => 0x2f },
	'widerange' => { 330 => 0x20f },
	'windowsatom' => { 392 => 'windowsAtom' },
	'windowsatomextension' => { 392 => [\'windowsAtom','windowsAtomExtension'] },
	'windowsatominvocationflags' => { 392 => [\'windowsAtom','windowsAtomInvocationFlags'] },
	'windowsatomuncprojectpath' => { 392 => [\'windowsAtom','windowsAtomUncProjectPath'] },
	'wordcount' => { 408 => 'wordCount' },
	'workcolorspace' => { 90 => 0x10200, 95 => 0x270 },
	'worktodo' => { 399 => 'WorkToDo' },
	'worldtimelocation' => { 267 => 0x3a, 300 => 0x22, 305 => '0.1' },
	'writer-editor' => { 112 => 0x7a },
	'x3filllight' => { 331 => 0x12 },
	'xml' => { 116 => 'xml ' },
	'xmp' => { 93 => 0xffff00f6, 105 => 'XMP' },
	'xmptoolkit' => { 415 => 'xmptk' },
	'xpauthor' => { 104 => 0x9c9d },
	'xpcomment' => { 104 => 0x9c9c },
	'xpkeywords' => { 104 => 0x9c9e },
	'xposition' => { 104 => 0x11e },
	'xpsubject' => { 104 => 0x9c9f },
	'xptitle' => { 104 => 0x9c9b },
	'xresolution' => { 104 => 0x11a, 115 => 0x3, 312 => 0x0, 414 => 'XResolution' },
	'xyresolution' => { 108 => 0x3 },
	'yawangle' => { 207 => 0x3513 },
	'ycbcrcoefficients' => { 104 => 0x211, 414 => 'YCbCrCoefficients' },
	'ycbcrpositioning' => { 104 => 0x213, 414 => 'YCbCrPositioning' },
	'ycbcrsubsampling' => { 104 => 0x212, 414 => 'YCbCrSubSampling' },
	'yearcreated' => { 120 => 0x10, 129 => 0xc },
	'yield' => { 410 => 'yield' },
	'yposition' => { 104 => 0x11f },
	'yresolution' => { 104 => 0x11b, 115 => 0x5, 312 => 0x4, 414 => 'YResolution' },
	'zonematching' => { 161 => 0x10a, 164 => [0x3a,0x4a], 350 => 0xb024 },
	'zonematchingmode' => { 159 => 0x14 },
	'zonematchingon' => { 158 => 0x75 },
	'zonematchingvalue' => { 338 => 0x1f },
	'zoomedpreviewlength' => { 252 => 0xf05 },
	'zoomedpreviewsize' => { 252 => 0xf06 },
	'zoomedpreviewstart' => { 252 => 0xf04 },
	'zoomsourcewidth' => { 30 => 0x24 },
	'zoomstepcount' => { 250 => 0x300, 252 => 0x100d },
	'zoomtargetwidth' => { 30 => 0x25 },
);

# lookup for non-writable tags to check if the name exists
my %tagExists = (
	'_ac3' => 1,
	'_h264' => 1,
	'_stream' => 1,
	'a100dataoffset' => 1,
	'aas' => 1,
	'abovecolor' => 1,
	'abstract' => 1,
	'accelerometertime' => 1,
	'accessdate' => 1,
	'accountname' => 1,
	'acdsee' => 1,
	'acquisitiontime' => 1,
	'acquisitiontimeday' => 1,
	'acquisitiontimemonth' => 1,
	'acquisitiontimeyear' => 1,
	'acquisitiontimeyearmonth' => 1,
	'acquisitiontimeyearmonthday' => 1,
	'acroform' => 1,
	'actor' => 1,
	'actualcompensation' => 1,
	'actualscalemax' => 1,
	'actualscalemin' => 1,
	'adobe_cm' => 1,
	'adobecmtype' => 1,
	'adobecrw' => 1,
	'adobekoda' => 1,
	'adobeleaf' => 1,
	'adobemrw' => 1,
	'adobepano' => 1,
	'adobephotoshop' => 1,
	'adoberaf' => 1,
	'adobesr2' => 1,
	'adoptedneutral' => 1,
	'adult' => 1,
	'advancedcontentencryption' => 1,
	'advancedmutualexcl' => 1,
	'advancedscenemode' => 1,
	'adventrevision' => 1,
	'adventscale' => 1,
	'aeflags' => 1,
	'aeinfo' => 1,
	'aeinfo2' => 1,
	'aeinfo3' => 1,
	'aeinfounknown' => 1,
	'afarea' => 1,
	'afareaheights' => 1,
	'afareawidths' => 1,
	'afareaxpositions' => 1,
	'afareaypositions' => 1,
	'afconfig' => 1,
	'afcp' => 1,
	'afcp_iptc' => 1,
	'aff1' => 1,
	'aff5' => 1,
	'affheader' => 1,
	'affinetransformmat' => 1,
	'afinfo' => 1,
	'afinfo2' => 1,
	'afinfo2version' => 1,
	'afinfo3' => 1,
	'afinfocus' => 1,
	'afinfosize' => 1,
	'afm' => 1,
	'afpointsinfocus1d' => 1,
	'afstatus15' => 1,
	'afstatus19' => 1,
	'aftune' => 1,
	'aimetadata' => 1,
	'aipdfprivatedata' => 1,
	'aiprivatedata' => 1,
	'album2' => 1,
	'albumartist' => 1,
	'albumartistsortorder' => 1,
	'albumcoverurl' => 1,
	'albumid' => 1,
	'albumidalbumartist' => 1,
	'albumname' => 1,
	'albumsortorder' => 1,
	'albumtitle' => 1,
	'albumtitleid' => 1,
	'albumtitlesortorder' => 1,
	'aliaslayermetadata' => 1,
	'alignment' => 1,
	'allcolorflatfield1' => 1,
	'allcolorflatfield2' => 1,
	'allcolorflatfield3' => 1,
	'alph' => 1,
	'alpha' => 1,
	'alphabitdepth' => 1,
	'alphabytecount' => 1,
	'alphachannelsnames' => 1,
	'alphacompression' => 1,
	'alphadatadiscard' => 1,
	'alphafilter' => 1,
	'alphafiltering' => 1,
	'alphaidentifiers' => 1,
	'alphainterlace' => 1,
	'alphaoffset' => 1,
	'alphapreprocessing' => 1,
	'alphasample' => 1,
	'alternateduotonecolors' => 1,
	'alternatesourceurl' => 1,
	'alternatespotcolors' => 1,
	'ambienceinfo' => 1,
	'anim' => 1,
	'animationiterations' => 1,
	'animationloopcount' => 1,
	'anmf' => 1,
	'anniversary' => 1,
	'annotation' => 1,
	'annotations' => 1,
	'annotationusagerights' => 1,
	'announce' => 1,
	'announcelist1' => 1,
	'anta' => 1,
	'aperture' => 1,
	'aperturedisplayed' => 1,
	'aperturemode' => 1,
	'apeversion' => 1,
	'app14flags0' => 1,
	'app14flags1' => 1,
	'app1_profile' => 1,
	'apple-fi' => 1,
	'applestoreaccount' => 1,
	'applestoreaccounttype' => 1,
	'applestorecatalogid' => 1,
	'applestorecountry' => 1,
	'application' => 1,
	'applicationdata' => 1,
	'applicationmissingmsg' => 1,
	'applicationversion' => 1,
	'appversion' => 1,
	'archivallocation' => 1,
	'archivedfilename' => 1,
	'ardronefile' => 1,
	'ardronetelemetry' => 1,
	'arranger' => 1,
	'arrangerkeywords' => 1,
	'artist2' => 1,
	'artistlen' => 1,
	'artisturl' => 1,
	'artwork' => 1,
	'ascender' => 1,
	'ascent' => 1,
	'asfleakybucketpairs' => 1,
	'asfpacketcount' => 1,
	'asfsecurityobjectssize' => 1,
	'asin' => 1,
	'asin2' => 1,
	'aspectinfo' => 1,
	'aspectratiox' => 1,
	'aspectratioy' => 1,
	'assistantsname' => 1,
	'assistantsphone' => 1,
	'association' => 1,
	'assumeddisplaysize' => 1,
	'assumeddistanceview' => 1,
	'atmospherictemperature' => 1,
	'atmospherictransalpha1' => 1,
	'atmospherictransalpha2' => 1,
	'atmospherictransbeta1' => 1,
	'atmospherictransbeta2' => 1,
	'atmospherictransx' => 1,
	'atob0' => 1,
	'atob1' => 1,
	'atob2' => 1,
	'attachments' => 1,
	'attributes' => 1,
	'audible_cvrx' => 1,
	'audible_meta' => 1,
	'audible_meta2' => 1,
	'audible_tags' => 1,
	'audible_tseg' => 1,
	'audiences' => 1,
	'audioattributes' => 1,
	'audioavailablebitraterange' => 1,
	'audioavailablenumberchannels' => 1,
	'audioavgbitrate' => 1,
	'audiobitratecontrolmode' => 1,
	'audiobitspersample' => 1,
	'audiobytes' => 1,
	'audiocodec' => 1,
	'audiocodecdescription' => 1,
	'audiocodecid' => 1,
	'audiocodecinfo' => 1,
	'audiocodecname' => 1,
	'audiocodecprimemethod' => 1,
	'audiocomponentversion' => 1,
	'audiocurrenttargetbitrate' => 1,
	'audiodelay' => 1,
	'audiodoessamplerateconversion' => 1,
	'audioencoding' => 1,
	'audioencodingparamsversion' => 1,
	'audioextendfrequencies' => 1,
	'audiofilesize' => 1,
	'audiofileurl' => 1,
	'audioformat' => 1,
	'audioframesize' => 1,
	'audiogain' => 1,
	'audiohasvariablepacketbytesizes' => 1,
	'audioheader' => 1,
	'audioinfo' => 1,
	'audioinputbuffersize' => 1,
	'audioisinitialized' => 1,
	'audiolayer' => 1,
	'audiomaxbitrate' => 1,
	'audiomaximumpacketbytesize' => 1,
	'audiominimumdelaymode' => 1,
	'audiominimumnumberinputpackets' => 1,
	'audiominimumnumberoutputpackets' => 1,
	'audiomode' => 1,
	'audiooutputprecedence' => 1,
	'audiopacketframesize' => 1,
	'audioprofile' => 1,
	'audioprofileversion' => 1,
	'audioqualitysetting' => 1,
	'audiorequirespacketdescription' => 1,
	'audiosamplecount' => 1,
	'audiosampledesc' => 1,
	'audiosamplesize' => 1,
	'audiosize' => 1,
	'audiosourceurl' => 1,
	'audiostream' => 1,
	'audiostreamtype' => 1,
	'audiotrackid' => 1,
	'audiousedinputbuffersize' => 1,
	'audiouserecommendedsamplerate' => 1,
	'audiovbrquality' => 1,
	'audiovendorid' => 1,
	'audiozeroframespadded' => 1,
	'authenticationtime' => 1,
	'authenticationtype' => 1,
	'authoringsoftwarerelease' => 1,
	'authorlen' => 1,
	'authorship' => 1,
	'authorsortorder' => 1,
	'authorurl' => 1,
	'autosavefilepath' => 1,
	'autosaveformat' => 1,
	'autosummary' => 1,
	'aux' => 1,
	'averagebitrate' => 1,
	'averagelevel' => 1,
	'avgbitrate' => 1,
	'avgbytespersec' => 1,
	'avgpacketsize' => 1,
	'avgpdusize' => 1,
	'avgwidth' => 1,
	'avi1' => 1,
	'avif' => 1,
	'aviheader' => 1,
	'awbinfo' => 1,
	'axisdistancex' => 1,
	'axisdistancey' => 1,
	'axisdistancez' => 1,
	'background' => 1,
	'backgroundcolor' => 1,
	'backgroundcolorindicator' => 1,
	'backgroundcolorvalue' => 1,
	'backgroundimageid' => 1,
	'backgroundtiling' => 1,
	'backlight' => 1,
	'backserial' => 1,
	'backuptime' => 1,
	'badfaxlines' => 1,
	'bahpver' => 1,
	'balance' => 1,
	'balpver' => 1,
	'band' => 1,
	'bandwidthsharing' => 1,
	'bannerimage' => 1,
	'bannerimagedata' => 1,
	'bannerimagetype' => 1,
	'bannerimageurl' => 1,
	'barcode' => 1,
	'barometerinfo' => 1,
	'barometerinfoversion' => 1,
	'baselinelength' => 1,
	'baseviewpointnum' => 1,
	'basisobject' => 1,
	'bass' => 1,
	'battery' => 1,
	'batteryinfo' => 1,
	'bavpver' => 1,
	'bccaddresses' => 1,
	'bccnames' => 1,
	'beats-per-minute' => 1,
	'beatsperminute' => 1,
	'belowcolor' => 1,
	'beta' => 1,
	'billinginformation' => 1,
	'binaryfilter' => 1,
	'binaryxml' => 1,
	'birthday' => 1,
	'bitrate' => 1,
	'bitrateinfo' => 1,
	'bitratemutualexclusion' => 1,
	'bitsperextendedrunlength' => 1,
	'bitsperpixel' => 1,
	'bitsperrunlength' => 1,
	'blackleveldata' => 1,
	'blackmaskbottomborder' => 1,
	'blackmaskleftborder' => 1,
	'blackmaskrightborder' => 1,
	'blackmasktopborder' => 1,
	'blocklocation' => 1,
	'blocksize' => 1,
	'blocksizemax' => 1,
	'blocksizemin' => 1,
	'blockspercolumn' => 1,
	'blocksperframe' => 1,
	'blocksperrow' => 1,
	'blueadjust' => 1,
	'bluegain' => 1,
	'bluematrixcolumn' => 1,
	'blueprimary' => 1,
	'bluesample' => 1,
	'bluetrc' => 1,
	'bluex' => 1,
	'bluey' => 1,
	'boardtemperature' => 1,
	'bookname' => 1,
	'booktitle' => 1,
	'booktype' => 1,
	'bookversion' => 1,
	'bordercolor' => 1,
	'borderid' => 1,
	'borderinformation' => 1,
	'borderlocation' => 1,
	'bordername' => 1,
	'bordersversion' => 1,
	'bordertype' => 1,
	'bottommag' => 1,
	'boundaryorigin' => 1,
	'boundingbox' => 1,
	'bracketshot' => 1,
	'breakchar' => 1,
	'brightnessdata' => 1,
	'broadcast' => 1,
	'broadcastdate' => 1,
	'broadcastextension' => 1,
	'btoa0' => 1,
	'btoa1' => 1,
	'btoa2' => 1,
	'btod0' => 1,
	'btod1' => 1,
	'btod2' => 1,
	'btod3' => 1,
	'bufferaverage' => 1,
	'buffersize' => 1,
	'builddate' => 1,
	'buildversion' => 1,
	'businessaddress' => 1,
	'businesscity' => 1,
	'businesscountry-region' => 1,
	'businessfax' => 1,
	'businesshomepage' => 1,
	'businessphone' => 1,
	'businesspobox' => 1,
	'businesspostalcode' => 1,
	'businessstateorprovince' => 1,
	'businessstreet' => 1,
	'buynow' => 1,
	'buytickets' => 1,
	'bw_halftoninginfo' => 1,
	'bw_transferfunc' => 1,
	'bwfversion' => 1,
	'bytelength' => 1,
	'byteorder' => 1,
	'bytes' => 1,
	'bytesperminute' => 1,
	'cachecontrol' => 1,
	'cachedimageheight' => 1,
	'cachedimagewidth' => 1,
	'calculatedscalemax' => 1,
	'calculatedscalemin' => 1,
	'calibrationdatetime' => 1,
	'callbacknumber' => 1,
	'callletters' => 1,
	'camcore' => 1,
	'camera' => 1,
	'camera1' => 1,
	'camera2' => 1,
	'cameraarrangementinterval' => 1,
	'camerabacktype' => 1,
	'camerabody' => 1,
	'camerabyteorder' => 1,
	'cameradatetime' => 1,
	'cameradirection' => 1,
	'cameraidentifier' => 1,
	'camerainfo' => 1,
	'camerainfo2' => 1,
	'camerainfo3' => 1,
	'camerainfoa100' => 1,
	'camerainfounknown' => 1,
	'cameramaker' => 1,
	'cameramanufacturer' => 1,
	'cameramotion' => 1,
	'cameraname' => 1,
	'cameraobjbacktype' => 1,
	'cameraobject' => 1,
	'cameraobjname' => 1,
	'cameraobjtype' => 1,
	'cameraobjversion' => 1,
	'camerapartnumber' => 1,
	'cameraprofileversion' => 1,
	'camerascalemax' => 1,
	'camerascalemin' => 1,
	'camerasettings' => 1,
	'camerasettings2' => 1,
	'camerasettings3' => 1,
	'camerasettingsa100' => 1,
	'camerasettingsifd' => 1,
	'camerasettingsunknown' => 1,
	'camerasetup' => 1,
	'camerasoftware' => 1,
	'cameraspecification' => 1,
	'can_skip_backward' => 1,
	'can_skip_forward' => 1,
	'canon' => 1,
	'canon_afinfo2_0x000d' => 1,
	'canon_afinfo_0x000b' => 1,
	'canonafinfo' => 1,
	'canonafinfo2' => 1,
	'canoncamerainfo1000d' => 1,
	'canoncamerainfo1100d' => 1,
	'canoncamerainfo1d' => 1,
	'canoncamerainfo1dmkii' => 1,
	'canoncamerainfo1dmkiii' => 1,
	'canoncamerainfo1dmkiin' => 1,
	'canoncamerainfo1dmkiv' => 1,
	'canoncamerainfo1dx' => 1,
	'canoncamerainfo40d' => 1,
	'canoncamerainfo450d' => 1,
	'canoncamerainfo500d' => 1,
	'canoncamerainfo50d' => 1,
	'canoncamerainfo550d' => 1,
	'canoncamerainfo5d' => 1,
	'canoncamerainfo5dmkii' => 1,
	'canoncamerainfo5dmkiii' => 1,
	'canoncamerainfo600d' => 1,
	'canoncamerainfo60d' => 1,
	'canoncamerainfo650d' => 1,
	'canoncamerainfo6d' => 1,
	'canoncamerainfo70d' => 1,
	'canoncamerainfo7d' => 1,
	'canoncamerainfopowershot' => 1,
	'canoncamerainfopowershot2' => 1,
	'canoncamerainfounknown' => 1,
	'canoncamerainfounknown16' => 1,
	'canoncamerainfounknown32' => 1,
	'canoncamerasettings' => 1,
	'canoncnop' => 1,
	'canoncnth' => 1,
	'canoncolorinfo1' => 1,
	'canoncolorinfo2' => 1,
	'canonfileinfo' => 1,
	'canonflags' => 1,
	'canonfocallength' => 1,
	'canonimageheight' => 1,
	'canonimagewidth' => 1,
	'canonpanorama' => 1,
	'canonrawmakemodel' => 1,
	'canonshotinfo' => 1,
	'canonskip' => 1,
	'canseekontime' => 1,
	'canseektoend' => 1,
	'capheight' => 1,
	'captiontext' => 1,
	'captprofbacktype' => 1,
	'captprofname' => 1,
	'captproftype' => 1,
	'captprofversion' => 1,
	'captureconditionspar' => 1,
	'capturedevicefid' => 1,
	'captureobjbacktype' => 1,
	'captureobjname' => 1,
	'captureobjtype' => 1,
	'captureobjversion' => 1,
	'captureprofile' => 1,
	'captureresolution' => 1,
	'captureserial' => 1,
	'capturesetup' => 1,
	'capturexresolution' => 1,
	'capturexresolutionunit' => 1,
	'captureyresolution' => 1,
	'captureyresolutionunit' => 1,
	'carphone' => 1,
	'casio' => 1,
	'casiodata' => 1,
	'casiojunk' => 1,
	'casioquality' => 1,
	'casioqvmi' => 1,
	'cast' => 1,
	'cc' => 1,
	'ccaddresses' => 1,
	'ccdrect' => 1,
	'ccdvalidrect' => 1,
	'ccdvideorect' => 1,
	'ccnames' => 1,
	'cddb1info' => 1,
	'cddbdiscplaytime' => 1,
	'cddbdisctracks' => 1,
	'cddbtracknumber' => 1,
	'cdetype' => 1,
	'cdtrackenabled' => 1,
	'cell' => 1,
	'cellphone' => 1,
	'centerdarkrect' => 1,
	'cfalayout' => 1,
	'cfaplanecolor' => 1,
	'channelmode' => 1,
	'channelnumber' => 1,
	'chapter' => 1,
	'chaptercount' => 1,
	'chapterlist' => 1,
	'chapterlisttrackid' => 1,
	'chaptername' => 1,
	'chapternum' => 1,
	'chapternumber' => 1,
	'characterescapesequence' => 1,
	'characters' => 1,
	'characterset' => 1,
	'characterswithspaces' => 1,
	'charcountwithspaces' => 1,
	'chartarget' => 1,
	'chartcontourinterval' => 1,
	'chartcorrdate' => 1,
	'chartcountryorigin' => 1,
	'chartdepthunits' => 1,
	'chartformat' => 1,
	'chartmagvar' => 1,
	'chartmagvarannchange' => 1,
	'chartmagvaryear' => 1,
	'chartrasteredition' => 1,
	'chartsoundingdatum' => 1,
	'chartsource' => 1,
	'chartsourcedate' => 1,
	'chartsourceedition' => 1,
	'chartwgsnsshift' => 1,
	'checkedby' => 1,
	'children' => 1,
	'chmversion' => 1,
	'chromaticaberrationcorrparams' => 1,
	'chromaticadaptation' => 1,
	'chromaticities' => 1,
	'chromaticity' => 1,
	'chromaticitychannel1' => 1,
	'chromaticitychannel2' => 1,
	'chromaticitychannel3' => 1,
	'chromaticitychannel4' => 1,
	'chromaticitychannels' => 1,
	'chromaticitycolorant' => 1,
	'chunkoffset' => 1,
	'chunkoffset64' => 1,
	'ciff' => 1,
	'cinematographer' => 1,
	'cip3datafile' => 1,
	'cip3sheet' => 1,
	'cip3side' => 1,
	'circleofconfusion' => 1,
	'class' => 1,
	'classification' => 1,
	'cleanaperture' => 1,
	'cleanaperturedimensions' => 1,
	'cleanapertureheight' => 1,
	'cleanapertureoffsetx' => 1,
	'cleanapertureoffsety' => 1,
	'cleanaperturewidth' => 1,
	'cleanfaxdata' => 1,
	'clientid' => 1,
	'clipboundary' => 1,
	'clipfilename' => 1,
	'clipid' => 1,
	'clipobjects' => 1,
	'clippath' => 1,
	'clippingboundary' => 1,
	'clippinglimit' => 1,
	'clippingpathname' => 1,
	'cloneid' => 1,
	'cloneobject' => 1,
	'clonetype' => 1,
	'closedcaptioning' => 1,
	'cmmflags' => 1,
	'cmykequivalent' => 1,
	'coarsedata' => 1,
	'coarsemapimage' => 1,
	'coarsemapimageheight' => 1,
	'coarsemapimagetype' => 1,
	'coarsemapimagewidth' => 1,
	'codecflavorid' => 1,
	'codeclist' => 1,
	'codedframesize' => 1,
	'codepage' => 1,
	'codesize' => 1,
	'codestreamheader' => 1,
	'codestreamregistration' => 1,
	'codeversion' => 1,
	'codinghistory' => 1,
	'codingmethods' => 1,
	'codirectors' => 1,
	'colorant1coordinates' => 1,
	'colorant1name' => 1,
	'colorant2coordinates' => 1,
	'colorant2name' => 1,
	'colorant3coordinates' => 1,
	'colorant3name' => 1,
	'colorantcount' => 1,
	'colorantorder' => 1,
	'coloranttable' => 1,
	'coloranttableout' => 1,
	'coloraverages' => 1,
	'colorbalance0100' => 1,
	'colorbalance0102' => 1,
	'colorbalance0103' => 1,
	'colorbalance02' => 1,
	'colorbalance0205' => 1,
	'colorbalance0209' => 1,
	'colorbalance0211' => 1,
	'colorbalance0213' => 1,
	'colorbalance0215' => 1,
	'colorbalancea' => 1,
	'colorbalanceunknown' => 1,
	'colorbalanceunknown02' => 1,
	'colorbalanceunknown04' => 1,
	'colorbitdepth' => 1,
	'colorboostdata' => 1,
	'colorbw' => 1,
	'colorcalib' => 1,
	'colorcalibrationmatrix' => 1,
	'colorcasts' => 1,
	'colorcharacterization' => 1,
	'colorcoefs' => 1,
	'colorcomponents' => 1,
	'colordata1' => 1,
	'colordata2' => 1,
	'colordata3' => 1,
	'colordata4' => 1,
	'colordata5' => 1,
	'colordata6' => 1,
	'colordata7' => 1,
	'colordata8' => 1,
	'colordataunknown' => 1,
	'colorgroup' => 1,
	'colorhalftoninginfo' => 1,
	'colorimetricintentimagestate' => 1,
	'colorimetry' => 1,
	'colorinfo' => 1,
	'colormap' => 1,
	'colorobjbacktype' => 1,
	'colorobjname' => 1,
	'colorobjtype' => 1,
	'colorobjversion' => 1,
	'colorpalette' => 1,
	'colorprimaries' => 1,
	'colorresolutiondepth' => 1,
	'colorresponseunit' => 1,
	'colors' => 1,
	'colorsamplersresource' => 1,
	'colorsamplersresource2' => 1,
	'colorsetup' => 1,
	'colorspacedata' => 1,
	'colorspecapproximation' => 1,
	'colorspecdata' => 1,
	'colorspecification' => 1,
	'colorspecmethod' => 1,
	'colorspecprecedence' => 1,
	'colortable' => 1,
	'colortransferfuncs' => 1,
	'colortransform' => 1,
	'colortwistmatrix' => 1,
	'colortype' => 1,
	'command' => 1,
	'commandlinearguments' => 1,
	'commentlen' => 1,
	'comments' => 1,
	'commenttime' => 1,
	'commercialurl' => 1,
	'commissioned' => 1,
	'common' => 1,
	'commonnetworkrellink' => 1,
	'commonpathsuffix' => 1,
	'compactsamplesizes' => 1,
	'company' => 1,
	'companymainphone' => 1,
	'companyname' => 1,
	'compatibility' => 1,
	'compatiblebrands' => 1,
	'compatiblefontname' => 1,
	'compilation' => 1,
	'complete' => 1,
	'compobj' => 1,
	'compobjusertype' => 1,
	'compobjusertypelen' => 1,
	'componentbitdepth' => 1,
	'componentdefinition' => 1,
	'componentmapping' => 1,
	'composerkeywords' => 1,
	'composers' => 1,
	'composersortorder' => 1,
	'compositinglayerheader' => 1,
	'composition' => 1,
	'compositionmode' => 1,
	'compositionoptions' => 1,
	'compositiontimetosample' => 1,
	'compositiontodecodetimelinemapping' => 1,
	'compressed' => 1,
	'compressedannotation' => 1,
	'compresseddatalength' => 1,
	'compresseddataoffset' => 1,
	'compressedmovie' => 1,
	'compressedsize' => 1,
	'compressedtext' => 1,
	'compressionclass' => 1,
	'compressionlevel' => 1,
	'compressiontype' => 1,
	'compressorid' => 1,
	'compressorname' => 1,
	'compressorversion' => 1,
	'computedatmospherictrans' => 1,
	'computer' => 1,
	'concreteflag' => 1,
	'condition' => 1,
	'conditionalfec' => 1,
	'conductor' => 1,
	'conductors' => 1,
	'confirmedobjectsize' => 1,
	'connectionspaceilluminant' => 1,
	'consecutivebadfaxlines' => 1,
	'consoledata' => 1,
	'consolefedata' => 1,
	'cont' => 1,
	'contactnames' => 1,
	'containerformat' => 1,
	'containerversion' => 1,
	'contake' => 1,
	'contentbranding' => 1,
	'contentcreatedate' => 1,
	'contentdescription' => 1,
	'contentdescriptionnotes' => 1,
	'contentdisposition' => 1,
	'contentdistributor' => 1,
	'contentdistributorduration' => 1,
	'contentdistributorid' => 1,
	'contentdistributortype' => 1,
	'contentencryption' => 1,
	'contentgroupdescription' => 1,
	'contentid' => 1,
	'contentlanguage' => 1,
	'contentrating' => 1,
	'contents' => 1,
	'contentscripttype' => 1,
	'contentstyletype' => 1,
	'contiguouscodestream' => 1,
	'contrastadjustment' => 1,
	'contrastinfo' => 1,
	'convergenceangle' => 1,
	'convergencebaseimage' => 1,
	'convergencedistance' => 1,
	'conversationid' => 1,
	'copyrightfilename' => 1,
	'copyrightlen' => 1,
	'copyrighturl' => 1,
	'correctionmethod' => 1,
	'costumedesigner' => 1,
	'count' => 1,
	'countinfo' => 1,
	'country-region' => 1,
	'coverart' => 1,
	'coverartmimetype' => 1,
	'coverarttype' => 1,
	'coveruri' => 1,
	'cpuarchitecture' => 1,
	'cpubyteorder' => 1,
	'cpucount' => 1,
	'cpusubtype' => 1,
	'cputype' => 1,
	'cpuversions' => 1,
	'crcdevelparams' => 1,
	'crdinfo' => 1,
	'createdby' => 1,
	'creatingapplication' => 1,
	'creatingtransform' => 1,
	'creationpathvector' => 1,
	'creatorappid' => 1,
	'creatorapplication' => 1,
	'creatorappversion' => 1,
	'creatoratom' => 1,
	'creatorbuildnumber' => 1,
	'creatorbuildnumber2' => 1,
	'creatorinfo' => 1,
	'creatormajorversion' => 1,
	'creatorminorversion' => 1,
	'creatorsoftware' => 1,
	'creatorversion' => 1,
	'cropdata' => 1,
	'cropinfo' => 1,
	'cropped' => 1,
	'cropxcommonoffset' => 1,
	'cropxoffset' => 1,
	'cropxoffset2' => 1,
	'cropxsize' => 1,
	'cropxviewpointnumber' => 1,
	'cropxviewpointnumber2' => 1,
	'cropycommonoffset' => 1,
	'cropyoffset' => 1,
	'cropyoffset2' => 1,
	'cropysize' => 1,
	'cropyviewpointnumber' => 1,
	'cropyviewpointnumber2' => 1,
	'cross-reference' => 1,
	'crossref' => 1,
	'crs' => 1,
	'crwparam' => 1,
	'cs1' => 1,
	'cuepoint' => 1,
	'cuesheet' => 1,
	'currentbitrate' => 1,
	'currentiptcdigest' => 1,
	'currenttime' => 1,
	'currentuser' => 1,
	'cursorsize' => 1,
	'customfunctions10d' => 1,
	'customfunctions1d' => 1,
	'customfunctions2' => 1,
	'customfunctions20d' => 1,
	'customfunctions30d' => 1,
	'customfunctions350d' => 1,
	'customfunctions400d' => 1,
	'customfunctions5d' => 1,
	'customfunctionsd30' => 1,
	'customfunctionsd60' => 1,
	'customfunctionsunknown' => 1,
	'customsettingsd3' => 1,
	'customsettingsd300' => 1,
	'customsettingsd300s' => 1,
	'customsettingsd3s' => 1,
	'customsettingsd3x' => 1,
	'customsettingsd4' => 1,
	'customsettingsd40' => 1,
	'customsettingsd4s' => 1,
	'customsettingsd5000' => 1,
	'customsettingsd5100' => 1,
	'customsettingsd5200' => 1,
	'customsettingsd700' => 1,
	'customsettingsd7000' => 1,
	'customsettingsd80' => 1,
	'customsettingsd800' => 1,
	'customsettingsd810' => 1,
	'customsettingsd90' => 1,
	'customsettingsoffset' => 1,
	'd-lightinghqdata' => 1,
	'd-lightinghsdata' => 1,
	'darkcorrectiontype' => 1,
	'darwindata' => 1,
	'data' => 1,
	'data1' => 1,
	'data2' => 1,
	'databasename' => 1,
	'datacreatedate' => 1,
	'datadump' => 1,
	'datadump2' => 1,
	'datainfo' => 1,
	'datainformation' => 1,
	'datakey' => 1,
	'datalen' => 1,
	'datalength' => 1,
	'datalocation' => 1,
	'datamodifydate' => 1,
	'dataobject' => 1,
	'dataobjectid' => 1,
	'dataobjectstatus' => 1,
	'dataobjecttitle' => 1,
	'dataoffset' => 1,
	'dataoffsets' => 1,
	'datapackets' => 1,
	'datarate' => 1,
	'dataref' => 1,
	'datareference' => 1,
	'datasign' => 1,
	'datasize' => 1,
	'datatype' => 1,
	'datawindow' => 1,
	'dateaccessed' => 1,
	'datearchived' => 1,
	'datecompleted' => 1,
	'dateimported' => 1,
	'datelastsaved' => 1,
	'datemodified' => 1,
	'datepicturetaken' => 1,
	'datereceived' => 1,
	'datereleased' => 1,
	'datetime1' => 1,
	'datetime2' => 1,
	'datetimecreated' => 1,
	'datetimeend' => 1,
	'datetimegenerated' => 1,
	'datevisited' => 1,
	'dc' => 1,
	'dcem' => 1,
	'dcme' => 1,
	'dctencodeversion' => 1,
	'dealeridnumber' => 1,
	'decimationmethod' => 1,
	'decimationprefilterwidth' => 1,
	'decode' => 1,
	'decodeconfig' => 1,
	'decodertable' => 1,
	'decodertablenumber' => 1,
	'decoderversion' => 1,
	'defaultaudiostream' => 1,
	'defaultchar' => 1,
	'defaultdisplayheight' => 1,
	'defaultdisplaywidth' => 1,
	'defaultimagecolor' => 1,
	'defaultrgb' => 1,
	'defaultstyle' => 1,
	'defineobject' => 1,
	'definequantizationtable' => 1,
	'delay' => 1,
	'deltapngheader' => 1,
	'deltatype' => 1,
	'deltaxy' => 1,
	'department' => 1,
	'dependentimage1entrynumber' => 1,
	'dependentimage2entrynumber' => 1,
	'depth' => 1,
	'descender' => 1,
	'designer' => 1,
	'designerurl' => 1,
	'desiredreproductions' => 1,
	'destinationid' => 1,
	'detector' => 1,
	'detectorboard' => 1,
	'deviceattributes' => 1,
	'devicemanufacturer' => 1,
	'devicemfgdesc' => 1,
	'devicemodel' => 1,
	'devicemodeldesc' => 1,
	'devicename' => 1,
	'devicesettings' => 1,
	'dex' => 1,
	'dicom' => 1,
	'dictionary' => 1,
	'dictionaryshortname' => 1,
	'digikam' => 1,
	'digitalcreationdatetime' => 1,
	'digitaleffectsname' => 1,
	'digitaleffectstype' => 1,
	'digitaleffectsversion' => 1,
	'digitalimagebroker' => 1,
	'digitalsignature' => 1,
	'dimensions' => 1,
	'directors' => 1,
	'discardobjects' => 1,
	'disknumber' => 1,
	'displayartist' => 1,
	'displayinfo' => 1,
	'displayresolution' => 1,
	'displaysize' => 1,
	'displayunits' => 1,
	'displaywindow' => 1,
	'displayxresolution' => 1,
	'displayxresolutionunit' => 1,
	'displayyresolution' => 1,
	'displayyresolutionunit' => 1,
	'dispose' => 1,
	'disposition' => 1,
	'distortinfo' => 1,
	'distortioncorrparams' => 1,
	'distortioninfo' => 1,
	'distortionversion' => 1,
	'distributedby' => 1,
	'distribution' => 1,
	'dittokey' => 1,
	'division' => 1,
	'djvuversion' => 1,
	'dlnaserverudn' => 1,
	'dlnasourceuri' => 1,
	'dlodata' => 1,
	'dlodatalength' => 1,
	'docclass' => 1,
	'docmdp' => 1,
	'docrights' => 1,
	'docsecurity' => 1,
	'doctype' => 1,
	'documentinfo' => 1,
	'documentnumber' => 1,
	'documentusagerights' => 1,
	'dof' => 1,
	'donotshow' => 1,
	'dotsperinch' => 1,
	'dpxfilesize' => 1,
	'dr4' => 1,
	'dr4header' => 1,
	'driveserialnumber' => 1,
	'drivetype' => 1,
	'drm' => 1,
	'drm_contentid' => 1,
	'drm_drmheader' => 1,
	'drm_drmheader_contentdistributor' => 1,
	'drm_drmheader_contentid' => 1,
	'drm_drmheader_individualizedversion' => 1,
	'drm_drmheader_keyid' => 1,
	'drm_drmheader_licenseacqurl' => 1,
	'drm_drmheader_subscriptioncontentid' => 1,
	'drm_e-bookbaseid' => 1,
	'drm_individualizedversion' => 1,
	'drm_keyid' => 1,
	'drm_lasignaturecert' => 1,
	'drm_lasignaturelicsrvcert' => 1,
	'drm_lasignatureprivkey' => 1,
	'drm_lasignaturerootcert' => 1,
	'drm_licenseacqurl' => 1,
	'drm_v1licenseacqurl' => 1,
	'drmcommerceid' => 1,
	'drmindividualizedversion' => 1,
	'drmkeyid' => 1,
	'drmserverid' => 1,
	'dropbykeyword' => 1,
	'dropchunks' => 1,
	'dtcpiphost' => 1,
	'dtcpipport' => 1,
	'dtob0' => 1,
	'dtob1' => 1,
	'dtob2' => 1,
	'dtob3' => 1,
	'ducky' => 1,
	'duedate' => 1,
	'duotonehalftoninginfo' => 1,
	'duotoneimageinfo' => 1,
	'duotonetransferfuncs' => 1,
	'dustdeleteapplied' => 1,
	'dustinfo' => 1,
	'dvdid' => 1,
	'dwc' => 1,
	'e-mail2' => 1,
	'e-mail3' => 1,
	'e-mailaddress' => 1,
	'e-maildisplayname' => 1,
	'e-maillist' => 1,
	'edit1' => 1,
	'edit2' => 1,
	'edit3' => 1,
	'edit4' => 1,
	'edit4data' => 1,
	'edit5' => 1,
	'edit6' => 1,
	'edit7' => 1,
	'edit8' => 1,
	'edit9' => 1,
	'editdata' => 1,
	'editedby' => 1,
	'editor' => 1,
	'edittagarray' => 1,
	'effect' => 1,
	'effectivebw' => 1,
	'effectsvisible' => 1,
	'eighthlanguage' => 1,
	'elementarystreamtrack' => 1,
	'embeddedaudiofile' => 1,
	'embeddedaudiofilename' => 1,
	'embeddedfile' => 1,
	'embeddedfilename' => 1,
	'embeddedfileusagerights' => 1,
	'embeddedimage' => 1,
	'embeddedimagecolorspace' => 1,
	'embeddedimagefilter' => 1,
	'embeddedimageheight' => 1,
	'embeddedimagename' => 1,
	'embeddedimagetype' => 1,
	'embeddedimagewidth' => 1,
	'emphasis' => 1,
	'encodedby' => 1,
	'encodedpixelsdimensions' => 1,
	'encodedusing' => 1,
	'encodedwith' => 1,
	'encoder' => 1,
	'encodersettings' => 1,
	'encodervendor' => 1,
	'encoderversion' => 1,
	'encoding' => 1,
	'encodingparams' => 1,
	'encodingprocess' => 1,
	'encodingscheme' => 1,
	'encodingsettings' => 1,
	'encodingtime' => 1,
	'encrypt' => 1,
	'encryption' => 1,
	'enddate' => 1,
	'endpoints' => 1,
	'endtime' => 1,
	'endtimecode' => 1,
	'entrypoint' => 1,
	'entrytype' => 1,
	'environmentmap' => 1,
	'envvardata' => 1,
	'episodeglobaluniqueid' => 1,
	'episodename' => 1,
	'eppim' => 1,
	'eprint' => 1,
	'epsoptions' => 1,
	'equipment' => 1,
	'equipmentifd' => 1,
	'error' => 1,
	'errorcorrection' => 1,
	'errorcorrectiontype' => 1,
	'escchar' => 1,
	'estimatedatmospherictrans' => 1,
	'evalstate' => 1,
	'events' => 1,
	'evstepinfo' => 1,
	'exif_profile' => 1,
	'exifdata' => 1,
	'exifex' => 1,
	'exifinfo' => 1,
	'exifinfo2' => 1,
	'exifinformation' => 1,
	'exifoffset' => 1,
	'exiftoolversion' => 1,
	'expandfilm' => 1,
	'expandfilterlens' => 1,
	'expandflashlamp' => 1,
	'expandlens' => 1,
	'expandscanner' => 1,
	'expandsoftware' => 1,
	'expires' => 1,
	'exportimage' => 1,
	'exposurebias' => 1,
	'exposureinfo' => 1,
	'exposureunknown' => 1,
	'expressionmedia' => 1,
	'exrversion' => 1,
	'extcache' => 1,
	'extendedaviheader' => 1,
	'extendedcontentdescr' => 1,
	'extendedcontentencryption' => 1,
	'extendedinfo' => 1,
	'extendedstreamprops' => 1,
	'extendedxmp' => 1,
	'extenderstatus' => 1,
	'extensionanimation' => 1,
	'extensionclassid' => 1,
	'extensioncreatedate' => 1,
	'extensiondescription' => 1,
	'extensionicc' => 1,
	'extensionmodifydate' => 1,
	'extensionname' => 1,
	'extensionpersistence' => 1,
	'extensions' => 1,
	'extensionxmp' => 1,
	'extensis' => 1,
	'externalleading' => 1,
	'externaltriggercount' => 1,
	'extraflags' => 1,
	'extrainfo' => 1,
	'extrainfo2' => 1,
	'extrainfo3' => 1,
	'extrasamples' => 1,
	'f-stop' => 1,
	'face1birthday' => 1,
	'face1category' => 1,
	'face1name' => 1,
	'face2birthday' => 1,
	'face2category' => 1,
	'face2name' => 1,
	'face3birthday' => 1,
	'face3category' => 1,
	'face3name' => 1,
	'face4birthday' => 1,
	'face4category' => 1,
	'face4name' => 1,
	'face5birthday' => 1,
	'face5category' => 1,
	'face5name' => 1,
	'face6birthday' => 1,
	'face6category' => 1,
	'face6name' => 1,
	'face7birthday' => 1,
	'face7category' => 1,
	'face7name' => 1,
	'face8birthday' => 1,
	'face8category' => 1,
	'face8name' => 1,
	'facedetect1' => 1,
	'facedetect2' => 1,
	'facedetect3' => 1,
	'facedetinfo' => 1,
	'faceinfo' => 1,
	'faceinfo1' => 1,
	'faceinfo2' => 1,
	'faceinfoa' => 1,
	'faceinfolength' => 1,
	'faceinfooffset' => 1,
	'facepos' => 1,
	'facerecinfo' => 1,
	'facesize' => 1,
	'fastseek' => 1,
	'faxprofile' => 1,
	'faxrecvparams' => 1,
	'faxrecvtime' => 1,
	'faxsubaddress' => 1,
	'fedexedr' => 1,
	'fffheader' => 1,
	'fieldmdp' => 1,
	'fieldofview' => 1,
	'fieldpermissions' => 1,
	'fifthlanguage' => 1,
	'file1duration' => 1,
	'file1length' => 1,
	'file1md5sum' => 1,
	'file1media' => 1,
	'file1path' => 1,
	'file1pathutf-8' => 1,
	'fileaccessdate' => 1,
	'fileas' => 1,
	'fileattributes' => 1,
	'fileblockcount' => 1,
	'fileblocksize' => 1,
	'filecount' => 1,
	'filedescription' => 1,
	'filedeviceid' => 1,
	'filedevicenumber' => 1,
	'fileflags' => 1,
	'fileflagsmask' => 1,
	'filefunctionflags' => 1,
	'fileglobalprofile' => 1,
	'filegroupid' => 1,
	'filehardlinks' => 1,
	'fileid' => 1,
	'fileinfo' => 1,
	'fileinfolen' => 1,
	'fileinfolen2' => 1,
	'fileinfoproperties' => 1,
	'fileinfoversion' => 1,
	'fileinodechangedate' => 1,
	'fileinodenumber' => 1,
	'filelength' => 1,
	'fileos' => 1,
	'fileowner' => 1,
	'filepath' => 1,
	'filepermissions' => 1,
	'fileprofileversion' => 1,
	'fileproperties' => 1,
	'files' => 1,
	'filesequence' => 1,
	'filesize' => 1,
	'filesizebytes' => 1,
	'filesubtype' => 1,
	'filetype' => 1,
	'filetypeextension' => 1,
	'fileurl' => 1,
	'fileuserid' => 1,
	'fileversionnumber' => 1,
	'fillattributes' => 1,
	'fillmethod' => 1,
	'filmbrand' => 1,
	'filmcategory' => 1,
	'filmframenumber' => 1,
	'filmgencode' => 1,
	'filmproductcode' => 1,
	'filmrollnumber' => 1,
	'filmsize' => 1,
	'filter' => 1,
	'filterinfo' => 1,
	'filtering' => 1,
	'filtermodel' => 1,
	'filterpartnumber' => 1,
	'filterserialnumber' => 1,
	'finalframeblocks' => 1,
	'firmwareinfo' => 1,
	'firmwareversions' => 1,
	'firstchar' => 1,
	'firstlanguage' => 1,
	'firstname' => 1,
	'firstobject' => 1,
	'firstobjectid' => 1,
	'fisheyefilter' => 1,
	'flac' => 1,
	'flagcolor' => 1,
	'flags' => 1,
	'flagstatus' => 1,
	'flashattributes' => 1,
	'flashexpcomp' => 1,
	'flashinfo' => 1,
	'flashinfo0100' => 1,
	'flashinfo0102' => 1,
	'flashinfo0103' => 1,
	'flashinfounknown' => 1,
	'flashinfoversion' => 1,
	'flashpixstreamfieldoffset' => 1,
	'flashpixstreampathname' => 1,
	'flashpower' => 1,
	'flashsyncmode' => 1,
	'flashttlmode' => 1,
	'flashversion' => 1,
	'flavor' => 1,
	'flir' => 1,
	'flir_gps' => 1,
	'flir_moreinfo' => 1,
	'flir_params' => 1,
	'flir_parts' => 1,
	'flir_serial' => 1,
	'flir_unknown' => 1,
	'flir_unknownuuid' => 1,
	'focallength35efl' => 1,
	'focallength35mm' => 1,
	'focalplaneafpointsused' => 1,
	'focalplanecolorimetryestimates' => 1,
	'focalrange' => 1,
	'focusdistance2' => 1,
	'focusinfo' => 1,
	'focusinfoifd' => 1,
	'focuspos' => 1,
	'folder' => 1,
	'folderpath' => 1,
	'font' => 1,
	'fontsize' => 1,
	'fontsubfamily' => 1,
	'fontsubfamilyid' => 1,
	'fonttable' => 1,
	'fontweight' => 1,
	'footerposition' => 1,
	'footnotes' => 1,
	'form' => 1,
	'formattag' => 1,
	'formatter' => 1,
	'formatversion' => 1,
	'formatversiontime' => 1,
	'formextrausagerights' => 1,
	'formfields' => 1,
	'formusagerights' => 1,
	'forwardto' => 1,
	'fotostation' => 1,
	'fourcc' => 1,
	'fourcc1' => 1,
	'fourcc2' => 1,
	'fourcc2len' => 1,
	'fourcc3' => 1,
	'fourcc3len' => 1,
	'fourthlanguage' => 1,
	'fov' => 1,
	'fovcot' => 1,
	'fpfversion' => 1,
	'fpv' => 1,
	'fpxr' => 1,
	'fractalparameters' => 1,
	'fragmentlist' => 1,
	'fragmenttable' => 1,
	'frame' => 1,
	'frameexposuretime' => 1,
	'frameid' => 1,
	'frameinfo' => 1,
	'framepriority' => 1,
	'framereadouttime' => 1,
	'framesize' => 1,
	'framesizemax' => 1,
	'framesizemin' => 1,
	'framespersecond' => 1,
	'free' => 1,
	'free-busystatus' => 1,
	'freebytecounts' => 1,
	'freeoffsets' => 1,
	'frequency' => 1,
	'fromaddresses' => 1,
	'fromnames' => 1,
	'fstype' => 1,
	'fujifilm' => 1,
	'fujifilmffmv' => 1,
	'fujifilmmvtg' => 1,
	'fujifilmtags' => 1,
	'fujiifd' => 1,
	'fujilayout' => 1,
	'fullname' => 1,
	'fullscreen' => 1,
	'gain' => 1,
	'gaindeaddata' => 1,
	'gaindeadmapimage' => 1,
	'gaindeadmapimageheight' => 1,
	'gaindeadmapimagetype' => 1,
	'gaindeadmapimagewidth' => 1,
	'gammainfo' => 1,
	'gamut' => 1,
	'gapless' => 1,
	'gdalmetadata' => 1,
	'gdalnodata' => 1,
	'geminfo' => 1,
	'genbalance' => 1,
	'gender' => 1,
	'generator' => 1,
	'generatorversion' => 1,
	'genflags' => 1,
	'gengraphicsmode' => 1,
	'genmediaheader' => 1,
	'genmediainfo' => 1,
	'genmediaversion' => 1,
	'genopcolor' => 1,
	'genr' => 1,
	'genreid' => 1,
	'geo' => 1,
	'geogangularunits' => 1,
	'geogangularunitsize' => 1,
	'geogazimuthunits' => 1,
	'geogcitation' => 1,
	'geogellipsoid' => 1,
	'geoggeodeticdatum' => 1,
	'geoginvflattening' => 1,
	'geoglinearunits' => 1,
	'geoglinearunitsize' => 1,
	'geogprimemeridian' => 1,
	'geogprimemeridianlong' => 1,
	'geographictype' => 1,
	'geogsemimajoraxis' => 1,
	'geogsemiminoraxis' => 1,
	'geogtowgs84' => 1,
	'geotiffversion' => 1,
	'getty' => 1,
	'gidcver' => 1,
	'gidpver' => 1,
	'gifapplicationextension' => 1,
	'gifgraphiccontrolextension' => 1,
	'gifplaintextextension' => 1,
	'gifversion' => 1,
	'gipc_cpld' => 1,
	'gipcver' => 1,
	'givenname' => 1,
	'gixiver' => 1,
	'globalinfo' => 1,
	'globalparametersifd' => 1,
	'globalpixelsize' => 1,
	'googlebot' => 1,
	'googlehostheader' => 1,
	'googlepingmessage' => 1,
	'googlepingurl' => 1,
	'googlesourcedata' => 1,
	'googlestarttime' => 1,
	'googletrackduration' => 1,
	'goprotype' => 1,
	'gpano' => 1,
	'gps' => 1,
	'gpscoordinates' => 1,
	'gpsinfo' => 1,
	'gpsposition' => 1,
	'grainybwfilter' => 1,
	'graphicconverter' => 1,
	'graphicsmode' => 1,
	'graphicstechnologystandardoutput' => 1,
	'grayresponsecurve' => 1,
	'graytrc' => 1,
	'greenadjust' => 1,
	'greengain' => 1,
	'greenmatrixcolumn' => 1,
	'greenprimary' => 1,
	'greensample' => 1,
	'greentrc' => 1,
	'greenx' => 1,
	'greeny' => 1,
	'gridguidesinfo' => 1,
	'group' => 1,
	'groupcaption' => 1,
	'grouping' => 1,
	'groupmutualexclusion' => 1,
	'gtcitation' => 1,
	'gtmodeltype' => 1,
	'gtrastertype' => 1,
	'guid' => 1,
	'handler' => 1,
	'handlerclass' => 1,
	'handlerdescription' => 1,
	'handlertype' => 1,
	'handlervendorid' => 1,
	'hasarbitrarydatastream' => 1,
	'hasattachedimages' => 1,
	'hasattachments' => 1,
	'hasaudio' => 1,
	'hascolormap' => 1,
	'hascuepoints' => 1,
	'hasfiletransferstream' => 1,
	'hasflag' => 1,
	'hasicc' => 1,
	'hasimage' => 1,
	'haskeyframes' => 1,
	'hasmetadata' => 1,
	'hasscript' => 1,
	'hasvideo' => 1,
	'hasxfa' => 1,
	'hcusage' => 1,
	'hdrinfo' => 1,
	'hdrl' => 1,
	'hdrtoninginfo' => 1,
	'hdvideo' => 1,
	'header' => 1,
	'header4' => 1,
	'headerext' => 1,
	'headerextension' => 1,
	'headersize' => 1,
	'headerversion' => 1,
	'headingpairs' => 1,
	'heightresolution' => 1,
	'hiddenslides' => 1,
	'highlightdata' => 1,
	'highlightendpoints' => 1,
	'hintformat' => 1,
	'hintheader' => 1,
	'hintinfo' => 1,
	'hintsampledesc' => 1,
	'hinttrackinfo' => 1,
	'hinttrackversion' => 1,
	'hintversion' => 1,
	'historybuffersize' => 1,
	'hobbies' => 1,
	'homeaddress' => 1,
	'homecity' => 1,
	'homecountry-region' => 1,
	'homefax' => 1,
	'homephone' => 1,
	'homepobox' => 1,
	'homepostalcode' => 1,
	'homestateorprovince' => 1,
	'homestreet' => 1,
	'horizontalresolution' => 1,
	'horizontalscale' => 1,
	'hotkey' => 1,
	'howpublished' => 1,
	'hp_tdhd' => 1,
	'htcbinary' => 1,
	'htcinfo' => 1,
	'htctrack' => 1,
	'http-equiv' => 1,
	'httphostheader' => 1,
	'huffmantable' => 1,
	'hyperfocaldistance' => 1,
	'hyperlinkbase' => 1,
	'hyperlinks' => 1,
	'hyperlinkschanged' => 1,
	'icc_untagged' => 1,
	'iccbased' => 1,
	'iconenvdata' => 1,
	'iconfilename' => 1,
	'iconindex' => 1,
	'iconuri' => 1,
	'ics' => 1,
	'id' => 1,
	'id3' => 1,
	'id3size' => 1,
	'id3v1' => 1,
	'id3v1_enh' => 1,
	'id3v2_2' => 1,
	'id3v2_3' => 1,
	'id3v2_4' => 1,
	'idc2_ifd' => 1,
	'idc_ifd' => 1,
	'idcpreviewimage' => 1,
	'idependentanddisposablesamples' => 1,
	'idsbasevalue' => 1,
	'ifd0_offset' => 1,
	'ihl_exif' => 1,
	'ihldata' => 1,
	'illustrator' => 1,
	'im' => 1,
	'imaddresses' => 1,
	'image' => 1,
	'image2description' => 1,
	'image3description' => 1,
	'image4description' => 1,
	'image5description' => 1,
	'image6description' => 1,
	'image7description' => 1,
	'image8description' => 1,
	'imagearrangement' => 1,
	'imageboardid' => 1,
	'imagebounds' => 1,
	'imagebytecount' => 1,
	'imageclass' => 1,
	'imagecolor' => 1,
	'imagecolorindicator' => 1,
	'imagecolorvalue' => 1,
	'imagedata' => 1,
	'imagedatadiscard' => 1,
	'imagedataoffset' => 1,
	'imagedepth' => 1,
	'imageelements' => 1,
	'imagefields' => 1,
	'imagefilename' => 1,
	'imageformat' => 1,
	'imagefullheight' => 1,
	'imagefullwidth' => 1,
	'imageheader' => 1,
	'imageid' => 1,
	'imageinfo' => 1,
	'imagelayer' => 1,
	'imagelength' => 1,
	'imagelimitexposurebias' => 1,
	'imagemagnificationdescriptor' => 1,
	'imagemedium' => 1,
	'imagemodulationexposurebias' => 1,
	'imageoffset' => 1,
	'imagepixelformat' => 1,
	'imageprintstatus' => 1,
	'imageprocessingifd' => 1,
	'imageprofile' => 1,
	'imageprops' => 1,
	'imagerboardid' => 1,
	'imagereadydatasets' => 1,
	'imagereadyvariables' => 1,
	'imagereferencepoints' => 1,
	'imageresolution' => 1,
	'imageresources' => 1,
	'imagerotated' => 1,
	'imagerotation' => 1,
	'imagerotationstatus' => 1,
	'imagesourceek' => 1,
	'imagestatus' => 1,
	'imagetoolbar' => 1,
	'imageuidlist' => 1,
	'imageversion' => 1,
	'imageworkstationmake' => 1,
	'imgprofbacktype' => 1,
	'imgprofname' => 1,
	'imgproftype' => 1,
	'imgprofversion' => 1,
	'immediatedatabytes' => 1,
	'importance' => 1,
	'imprint' => 1,
	'includedfileid' => 1,
	'incomplete' => 1,
	'index' => 1,
	'index01' => 1,
	'index02' => 1,
	'index03' => 1,
	'index04' => 1,
	'index05' => 1,
	'index06' => 1,
	'index07' => 1,
	'index08' => 1,
	'index09' => 1,
	'index10' => 1,
	'index11' => 1,
	'index12' => 1,
	'index13' => 1,
	'index14' => 1,
	'index15' => 1,
	'index16' => 1,
	'indexable' => 1,
	'indexed' => 1,
	'indexedcolourtablecount' => 1,
	'indexoffset' => 1,
	'indexparameters' => 1,
	'info' => 1,
	'information' => 1,
	'infourl' => 1,
	'ingrreserved' => 1,
	'initialdisplayeffect' => 1,
	'initializationvector' => 1,
	'initializeddatasize' => 1,
	'initialkey' => 1,
	'initialobjectdescriptor' => 1,
	'initials' => 1,
	'inknames' => 1,
	'inputdataobjectlist' => 1,
	'inputdevicename' => 1,
	'inputdeviceserialnumber' => 1,
	'insertmode' => 1,
	'insetnwpixelx' => 1,
	'insetnwpixely' => 1,
	'institution' => 1,
	'instructionset' => 1,
	'integrationtime' => 1,
	'intellectualproperty' => 1,
	'intellectualpropertynotes' => 1,
	'intensitystereo' => 1,
	'intergraphflagregisters' => 1,
	'intergraphmatrix' => 1,
	'intergraphpacketdata' => 1,
	'interlace' => 1,
	'interleavedfield' => 1,
	'internalidnumber' => 1,
	'internalleading' => 1,
	'internalname' => 1,
	'internalversionnumber' => 1,
	'internationaltext' => 1,
	'internetradiostationname' => 1,
	'internetradiostationowner' => 1,
	'internetradiostationurl' => 1,
	'interopoffset' => 1,
	'interpretedby' => 1,
	'involvedpeople' => 1,
	'ipmpcontrol' => 1,
	'iptc_profile' => 1,
	'iptcapplication' => 1,
	'iptccore' => 1,
	'iptcdata' => 1,
	'iptcenvelope' => 1,
	'iptcext' => 1,
	'iptcfotostation' => 1,
	'iptcnewsphoto' => 1,
	'iptcobjectdata' => 1,
	'iptcpostobjectdata' => 1,
	'iptcpreobjectdata' => 1,
	'irwindowtemperature' => 1,
	'irwindowtransmission' => 1,
	'is_protected' => 1,
	'is_trusted' => 1,
	'isattachment' => 1,
	'isbasefont' => 1,
	'iscompleted' => 1,
	'isdeleted' => 1,
	'isfixedpitch' => 1,
	'isfixedv' => 1,
	'isinfoa100' => 1,
	'isnetworkfeed' => 1,
	'isoinfo' => 1,
	'isonline' => 1,
	'isotherm1color' => 1,
	'isotherm2color' => 1,
	'isprotected' => 1,
	'isrc' => 1,
	'isrccode' => 1,
	'isrcnumber' => 1,
	'isrecurring' => 1,
	'isvbr' => 1,
	'it8header' => 1,
	'italic' => 1,
	'italicangle' => 1,
	'itch' => 1,
	'item' => 1,
	'item0032' => 1,
	'itemid' => 1,
	'iteminformation' => 1,
	'itemlist' => 1,
	'itemlocation' => 1,
	'itemprotection' => 1,
	'itemtool' => 1,
	'itemvendorid' => 1,
	'iterationcount' => 1,
	'iterationendaction' => 1,
	'iterationmax' => 1,
	'iterationminmax' => 1,
	'iterations' => 1,
	'itunesinfo' => 1,
	'itunesmediatype' => 1,
	'itunesu' => 1,
	'itunmovi' => 1,
	'itunsmpb' => 1,
	'ituntool' => 1,
	'jbigoptions' => 1,
	'jfif' => 1,
	'jfifversion' => 1,
	'jfxx' => 1,
	'jngheader' => 1,
	'jobtitle' => 1,
	'journal' => 1,
	'jp2header' => 1,
	'jp2signature' => 1,
	'jpeg-hdr' => 1,
	'jpeg-hdrversion' => 1,
	'jpeg_quality' => 1,
	'jpegactables' => 1,
	'jpegdctables' => 1,
	'jpegdigest' => 1,
	'jpegexifdata' => 1,
	'jpeglosslesspredictors' => 1,
	'jpegpointtransforms' => 1,
	'jpegproc' => 1,
	'jpegprocess' => 1,
	'jpegqtables' => 1,
	'jpegrestartinterval' => 1,
	'jpegtables' => 1,
	'jplcartoifd' => 1,
	'jsonmetadata' => 1,
	'jumptoxpep' => 1,
	'junk' => 1,
	'kbytesize' => 1,
	'kdc_ifd' => 1,
	'kelvinwb' => 1,
	'keycode' => 1,
	'keyframepositions' => 1,
	'keyframestimes' => 1,
	'keyid' => 1,
	'keys' => 1,
	'kf8coveruri' => 1,
	'kids' => 1,
	'kinds' => 1,
	'knownfolderdata' => 1,
	'kodak' => 1,
	'kodak_frea' => 1,
	'kodakbordersifd' => 1,
	'kodakdcmd' => 1,
	'kodakeffectsifd' => 1,
	'kodakfree' => 1,
	'kodakifd' => 1,
	'kodakmake' => 1,
	'kodaktags' => 1,
	'konicaminolta' => 1,
	'konicaminoltatags' => 1,
	'label0' => 1,
	'label1' => 1,
	'label2' => 1,
	'label3' => 1,
	'lamebitrate' => 1,
	'lameheader' => 1,
	'lamelowpassfilter' => 1,
	'lamemethod' => 1,
	'lamequality' => 1,
	'lamestereomode' => 1,
	'lamevbrquality' => 1,
	'languagecode' => 1,
	'languagelist' => 1,
	'largestpacketduration' => 1,
	'largestpacketsize' => 1,
	'lastauthor' => 1,
	'lastbackupdate' => 1,
	'lastchar' => 1,
	'lastkeyframetime' => 1,
	'lastmodifiedby' => 1,
	'lastmodifier' => 1,
	'lastname' => 1,
	'lastobject' => 1,
	'lastobjectid' => 1,
	'lastprinted' => 1,
	'lasttimestamp' => 1,
	'lastupdate' => 1,
	'lastupdatetime' => 1,
	'layercomps' => 1,
	'layergroupsenabledid' => 1,
	'layerselectionids' => 1,
	'layersgroupinfo' => 1,
	'layout' => 1,
	'leadperformer' => 1,
	'leafautoactive' => 1,
	'leafautobasename' => 1,
	'leafdata' => 1,
	'leafhotfolder' => 1,
	'leafopenprochdr' => 1,
	'leafoutputfiletype' => 1,
	'leafsaveselection' => 1,
	'leafsubifd' => 1,
	'leftdarkrect' => 1,
	'leftmag' => 1,
	'legalcopyright' => 1,
	'legaltrademarks' => 1,
	'leicaleic' => 1,
	'length' => 1,
	'lens35efl' => 1,
	'lenscorr' => 1,
	'lensdata' => 1,
	'lensdata0100' => 1,
	'lensdata0101' => 1,
	'lensdata0201' => 1,
	'lensdata0204' => 1,
	'lensdata0400' => 1,
	'lensdataunknown' => 1,
	'lensdataversion' => 1,
	'lensinfoq' => 1,
	'lensmaker' => 1,
	'lenspartnumber' => 1,
	'lensrec' => 1,
	'lensshading' => 1,
	'levelinfo' => 1,
	'libraryid' => 1,
	'libraryname' => 1,
	'licenseinfourl' => 1,
	'lightingopt' => 1,
	'lightness' => 1,
	'lightroomworkflow' => 1,
	'lights' => 1,
	'lightvalue' => 1,
	'linearizationcoefficients1' => 1,
	'linearizationcoefficients2' => 1,
	'linearized' => 1,
	'lineorder' => 1,
	'lines' => 1,
	'linkerversion' => 1,
	'linkinfo' => 1,
	'linkstatus' => 1,
	'linksuptodate' => 1,
	'linktarget' => 1,
	'lit' => 1,
	'ln0' => 1,
	'ln1' => 1,
	'localbasepath' => 1,
	'localdeltatype' => 1,
	'localeindicator' => 1,
	'locationbody' => 1,
	'locationdate' => 1,
	'locationinfo' => 1,
	'locationinformation' => 1,
	'locationnote' => 1,
	'locationrole' => 1,
	'lockedpropertylist' => 1,
	'locks' => 1,
	'logoiconurl' => 1,
	'logourl' => 1,
	'longdescription' => 1,
	'lookheadbacktype' => 1,
	'lookheader' => 1,
	'lookheadname' => 1,
	'lookheadtype' => 1,
	'lookheadversion' => 1,
	'lookmodtransform' => 1,
	'lookuptable' => 1,
	'loopstyle' => 1,
	'lotus' => 1,
	'lr' => 1,
	'lslv' => 1,
	'luminance' => 1,
	'luminanceconsts' => 1,
	'lyricist' => 1,
	'lyrics_synchronised' => 1,
	'lyricsuri' => 1,
	'machineid' => 1,
	'machinetype' => 1,
	'macintoshnsprintinfo' => 1,
	'macintoshprintinfo' => 1,
	'magnification' => 1,
	'magnifyobject' => 1,
	'mailingaddress' => 1,
	'mailstop' => 1,
	'mainboard' => 1,
	'maininfo' => 1,
	'maininfoifd' => 1,
	'majorbrand' => 1,
	'makeandmodel' => 1,
	'makemodel' => 1,
	'makernotepentax5a' => 1,
	'makernotepentax5b' => 1,
	'makernotepentax5c' => 1,
	'makernotepentaxunknown' => 1,
	'makernotes' => 1,
	'makerurl' => 1,
	'mandatorybackground' => 1,
	'manufacturecode' => 1,
	'manufactureindex' => 1,
	'manufacturername' => 1,
	'mappingscheme' => 1,
	'markbits' => 1,
	'marker' => 1,
	'markerid' => 1,
	'markinfo' => 1,
	'matrixstructure' => 1,
	'matrixworldtocamera' => 1,
	'matrixworldtoscreen' => 1,
	'mattcolor' => 1,
	'matte' => 1,
	'matteing' => 1,
	'matter' => 1,
	'maxband' => 1,
	'maxbitrate' => 1,
	'maxdatarate' => 1,
	'maximumbitrate' => 1,
	'maximumimageindex' => 1,
	'maximumobjectsize' => 1,
	'maximumoperationindex' => 1,
	'maximumtransformindex' => 1,
	'maxjpegtableindex' => 1,
	'maxpacketsize' => 1,
	'maxpagenormal' => 1,
	'maxpdusize' => 1,
	'maxsubfilesize' => 1,
	'maxtransmissiontime' => 1,
	'maxval' => 1,
	'maxwidth' => 1,
	'mc' => 1,
	'mcdi' => 1,
	'md5sum' => 1,
	'mdcolortable' => 1,
	'mdfiletag' => 1,
	'mdfileunits' => 1,
	'mdlabname' => 1,
	'mdpm' => 1,
	'mdpr' => 1,
	'mdprepdate' => 1,
	'mdpreptime' => 1,
	'mdsampleinfo' => 1,
	'mdscalepixel' => 1,
	'meas1label' => 1,
	'meas1params' => 1,
	'meas1type' => 1,
	'measuredcolor' => 1,
	'measuredinfo' => 1,
	'measurement' => 1,
	'measurementbacking' => 1,
	'measurementflare' => 1,
	'measurementgeometry' => 1,
	'measurementilluminant' => 1,
	'measurementinfo' => 1,
	'measurementobserver' => 1,
	'measurementscale' => 1,
	'media' => 1,
	'mediablackpoint' => 1,
	'mediaclassprimaryid' => 1,
	'mediaclasssecondaryid' => 1,
	'mediacolor' => 1,
	'mediacontenttypes' => 1,
	'mediacreated' => 1,
	'mediacredits' => 1,
	'mediadata' => 1,
	'mediaduration' => 1,
	'mediaflags' => 1,
	'mediaheader' => 1,
	'mediaheaderversion' => 1,
	'mediaindex' => 1,
	'mediainfo' => 1,
	'mediaisdelay' => 1,
	'mediaisfinale' => 1,
	'mediaislive' => 1,
	'mediaispremiere' => 1,
	'mediaisrepeat' => 1,
	'mediaissap' => 1,
	'mediaisstereo' => 1,
	'mediaissubtitled' => 1,
	'mediaistape' => 1,
	'mediajukebox' => 1,
	'medialanguagecode' => 1,
	'medianetworkaffiliation' => 1,
	'mediaoriginalbroadcastdatetime' => 1,
	'mediaoriginalchannel' => 1,
	'mediapro' => 1,
	'mediastationcallsign' => 1,
	'mediastationname' => 1,
	'mediatimescale' => 1,
	'mediatrackbytes' => 1,
	'mediatype' => 1,
	'mediaweight' => 1,
	'mediawhitepoint' => 1,
	'medium' => 1,
	'megapixels' => 1,
	'message' => 1,
	'meta' => 1,
	'metadata' => 1,
	'metadatacreator' => 1,
	'metadataid' => 1,
	'metadatalibrary' => 1,
	'metadatanumber' => 1,
	'meterinfo' => 1,
	'meterlink' => 1,
	'metermode' => 1,
	'microsoft' => 1,
	'microsoftxtra' => 1,
	'middlename' => 1,
	'mie' => 1,
	'mileage' => 1,
	'mimetype' => 1,
	'minaperturevalue' => 1,
	'miniaturefilter' => 1,
	'miniaturefilterorientation' => 1,
	'miniaturefilterparameter' => 1,
	'miniaturefilterposition' => 1,
	'minimumbitrate' => 1,
	'minimumversion' => 1,
	'minoltacamerasettings' => 1,
	'minoltacamerasettings2' => 1,
	'minoltacamerasettings5d' => 1,
	'minoltacamerasettings7d' => 1,
	'minoltacamerasettingsold' => 1,
	'minoltamakernote' => 1,
	'minoltamma0' => 1,
	'minoltamma1' => 1,
	'minoltaprd' => 1,
	'minoltarif' => 1,
	'minoltatags' => 1,
	'minoltattw' => 1,
	'minoltawbg' => 1,
	'minorversion' => 1,
	'minpacketsize' => 1,
	'mintransmissiontime' => 1,
	'mmclips' => 1,
	'mngheader' => 1,
	'mobitype' => 1,
	'mobiversion' => 1,
	'modeextension' => 1,
	'modeflags' => 1,
	'model2' => 1,
	'modelandversion' => 1,
	'modeltiepoint' => 1,
	'modeltransform' => 1,
	'modeltype' => 1,
	'modenumber' => 1,
	'modificationnumber' => 1,
	'modificationpermissions' => 1,
	'modifiedby' => 1,
	'modifiedinfo' => 1,
	'moiversion' => 1,
	'montage' => 1,
	'month' => 1,
	'mood' => 1,
	'moreinfo' => 1,
	'moreinfo0201' => 1,
	'moreinfo0401' => 1,
	'moreinfobannerimage' => 1,
	'moreinfobannerurl' => 1,
	'moreinfotext' => 1,
	'moreinfourl' => 1,
	'moresettings' => 1,
	'mosaicpattern' => 1,
	'movableinfo' => 1,
	'moveobjects' => 1,
	'movie' => 1,
	'moviedata' => 1,
	'moviedataoffset' => 1,
	'moviedatasize' => 1,
	'movieheader' => 1,
	'movieheaderversion' => 1,
	'movieinfo' => 1,
	'moviestreamname' => 1,
	'mp' => 1,
	'mp1' => 1,
	'mpeg7binary' => 1,
	'mpegaudioversion' => 1,
	'mpf' => 1,
	'mpfversion' => 1,
	'mpimage' => 1,
	'mpimageflags' => 1,
	'mpimageformat' => 1,
	'mpimagelength' => 1,
	'mpimagelist' => 1,
	'mpimagestart' => 1,
	'mpimagetype' => 1,
	'mpindividualnum' => 1,
	'mrwinfo' => 1,
	'msdocumenttext' => 1,
	'msdocumenttextposition' => 1,
	'mspropertysetstorage' => 1,
	'msstereo' => 1,
	'multiexp' => 1,
	'multiexposureversion' => 1,
	'multimediatype' => 1,
	'multiprofiles' => 1,
	'multiquality' => 1,
	'multiview' => 1,
	'musicby' => 1,
	'musiccdidentifier' => 1,
	'musiciancredits' => 1,
	'mute' => 1,
	'mwg-coll' => 1,
	'mwg-kw' => 1,
	'mwg-rs' => 1,
	'mxfversion' => 1,
	'mycolors' => 1,
	'name' => 1,
	'namedcolor' => 1,
	'namedcolor2' => 1,
	'nametableversion' => 1,
	'nameutf-8' => 1,
	'narrator' => 1,
	'nativedisplayinfo' => 1,
	'nativeresolutionunit' => 1,
	'nativexresolution' => 1,
	'nativeyresolution' => 1,
	'ncc' => 1,
	'nestlevel' => 1,
	'netexposurecompensation' => 1,
	'netname' => 1,
	'netprovidertype' => 1,
	'neutals' => 1,
	'neutobjbacktype' => 1,
	'neutobjname' => 1,
	'neutobjtype' => 1,
	'neutobjversion' => 1,
	'neutrals' => 1,
	'newbitdepth' => 1,
	'newcolortype' => 1,
	'newguid' => 1,
	'nexttrackid' => 1,
	'nikon' => 1,
	'nikoncaptureoffsets' => 1,
	'nikondata' => 1,
	'nikonncdb' => 1,
	'nikonncdt' => 1,
	'nikonscanifd' => 1,
	'nikontags' => 1,
	'nikonvers' => 1,
	'ninthlanguage' => 1,
	'nitf' => 1,
	'nitfversion' => 1,
	'noise' => 1,
	'noisereductiondata' => 1,
	'nominalbitrate' => 1,
	'nominalframecount' => 1,
	'nominallayercount' => 1,
	'nominalplaytime' => 1,
	'nominalvideobitrate' => 1,
	'nomssmarttags' => 1,
	'note' => 1,
	'notice' => 1,
	'now' => 1,
	'npts' => 1,
	'nsc_address' => 1,
	'nsc_description' => 1,
	'nsc_email' => 1,
	'nsc_name' => 1,
	'nsc_phone' => 1,
	'nullmediaheader' => 1,
	'numafpoints' => 1,
	'numberlist' => 1,
	'numberofcomponents' => 1,
	'numberofframes' => 1,
	'numberofimages' => 1,
	'numberofinks' => 1,
	'numberofparts' => 1,
	'numberofplanes' => 1,
	'numberofresolutions' => 1,
	'numchannels' => 1,
	'numcolors' => 1,
	'numfonts' => 1,
	'numhistorybuffers' => 1,
	'numimportantcolors' => 1,
	'numpackets' => 1,
	'numproperties' => 1,
	'numrules' => 1,
	'numsampleframes' => 1,
	'numstreams' => 1,
	'objectfiletype' => 1,
	'objectid' => 1,
	'objectsizeannounced' => 1,
	'obsoletephotoshoptag1' => 1,
	'obsoletephotoshoptag2' => 1,
	'obsoletephotoshoptag3' => 1,
	'ocad' => 1,
	'ocadrevision' => 1,
	'oceapplicationselector' => 1,
	'oceidnumber' => 1,
	'oceimagelogic' => 1,
	'ocescanjobdesc' => 1,
	'office' => 1,
	'officelocation' => 1,
	'offlineavailability' => 1,
	'offlinestatus' => 1,
	'offsetorigin' => 1,
	'offsetx' => 1,
	'offsetxy' => 1,
	'offsety' => 1,
	'oldxmp' => 1,
	'olym' => 1,
	'olympus' => 1,
	'olympus2100' => 1,
	'olympus2100ifd' => 1,
	'olympus2200' => 1,
	'olympus2200ifd' => 1,
	'olympus2300' => 1,
	'olympus2300ifd' => 1,
	'olympus2400' => 1,
	'olympus2400ifd' => 1,
	'olympus2500' => 1,
	'olympus2500ifd' => 1,
	'olympus2600' => 1,
	'olympus2600ifd' => 1,
	'olympus2700' => 1,
	'olympus2700ifd' => 1,
	'olympus2800' => 1,
	'olympus2800ifd' => 1,
	'olympus2900' => 1,
	'olympus2900ifd' => 1,
	'olympusatom' => 1,
	'olympusdss' => 1,
	'olympusjunk' => 1,
	'olympusolym' => 1,
	'olympuspreview' => 1,
	'olympustags1' => 1,
	'olympustags2' => 1,
	'olympustags3' => 1,
	'olympustags4' => 1,
	'olympusthumbnail' => 1,
	'onionskins' => 1,
	'opacity' => 1,
	'opcodelist1' => 1,
	'opcodelist2' => 1,
	'opcodelist3' => 1,
	'opcolor' => 1,
	'opendml' => 1,
	'openwithapplication' => 1,
	'operatingsystem' => 1,
	'operation' => 1,
	'operationclassid' => 1,
	'operationid' => 1,
	'operationnumber' => 1,
	'opiproxy' => 1,
	'optics' => 1,
	'optimalbitrate' => 1,
	'optionalattendeeaddresses' => 1,
	'optionalattendees' => 1,
	'orderingrestrictions' => 1,
	'organizeraddress' => 1,
	'organizername' => 1,
	'originalalbum' => 1,
	'originalalbumtitle' => 1,
	'originalartist' => 1,
	'originaldocumentsize' => 1,
	'originalfilesize' => 1,
	'originalfiletype' => 1,
	'originalformat' => 1,
	'originalimagebroker' => 1,
	'originallyricist' => 1,
	'originalmedia' => 1,
	'originalmedium' => 1,
	'originalrawcreator' => 1,
	'originalrawfiletype' => 1,
	'originalrawimage' => 1,
	'originalrawresource' => 1,
	'originalreleasetime' => 1,
	'originalreleaseyear' => 1,
	'originalscannedimagesize' => 1,
	'originalthmcreator' => 1,
	'originalthmfiletype' => 1,
	'originalthmimage' => 1,
	'originalthmresource' => 1,
	'originator' => 1,
	'originatorreference' => 1,
	'originpathinfo' => 1,
	'osversion' => 1,
	'otheraddress' => 1,
	'othercity' => 1,
	'othercodecdescription' => 1,
	'othercodecname' => 1,
	'othercountry-region' => 1,
	'otherformat' => 1,
	'otherinfo' => 1,
	'otherpobox' => 1,
	'otherpostalcode' => 1,
	'othersampledesc' => 1,
	'otherstateorprovince' => 1,
	'otherstreet' => 1,
	'outputdataobjectlist' => 1,
	'outputresponse' => 1,
	'overflowcolor' => 1,
	'ownership' => 1,
	'packets' => 1,
	'packingmethod' => 1,
	'page' => 1,
	'pageenter' => 1,
	'pageexit' => 1,
	'pagefront' => 1,
	'pagelayout' => 1,
	'pagemode' => 1,
	'pagenormal' => 1,
	'pager' => 1,
	'pages' => 1,
	'pagespecial' => 1,
	'paintdata' => 1,
	'paintimage' => 1,
	'paintimageheight' => 1,
	'paintimagetype' => 1,
	'paintimagewidth' => 1,
	'paintingfilter' => 1,
	'palette' => 1,
	'palettecolors' => 1,
	'palettefilename' => 1,
	'palettehistogram' => 1,
	'paletteinfo' => 1,
	'palettemethod' => 1,
	'palettename' => 1,
	'palettestretch' => 1,
	'palmfiletype' => 1,
	'panasonic' => 1,
	'panasonicpana' => 1,
	'panorama' => 1,
	'panorientation' => 1,
	'panoverlaph' => 1,
	'panoverlapv' => 1,
	'paragraphs' => 1,
	'param0' => 1,
	'param1' => 1,
	'param2' => 1,
	'param3' => 1,
	'parameter' => 1,
	'parameterinfo' => 1,
	'parasites' => 1,
	'parentalrating' => 1,
	'parentalratingreason' => 1,
	'parentproductid' => 1,
	'parentshorttitle' => 1,
	'parenttitle' => 1,
	'part' => 1,
	'partialpalette' => 1,
	'partialsyncsamples' => 1,
	'participants' => 1,
	'partnumber' => 1,
	'partofset' => 1,
	'pastclippingboundary' => 1,
	'pasteimage' => 1,
	'path' => 1,
	'pathselectionstate' => 1,
	'patternangle' => 1,
	'payloadtype' => 1,
	'paymenturl' => 1,
	'pcscitation' => 1,
	'pdahistogram' => 1,
	'pdf' => 1,
	'pdfx' => 1,
	'peakbitrate' => 1,
	'peakspectralsensitivity' => 1,
	'peakvalue' => 1,
	'pefversion' => 1,
	'pentax' => 1,
	'pentaxdata' => 1,
	'pentaxjunk' => 1,
	'pentaxjunk2' => 1,
	'pentaxpent' => 1,
	'pentaxpreview' => 1,
	'pentaxtags' => 1,
	'perceivedtype' => 1,
	'perceptualrenderingintentgamut' => 1,
	'performer' => 1,
	'performerkeywords' => 1,
	'performers' => 1,
	'performersortorder' => 1,
	'performerurl' => 1,
	'period' => 1,
	'perms' => 1,
	'perpicturenotes' => 1,
	'personalfunctions' => 1,
	'personalfunctionvalues' => 1,
	'personaltitle' => 1,
	'petype' => 1,
	'pfmheader' => 1,
	'pfmversion' => 1,
	'pgfversion' => 1,
	'photoeffectsdata' => 1,
	'photofinishername' => 1,
	'photomech' => 1,
	'photomechanic' => 1,
	'photoshop' => 1,
	'photoshop2colortable' => 1,
	'photoshop2info' => 1,
	'photoshop_profile' => 1,
	'photoshopdata' => 1,
	'photoshopformat' => 1,
	'photoshopinfo' => 1,
	'photoshopsettings' => 1,
	'physicalpixel' => 1,
	'physicalstreamnumbermap' => 1,
	'physicalstreamnumbers' => 1,
	'physicalstreams' => 1,
	'pic_ifd' => 1,
	'picslabel' => 1,
	'picture' => 1,
	'picturebitsperpixel' => 1,
	'picturecontrolversion' => 1,
	'picturectrl' => 1,
	'picturedescription' => 1,
	'pictureformat' => 1,
	'pictureheight' => 1,
	'pictureindexedcolors' => 1,
	'pictureinfo' => 1,
	'picturelength' => 1,
	'picturemimetype' => 1,
	'picturestyleinfo' => 1,
	'picturetype' => 1,
	'picturewidth' => 1,
	'pieceinfo' => 1,
	'piecelength' => 1,
	'pieces' => 1,
	'pip' => 1,
	'pipx1' => 1,
	'pipx2' => 1,
	'pipy1' => 1,
	'pipy2' => 1,
	'pitchandfamily' => 1,
	'pitchshift' => 1,
	'pixelaspectratio' => 1,
	'pixelaspectratiox' => 1,
	'pixelaspectratioy' => 1,
	'pixelcalibration' => 1,
	'pixelformat' => 1,
	'pixelintensityrange' => 1,
	'pixellive' => 1,
	'pixelmagicjbigoptions' => 1,
	'pixelscale' => 1,
	'pixelspermeterx' => 1,
	'pixelspermetery' => 1,
	'pixheight' => 1,
	'pixwidth' => 1,
	'places' => 1,
	'planckb' => 1,
	'planckf' => 1,
	'plancko' => 1,
	'planckr1' => 1,
	'planckr2' => 1,
	'planes' => 1,
	'playallframes' => 1,
	'playcounter' => 1,
	'playduration' => 1,
	'playerversion' => 1,
	'playgap' => 1,
	'playlistdelay' => 1,
	'playlistid' => 1,
	'playlistindex' => 1,
	'playmode' => 1,
	'playselection' => 1,
	'plus' => 1,
	'pmi' => 1,
	'pobox' => 1,
	'podcast' => 1,
	'podcastcategory' => 1,
	'podcastdescription' => 1,
	'podcastid' => 1,
	'podcastkeywords' => 1,
	'podcasturl' => 1,
	'pointsize' => 1,
	'popularimeter' => 1,
	'popupfillattributes' => 1,
	'popupflash' => 1,
	'postertime' => 1,
	'postscript2crd0' => 1,
	'postscript2crd1' => 1,
	'postscript2crd2' => 1,
	'postscript2csa' => 1,
	'postscriptfont' => 1,
	'postscriptfontname' => 1,
	'pragma' => 1,
	'preferredfamily' => 1,
	'preferredrate' => 1,
	'preferredsubfamily' => 1,
	'preferredvolume' => 1,
	'preroll' => 1,
	'presentationformat' => 1,
	'presentationtarget' => 1,
	'preview' => 1,
	'preview0' => 1,
	'preview1' => 1,
	'preview2' => 1,
	'previewatomindex' => 1,
	'previewatomtype' => 1,
	'previewduration' => 1,
	'previewifd' => 1,
	'previewifd_offset' => 1,
	'previewimagedata' => 1,
	'previewimageinfo' => 1,
	'previewinfo' => 1,
	'previewpict' => 1,
	'previewpng' => 1,
	'previewtime' => 1,
	'previewversion' => 1,
	'previewwmf' => 1,
	'primarye-mail' => 1,
	'primaryitemreference' => 1,
	'primaryphone' => 1,
	'primaryplatform' => 1,
	'printflags' => 1,
	'printflagsinfo' => 1,
	'printimversion' => 1,
	'printinfo' => 1,
	'printinfo2' => 1,
	'printquality' => 1,
	'printscale' => 1,
	'printstyle' => 1,
	'printtovideo' => 1,
	'priority' => 1,
	'prism' => 1,
	'private' => 1,
	'privatebuild' => 1,
	'prl' => 1,
	'prm' => 1,
	'processing' => 1,
	'processinginfo' => 1,
	'processingtime' => 1,
	'prod' => 1,
	'prodnotes' => 1,
	'producedby' => 1,
	'produceddate' => 1,
	'producednotice' => 1,
	'producerkeywords' => 1,
	'producers' => 1,
	'product' => 1,
	'productionaperturedimensions' => 1,
	'productiondate' => 1,
	'productiondesigner' => 1,
	'productionstudio' => 1,
	'productname' => 1,
	'producttype' => 1,
	'productversion' => 1,
	'productversionnumber' => 1,
	'profile' => 1,
	'profile1audiocodec' => 1,
	'profile1height' => 1,
	'profile1videocodec' => 1,
	'profile1width' => 1,
	'profileclass' => 1,
	'profilecmmtype' => 1,
	'profileconnectionspace' => 1,
	'profilecreator' => 1,
	'profiledatetime' => 1,
	'profiledescription' => 1,
	'profiledescriptionml' => 1,
	'profilefilesignature' => 1,
	'profileheader' => 1,
	'profileid' => 1,
	'profileifd' => 1,
	'profiles' => 1,
	'profilesequencedesc' => 1,
	'profilesequenceidentifier' => 1,
	'profiletype' => 1,
	'profileversion' => 1,
	'progid' => 1,
	'programdescription' => 1,
	'programname' => 1,
	'progressivescans' => 1,
	'projazimuthangle' => 1,
	'projcentereasting' => 1,
	'projcenterlat' => 1,
	'projcenterlong' => 1,
	'projcenternorthing' => 1,
	'projcoordtrans' => 1,
	'project' => 1,
	'projectedcstype' => 1,
	'projection' => 1,
	'projects' => 1,
	'projfalseeasting' => 1,
	'projfalsenorthing' => 1,
	'projfalseorigineasting' => 1,
	'projfalseoriginlat' => 1,
	'projfalseoriginlong' => 1,
	'projfalseoriginnorthing' => 1,
	'projlinearunits' => 1,
	'projlinearunitsize' => 1,
	'projnatoriginlat' => 1,
	'projnatoriginlong' => 1,
	'projrectifiedgridangle' => 1,
	'projscaleatcenter' => 1,
	'projscaleatnatorigin' => 1,
	'projstdparallel1' => 1,
	'projstdparallel2' => 1,
	'projstraightvertpolelong' => 1,
	'promoteparent' => 1,
	'promotionurl' => 1,
	'prop' => 1,
	'properties' => 1,
	'propertysetidcodes' => 1,
	'propertysetpathname' => 1,
	'propertystoredata' => 1,
	'propertyvectorelements' => 1,
	'protect' => 1,
	'protected' => 1,
	'protectioninfo' => 1,
	'protectiontype' => 1,
	'provider' => 1,
	'providercopyright' => 1,
	'providerlogourl' => 1,
	'providerrating' => 1,
	'providerstyle' => 1,
	'providerurl' => 1,
	'ps2crdvmsize' => 1,
	'ps2renderingintent' => 1,
	'psfontinfo' => 1,
	'pstringcaption' => 1,
	'publishdate' => 1,
	'publishdatestart' => 1,
	'publisherlimit' => 1,
	'publisherurl' => 1,
	'pur' => 1,
	'purchasedate' => 1,
	'purchasefileformat' => 1,
	'purchaseinfo' => 1,
	'purpose' => 1,
	'pyramidlevels' => 1,
	'qualcomm' => 1,
	'quickedit' => 1,
	'quickmaskinfo' => 1,
	'qvci' => 1,
	'ra3' => 1,
	'ra4' => 1,
	'ra5' => 1,
	'radioband' => 1,
	'radioformat' => 1,
	'radiostationname' => 1,
	'radiostationowner' => 1,
	'rafdata' => 1,
	'rafversion' => 1,
	'rasterpadding' => 1,
	'rate' => 1,
	'rated' => 1,
	'ratingorg' => 1,
	'ratioimage' => 1,
	'rawcodecversion' => 1,
	'rawdatalength' => 1,
	'rawdataoffset' => 1,
	'rawdatarotation' => 1,
	'rawdev2' => 1,
	'rawdev2ifd' => 1,
	'rawdevelopment' => 1,
	'rawdevelopmentifd' => 1,
	'rawexposurebias' => 1,
	'rawformat' => 1,
	'rawimagefullheight' => 1,
	'rawimagefullsize' => 1,
	'rawimagefullwidth' => 1,
	'rawimageheight' => 1,
	'rawimagemode' => 1,
	'rawimagesegmentation' => 1,
	'rawimagewidth' => 1,
	'rawinfo' => 1,
	'rawinfoifd' => 1,
	'rawjpginfo' => 1,
	'rawthermalimage' => 1,
	'rawthermalimageheight' => 1,
	'rawthermalimagetype' => 1,
	'rawthermalimagewidth' => 1,
	'rawvaluemedian' => 1,
	'rawvaluerange' => 1,
	'rawzorcreatorversion' => 1,
	'rawzorrequiredversion' => 1,
	'rdf' => 1,
	'readerrequirements' => 1,
	'reading1description' => 1,
	'reading1device' => 1,
	'reading1units' => 1,
	'reading1value' => 1,
	'reading2description' => 1,
	'reading2device' => 1,
	'reading2units' => 1,
	'reading2value' => 1,
	'reading3description' => 1,
	'reading3device' => 1,
	'reading3units' => 1,
	'reading3value' => 1,
	'reading4description' => 1,
	'reading4device' => 1,
	'reading4units' => 1,
	'reading4value' => 1,
	'readstatus' => 1,
	'real2ir' => 1,
	'realtimestreamingprotocol' => 1,
	'receivedfrom' => 1,
	'recengineer' => 1,
	'recinfo' => 1,
	'reclocation' => 1,
	'reconstructiontype' => 1,
	'recordedby' => 1,
	'recordeddate' => 1,
	'recordingcopyright' => 1,
	'recordingdates' => 1,
	'recordingtime' => 1,
	'recordingtimeday' => 1,
	'recordingtimemonth' => 1,
	'recordingtimeyear' => 1,
	'recordingtimeyearmonth' => 1,
	'recordingtimeyearmonthday' => 1,
	'recordlabelname' => 1,
	'recordlabelurl' => 1,
	'rect' => 1,
	'rectangleofinterest' => 1,
	'redadjust' => 1,
	'redblueflatfield' => 1,
	'redeyedata' => 1,
	'redgain' => 1,
	'redmatrixcolumn' => 1,
	'redprimary' => 1,
	'redsample' => 1,
	'redtrc' => 1,
	'redx' => 1,
	'redy' => 1,
	'reference' => 1,
	'referencetemperature' => 1,
	'reflectedapparenttemperature' => 1,
	'reflectionhardcopyorigcolorimetry' => 1,
	'reflectionprintoutputcolorimetry' => 1,
	'refresh' => 1,
	'regionxformtackpoint' => 1,
	'relatedimagefile' => 1,
	'relativehumidity' => 1,
	'relativepath' => 1,
	'relativevolumeadjustment' => 1,
	'releasedateday' => 1,
	'releasedatemonth' => 1,
	'releasedateyear' => 1,
	'releasedateyearmonth' => 1,
	'releasedateyearmonthday' => 1,
	'remindertime' => 1,
	'removehistoryduplicates' => 1,
	'renderingintent' => 1,
	'renderingtransform' => 1,
	'rentalexpirationdate' => 1,
	'rentalflag' => 1,
	'repeateddatabytes' => 1,
	'replaygainalbumgain' => 1,
	'replaygainalbumpeak' => 1,
	'replaygaintrackgain' => 1,
	'replaygaintrackpeak' => 1,
	'replyto' => 1,
	'representativedisparityfar' => 1,
	'representativedisparitynear' => 1,
	'representativeimage' => 1,
	'requeststate' => 1,
	'requiredattendeeaddresses' => 1,
	'requiredattendees' => 1,
	'requirements' => 1,
	'rerun' => 1,
	'reserved1' => 1,
	'resolutioninfo' => 1,
	'resourcecount' => 1,
	'resourceforksize' => 1,
	'resources' => 1,
	'resourcesneeded' => 1,
	'resourcetype' => 1,
	'resultaspectratio' => 1,
	'retailprice' => 1,
	'retailpricecurrency' => 1,
	'retouchinfoversion' => 1,
	'review' => 1,
	'revisiondate' => 1,
	'revisionnumber' => 1,
	'revisitafter' => 1,
	'rgb_profile' => 1,
	'ricoh' => 1,
	'ricohjunk' => 1,
	'ricohmake' => 1,
	'ricohmodel' => 1,
	'ricohpitch' => 1,
	'ricohrdc2' => 1,
	'ricohrmkn' => 1,
	'ricohroll' => 1,
	'ricohrr1subdir' => 1,
	'ricohsubdir' => 1,
	'ricohsubdirifd' => 1,
	'rightdarkrect' => 1,
	'rightmag' => 1,
	'rippedby' => 1,
	'rjmd' => 1,
	'rmeta' => 1,
	'robots' => 1,
	'rocinfo' => 1,
	'roidescription' => 1,
	'rollguidelements' => 1,
	'root' => 1,
	'rotationangle' => 1,
	'roundtripversion' => 1,
	'rowinterleavefactor' => 1,
	'rtptimescale' => 1,
	'runtime' => 1,
	'runtimeepoch' => 1,
	'runtimeflags' => 1,
	'runtimescale' => 1,
	'runtimesincepowerup' => 1,
	'runtimevalue' => 1,
	'runwindow' => 1,
	's2n' => 1,
	'sampledegradationpriority' => 1,
	'sampleflag' => 1,
	'sampleformat' => 1,
	'samplegroupdescription' => 1,
	'samplepaddingbits' => 1,
	'samplerate2' => 1,
	'samplesize' => 1,
	'samplesizes' => 1,
	'sampletable' => 1,
	'sampletext' => 1,
	'sampletochunk' => 1,
	'sampletogroup' => 1,
	'samsung' => 1,
	'samsungifd' => 1,
	'samsunginfo' => 1,
	'samsungsec' => 1,
	'samsungsmta' => 1,
	'samsungsvss' => 1,
	'samsungtags' => 1,
	'sanyomov' => 1,
	'sanyomp4' => 1,
	'sap' => 1,
	'saturationinfo' => 1,
	'saturationrenderingintentgamut' => 1,
	'saveobjbacktype' => 1,
	'saveobjects' => 1,
	'saveobjname' => 1,
	'saveobjtype' => 1,
	'saveobjversion' => 1,
	'savesetup' => 1,
	'sba_rgbshifts' => 1,
	'sbaexposurerecord' => 1,
	'sbainputimagebitdepth' => 1,
	'sbainputimagecolorspace' => 1,
	'scalado' => 1,
	'scale' => 1,
	'scalecrop' => 1,
	'scalefactor35efl' => 1,
	'scalingfactor' => 1,
	'scandate' => 1,
	'scannerfirmwaredate' => 1,
	'scannerfirmwareversion' => 1,
	'scannermake' => 1,
	'scannermodel' => 1,
	'scannerpixelsize' => 1,
	'scannerproductid' => 1,
	'scannerserialnumber' => 1,
	'scannervendorid' => 1,
	'scanoperatorid' => 1,
	'scansoftware' => 1,
	'scansoftwarerevisiondate' => 1,
	'sceneappearanceestimates' => 1,
	'scenebalancealgorithmcommand' => 1,
	'scenebalancealgorithmfilmid' => 1,
	'scenebalancealgorithmrevision' => 1,
	'scenecolorimetryestimates' => 1,
	'schemeinfo' => 1,
	'schemetype' => 1,
	'schemeurl' => 1,
	'schemeversion' => 1,
	'school' => 1,
	'screenbuffersize' => 1,
	'screendescriptor' => 1,
	'screening' => 1,
	'screeningdesc' => 1,
	'screennail' => 1,
	'screenwindowcenter' => 1,
	'screenwindowwidth' => 1,
	'screenwriters' => 1,
	'scriptcommand' => 1,
	'searchranking' => 1,
	'secondarygenre' => 1,
	'secondlanguage' => 1,
	'security' => 1,
	'seekable' => 1,
	'seekpoint' => 1,
	'seektable' => 1,
	'selection' => 1,
	'selectionduration' => 1,
	'selectiontime' => 1,
	'selobjbacktype' => 1,
	'selobjname' => 1,
	'selobjtype' => 1,
	'selobjversion' => 1,
	'sendduration' => 1,
	'senderaddress' => 1,
	'sendername' => 1,
	'sensitivity' => 1,
	'sensorbottomborder' => 1,
	'sensordefects' => 1,
	'sensorid' => 1,
	'sensorimageheight' => 1,
	'sensorimagewidth' => 1,
	'sensorinfo' => 1,
	'sensorleftborder' => 1,
	'sensorleftmargin' => 1,
	'sensorrightborder' => 1,
	'sensortemperature2' => 1,
	'sensortopborder' => 1,
	'sensortopmargin' => 1,
	'sequenceframenumber' => 1,
	'sequencenumberrandomoffset' => 1,
	'serialinfo' => 1,
	'series' => 1,
	'serviceorganizationname' => 1,
	'setcookie' => 1,
	'setinfo' => 1,
	'setsubtitle' => 1,
	'seventhlanguage' => 1,
	'shadowendpoints' => 1,
	'shadowfilepath' => 1,
	'shadowsyncsampletable' => 1,
	'shakereductioninfo' => 1,
	'shared' => 1,
	'shareddata' => 1,
	'shareddoc' => 1,
	'shareduserrating' => 1,
	'sharedwith' => 1,
	'sharpinfo' => 1,
	'sharpmethod' => 1,
	'sharpnessapproximation' => 1,
	'sharpnessfreqtable' => 1,
	'sharpnesstable' => 1,
	'sharpobjbacktype' => 1,
	'sharpobjname' => 1,
	'sharpobjtype' => 1,
	'sharpobjversion' => 1,
	'sheetdisclosure' => 1,
	'shimdata' => 1,
	'shootingcount' => 1,
	'shootingrecord' => 1,
	'shootobjbacktype' => 1,
	'shootobjname' => 1,
	'shootobjtype' => 1,
	'shootobjversion' => 1,
	'shootsetup' => 1,
	'shorttitle' => 1,
	'shotinfo' => 1,
	'shotinfo02xx' => 1,
	'shotinfod300a' => 1,
	'shotinfod300b' => 1,
	'shotinfod300s' => 1,
	'shotinfod3a' => 1,
	'shotinfod3b' => 1,
	'shotinfod3s' => 1,
	'shotinfod3x' => 1,
	'shotinfod4' => 1,
	'shotinfod40' => 1,
	'shotinfod4s' => 1,
	'shotinfod5000' => 1,
	'shotinfod5100' => 1,
	'shotinfod5200' => 1,
	'shotinfod700' => 1,
	'shotinfod7000' => 1,
	'shotinfod80' => 1,
	'shotinfod800' => 1,
	'shotinfod810' => 1,
	'shotinfod90' => 1,
	'shotinfounknown' => 1,
	'shotinfoversion' => 1,
	'showmode' => 1,
	'showobjects' => 1,
	'shutter' => 1,
	'shuttercurtainhack' => 1,
	'shutterspeed' => 1,
	'shutterspeeddisplayed' => 1,
	'sidebars' => 1,
	'sigma' => 1,
	'signalnumber' => 1,
	'signature' => 1,
	'signature_name' => 1,
	'signatureusagerights' => 1,
	'signercontactinfo' => 1,
	'significantbits' => 1,
	'signingauthority' => 1,
	'signingdate' => 1,
	'signinglocation' => 1,
	'signingreason' => 1,
	'signtype' => 1,
	'simpleindex' => 1,
	'simplicityprofile' => 1,
	'singlequality' => 1,
	'site' => 1,
	'siteenter' => 1,
	'siteexit' => 1,
	'sixthlanguage' => 1,
	'size' => 1,
	'sizemode' => 1,
	'skip' => 1,
	'slateinformation' => 1,
	'slices' => 1,
	'slides' => 1,
	'slideshow' => 1,
	'smaxsamplevalue' => 1,
	'sminsamplevalue' => 1,
	'snapshotid' => 1,
	'snapshotname' => 1,
	'soctemperature' => 1,
	'softedit' => 1,
	'softfocusfilter' => 1,
	'softwarecomponents' => 1,
	'softwarerelease' => 1,
	'songwriter' => 1,
	'songwriterkeywords' => 1,
	'sony' => 1,
	'sortalbum' => 1,
	'sortalbumartist' => 1,
	'sortartist' => 1,
	'sortcomposer' => 1,
	'sortname' => 1,
	'sortshow' => 1,
	'soundfile' => 1,
	'soundschemetitle' => 1,
	'sourcecreatedate' => 1,
	'sourcecredits' => 1,
	'sourcedata' => 1,
	'sourcedate' => 1,
	'sourceedition' => 1,
	'sourcefilename' => 1,
	'sourceform' => 1,
	'sourceid' => 1,
	'sourceimagedirectory' => 1,
	'sourceimagefilename' => 1,
	'sourceimageheight' => 1,
	'sourceimagevolumename' => 1,
	'sourceimagewidth' => 1,
	'sourcepublisher' => 1,
	'sourcerights' => 1,
	'sourcetitle' => 1,
	'sourceurl' => 1,
	'spacefree' => 1,
	'spaceused' => 1,
	'spatialorientation' => 1,
	'spatialresolution' => 1,
	'specialbuild' => 1,
	'specialeffectsopticalfilter' => 1,
	'specialfolderdata' => 1,
	'specificationversion' => 1,
	'speed' => 1,
	'spiff' => 1,
	'spiffversion' => 1,
	'splitcolumn' => 1,
	'spothalftone' => 1,
	'spouse' => 1,
	'sr2dataifd' => 1,
	'sr2private' => 1,
	'sr2subifdkey' => 1,
	'sr2subifdlength' => 1,
	'sr2subifdoffset' => 1,
	'srawtype' => 1,
	'srf2key' => 1,
	'srf6offset' => 1,
	'srfdataoffset' => 1,
	'srgbrendering' => 1,
	'stampinfo' => 1,
	'stamptoolcount' => 1,
	'starring' => 1,
	'startdate' => 1,
	'startofframe' => 1,
	'startreading' => 1,
	'starttime' => 1,
	'stateorprovince' => 1,
	'stationcallsign' => 1,
	'stationname' => 1,
	'statistics' => 1,
	'stdautoactive' => 1,
	'stdbasename' => 1,
	'stdhotfolder' => 1,
	'stdopeninphotoshop' => 1,
	'stdoutputbitdepth' => 1,
	'stdoutputcolormode' => 1,
	'stdoutputfiletype' => 1,
	'stdoxygen' => 1,
	'stdsaveselection' => 1,
	'stdscaledoutput' => 1,
	'stdsharpenoutput' => 1,
	'stereo' => 1,
	'stereoimage' => 1,
	'stereomode' => 1,
	'stim' => 1,
	'stimversion' => 1,
	'stitchinfo' => 1,
	'stonits' => 1,
	'storage-streampathname' => 1,
	'store' => 1,
	'stream' => 1,
	'streamavgbitrate' => 1,
	'streamavgpacketsize' => 1,
	'streambitdepth' => 1,
	'streambitrateprops' => 1,
	'streamcolor' => 1,
	'streamcount' => 1,
	'streamdata' => 1,
	'streamduration' => 1,
	'streamheader' => 1,
	'streaminfo' => 1,
	'streamingdataprotocol' => 1,
	'streammaxbitrate' => 1,
	'streammaxpacketsize' => 1,
	'streammimelen' => 1,
	'streammimetype' => 1,
	'streamname' => 1,
	'streamnamelen' => 1,
	'streamnumber' => 1,
	'streampreroll' => 1,
	'streamprioritization' => 1,
	'streamproperties' => 1,
	'streamsamplecount' => 1,
	'streamsamplerate' => 1,
	'streamstarttime' => 1,
	'streamtype' => 1,
	'streamtypeinfo' => 1,
	'street' => 1,
	'stridable' => 1,
	'strikeout' => 1,
	'stripbytecounts' => 1,
	'stripoffsets' => 1,
	'striprowcounts' => 1,
	'strobe' => 1,
	'strobetime' => 1,
	'studio' => 1,
	'sub-sampleinformation' => 1,
	'subdir3000' => 1,
	'subdir3100' => 1,
	'subdir3400' => 1,
	'subdir3900' => 1,
	'subfile' => 1,
	'subifd' => 1,
	'subifd0' => 1,
	'subifd1' => 1,
	'subifd2' => 1,
	'subifd255' => 1,
	'subifd3' => 1,
	'subifd4' => 1,
	'subifd5' => 1,
	'subifd6' => 1,
	'subifd_offset' => 1,
	'subimagecolor' => 1,
	'subimagehdr' => 1,
	'subimageheight' => 1,
	'subimageicc_profile' => 1,
	'subimagenumericalformat' => 1,
	'subimageresolutions' => 1,
	'subimagetilecount' => 1,
	'subimagetileheight' => 1,
	'subimagetilewidth' => 1,
	'subimagewidth' => 1,
	'subjectpixelheight' => 1,
	'subjectpixelwidth' => 1,
	'subjectscale' => 1,
	'subjectunits' => 1,
	'subpacketh' => 1,
	'subpacketsize' => 1,
	'subscriptioncontentid' => 1,
	'subseccreatedate' => 1,
	'subsecdatetimeoriginal' => 1,
	'subsecmodifydate' => 1,
	'subsystem' => 1,
	'subsystemversion' => 1,
	'subtileblocksize' => 1,
	'subtitledescription' => 1,
	'subtitlekeywords' => 1,
	'suffix' => 1,
	'suggestedpalette' => 1,
	'summary' => 1,
	'summaryinfo' => 1,
	'surroundmode' => 1,
	'svgversion' => 1,
	'swf' => 1,
	'sync01' => 1,
	'sync02' => 1,
	'sync03' => 1,
	'sync04' => 1,
	'sync05' => 1,
	'sync06' => 1,
	'sync07' => 1,
	'sync08' => 1,
	'sync09' => 1,
	'sync10' => 1,
	'sync11' => 1,
	'sync12' => 1,
	'sync13' => 1,
	'sync14' => 1,
	'sync15' => 1,
	'sync16' => 1,
	'synchronizedlyricsdescription' => 1,
	'synchronizedlyricstext' => 1,
	'synchronizedlyricstype' => 1,
	'synconly' => 1,
	'syncsampletable' => 1,
	'syncstate' => 1,
	'synlyrics' => 1,
	'system' => 1,
	't4options' => 1,
	't6options' => 1,
	't82options' => 1,
	't88options' => 1,
	'tag2010a' => 1,
	'tag2010b' => 1,
	'tag2010c' => 1,
	'tag2010d' => 1,
	'tag2010e' => 1,
	'tag2010f' => 1,
	'tag2010g' => 1,
	'tag2010h' => 1,
	'tag900b' => 1,
	'tag9050' => 1,
	'tag9400a' => 1,
	'tag9400b' => 1,
	'tag9400c' => 1,
	'tag9402' => 1,
	'tag9403' => 1,
	'tag9404a' => 1,
	'tag9404b' => 1,
	'tag9405a' => 1,
	'tag9405b' => 1,
	'tag9406' => 1,
	'tag940a' => 1,
	'tag940c' => 1,
	'taggedpdf' => 1,
	'taggingtime' => 1,
	'tamper-proofkeys' => 1,
	'targetaudiences' => 1,
	'targetdeltatype' => 1,
	'targetfiledosname' => 1,
	'targetfilesize' => 1,
	'targetlayerid' => 1,
	'targetprinter' => 1,
	'targetxy' => 1,
	'taskowner' => 1,
	'tcmediainfo' => 1,
	'tdat' => 1,
	'tdhd' => 1,
	'technician' => 1,
	'technology' => 1,
	'telephonenumber' => 1,
	'telex' => 1,
	'temperature' => 1,
	'tempinfo' => 1,
	'template' => 1,
	'temporary' => 1,
	'terminationaction' => 1,
	'terminationcondition' => 1,
	'termsofuse' => 1,
	'testtarget' => 1,
	'text' => 1,
	'textcolor' => 1,
	'textface' => 1,
	'textfont' => 1,
	'textinfo' => 1,
	'textinfo1' => 1,
	'textinfo2' => 1,
	'textjunk' => 1,
	'textsize' => 1,
	'texttospeech' => 1,
	'textualdata' => 1,
	'textualinfo' => 1,
	'textureformat' => 1,
	'theora' => 1,
	'theoraversion' => 1,
	'thetasubdir' => 1,
	'things' => 1,
	'thirdlanguage' => 1,
	'thumbinfo' => 1,
	'thumbnail' => 1,
	'thumbnailclip' => 1,
	'thumbnailpng' => 1,
	'tickspersecond' => 1,
	'tiff' => 1,
	'tiff-epstandardid' => 1,
	'tiff_fxextensions' => 1,
	'tiffpreview' => 1,
	'tilebytecounts' => 1,
	'tiledepth' => 1,
	'tileoffsets' => 1,
	'tiles' => 1,
	'timecode' => 1,
	'timecodeindex' => 1,
	'timecodeindexparms' => 1,
	'timeinfo' => 1,
	'timelineinfo' => 1,
	'timeoffset' => 1,
	'timereference' => 1,
	'timescale' => 1,
	'timestamprandomoffset' => 1,
	'timetosampletable' => 1,
	'title2' => 1,
	'titlelen' => 1,
	'titlenum' => 1,
	'titleofparts' => 1,
	'titlesofparts' => 1,
	'titlesortorder' => 1,
	'toaddresses' => 1,
	'tocitems' => 1,
	'todotitle' => 1,
	'tonames' => 1,
	'tonecurvematching' => 1,
	'tonecurvetable' => 1,
	'tonematrix' => 1,
	'toneobjbacktype' => 1,
	'toneobjname' => 1,
	'toneobjtype' => 1,
	'toneobjversion' => 1,
	'tones' => 1,
	'tonespaceflow' => 1,
	'tool_name' => 1,
	'tool_version' => 1,
	'toolname' => 1,
	'toolversion' => 1,
	'topmag' => 1,
	'totalbitrate' => 1,
	'totalbytes' => 1,
	'totalbytesnortpheaders' => 1,
	'totaldatarate' => 1,
	'totalduration' => 1,
	'totaleditingtime' => 1,
	'totaledittime' => 1,
	'totalfilesize' => 1,
	'totalframecount' => 1,
	'totalframes' => 1,
	'totalsamples' => 1,
	'totalsize' => 1,
	'toycamerafilter' => 1,
	'track' => 1,
	'trackaperture' => 1,
	'trackcategory' => 1,
	'trackcomments' => 1,
	'trackduration' => 1,
	'trackerdata' => 1,
	'trackheader' => 1,
	'trackheaderversion' => 1,
	'trackid' => 1,
	'trackingid' => 1,
	'tracklayer' => 1,
	'tracklyrics' => 1,
	'trackproperty' => 1,
	'trackref' => 1,
	'tracktype' => 1,
	'trackvolume' => 1,
	'trademark' => 1,
	'transactionid' => 1,
	'transferrange' => 1,
	'transformation' => 1,
	'transformcreatedate' => 1,
	'transformedimagetitle' => 1,
	'transformmodifydate' => 1,
	'transformnodeid' => 1,
	'transformparams' => 1,
	'transformtitle' => 1,
	'transparency' => 1,
	'transparencyindicator' => 1,
	'transparentindex' => 1,
	'trapindicator' => 1,
	'trebel' => 1,
	'tty-ttdphone' => 1,
	'tvepisode' => 1,
	'tvepisodeid' => 1,
	'tvnetworkname' => 1,
	'tvseason' => 1,
	'tvshow' => 1,
	'typeoforiginal' => 1,
	'typist' => 1,
	'ucrbg' => 1,
	'uic1tag' => 1,
	'uic2tag' => 1,
	'uic3tag' => 1,
	'uic4tag' => 1,
	'uncompressed' => 1,
	'uncompressedsize' => 1,
	'uncompressedtextlength' => 1,
	'underflowcolor' => 1,
	'underline' => 1,
	'underlineposition' => 1,
	'underlinethickness' => 1,
	'unicodealphanames' => 1,
	'uninitializeddatasize' => 1,
	'uniquefileidentifier' => 1,
	'units' => 1,
	'unknown' => 1,
	'unknown_aacr' => 1,
	'unknown_cdek' => 1,
	'unknown_cdet' => 1,
	'unknown_cndb' => 1,
	'unknown_slmt' => 1,
	'unknownd30' => 1,
	'unknowndata' => 1,
	'unknowndate' => 1,
	'unknowninfo' => 1,
	'unknowninfo2' => 1,
	'unknowninfo2version' => 1,
	'unknowninfoifd' => 1,
	'unknowninfoversion' => 1,
	'unknownserial1' => 1,
	'unknownserial2' => 1,
	'unknownserial3' => 1,
	'unknownserial4' => 1,
	'unknowntags' => 1,
	'unknowntemperature1' => 1,
	'unknowntemperature2' => 1,
	'unknowntemperature3' => 1,
	'unknowntemperature4' => 1,
	'unknowntemperature5' => 1,
	'unknowntemperature6' => 1,
	'unknownthumbnail' => 1,
	'unsharpdata' => 1,
	'untitled0' => 1,
	'untitled1' => 1,
	'untitled2' => 1,
	'unused' => 1,
	'updatedtitle' => 1,
	'ur3' => 1,
	'url_list' => 1,
	'urllist1' => 1,
	'urn' => 1,
	'usagerightsmessage' => 1,
	'usedextensionnumbers' => 1,
	'useraccess' => 1,
	'useradjsba_rgbshifts' => 1,
	'usercollection' => 1,
	'usercustom1' => 1,
	'usercustom2' => 1,
	'userdata' => 1,
	'userdefinedid' => 1,
	'userdefinedtext' => 1,
	'userdefinedurl' => 1,
	'usereffectiverating' => 1,
	'userid' => 1,
	'userlastplayedtime' => 1,
	'username' => 1,
	'userplaycount' => 1,
	'userplaycountafternoon' => 1,
	'userplaycountevening' => 1,
	'userplaycountmorning' => 1,
	'userplaycountnight' => 1,
	'userplaycountweekday' => 1,
	'userplaycountweekend' => 1,
	'userrating' => 1,
	'userselectgrouptitle' => 1,
	'userservicerating' => 1,
	'userweburl' => 1,
	'usingtransforms' => 1,
	'usptomiscellaneous' => 1,
	'usptooriginalcontenttype' => 1,
	'utm' => 1,
	'uuid-canon' => 1,
	'uuid-exif' => 1,
	'uuid-exif2' => 1,
	'uuid-flip' => 1,
	'uuid-geojp2' => 1,
	'uuid-iptc' => 1,
	'uuid-iptc2' => 1,
	'uuid-photoshop' => 1,
	'uuid-prof' => 1,
	'uuid-unknown' => 1,
	'uuid-usmt' => 1,
	'uuid-xmp' => 1,
	'uuidinfo' => 1,
	'uuidlist' => 1,
	'validafpoints' => 1,
	'value0' => 1,
	'value1' => 1,
	'value2' => 1,
	'value3' => 1,
	'vary' => 1,
	'vbrbytes' => 1,
	'vbrframes' => 1,
	'vbrpeak' => 1,
	'vbrscale' => 1,
	'vegasversionmajor' => 1,
	'vegasversionminor' => 1,
	'vendor' => 1,
	'vendorid' => 1,
	'vendorname' => 1,
	'vendorurl' => 1,
	'version1' => 1,
	'version2' => 1,
	'versionbf' => 1,
	'versionifd' => 1,
	'versioninfo' => 1,
	'versionrestrictions' => 1,
	'versionyear' => 1,
	'verticalcitation' => 1,
	'verticalcstype' => 1,
	'verticaldatum' => 1,
	'verticaldivergence' => 1,
	'verticalresolution' => 1,
	'verticalscale' => 1,
	'verticalunits' => 1,
	'video' => 1,
	'videoattributes' => 1,
	'videoavgbitrate' => 1,
	'videoavgframerate' => 1,
	'videobitrate' => 1,
	'videocardgamma' => 1,
	'videoclosedcaptioning' => 1,
	'videocodecdescription' => 1,
	'videocodecid' => 1,
	'videocodecinfo' => 1,
	'videocodecname' => 1,
	'videocompression' => 1,
	'videoencoding' => 1,
	'videoformat' => 1,
	'videoframecount' => 1,
	'videoheader' => 1,
	'videoheight' => 1,
	'videomaxbitrate' => 1,
	'videomaxframerate' => 1,
	'videomode' => 1,
	'videoprofile' => 1,
	'videoprofileversion' => 1,
	'videosampledesc' => 1,
	'videoscantype' => 1,
	'videosize' => 1,
	'videostreamtype' => 1,
	'videotrackid' => 1,
	'videowidth' => 1,
	'view' => 1,
	'viewable' => 1,
	'viewingconddesc' => 1,
	'viewingcondilluminant' => 1,
	'viewingcondilluminanttype' => 1,
	'viewingconditions' => 1,
	'viewingcondsurround' => 1,
	'viewtype' => 1,
	'vignettingcorr' => 1,
	'vignettingcorr2' => 1,
	'vignettingcorrunknown1' => 1,
	'vignettingcorrunknown2' => 1,
	'vignettingcorrversion' => 1,
	'virtualimageheight' => 1,
	'virtualimagewidth' => 1,
	'virtualpage' => 1,
	'virtualpageunits' => 1,
	'visibleoutputs' => 1,
	'vistaidlistdata' => 1,
	'volumeid' => 1,
	'volumelabel' => 1,
	'volumenormalization' => 1,
	'vorbis' => 1,
	'vorbiscomment' => 1,
	'vorbisversion' => 1,
	'vp8bitstream' => 1,
	'vp8l' => 1,
	'vp8version' => 1,
	'vp8x' => 1,
	'vrd1' => 1,
	'vrd2' => 1,
	'vrdstamptool' => 1,
	'vrdversion' => 1,
	'vrinfo' => 1,
	'vrinfoversion' => 1,
	'vw96' => 1,
	'wangannotation' => 1,
	'wangtag1' => 1,
	'wangtag3' => 1,
	'wangtag4' => 1,
	'warning' => 1,
	'warpquadrilateral' => 1,
	'watercolorfilter' => 1,
	'watermark' => 1,
	'watermarktype' => 1,
	'watermarkurl' => 1,
	'wave' => 1,
	'wb_grbglevelsauto' => 1,
	'wb_grblevels' => 1,
	'wb_grblevelsauto' => 1,
	'wb_grblevelsstandard' => 1,
	'wb_grgblevels' => 1,
	'wb_grgblevelsauto' => 1,
	'wb_grgblevelscloudy' => 1,
	'wb_grgblevelsdaylight' => 1,
	'wb_grgblevelsdaylightfluor' => 1,
	'wb_grgblevelsdaywhitefluor' => 1,
	'wb_grgblevelslivingroomwarmwhitefluor' => 1,
	'wb_grgblevelstungsten' => 1,
	'wb_grgblevelswarmwhitefluor' => 1,
	'wb_grgblevelswhitefluorescent' => 1,
	'wb_rgbcoeffs0' => 1,
	'wb_rgbcoeffs1' => 1,
	'wb_rgbcoeffs2' => 1,
	'wb_rgbcoeffs3' => 1,
	'wb_rgblevels2500k' => 1,
	'wb_rgblevels3200k' => 1,
	'wb_rgblevels4500k' => 1,
	'wb_rgblevels6000k' => 1,
	'wb_rgblevels8500k' => 1,
	'wb_rgblevelsauto' => 1,
	'wb_rgblevelscloudy' => 1,
	'wb_rgblevelscustom' => 1,
	'wb_rgblevelsdaylight' => 1,
	'wb_rgblevelsflash' => 1,
	'wb_rgblevelsfluorescent' => 1,
	'wb_rgblevelsfluorescentm1' => 1,
	'wb_rgblevelsfluorescentp1' => 1,
	'wb_rgblevelsfluorescentp2' => 1,
	'wb_rgblevelsshade' => 1,
	'wb_rgblevelstungsten' => 1,
	'wb_rgbmul0' => 1,
	'wb_rgbmul1' => 1,
	'wb_rgbmul2' => 1,
	'wb_rgbmul3' => 1,
	'wbadjdata' => 1,
	'wbblueasshot' => 1,
	'wbbluecloudy' => 1,
	'wbbluedaylight' => 1,
	'wbblueflash' => 1,
	'wbbluetungsten' => 1,
	'wbgreenasshot' => 1,
	'wbgreencloudy' => 1,
	'wbgreendaylight' => 1,
	'wbgreenflash' => 1,
	'wbgreentungsten' => 1,
	'wbinfo' => 1,
	'wbinfo2' => 1,
	'wbinfoa100' => 1,
	'wblevels' => 1,
	'wbredasshot' => 1,
	'wbredcloudy' => 1,
	'wbreddaylight' => 1,
	'wbredflash' => 1,
	'wbredtungsten' => 1,
	'wcsprofiles' => 1,
	'webpage' => 1,
	'weight' => 1,
	'whitebalancematching' => 1,
	'whitebalancetable' => 1,
	'whiteluminance' => 1,
	'whitepointx' => 1,
	'whitepointy' => 1,
	'whitesample' => 1,
	'whitesamplebits' => 1,
	'whitesampleheight' => 1,
	'whitesampleleftborder' => 1,
	'whitesampletopborder' => 1,
	'whitesamplewidth' => 1,
	'wide' => 1,
	'widthbytes' => 1,
	'widthresolution' => 1,
	'windowlocation' => 1,
	'windoworigin' => 1,
	'windoworiginauto' => 1,
	'windowsdevmode' => 1,
	'windowsfilename' => 1,
	'windowsize' => 1,
	'windowtarget' => 1,
	'wm_collectiongroupid' => 1,
	'wm_collectionid' => 1,
	'wm_contentid' => 1,
	'wm_mediaclassprimaryid' => 1,
	'wm_mediaclasssecondaryid' => 1,
	'wm_provider' => 1,
	'wmadrcaveragereference' => 1,
	'wmadrcaveragetarget' => 1,
	'wmadrcpeakreference' => 1,
	'wmadrcpeaktarget' => 1,
	'wmcollectiongroupid' => 1,
	'wmcollectionid' => 1,
	'wmcontentid' => 1,
	'wmshadowfilesourcedrmtype' => 1,
	'wmshadowfilesourcefiletype' => 1,
	'words' => 1,
	'workflowurl' => 1,
	'workingdirectory' => 1,
	'workingpath' => 1,
	'worldtime' => 1,
	'worldtocamera' => 1,
	'worldtondc' => 1,
	'wrapmodes' => 1,
	'writer' => 1,
	'writers' => 1,
	'writtenby' => 1,
	'wwsfamilyname' => 1,
	'wwssubfamilyname' => 1,
	'x' => 1,
	'xcfversion' => 1,
	'xclippathunits' => 1,
	'xheight' => 1,
	'xmag' => 1,
	'xmethod' => 1,
	'xmldata' => 1,
	'xmlfiletype' => 1,
	'xmp_profile' => 1,
	'xmpbj' => 1,
	'xmpdm' => 1,
	'xmpmm' => 1,
	'xmpnote' => 1,
	'xmpplus' => 1,
	'xmprights' => 1,
	'xmptpg' => 1,
	'xobject' => 1,
	'xoffset' => 1,
	'xp_dip_xml' => 1,
	'xtranslayout' => 1,
	'xylocation' => 1,
	'xyoffsetinfo' => 1,
	'yclippathunits' => 1,
	'year' => 1,
	'ylevel' => 1,
	'ymag' => 1,
	'ymethod' => 1,
	'yoffset' => 1,
	'ytarget' => 1,
	'zipbitflag' => 1,
	'zipcompressedsize' => 1,
	'zipcompression' => 1,
	'zipcrc' => 1,
	'zipfilename' => 1,
	'zipmodifydate' => 1,
	'ziprequiredversion' => 1,
	'zipuncompressedsize' => 1,
	'zoom' => 1,
	'zoomedpreviewimage' => 1,
	'zoompos' => 1,
);

# module names for writable Composite tags
my %compositeModules = (
	'filenumber' => 'Image::ExifTool::Canon',
	'flash' => 'Image::ExifTool::XMP',
	'jpgfromraw' => 'Image::ExifTool::Exif',
	'originaldecisiondata' => 'Image::ExifTool::Canon',
	'otherimage' => 'Image::ExifTool::Exif',
	'previewimage' => 'Image::ExifTool::Exif',
	'thumbnailimage' => 'Image::ExifTool::Exif',
);

#++++ End automatically generated code ++++

my %specialStruct = (
    NAMESPACE   => 1,
    STRUCT_NAME => 1,
    TYPE        => 1,
    NOTES       => 1,
);

# insert any user-defined tags into our tag lookup
if (%Image::ExifTool::UserDefined) {
    my @userTables = sort keys %Image::ExifTool::UserDefined;
    while (@userTables) {
        my $table = shift @userTables;
        AddTags($Image::ExifTool::UserDefined{$table}, $table);
    }
}

# insert any other queued tags from plug-in modules
if (@Image::ExifTool::pluginTags) {
    my $args;
    foreach $args (@Image::ExifTool::pluginTags) {
        AddTags($$args[0], $$args[1]);
    }
    undef @Image::ExifTool::pluginTags;
}


#------------------------------------------------------------------------------
# Add tag names corresponding to flattened XMP tags for all structure fields
# Inputs: 0) tag table ref for flattened tags, 1) tagID, 2) lowercase tag name,
#         3) tag ID list ref, 4) reference to list of lowercase tag names
#         5) table number in lookup, 6) tagInfo hash for parent structure
#         7) tag ID of top-level stucture
# Notes: Used only for user-defined structures
sub AddFields($$$$$$;$$)
{
    my ($tagTablePtr, $tagID, $lcTag, $tagIDs, $lcTags, $tnum, $tagInfo, $baseID) = @_;
    return if length($tagID) > 500;    # avoid deep recursion
    unless ($tagInfo) {
        $tagInfo = $$tagTablePtr{$tagID};
        $baseID = $tagID;
    }
    my $strTable = $$tagInfo{Struct};
    unless (ref $strTable) {
        my $strName = $strTable;
        $strTable = $Image::ExifTool::UserDefined::xmpStruct{$strTable};
        $strTable or warn("No definition for structure '$strName'\n"), return;
        $$strTable{STRUCT_NAME} or $$strTable{STRUCT_NAME} = "XMP $strName";
        $$tagInfo{Struct} = $strTable;  # replace name with hash ref
        delete $$tagInfo{SubDirectory}; # deprecated use of SubDirectory in Struct tags
    }
    # inherit NAMESPACE from parent table if it doesn't exist
    $$strTable{NAMESPACE} = $$tagTablePtr{NAMESPACE} unless exists $$strTable{NAMESPACE};
    my $field;
    foreach $field (keys %$strTable) {
        next if $specialStruct{$field};
        my $id = $tagID . ucfirst($field);
        # use name of existing flattened tag if already defined
        my $flatInfo = $$tagTablePtr{$id};
        my $lc = ($flatInfo and $$flatInfo{Name}) ? lc $$flatInfo{Name} : $lcTag . lc($field);
        my $copyID = $baseID;
        push @$tagIDs, \$copyID, $id;
        push @$lcTags, $lc, $lc;
        my $fieldInfo = $$strTable{$field};
        next unless ref $fieldInfo eq 'HASH' and $$fieldInfo{Struct};
        # recursively add flattened tags for all sub-fields
        AddFields($tagTablePtr, $id, $lc, $tagIDs, $lcTags, $tnum, $fieldInfo, $baseID);
    }
}

#------------------------------------------------------------------------------
# Add tags to the lookup (for user-defined tags, etc)
# Inputs: 0) tag table ref, 1) table name
my %tableNumHash;
sub AddTags($$)
{
    my ($tagTablePtr, $table) = @_;

    # generate lookup for table numbers if not done already
    unless (%tableNumHash) {
        my $tnum = 0;
        my $tbl;
        foreach $tbl (@tableList) {
            $tableNumHash{$tbl} = $tnum++;
        }
    }
    my (@moreTables, %moreTableRefs);
    for (;;) {
        my $tnum = $tableNumHash{$table};
        unless (defined $tnum) {
            # add new table to list
            $tnum = scalar @tableList;
            push @tableList, $table;
        }
        my $tagID;
        foreach $tagID (Image::ExifTool::TagTableKeys($tagTablePtr)) {
            my $newInfo = $$tagTablePtr{$tagID};
            if (ref $newInfo eq 'HASH') {
                $$newInfo{Name} or $$newInfo{Name} = Image::ExifTool::MakeTagName($tagID);
                # use new ID of tag in Composite table in case it changed
                $tagID = $$newInfo{NewTagID} if defined $$newInfo{NewTagID};
            } else {
                $newInfo = $$tagTablePtr{$tagID} = { Name => $newInfo };
            }
            my $lcTag = lc $$newInfo{Name};
            my (@lcTags, @tagIDs, $existed, $isFlat);
            # if this is a structure, add all flattened tag names to lookup
            if ($$newInfo{Struct}) {
                AddFields($tagTablePtr, $tagID, $lcTag, \@tagIDs, \@lcTags, $tnum);
            }
            # add tags to lookup even though we don't know if they are writable
            # (to save speed by not having to load the module)
Tags:       for (;;) {
                my $lookup = $tagLookup{$lcTag};
                $lookup or $lookup = $tagLookup{$lcTag} = { };
                if ($$lookup{$tnum}) {
                    my $le = $$lookup{$tnum};
                    my $ids = (ref $le eq 'ARRAY') ? $le : [ $le ];
                    if (ref $tagID) {
                        # a reference points to the tag ID of the base structure for
                        # a flattened tag.  There must be only one of these,
                        # and it must come first.
                        unshift @$ids, $tagID unless ref $$ids[0];
                    # only add new tag ID if it didn't already exist
                    } elsif (grep /^$tagID$/, @$ids) {
                        $existed = 1 unless $isFlat;
                    } else {
                        push @$ids, $tagID;
                    }
                    # only update lookup if there is now more than one entry
                    $$lookup{$tnum} = $ids if @$ids > 1;
                } else {
                    $$lookup{$tnum} = $tagID;
                }
                last unless @tagIDs;
                for (;;) {
                    $tagID = shift @tagIDs;
                    $lcTag = shift @lcTags;
                    last unless $$tagTablePtr{$tagID}; # don't waste time if it exists
                    last Tags unless @tagIDs;
                }
                $isFlat = 1;
            }
            # add any new subdirectory tables (unless done already)
            next if $existed or not $$newInfo{SubDirectory};
            my $subTable = $$newInfo{SubDirectory}{TagTable};
            next unless $subTable and not defined $tableNumHash{$subTable};
            next if $moreTableRefs{$subTable};
            no strict 'refs';
            next unless %$subTable;
            # save new table to process after this one
            push @moreTables, $subTable;
            $moreTableRefs{$subTable} = \%$subTable;
            # save source table name so we can load it when necessary
            $$subTable{SRC_TABLE} = $table;
        }
        $table = shift @moreTables or last;
        $tagTablePtr = $moreTableRefs{$table};
    }
}

#------------------------------------------------------------------------------
# Return true if the tag exists
# Inputs: 0) tag name (case insensitive)
# Returns: true if tag exists
sub TagExists($)
{
    my $tag = lc($_[0]);
    return 1 if $tagExists{$tag} or $tagLookup{$tag};
    return 0;
}

#------------------------------------------------------------------------------
# Find information for writable tags (case insensitive)
# Inputs: 0) tag name (case insensitive)
# Returns: Scalar context: tag info or false if none found
#          List context: list of all matching tagInfo hashes
sub FindTagInfo($)
{
    local $_;
    my $tag = shift;
    my $lcTag = lc($tag);
    my ($tableNum, @tagInfoList, @lookups);
    my $lookup = $tagLookup{$lcTag};
    if (not $lookup and $lcTag =~ /[?*]/) {
        # allow wildcards in tag name
        my $pat = $lcTag;
        $pat =~ s/\*/[-\\w]*/g;
        $pat =~ s/\?/[-\\w]/g;
        my @tags = grep(/^$pat$/, keys %tagLookup);
        if (@tags) {
            push @lookups, $tagLookup{$_} foreach sort @tags;
            $lookup = shift @lookups;
        }
    }
    while ($lookup) {
        foreach $tableNum (keys %$lookup) {
            my $table = GetTagTable($tableList[$tableNum]);
            my $le = $$lookup{$tableNum};
            my ($tagID, $tagIDs);
            if (ref $le eq 'ARRAY') {
                $tagIDs = $le;
                # if first entry is a reference, it indicates that this is a
                # flattened tag and refers to the tag ID of the containing top-level
                # structure, so now is the time to generate the flattened tags
                if (ref $$tagIDs[0]) {
                    # (remove from the lookup since we only need to do this once)
                    my $rootIDPtr = shift @$tagIDs;
                    require Image::ExifTool::XMP;
                    Image::ExifTool::XMP::AddFlattenedTags($table, $$rootIDPtr);
                }
            } else {
                $tagIDs = [ $le ];
            }
            foreach $tagID (@$tagIDs) {
                my @infoList = GetTagInfoList($table,$tagID);
                unless (@infoList) {
                    my $reload;
                    # call write proc if it exists in case it adds tags to the table
                    my $writeProc = $table->{WRITE_PROC};
                    $reload = 1 if $writeProc and &$writeProc();
                    # load module with composite tag if necessary
                    my $compMod = $compositeModules{$lcTag};
                    $reload = 1 if $compMod and eval "require $compMod";
                    @infoList = GetTagInfoList($table,$tagID) if $reload;
                }
                if (@infoList == 1) {
                    push @tagInfoList, @infoList;
                } elsif (@infoList > 1) {
                    my $tagInfo;
                    # must check tag list in case tags have different names
                    foreach $tagInfo (@infoList) {
                        next unless $lcTag eq lc($$tagInfo{Name});
                        push @tagInfoList, $tagInfo;
                    }
                }
            }
        }
        $lookup = shift @lookups;
    }
    if (wantarray) {
        return @tagInfoList;
    } else {
        return $tagInfoList[0];
    }
}


1;  # end

__END__

=head1 NAME

Image::ExifTool::TagLookup - Fast lookup for ExifTool tags

=head1 SYNOPSIS

This module is required by Image::ExifTool for writing tags.

=head1 DESCRIPTION

Provides a fast, case insensitive lookup for tag names.

=head1 AUTHOR

Copyright 2003-2015, Phil Harvey (phil at owl.phy.queensu.ca)

This library is free software; you can redistribute it and/or modify it
under the same terms as Perl itself.

=head1 SEE ALSO

L<Image::ExifTool(3pm)|Image::ExifTool>,
L<Image::ExifTool::BuildTagLookup(3pm)|Image::ExifTool::BuildTagLookup>,
L<Image::ExifTool::TagNames(3pm)|Image::ExifTool::TagNames>

=cut
