/*
*   Copyright 2010 Marco Martin <notmart@gmail.com>
*   Copyright 2010 Lukas Appelhans <l.appelhans@gmx.de>
*   Copyright 2011 - 2012 Johannes Troescher <fritz_van_tom@hotmail.com>
*
*   This program is free software; you can redistribute it and/or modify
*   it under the terms of the GNU Library General Public License as
*   published by the Free Software Foundation; either version 2, or
*   (at your option) any later version.
*
*   This program is distributed in the hope that it will be useful,
*   but WITHOUT ANY WARRANTY; without even the implied warranty of
*   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
*   GNU General Public License for more details
*
*   You should have received a copy of the GNU Library General Public
*   License along with this program; if not, write to the
*   Free Software Foundation, Inc.,
*   51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
*/

import QtQuick 2.1
import QtQuick.Layouts 1.1
import org.kde.plasma.components 2.0 as PlasmaComponents
import org.kde.plasma.core 2.0 as PlasmaCore
//import org.kde.plasma.graphicswidgets 2.0 as PlasmaWidgets
import org.kde.plasma.extras 2.0 as PlasmaExtras
import QtQuick.XmlListModel 2.0
import org.kde.plasma.plasmoid 2.0

Item {
    property int minimumWidth: 540
    property int minimumHeight: 480
    Layout.minimumWidth: minimumWidth < buttonRow.width ? buttonRow.width : minimumWidth
    Layout.minimumHeight: minimumHeight

    property int iconSize: units.iconSizes.large

    InfoModel { id: infoModel }

    RssModel {
        id: newsFeedModel
        feedUrl: "https://community.chakralinux.org/c/news.rss"
    }

    Item {
        id: root
        anchors { fill: parent; margins: 3 }

        PlasmaExtras.Paragraph {
            id: welcome
            text: i18n("Thanks for trying out our latest release! Hopefully you will take the time to read this quick overview of what Chakra is, what it is not, what we are trying to achieve, and what is yet to be done..")

            anchors {
                left: parent.left; leftMargin: 5;
                right: parent.right; rightMargin: 5;
                top: parent.top; topMargin: 3
            }
        }

        PlasmaCore.Svg {
            id: lineSvg
            imagePath: "widgets/line"
        }

        PlasmaCore.SvgItem {
            id: headerSeparator
            svg: lineSvg
            elementId: "horizontal-line"
            anchors { left: parent.left; right: parent.right; top: welcome.bottom; topMargin: 5 }
            height: lineSvg.elementSize("horizontal-line").height
        }

        Item {
            id: navigation
            anchors { left: parent.left; right: parent.right; top: headerSeparator.bottom; bottom: buttonRow.top }

            PlasmaComponents.TabBar {
                id: modeSelect
                anchors { left: parent.left; right: parent.right; top: parent.top}

                PlasmaComponents.TabButton { tab: welcomeTab; text: i18n("Welcome"); iconSource: "chakra-shield"}
                PlasmaComponents.TabButton { tab: newsTab; text: i18n("News"); iconSource: "application-rss+xml" }
            }

            PlasmaComponents.TabGroup {
                id: tabGroup
                anchors { left: parent.left; right: parent.right; top: modeSelect.bottom; topMargin: 5; bottom: parent.bottom }

                NavigationStack { id: welcomeTab; model: infoModel }
                NavigationStack { id: newsTab; model: newsFeedModel }

                onCurrentTabChanged: {
                    if ((currentTab == newsTab) && (newsFeedModel.status == XmlListModel.Ready)){
                        newsFeedModel.reload()
                    }
                }
            }
        }

        Row {
            id: buttonRow
            spacing: 3

            anchors {
                horizontalCenter: parent.horizontalCenter;bottom: parent.bottom
            }

            Rectangle {
                height: 48
            }

            PlasmaCore.DataSource {
                id: executer
                engine: "executable"
                onNewData: {executer.disconnectSource(sourceName);}
            }

            InfoButton {
                id: install

                text: i18n("Install Chakra")
                iconName: "calamares"
                onClicked: executer.connectSource("/usr/bin/launch-calamares.sh");
            }

            InfoButton {
                id: website

                text: i18n("Website")
                iconName: "chakra-shield"
                onClicked: executer.connectSource("xdg-open https://www.chakralinux.org/")
            }

            InfoButton {
                id: donate

                text: i18n("Donate")
                iconName: "help-donate"
                onClicked: executer.connectSource("xdg-open https://www.chakralinux.org/?donate")
            }

            InfoButton {
                id: beginner

                text: i18n("Help")
                iconName: "system-help"
                onClicked: executer.connectSource("xdg-open https://community.chakralinux.org/t/how-to-install-chakra/45")
            }

            InfoButton {
                id: passwords

                text: i18n("Passwords")
                iconName: "preferences-desktop-cryptography"
                onClicked: executer.connectSource("kdialog --title "
                           + "\"" + i18n("Passwords") + "\""
                           + " --msgbox "
                           + "\"" + i18n("You may need some passwords to do stuff, so here they are:\n\nroot: root / root\nuser: live / live\n\nHave fun") + "\"")
            }

            InfoButton {
                id: installed

                text: i18n("Installed Packages")
                iconName: "preflight-verifier"
                onClicked: executer.connectSource("pacman -Q > /tmp/installed.pkgs && kdialog --title " 
                           + "\"" + i18n("Installed Packages") + "\""
                           + " --textbox  /tmp/installed.pkgs 400 600 --icon preflight-verifier")
            }
        }
    }
}
