/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.AspectRatio;
import com.eteks.sweethome3d.model.Camera;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.lang.ref.WeakReference;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class VideoController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView videoView;
    private AspectRatio aspectRatio;
    private int frameRate;
    private int width;
    private int height;
    private int quality;
    private float speed;
    private List<Camera> cameraPath;
    private long time;
    private int ceilingLightColor;

    public VideoController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.updateProperties();
        home.getEnvironment().addPropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, new HomeEnvironmentChangeListener(this));
    }

    @Override
    public DialogView getView() {
        if (this.videoView == null) {
            this.videoView = this.viewFactory.createVideoView(this.home, this.preferences, this);
        }
        return this.videoView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    protected void updateProperties() {
        HomeEnvironment homeEnvironment = this.home.getEnvironment();
        this.setFrameRate(homeEnvironment.getVideoFrameRate());
        this.setWidth(homeEnvironment.getVideoWidth(), false);
        this.setHeight(homeEnvironment.getVideoHeight(), false);
        this.setAspectRatio(homeEnvironment.getVideoAspectRatio());
        this.setQuality(homeEnvironment.getVideoQuality());
        this.setSpeed(homeEnvironment.getVideoSpeed());
        List<Camera> list = homeEnvironment.getVideoCameraPath();
        this.setCameraPath(list);
        this.setTime(list.isEmpty() ? this.home.getCamera().getTime() : list.get(0).getTime());
        this.setCeilingLightColor(homeEnvironment.getCeillingLightColor());
    }

    public void setAspectRatio(AspectRatio aspectRatio) {
        if (this.aspectRatio != aspectRatio) {
            AspectRatio aspectRatio2 = this.aspectRatio;
            this.aspectRatio = aspectRatio;
            this.propertyChangeSupport.firePropertyChange(Property.ASPECT_RATIO.name(), (Object)aspectRatio2, (Object)aspectRatio);
            this.home.getEnvironment().setVideoAspectRatio(this.aspectRatio);
            this.setHeight(Math.round((float)this.width / this.aspectRatio.getValue().floatValue()), false);
        }
    }

    public AspectRatio getAspectRatio() {
        return this.aspectRatio;
    }

    public void setFrameRate(int n) {
        if (this.frameRate != n) {
            int n2 = this.frameRate;
            this.frameRate = n;
            this.propertyChangeSupport.firePropertyChange(Property.QUALITY.name(), n2, n);
            this.home.getEnvironment().setVideoFrameRate(this.frameRate);
        }
    }

    public int getFrameRate() {
        return this.frameRate;
    }

    public void setWidth(int n) {
        this.setWidth(n, true);
    }

    private void setWidth(int n, boolean bl) {
        if (this.width != n) {
            int n2 = this.width;
            this.width = n;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), n2, n);
            if (bl) {
                this.setHeight(Math.round((float)n / this.aspectRatio.getValue().floatValue()), false);
            }
            this.home.getEnvironment().setVideoWidth(this.width);
        }
    }

    public int getWidth() {
        return this.width;
    }

    public void setHeight(int n) {
        this.setHeight(n, true);
    }

    private void setHeight(int n, boolean bl) {
        if (this.height != n) {
            int n2 = this.height;
            this.height = n;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), n2, n);
            if (bl) {
                this.setWidth(Math.round((float)n * this.aspectRatio.getValue().floatValue()), false);
            }
        }
    }

    public int getHeight() {
        return this.height;
    }

    public void setQuality(int n) {
        if (this.quality != n) {
            int n2 = this.quality;
            this.quality = Math.min(n, this.getQualityLevelCount() - 1);
            this.propertyChangeSupport.firePropertyChange(Property.QUALITY.name(), n2, n);
            this.home.getEnvironment().setVideoQuality(this.quality);
        }
    }

    public int getQuality() {
        return this.quality;
    }

    public void setSpeed(float f) {
        if (this.speed != f) {
            float f2 = this.speed;
            this.speed = f;
            this.propertyChangeSupport.firePropertyChange(Property.SPEED.name(), Float.valueOf(f2), Float.valueOf(f));
            this.home.getEnvironment().setVideoSpeed(this.speed);
        }
    }

    public float getSpeed() {
        return this.speed;
    }

    public int getQualityLevelCount() {
        return 4;
    }

    public List<Camera> getCameraPath() {
        return this.cameraPath;
    }

    public void setCameraPath(List<Camera> list) {
        if (this.cameraPath != list) {
            List<Camera> list2 = this.cameraPath;
            this.cameraPath = list;
            this.propertyChangeSupport.firePropertyChange(Property.CAMERA_PATH.name(), list2, list);
            this.home.getEnvironment().setVideoCameraPath(this.cameraPath);
        }
    }

    public void setTime(long l) {
        if (this.time != l) {
            long l2 = this.time;
            this.time = l;
            this.propertyChangeSupport.firePropertyChange(Property.TIME.name(), l2, l);
            this.home.getCamera().setTime(l);
        }
    }

    public long getTime() {
        return this.time;
    }

    public void setCeilingLightColor(int n) {
        if (this.ceilingLightColor != n) {
            int n2 = this.ceilingLightColor;
            this.ceilingLightColor = n;
            this.propertyChangeSupport.firePropertyChange(Property.CEILING_LIGHT_COLOR.name(), n2, n);
            this.home.getEnvironment().setCeillingLightColor(n);
        }
    }

    public int getCeilingLightColor() {
        return this.ceilingLightColor;
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    public void setHomeProperty(String string, String string2) {
        this.home.setProperty(string, string2);
    }

    private static class HomeEnvironmentChangeListener
    implements PropertyChangeListener {
        private WeakReference<VideoController> videoController;

        public HomeEnvironmentChangeListener(VideoController videoController) {
            this.videoController = new WeakReference<VideoController>(videoController);
        }

        public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
            VideoController videoController = (VideoController)this.videoController.get();
            if (videoController == null) {
                ((HomeEnvironment)propertyChangeEvent.getSource()).removePropertyChangeListener(HomeEnvironment.Property.CEILING_LIGHT_COLOR, this);
            } else {
                videoController.updateProperties();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ASPECT_RATIO,
        FRAME_RATE,
        WIDTH,
        HEIGHT,
        QUALITY,
        SPEED,
        CAMERA_PATH,
        TIME,
        CEILING_LIGHT_COLOR;

    }
}

