/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor;

import com.apple.eawt.Application;
import com.apple.eawt.ApplicationAdapter;
import com.apple.eawt.ApplicationEvent;
import com.apple.eawt.ApplicationListener;
import com.eteks.furniturelibraryeditor.io.FileFurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.io.FurnitureLibraryFileRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryRecorder;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.swing.SwingEditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorController;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorView;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.swing.FileContentManager;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.View;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.ResourceBundle;
import javax.imageio.ImageIO;
import javax.swing.ActionMap;
import javax.swing.ImageIcon;
import javax.swing.InputMap;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JRootPane;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;

public class FurnitureLibraryEditor {
    private FurnitureLibraryFileRecorder furnitureLibraryRecorder;
    private FileFurnitureLibraryUserPreferences userPreferences;
    private EditorViewFactory viewFactory;
    private ContentManager contentManager;

    public FurnitureLibraryRecorder getFurnitureLibraryRecorder() {
        if (this.furnitureLibraryRecorder == null) {
            this.furnitureLibraryRecorder = new FurnitureLibraryFileRecorder();
        }
        return this.furnitureLibraryRecorder;
    }

    public FurnitureLibraryUserPreferences getUserPreferences() {
        if (this.userPreferences == null) {
            this.userPreferences = new FileFurnitureLibraryUserPreferences();
        }
        return this.userPreferences;
    }

    protected ContentManager getContentManager() {
        if (this.contentManager == null) {
            this.contentManager = new FileContentManager(this.getUserPreferences()){
                private File modelsDirectory;

                public String showOpenDialog(View view, String string, ContentManager.ContentType contentType) {
                    if (contentType == ContentManager.ContentType.USER_DEFINED) {
                        JFileChooser jFileChooser = new JFileChooser();
                        if (this.modelsDirectory != null) {
                            jFileChooser.setCurrentDirectory(this.modelsDirectory);
                        }
                        jFileChooser.setDialogTitle(string);
                        jFileChooser.setMultiSelectionEnabled(true);
                        if (jFileChooser.showOpenDialog((JComponent)((Object)view)) == 0) {
                            this.modelsDirectory = jFileChooser.getCurrentDirectory();
                            String string2 = "";
                            for (File file : jFileChooser.getSelectedFiles()) {
                                if (string2.length() > 0) {
                                    string2 = string2 + File.pathSeparator;
                                }
                                string2 = string2 + file;
                            }
                            return string2;
                        }
                        return null;
                    }
                    return super.showOpenDialog(view, string, contentType);
                }
            };
        }
        return this.contentManager;
    }

    protected EditorViewFactory getViewFactory() {
        if (this.viewFactory == null) {
            this.viewFactory = new SwingEditorViewFactory();
        }
        return this.viewFactory;
    }

    private String getName() {
        return this.getUserPreferences().getLocalizedString(FurnitureLibraryEditor.class, "applicationName", new Object[0]);
    }

    protected EditorController createEditorController(FurnitureLibrary furnitureLibrary) {
        return new EditorController(furnitureLibrary, this.getFurnitureLibraryRecorder(), this.getUserPreferences(), this.getViewFactory(), this.getContentManager());
    }

    public static void main(String[] stringArray) {
        new FurnitureLibraryEditor().init(stringArray);
    }

    protected void init(final String[] stringArray) {
        this.initSystemProperties();
        this.initLookAndFeel();
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                FurnitureLibraryEditor.this.run(stringArray);
            }
        });
    }

    private void initSystemProperties() {
        if (OperatingSystem.isMacOSX()) {
            String string = FurnitureLibraryEditor.class.getName();
            string = string.substring(0, string.lastIndexOf("."));
            ResourceBundle resourceBundle = ResourceBundle.getBundle(string + ".package");
            String string2 = resourceBundle.getString("FurnitureLibraryEditor.applicationName");
            System.setProperty("com.apple.mrj.application.apple.menu.about.name", string2);
            System.setProperty("apple.laf.useScreenMenuBar", "true");
            System.setProperty("apple.awt.graphics.UseQuartz", "true");
        }
        if (System.getProperty("j3d.implicitAntialiasing") == null) {
            System.setProperty("j3d.implicitAntialiasing", "true");
        }
    }

    private void initLookAndFeel() {
        try {
            UIManager.setLookAndFeel(System.getProperty("swing.defaultlaf", UIManager.getSystemLookAndFeelClassName()));
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                UIManager.put("TitledBorder.border", UIManager.getBorder("TitledBorder.aquaVariant"));
            }
            SwingTools.updateSwingResourceLanguage();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void run(String[] stringArray) {
        String string = stringArray.length == 2 && "-open".equals(stringArray[0]) ? stringArray[1] : null;
        final FurnitureLibrary furnitureLibrary = new FurnitureLibrary();
        final EditorController editorController = this.createEditorController(furnitureLibrary);
        final EditorView editorView = editorController.getView();
        final JFrame jFrame = new JFrame(){
            {
                if (editorView instanceof JRootPane) {
                    this.setRootPane((JRootPane)((Object)editorView));
                } else {
                    this.add((JComponent)((Object)editorView));
                }
            }
        };
        Image[] imageArray = new Image[]{new ImageIcon(FurnitureLibraryEditor.class.getResource("resources/frameIcon.png")).getImage(), new ImageIcon(FurnitureLibraryEditor.class.getResource("resources/frameIcon32x32.png")).getImage()};
        try {
            jFrame.getClass().getMethod("setIconImages", List.class).invoke((Object)jFrame, Arrays.asList(imageArray));
        }
        catch (Exception exception) {
            jFrame.setIconImage(imageArray[0]);
        }
        jFrame.setLocationByPlatform(true);
        jFrame.pack();
        jFrame.setDefaultCloseOperation(0);
        jFrame.setVisible(true);
        jFrame.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent windowEvent) {
                editorController.exit();
            }
        });
        if (jFrame.getJMenuBar() == null) {
            this.installAccelerators(jFrame, editorController);
        }
        if (OperatingSystem.isMacOSX()) {
            MacOSXConfiguration.bindToApplicationMenu(editorController);
        }
        if (string != null) {
            editorController.open(string);
        }
        this.updateFrameTitle(jFrame, furnitureLibrary, this.getUserPreferences(), this.getContentManager());
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.LOCATION, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryEditor.this.updateFrameTitle(jFrame, furnitureLibrary, FurnitureLibraryEditor.this.getUserPreferences(), FurnitureLibraryEditor.this.getContentManager());
            }
        });
        furnitureLibrary.addPropertyChangeListener(FurnitureLibrary.Property.MODIFIED, new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                FurnitureLibraryEditor.this.updateFrameTitle(jFrame, furnitureLibrary, FurnitureLibraryEditor.this.getUserPreferences(), FurnitureLibraryEditor.this.getContentManager());
            }
        });
    }

    private void installAccelerators(JFrame jFrame, EditorController editorController) {
        JComponent jComponent = (JComponent)((Object)editorController.getView());
        InputMap inputMap = jComponent.getInputMap(2);
        ActionMap actionMap = jComponent.getActionMap();
        for (Object object : actionMap.allKeys()) {
            if (!(object instanceof EditorView.ActionType)) continue;
            inputMap.put((KeyStroke)actionMap.get(object).getValue("AcceleratorKey"), object);
        }
    }

    private void updateFrameTitle(JFrame jFrame, FurnitureLibrary furnitureLibrary, UserPreferences userPreferences, ContentManager contentManager) {
        String string = furnitureLibrary.getLocation();
        String string2 = string == null ? userPreferences.getLocalizedString(FurnitureLibraryEditor.class, "untitled", new Object[0]) : contentManager.getPresentationName(string, ContentManager.ContentType.FURNITURE_LIBRARY);
        String string3 = string2;
        if (OperatingSystem.isMacOSX()) {
            Boolean bl = furnitureLibrary.isModified();
            jFrame.getRootPane().putClientProperty("windowModified", bl);
            if (OperatingSystem.isMacOSXLeopardOrSuperior()) {
                File file;
                jFrame.getRootPane().putClientProperty("Window.documentModified", bl);
                if (string != null && (file = new File(string)).exists()) {
                    jFrame.getRootPane().putClientProperty("Window.documentFile", file);
                }
            }
        } else {
            string3 = string3 + " - " + this.getName();
            if (furnitureLibrary.isModified()) {
                string3 = "* " + string3;
            }
        }
        jFrame.setTitle(string3);
    }

    private static class MacOSXConfiguration {
        private MacOSXConfiguration() {
        }

        public static void bindToApplicationMenu(final EditorController editorController) {
            Application application = Application.getApplication();
            application.addApplicationListener((ApplicationListener)new ApplicationAdapter(){

                public void handleQuit(ApplicationEvent applicationEvent) {
                    editorController.exit();
                }

                public void handleAbout(ApplicationEvent applicationEvent) {
                    editorController.about();
                    applicationEvent.setHandled(true);
                }

                public void handlePreferences(ApplicationEvent applicationEvent) {
                    editorController.editPreferences();
                    applicationEvent.setHandled(true);
                }

                public void handleOpenFile(ApplicationEvent applicationEvent) {
                    editorController.open(applicationEvent.getFilename());
                }

                public void handleReOpenApplication(ApplicationEvent applicationEvent) {
                    SwingUtilities.getWindowAncestor((JComponent)((Object)editorController.getView())).toFront();
                }
            });
            application.setEnabledAboutMenu(true);
            application.setEnabledPreferencesMenu(true);
            if (!"true".equalsIgnoreCase(System.getProperty("furniturelibraryeditor.bundle", "false"))) {
                try {
                    BufferedImage bufferedImage = ImageIO.read(MacOSXConfiguration.class.getResource("swing/resources/aboutIcon.png"));
                    application.setDockIconImage((Image)bufferedImage);
                }
                catch (NoSuchMethodError noSuchMethodError) {
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

