/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.model;

import com.eteks.sweethome3d.model.LengthUnit;
import com.eteks.sweethome3d.model.UserPreferences;
import java.beans.PropertyChangeSupport;

public abstract class FurnitureLibraryUserPreferences
extends UserPreferences {
    private final PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    private String[] editedProperties = new String[]{"MODEL", "ICON", "NAME", "TAGS", "CATEGORY", "CREATOR", "WIDTH", "DEPTH", "HEIGHT", "ELEVATION", "MOVABLE", "DOOR_OR_WINDOW", "DOOR_OR_WINDOW_CUT_OUT_SHAPE", "STAIRCASE_CUT_OUT_SHAPE", "MODEL_ROTATION"};
    private String defaultCreator;
    private boolean offlineFurnitureLibrary;
    private String furnitureResourcesLocalDirectory;
    private String furnitureResourcesRemoteUrlBase;

    public FurnitureLibraryUserPreferences() {
        this.setUnit(LengthUnit.CENTIMETER);
        this.offlineFurnitureLibrary = true;
    }

    public String[] getSupportedLanguages() {
        return new String[]{"en", "fr"};
    }

    public String getFurnitureDefaultLanguage() {
        return this.getLanguage();
    }

    public String[] getEditedProperties() {
        return this.editedProperties;
    }

    public boolean isModelContentAlwaysConvertedToOBJFormat() {
        return false;
    }

    public String getDefaultCreator() {
        return this.defaultCreator;
    }

    public void setDefaultCreator(String string) {
        if (string != this.defaultCreator || string != null && !string.equals(this.defaultCreator)) {
            String string2 = this.defaultCreator;
            this.defaultCreator = string;
            this.propertyChangeSupport.firePropertyChange(Property.DEFAULT_CREATOR.toString(), string2, string);
        }
    }

    public boolean isOnlineFurnitureLibrarySupported() {
        return false;
    }

    public boolean isFurnitureLibraryOffline() {
        return this.offlineFurnitureLibrary;
    }

    public void setFurnitureLibraryOffline(boolean bl) {
        if (!this.isOnlineFurnitureLibrarySupported() && !bl) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (bl != this.offlineFurnitureLibrary) {
            this.offlineFurnitureLibrary = bl;
            this.propertyChangeSupport.firePropertyChange(Property.OFFLINE_FURNITURE_LIBRARY.toString(), !bl, bl);
        }
    }

    public String getFurnitureResourcesLocalDirectory() {
        return this.furnitureResourcesLocalDirectory;
    }

    public void setFurnitureResourcesLocalDirectory(String string) {
        if (!this.isOnlineFurnitureLibrarySupported()) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (string != this.furnitureResourcesLocalDirectory || string != null && !string.equals(this.furnitureResourcesLocalDirectory)) {
            String string2 = this.furnitureResourcesLocalDirectory;
            this.furnitureResourcesLocalDirectory = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_LOCAL_DIRECTORY.toString(), string2, string);
        }
    }

    public String getFurnitureResourcesRemoteURLBase() {
        return this.furnitureResourcesRemoteUrlBase;
    }

    public void setFurnitureResourcesRemoteURLBase(String string) {
        if (!this.isOnlineFurnitureLibrarySupported()) {
            throw new IllegalArgumentException("Furniture library doesn't support online libraries");
        }
        if (string != this.furnitureResourcesRemoteUrlBase || string != null && !string.equals(this.furnitureResourcesRemoteUrlBase)) {
            String string2 = this.furnitureResourcesRemoteUrlBase;
            this.furnitureResourcesRemoteUrlBase = string;
            this.propertyChangeSupport.firePropertyChange(Property.FURNITURE_RESOURCES_REMOTE_URL_BASE.toString(), string2, string);
        }
    }

    public boolean isContentMatchingFurnitureName() {
        return true;
    }

    public boolean isCheckUpdatesEnabled() {
        return false;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        DEFAULT_CREATOR,
        OFFLINE_FURNITURE_LIBRARY,
        FURNITURE_RESOURCES_LOCAL_DIRECTORY,
        FURNITURE_RESOURCES_REMOTE_URL_BASE;

    }
}

