/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.furniturelibraryeditor.viewcontroller;

import com.eteks.furniturelibraryeditor.model.FurnitureLibrary;
import com.eteks.furniturelibraryeditor.model.FurnitureLibraryUserPreferences;
import com.eteks.furniturelibraryeditor.viewcontroller.EditorViewFactory;
import com.eteks.furniturelibraryeditor.viewcontroller.FurnitureLanguageController;
import com.eteks.furniturelibraryeditor.viewcontroller.ImportFurnitureController;
import com.eteks.sweethome3d.model.CatalogDoorOrWindow;
import com.eteks.sweethome3d.model.CatalogLight;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.FurnitureCatalog;
import com.eteks.sweethome3d.model.FurnitureCategory;
import com.eteks.sweethome3d.model.Sash;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.DialogView;
import com.eteks.sweethome3d.viewcontroller.View;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Set;
import java.util.TreeSet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FurnitureController
implements Controller {
    private static final Map<String, Property> PROPERTIES_MAP = new HashMap<String, Property>();
    private static final String DEFAULT_CUT_OUT_SHAPE = "M0,0 v1 h1 v-1 z";
    private final FurnitureLibrary furnitureLibrary;
    private final List<CatalogPieceOfFurniture> modifiedFurniture;
    private final Set<Property> editableProperties;
    private final FurnitureLibraryUserPreferences preferences;
    private final FurnitureLanguageController furnitureLanguageController;
    private final EditorViewFactory viewFactory;
    private final ContentManager contentManager;
    private final PropertyChangeSupport propertyChangeSupport;
    private DialogView homeFurnitureView;
    private String id;
    private String name;
    private String description;
    private String information;
    private String[] tags;
    private Long creationDate;
    private Float grade;
    private FurnitureCategory category;
    private Content model;
    private Content icon;
    private Float width;
    private Float proportionalWidth;
    private Float depth;
    private Float proportionalDepth;
    private Float height;
    private Float proportionalHeight;
    private Float elevation;
    private Boolean movable;
    private Boolean doorOrWindow;
    private String doorOrWindowCutOutShape;
    private Boolean staircase;
    private String staircaseCutOutShape;
    private Boolean backFaceShown;
    private Long modelSize;
    private Boolean resizable;
    private Boolean deformable;
    private Boolean texturable;
    private float[][] modelRotation;
    private String creator;
    private BigDecimal price;
    private BigDecimal valueAddedTaxPercentage;
    private boolean proportional;
    private PropertyChangeListener widthChangeListener;
    private PropertyChangeListener depthChangeListener;
    private PropertyChangeListener heightChangeListener;

    public FurnitureController(FurnitureLibrary furnitureLibrary, List<CatalogPieceOfFurniture> list, FurnitureLibraryUserPreferences furnitureLibraryUserPreferences, FurnitureLanguageController furnitureLanguageController, EditorViewFactory editorViewFactory, ContentManager contentManager) {
        this.furnitureLibrary = furnitureLibrary;
        this.modifiedFurniture = list;
        this.preferences = furnitureLibraryUserPreferences;
        this.furnitureLanguageController = furnitureLanguageController;
        this.viewFactory = editorViewFactory;
        this.contentManager = contentManager;
        this.propertyChangeSupport = new PropertyChangeSupport(this);
        this.editableProperties = new HashSet<Property>();
        for (String string : furnitureLibraryUserPreferences.getEditedProperties()) {
            this.editableProperties.add(PROPERTIES_MAP.get(string));
        }
        this.setProportional(list.size() == 1);
        this.updateProperties();
        this.addListeners();
    }

    @Override
    public DialogView getView() {
        if (this.homeFurnitureView == null) {
            this.homeFurnitureView = this.viewFactory.createFurnitureView(this.preferences, this);
        }
        return this.homeFurnitureView;
    }

    public void displayView(View view) {
        this.getView().displayView(view);
    }

    public void addPropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.addPropertyChangeListener(property.name(), propertyChangeListener);
    }

    public void removePropertyChangeListener(Property property, PropertyChangeListener propertyChangeListener) {
        this.propertyChangeSupport.removePropertyChangeListener(property.name(), propertyChangeListener);
    }

    private void addListeners() {
        this.widthChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setDepth(Float.valueOf(FurnitureController.this.proportionalDepth.floatValue() * f), true);
                    FurnitureController.this.setHeight(Float.valueOf(FurnitureController.this.proportionalHeight.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                }
            }
        };
        this.depthChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setWidth(Float.valueOf(FurnitureController.this.proportionalWidth.floatValue() * f), true);
                    FurnitureController.this.setHeight(Float.valueOf(FurnitureController.this.proportionalHeight.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.HEIGHT, FurnitureController.this.heightChangeListener);
                }
            }
        };
        this.heightChangeListener = new PropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (FurnitureController.this.isProportional()) {
                    FurnitureController.this.removePropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.removePropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                    float f = ((Float)propertyChangeEvent.getNewValue()).floatValue() / ((Float)propertyChangeEvent.getOldValue()).floatValue();
                    FurnitureController.this.setWidth(Float.valueOf(FurnitureController.this.proportionalWidth.floatValue() * f), true);
                    FurnitureController.this.setDepth(Float.valueOf(FurnitureController.this.proportionalDepth.floatValue() * f), true);
                    FurnitureController.this.addPropertyChangeListener(Property.WIDTH, FurnitureController.this.widthChangeListener);
                    FurnitureController.this.addPropertyChangeListener(Property.DEPTH, FurnitureController.this.depthChangeListener);
                }
            }
        };
        this.addPropertyChangeListener(Property.WIDTH, this.widthChangeListener);
        this.addPropertyChangeListener(Property.DEPTH, this.depthChangeListener);
        this.addPropertyChangeListener(Property.HEIGHT, this.heightChangeListener);
    }

    public ContentManager getContentManager() {
        return this.contentManager;
    }

    public boolean isPropertyEditable(Property property) {
        if (this.modifiedFurniture.size() == 1) {
            return this.editableProperties.contains((Object)property);
        }
        return this.editableProperties.contains((Object)property) && property != Property.ID && property != Property.MODEL && property != Property.ICON && property != Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE;
    }

    protected void updateProperties() {
        if (this.modifiedFurniture.isEmpty()) {
            this.setId(null);
            this.setName(null);
            this.setDescription(null);
            this.setCategory(null);
            this.setModel((Content)null);
            this.setIcon(null);
            this.setWidth(null);
            this.setDepth(null);
            this.setHeight(null);
            this.setElevation(null);
            this.setMovable(null);
            this.setDoorOrWindow(null);
            this.setDoorOrWindowCutOutShape(null);
            this.setStaircase(null);
            this.setStaircaseCutOutShape(null);
            this.setBackFaceShown(null);
            this.setResizable(null);
            this.setDeformable(null);
            this.setTexturable(null);
            this.setModelRotation(null);
            this.setCreator(null);
            this.setPrice(null);
            this.setValueAddedTaxPercentage(null);
            this.editableProperties.remove((Object)Property.PROPORTIONAL);
        } else {
            Comparable<CatalogPieceOfFurniture> comparable;
            int n;
            String string;
            Object object;
            Comparable<CatalogPieceOfFurniture> comparable2;
            Object[] objectArray;
            Object object2;
            CatalogPieceOfFurniture catalogPieceOfFurniture = this.modifiedFurniture.get(0);
            this.setBackFaceShown(false);
            if (this.modifiedFurniture.size() == 1) {
                this.setIcon(catalogPieceOfFurniture.getIcon());
                this.setModel(catalogPieceOfFurniture.getModel());
                this.setModelSize(catalogPieceOfFurniture.getModelSize());
                this.editableProperties.add(Property.BACK_FACE_SHOWN);
            } else {
                this.setIcon(null);
                this.setModel((Content)null);
                this.setModelSize(null);
                this.editableProperties.remove((Object)Property.BACK_FACE_SHOWN);
            }
            String string2 = catalogPieceOfFurniture.getId();
            if (string2 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (string2.equals(this.modifiedFurniture.get(i).getId())) continue;
                    string2 = null;
                    break;
                }
            }
            this.setId(string2);
            String string3 = this.furnitureLanguageController.getFurnitureLangauge();
            String string4 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string3, "NAME", catalogPieceOfFurniture.getName());
            if (string4 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    object2 = this.modifiedFurniture.get(i);
                    if (string4.equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)object2, string3, "NAME", ((CatalogPieceOfFurniture)object2).getName()))) continue;
                    string4 = null;
                    break;
                }
            }
            this.setName(string4);
            String string5 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string3, "DESCRIPTION", catalogPieceOfFurniture.getDescription());
            if (string5 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    objectArray = this.modifiedFurniture.get(i);
                    if (string5.equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)objectArray, string3, "DESCRIPTION", objectArray.getDescription()))) continue;
                    string5 = null;
                    break;
                }
            }
            this.setDescription(string5);
            object2 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string3, "INFORMATION", catalogPieceOfFurniture.getInformation());
            if (object2 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    comparable2 = this.modifiedFurniture.get(i);
                    if (((String)object2).equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData((CatalogPieceOfFurniture)comparable2, string3, "INFORMATION", ((CatalogPieceOfFurniture)comparable2).getInformation()))) continue;
                    object2 = null;
                    break;
                }
            }
            this.setInformation((String)object2);
            objectArray = (String[])this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string3, "TAGS", catalogPieceOfFurniture.getTags());
            if (objectArray != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture2 = this.modifiedFurniture.get(i);
                    if (Arrays.equals(objectArray, (String[])this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string3, "TAGS", catalogPieceOfFurniture2.getTags()))) continue;
                    objectArray = null;
                    break;
                }
            }
            this.setTags((String[])objectArray);
            comparable2 = catalogPieceOfFurniture.getCreationDate();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                CatalogPieceOfFurniture catalogPieceOfFurniture3 = this.modifiedFurniture.get(i);
                if ((comparable2 != null || catalogPieceOfFurniture3.getCreationDate() == null) && (comparable2 == null || ((Long)comparable2).equals(catalogPieceOfFurniture3.getCreationDate()))) continue;
                comparable2 = null;
                break;
            }
            this.setCreationDate((Long)comparable2);
            Float f = catalogPieceOfFurniture.getGrade();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                object = this.modifiedFurniture.get(i);
                if ((f != null || ((CatalogPieceOfFurniture)object).getGrade() == null) && (f == null || f.equals(((CatalogPieceOfFurniture)object).getGrade()))) continue;
                f = null;
                break;
            }
            this.setGrade(f);
            FurnitureCategory furnitureCategory = catalogPieceOfFurniture.getCategory();
            object = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string3, "CATEGORY", furnitureCategory.getName());
            if (furnitureCategory != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture4 = this.modifiedFurniture.get(i);
                    if (((String)object).equals(this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture4, string3, "CATEGORY", catalogPieceOfFurniture4.getCategory().getName()))) continue;
                    furnitureCategory = null;
                    break;
                }
            }
            this.setCategory(furnitureCategory == null ? null : new FurnitureCategory((String)object));
            Float f2 = Float.valueOf(catalogPieceOfFurniture.getWidth());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f2.floatValue() == this.modifiedFurniture.get(i).getWidth()) continue;
                f2 = null;
                break;
            }
            this.setWidth(f2);
            Float f3 = Float.valueOf(catalogPieceOfFurniture.getDepth());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f3.floatValue() == this.modifiedFurniture.get(i).getDepth()) continue;
                f3 = null;
                break;
            }
            this.setDepth(f3);
            Float f4 = Float.valueOf(catalogPieceOfFurniture.getHeight());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f4.floatValue() == this.modifiedFurniture.get(i).getHeight()) continue;
                f4 = null;
                break;
            }
            this.setHeight(f4);
            Float f5 = Float.valueOf(catalogPieceOfFurniture.getElevation());
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (f5.floatValue() == this.modifiedFurniture.get(i).getElevation()) continue;
                f5 = null;
                break;
            }
            this.setElevation(f5);
            Boolean bl = catalogPieceOfFurniture.isMovable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl.booleanValue() == this.modifiedFurniture.get(i).isMovable()) continue;
                bl = null;
                break;
            }
            this.setMovable(bl);
            Boolean bl2 = catalogPieceOfFurniture.isResizable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl2.booleanValue() == this.modifiedFurniture.get(i).isResizable()) continue;
                bl2 = null;
                break;
            }
            this.setResizable(bl2);
            Boolean bl3 = catalogPieceOfFurniture.isDeformable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl3.booleanValue() == this.modifiedFurniture.get(i).isDeformable()) continue;
                bl3 = null;
                break;
            }
            this.setDeformable(bl3);
            Boolean bl4 = catalogPieceOfFurniture.isTexturable();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl4.booleanValue() == this.modifiedFurniture.get(i).isTexturable()) continue;
                bl4 = null;
                break;
            }
            this.setTexturable(bl4);
            Boolean bl5 = catalogPieceOfFurniture.isDoorOrWindow();
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl5.booleanValue() == this.modifiedFurniture.get(i).isDoorOrWindow()) continue;
                bl5 = null;
                break;
            }
            this.setDoorOrWindow(bl5);
            String string6 = string = catalogPieceOfFurniture instanceof CatalogDoorOrWindow ? ((CatalogDoorOrWindow)catalogPieceOfFurniture).getCutOutShape() : null;
            if (string != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture5 = this.modifiedFurniture.get(i);
                    if (catalogPieceOfFurniture5 instanceof CatalogDoorOrWindow && string.equals(((CatalogDoorOrWindow)catalogPieceOfFurniture5).getCutOutShape())) continue;
                    string = null;
                    break;
                }
            }
            this.setDoorOrWindowCutOutShape(string);
            Boolean bl6 = catalogPieceOfFurniture.getStaircaseCutOutShape() != null;
            for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                if (bl6 == (this.modifiedFurniture.get(i).getStaircaseCutOutShape() != null)) continue;
                bl6 = null;
                break;
            }
            this.setStaircase(bl6);
            if (Boolean.TRUE.equals(bl6)) {
                String string7 = catalogPieceOfFurniture.getStaircaseCutOutShape();
                for (n = 1; n < this.modifiedFurniture.size(); ++n) {
                    comparable = this.modifiedFurniture.get(n);
                    if ((string7 != null || ((CatalogPieceOfFurniture)comparable).getStaircaseCutOutShape() == null) && (string7 == null || string7.equals(((CatalogPieceOfFurniture)comparable).getStaircaseCutOutShape()))) continue;
                    string7 = null;
                    break;
                }
                this.setStaircaseCutOutShape(string7);
            } else if (Boolean.FALSE.equals(bl6)) {
                this.setStaircaseCutOutShape(DEFAULT_CUT_OUT_SHAPE);
            } else {
                this.setStaircaseCutOutShape(null);
            }
            float[][] fArray = catalogPieceOfFurniture.getModelRotation();
            if (fArray != null) {
                for (n = 1; n < this.modifiedFurniture.size(); ++n) {
                    if (Arrays.deepEquals((Object[])fArray, (Object[])this.modifiedFurniture.get(n).getModelRotation())) continue;
                    fArray = null;
                    break;
                }
            }
            this.setModelRotation(fArray);
            String string8 = catalogPieceOfFurniture.getCreator();
            if (string8 != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (string8.equals(this.modifiedFurniture.get(i).getCreator())) continue;
                    string8 = null;
                    break;
                }
            }
            this.setCreator(string8);
            comparable = catalogPieceOfFurniture.getPrice();
            if (comparable != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (((BigDecimal)comparable).equals(this.modifiedFurniture.get(i).getPrice())) continue;
                    comparable = null;
                    break;
                }
            }
            this.setPrice((BigDecimal)comparable);
            BigDecimal bigDecimal = catalogPieceOfFurniture.getValueAddedTaxPercentage();
            if (bigDecimal != null) {
                for (int i = 1; i < this.modifiedFurniture.size(); ++i) {
                    if (bigDecimal.equals(this.modifiedFurniture.get(i).getValueAddedTaxPercentage())) continue;
                    bigDecimal = null;
                    break;
                }
            }
            this.setValueAddedTaxPercentage(bigDecimal);
            if (this.editableProperties.contains((Object)Property.WIDTH) && this.editableProperties.contains((Object)Property.DEPTH) && this.editableProperties.contains((Object)Property.HEIGHT) && this.getWidth() != null && this.getDepth() != null && this.getHeight() != null) {
                this.editableProperties.add(Property.PROPORTIONAL);
            }
        }
    }

    public void setId(String string) {
        if (string != this.id) {
            String string2 = this.id;
            this.id = string;
            this.propertyChangeSupport.firePropertyChange(Property.ID.name(), string2, string);
        }
    }

    public String getId() {
        return this.id;
    }

    public void setName(String string) {
        if (string != this.name) {
            String string2 = this.name;
            this.name = string;
            this.propertyChangeSupport.firePropertyChange(Property.NAME.name(), string2, string);
        }
    }

    public String getName() {
        return this.name;
    }

    public void setDescription(String string) {
        if (string != this.description) {
            String string2 = this.description;
            this.description = string;
            this.propertyChangeSupport.firePropertyChange(Property.DESCRIPTION.name(), string2, string);
        }
    }

    public String getDescription() {
        return this.description;
    }

    public void setInformation(String string) {
        if (string != this.information) {
            String string2 = this.information;
            this.information = string;
            this.propertyChangeSupport.firePropertyChange(Property.INFORMATION.name(), string2, string);
        }
    }

    public String getInformation() {
        return this.information;
    }

    public void setTags(String[] stringArray) {
        if (stringArray != this.tags) {
            String[] stringArray2 = this.tags;
            this.tags = stringArray;
            this.propertyChangeSupport.firePropertyChange(Property.TAGS.name(), stringArray2, stringArray);
        }
    }

    public String[] getTags() {
        return this.tags;
    }

    public void setCreationDate(Long l) {
        if (l != this.creationDate) {
            Long l2 = this.creationDate;
            this.creationDate = l;
            this.propertyChangeSupport.firePropertyChange(Property.INFORMATION.name(), l2, l);
        }
    }

    public Long getCreationDate() {
        return this.creationDate;
    }

    public void setGrade(Float f) {
        if (f != this.grade) {
            Float f2 = this.grade;
            this.grade = f;
            this.propertyChangeSupport.firePropertyChange(Property.GRADE.name(), f2, f);
        }
    }

    public Float getGrade() {
        return this.grade;
    }

    public void setCategory(FurnitureCategory furnitureCategory) {
        if (furnitureCategory != this.category) {
            FurnitureCategory furnitureCategory2 = this.category;
            this.category = furnitureCategory;
            this.propertyChangeSupport.firePropertyChange(Property.CATEGORY.name(), furnitureCategory2, furnitureCategory);
        }
    }

    public FurnitureCategory getCategory() {
        return this.category;
    }

    public List<FurnitureCategory> getAvailableCategories() {
        String string = this.furnitureLanguageController.getFurnitureLangauge();
        TreeSet<FurnitureCategory> treeSet = new TreeSet<FurnitureCategory>(this.getDefaultCategories(string));
        for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.furnitureLibrary.getFurniture()) {
            String string2 = (String)this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string, "CATEGORY", catalogPieceOfFurniture.getCategory().getName());
            treeSet.add(new FurnitureCategory(string2));
        }
        return new ArrayList<FurnitureCategory>(treeSet);
    }

    public List<FurnitureCategory> getDefaultCategories(String string) {
        int n = string.indexOf(95);
        Locale locale = n != -1 ? new Locale(string.substring(0, n), string.substring(n + 1)) : new Locale(string.length() == 0 ? this.preferences.getFurnitureDefaultLanguage() : string);
        ResourceBundle resourceBundle = ResourceBundle.getBundle("com.eteks.furniturelibraryeditor.viewcontroller.DefaultCategories", locale);
        ArrayList<FurnitureCategory> arrayList = new ArrayList<FurnitureCategory>();
        int n2 = 1;
        try {
            while (true) {
                arrayList.add(new FurnitureCategory(resourceBundle.getString("defaultFurnitureCategory#" + n2++)));
            }
        }
        catch (MissingResourceException missingResourceException) {
            return arrayList;
        }
    }

    public void setIcon(Content content) {
        if (content != this.icon) {
            Content content2 = this.icon;
            this.icon = content;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), content2, content);
        }
    }

    public Content getIcon() {
        return this.icon;
    }

    public void setModel(Content content) {
        if (content != this.model) {
            Content content2 = this.model;
            this.model = content;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL.name(), content2, content);
        }
    }

    public Content getModel() {
        return this.model;
    }

    private void setModelSize(Long l) {
        if (l != this.modelSize) {
            Long l2 = this.modelSize;
            this.modelSize = l;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_SIZE.name(), l2, l);
        }
    }

    public Long getModelSize() {
        return this.modelSize;
    }

    public void setModel(String string) {
        final FurnitureLibrary furnitureLibrary = new FurnitureLibrary();
        Runnable runnable = new Runnable(){

            public void run() {
                List<CatalogPieceOfFurniture> list = furnitureLibrary.getFurniture();
                if (!list.isEmpty()) {
                    CatalogPieceOfFurniture catalogPieceOfFurniture = list.get(0);
                    FurnitureController.this.setModel(catalogPieceOfFurniture.getModel());
                    FurnitureController.this.setModelRotation(catalogPieceOfFurniture.getModelRotation());
                    FurnitureController.this.setModelSize(catalogPieceOfFurniture.getModelSize());
                    boolean bl = FurnitureController.this.isProportional();
                    FurnitureController.this.setProportional(false);
                    FurnitureController.this.setWidth(Float.valueOf(catalogPieceOfFurniture.getWidth()));
                    FurnitureController.this.setDepth(Float.valueOf(catalogPieceOfFurniture.getDepth()));
                    FurnitureController.this.setHeight(Float.valueOf(catalogPieceOfFurniture.getHeight()));
                    FurnitureController.this.setProportional(bl);
                }
            }
        };
        new ImportFurnitureController(furnitureLibrary, new String[]{string}, runnable, this.preferences, this.viewFactory, this.contentManager).executeTask(this.getView());
    }

    public void setWidth(Float f) {
        this.setWidth(f, false);
    }

    private void setWidth(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalWidth = f;
        }
        if (f2 == null && this.width != null || f2 != null && !f2.equals(this.width)) {
            Float f4 = this.width;
            this.width = f2;
            this.propertyChangeSupport.firePropertyChange(Property.WIDTH.name(), f4, f2);
        }
    }

    public Float getWidth() {
        return this.width;
    }

    public void setDepth(Float f) {
        this.setDepth(f, false);
    }

    private void setDepth(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalDepth = f;
        }
        if (f2 == null && this.depth != null || f2 != null && !f2.equals(this.depth)) {
            Float f4 = this.depth;
            this.depth = f2;
            this.propertyChangeSupport.firePropertyChange(Property.DEPTH.name(), f4, f2);
        }
    }

    public Float getDepth() {
        return this.depth;
    }

    public void setHeight(Float f) {
        this.setHeight(f, false);
    }

    private void setHeight(Float f, boolean bl) {
        Float f2;
        Float f3 = f2 = f != null ? Float.valueOf(Math.max(f.floatValue(), 0.001f)) : null;
        if (f2 == f || f2 != null && f2.equals(f) || !bl) {
            this.proportionalHeight = f;
        }
        if (f2 == null && this.height != null || f2 != null && !f2.equals(this.height)) {
            Float f4 = this.height;
            this.height = f2;
            this.propertyChangeSupport.firePropertyChange(Property.HEIGHT.name(), f4, f2);
        }
    }

    public Float getHeight() {
        return this.height;
    }

    public boolean isProportional() {
        return this.proportional;
    }

    public void setProportional(boolean bl) {
        if (bl != this.proportional) {
            this.proportional = bl;
            this.propertyChangeSupport.firePropertyChange(Property.PROPORTIONAL.name(), !bl, bl);
        }
    }

    public void multiplySize(float f) {
        if (this.isProportional()) {
            this.setWidth(Float.valueOf(this.getWidth().floatValue() * f));
        } else {
            this.setProportional(true);
            this.setWidth(Float.valueOf(this.getWidth().floatValue() * f));
            this.setProportional(false);
        }
    }

    public void setElevation(Float f) {
        if (f != this.elevation) {
            Float f2 = this.elevation;
            this.elevation = f;
            this.propertyChangeSupport.firePropertyChange(Property.ELEVATION.name(), f2, f);
        }
    }

    public Float getElevation() {
        return this.elevation;
    }

    public void setMovable(Boolean bl) {
        if (bl != this.movable) {
            Boolean bl2 = this.movable;
            this.movable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.MOVABLE.name(), bl2, bl);
        }
    }

    public Boolean getMovable() {
        return this.movable;
    }

    public void setDoorOrWindow(Boolean bl) {
        if (bl != this.doorOrWindow) {
            Boolean bl2 = this.doorOrWindow;
            this.doorOrWindow = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DOOR_OR_WINDOW.name(), bl2, bl);
        }
    }

    public Boolean getDoorOrWindow() {
        return this.doorOrWindow;
    }

    public void setDoorOrWindowCutOutShape(String string) {
        if (string != this.doorOrWindowCutOutShape || string != null && !string.equals(this.doorOrWindowCutOutShape)) {
            String string2 = this.doorOrWindowCutOutShape;
            this.doorOrWindowCutOutShape = string;
            this.propertyChangeSupport.firePropertyChange(Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE.name(), string2, string);
        }
    }

    public String getDoorOrWindowCutOutShape() {
        return this.doorOrWindowCutOutShape;
    }

    public void setStaircase(Boolean bl) {
        if (bl != this.staircase) {
            Boolean bl2 = this.staircase;
            this.staircase = bl;
            this.propertyChangeSupport.firePropertyChange(Property.STAIRCASE.name(), bl2, bl);
        }
    }

    public Boolean getStaircase() {
        return this.staircase;
    }

    public void setStaircaseCutOutShape(String string) {
        if (string != this.staircaseCutOutShape || string != null && !string.equals(this.staircaseCutOutShape)) {
            String string2 = this.staircaseCutOutShape;
            this.staircaseCutOutShape = string;
            this.propertyChangeSupport.firePropertyChange(Property.STAIRCASE_CUT_OUT_SHAPE.name(), string2, string);
        }
    }

    public String getStaircaseCutOutShape() {
        return this.staircaseCutOutShape;
    }

    public void setBackFaceShown(Boolean bl) {
        if (bl != this.backFaceShown) {
            Boolean bl2 = this.backFaceShown;
            this.backFaceShown = bl;
            this.propertyChangeSupport.firePropertyChange(Property.BACK_FACE_SHOWN.name(), bl2, bl);
        }
    }

    public Boolean getBackFaceShown() {
        return this.backFaceShown;
    }

    public void setResizable(Boolean bl) {
        if (bl != this.resizable) {
            Boolean bl2 = this.resizable;
            this.resizable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.RESIZABLE.name(), bl2, bl);
        }
    }

    public Boolean getResizable() {
        return this.resizable;
    }

    public void setDeformable(Boolean bl) {
        if (bl != this.deformable) {
            Boolean bl2 = this.deformable;
            this.deformable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.DEFORMABLE.name(), bl2, bl);
        }
    }

    public Boolean getDeformable() {
        return this.deformable;
    }

    public void setTexturable(Boolean bl) {
        if (bl != this.texturable) {
            Boolean bl2 = this.texturable;
            this.texturable = bl;
            this.propertyChangeSupport.firePropertyChange(Property.TEXTURABLE.name(), bl2, bl);
        }
    }

    public Boolean getTexturable() {
        return this.texturable;
    }

    public void setModelRotation(float[][] fArray) {
        if (fArray != this.modelRotation) {
            float[][] fArray2 = this.modelRotation;
            this.modelRotation = fArray;
            this.propertyChangeSupport.firePropertyChange(Property.MODEL_ROTATION.name(), fArray2, fArray);
        }
    }

    public float[][] getModelRotation() {
        return this.modelRotation;
    }

    public void setCreator(String string) {
        if (string != this.creator) {
            String string2 = this.creator;
            this.creator = string;
            this.propertyChangeSupport.firePropertyChange(Property.CREATOR.name(), string2, string);
        }
    }

    public String getCreator() {
        return this.creator;
    }

    public void setPrice(BigDecimal bigDecimal) {
        if (bigDecimal != this.price) {
            BigDecimal bigDecimal2 = this.price;
            this.price = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.ICON.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getPrice() {
        return this.price;
    }

    public void setValueAddedTaxPercentage(BigDecimal bigDecimal) {
        if (bigDecimal != this.valueAddedTaxPercentage) {
            BigDecimal bigDecimal2 = this.valueAddedTaxPercentage;
            this.valueAddedTaxPercentage = bigDecimal;
            this.propertyChangeSupport.firePropertyChange(Property.VALUE_ADDED_TAX_PERCENTAGE.name(), bigDecimal2, bigDecimal);
        }
    }

    public BigDecimal getValueAddedTaxPercentage() {
        return this.valueAddedTaxPercentage;
    }

    public void modifyFurniture() {
        if (!this.modifiedFurniture.isEmpty()) {
            String string = this.getId();
            String string2 = this.getName();
            String string3 = this.getDescription();
            String string4 = this.getInformation();
            String[] stringArray = this.getTags();
            Long l = this.getCreationDate();
            Float f = this.getGrade();
            FurnitureCategory furnitureCategory = this.getCategory();
            Content content = this.getModel();
            Content content2 = this.getIcon();
            Float f2 = this.getWidth();
            Float f3 = this.getDepth();
            Float f4 = this.getHeight();
            Float f5 = this.getElevation();
            Boolean bl = this.getMovable();
            Boolean bl2 = this.getResizable();
            Boolean bl3 = this.getDeformable();
            Boolean bl4 = this.getTexturable();
            Boolean bl5 = this.getDoorOrWindow();
            String string5 = this.getDoorOrWindowCutOutShape();
            Boolean bl6 = this.getStaircase();
            String string6 = this.getStaircaseCutOutShape();
            float[][] fArray = this.getModelRotation();
            Long l2 = this.getModelSize();
            String string7 = this.getCreator();
            BigDecimal bigDecimal = this.getPrice();
            BigDecimal bigDecimal2 = this.getValueAddedTaxPercentage();
            boolean bl7 = "".equals(this.furnitureLanguageController.getFurnitureLangauge());
            int n = this.modifiedFurniture.size();
            for (CatalogPieceOfFurniture catalogPieceOfFurniture : this.modifiedFurniture) {
                CatalogPieceOfFurniture catalogPieceOfFurniture2;
                Cloneable cloneable;
                Map<String, String> map;
                int n2 = this.furnitureLibrary.getPieceOfFurnitureIndex(catalogPieceOfFurniture);
                String string8 = catalogPieceOfFurniture.getId();
                String string9 = catalogPieceOfFurniture.getName();
                String string10 = catalogPieceOfFurniture.getDescription();
                String string11 = catalogPieceOfFurniture.getInformation();
                String[] stringArray2 = catalogPieceOfFurniture.getTags();
                Long l3 = catalogPieceOfFurniture.getCreationDate();
                Float f6 = catalogPieceOfFurniture.getGrade();
                FurnitureCategory furnitureCategory2 = catalogPieceOfFurniture.getCategory();
                Content content3 = catalogPieceOfFurniture.getModel();
                Content content4 = catalogPieceOfFurniture.getIcon();
                Content content5 = catalogPieceOfFurniture.getPlanIcon();
                float f7 = catalogPieceOfFurniture.getWidth();
                float f8 = catalogPieceOfFurniture.getDepth();
                float f9 = catalogPieceOfFurniture.getHeight();
                float f10 = catalogPieceOfFurniture.getDropOnTopElevation();
                float f11 = catalogPieceOfFurniture.getElevation();
                boolean bl8 = catalogPieceOfFurniture.isMovable();
                float[][] fArray2 = catalogPieceOfFurniture.getModelRotation();
                String string12 = catalogPieceOfFurniture instanceof CatalogDoorOrWindow ? ((CatalogDoorOrWindow)catalogPieceOfFurniture).getCutOutShape() : null;
                String string13 = catalogPieceOfFurniture.getStaircaseCutOutShape();
                boolean bl9 = catalogPieceOfFurniture.isBackFaceShown();
                Long l4 = catalogPieceOfFurniture.getModelSize();
                String string14 = catalogPieceOfFurniture.getCreator();
                boolean bl10 = catalogPieceOfFurniture.isResizable();
                boolean bl11 = catalogPieceOfFurniture.isDeformable();
                boolean bl12 = catalogPieceOfFurniture.isTexturable();
                BigDecimal bigDecimal3 = catalogPieceOfFurniture.getPrice();
                BigDecimal bigDecimal4 = catalogPieceOfFurniture.getValueAddedTaxPercentage();
                String string15 = catalogPieceOfFurniture.getCurrency();
                Collection<String> collection = catalogPieceOfFurniture.getPropertyNames();
                if (collection.isEmpty()) {
                    map = Collections.emptyMap();
                } else {
                    map = new HashMap(collection.size());
                    for (String string16 : collection) {
                        map.put(string16, catalogPieceOfFurniture.getProperty(string16));
                    }
                }
                HashMap hashMap = new HashMap();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap, "NAME");
                HashMap<String, Object> object2 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, object2, "DESCRIPTION");
                HashMap<String, Object> hashMap2 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap2, "INFORMATION");
                HashMap<String, Object> hashMap3 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap3, "TAGS");
                HashMap<String, Object> hashMap4 = new HashMap<String, Object>();
                this.retrieveLocalizedData(catalogPieceOfFurniture, hashMap4, "CATEGORY");
                if (content != null) {
                    content3 = content;
                }
                if (content2 != null) {
                    content4 = content2;
                }
                if (f2 != null) {
                    f7 = f2.floatValue();
                }
                if (f3 != null) {
                    f8 = f3.floatValue();
                }
                if (f4 != null) {
                    f9 = f4.floatValue();
                }
                if (bl != null) {
                    bl8 = bl;
                }
                if (string != null || n == 1) {
                    string8 = string;
                }
                if (l != null || n == 1) {
                    l3 = l;
                }
                if (f != null || n == 1) {
                    f6 = f;
                }
                if (f5 != null || n == 1) {
                    f11 = f5.floatValue();
                }
                if (fArray != null || n == 1) {
                    fArray2 = fArray;
                }
                if (string12 != null || n == 1) {
                    string12 = string5;
                }
                if (bl6 != null) {
                    if (bl6.booleanValue()) {
                        if (string6 != null) {
                            string13 = string6;
                        } else if (n == 1) {
                            string13 = DEFAULT_CUT_OUT_SHAPE;
                        }
                    } else {
                        string13 = null;
                    }
                } else if (string6 != null && string13 != null) {
                    string13 = string6;
                }
                if (l2 != null || n == 1) {
                    l4 = l2;
                }
                if (string7 != null || n == 1) {
                    string14 = string7;
                }
                if (bl2 != null || n == 1) {
                    bl10 = bl2;
                }
                if (bl3 != null || n == 1) {
                    bl11 = bl3;
                }
                if (bl4 != null || n == 1) {
                    bl12 = bl4;
                }
                if (bigDecimal != null || n == 1) {
                    bigDecimal3 = bigDecimal;
                }
                if (bigDecimal2 != null || n == 1) {
                    bigDecimal4 = bigDecimal2;
                }
                if (string2 != null) {
                    if (bl7) {
                        string9 = string2;
                    } else {
                        hashMap.put(this.furnitureLanguageController.getFurnitureLangauge(), string2);
                    }
                }
                if (furnitureCategory != null) {
                    if (bl7) {
                        furnitureCategory2 = furnitureCategory;
                    } else {
                        hashMap4.put(this.furnitureLanguageController.getFurnitureLangauge(), furnitureCategory.getName());
                    }
                }
                if (string3 != null || n == 1) {
                    if (bl7) {
                        string10 = string3;
                    } else {
                        object2.put(this.furnitureLanguageController.getFurnitureLangauge(), string3);
                    }
                }
                if (string4 != null || n == 1) {
                    if (bl7) {
                        string11 = string4;
                    } else {
                        hashMap2.put(this.furnitureLanguageController.getFurnitureLangauge(), string4);
                    }
                }
                if (stringArray != null || n == 1) {
                    if (bl7) {
                        stringArray2 = stringArray == null ? new String[]{} : stringArray;
                    } else {
                        hashMap3.put(this.furnitureLanguageController.getFurnitureLangauge(), stringArray);
                    }
                }
                if (catalogPieceOfFurniture instanceof CatalogDoorOrWindow && (bl5 == null || bl5.booleanValue())) {
                    cloneable = (CatalogDoorOrWindow)catalogPieceOfFurniture;
                    catalogPieceOfFurniture2 = new CatalogDoorOrWindow(string8, string9, string10, string11, stringArray2, l3, f6, content4, content5, content3, f7, f8, f9, f11, f10, bl8, string12, ((CatalogDoorOrWindow)cloneable).getWallThickness(), ((CatalogDoorOrWindow)cloneable).getWallDistance(), ((CatalogDoorOrWindow)cloneable).isWallCutOutOnBothSides(), ((CatalogDoorOrWindow)cloneable).isWidthDepthDeformable(), ((CatalogDoorOrWindow)cloneable).getSashes(), fArray2, bl9, l4, string14, bl10, bl11, bl12, bigDecimal3, bigDecimal4, string15, map);
                } else if (catalogPieceOfFurniture instanceof CatalogLight) {
                    cloneable = (CatalogLight)catalogPieceOfFurniture;
                    catalogPieceOfFurniture2 = new CatalogLight(string8, string9, string10, string11, stringArray2, l3, f6, content4, content5, content3, f7, f8, f9, f11, f10, bl8, ((CatalogLight)cloneable).getLightSources(), string13, fArray2, bl9, l4, string14, bl10, bl11, bl12, catalogPieceOfFurniture.isHorizontallyRotatable(), bigDecimal3, bigDecimal4, string15, map);
                } else {
                    catalogPieceOfFurniture2 = bl5 != null && bl5 != false ? new CatalogDoorOrWindow(string8, string9, string10, string11, stringArray2, l3, f6, content4, content5, content3, f7, f8, f9, f11, f10, bl8, string12, 1.0f, 0.0f, true, true, new Sash[0], fArray2, bl9, l4, string14, bl10, bl11, bl12, bigDecimal3, bigDecimal4, string15, map) : new CatalogPieceOfFurniture(string8, string9, string10, string11, stringArray2, l3, f6, content4, content5, content3, f7, f8, f9, f11, f10, bl8, string13, fArray2, bl9, l4, string14, bl10, bl11, bl12, catalogPieceOfFurniture.isHorizontallyRotatable(), bigDecimal3, bigDecimal4, string15, map);
                }
                new FurnitureCatalog().add(furnitureCategory2, catalogPieceOfFurniture2);
                this.furnitureLibrary.addPieceOfFurniture(catalogPieceOfFurniture2, n2);
                cloneable = new HashSet<String>(this.furnitureLibrary.getSupportedLanguages());
                cloneable.add(this.furnitureLanguageController.getFurnitureLangauge());
                Iterator iterator = cloneable.iterator();
                while (iterator.hasNext()) {
                    Object v;
                    Object v2;
                    Object v3;
                    Object v4;
                    String string17 = (String)iterator.next();
                    if ("".equals(string17)) continue;
                    Object v5 = hashMap.get(string17);
                    if (v5 != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string17, "NAME", v5);
                    }
                    if ((v4 = object2.get(string17)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string17, "DESCRIPTION", v4);
                    }
                    if ((v3 = hashMap2.get(string17)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string17, "INFORMATION", v3);
                    }
                    if ((v2 = hashMap3.get(string17)) != null) {
                        this.furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string17, "TAGS", v2);
                    }
                    if ((v = hashMap4.get(string17)) == null) continue;
                    this.furnitureLibrary.setPieceOfFurnitureLocalizedData(catalogPieceOfFurniture2, string17, "CATEGORY", v);
                }
                this.furnitureLibrary.deletePieceOfFurniture(catalogPieceOfFurniture);
            }
        }
    }

    private void retrieveLocalizedData(CatalogPieceOfFurniture catalogPieceOfFurniture, Map<String, Object> map, String string) {
        for (String string2 : this.furnitureLibrary.getSupportedLanguages()) {
            Object object = this.furnitureLibrary.getPieceOfFurnitureLocalizedData(catalogPieceOfFurniture, string2, string);
            if (object == null) continue;
            map.put(string2, object);
        }
    }

    static {
        PROPERTIES_MAP.put("ID", Property.ID);
        PROPERTIES_MAP.put("NAME", Property.NAME);
        PROPERTIES_MAP.put("DESCRIPTION", Property.DESCRIPTION);
        PROPERTIES_MAP.put("INFORMATION", Property.INFORMATION);
        PROPERTIES_MAP.put("TAGS", Property.TAGS);
        PROPERTIES_MAP.put("GRADE", Property.GRADE);
        PROPERTIES_MAP.put("CREATION_DATE", Property.CREATION_DATE);
        PROPERTIES_MAP.put("CATEGORY", Property.CATEGORY);
        PROPERTIES_MAP.put("CREATOR", Property.CREATOR);
        PROPERTIES_MAP.put("MODEL", Property.MODEL);
        PROPERTIES_MAP.put("ICON", Property.ICON);
        PROPERTIES_MAP.put("WIDTH", Property.WIDTH);
        PROPERTIES_MAP.put("DEPTH", Property.DEPTH);
        PROPERTIES_MAP.put("HEIGHT", Property.HEIGHT);
        PROPERTIES_MAP.put("ELEVATION", Property.ELEVATION);
        PROPERTIES_MAP.put("MOVABLE", Property.MOVABLE);
        PROPERTIES_MAP.put("DEFORMABLE", Property.DEFORMABLE);
        PROPERTIES_MAP.put("RESIZABLE", Property.RESIZABLE);
        PROPERTIES_MAP.put("TEXTURABLE", Property.TEXTURABLE);
        PROPERTIES_MAP.put("DOOR_OR_WINDOW", Property.DOOR_OR_WINDOW);
        PROPERTIES_MAP.put("DOOR_OR_WINDOW_CUT_OUT_SHAPE", Property.DOOR_OR_WINDOW_CUT_OUT_SHAPE);
        PROPERTIES_MAP.put("STAIRCASE_CUT_OUT_SHAPE", Property.STAIRCASE_CUT_OUT_SHAPE);
        PROPERTIES_MAP.put("MODEL_ROTATION", Property.MODEL_ROTATION);
        PROPERTIES_MAP.put("PRICE", Property.PRICE);
        PROPERTIES_MAP.put("VALUE_ADDED_TAX_PERCENTAGE", Property.VALUE_ADDED_TAX_PERCENTAGE);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Property {
        ID,
        NAME,
        DESCRIPTION,
        INFORMATION,
        TAGS,
        GRADE,
        CREATION_DATE,
        CATEGORY,
        MODEL,
        ICON,
        WIDTH,
        DEPTH,
        HEIGHT,
        ELEVATION,
        MOVABLE,
        RESIZABLE,
        DEFORMABLE,
        TEXTURABLE,
        DOOR_OR_WINDOW,
        DOOR_OR_WINDOW_CUT_OUT_SHAPE,
        STAIRCASE,
        STAIRCASE_CUT_OUT_SHAPE,
        MODEL_ROTATION,
        MODEL_SIZE,
        CREATOR,
        PROPORTIONAL,
        BACK_FACE_SHOWN,
        PRICE,
        VALUE_ADDED_TAX_PERCENTAGE;

    }
}

