/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput;

import com.google.common.collect.ImmutableMap;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jdt.annotation.Nullable;
import org.eclipse.tracecompass.analysis.os.linux.core.trace.IKernelAnalysisEventLayout;
import org.eclipse.tracecompass.common.core.NonNullUtils;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.Activator;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.DiskWriteModel;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.BlockFrontMergeHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.BlockRqComplete;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.BlockRqInsertHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.BlockRqIssueHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.MergeRequestsHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.StateDumpHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.SysEntryHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.inputoutput.handlers.SysExitHandler;
import org.eclipse.tracecompass.internal.analysis.os.linux.core.kernel.handlers.KernelEventHandler;
import org.eclipse.tracecompass.statesystem.core.ITmfStateSystemBuilder;
import org.eclipse.tracecompass.statesystem.core.exceptions.AttributeNotFoundException;
import org.eclipse.tracecompass.statesystem.core.exceptions.StateValueTypeException;
import org.eclipse.tracecompass.statesystem.core.exceptions.TimeRangeException;
import org.eclipse.tracecompass.tmf.core.event.ITmfEvent;
import org.eclipse.tracecompass.tmf.core.statesystem.AbstractTmfStateProvider;
import org.eclipse.tracecompass.tmf.core.trace.ITmfTrace;

public class InputOutputStateProvider
extends AbstractTmfStateProvider {
    private static final int VERSION = 1;
    private final Map<Integer, DiskWriteModel> fDisks = new HashMap<Integer, DiskWriteModel>();
    private final Map<String, KernelEventHandler> fEventNames;
    private final IKernelAnalysisEventLayout fLayout;
    private final KernelEventHandler fSysEntryHandler;
    private final KernelEventHandler fSysExitHandler;

    public InputOutputStateProvider(ITmfTrace trace, IKernelAnalysisEventLayout layout) {
        super(trace, "Input Output Analysis");
        this.fLayout = layout;
        this.fEventNames = this.buildEventNames(layout);
        this.fSysEntryHandler = new SysEntryHandler(layout);
        this.fSysExitHandler = new SysExitHandler(layout);
    }

    private Map<String, KernelEventHandler> buildEventNames(IKernelAnalysisEventLayout layout) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)layout.eventBlockRqInsert(), (Object)new BlockRqInsertHandler(layout, this));
        builder.put((Object)layout.eventBlockRqIssue(), (Object)new BlockRqIssueHandler(layout, this));
        builder.put((Object)layout.eventBlockRqComplete(), (Object)new BlockRqComplete(layout, this));
        builder.put((Object)layout.eventBlockBioFrontmerge(), (Object)new BlockFrontMergeHandler(layout, this));
        builder.put((Object)layout.eventBlockRqMerge(), (Object)new MergeRequestsHandler(layout, this));
        String eventStatedumpBlockDevice = layout.eventStatedumpBlockDevice();
        if (eventStatedumpBlockDevice != null) {
            builder.put((Object)eventStatedumpBlockDevice, (Object)new StateDumpHandler(layout, this));
        }
        return builder.build();
    }

    public int getVersion() {
        return 1;
    }

    public InputOutputStateProvider getNewInstance() {
        return new InputOutputStateProvider(this.getTrace(), this.fLayout);
    }

    protected void eventHandle(@Nullable ITmfEvent event) {
        if (event == null) {
            return;
        }
        String eventName = event.getName();
        try {
            ITmfStateSystemBuilder ss = (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder());
            KernelEventHandler handler = this.fEventNames.get(eventName);
            if (handler == null) {
                if (this.isSyscallExit(eventName)) {
                    handler = this.fSysExitHandler;
                } else if (this.isSyscallEntry(eventName)) {
                    handler = this.fSysEntryHandler;
                }
            }
            if (handler != null) {
                handler.handleEvent(ss, event);
            }
        }
        catch (AttributeNotFoundException | StateValueTypeException | TimeRangeException e) {
            Activator.getDefault().logError("Exception while building the IO state system", e);
        }
    }

    public DiskWriteModel getDisk(int deviceId) {
        DiskWriteModel disk = this.fDisks.get(deviceId);
        if (disk == null) {
            disk = new DiskWriteModel(deviceId, (ITmfStateSystemBuilder)NonNullUtils.checkNotNull((Object)this.getStateSystemBuilder()));
            this.fDisks.put(deviceId, disk);
        }
        return disk;
    }

    private boolean isSyscallEntry(String eventName) {
        return eventName.startsWith(this.fLayout.eventSyscallEntryPrefix()) || eventName.startsWith(this.fLayout.eventCompatSyscallEntryPrefix());
    }

    private boolean isSyscallExit(String eventName) {
        return eventName.startsWith(this.fLayout.eventSyscallExitPrefix()) || eventName.startsWith(this.fLayout.eventCompatSyscallExitPrefix());
    }

    public static int getNodeThreads(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"Threads"});
    }

    public static int getNodeSyscalls(ITmfStateSystemBuilder ssb) {
        return ssb.getQuarkAbsoluteAndAdd(new String[]{"system_calls"});
    }
}

