/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.buildship.core.internal.configuration;

import com.google.common.base.Objects;
import java.io.File;
import java.util.Collections;
import org.eclipse.buildship.core.GradleDistribution;
import org.eclipse.buildship.core.internal.configuration.BuildConfiguration;
import org.eclipse.buildship.core.internal.configuration.DefaultBuildConfigurationProperties;
import org.eclipse.buildship.core.internal.configuration.GradleArguments;
import org.eclipse.buildship.core.internal.configuration.WorkspaceConfiguration;

public final class DefaultBuildConfiguration
implements BuildConfiguration {
    private final DefaultBuildConfigurationProperties properties;
    private final WorkspaceConfiguration workspaceConfiguration;

    public DefaultBuildConfiguration(DefaultBuildConfigurationProperties persistentProperties, WorkspaceConfiguration workspaceConfiguration) {
        this.properties = persistentProperties;
        this.workspaceConfiguration = workspaceConfiguration;
    }

    @Override
    public WorkspaceConfiguration getWorkspaceConfiguration() {
        return this.workspaceConfiguration;
    }

    @Override
    public File getRootProjectDirectory() {
        return this.properties.getRootProjectDirectory();
    }

    @Override
    public boolean isOverrideWorkspaceSettings() {
        return this.properties.isOverrideWorkspaceSettings();
    }

    @Override
    public File getGradleUserHome() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.getGradleUserHome();
        }
        return this.workspaceConfiguration.getGradleUserHome();
    }

    @Override
    public GradleDistribution getGradleDistribution() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.getGradleDistribution();
        }
        return this.workspaceConfiguration.getGradleDistribution();
    }

    @Override
    public boolean isBuildScansEnabled() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.isBuildScansEnabled();
        }
        return this.workspaceConfiguration.isBuildScansEnabled();
    }

    @Override
    public boolean isOfflineMode() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.isOfflineMode();
        }
        return this.workspaceConfiguration.isOffline();
    }

    public boolean equals(Object obj) {
        if (obj instanceof DefaultBuildConfiguration) {
            DefaultBuildConfiguration other = (DefaultBuildConfiguration)obj;
            return Objects.equal((Object)this.properties, (Object)other.properties) && Objects.equal((Object)this.workspaceConfiguration, (Object)other.workspaceConfiguration);
        }
        return false;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.properties, this.workspaceConfiguration});
    }

    public DefaultBuildConfigurationProperties getProperties() {
        return this.properties;
    }

    @Override
    public GradleArguments toGradleArguments() {
        return GradleArguments.from(this.getRootProjectDirectory(), this.getGradleDistribution(), this.getGradleUserHome(), null, this.isBuildScansEnabled(), this.isOfflineMode(), Collections.emptyList(), Collections.emptyList());
    }

    @Override
    public boolean isAutoSync() {
        if (this.properties.isOverrideWorkspaceSettings()) {
            return this.properties.isAutoSync();
        }
        return this.workspaceConfiguration.isAutoSync();
    }

    @Override
    public org.eclipse.buildship.core.BuildConfiguration toApiBuildConfiguration() {
        return org.eclipse.buildship.core.BuildConfiguration.forRootProjectDirectory(this.properties.getRootProjectDirectory()).overrideWorkspaceConfiguration(this.properties.isOverrideWorkspaceSettings()).gradleDistribution(this.properties.getGradleDistribution()).gradleUserHome(this.properties.getGradleUserHome()).buildScansEnabled(this.properties.isBuildScansEnabled()).offlineMode(this.properties.isOfflineMode()).autoSync(this.properties.isAutoSync()).build();
    }
}

