/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.correction;

import java.util.HashSet;
import java.util.regex.Pattern;
import org.eclipse.core.resources.IMarker;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.text.bundle.Bundle;
import org.eclipse.pde.internal.core.text.bundle.BundleModel;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageObject;
import org.eclipse.pde.internal.core.util.PatternConstructor;
import org.eclipse.pde.internal.ui.PDEPlugin;
import org.eclipse.pde.internal.ui.PDEUIMessages;
import org.eclipse.pde.internal.ui.correction.AbstractManifestMarkerResolution;

public class AddExportPackageMarkerResolution
extends AbstractManifestMarkerResolution {
    private String fValues;
    IMarker marker = null;

    public AddExportPackageMarkerResolution(IMarker mark, int type, String values) {
        super(type);
        this.fValues = values;
        this.marker = mark;
    }

    public String getLabel() {
        return PDEUIMessages.AddExportPackageResolution_Label;
    }

    @Override
    public void run(IMarker marker) {
        this.marker = marker;
        super.run(marker);
    }

    @Override
    protected void createChange(BundleModel model) {
        IBundle bundle = model.getBundle();
        if (bundle instanceof Bundle) {
            Bundle bun = (Bundle)bundle;
            ExportPackageHeader header = (ExportPackageHeader)bun.getManifestHeader("Export-Package");
            if (header == null) {
                bundle.setHeader("Export-Package", "");
                header = (ExportPackageHeader)bun.getManifestHeader("Export-Package");
            }
            this.processPackages(header);
        }
    }

    private void processPackages(ExportPackageHeader header) {
        this.fValues = this.marker.getAttribute("packages", null);
        if (this.fValues == null) {
            return;
        }
        String[] packages = this.fValues.split(",");
        String filter = PDEPlugin.getDefault().getDialogSettings().get("OrganizeManifests.ExportedPackages.packageFilter");
        if (filter == null) {
            filter = "*.internal*";
        }
        Pattern pat = PatternConstructor.createPattern((String)filter, (boolean)false);
        String[] stringArray = packages;
        int n = packages.length;
        int n2 = 0;
        while (n2 < n) {
            String packageId = stringArray[n2];
            ExportPackageObject obj = header.addPackage(packageId);
            if (pat.matcher(packageId).matches()) {
                obj.setInternal(true);
            }
            ++n2;
        }
    }

    @Override
    public IMarker[] findOtherMarkers(IMarker[] markers) {
        HashSet<IMarker> mset = new HashSet<IMarker>(markers.length);
        IMarker[] iMarkerArray = markers;
        int n = markers.length;
        int n2 = 0;
        while (n2 < n) {
            String str;
            IMarker iMarker = iMarkerArray[n2];
            if (!iMarker.equals((Object)this.marker) && (str = iMarker.getAttribute("compilerKey", "")).equals(this.marker.getAttribute("compilerKey", ""))) {
                mset.add(iMarker);
            }
            ++n2;
        }
        int size = mset.size();
        return mset.toArray(new IMarker[size]);
    }
}

