/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.json.core.internal.schema.catalog;

import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.InstanceScope;
import org.eclipse.wst.json.core.JSONCorePlugin;
import org.eclipse.wst.json.core.internal.schema.catalog.UserEntry;

public class EntryParser {
    public static final String JSON_CATALOG_ENTRIES = "catalogEntries";
    private static final JAXBContext jaxbContext;

    static {
        try {
            jaxbContext = JAXBContext.newInstance((Class[])new Class[]{EntriesWrapper.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
    }

    public Set<UserEntry> parse(String xml) throws CoreException {
        if (xml == null || xml.trim().isEmpty()) {
            return null;
        }
        try {
            EntriesWrapper list = (EntriesWrapper)this.unmarshall(jaxbContext, xml);
            return list.entries == null ? Collections.emptySet() : list.entries;
        }
        catch (Exception e) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.json.core", "Unable to parse entry", (Throwable)e));
        }
    }

    public String serialize(Set<UserEntry> entries) throws CoreException {
        try {
            EntriesWrapper list = new EntriesWrapper();
            list.entries = entries;
            Marshaller marshaller = jaxbContext.createMarshaller();
            marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
            StringWriter writer = new StringWriter();
            marshaller.marshal((Object)list, (Writer)writer);
            return writer.toString();
        }
        catch (Exception shouldntHappen) {
            throw new CoreException((IStatus)new Status(4, "org.eclipse.wst.json.core", "Unable to serialize entries ", (Throwable)shouldntHappen));
        }
    }

    public static Set<UserEntry> getUserEntries() {
        LinkedHashSet<UserEntry> entries = new LinkedHashSet<UserEntry>();
        IEclipsePreferences prefs = EntryParser.getPreferences();
        String xml = prefs.get(JSON_CATALOG_ENTRIES, null);
        if (xml != null && !xml.trim().isEmpty()) {
            try {
                Set<UserEntry> set = new EntryParser().parse(xml);
                if (set != null) {
                    entries.addAll(set);
                }
            }
            catch (CoreException e) {
                Status status = new Status(4, "org.eclipse.wst.json.core", e.getLocalizedMessage(), (Throwable)e);
                JSONCorePlugin.getDefault().getLog().log((IStatus)status);
            }
        }
        return entries;
    }

    private static IEclipsePreferences getPreferences() {
        IEclipsePreferences preferences = InstanceScope.INSTANCE.getNode("org.eclipse.wst.json.ui");
        return preferences;
    }

    protected Object unmarshall(JAXBContext jaxbContext, String xml) throws JAXBException, IOException, XMLStreamException {
        return this.unmarshall(jaxbContext, new StringReader(xml));
    }

    protected Object unmarshall(JAXBContext jaxbContext, File file) throws JAXBException, IOException, XMLStreamException {
        return this.unmarshall(jaxbContext, new FileReader(file));
    }

    protected Object unmarshall(JAXBContext jaxbContext, Reader reader) throws JAXBException, IOException, XMLStreamException {
        Unmarshaller jaxbUnmarshaller = jaxbContext.createUnmarshaller();
        XMLInputFactory xmlif = XMLInputFactory.newInstance();
        try (Reader r = null;){
            r = reader;
            XMLStreamReader xmler = xmlif.createXMLStreamReader(r);
            Object object = jaxbUnmarshaller.unmarshal(xmler);
            return object;
        }
    }

    @XmlRootElement(name="entries")
    @XmlAccessorType(value=XmlAccessType.FIELD)
    static class EntriesWrapper {
        @XmlElement(name="entry", type=UserEntry.class)
        Set<UserEntry> entries;

        EntriesWrapper() {
        }
    }
}

